/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware BIS Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             RxCEOC_com.c
 * DESCRIPTION:      common code (BIS/DMT) to write to Rx Clear EOC fifo
 *
 **********************************************************************/
#include "typedef.h"
#include "gdata.h"



static void BufferClearEOCMsg(uint8 uc_ClearEOCData)
{
   int16 s_TempWriteIndex;

    s_TempWriteIndex = gt_RxClearEocBuf_CMV.gs_RxClearEocBuf_WriteIndex + 1;

   if (s_TempWriteIndex == RX_CLEAR_EOC_DATA_SIZE*2)
   {
      s_TempWriteIndex = 0;
   }

   if (s_TempWriteIndex == gt_RxClearEocBuf_CMV.gs_RxClearEocBuf_ReadIndex)
   {
      // artificial overflow
      gt_RxClearEocBuf_CMV.gs_RxClearEocBuf_OverflowCnt++;
   }
   else
   {
      if (gt_RxClearEocBuf_CMV.gs_RxClearEocBuf_WriteIndex & 0x1)
      {
         gt_RxClearEocBuf_CMV.gpus_RxClearEocBuf[gt_RxClearEocBuf_CMV.gs_RxClearEocBuf_WriteIndex >> 1] |= (uc_ClearEOCData << 8);
      }
      else
      {
         gt_RxClearEocBuf_CMV.gpus_RxClearEocBuf[gt_RxClearEocBuf_CMV.gs_RxClearEocBuf_WriteIndex >> 1] = uc_ClearEOCData;
      }

      gt_RxClearEocBuf_CMV.gs_RxClearEocBuf_WriteIndex = s_TempWriteIndex;
   }
}


void CopyBufferToRxClearEOC(uint8 *puc_buffer, int32 l_length)
{

   int i;

   for (i=0 ; i<l_length ; i++, puc_buffer++)
      BufferClearEOCMsg(*puc_buffer);

}
