/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */

/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   SetUpSWRSDetectBins.c
 *
 *   Iridia CPE core interface layer.
 *
 *
 *----------------------------------------------------------------------------
 */


#include "const.h"
#include "const_bis.h"
#include "gdata.h"
#include "gdata_bis.h"

#include "string.h"
#include "states.h"
#include "const.h"
#include "cmv.h"
#include "bitload_const.h"
#include "pll.h"


extern int16 gsa_PreSel_RSDetectBins[NUM_REVERB_SEGUE_BIN_CHECKS];

void SetUpSWRSDetectBins()
{
   int s_toneidx, s_numTones, i;

   /* For S/W RS Detection -- Clear RS Detect Arrays  */
   for(i= 0; i < NUM_REVERB_SEGUE_BINS; i++)
   {
      gsa_RSDetect_Bins[i] = 0;
      if((i&0x7) == 0)
         gsa_RSDetect_PNSeq[i>>3] = 0;
   }

   s_numTones = 0;
   s_toneidx = gs_RxFirstChannel;
   /* For S/W RS Detection */
   while ((s_toneidx < gs_RxNumTones) && (s_numTones < NUM_REVERB_SEGUE_BINS))
   {
      int16 s_pn_seq;

      if (s_toneidx == gsa_PreSel_RSDetectBins[s_numTones])
      {
         /* Get PN Sequence for tones selected for RS Detection */
         s_pn_seq = gusa_PN512Tab[s_toneidx>>3];
         s_pn_seq >>= ((s_toneidx&0x7)<<1);
         s_pn_seq &= 0x3;
         /* Update RSDetect Array */
         gsa_RSDetect_Bins[s_numTones] = s_toneidx;
         gsa_RSDetect_PNSeq[s_numTones>>3] |= (s_pn_seq << ((s_numTones&0x7)<<1));
         s_numTones++;
      }
      s_toneidx++;
   }
   gs_RSDetect_NumBins = s_numTones;
}
