/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *-------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   TxInfoBit.c
 *
 *   Transmitter operations.
 *
 *-------------------------------------------------------------------------
 */

#include "common.h"
#include "gdata.h"
#include "tx_ops.h"


/*^^^
*------------------------------------------------------------------------
*
*  Name : TxInfoBit
*
*   Prototype:
*       uint16 TxInfoBit(uint8 *puca_message, int16 s_opt_count)
*
*   Abstract:
*       Extracts a bit from a charater array, encodes it as R_Reverb (bit = 0)
*       or R_Segue (bit = 1) and fills s_TxOutBuf[] with the corresponding samples
*
*   Input Parameters:
*     *puca_message       Pointer to character array with bit to encode and send
*       s_opt_count         number of bit to be sent, 0 corresponds to the lsb of
*                           puca_message[0], 7 to the msb of puca_message[7], etc
*
*   Returns:
*       Info bit.
*
*  Global Variables:
*     s_TxOutBuf[]    (O) output samples (changed in TxReverbSegue() )
*
*-----------------------------------------------------------------------------
^^^*/
C_SCOPE uint16 TxInfoBit(uint8 *puca_message, int16 s_opt_count) {

   int16    s_indx, s_bitnum;
   uint16  us_infobit;

   /* extract bit */
   s_indx = s_opt_count >> 3;
   s_bitnum = s_opt_count & 0x7;
   us_infobit = (uint16) (puca_message[s_indx] >> s_bitnum);
   us_infobit &= 0x0001;

   /* encode and transmit bit  */
   TxReverbSegueSetUp(gs_TxFirstChannel, gs_TxLastChannel, us_infobit);

   return us_infobit;

}

