/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *-------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   TxMTnSt.c
 *
 *   Definition of TxMultiToneSetUp.
 *
 *-------------------------------------------------------------------------
 */

#include "common.h"
#include "gdata.h"


/*
 *------------------------------------------------------------------------
 *
 *  Name: TxMultiToneSetUp
 *
 *  Abstract: Loads gsa_TxToneBuf with the frequency domain samples for
 *       given frequency bins and amplitude.
 *
 *  Parameters:
 *     int16 sa_CarSet[]    Frequency bins of the carrier set to be used
 *     int16 s_NumCar       No. of carrier frequecies in the carrier set
 *     int16 s_TxScale      Scale of tones to be sent
 *     int16 s_An           Bit symbol to be sent (either +1 or -1)
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *      gsa_TxToneBuf[]   - (O) frequency domains samples
 *
 *------------------------------------------------------------------------
 */

C_SCOPE void TxMultiToneSetUp(CONSTANT int16 sa_CarSet[], int16 s_NumCar, int16 s_TxScale) {

    int16  i;

    /* ---- assure that tone buffer is cleared before function call (if required) ---- */

    // multiply scale with sqrt(2):
    s_TxScale = (int16) ((23170 * (int32)s_TxScale) >> 14);
    /* insert tones with phase 90 or 270, depending on the sign of s_TxScale */
    for (i=0; i < s_NumCar-1; i++) {
        gsa_TxToneBuf[ 2 * sa_CarSet[i] ]       = 0;
        gsa_TxToneBuf[ 2 * sa_CarSet[i] + 1 ]   = s_TxScale;
    }

    /* Reverse phase for the last carrier. This reduces the high frequency sidelobes, and
      therefore echo, considerably. Additionally, it also improves peak-to-average ratio so that
      the receiver on the other side is less likely to clip even at high PGA setting
      (on short loops). */
    gsa_TxToneBuf[ 2 * sa_CarSet[s_NumCar-1] ]     = 0;
    gsa_TxToneBuf[ 2 * sa_CarSet[s_NumCar-1] + 1 ] = -s_TxScale;

}   /*  TxMultiToneSetUp */
