/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *-------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   TxTneSt.c
 *
 *   Definition of TxToneSetUp.
 *
 *-------------------------------------------------------------------------
 */

#include "common.h"
#include "gdata.h"
#include <string.h>
#include "afe.h"


/*
 *------------------------------------------------------------------------
 *
 *  Name: TxToneSetUp
 *
 *  Prototype:
 *    void TxToneSetUp(int16 s_TxTone, int16 s_TxScale);
 *
 *  Description:
 *
 *    Fills global transmit buffer gsa_TxToneBuf with
 *    freq domain samples for a single tone.  The
 *    Tone is sent in the I (vs. Q) component only.
 *
 *  Parameters:
 *     int16 s_TxTone       Frequency bin of tone to be sent
 *     int16 s_ITxScale     Scale for I component of tone to be sent
 *     int16 s_QTxScale     Scale for Q component of tone to be sent
 *
 *  Returns:
 *    None
 *
 *  Global Variables Used:
 *
 *      gsa_TxToneBuf[]   - (O) frequency domains samples
 *
 *------------------------------------------------------------------------
 */
C_SCOPE void TxToneSetUp(int16 s_TxTone, int16 s_ITxScale, int16 s_QTxScale) {

   /* clear tone buffer */
   memset(gsa_TxToneBuf,0,sizeof(int16)*gs_TxFftLength);



#ifdef AMAZON_AFE
#ifdef TX_NOISESHAPER_RESET
   //  The  AFE noise shaper will be reset in 2 frames, when the first zero data exits strymon.
      if ((s_ITxScale == 0) && (s_QTxScale == 0))
      gc_afeResetDelayCnt = 2;


#else
   // Amazon afe fix in fs4
   if ((s_ITxScale == 0) && (s_QTxScale == 0))
   {

      // Instead of zeroing entire buffer, send one US tone at -80db below nominal
      // in order to keep AFE noise shaper from generating periodic noise.
      s_TxTone = gs_TxToneForNoiseShaper;

      s_ITxScale = ENCGAIN2 >> 13;     // Right shift attenuates power by ~80dB, due to truncation.
      s_QTxScale = ENCGAIN2 >> 13;
   }

#endif
#endif

   /* insert tone */
   gsa_TxToneBuf[2 * s_TxTone]     = s_ITxScale;
   gsa_TxToneBuf[2 * s_TxTone + 1] = s_QTxScale;

}
