/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   bufmisc.c
 *
 *   Miscellaneous functions for manipulating data buffers.
 *
 *------------------------------------------------------------------------
 */

#include "typedef.h"
#include "dsp_op.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "const_bis.h"


/****************************************************************************
 ;
 ; Subroutine Name : RightNormalizeSignedPair(pl_x, pl_y, s_NBits, s_RightShift)
 ;
 ; This function can be used to normalize a complex number to a given number of
 ; significant bits.
 ; Let the input x and y values be the real and imaginary components of the
 ; imaginary number. This function finds the smallest RIGHT shift that will
 ; limit the number of significant bits (including sign bits) in both l_x and l_y to
 ; s_NBits (right justified).
 ;  The right shift value is returned in ps_RightShift.  (NOTE that no left shifting
 ; is ever done. If both x and y already have no more than s_NBits significant bits,
 ;  then no shifting is done.)
 ; The shifted data values are returned in l_x, l_y.
 ;
 ; Example:
 ;
 ;    if l_x = 0x00345123, l_y = 0xffff4126, and s_Nbits=10:
 ;
 ;       Return values are:
 ;
 ;       s_RightShift = 13,
 ;
 ;       l_x = (0x00345123) >> 13
 ;          = 0x000001a2 (has 10 significant bits),
 ;
 ;       l_y = (0xffff4126) >> 13
 ;          = 0xfffffffa (has 5 significant bits),
 ;
 ; Prototype:
 ;
 ;    void NormalizeSignedPair(int32 *pl_x, int32 *pl_y, int16 s_NBits, int16 *s_RightShift)
 ;
 ;  Input Arguments:
 ;
 ;    int32 pl_x  - pointer to signed 32-bit value x
 ;
 ;    int32 pl_y  - pointer to signed 32-bit value y
 ;
 ;    int16 s_NBits - Number of significant bits desired in shifted x,y.
 ;
 ;   Output Arguments:
 ;
 ;    int16 ps_RightShift - Right shift value used to shift l_x and l_y.
 ;
 ;  Return Value:
 ;
 ;    none.
 ;
 *****************************************************************************/
void RightNormalizeSignedPair(int32 *pl_x, int32 *pl_y, int16 s_NBits, int16 *ps_RightShift)
{

   int16 s_norm1, s_norm2, s_shift;
   int32 l_x, l_y;

   l_x = *pl_x;
   l_y = *pl_y;

   /* Right shift enough to fit mantissas into 's_NBits' bits. */

   s_norm1 = norm_l(l_x);
   s_norm2 = norm_l(l_y);

   // Set s_norm1 equal to smaller of two norm values.

   if (l_x == 0)
      // If mantissa is exactly zero, don't use its norm value.
      s_norm1 = s_norm2;
   else if (l_y != 0){  // Therefore if l_y == 0, s_norm1 is used as is.
      if (s_norm2 < s_norm1)
         s_norm1 = s_norm2;
   }

   // This is smallest right shift value that guarantees mantissas fit in s_NBits lsbs.
   s_shift = 32 - s_NBits - s_norm1;
   if (s_shift < 0)
      s_shift = 0;      // We don't do left-shifting.

   *pl_x = l_x >> s_shift;
   *pl_y = l_y >> s_shift;

   *ps_RightShift = s_shift;
}

