/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   bufmisc_ext.c
 *
 *   Miscellaneous functions for manipulating data buffers.
 *
 *------------------------------------------------------------------------
 */

#include "typedef.h"
#include "dsp_op.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "const_bis.h"
#include "T1413.h"


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RightShiftAndRound32to16
 *
 *  Description: Right-shift and truncate values in a buffer and copy the results
 *          to another buffer.
 *
 *  Prototype: void RightShiftAndRound32to16(int16 *psa_dest, int16 s_doffset,
 *                                  int32 *pla_src, int16 s_soffset,
 *                                  int16 s_nitems, int16 s_rshift)
 *
 *  Input Arguments: pla_src     - pointer to the source buffer (int32)
 *             s_soffset      - offset for pl_src
 *             s_nitems    - number of items to copy
 *             s_rshift    - number of bits to shift
 *
 *  Output Arguments: psa_dest      - pointer to the destination buffer (int16)
 *             s_doffset      - offset for ps_dest
 *
 *  Return: none
 *
 *------------------------------------------------------------------------
 *^^^
 */

void RightShiftAndRound32to16(int16 *psa_dest, int16 s_doffset,
                        int32 *pla_src, int16 s_soffset,
                        int16 s_nitems, int16 s_rshift)
{
   int i;

   psa_dest += s_doffset;
   pla_src += s_soffset;

   for (i = 0; i < s_nitems; i++)
      psa_dest[i] = (int16) round(pla_src[i], s_rshift);
}

void BgRightShiftAndRound32to16(void)
{
   if(gs_RxState == R_C_COMB2_RX_BIS)
      RightShiftAndRound32to16(gsa_RxRepFrameAlignBuf, 0, gla_RxAccumBuf, 0,
                           gs_RxSamplesPerFrame, LOG2_R_C_COMB2_AC_LEN_BIS);
   else if (gs_RxState == R_C_COMB3_RX_BIS)
      RightShiftAndRound32to16(gsa_RxRepFrameAlignBuf, 0, gla_RxAccumBuf, 0,
                           gs_RxSamplesPerFrame, (int16)(LOG2_R_C_COMB2_AC_LEN_BIS-1));
   else if (gs_RxState == R_C_TONES_RX)
      RightShiftAndRound32to16(gsa_RxRepFrameAlignBuf, 0, gla_RxAccumBuf, 0,
                           RX_FFT_LENGTH, GHSCARRIERSET_LOG2_NUM_ACCUM_SYMBOLS);
   else if (gs_RxState == R_C_ACT_RX)
      RightShiftAndRound32to16(gsa_RxRepFrameAlignBuf, 0, gla_RxAccumBuf, 0,
                           RX_FFT_LENGTH, 3); //scale factor:3 is it intentional ??
   guc_AccumState = TRAINING_DONE;
}

// DSP OPERATIONS
// FUNCS FROM DSP_OP2.c THAT ARE NEEDED IN TRAINING ONLY
/*****************************************************************************
 ;
 ;   Function Name: abs_s(int16 s_var1)
 ;
 ;   Abstract:
 ;    Absolute value of var1; abs_s(-32768) = 32767.
 ;
 ;   Complexity weight: 1
 ;
 ;   Inputs:
 ;    s_var1  - 16 bit short signed integer (Word16) whose value falls in the
 ;              range: 0xffff 8000 <= var1 <= 0x0000 7fff.
 ;
 ;   Outputs:
 ;   none
 ;
 ;   Return Value:
 ;    var_out  - 16 bit short signed integer (Word16) whose value falls in the
 ;               range: 0x0000 0000 <= var_out <= 0x0000 7fff.
 *****************************************************************************/
int16 abs_s(int16 s_var1)
{
    int16 s_var_out;

    if (s_var1 == (int16)0X8000 ) {
        s_var_out = MAX_16;
    }
    else {
        if (s_var1 < 0) {
            s_var_out = -s_var1;
        }
        else {
            s_var_out = s_var1;
        }
    }

    return(s_var_out);
}

