/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   calibrat.c
 *
 * Contains values that need to be calibrated for a given platform.
 *
 *   Notes:
 *
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "typedef.h"
#include "platform.h"

/*
// Every system will consist of at least an analog front end (AFE), an A-to-D converter
// and a means for computing the FFT of digitized samples.

// Here we define a structure to define the conversion scale factor between
// the actual received power at an AFE input and the corresponding digital frequency
// domain value output by the FFT.  Because the conversion factor depends on any sources
// of variable gain in the path between the AFE input and FFT output, the conversion factor
// is defined for a particular set of values for these variable gain sources. The variable
// gain sources are: 1) AFE gain, 2) number of FFT scalebacks.

   NOTE: If there are other sources of gain between the AFE and the FFT output that may change
   during modem operation, their settings must be recorded during calibration.

   The values in this structure must be obtained by a laboratory calibration procedure.

   For the calibration measurement:

   - The input signal to the AFE is a single frequency sinusoid.
   - AFE gain is set to a typical value.
   - The amplitude of the
   input signal must be low enough to ensure no saturation (clipping)
   at any point in the path from AFE input to FFT output.

  The following quantities/settings are measured/recorded:
  (A range of power and gain settings may be used.  The important thing is that all values
  are recorded at the same time.)

   1) Absolute power of  a single input tone at AFE input, in units of mW (= TonePower_mW).
   2) Power in a single tone of the FFT output (32-bit digital value).
         l_TonePower_Freq_Domain = Tone power = (RealPart{FT[k]})^2 + (ImagPart{FT[k]})^2

   3) Total AFE gain setting, in dB. Format Q8.8. => RXPOWERCAL_AFEGAIN.

   4) FFT scaling = number of stage scalebacks done by FFT => RXPOWERCAL_FFT_SCALEBACKS

  Then the conversion factor is calculated as the ratio :

      RxPowerConvert = TonePower_mW / l_TonePower_Freq_Domain

  and expressed in a normalized mantissa and exponent format by:

      RxPowerConvert =  RXPOWERCAL_CONVERT_MANTISSA * 2^RXPOWERCAL_CONVERT_EXPONENT

*/

struct RxPowerCalibration gt_RxPowerCalibration =
{
   RXPOWERCAL_CONVERT_MANTISSA,  // const int16 s_RxPowerConvert_Mantissa;
   RXPOWERCAL_CONVERT_EXPONENT,  // const int16 s_RxPowerConvert_Exp;
   RXPOWERCAL_AFEGAIN,           // const int16 s_AFE_Gain_dB;
   RXPOWERCAL_FFT_SCALEBACKS     // const int16 s_FFT_Scalebacks;
};





   ;


