/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  config.c
;
;  This file contains sets of configuration parameters for running the
;  system.
;
;***************************************************************************/

#include "common.h"
#include "ghs.h"

/* =============================================== */
/* static variable declarations */
/* =============================================== */
/* Bit allocation tables, used to test various channels */



/* Include TCM overhead bits in the BATs. */
#ifdef ISDN
uint8 guca_US_BAT23_TCM_ON[64] = {
   0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0,
   0,  0,  3,  4,  5,  6, 7,  8,  9, 10,  //32-41
   13, 15, 0, 15, 14,  10, 9,  9,  8,  8,  //42-51
   7,  7,  7,  6,  6,  6, 5,  4, 0, 0,     //52-61
   0,  0};

   uint8 guca_DS_BAT68_TCM_ON[256] =
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,      //0-32
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,      //33-63
 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 8, 9,                           //64-80
 9, 9, 9, 10, 10, 10, 10, 11, 11, 11, 11, 12, 12, 12, 12, 0, 13, 13, 13, 13,        //81-100
 14, 14, 14, 14, 14, 14, 14, 14, 15, 15, 15, 15, 3, 3, 3, 3, 3, 3, 3, 3,         //101-120
 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,                  //121-150
 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0                      //151-158
};
#else
uint8 guca_US_BAT23_TCM_ON[32] = {
     0,  0,  0,   0,  0,  0,  3,  4,  5,  6,
     7,  8,  9,  10, 13, 15,  0, 15, 14,  10,
     9,  9,  8,  8,  7,  7,  7,  6,  6,  6,
     5,  4};

uint8 guca_DS_BAT68_TCM_ON[256] =
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,      /* 0-32              */
 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 8, 9,                           /* 33-49 */
 9, 9, 9, 10, 10, 10, 10, 11, 11, 11, 11, 12, 12, 12, 0, 12, 13, 13, 13, 13,        /* 50-69 */
 14, 14, 14, 14, 14, 14, 14, 14, 15, 15, 15, 15, 3, 3, 3, 3, 3, 3, 3, 3,         /* 70-89 */
 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,                  /* 90-119 */
 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0                      /* 120-127 */
};
#endif

uint8 guca_US_BAT30_TCM_ON[32] = {
   0, 0, 0, 0, 0, 0, 14,   15,   10,   14,   15,   15,   8, 10,   12,   15,
   12,   14,   11,   3, 7, 9, 0, 12,   4, 12,   4, 5, 11,   8, 6, 11};

uint8 guca_DS_BAT31_TCM_ON[256] = {
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 14,   14,   0, 6, 15,   4, 10,   7, 15,   11,   14,   13,   12,   14,   4,
   12,   11,   8, 6, 12,   8, 11,   3, 13,   11,   5, 12,   0, 0, 0, 0};

/* Bit allocation tables */
#ifdef ISDN
uint8 guca_US_BAT23[64] = {
   0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0,
   0,  0,  2,  3,  4,  5, 6,  7,  8,  9,   //32-41
   12, 15, 0, 15, 13,  9, 7,  7,  7,  7,   //42-51
   7,  7,  7,  6,  6,  6, 5,  4,  0,  0,   //52-61
   0,  0};

uint8 guca_DS_BAT68[256] =
   {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,      //0-32
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,      //33-63
   4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8,                         //64-80
   8, 8, 8, 9, 9, 9, 9, 10, 10, 10, 10, 11, 11, 11, 11, 0, 12, 12, 12, 12,       //81-100
   13, 13, 13, 13, 14, 14, 14, 14, 15, 15, 15, 15, 2, 2, 2, 2, 2, 2, 2, 2,       //101-120
   2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,                //121-150
   2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0                       //151-158
   };
#else
uint8 guca_US_BAT23[32] = {
    0,  0,  0,  0,  0,  0,  2,  3,  4,  5,
    6,  7,  8,  9, 12, 15,  0, 15, 13,  9,
    7,  7,  7,  7,  7,  7,  7,  6,  6,  6,
    5,  4};

uint8 guca_DS_BAT68[256] = {
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    /* 0-32 */
   4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8,                         /* 33-49 */
   8, 8, 8, 9, 9, 9, 9, 10, 10, 10, 10, 11, 11, 11, 0, 11, 12, 12, 12, 12,          /* 50-69 */
   13, 13, 13, 13, 14, 14, 14, 14, 15, 15, 15, 15, 2, 2, 2, 2, 2, 2, 2, 2,          /* 70-89 */
   2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,                   /* 90-119 */
   2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0};                        /* 120-117 */
#endif

uint8 guca_US_BAT28[32] = {
    0, 0, 0, 0, 0, 0, 6, 6, 5, 5,
    4, 4, 3, 5, 2, 15, 0, 15, 14, 14,
    13, 13, 12, 12, 11, 11, 10, 10, 9, 9,
    8, 8};

uint8 guca_US_BAT48[32] = {
   0, 0, 0, 0, 0, 0, 9, 15,   15,   15,   15,   15,   15,   15,   15,   15,
   15,   15,   15,   15,   15,   15,   15,   15,   15,   15,   15,   15,   15,   15,   15,   15};

uint8 guca_DS_BAT255[256] = {
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 11,   8, 9, 5, 15,   9, 12,   13,   14,   10,   6, 15,   10,   15,   15,
   15,   12,   11,   3, 15,   10,   9, 6, 14,   14,   13,   7, 14,   12,   9, 12,
   0, 14,   12,   14,   11,   12,   15,   15,   15,   6, 9, 5, 14,   13,   12,   15,
   10,   11,   14,   12,   15,   13,   15,   14,   9, 10,   13,   13,   15,   9, 13,   12,
   10,   13,   14,   4, 15,   14,   14,   14,   12,   11,   9, 13,   12,   14,   12,   15,
   13,   14,   0, 5, 12,   5, 14,   11,   2, 2, 0, 4, 8, 7, 11,   9,
   8, 2, 3, 6, 5, 12,   5, 10,   15,   8, 15,   13,   14,   2, 13,   14,
   3, 2, 12,   11,   10,   12,   10,   14,   5, 7, 4, 0, 2, 13,   6, 7,
   14,   4, 13,   10,   14,   8, 15,   6, 8, 3, 8, 7, 10,   11,   15,   3,
   2, 9, 15,   0, 14,   0, 8, 3, 11,   4, 15,   3, 8, 14,   15,   6,
   7, 8, 3, 3, 8, 11,   6, 6, 5, 14,   10,   4, 15,   10,   4, 11,
   10,   3, 0, 4, 2, 2, 13,   3, 0, 12,   9, 5, 6, 0, 14,   13,
   4, 9, 3, 9, 5, 10,   13,   9, 15,   12,   3, 13,   3, 10,   11,   12,
   6, 7, 8, 10,   3, 0, 12,   8, 4, 2, 3, 7, 7, 11,   15,   0};

uint8 guca_DS_BAT299[256] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    //0-32
4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8,                         //33-49
8, 8, 8, 9, 9, 9, 9, 10, 10, 10, 10, 11, 11, 11, 0, 11, 12, 12, 12, 12,       //50-69
13, 13, 13, 13, 14, 14, 14, 14, 15, 15, 15, 15, 2, 2, 2, 2, 2, 2, 2, 2,       //70-89
15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,     //90-119
15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,     //120-139
15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,     //140-159
15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
15, 15, 15, 15, 15, 15, 15, 15, 15, 15,  0,  0
};

uint8 guca_US_BAT17[32] = {
   0, 0, 0, 0, 0, 0, 15,   4, 10,   8, 14,   12,   7, 0, 13,   7,
   10,   12,   14,   8, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0};

uint8 guca_DS_BAT5[256] = {
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 3, 10,   5, 3, 0, 12,   4, 3, 0, 0, 0, 0, 0, 0, 0};

/* bit allocation tables for g.bis. The number 184 after gsa_US_BAT reflects 184 bits */
/* and not bytes as in previous cases */
uint8 guca_US_BAT184[32] = {
    0,  0,  0,  0,  0,  0,  2,  3,  4,  5,
    6,  7,  8,  9, 12, 15,  0, 15, 13,  9,
    7,  7,  7,  7,  7,  7,  7,  6,  6,  6,
    5,  4};

uint8 guca_US_BAT66[32] = {
    0,  0,  0,  0,  0,  0,  0,  3,  4,  5,
    5,  6,  5,  6, 10, 6,  0, 4, 4,  3,
    3,  2,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0};

/* bit allocation tables for g.bis. The number 2040 after gsa_DS_BAT reflects 2040 bits */
uint8 guca_DS_BAT2040[256] = {
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 11,   8, 9, 5, 15,   9, 12,   13,   14,   10,   6, 15,   10,   15,   15,
   15,   12,   11,   3, 15,   10,   9, 6, 14,   14,   13,   7, 14,   12,   9, 12,
   0, 14,   12,   14,   11,   12,   15,   15,   15,   6, 9, 5, 14,   13,   12,   15,
   10,   11,   14,   12,   15,   13,   15,   14,   9, 10,   13,   13,   15,   9, 13,   12,
   10,   13,   14,   4, 15,   14,   14,   14,   12,   11,   9, 13,   12,   14,   12,   15,
   13,   14,   0, 5, 12,   5, 14,   11,   2, 2, 0, 4, 8, 7, 11,   9,
   8, 2, 3, 6, 5, 12,   5, 10,   15,   8, 15,   13,   14,   2, 13,   14,
   3, 2, 12,   11,   10,   12,   10,   14,   5, 7, 4, 0, 2, 13,   6, 7,
   14,   4, 13,   10,   14,   8, 15,   6, 8, 3, 8, 7, 10,   11,   15,   3,
   2, 9, 15,   0, 14,   0, 8, 3, 11,   4, 15,   3, 8, 14,   15,   6,
   7, 8, 3, 3, 8, 11,   6, 6, 5, 14,   10,   4, 15,   10,   4, 11,
   10,   3, 0, 4, 2, 2, 13,   3, 0, 12,   9, 5, 6, 0, 14,   13,
   4, 9, 3, 9, 5, 10,   13,   9, 15,   12,   3, 13,   3, 10,   11,   12,
   6, 7, 8, 10,   3, 0, 12,   8, 4, 2, 3, 7, 7, 11,   15,   0};

uint8 guca_DS_BAT1968[256] = {
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 11,   8, 9, 5, 14,   8, 12,   13,   14,   10,   6, 15,   10,   15,   0,
   15,   12,   11,   3, 15,   10,   9, 6, 10,   10,   13,   7, 14,   12,   9, 12,
   0, 14,   12,   14,   11,   12,   15,   15,   15,   6, 9, 5, 14,   13,   12,   15,
   10,   11,   14,   12,   15,   13,   15,   14,   9, 10,   13,   13,   15,   9, 13,   12,
   10,   13,   14,   4, 15,   14,   14,   14,   12,   11,   9, 13,   12,   14,   12,   15,
   13,   14,   0, 5, 12,   5, 14,   11,   2, 2, 0, 4, 8, 7, 11,   9,
   8, 2, 3, 6, 5, 12,   5, 10,   15,   8, 15,   13,   14,   2, 13,   14,
   3, 2, 12,   11,   10,   12,   10,   14,   5, 7, 4, 0, 2, 13,   6, 7,
   14,   4, 13,   10,   14,   8, 15,   6, 8, 3, 8, 7, 10,   11,   15,   3,
   2, 9, 15,   0, 14,   0, 8, 3, 11,   4, 15,   3, 8, 14,   15,   6,
   7, 8, 3, 3, 8, 11,   6, 6, 5, 14,   10,   4, 15,   10,   4, 11,
   10,   3, 0, 4, 2, 2, 13,   3, 0, 12,   9, 5, 6, 0, 14,   13,
   4, 9, 3, 9, 5, 10,   13,   9, 15,   12,   3, 13,   3, 10,   11,   12,
   6, 0, 8, 10,   3, 0, 12,   8, 4, 2, 3, 0, 0, 0, 0, 0};

int16 gsa_FineGains[256] =
{0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000};

/* =============================================== */
/* global variable declarations */
/* =============================================== */

/* Configuration parameters: */

/* when used for g.bis each set contains the following parameter
 {
   Nbc,
   Nlp,
   {Rp[0],...,Rp[Nlp-1]},
   {Mp[0],...,Mp[Nlp-1]},
   {Lp[0],...,Lp[Nlp-1]} ,
   {Tp[0],...,Tp[Nlp-1]},
   {Dp[0],...,Dp[Nlp-1]},
   {
      {Bpn[0][0],...,Bpn[0][Nbc-1]},
      {Bpn[0][0],...,Bpn[0][Nbc-1]},
      :
      :
      :
      {Bpn[Nlp-1][0],...,Bpn[Nlp-1][Nbc-1]}
   },
   x,
   MSGlp,
   IBITSlp,
   MSGc,
   array_name_of_BitAllocationTable,
   array_name_FineGainsTable
   }
 where   Nbc = number of frame bearers to be supported
         Nlp = number of latency paths to transport
         Rp[p] = number of R-S check bytes per FEC codeword in the path p
         Mp[p] = number of mux frames per FEC data frame in path p
         Lp[p] = number of bits from latency path p
         Tp[p] = ratio of mux data frames to number of overhead octets in path p
         Dp[p] = interleave depth in path p
         Bpn[p][n] = number of raw bytes per mux data frame on Bearer Channel n, Latency Path p
                  n is in {0, 1,...,Nbc-1}
                  p is in {0, 1,...,Nlp-1}
         x = entry is not applicable
         MSGlp = label of the latency path used to transport the message based overhead information
         IBITSlp = label of the latency path used to transport the indicator bits
         MSGc = number of octets in the message based portion of the overhead structure
         pBAT = pointer to Bit Allocation Table
         pFineGains = pointer to Fine Gains Table

 when used for DS g.dmt each set contains the following parameter
 {
   NUM_DS_BEARER_CHANNELS(7),
   NUM_DATA_PATHS(2),
   {Ri,Rf},
   {S,x},
   {x,x} ,
   {x,x},
   {D,x},
   {
      {N_AS0i, N_AS1i, N_AS2i, N_AS3i, N_LS0i, N_LS1i, N_LS2i},
      {N_AS0f, N_AS1f, N_AS2f, N_AS3f, N_LS0f, N_LS1f, N_LS2f},
   },
   FM,
   x,
   x,
   x,
   array_name_of_BitAllocationTable,
   array_name_FineGainsTable
   }
 when used for US g.dmt each set contains the following parameter
 {
   NUM_DS_BEARER_CHANNELS(7),
   NUM_DATA_PATHS(2),
   {Ri,Rf},
   {S,x},
   {x,x} ,
   {x,x},
   {D,x},
   {
      {N_LS0i, N_LS1i, N_LS2i, 0, 0, 0, 0},
      {N_LS0f, N_LS1f, N_LS2f, 0, 0, 0, 0},
   },
   FM,
   x,
   x,
   x,
   array_name_of_BitAllocationTable,
   array_name_FineGainsTable
   }
 where   Rf = number of R-S check bytes per symbol in the Fast Latency Path
         Ri = number of R-S check bytes per FEC codeword in the Interleaved Latency Path
         S = number of symbols per FEC codeword in the Interleaved Path
          FM = framing mode (0, 1, 2, 3)
         x = entry is not applicable
         D = interleave depth
         N_BBBp = number of raw bytes per mux data frame on Bearer Channel BBB, Latency Path p
                   BBB is in {AS0, AS1, AS2, AS3, LS0, LS1, LS2}
                   p = f, Fast Latency Path; p = i, Interleaved Latency Path
         pBAT = pointer to Bit Allocation Table
         pFineGains = pointer to Fine Gains Table
 The following configuration parameter sets are used to test different Rf, Ri, S, D and NBBBp.
 Each given Rf, Ri, S, D and NBBBp is selected such that Reed Solomon check byte overhead is
 close to 10% of a codeword.

 The real configuration parameter should be supplied at the end of training process. */
Config_t gt_config_set[NUM_CONFIG_SETS] =
{
    /* ====================== */
    /* Down stream  */
    /* ====================== */

    /* Framing mode 3, Interleaved Path, AS0 active */
    /* Rf =0, Ri=16, S=2, D=16, N = 59 */
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {16, 0}, {2, -1}, {-1, -1}, {-1, -1}, {16, -1},
      {{59, 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}},
      REDUCED_MERGED, -1, -1, -1, guca_DS_BAT68, gsa_FineGains
   }, /* 0 */
#ifdef TEST_ADSL62_FAST
   /* Framing mode 3, Fast Path, AS0 active */
    /* Rf = 8, Ri = 0, S=1, D=1, N = 59 */
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {0, 8}, {1, -1}, {-1, -1}, {-1, -1}, {1, -1},
      {{0, 0, 0, 0, 0, 0, 0},{59, 0, 0, 0, 0, 0, 0}},
      REDUCED_MERGED, -1, -1, -1, guca_DS_BAT68, gsa_FineGains
   }, /* 0' */
#endif

    /* Framing mode 2, Fast Path, AS0 active */
    /* Rf = 8, Ri = 0, S=1, D=1, N = 59 */
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {0, 8}, {1, -1}, {-1, -1}, {-1, -1}, {1, -1},
      {{0, 0, 0, 0, 0, 0, 0},{58, 0, 0, 0, 0, 0, 0}},
      REDUCED_SEPARATE, -1, -1, -1, guca_DS_BAT68, gsa_FineGains
   }, /* 1 */

    /* Framing mode 1, Fast Path AS0, Interleaved Path, AS1 active */
    /* Rf = 4, Ri=16, S=4, D=8, N, AS0 = 30; N, AS1 = 24 */
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {16, 4}, {4, -1}, {-1, -1}, {-1, -1}, {8, -1},
      {{0, 24, 0, 0, 0, 0, 0},{30, 0, 0, 0, 0, 0, 0}},
      FULL_SYNC, -1, -1, -1, guca_DS_BAT68, gsa_FineGains
   }, /* 2 */

    /* Framing mode 0, Fast Path AS0, LS0 ( = 'C' Channel); Interleaved Path, AS2, AS3, LS1, LS2 active */
    /* Rf = 4, Ri=16, S=4, D=16, N,AS0 = 25; N,LS0 = 255 (indicates 'C' channel) */
    /*                           N,AS2 = 12; N,AS3 = 8; N,LS1 = 7; N,LS2 = 2 */
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {16, 4}, {4, -1}, {-1, -1}, {-1, -1}, {16, -1},
      {{0, 0, 12, 8, 0, 7, 2},{25, 0, 0, 0, 255, 0, 0}},
      FULL_ASYNC, -1, -1, -1, guca_DS_BAT68, gsa_FineGains
   }, /* 3 */


   /* ====================== */
    /* Up stream  */
    /* ====================== */

    /* Framing mode 3, Interleaved Path, LS0 active */
    /* Rf=0; Ri = 16; S=8; D=16; N = 20 */
    /*{0, 2, 8, 16, 0, 0, 0, 0, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, REDUCED_MERGED, gsa_US_BAT23, gsa_FineGains},*/ /* 4 */
    /* Rf=0; Ri = 16; S=8; D=8; N = 20 */
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {16, 0}, {8, -1}, {-1, -1}, {-1, -1}, {8, -1},
      {{20, 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}},
      REDUCED_MERGED, -1, -1, -1, guca_US_BAT23, gsa_FineGains
   }, /* 4 */
#ifdef TEST_ADSL62_FAST
    /* Framing mode 3, Fast Path, LS0 active */
    /* Rf=2, Ri = 0, S=1, D=1, LS0 = 19 */
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {0, 2}, {1, -1}, {-1, -1}, {-1, -1}, {1, -1},
      {{0, 0, 0, 0, 0, 0, 0},{20, 0, 0, 0, 0, 0, 0}},
      REDUCED_MERGED, -1, -1, -1, guca_US_BAT23, gsa_FineGains
   }, /* 4' */
#endif

    /* Framing mode 2, Fast Path, LS0 active */
    /* Rf=2, Ri = 0, S=1, D=1, LS0 = 19 */
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {0, 2}, {1, -1}, {-1, -1}, {-1, -1}, {1, -1},
      {{0, 0, 0, 0, 0, 0, 0},{19, 0, 0, 0, 0, 0, 0}},
      REDUCED_SEPARATE, -1, -1, -1, guca_US_BAT23, gsa_FineGains
   }, /* 5 */

    /* Framing mode 1, Fast Path, LS0; Interleaved Path, LS1 */
    /* Rf=2, Ri = 8, S=4, D=16, N, LS0 = 8; N,LS1 = 7 */
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {8, 2}, {4, -1}, {-1, -1}, {-1, -1}, {16, -1},
      {{0, 7, 0, 0, 0, 0, 0},{8, 0, 0, 0, 0, 0, 0}},
      FULL_SYNC, -1, -1, -1, guca_US_BAT23, gsa_FineGains
   }, /* 6 */

    /* Framing mode 0, Fast Path, LS2; Interleaved Path, LS0 (='C' Channel) */
    /* Rf = 0; Ri=16; S=8; D=8; N, LS0 = 255 (indicates 'C' channel); N,LS2 = 17 */
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {16, 0}, {8, -1}, {-1, -1}, {-1, -1}, {8, -1},
      {{255, 0, 0, 0, 0, 0, 0},{0, 0, 17, 0, 0, 0, 0}},
      FULL_ASYNC, -1, -1, -1, guca_US_BAT23, gsa_FineGains
   }, /* 7 */

    /* ======================================================================== */
    /*  TEST GENERATOR */

    /*  Use gt_config_set[n+4] as the the TX configuration to generate loopback */
    /*  test vectors to verify gt_config_set[n], n = {4, 5, 6, 7} .  When using */
    /*  the following configurations, the following definition in CONFIG.H must */
    /*  be used:     #define GDMT_DS_NUM_TONES  32 */
    /* ======================================================================== */

    /* Framing mode 3, Interleaved Path, LS0 active */
    /* Rf=0; Ri = 16; S=8; D=16; N = 20 */
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {16, 0}, {8, -1}, {-1, -1}, {-1, -1}, {16, -1},
      {{0, 0, 0, 0, 20, 0, 0},{0, 0, 0, 0, 0, 0, 0}},
      REDUCED_MERGED, -1, -1, -1, guca_US_BAT23, gsa_FineGains
   }, /* 8 */

    /* Framing mode 2, Fast Path, LS0 active */
    /* Rf=2, Ri = 0, S=1, D=1, LS0 = 19 */
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {0, 2}, {1, -1}, {-1, -1}, {-1, -1}, {1, -1},
      {{0, 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 19, 0, 0}},
      REDUCED_SEPARATE, -1, -1, -1, guca_US_BAT23, gsa_FineGains
   }, /* 9 */

    /* Framing mode 1, Fast Path, LS0; Interleaved Path, LS1 */
    /* Rf=2, Ri = 8, S=4, D=16, N, LS0 = 8; N,LS1 = 7 */
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {8, 2}, {4, -1}, {-1, -1}, {-1, -1}, {16, -1},
      {{0, 0, 0, 0, 0, 7, 0},{0, 0, 0, 0, 8, 0, 0}},
      FULL_SYNC, -1, -1, -1, guca_US_BAT23, gsa_FineGains
   }, /* 10 */

    /* Framing mode 0, Fast Path, LS2; Interleaved Path, LS0 (='C' Channel) */
    /* Rf = 0; Ri=16; S=8; D=16; N, LS0 = 255 (indicates 'C' channel); N,LS2 = 17 */
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {16, 0}, {8, -1}, {-1, -1}, {-1, -1}, {16, -1},
      {{0, 0, 0, 0, 255, 0, 0},{0, 0, 0, 0, 0, 0, 17}},
      FULL_ASYNC, -1, -1, -1, guca_US_BAT23, gsa_FineGains
   }, /* 11 */

     /* ==================================================================================== */
    /* The following configuration is created to generate the test vector with S=2 and D=1. */
    /* When using the following configuration, the following definition in CONFIG.H must    */
    /*  be used:     #define GDMT_US_NUM_TONES  256                                         */
    /* ==================================================================================== */

    /* ====================== */
    /* Down stream  */
    /* ====================== */

    /* Framing mode 3, Interleaved Path, AS0 active */
    /* Rf =0, Ri=16, S=2, D=1, N = 59 */
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {16, 0}, {2, -1}, {-1, -1}, {-1, -1}, {1, -1},
      {{59, 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}},
      REDUCED_MERGED, -1, -1, -1, guca_DS_BAT68, gsa_FineGains
   }, /* 12 */

    /* ====================== */
    /* Up stream  */
    /* ====================== */

    /* Framing mode 3, Interleaved Path, LS0 active */
    /* Rf=0; Ri = 16; S=2; D=1; N = 14 */
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {16, 0}, {2, -1}, {-1, -1}, {-1, -1}, {1, -1},
      {{14, 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}},
      REDUCED_MERGED, -1, -1, -1, guca_US_BAT23, gsa_FineGains
   }, /* 13 */

    /* Framing mode 3, Interleaved Path, LS0 active */
    /* Rf=0; Ri = 16; S=2; D=1; N = 14 */
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {16, 0}, {2, -1}, {-1, -1}, {-1, -1}, {1, -1},
      {{0, 0, 0, 0, 14, 0, 0},{0, 0, 0, 0, 0, 0, 0}},
      REDUCED_MERGED, -1, -1, -1, guca_US_BAT23, gsa_FineGains
   }, /* 14 */

    /* ====================== */
    /* Down stream  */
    /* ====================== */

    //Framing mode 0, Fast Path AS0, LS0 ( = 'C' Channel);
    //Rf = 4, Ri=0, S=4, D=16, N,AS0 = 60; N,LS0 = 255 (indicates 'C' channel)
    //{4, 4, 4, 16, 56, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, FULL_ASYNC, gsa_DS_BAT68, gsa_FineGains},  /* 15 */
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {0, 4}, {4, -1}, {-1, -1}, {-1, -1}, {16, -1},
      {{0, 0, 0, 0, 0, 0, 0},{60, 0, 0, 0, 255, 0, 0}},
      FULL_ASYNC, -1, -1, -1, guca_DS_BAT68, gsa_FineGains
   }, /* 15 */

    /* to generate test vectors with data on only one path, eg. fast path */
    //Framing mode 1, Interleaved Path, AS0, AS1 active
    //Rf = 0, Ri=16, S=2, D=8, N, AS0 = 30, N, AS1 = 26
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {16, 0}, {2, -1}, {-1, -1}, {-1, -1}, {8, -1},
      {{30, 26, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}},
      FULL_SYNC, -1, -1, -1, guca_DS_BAT68, gsa_FineGains
   }, /* 16 */

    /* ====================== */
    /* Up stream  */
    /* ====================== */

    /* to generate test vectors with data on only one path, eg. fast path */
    //Framing mode 0, Fast Path, LS2;
    //Rf = 4; Ri=0; S=8; D=8; N,LS2 = 16
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {0, 4}, {8, -1}, {-1, -1}, {-1, -1}, {8, -1},
      {{0, 0, 0, 0, 0, 0, 0},{0, 0, 16, 0, 0, 0, 0}},
      FULL_ASYNC, -1, -1, -1, guca_US_BAT23, gsa_FineGains
   }, /* 17 */

    /* Framing mode 0, Fast Path, LS2;  */
    /* Rf = 4; Ri=0; S=8; D=8; N,LS2 = 16 */
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {0, 4}, {8, -1}, {-1, -1}, {-1, -1}, {8, -1},
      {{0, 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 16}},
      FULL_ASYNC, -1, -1, -1, guca_US_BAT23, gsa_FineGains
   }, /* 18 */

    /* Framing mode 1, Interleaved Path, LS1 */
    /* Rf=0, Ri = 8, S=4, D=8, N,LS1 = 18 */
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {8, 0}, {4, -1}, {-1, -1}, {-1, -1}, {8, -1},
      {{0, 18, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}},
      FULL_SYNC, -1, -1, -1, guca_US_BAT23, gsa_FineGains
   }, /* 19 */

    /* Framing mode 1,Interleaved Path, LS1 */
    /* Rf=0, Ri = 8, S=4, D=8, N,LS1 = 18 */
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {8, 0}, {4, -1}, {-1, -1}, {-1, -1}, {8, -1},
      {{0, 0, 0, 0, 0, 18, 0},{0, 0, 0, 0, 0, 0, 0}},
      FULL_SYNC, -1, -1, -1, guca_US_BAT23, gsa_FineGains
   }, /* 20 */

   // New showtime test configurations

   //Down-stream
   /* Framing mode 2, Interleaved Path, AS0 active, TCM on */
   /* Rf=16, Ri=16, S=16, D=64, payload = 12 */
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {16, 16}, {16, -1}, {-1, -1}, {-1, -1}, {64, -1},
      {{12, 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}},
      REDUCED_SEPARATE, -1, -1, -1, guca_DS_BAT31_TCM_ON, gsa_FineGains
   }, /* 21 */

   //Up-stream
   /* Framing mode 2, Interleaved Path, LS0 active, TCM on */
   /* Rf=16, Ri=16, S=16, D=8, payload = 11 */
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {16, 16}, {16, -1}, {-1, -1}, {-1, -1}, {8, -1},
      {{11, 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}},
      REDUCED_SEPARATE, -1, -1, -1, guca_US_BAT30_TCM_ON, gsa_FineGains
   }, /* 22 */

   //Down-stream
   /* Framing mode 3, Fast Path, AS0 active, TCM off */
   /* Rf=0, Ri=0, S=1, D=1, payload = 254 */
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {0, 0}, {1, -1}, {-1, -1}, {-1, -1}, {1, -1},
      {{0, 0, 0, 0, 0, 0, 0},{254, 0, 0, 0, 0, 0, 0}},
      REDUCED_MERGED, -1, -1, -1, guca_DS_BAT255, gsa_FineGains
   }, /* 23 */

   //Up-stream
   /* Framing mode 3, Fast Path, LS0 active, TCM off */
   /* Rf=0, Ri=0, S=1, D=1, payload = 47 */
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {0, 0}, {1, -1}, {-1, -1}, {-1, -1}, {1, -1},
      {{0, 0, 0, 0, 0, 0, 0},{47, 0, 0, 0, 0, 0, 0}},
      REDUCED_MERGED, -1, -1, -1, guca_US_BAT48, gsa_FineGains
   }, /* 24 */

   //Down-stream
   /* Framing mode 0, Fast Path, AS0 active, TCM on */
   /* Rf=8, Ri=0, S=4, D=2, payload = 19 */
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {0, 8}, {4, -1}, {-1, -1}, {-1, -1}, {2, -1},
      {{0, 0, 0, 0, 0, 0, 0},{19, 0, 0, 0, 0, 0, 0}},
      FULL_ASYNC, -1, -1, -1, guca_DS_BAT31_TCM_ON, gsa_FineGains
   }, /* 25 */

   //Up-stream
   /* Framing mode 0, Fast Path, LS0 active, TCM on */
   /* Rf=14, Ri=12, S=4, D=4, payload = 10 */
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {12, 14}, {4, -1}, {-1, -1}, {-1, -1}, {4, -1},
      {{0, 0, 0, 0, 0, 0, 0},{10, 0, 0, 0, 0, 0, 0}},
      FULL_ASYNC, -1, -1, -1, guca_US_BAT30_TCM_ON, gsa_FineGains
   }, /* 26 */

   //Down-stream
   /* Framing mode 1, Fast Path, AS0 active, TCM off */
   /* Rf=0, Ri=0, S=2, D=4, payload = 1 */
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {0, 0}, {2, -1}, {-1, -1}, {-1, -1}, {4, -1},
      {{0, 0, 0, 0, 0, 0, 0},{1, 0, 0, 0, 0, 0, 0}},
      FULL_SYNC, -1, -1, -1, guca_DS_BAT5, gsa_FineGains
   }, /* 27 */

   //Up-stream
   /* Framing mode 1, Fast Path, LS0 active, TCM off */
   /* Rf=8, Ri=10, S=2, D=2, payload = 1 */
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {10, 8}, {2, -1}, {-1, -1}, {-1, -1}, {2, -1},
      {{0, 0, 0, 0, 0, 0, 0},{1, 0, 0, 0, 0, 0, 0}},
      FULL_SYNC, -1, -1, -1, guca_US_BAT17, gsa_FineGains
   }, /* 28 */


    /* Up stream ======================= */
    /* Added from G992_2/shared/config.c to enable testing LITE */
   /* R=16, S=4, D=8, N=23 */
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {16, 0}, {4, -1}, {-1, -1}, {-1, -1}, {8, -1},
      {{23, 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}},
      REDUCED_MERGED, -1, -1, -1, guca_US_BAT28, gsa_FineGains
   }, /* 29 */

#ifndef ISDN
   //Up-stream (same as #28 but using interleave path instead of fast path).
   /* Framing mode 1, Interleave Path, LS0 active, TCM off */
   /* Rf=8, Ri=10, S=2, D=2, payload = 1 */
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {10, 8}, {2, -1}, {-1, -1}, {-1, -1}, {2, -1},
      {{1, 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}},
      FULL_SYNC, -1, -1, -1, guca_US_BAT17, gsa_FineGains
   }, /* 30 */

    //========================================================================
    // TEST DS for S_HALF
   //========================================================================
   //Framing mode 3, Interleaved Path, AS0 active
   //Rf =0, Ri=8, S=0, D=16, N = 283
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {16, 0}, {S_HALF, -1}, {-1, -1}, {-1, -1}, {16, -1},
      {{282, 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}},
      REDUCED_MERGED, -1, -1, -1, guca_DS_BAT299, gsa_FineGains
   }, /* 31 */

      //========================================================================
   // CONFIGURATIONS FOR TESTING G.BIS
   //========================================================================
   /* ====================== */
    /* Down stream  */
    /* ====================== */

   /* Framing mode G.BIS, LP0 Path */
   /* for latency path LP0, Rp=8, Mp = 1, Lp = 536bits, Tp = 2, Dp = 1, Bpn = 58 bytes,framing mode = don't care, set to 4, because hw uses 4 for bis, */
   /* latency path = LP1, Rp=0, Mp = 1, Lp = 8bits, Tp = 2, Dp = 1, Bpn = 0 bytes */
   {  NUM_BEARER_CHANNELS, NUM_DATA_PATHS, {8, 0}, {1, 1}, {536, 8}, {2, 2}, {1, 1},
      {{58,0,0,0,0,0,0}, {0,1,0,0,0,0,0}},
      4, LP0_DATA_PATH, -1, 0, guca_DS_BAT68, gsa_FineGains
   }, /* 32 */

   /* ====================== */
    /* Up stream  */
    /* ====================== */

   /* Framing mode G.BIS, LP0 Path */
   /* for latency path LP0,  Rp=8, Mp = 1, Lp = 176bits, Tp = 2, Dp = 1, Bpn = 13 bytes, framing mode = don't care, set to 4, because hw uses 4 for bis */
   /* latency path = LP0, Rp=0, Mp = 1, Lp = 8bits, Tp = 2, Dp = 1, Bpn = 0 bytes  */
   {  NUM_BEARER_CHANNELS, NUM_DATA_PATHS, {8, 0}, {1, 1}, {176, 8}, {2, 2}, {1, 1},
      {{13,0,0,0,0,0,0}, {0,0,0,0,0,0,0}},
      4, LP0_DATA_PATH, -1, 0, guca_US_BAT184, gsa_FineGains
   }, /* 33 */


   /* ====================== */
    /* Down stream  */
    /* ====================== */
   /* Framing mode G.BIS, LP0, LP1 Path */
   /* Nbc = 2,  Nlp = 2, MSGc = 0 */
   /* for latency path LP0, Rp=16, Mp = 2, Lp = 1744bits, Tp = 1, Dp = 64, Bpn = 100 bytes,framing mode = don't care, set to 4, because hw uses 4 for bis, */
   /* latency path = LP1, Rp=16, Mp = 16, Lp = 224bits, Tp = 2, Dp = 64, Bpn = 12 bytes */
   {  NUM_BEARER_CHANNELS, NUM_DATA_PATHS, {16, 16}, {2, 16}, {1744, 224}, {1, 2}, {64, 2},
      {{0,100,0,0,0,0,0}, {12,0,0,0,0,0,0}},
      4, LP0_DATA_PATH, -1, 0, guca_DS_BAT1968, gsa_FineGains
   }, /* 34 */

   /* ====================== */
    /* Up stream  */
    /* ====================== */

   /* Framing mode G.BIS, LP1 Path */
   /* Nbc = 2, Nlp = 2, MSGc = 0 */
    /* for latency path LP0,  Rp=8, Mp = 8, Lp = 20bits, Tp = 2, Dp = 8, Bpn = 20 bytes, framing mode = don't care, set to 4, because hw uses 4 for bis */
   /* latency path = LP0, Rp=4, Mp = 1, Lp = 46bits, Tp = 1, Dp = 2, Bpn = 43 bytes  */
   {  NUM_BEARER_CHANNELS, NUM_DATA_PATHS, {16, 4}, {8, 1}, {20, 46}, {2, 1}, {8, 2},
      {{0,20,0,0,0,0,0}, {43,0,0,0,0,0,0}},
      4, LP1_DATA_PATH, -1, 0, guca_US_BAT66, gsa_FineGains
   }, /* 35 */

   /* ====================== */
    /* Down stream  */
    /* ====================== */
   /* Framing mode G.BIS, LP0 Path */
   /* for latency path LP0, Rp = 8, Mp = 1, Lp = 544bits, Tp = 1, Dp = 1, Bpn = 70 bytes,framing mode = don't care, set to 4, because hw uses 4 for bis, */
   /* for latency path LP1, Rp = 0, Mp = 1, Lp = 0bits, Tp = 1, Dp = 1, Bpn = 0 bytes */
   {  1, 1, {8, 0}, {1, 1}, {544, 0}, {1, 1}, {1, 1},
      {{70,0,0,0,0,0,0}, {0,0,0,0,0,0,0}},
      4, LP0_DATA_PATH, -1, 8, guca_DS_BAT68, gsa_FineGains
   }, /* 36 */

   /* ====================== */
    /* Up stream  */
    /* ====================== */
   /* Framing mode G.BIS, LP0 Path */
   /* for latency path LP0, Rp = 8, Mp = 1, Lp = 184bits, Tp = 1, Dp = 1, Bpn = 20 bytes, framing mode = don't care, set to 4, because hw uses 4 for bis */
   /* for latency path LP1, Rp = 0, Mp = 1, Lp = 0bits, Tp = 1, Dp = 1, Bpn = 0 bytes  */
   {  1, 1, {8, 0}, {1, 1}, {184, 0}, {1, 1}, {1, 1},
      {{20,0,0,0,0,0,0}, {0,0,0,0,0,0,0}},
      4, LP0_DATA_PATH, -1, 8, guca_US_BAT184, gsa_FineGains
   }, /* 37 */

   /* ====================== */
    /* Down stream  */
    /* ====================== */
   /* Framing mode G.BIS, LP0 Path */
   /* for latency path LP0, Rp = 0, Mp = 1, Lp = 424bits, Tp = 1, Dp = 1, Bpn = 52 bytes,framing mode = don't care, set to 4, because hw uses 4 for bis, */
   /* for latency path LP1, Rp = 0, Mp = 1, Lp = 120bits, Tp = 2, Dp = 1, Bpn = 14 bytes */
   {  NUM_BEARER_CHANNELS, NUM_DATA_PATHS, {0, 0}, {1, 1}, {424, 120}, {1, 2}, {1, 1},
      {{52,0,0,0,0,0,0}, {0,14,0,0,0,0,0}},
      4, LP0_DATA_PATH, -1, 8, guca_DS_BAT68, gsa_FineGains
   }, /* 38 */

   /* ====================== */
    /* Up stream  */
    /* ====================== */
   /* Framing mode G.BIS, LP0 Path */
   /* for latency path LP0, Rp = 0, Mp = 1, Lp = 144bits, Tp = 2, Dp = 1, Bpn = 17 bytes, framing mode = don't care, set to 4, because hw uses 4 for bis */
   /* for latency path LP1, Rp = 0, Mp = 1, Lp = 40bits, Tp = 1, Dp = 1, Bpn = 4 bytes  */
   {  NUM_BEARER_CHANNELS, NUM_DATA_PATHS, {0, 0}, {1, 1}, {144, 40}, {2, 1}, {1, 1},
      {{17,0,0,0,0,0,0}, {0,4,0,0,0,0,0}},
      4, LP0_DATA_PATH, -1, 8, guca_US_BAT184, gsa_FineGains
   }, /* 39 */

   /* ====================== */
    /* Down stream  */
    /* ====================== */
   /* Framing mode G.BIS, LP0 Path */
   /* for latency path LP0, Rp = 8, Mp = 1, Lp = 536bits, Tp = 16, Dp = 16, Bpn = 44 bytes,framing mode = don't care, set to 4, because hw uses 4 for bis, */
   /* for latency path LP1, Rp = 0, Mp = 1, Lp = 8bits, Tp = 1, Dp = 1, Bpn = 14 bytes */
   {  NUM_BEARER_CHANNELS, NUM_DATA_PATHS, {8, 0}, {1, 1}, {536, 8}, {16, 1}, {16, 1},
      {{44,14,0,0,0,0,0}, {0,0,0,0,0,0,0}},
      4, LP1_DATA_PATH, -1, 8, guca_DS_BAT68, gsa_FineGains
   }, /* 40 */

   /* ====================== */
    /* Up stream  */
    /* ====================== */
   /* Framing mode G.BIS, LP0 Path */
   /* for latency path LP0, Rp = 8, Mp = 1, Lp = 176bits, Tp = 16, Dp = 8, Bpn = 9 bytes, framing mode = don't care, set to 4, because hw uses 4 for bis */
   /* for latency path LP1, Rp = 0, Mp = 1, Lp = 8bits, Tp = 1, Dp = 1, Bpn = 4 bytes  */
   {  NUM_BEARER_CHANNELS, NUM_DATA_PATHS, {8, 0}, {1, 1}, {176, 8}, {16, 1}, {8, 1},
      {{9,4,0,0,0,0,0}, {0,0,0,0,0,0,0}},
      4, LP1_DATA_PATH, -1, 8, guca_US_BAT184, gsa_FineGains
   }, /* 41 */

   /* ====================== */
    /* Down stream  */
    /* ====================== */
   /* Framing mode G.BIS, LP0 Path */
   /* for latency path LP0, Rp = 16, Mp = 2, Lp = 421bits, Tp = 4, Dp = 32, Bpn = 61 bytes,framing mode = don't care, set to 4, because hw uses 4 for bis, */
   /* for latency path LP1, Rp = 8, Mp = 1, Lp = 123bits, Tp = 1, Dp = 1, Bpn = 20 bytes */
   {  NUM_BEARER_CHANNELS, NUM_DATA_PATHS, {16, 8}, {2, 1}, {421, 123}, {4, 1}, {32, 1},
      {{61,0,0,0,0,0,0}, {0,20,0,0,0,0,0}},
      4, LP0_DATA_PATH, -1, 8, guca_DS_BAT68, gsa_FineGains
   }, /* 42 */

   /* ====================== */
    /* Up stream  */
    /* ====================== */
   /* Framing mode G.BIS, LP0 Path */
   /* for latency path LP0, Rp = 8, Mp = 4, Lp = 139bits, Tp = 1, Dp = 8, Bpn = 20 bytes, framing mode = don't care, set to 4, because hw uses 4 for bis */
   /* for latency path LP1, Rp = 8, Mp = 1, Lp = 45bits, Tp = 4, Dp = 1, Bpn = 9 bytes  */
   {  NUM_BEARER_CHANNELS, NUM_DATA_PATHS, {8, 8}, {4, 1}, {139, 45}, {1, 4}, {8, 1},
      {{20,0,0,0,0,0,0}, {0,9,0,0,0,0,0}},
      4, LP0_DATA_PATH, -1, 8, guca_US_BAT184, gsa_FineGains
   }, /* 43 */

   /* ====================== */
    /* Down stream  */
    /* ====================== */
   /* Framing mode G.BIS, LP0 Path */
   /* for latency path LP0, Rp = 8, Mp = 4, Lp = 191bits, Tp = 4, Dp = 16, Bpn = 9 bytes,framing mode = don't care, set to 4, because hw uses 4 for bis, */
   /* for latency path LP1, Rp = 16, Mp = 1, Lp = 353bits, Tp = 2, Dp = 1, Bpn = 21 bytes */
   {  NUM_BEARER_CHANNELS, NUM_DATA_PATHS, {8, 16}, {4, 1}, {191, 353}, {4, 2}, {16, 1},
      {{9,0,0,0,0,0,0}, {0,21,0,0,0,0,0}},
      4, LP0_DATA_PATH, -1, 8, guca_DS_BAT68, gsa_FineGains
   }, /* 44 */

   /* ====================== */
    /* Up stream  */
    /* ====================== */
   /* Framing mode G.BIS, LP0 Path */
   /* for latency path LP0, Rp = 4, Mp = 2, Lp = 125bits, Tp = 2, Dp = 4, Bpn = 7 bytes, framing mode = don't care, set to 4, because hw uses 4 for bis */
   /* for latency path LP1, Rp = 0, Mp = 1, Lp = 59bits, Tp = 2, Dp = 1, Bpn = 3 bytes  */
   {  NUM_BEARER_CHANNELS, NUM_DATA_PATHS, {4, 0}, {2, 1}, {125, 59}, {2, 2}, {4, 1},
      {{7,0,0,0,0,0,0}, {0,3,0,0,0,0,0}},
      4, LP0_DATA_PATH, -1, 8, guca_US_BAT184, gsa_FineGains
   }, /* 45 */

   /* ====================== */
    /* Down stream  */
    /* ====================== */
   /* Framing mode G.BIS, LP0 Path */
   /* for latency path LP0, Rp = 0, Mp = 1, Lp = 392bits, Tp = 1, Dp = 1, Bpn = 48 bytes,framing mode = don't care, set to 4, because hw uses 4 for bis, */
   /* for latency path LP1, Rp = 0, Mp = 1, Lp = 152bits, Tp = 1, Dp = 1, Bpn = 18 bytes */
   {  NUM_BEARER_CHANNELS, NUM_DATA_PATHS, {0, 0}, {1, 1}, {392, 152}, {1, 1}, {1, 1},
      {{48,0,0,0,0,0,0}, {0,18,0,0,0,0,0}},
      4, LP0_DATA_PATH, -1, 8, guca_DS_BAT68, gsa_FineGains
   }, /* 46 */

   /* ====================== */
    /* Up stream  */
    /* ====================== */
   /* Framing mode G.BIS, LP0 Path */
   /* for latency path LP0, Rp = 0, Mp = 1, Lp = 120bits, Tp = 1, Dp = 1, Bpn = 14 bytes, framing mode = don't care, set to 4, because hw uses 4 for bis */
   /* for latency path LP1, Rp = 0, Mp = 1, Lp = 64bits, Tp = 1, Dp = 1, Bpn = 7 bytes  */
   {  NUM_BEARER_CHANNELS, NUM_DATA_PATHS, {0, 0}, {1, 1}, {120, 64}, {1, 1}, {1, 1},
      {{14,0,0,0,0,0,0}, {0,7,0,0,0,0,0}},
      4, LP0_DATA_PATH, -1, 8, guca_US_BAT184, gsa_FineGains
   }, /* 47 */
#endif //#ifndef ISDN
};

/* ======================================================================== */
/*  The following arrays are used to simulate an external source  */
/*  requesting a sync control action, so that the robbing and  */
/*  stuffing mechanism may be tested. */
/* ======================================================================== */

/*  gsa_FramesPerSyncAction[] defines the rate at which sync control frames  */
/*  will be requested, sorted by bearer channels.  Only used to simulate an  */
/*  external source requesting a sync control action */
int16 gsa_FramesPerSyncAction[NUM_US_BEARER_CHANNELS]   = {2, 0, 5};

/*  gsa_SyncActionCount[] containes the number of user data frames before a  */
/*  sync control action will be requested, sorted by bearer channels.  Only  */
/*  used to simulate an external source requesting a sync control action */
int16 gsa_SyncActionCount[NUM_US_BEARER_CHANNELS]       = {2, 0, 5};

/*  gsa_SyncActionReq[] contains the number of sync control actions pending,  */
/*  sorted by bearer channels.  Only used to simulate an external source  */
/*  requesting a sync control action */
int16 gsa_SyncActionReq[NUM_US_BEARER_CHANNELS]         = {0, 0, 0};

/*  gsa_SyncActionType[] defines the type of sync control action that is  */
/*  requested (ROB or STUFF), sorted by bearer channels.  Only used to  */
/*  simulate an external source requesting a sync control action */
int16 gsa_SyncActionType[NUM_US_BEARER_CHANNELS]        = {ROB, 0, STUFF};
