/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *-------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   detect.c
 *
 *   detect tone etc
 *
 *-------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_tones.h"
#include "dsp_op.h"
#include "dsp_op2.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "ec_data.h"
#include "ghs.h"
#include "cmv.h"
#include "vecpwr.h"
#include "detect.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : DetectReverbSegue
 *
 *  Description:    Detects whether the input signal is more likely a
 * R_Reverb or R_Segue symbol.
 *
 *  Prototype:  int16 DetectReverbSegue (int16 *psa_Bins,
 *                                      int16 *psa_PNSeq,
 *                                      int16 s_num_bins,
 *                            int16 *ps_num_reverb_matches,
 *                            int16 *ps_num_segue_matches);
 *
 *  Input Arguments:
 *    int16 *psa_Bins         - input aray of bins to be used for Reverb Segue Detection
 *      uint16 *psa_PNSeq     - input array of psuedo random sequence correspoding to
 *                                the bins specified by psa_Bins array in the same order
 *      int16 s_num_bins        - number of bins examined during detection
 *
 *  Output Arguments:
 *      int16 *ps_num_reverb_matches   - number of bins that match reverb
 *      int16 *ps_num_segue_matches    - number of bins that match segue
 *    Here the detection logic decides if the input signal (gsa_RxToneBuf) is REVERB or SEGUE or NEITHER
 *    Hence, if we intend to use the output arguments for Reverb Segue Detection; the calling function
 *    needs to decide if the input signal was a REVERB/SEGUE/NEITHER based on the number of matches
 *
 *  Return:
 *          int16 s_ToneType
 *                              =  0, R_Reverb detected
 *                              =  1, R_Segue detected
 *    Here the detection logic decides if the input signal (gsa_RxToneBuf) is REVERB or SEGUE
 *    Hence, if we intend to use the return value for Reverb Segue Detection; the assumption
 *    is that the input signal (gsa_RxToneBuf) is always REVERB or SEGUE
 *
 *  Global Variables Used:
 *      gsa_RxToneBuf[]       - (I) output of FDQ, compare with PN sequence
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

int16 DetectReverbSegue(int16 *psa_Bins,
                  int16 *psa_PNSeq,
                  int16 s_num_bins,
                  int16 *ps_num_reverb_matches,
                  int16 *ps_num_segue_matches)
{
    int16 s_ReverbMatches = 0, s_ToneType = 0;
    int  i, x, y;
    uint16 us_datum = 0, quadrant, us_XOR1, us_XOR2;

   /* initializations */
   if (ps_num_reverb_matches != NULL) *ps_num_reverb_matches = 0;
   if (ps_num_segue_matches != NULL) *ps_num_segue_matches = 0;

    /*  Examine each frequency bin  */
    for (i = 0; i < s_num_bins; i++)
   {
      /* get new word from pn sequence array if necessary */
        if ((i&0x7) == 0)
      {
            us_datum = *psa_PNSeq++;
        }

        /*  Get next 2 bits from psuedo random sequence */
      quadrant = us_datum & 0x3;

        /*  Get the signal value from Rx Tone Buf */
      x = gsa_RxToneBuf[(*psa_Bins)<<1];
      y = gsa_RxToneBuf[((*psa_Bins)<<1)+1];

      // NOTE
        // if us_datum & 0x3 == 0,   R_Reverb is + + (real complex)
        // if us_datum & 0x3 == 1,   R_Reverb is - +
        // if us_datum & 0x3 == 2,   R_Reverb is + -
        // if us_datum & 0x3 == 3,   R_Reverb is - -

      //REVERB,SEGUE,NEITHER DETECTION
      // Reverb detection
      // // XDSLRTFW-416 : Enhancement_ALL_BisPLus_ALL_L2 (START)
      if ((ps_num_reverb_matches != NULL) & (ps_num_segue_matches != NULL))
      {
         us_XOR1 = (us_datum & 0x1);            // Equals 1 if Segue real component is +, else 0.
         us_XOR2 = ((us_datum & 0x2) >> 1);     // Equals 1 if Segue imag component is +, else 0.

         x = ((x & 0x8000)>>15);
         y = ((y & 0x8000)>>15);

         if ((x ^ us_XOR1) && (y ^ us_XOR2))
            (*ps_num_segue_matches)++;

         us_XOR1 = (us_XOR1) ^ 1;         // Equals 1 if Reverb real component is +, else 0.
         us_XOR2 = (us_XOR2) ^ 1;         // Equals 1 if Reverb imag component is +, else 0.

         if ((x ^ us_XOR1) && (y ^ us_XOR2))
            (*ps_num_reverb_matches)++;
      }
      else
      {
         //REVERB or SEGUE DETECTION
         if (quadrant == 0) {
            /* Declare (+,+) if y > -x. */
            if ( (int32)y+(int32)x > 0 )
               s_ReverbMatches++;

         } else if (quadrant == 1) {
            /* Declare (-,+) if y > x. */
            if ( (int32)y-(int32)x > 0 )
               s_ReverbMatches++;

         } else if (quadrant == 2) {
            /* Declare (+,-) if y < x. */
            if ( (int32)y-(int32)x < 0 )
               s_ReverbMatches++;

         } else { /* quadrant 3 */
            /* Declare (-,-) if y < -x. */
            if ( (int32)y+(int32)x < 0 )
               s_ReverbMatches++;
         }

      }
      // XDSLRTFW-416 : Enhancement_ALL_BisPLus_ALL_L2 (END)

      /* update bin for next iteration */
      psa_Bins++;
      /* update pn sequence for next iteration */
      us_datum >>= 2;
    }

    /*  determine which signal detected */
    if (s_ReverbMatches > (s_num_bins >> 1))
      s_ToneType = 0; /* Decide R_Reverb */
    else
      s_ToneType = 1; /* Decide R_Segue  */

    return s_ToneType;
}
