/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   fft_bg.c
 *
 *   Functions for performing an FFT from a background task
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "compiler.h"
#include "gdata.h"
#include "fifo.h"
#include "pll.h"

#ifndef USE_ENGINE_FOR_BG_FFTS
   #include "fft.h"
#endif

/* =============================================== */
/* global variable declarations */
/* =============================================== */

/* =============================================== */
/* static variable declarations */
/* =============================================== */
#ifdef HERCULES_ADSL_CPE
extern int16 gsa_EngineFFTInput_Plus[] ;
#endif

// Task layer (background)
C_SCOPE void BgFftReal(int16* psa_inbuf, int16 *psa_outbuf, int16 s_fftn, int16 s_log2n)
{
#ifdef USE_ENGINE_FOR_BG_FFTS

   // Use DSL engine (probably hardware) to calculate an FFT.

   // Set FFT parameters.
   gft_EngineFFT_Done = 0;    // Reset flag that signals completion.

#ifdef HERCULES_ADSL_CPE
   if (s_fftn==512) // Plus needs input interpolated by 2
   {
      memset(gsa_EngineFFTInput_Plus, 0, sizeof(int16)*2048);
      p_dest = gsa_EngineFFTInput_Plus ;
      p_src = psa_inbuf ;
      for (i=0 ; i<1024; i++) {
         *p_dest++ = *p_src++ ;
         p_dest++ ;  // leave a zero in between
      }
      gpsa_EngineFFTInput  = gsa_EngineFFTInput_Plus ;
   }
   else
#endif
      gpsa_EngineFFTInput = psa_inbuf;


   gpsa_EngineFFTOutput = psa_outbuf;
   gs_EngineFFTSize = s_fftn;       // Size of FFT output. Either (128/LitE) or 256 or 512

   // Initialize foreground state machine.
   gs_EngineFFT_Substate = 0;

   // Set flag that signals foreground to run EngineFFT state machine.
   gft_StartEngineFFT = 1;

   // Wait for foreground state machine to signal completion.
   while (!gft_EngineFFT_Done)
      ;
#else

   FftReal(psa_inbuf, psa_outbuf, s_fftn, s_log2n);
#endif

}

#ifdef USE_ENGINE_FOR_BG_FFTS

#define ENGINE_FFT_INIT    0
#define ENGINE_FFT_RUN     1
#define ENGINE_FFT_RESTORE_1  2
#define ENGINE_FFT_RESTORE_2  3

// Task-layer state machine for setting up hardware-assisted FFT
C_SCOPE void EngineFFT_StateMachine(void)
{
   static FlagT ft_EnablePll, ft_DDPilot, ft_CopyRxBuffer, ft_DisableGetRxTones, ft_fdqState;

   if(gs_EngineFFT_Substate == ENGINE_FFT_INIT)
   {

      // Save current state.

         ft_EnablePll = gft_EnablePLL;
         ft_DDPilot = gft_DDPilot;
         ft_CopyRxBuffer = gft_CopyRxBuffer;
         ft_DisableGetRxTones = gft_DisableGetRxTones;
         ft_fdqState = gft_fdqState;

      // Turn off copying of Rx Tone buffer.
         gft_CopyRxBuffer = FALSE;

      // Turn off PLL
         gft_EnablePLL = FALSE;
         gft_DDPilot = DD_PILOT_OFF;   //so that DisableFDQ() disables FDQ over pilot tone
                              //NOTE: The s/w copy of FDQ coefs should be SAME as h/w
                              //copy since we need to re-Load FDQ coefs @ end of BgFFT


         gft_LoadEngineFFTInput = TRUE;
         gft_GetEngineFFTOutput = FALSE;
         gft_GetEngineFFTOutputDone = FALSE;

      // Move interrupt to Rx frame start.
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,MoveToFrameStartInt);
      // Disable FDQ, if currently enabled
         if(gft_fdqState == FDQ_ENABLED)
         {
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,DisableFDQ);
         }
         gs_EngineFFT_Substate = ENGINE_FFT_RUN;
   }
   else if(gs_EngineFFT_Substate == ENGINE_FFT_RUN)
   {
#ifndef HERCULES_ADSL_CPE
         gt_TaskArray[RX_FDQ_DONE].NonTimeCriticalTask = NULL;
#else
         gt_TaskArray[RX_QAM_DONE].NonTimeCriticalTask = NULL;
#endif
         gs_EngineFFT_Substate = ENGINE_FFT_RESTORE_1;
   }
   else if(gs_EngineFFT_Substate == ENGINE_FFT_RESTORE_1)
   {
         if(ft_DisableGetRxTones == FALSE)  /* FDQ_DONE interrupt only */
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,MoveToFdqDoneInt);

         // FDQ had been disabled during Bg FFT, Load FDQ if required
         if(ft_fdqState == FDQ_ENABLED)
         {
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadFDQ);
         }

         gs_EngineFFT_Substate = ENGINE_FFT_RESTORE_2;
   }
   else if(gs_EngineFFT_Substate == ENGINE_FFT_RESTORE_2)
   {
         if(ft_DisableGetRxTones == FALSE)  /* FDQ_DONE interrupt only */
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,EnableFDQDoneNTC_EnableGetRxTones);
         if (gft_GetEngineFFTOutputDone == TRUE)
         {
            gft_GetEngineFFTOutputDone = FALSE;

            gft_EnablePLL = ft_EnablePll;
            gft_DDPilot = ft_DDPilot;
            gft_CopyRxBuffer = ft_CopyRxBuffer;

            gft_EngineFFT_Done = 1; // Signal FFT completion to background task.
            gft_StartEngineFFT = 0; // Exit this state machine.
         }
   }
}

#endif
