/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  fft_tab.c
;
;  This file contains tables used for a fixed-point implementation of
;  the Fast Fourier Transform (FFT) and the inverse FFT
;  (IFFT) using the radix-2 Decimation In Frequency (DIF) algorithm.
;
;***************************************************************************/

#include "ifft_fix.h"
#include "data_alloc.h"

/* ===============FFT Tables for 256 tones==================== */

// The below buffers are mapped to commonTwidMemory */
/*int16 gsa_twid_real256[N256/4];
int16 gsa_twid_imag256[N256/4];

int16 gsa_sk_tab256[N256/4+1];
int16 gsa_bit_reverse_idx256[N256/2]; */

int16 *gsa_twid_real256;
int16 *gsa_twid_imag256;

int16 *gsa_sk_tab256;
int16 *gsa_bit_reverse_idx256;

DATA_MAP_deILV2_BIS
int16 gsa_CommonTwidMem[1762] =

   {
/* gsa_twid_real[k] = cos(2*pi*k/(N/2)) for k=0,1,...,N/4 */
32767,
32766,
32758,
32746,
32729,
32706,
32679,
32647,
32610,
32568,
32522,
32470,
32413,
32352,
32286,
32214,
32138,
32058,
31972,
31881,
31786,
31686,
31581,
31471,
31357,
31238,
31114,
30986,
30853,
30715,
30572,
30425,
30274,
30118,
29957,
29792,
29622,
29448,
29269,
29086,
28899,
28707,
28511,
28311,
28106,
27897,
27684,
27467,
27246,
27020,
26791,
26557,
26320,
26078,
25833,
25583,
25330,
25073,
24812,
24548,
24279,
24008,
23732,
23453,
23170,
22884,
22595,
22302,
22006,
21706,
21403,
21097,
20788,
20475,
20160,
19841,
19520,
19195,
18868,
18538,
18205,
17869,
17531,
17190,
16846,
16500,
16151,
15800,
15447,
15091,
14733,
14373,
14010,
13646,
13279,
12910,
12540,
12167,
11793,
11417,
11039,
10660,
10279,
9896 ,
9512 ,
9127 ,
8740 ,
8351 ,
7962 ,
7571 ,
7180 ,
6787 ,
6393 ,
5998 ,
5602 ,
5205 ,
4808 ,
4410 ,
4011 ,
3612 ,
3212 ,
2811 ,
2411 ,
2009 ,
1608 ,
1206 ,
804  ,
402  ,
0    ,
-402 ,
-804 ,
-1206,
-1608,
-2009,
-2411,
-2811,
-3212,
-3612,
-4011,
-4410,
-4808,
-5205,
-5602,
-5998,
-6393,
-6787,
-7180,
-7571,
-7962,
-8351,
-8740,
-9127,
-9512,
-9896,
-10279,
-10660,
-11039,
-11417,
-11793,
-12167,
-12540,
-12910,
-13279,
-13646,
-14010,
-14373,
-14733,
-15091,
-15447,
-15800,
-16151,
-16500,
-16846,
-17190,
-17531,
-17869,
-18205,
-18538,
-18868,
-19195,
-19520,
-19841,
-20160,
-20475,
-20788,
-21097,
-21403,
-21706,
-22006,
-22302,
-22595,
-22884,
-23170,
-23453,
-23732,
-24008,
-24279,
-24548,
-24812,
-25073,
-25330,
-25583,
-25833,
-26078,
-26320,
-26557,
-26791,
-27020,
-27246,
-27467,
-27684,
-27897,
-28106,
-28311,
-28511,
-28707,
-28899,
-29086,
-29269,
-29448,
-29622,
-29792,
-29957,
-30118,
-30274,
-30425,
-30572,
-30715,
-30853,
-30986,
-31114,
-31238,
-31357,
-31471,
-31581,
-31686,
-31786,
-31881,
-31972,
-32058,
-32138,
-32214,
-32286,
-32352,
-32413,
-32470,
-32522,
-32568,
-32610,
-32647,
-32679,
-32706,
-32729,
-32746,
-32758,
-32766,  /* } */

/* gsa_twid_imag[k] = sin(2*pi*k/(N/2)) for k=0,1,...,N/4 */
   /*{ */

-0       ,
-402     ,
-804     ,
-1206    ,
-1608    ,
-2009    ,
-2411    ,
-2811    ,
-3212    ,
-3612    ,
-4011    ,
-4410    ,
-4808    ,
-5205    ,
-5602    ,
-5998    ,
-6393    ,
-6787    ,
-7180    ,
-7571    ,
-7962    ,
-8351    ,
-8740    ,
-9127    ,
-9512    ,
-9896    ,
-10279   ,
-10660   ,
-11039   ,
-11417   ,
-11793   ,
-12167   ,
-12540   ,
-12910   ,
-13279   ,
-13646   ,
-14010   ,
-14373   ,
-14733   ,
-15091   ,
-15447   ,
-15800   ,
-16151   ,
-16500   ,
-16846   ,
-17190   ,
-17531   ,
-17869   ,
-18205   ,
-18538   ,
-18868   ,
-19195   ,
-19520   ,
-19841   ,
-20160   ,
-20475   ,
-20788   ,
-21097   ,
-21403   ,
-21706   ,
-22006   ,
-22302   ,
-22595   ,
-22884   ,
-23170   ,
-23453   ,
-23732   ,
-24008   ,
-24279   ,
-24548   ,
-24812   ,
-25073   ,
-25330   ,
-25583   ,
-25833   ,
-26078   ,
-26320   ,
-26557   ,
-26791   ,
-27020   ,
-27246   ,
-27467   ,
-27684   ,
-27897   ,
-28106   ,
-28311   ,
-28511   ,
-28707   ,
-28899   ,
-29086   ,
-29269   ,
-29448   ,
-29622   ,
-29792   ,
-29957   ,
-30118   ,
-30274   ,
-30425   ,
-30572   ,
-30715   ,
-30853   ,
-30986   ,
-31114   ,
-31238   ,
-31357   ,
-31471   ,
-31581   ,
-31686   ,
-31786   ,
-31881   ,
-31972   ,
-32058   ,
-32138   ,
-32214   ,
-32286   ,
-32352   ,
-32413   ,
-32470   ,
-32522   ,
-32568   ,
-32610   ,
-32647   ,
-32679   ,
-32706   ,
-32729   ,
-32746   ,
-32758   ,
-32766   ,
-32768   ,
-32766   ,
-32758   ,
-32746   ,
-32729   ,
-32706   ,
-32679   ,
-32647   ,
-32610   ,
-32568   ,
-32522   ,
-32470   ,
-32413   ,
-32352   ,
-32286   ,
-32214   ,
-32138   ,
-32058   ,
-31972   ,
-31881   ,
-31786   ,
-31686   ,
-31581   ,
-31471   ,
-31357   ,
-31238   ,
-31114   ,
-30986   ,
-30853   ,
-30715   ,
-30572   ,
-30425   ,
-30274   ,
-30118   ,
-29957   ,
-29792   ,
-29622   ,
-29448   ,
-29269   ,
-29086   ,
-28899   ,
-28707   ,
-28511   ,
-28311   ,
-28106   ,
-27897   ,
-27684   ,
-27467   ,
-27246   ,
-27020   ,
-26791   ,
-26557   ,
-26320   ,
-26078   ,
-25833   ,
-25583   ,
-25330   ,
-25073   ,
-24812   ,
-24548   ,
-24279   ,
-24008   ,
-23732   ,
-23453   ,
-23170   ,
-22884   ,
-22595   ,
-22302   ,
-22006   ,
-21706   ,
-21403   ,
-21097   ,
-20788   ,
-20475   ,
-20160   ,
-19841   ,
-19520   ,
-19195   ,
-18868   ,
-18538   ,
-18205   ,
-17869   ,
-17531   ,
-17190   ,
-16846   ,
-16500   ,
-16151   ,
-15800   ,
-15447   ,
-15091   ,
-14733   ,
-14373   ,
-14010   ,
-13646   ,
-13279   ,
-12910   ,
-12540   ,
-12167   ,
-11793   ,
-11417   ,
-11039   ,
-10660   ,
-10279   ,
-9896    ,
-9512    ,
-9127    ,
-8740    ,
-8351    ,
-7962    ,
-7571    ,
-7180    ,
-6787    ,
-6393    ,
-5998    ,
-5602    ,
-5205    ,
-4808    ,
-4410    ,
-4011    ,
-3612    ,
-3212    ,
-2811    ,
-2411    ,
-2009    ,
-1608    ,
-1206    ,
-804     ,
-402,  /*} */
/* gsa_sk_tab[k] = sin(2*pi*k/N) for k=0,1,...,N/4 */
/*{ */

   0  ,
-201  ,
-402  ,
-603  ,
-804  ,
-1005 ,
-1206 ,
-1407 ,
-1608 ,
-1809 ,
-2009 ,
-2210 ,
-2411 ,
-2611 ,
-2811 ,
-3012 ,
-3212 ,
-3412 ,
-3612 ,
-3812 ,
-4011 ,
-4211 ,
-4410 ,
-4609 ,
-4808 ,
-5007 ,
-5205 ,
-5404 ,
-5602 ,
-5800 ,
-5998 ,
-6195 ,
-6393 ,
-6590 ,
-6787 ,
-6983 ,
-7180 ,
-7376 ,
-7571 ,
-7767 ,
-7962 ,
-8157 ,
-8351 ,
-8546 ,
-8740 ,
-8933 ,
-9127 ,
-9319 ,
-9512 ,
-9704 ,
-9896 ,
-10088   ,
-10279   ,
-10469   ,
-10660   ,
-10850   ,
-11039   ,
-11228   ,
-11417   ,
-11605   ,
-11793   ,
-11980   ,
-12167   ,
-12354   ,
-12540   ,
-12725   ,
-12910   ,
-13095   ,
-13279   ,
-13463   ,
-13646   ,
-13828   ,
-14010   ,
-14192   ,
-14373   ,
-14553   ,
-14733   ,
-14912   ,
-15091   ,
-15269   ,
-15447   ,
-15624   ,
-15800   ,
-15976   ,
-16151   ,
-16326   ,
-16500   ,
-16673   ,
-16846   ,
-17018   ,
-17190   ,
-17361   ,
-17531   ,
-17700   ,
-17869   ,
-18037   ,
-18205   ,
-18372   ,
-18538   ,
-18703   ,
-18868   ,
-19032   ,
-19195   ,
-19358   ,
-19520   ,
-19681   ,
-19841   ,
-20001   ,
-20160   ,
-20318   ,
-20475   ,
-20632   ,
-20788   ,
-20943   ,
-21097   ,
-21251   ,
-21403   ,
-21555   ,
-21706   ,
-21856   ,
-22006   ,
-22154   ,
-22302   ,
-22449   ,
-22595   ,
-22740   ,
-22884   ,
-23028   ,
-23170   ,
-23312   ,
-23453   ,
-23593   ,
-23732   ,
-23870   ,
-24008   ,
-24144   ,
-24279   ,
-24414   ,
-24548   ,
-24680   ,
-24812   ,
-24943   ,
-25073   ,
-25202   ,
-25330   ,
-25457   ,
-25583   ,
-25708   ,
-25833   ,
-25956   ,
-26078   ,
-26199   ,
-26320   ,
-26439   ,
-26557   ,
-26674   ,
-26791   ,
-26906   ,
-27020   ,
-27133   ,
-27246   ,
-27357   ,
-27467   ,
-27576   ,
-27684   ,
-27791   ,
-27897   ,
-28002   ,
-28106   ,
-28209   ,
-28311   ,
-28411   ,
-28511   ,
-28610   ,
-28707   ,
-28803   ,
-28899   ,
-28993   ,
-29086   ,
-29178   ,
-29269   ,
-29359   ,
-29448   ,
-29535   ,
-29622   ,
-29707   ,
-29792   ,
-29875   ,
-29957   ,
-30038   ,
-30118   ,
-30196   ,
-30274   ,
-30350   ,
-30425   ,
-30499   ,
-30572   ,
-30644   ,
-30715   ,
-30784   ,
-30853   ,
-30920   ,
-30986   ,
-31050   ,
-31114   ,
-31177   ,
-31238   ,
-31298   ,
-31357   ,
-31415   ,
-31471   ,
-31527   ,
-31581   ,
-31634   ,
-31686   ,
-31737   ,
-31786   ,
-31834   ,
-31881   ,
-31927   ,
-31972   ,
-32015   ,
-32058   ,
-32099   ,
-32138   ,
-32177   ,
-32214   ,
-32251   ,
-32286   ,
-32319   ,
-32352   ,
-32383   ,
-32413   ,
-32442   ,
-32470   ,
-32496   ,
-32522   ,
-32546   ,
-32568   ,
-32590   ,
-32610   ,
-32629   ,
-32647   ,
-32664   ,
-32679   ,
-32693   ,
-32706   ,
-32718   ,
-32729   ,
-32738   ,
-32746   ,
-32753   ,
-32758   ,
-32762   ,
-32766   ,
-32767   ,
-32767, /* } */

/* bit reversed index table for reorder FFT/IFFT output */
   /*{ */

0,
256,
128,
384,
64,
320,
192,
448,
32,
288,
160,
416,
96,
352,
224,
480,
16,
272,
144,
400,
80,
336,
208,
464,
48,
304,
176,
432,
112,
368,
240,
496,
8,
264,
136,
392,
72,
328,
200,
456,
40,
296,
168,
424,
104,
360,
232,
488,
24,
280,
152,
408,
88,
344,
216,
472,
56,
312,
184,
440,
120,
376,
248,
504,
4,
260,
132,
388,
68,
324,
196,
452,
36,
292,
164,
420,
100,
356,
228,
484,
20,
276,
148,
404,
84,
340,
212,
468,
52,
308,
180,
436,
116,
372,
244,
500,
12,
268,
140,
396,
76,
332,
204,
460,
44,
300,
172,
428,
108,
364,
236,
492,
28,
284,
156,
412,
92,
348,
220,
476,
60,
316,
188,
444,
124,
380,
252,
508,
2,
258,
130,
386,
66,
322,
194,
450,
34,
290,
162,
418,
98,
354,
226,
482,
18,
274,
146,
402,
82,
338,
210,
466,
50,
306,
178,
434,
114,
370,
242,
498,
10,
266,
138,
394,
74,
330,
202,
458,
42,
298,
170,
426,
106,
362,
234,
490,
26,
282,
154,
410,
90,
346,
218,
474,
58,
314,
186,
442,
122,
378,
250,
506,
6,
262,
134,
390,
70,
326,
198,
454,
38,
294,
166,
422,
102,
358,
230,
486,
22,
278,
150,
406,
86,
342,
214,
470,
54,
310,
182,
438,
118,
374,
246,
502,
14,
270,
142,
398,
78,
334,
206,
462,
46,
302,
174,
430,
110,
366,
238,
494,
30,
286,
158,
414,
94,
350,
222,
478,
62,
318,
190,
446,
126,
382,
254,
510,
1,
257,
129,
385,
65,
321,
193,
449,
33,
289,
161,
417,
97,
353,
225,
481,
17,
273,
145,
401,
81,
337,
209,
465,
49,
305,
177,
433,
113,
369,
241,
497,
9,
265,
137,
393,
73,
329,
201,
457,
41,
297,
169,
425,
105,
361,
233,
489,
25,
281,
153,
409,
89,
345,
217,
473,
57,
313,
185,
441,
121,
377,
249,
505,
5,
261,
133,
389,
69,
325,
197,
453,
37,
293,
165,
421,
101,
357,
229,
485,
21,
277,
149,
405,
85,
341,
213,
469,
53,
309,
181,
437,
117,
373,
245,
501,
13,
269,
141,
397,
77,
333,
205,
461,
45,
301,
173,
429,
109,
365,
237,
493,
29,
285,
157,
413,
93,
349,
221,
477,
61,
317,
189,
445,
125,
381,
253,
509,
3,
259,
131,
387,
67,
323,
195,
451,
35,
291,
163,
419,
99,
355,
227,
483,
19,
275,
147,
403,
83,
339,
211,
467,
51,
307,
179,
435,
115,
371,
243,
499,
11,
267,
139,
395,
75,
331,
203,
459,
43,
299,
171,
427,
107,
363,
235,
491,
27,
283,
155,
411,
91,
347,
219,
475,
59,
315,
187,
443,
123,
379,
251,
507,
7,
263,
135,
391,
71,
327,
199,
455,
39,
295,
167,
423,
103,
359,
231,
487,
23,
279,
151,
407,
87,
343,
215,
471,
55,
311,
183,
439,
119,
375,
247,
503,
15,
271,
143,
399,
79,
335,
207,
463,
47,
303,
175,
431,
111,
367,
239,
495,
31,
287,
159,
415,
95,
351,
223,
479,
63,
319,
191,
447,
127,
383,
255,
511

};

DATA_MAP_END //DATA_MAP_deILV2_BIS

