/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 * Aware DMT Technology. Proprietary and Condfidential
 *
 * 40 Middlesex Turnpike, Bedford, MA 01730-1413
 * Phone (781) 276-4000
 * FAX   (781) 276-4001
 *
 * FIFO.C
 *
 * Generic Routines and data structures to handle fifos of either
 * 1) Messages, such as for AOC or EOC, or
 * 2) Functions, such as for the Background Task Handler
 *
 * The reason we have separate functions instead of using a union is that sizeof(PtrToFunc)
 *  may not equal sizeof(int16)
 *----------------------------------------------------------------------------
 */

#include "fifo.h"
#include "gdata.h"
#include "xception.h"
#include "gdata_bis.h"
#include "Debugbuffer.h"

void disable1_save(uint32 *pul_stat);
void restore1_save(uint32 ul_stat);

void AddMessageToOvhdFifo(MessageOvhdFifo_t *fifo, uint8 message)
{
   int16 s_NextAvailableAfterUpdate;

   s_NextAvailableAfterUpdate = fifo->NextAvailable + 1;

   if (s_NextAvailableAfterUpdate==fifo->BufferSize)
      s_NextAvailableAfterUpdate=0;

   if (s_NextAvailableAfterUpdate == fifo->IndexOfOldest)
   {
   // KernelException(fifo->ErrorCode);
      fifo->ErrorCode = (E_CODE_OVHD_FIFO_OVERFLOW & 0xffff);
      fifo->us_OvflowCnt++;
      return; //discard the incoming message byte
   }

   fifo->ErrorCode = 0;  //clear error code

   // First add message to fifo.
   fifo->MessageBuffer[fifo->NextAvailable] = message;

   // Then indicate new message.
   fifo->NextAvailable = s_NextAvailableAfterUpdate;
}

/* returns a 1 if there is a message, returns a 0 if fifo is empty */
int16 RemoveMessageFromOvhdFifo(MessageOvhdFifo_t *fifo, uint8 *message)
{
   if (fifo->IndexOfOldest == fifo->NextAvailable)
      return 0;

   // First read message from fifo.
   *message = fifo->MessageBuffer[fifo->IndexOfOldest];

   // Then indicate message has been removed.
   if ((fifo->IndexOfOldest + 1) == fifo->BufferSize)
      fifo->IndexOfOldest=0;
   else
      fifo->IndexOfOldest++;

   return 1;
}


// Use only for background function fifo.
void AddFunctionToBkgdFifo(PtrToBkgdFunc Function)
{
   FunctionFifo_t *fifo = gp_BGTaskFifo;
   uint32 ul_int_status;
   disable1_save(&ul_int_status);

   if (fifo->FunctionBuffer[fifo->NextAvailable] != 0)   /* we have run out of space */
   {
      KernelException((int16)E_CODE_BKGDFIFO_OVERFLOW);
      fifo->ErrorCode = (E_CODE_BKGDFIFO_OVERFLOW & 0xffff);
   }
   else{
      fifo->FunctionBuffer[fifo->NextAvailable] = Function;
      fifo->NextAvailable++;
      fifo->PendingFunctionCount++;
      if (fifo->NextAvailable==fifo->BufferSize)
      {
         fifo->NextAvailable=0;
      }
   }
   restore1_save(ul_int_status);
}


/* returns a 1 if there is a Function, returns a 0 if fifo is empty */
// Use only for background function fifo.
int16 RemoveFunctionFromBkgdFifo(FunctionFifo_t *fifo, PtrToBkgdFunc *p_Function)
{
   int16 tmp;
   uint32 ul_int_status;
   disable1_save(&ul_int_status);

   if (fifo->FunctionBuffer[fifo->IndexOfOldest] == 0){
      tmp = 0;
   }
   else{
      *p_Function=fifo->FunctionBuffer[fifo->IndexOfOldest];
      fifo->FunctionBuffer[fifo->IndexOfOldest] = 0;  /* make this one null */
      fifo->IndexOfOldest++;
      fifo->PendingFunctionCount--;
      if (fifo->IndexOfOldest==fifo->BufferSize)
         fifo->IndexOfOldest=0;
      tmp = 1;
   }
   restore1_save(ul_int_status);
   return(tmp);
}



// Use only for loading function fifo.
void AddFunctionToFifo(LoadingFunctionFifo fifo, LoadingFunction Function)
{
   int16 s_ValidEntries;

#ifdef TARGET_HW
   //As a rule if we were to add a func to the Tx(Rx) loading
   //func fifo ONLY from a Tx(Rx) TC/foreground function then
   //we wouldnt need to disable interrupts here
    #ifdef ADSL_62
    uint32 ul_IntrStat;
    disable1_save(&ul_IntrStat);
    #else
   _disable1();      //disable interrupts so that we arent interrupted
                  //by a TC task that executes loading function
    #endif
#endif

   // fifo[0] contains number of valid entries in fifo[].
   // Valid entries start at index 1, i.e. fifo[1].
   s_ValidEntries = (int16) fifo[0];
   if (s_ValidEntries+1 > LOADING_FUNCTION_FIFO_SIZE)
      KernelException(LOADFUNC_FIFO_OVERFLOW);

   s_ValidEntries++;
   fifo[0] = (PtrToLoadingFunction) s_ValidEntries;
   fifo[s_ValidEntries] = Function;

#ifdef TARGET_HW
    #ifdef ADSL_62
    restore1_save(ul_IntrStat);
    #else
   _enable1();       //reenable interrupts
    #endif
#endif
}

// Use only for loading function fifo.
void ExecuteQueuedLoadingFunctions(LoadingFunctionFifo fifo)
{
   // Removes all loading functions from the fifo and executes
   // them.  This function must not be interrupted by calls to
   // AddFunctionToFifo().

   // fifo[0] contains number of valid entries in fifo[].
   // Valid entries start at index 1, i.e. fifo[1].

   int i, i_ValidEntries;
   i_ValidEntries = (int) fifo[0];

   for (i=1 ; i<=i_ValidEntries ; i++)
      (fifo[i])();

   fifo[0] = (PtrToLoadingFunction) 0;    // Reset count.
}
