/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 * Aware DMT Technology. Proprietary and Condfidential
 *
 * 40 Middlesex Turnpike, Bedford, MA 01730-1413
 * Phone (781) 276-4000
 * FAX   (781) 276-4001
 *
 * FIFO_dmt.C
 *
 * Generic Routines and data structures to handle fifos of
 *  Messages, such as for AOC or EOC, or
 *
 * The reason we have separate functions instead of using a union is that sizeof(PtrToFunc)
 *  may not equal sizeof(int16)
 *----------------------------------------------------------------------------
 */

#include "fifo.h"
#include "gdata.h"
#include "xception.h"
#include "gdata_bis.h"


void AddMessageToFifo(MessageFifo_t *fifo, uint16 message)
{
   if (fifo->PendingMessageCount < fifo->BufferSize)
   {
      fifo->MessageBuffer[fifo->NextAvailable] = message;
      fifo->PendingMessageCount++;
      fifo->NextAvailable++;
      if (fifo->NextAvailable==fifo->BufferSize)
         fifo->NextAvailable=0;
   }
   else
   {
   // KernelException(fifo->ErrorCode);
      fifo->ErrorCode = (int16)(E_CODE_MSG_FIFO_OVERFLOW & 0xFFFF);
      fifo->us_OvflowCnt++;
      fifo->PendingMessageCount = 0; //allow the new byte come in
   }
}


/* returns a 1 if there is a message, returns a 0 if fifo is empty */
int16 RemoveMessageFromFifo(MessageFifo_t *fifo, uint16 *message)
{
   if (fifo->PendingMessageCount==0)
      return 0;

   *message=fifo->MessageBuffer[fifo->IndexOfOldest];
   fifo->PendingMessageCount--;
   fifo->IndexOfOldest++;
   if (fifo->IndexOfOldest==fifo->BufferSize)
      fifo->IndexOfOldest=0;

   return 1;
}

