/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   gdata.c
*
*       This file contains global variable declarations.
*
*-------------------------------------------------------------------------
*/
// ******************************************************************
// gdata.c
//
// History
//
// 16/04/2010 Nihar: Increase DS performance against Vinax in DTAG lab
//                    DTAG-lab shows higher WhiteNoise level => use -130dBm/Hz instead of
//                    -140dBm/Hz for White Noise detection
//                    Grep for IOP_DS_ALL_VINAX_SetWhiteNoiseLevelToM130dBmHz
//
// 03/06/2010 Bhadra: CMV INFO 107 is used to know the status of AFE, DFE and 3 GLP interface(VR9)
//                    underflow overflow and not ready condtions.
//                   Grep for "Feature_ALL_ALL_ALL_AFE_DFE_3GLP_Status"
//
// 16/07/2010 Sriram/Bhadra: Added new code pointer in the HNSHK phase to support Amendment 3 to G.994.1 standard
//                                      Grep for XDSLRTFW-148:SMS00918205 SMS00918215 Feature_AB_US_BisPlus_ALL_Optional_US_interlever_depth
//
// 19/07/2010  Bhadra:Added code for mapping of NE Tx counters(Idle Cell /Non Idle cells) to CMV CNTR 53
//                                      Grep for " XDSLRTFW-151 :Feature_AB_ALL_ALL_NE_ATM_TC_CNTRS_Mapping "
//
// 26/07/2010 Nihar: Logic to add extra DS PCB to boost the DS data rate
//                   for short loops in Plus mode. All hashdefines/constants
//                   used as part of this logic are derived from experimentation results.
//                   By default its disabled. To enable it cw INFO 103 1 0x0040
//                   Grep for PERF_DS_PLUS_ALL_GeneralizedPcb
//
// 05/08/2010 Nihar : Added a global structure to Erasure decoding reporting
//                          Grep for Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting
//
// 06/08/2010 Nihar : Added "1" variable to enable DS BitSwap
//       for all DSLAMs in DMT mode. Grep for IOP_DS_DMT_ALL_EnableDsBitSwap
//
// 26/07/10  Bhadra/Palaksha Murthy  Added fix against CNXT Cos.Link drops are
//           observed with some old CNXT DSLAMS in ADSL2/+ mode,if all tones are
//           loaded with 1bit(at some long loop fixed rate cases.
//          Solution is to force atleast to have one 2 bit tone.
//          Grep for "IOP_ALL_BISPLus_CNXT_1bitConstellation" to check the changes.
//
// 26/07/10  Bhadra/Kannan: Added a flag to enable Noise Margin Separation Calculation
//           while Forcing Unity TDQ.This is done to improve the DS Data Rate in ADSL2
//           Mode against Connexant D57 DSLAM.
//                    Grep for "PERF_DS_Bis_CNXT_ForceUnityTDQ" to check the changes.
//
// 11/08/2010 ChihWen/Bhadra: Added globle variables for C-Pilot1 detection to fix
//                    a xtalk issue with UT900CNXT/D57/Rev7 DSLAM at Netcom.
//                    By default, this fix is disabled. To enable it cw INFO 103 20 0x0004
//                    Grep for SMS00827680 IOP_DS_CNXT_Gdmt_CPilot1Det
//
// 11/08/2010 Kannan/Bhadra: Start Channel Identification & TDQ training
//                   from Rx channel '1' against TI & CNXT based COs for better
//                   DS performance. Since this change doesn't degrade the performance make it general.
//                   Grep for PERF_DS_ALL_TI&CNXT_ChIDfrmTone1
//
// 12/08/2010 Nihar : Added a flag to indicate the Vender ID change in
//                    T1.413 mode against old IFX DSLAMs like AFC 6+6H.
//                    Switch the vender ID in T1413 mode to TI VID
//                    if the CO is Siemens. This improves US rates in long loops.
//                    Grep for IOP_A_US_T1413_OldIFX_SwitchToTIVID
//
// 17/08/2010 AdeelJ/Palaksha/Bhadra: defined global flags for SRA process.
//            Grep for SMS00966298 SMS00951973 IOP_DS_BISPlus_ALL_SRATargetMarginFix
//
// 17/08/2010 AdeelJ/Palaksha/Bhadra: Declared global flags for SRA process.
//            Grep for SMS00966303 SMS00954738 Feature_AB_DS_BISPlus_ALL_IncreaseAccuracySRAStep
//
// 17/08/2009 Kannan/Bhadra: IOP fix for Downstream Upshift SRA failure
//                    against  ISAM 7302 NALT-C  & Geminax.
//               Grep for SMS00900615 IOP_DS_BISPLus_ALL_AllowUpshiftSRA
//
//
// 26/08/2011 Sriram Shastry : Add support for PTM transfer mode (in addition to ATM mode which is normally used in ADSL).
// This includes support in G.HS to indicate PTM support and evaluate CO response regarding possible PTM support
// Interface towards PPE engine -> Exchange of data-> reading of TC status counters from PPE engine and forwarding them to the
// related CMVs such that API can read them
// This feature is contolled via
// cnfg 0 0 2   // 1 : PTM 2: ATM 3: PTM+ATM
// cnfg 2 0 2   // 1 : PTM 2: ATM 3: PTM+ATM
// Default : ATM mode
// Grep for XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping
//
// 09/08/2011 Vinjam/SriRam: Integrated code which finds "OOS" anamoly by reading the PPE register.
//                           Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//                           Grep for Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping
//
// 15/07/2011 Kannan: T1413 bring up and T1413 mode loop length estimation.
//           Grep for XDSLRTFW-254 XDSLRTFW-221 Feature_ALL_T1413_ALL_Bringup
//
// 23/8/2011 Vinjam: Renamed "gl_LOS_detect_power" to "gl_AvgPilotPow".
//           renamed "gs_LOS_sframe_cnt" to "gs_LosDefect_state_cnt".
//           Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//
// 30/08/2011 Sriram Shastry :  QLN/HLOG calibration for Annex-A DMT, ADSL2/2+. Calibration is done with respect to the
// line simulator generated refernce data.
//                                       Grep for "XDSLRTFW-211 Enhance_DS_ALL_ALL_Delt_Calibration"
//
// 30/8/2011 Vinjam: Integrated "DSL_PPE_CLOCK_CONTROL" code from VR9 VDSL2 code (544316)
//               Add PPE clock change CMV as DSL 15. Bits 0:1 are the new clock setting,
//           Bit 4 is a trigger bit that will be cleared by FW after the register write is done.
//           Grep for XDSLRTFW-315: Feature_ALL_ALL_ALL_DSL_PPE_CLOCK_CONTROL
//
// 30/09/2011 Stefan : Upsteam performance fixes from Stefan.
//                     Vinjam integrated them to Vr9 R4.3 ADSL mainline
//                     Grep for XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl
//
// 05/10/2011 Kannan/Vinjam : Relocated "gt_ADSL_TcMode_Reprt" structure (pointed by CMV DSL 14) from "Bis" to "Bulk Memory" data overlay section
// Grep for XDSLRTFW-340 BugFix_DS_DMT_ALL_SelectedTcModeAfterG.Hs
//
// 09/11/2011 Shakil/Bhadra: Downshift SRA was not performed due to Max Delay constraints. In certain interleaved
//                                        profiles LQ CPE trains with maximum Delay. When Downshift SRA is triggered line rate (Lp)
//                                        cannot decrease anymore as it will violate the max delay according to the following equations.
//                                        Sp = 8*NFEC/Lp
//                                        Delay = Sp*Dp/4 ms
//                                        proposed solution is to detect such cases after the first framing calculation and recalculate
//                                        the framing to incorporate the Downshift SRA into account so that we do not violate the delay
//                                        constraints after SRA completes. This algorithm is trigerred only if SRA is enabled and
//                                        max_delay > 1 ms (interleaved profile)
//                                        Grep for ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved
//
// 09/11/2011 ChihWen/Bhadra: The fix for "ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved":
//                      1. The orginal code will start the searching (for max delta_Lp) from 2880, which will take very long time
//                         to find the max delta_Lp and fail the training. The maximum allowed starting point (for max delta_Lp)
//                         is set to 2000, which will take about 15384 symbols (from 12642 to 28026).
//                      2. Considering the max_Lp (Lp + max_delta_Lp) and min_Lp (Lp - min_delta_Lp) before requesting SRA.
//                      3. The searching for SRA will be enabled when it is BDCM CO or INFO 103 26 bitmask(0x0400) being one (it is zero by default).
//                      Grep for ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved
//
// 21/11/2011 Hanyu: Ported MFD code to VRx. Added FW flag to indicate NLNF measurement is enabled.
//            This feature is triggered by "cw cntl 0 0 0x09" similar to sleep test mode.
//            Additinally, it is triggered by SW API 3.16.5.9 or newer during modem power up
//            and can be disabled by CMV bit-15 (default "0" means enabled) of INFO 121 0.
//        Grep for XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect

// 02/12/2011 Balabath:Added new microstate STATs18D and 19D CMV DSL 16 is used inplace of INFO 121
//            for NLNF measurement.INFO 103 (6:11) are mapped to DSL 18 0 5 (Hybrid information)..
//            Additinally, DSL13 bit2 is used inplace of CMV bit-15 (default "0" means enabled) of INFO 121 0.
//        Grep for XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect_CMVRemap
//

// 05/12/2011 Balabath/Sabrina: Use LATN to estimate loop length. Conversion values needs to be
//            empirically determined against GMX EVM, E67, D57 and BRCM DSLAMs.
//            They were verified against other chipsets including CTLM, STM in
//            different modes and loop conditions (straight loops and bridgedtaps).
//            Grep for SMS01544218 FEATURE_ALL_DS_ALL_LoopEstimate
//
// 04/01/2012 Balabath:Support US SRA and controlling US SRA" between Hercules CMV "OPTN 15 0 x0002"
//                   to Socrates "OPTN 15 0 0x0100
//       Grep for XDSLRTFW-380: Feature_US_BisPlus_All_USSRA_CMVRemap
//
//10/01/2012:Balabath:Enhance_DM_Optimisation
//
// 10/01/2012 Shakil/Bhadra: Random link drops seen in ADSL2p mode in a noisy line of DTAG customer house.CPE dropped the link
//                                        due to near end LOS generated by excessive Downstream CRCs. According to our reboot criterion it
//                                        requires more than 1000 downstream CRCs to declare LOS from the CPE side but while we suppressed
//                                        the LOS generation (cw test 29 0 0x4) we did not see the issue and the maximum CRC was less
//                                        than 300. Since we expected more than 1000 CRCs when the LOS was suppressed the root cause was in
//                                        the LOS based on CRC block of the code where we did not increase gsa_good_count_ variable at all which
//                                        triggered LOS if CRC is increased by more than 40 in 20 seconds interval. The reason that gsa_good_count
//                                        did not increased is, it resides in a function called ProcessFramingBytes() which was excluded in the VR9
//                                        compilation process(executes only ifndef HERCULES_ADSL_CPE). Asa fix this variable was moved to the
//                                        correct place to be compiled and incremented correctly.
//                                        Code Grep: XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC
//
//16/01/2012 Shakil/Balabath:Non Standard T1413 GHS Activation switching required by Telefonica Spain.
//          By default , if no CO activation tones detected the CPE switches between T1413 and GHS activation
//          at every two seconds (i.e. 2 seconds of t1413 followed by 2 seconds of GHS and so on).
//          This feature changes the switching time from 2 seconds to 60 seconds
//          (i.e. 60 seconds of t1413 followed by 60 seconds of GHS and so on..).
//          This feature is CMV controlled and by default disabled.
//          CNFG 58 0 -> bit 0  (Non standard T1413-GHS activation switching enabled/disabled)
//                       0: disabled (default)
//                       1: enabled
//          CNFG 58 0-> bit 1 (T1413/GHS Activation startup)
//                   0 -> GHS Activation startup (Default)
//                  1-> T1413 activation startup
//       For code changes Grep for XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching
//
// 12/01/2012 Kannan: Added variable to enable
//            64pt IFFT emulation for TI & CNXT in T1413 mode.
//            Grep for PERF_US_T1413_T1&CNXT_64ptIFFT
//
// 25/01/2012 Kannan: PLAM counters Eg:"guc_consecutive_sev_err_sec_cnt" is not being updated for every 1secs,
//                    since "gs_bitswap_tx_sframe_count"
//                    is being reset for every 256 super frames, reseting of this counter
//                    will have incorrect update of PLAM counter, i.e not updated for every 1 secs.
//                    For Eg: 0, 59, 118, 177, 236, (256==>0), 59, 118, etc
//                    Grep for BugFix_DS_ADSL1_ALL_SuddenRFI
//
// 12/01/2012: Balabath: Added CMV to trigger LPR in idication.DSL 5 0 1 will trigger this.By default
//                      this bit is set to zero.
//                Grep for XDSLRTFW-201 Feature_US_ALL_ALL_LPR
//
// 16/2/2012 Vinjam: Allow adjusting the target DS margin via CMV/message in ADSL mode.
//           Option to add additional DS margin (additional to what is requested as target margin by the CO).
//           This margin would be added on all tones (i.e. flat). The reported margin must be the real margin
//          (i.e. including the additional margin configured). The goal of the CMV is not margin cheating.
//          This CMV will also be helpful for debugging purposes and it will also allow to decrease the margin
//          (i.e. increase DS performance by sacrificing margin/stability) HERC CMV "OPTN 28" is used for setting deltaTARSNRMds.
//          grep for "XDSLRTFW-310 Improve_BisPlus_DS_All_AdjustTargetMarginThroughCMV" to see the code changes.
//
// 23/02/2012 Sriram Shastry : Disable PLL bandwidth to reduce DS CRC for 24DSL noise CPE margin verification test.It was observed that if
//      RxAvgmargin drops from 3.5 dB to 2.5 dB , we see Burst of DS CRC's  as a result Sync is Lost.
//      Grep for : Enhc_DS_ALL_ALL_ByPassPLLBWIncrease
//
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
// 01/06/2012 Shakil: Merge all FT EMC fixes from ARx platform to VR9. Important changes are
//                                        --> 512 point QLN implementation for PLUS mode only because in VR9 platform Rx Strymon IIR runs in 2.2Mhz
//                                                in BIS/DMT mode and in 4.4Mhz in PLUS mode
//                                        --> Remove all Rx bypass filters with unity pass
//                                        --> Since in BIS/DMT mode Rx IIR runs in half of the frequency as in ARx platform modify the detection of
//                                                RFI notch filter (double the input RFI frequency) only in BIS/DMT mode
//                                        --> Added CMV control to enable/disable the RFI notching and enabled by default.
//                                                INFO 103 28 bitmask 0x100-> 0 Enabled(default), 1(disabled)
//                                        --> Remove the code for VR9 where we reset the noisy pilot flag if more than 17 frames are disturbed at
//                                                every 40 frames. This reduces the possibility of a bad DEC update for long impulse burst.
//                                        --> Improve detection of corrupted Sync Symbol by adding the noisy pilot flag as well in the condition
//                                        --> Merge the change from ARx platform where we update the DEC coeffs if the Average margin is more than 3dB
//              Grep for: XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES
//
//      04/06/2012 Shakil: New feature implemented where we detect REIN noise at training and change framing
//                         accordingly taking erasure decoding into account to increase stability in presence of REIN
//                         even if the minINP exchanged during GSK was not enough to sustain the REIN. The background
//                         of this feature was a test requirement from FT EMC lab at Lane on where the minINP and maxdelay
//                              configured was 2 and 16ms respectively whereas REIN in the line was 4-5 DMT symbol duration.
//                              In the regular condition considering erasure we may protect maximum 3 DMT symbol REIN therefore
//                              resulting huge DS CRCs and link drop. With the new feature we could dynamically detect REIN at
//                              CSilent1 state during handshake and increase the INP taking erasure into account while cap the
//                              delay maximum to 8 ms and achieved CRC free stable link without sacrificing too much data rate
//                              since we also ignore REIN affected symbols before bitloading and medley SNR calculation.There are
//                              two parts of the implementation
//                              1. Detect REIN during GSK and adapt framing  prior to bitloading at Medley. It is controlled by
//                                 INFO 103 28 bitmask 0x200 and disabled by default (bitmask 0x200-> 0 disabled, 1 enabled)
//                              2. Ignore REIN affected symbols for bitloading: No CMV controlled. Enabled by default
//                              Grep for XDSLRTFW-471 Enhance_DS_ALL_ALL_REIN_IMMUNITY_TRAINING
//
//
// 14/06/2012 Kannan:
//          1. FIFO3 can be used to get the debug data in Rx Path
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
// 07/06/2012 Vinjam: Defined a new global structure to hold the Transmitter referred downstream
//            virtual noise break points. "gt_DS_RefVirtNoiseLevel_ADSL2" moved to DATA_BULK01 section, which is available
//            starting from channel discovery phase onwards. Added global variable "gpsa_RxSnrBufWoVN" to point the
//            memory locations used to store the SNR with out virtual noise during show time, if DS virtual noise feature is triggered.
//            Grep for XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise
// 19/06/2012 Raghu M
//                        L2 related changes grep for XDSLRTFQ-416 : Enhancement_ALL_BisPLus_ALL_L2
//
// 19/06/2012 Ram: Merged "ReTx" related MGMT counters and Test Params code from
//                 ARX ADSL code base (Grep: FEATURE_DS_BisPlus_ALL_ReTx_MGMTCntrs_TestParams)
//                 Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 04/07/2012 Ram: Merged "ReTx" Bitswap code from ARX ADSL code base.
//                 Grep for "XDSLRTFW-443 FEATURE_DS_BisPlus_ALL_BitSwapReTx"
//
// 05/07/2012 Ram: Merged "ReTx" Segmented Bitswap Request code from ARX ADSL code base.
//   To cope with sweeping and fixed RFI, the following changes are done.
//   1. Below changes #2,#4,#5,#6 are under cmv control INFO 103 23 bitmask(0x0040). This bit is one (enabled) by default.
//   2. Modify the maximum number of bits for bitswap (gs_REDUCE_LP_DELTA_BITSWAP) from 20 to 120.
//   3. Increase Tx HDLC buffer size (MAX_TX_HDLC_MSG_SIZE, MAX_TX_HDLC_BUFFER_SIZE) from 700 to 1000.
//   4. Increase the maximum tone number (gs_MaxTonePerOvhdMsg) in one HDLC segment from 160 to 240.
//   5. Enable segmented bitswap request.
//   6. Change gs_DD_RxChannelsPerSymbol from 16 to 32 to improve SNR updating frequency.
//   7. Once marign on tones were ever dropped to below -6 dB, then bitswap is triggered when minimum margin is below 0 dB.
//      The threshold (-6dB by default) can be changed with cmv INFO 119 0.
//   8. Do not move bits to the tones whose margin were ever dropped to below -6 dB since these tones were very likely
//      to be affected by RFI before, and will be affected by RFI again. This mechanism is under cmv control
//      INFO 103 23 bitmask(0x0080). This bit is one (enabled) by default.
//   9. If bitswap is failed, checking of #7 condition will be ignored. Then bitswap will be tried again.
//   10. Include fix SMS01320806 IOP_A_BisPlus_CNXT_ImprovedBitSwap.
//   Grep for "XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest"
// 04/07/2012 Anantha: Added global varibles needed for implementing LCD and NCD failure triggering
//                    Grep for XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers
//
// 23/08/2012 Vinjam: Added a structure "gt_InteropOptions" for Interop bits common to ADSL/VDSL, attached to "CMV DSL 19"
//            Grep for "XDSLRTFW-508 Fix_DS_All_All_SuppressCounterWriteFromDSLAPI"
//
// 26/11/2012 Kannan: Added variable to pull the PPE data when link is down
//                 Grep for "XDSLRTFW-541: Platform_VR9_VRX318"
//
// 14/12/2012 Hanyu/Vinjam: Integrated "XDSLRTFW_523" changes to R5.2 mainline
//                              Fixed low ATTANDRds issue when SRA is enabled in capped/fixed rate cases.
//                              Replaced gs_RxDesiredMargin with gs_RxDesiredMargin_original from bitloading
//                              since gs_RxDesiredMargin could be overwritten by gs_RxAvMargin in SRA,
//                          which would cause lower ATTANDRds when gs_RxAvMargin is much higher than target margin in capped/fixed rate cases.
//              Grep for XDSLRTFW-632 XDSLRTFW_523 BugFix_DS_BisPlus_AB_All_UpdateATTNDRds_SRA
//
// 24/12/2012 ChihWen/Vinjam: Integration of R3.5 dying Gasp code changes to R5.2.
//            Overwrite one time the Tx IB FIFO with LPR indication when dying gasp event is happening (GPIO pin 15), so that the LPR will be indicated
//                        in the next US OHC frame. The reason for doing so was that there could be one OHC frame delay between the dying gasp event and
//                        the time when Tx IB FIFO was empty. This delay would cause one OHC frame later for indicating LPR.
//                    Grep for XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR
//
// 26/12/2012 Stefan/Vinjam: Integrated R3.5 fix to R5.2 Mainline.
//            To avoid long training times in ADSL mode and too early false mode switches to VDSL binary,
//                FW sends the intentional retrain information (using a global variable guc_Forced_Retrain) to SW/DSL API.
//            Code changes connected to Jira XDSLRTFW-248" and Jira XDSLRTFW-255.
//                Grep for XDSLRTFW-654 XDSLRTFW-248 Bug_DS_All_All_IntentionalReTrainToReduceTrainTime
// 08/11/2012 Anantha: 1. Added global variable to store previous Average margin
//                                         2. Added variable to help decreasing number of bins from which bits are removed
//                              grep for XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap
//
// 07/01/2013 Ram: Added fix for JIRA 575, 459.
//                 a) 575: Seperate out and align FW internal counters as per Msg spec
//                         Implement incrementing UAS counter during training
//                 b) 459: Implement CMV 'CNTR 51'
//            Grep for XDSLRTFW-575: Counter Write back in ADSL mode
//            Grep for XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping
//
// 16/01/2013 Ram: Fix added for JIRA 285 - Implement a 'Feature MAP' indicating the features supported by ADSL FW
//                 Added a new variable to implement CMV 'DSL 19' (Refer Msg Spec ver 1.9 for more details on CMV)
//                 Grep for XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map
//
// 07/02/2013 Vinjam: Added support for "CMV CNFG 45" to select "G.Hs Toneset" as per VRx Msg Spec.
//            Inturn, "enale/disable" of "optional upstream interleaver depth" feature is moved to "CMV CNFG 46".
//            Grep for XDSLRTFW-699: Fix_AB_US_All_GHsToneSetSelection
// 11/02/2013 Kannan:
//          1. Orderly shutdown algo implementation and it is applicable for both
//             VR9 & VRX318.
//             Grep for "XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown"
//
// 07/02/2013 Vinjam: Send "Vector" code pointer in "VDSL2 code pointers" in ADSL G.Hs Short CLR Message.
//            Vector feature is enabled using "CMV CNFG 82". If enabled, then set "SPAR2 OCTET2 Bit-3(0x8)" & NPAR3 OCTET1 Bit-0(0x1).
//            Grep for XDSLRTFW-713 Feature_AB_All_All_All_SendVectorCodePointerInGHs
// 20/02/2013 Mahesh:  Removed Ananta's bitswap enhancement changes for L2 & SRA
//
// 18/02/2013 Vinjam: Report downstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 1 [14:15]" & "CMV_RATE 1 [16:17] respectively.
//            Also, Report upstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 0 [14:15]" & "CMV_RATE 0 [16:17] respectively.
//            Modified enable/disable of Erasuredecoder logic as per VRx Msg Spec through "CMV DSL 1 0"
//            Grep for XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec
//
// 25/02/2013 Ram: Fix added for JIRA 285 - Implement a 'Feature MAP' indicating the features supported by VDSL FW
//                 Added a new variable to implement CMV 'DSL 20' (Refer Msg Spec ver 1.9 for more details on CMV)
//                 Grep for XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map
//
// 27/2/2013 Vinjam: Memory Layout, Buffers Re-Shuffling to get free space in "BULK_DATA_RAM_DMSWAP".
//           Moved buffers (guca_fe_SystemVendorID[], guca_fe_SystemVersionNum[], guca_fe_SystemSerialNum[])
//           from "BULK_DATA_RAM_DMSWAP" to "ONE_PORT_DEBUG_DATA"
//           Grep for XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec
//26-03-2013 Anantha: Added data structure to trigger bitswap over stored SNR to increase bitswap speed
//                                        during RFI test
//                              grep pattern XDSLRTFW-686: PERF_DS_DMT_ALL_Bitswap
//
// 27/5/2013 Vinjam: Clean up HERC CMV CNFG 17. Removed global structure "gt_Bonding_DiscAggr_ControlCMV".
//            Grep for XDSLRTFW-230 Bug_All_All_All_HercCnfg17_CleanUp
//
// 27/05/2013 Varun : Added strucures and variables needed for the Debug Buffer code
//                    grep for "XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
//
// 24/5/2013 Vinjam: Added mapping of "HERC CMV INFO 85" to "Showtime SNR with out Virtual Noise" and the existing
//                   HERC/SOC CMV INFO 85 (INFO_RX_CLEAR_EOC) is moved to HERC/SOC CMV INFO 130
//                   Grep for XDSLRTFW-965 Task_DS_BisPlus_All_AttachHercCMVINFO85
//
// 20/06/2013 Varun : Added strucures and variables needed for the Debug Buffer code of Showtime
//                    grep for "XDSLRTFW-599 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
// 25/06/2013 Kannan: Added variables to fix DEC struck issue.
//                    Grep for "XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest"
//
//22/11/2013 Sooraj Govindan : To reduce the size of PERSISTENT_MEM block by 512 bytes, moved guca_QLN[] from PERSISTENT_MEM to LOCAL_LD_ST Memory block.
//                   This helps in reducing memory requirements needed in VDSL mode, to support PERSISTENT memory of ADSL mode. (XDSLRTFW-441)
//
// 04/01/2015 Anantha Ramu/TV Ram: Uncorrected DTUs observed in some test setups. Two types of fixes done
// 1. Fix for uncorrected DTUs due to Q full condition
// 2. Fix for uncorrected DTUs due PLL disturbance(Noise spread) by SHINE pulse.
// grep for XDSLRTFW-1223.
//
// 25/03/2014 Sriram Shastry: Changes done for "SMS01261908:Link drop issue during on-hook/off-hook in G.dmt with Catena/Ciena CNX-5 DSLAMs"
//                   Changed the name of the global variable gsa_RxPilotToneInCReverb4 to gsa_RxPilotToneInCReverb34.
//        Grep for XDSLRTFW-1633 SMS01261908 SMS001231692 PERF_DS_ADSL1_AB_Ciena_PLL_TRACKING_REVERB3
//
// 31/03/2014 ChihWen: DS rate improvement against Adtran Geminax in DMT mode.
//                To improve the DS rate against Adtran Geminax in DMT mode, the solutions are below.
//                1. When preparing the parameters in R-MsgsRA, search the best R (>= 4) which will achieve highest K (best net rate),
//                   then set K in R-MsgsRA accordingly, but set R = 0, coding gain = 5.5 dB, and loaded tone number by the equation below.
//                   (loaded tone number) = 159 * (codeword size) - 232. This one-order equation is from (codeword size, loaded tone number)
//                   = (245,152) and (104,64). After receiving R-MsgsRA, Adtran Geminax will send C-RatesRA with proper options of R and K,
//                   in which AR9 will select the second or third option.
//                2. Report DS LOS when pilot power < gl_PilotTone_PwrThresh/256 instead of gl_PilotTone_PwrThresh due to link drop by CO.
//            This is controlled by CMV info 103 27 bit5 0x0020 and is disabled by default.
//            1: Enabled
//            0: Disabled (Default)
//                Grep for XDSLRTFW-1586 IOP_DS_A_GMX_DMT_LowRate
//
// 15/04/2014 ChiWen/Hanyu: Fine tuned US performance against CNXT DSLAMs based on ADSLRTFW-1480 and ADSLRTFW-1591 with the following changes
//  (1) Added special flat US TSSI;
//  (2) Set tone 32 to zero(gusa_US_Tssi_Value[32] = 0);
//  (3) Enabled special flat US TSSI in C-REVERB1/R-REVERB1 (might have influence over the final PGA training);
//  (4) Enabled special flat US TSSI in C-REVERB2;
//  (5) Renamed gft_USPerf_Midloop_Gspn to gft_USPerf_Gspn for all CNXT CO's;
//  (6) Above changes are applied to all CNXT CO/DSLAMs regardless of CO FW versions and controlled by CMV bit4 (MASK 0x0010) of info 103 27
//      that is ENABLED (bit4=1) by default. This is especially recommended at CenturyLink/USA. So far no side effect has been observed.
//  Grep for XDSLRTFW-1584 XDSLRTFW-1585 IOP_US_BISPlus_CNXT_USRateImprovement
//
//
// 30/03/2015 Sriram Shastry:Fail in TR-105i2a1 7.9 Performance Monitoring Counters during G.998.4 retransmission.
//       Grep for : XDSLRTFW-2070
//
// 12/10/2015 Vinay: Added code to support G.Fast in ADSL G.Hs session.
//            Grep for XDSLRTFW-2298
//
// 18/01/2016 Vinay: Changed the addresses of DSL 27 and DSL 28. Initially they were hard coded and now it is pointing to a variable.
//                   Also added few variables to BAR15 register.
//                   Grep: XDSLRTFW-1942
//
// 24/11/2017 Sriram Shastry:VRX518 US CRCs and FECs in Tests of 1TR112 ADSL2+ Anx J.
//       Disable OOB handling if US Bitswap is ongoing .DEC update logic gets into conflict with OLR as both algorithms
//       copy gsa_TxCombinedGains to the inactive gain table / active table.
//       Grep for XDSLRTFW-3479
//
// 15/12/2017 Sriram shastry: DCT tool does not work in ADSL mode for VRX518 FW R5
// Added Support towards VRX518 Platform for  debug traces ( Updated address field )
// Search  Pattern XDSLRTFW-3638
// ******************************************************************************************************************************************

#include <stdio.h>
#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "pga_set.h"
#include "ifft_fix.h"
#include "aoc.h"
#include "typedef.h"
#include "ovhd_bis.h"
#include "bert.h"
#include "compiler.h"
#include "eoc.h"
#include "ib.h"
#include "const.h"
#include "const_bis.h"
#include "data_alloc.h"
#include "ghs.h"
#include "rt_tones.h"
#include "ghs.h"
#include "mp.h"
#include "T1413.h"
#include "DebugBuffer.h"
#ifdef DEBUG_STREAMING
#include "Hmp_data.h"
#endif
#ifdef TARGET_HW
#include "gpio.h"
#endif
#ifdef IFX_XTC
#include "customertasks.h"
#endif
// XDSLRTFW-1205 ENH_DS_ALL_ALL_LOMx_ReInit (Start_End)
#include "plam.h"
#include "pll.h"  /* XDSLRTFW-2464 */
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
//SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod (Start)

//ReTxXmemConfigInfo_t *gpt_ReTxXmemConfigInfo; //PPE_SDRAM_interface changes
//SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod (End)

// XDSLRTFW-1942 (Start)
DATA_MAP_SRAM_BAR15
// XDSLRTFW-3638(Start)
/*
ATTENTION-VRX518!
+--------------------+--------------------+------------------------+
|Address[File]       |Address[File]       |Symbol Addr             |
|Variables under     |Variables under     |                        |
|DATA_MAP_SRAM_BAR15 |DATA_MAP_SRAM_BAR15 |                        |
|*.c                 | *.h                |                        |
|BAR_15              |BAR_15              |BAR_15     = 0x1f0000   |
|Medley              |Medley              |Medley     = 0x1f5000   |
|Reverb              |Reverb              |Reverb     = 0x1f5400   |
|ReverbEcho          |ReverbEcho          |ReverbEcho = 0x1f5800   |
+--------------------+--------------------+------------------------+
|*.c[changed Order]  | *.h                |Symbol Addr             |
|Medley              |BAR_15              |BAR_15     = 0x1f0000   |
|Reverb              |Medley              |Medley     = 0x1f5000   |
|ReverbEcho          |Reverb              |Reverb     = 0x1f5400   |
|BAR_15              |ReverbEcho          |ReverbEcho = 0x1f5800   |
+--------------------+--------------------+------------------------+
|*.c                 |*.h[changedOrder]   |Symbol Addr             |
|BAR_15              |Medley              |Medley     = 0x1f0000   |
|Medley              |Reverb              |Reverb     = 0x1f0400   |
|Reverb              |ReverbEcho          |ReverbEcho = 0x1f0800   |
|ReverbEcho          |BAR_15              |BAR_15     = 0x1f0C00   |
+--------------------+--------------------+------------------------+
ATTENTION-VRX218-R9FW!
+--------------------+--------------------+------------------------+
|Address[File]       |Address[File]       |Symbol Addr             |
|Variables under     |Variables under     |                        |
|DATA_MAP_SRAM_BAR15 |DATA_MAP_SRAM_BAR15 |                        |
|*.c                 | *.h                |                        |
|BAR_15              |BAR_15              |BAR_15     = 0x170000   |
|Medley              |Medley              |Medley     = 0x175000   |
|Reverb              |Reverb              |Reverb     = 0x175400   |
|ReverbEcho          |ReverbEcho          |ReverbEcho = 0x175800   |
+--------------------+--------------------+------------------------+
|*.c[changed Order]  | *.h                |Symbol Addr             |
|Medley              |BAR_15              |BAR_15     = 0x170000   |
|Reverb              |Medley              |Medley     = 0x175000   |
|ReverbEcho          |Reverb              |Reverb     = 0x175400   |
|BAR_15              |BAR_16              |ReverbEcho = 0x175800   |
+--------------------+--------------------+------------------------+
|*.c                 |*.h[changedOrder]   |Symbol Addr             |
|Medley              |Medley              |Medley     = 0x170000   |
|Reverb              |Reverb              |Reverb     = 0x170400   |
|ReverbEcho          |ReverbEcho          |ReverbEcho = 0x170800   |
|BAR_15              |BAR_15              |BAR_15     = 0x170C00   |
+--------------------+--------------------+------------------------+
ATTENTION!
// XDSLRTFW-3638(End)
*/
uint32 gula_DebugBuffer_BAR15[5*1024]; // Total memory required is 20KB i.e, 2KB for GHS to training and 18KB for Showtime data
uint16 gusa_MedleySnrBuffer_BAR15[RX_NUM_TONES];  //
uint16 gusa_ReverbSnrBuffer_BAR15[RX_NUM_TONES];
uint16 gusa_ReverbEchoSnrBuffer_BAR15[RX_NUM_TONES];
DATA_MAP_END
// XDSLRTFW-1942 (End)
int16 gs_Force_ReTx_Framing = 0;   //FEATURE_DS_BisPlus_ALL_ForceExplicitFramingForURETX (Start_End)
uint16 gus_INP_act_SHINE = 0;
uint16 gus_17MSec_RxShowtimeFrameCnt; //Conter for 17 msec
int16 gs_norm_DTUuc_1sec;

uint8 guc_INP_act_REIN = 0;
uint8 guc_delay_act_RETX = 0;

RRC_Stat_t gt_RrcStat;
uint8 guc_retx_N;
uint8 guc_retx_K;
uint8 guc_retx_payload_cw1;
uint8 guc_XDTUs = 0; // No of DTU's that read out from the Queue and forwarded to PPE

volatile uint32 gul_ZrFifoSetupWait;
volatile uint32 gul_ZrFifoReadWait;
uint32 gul_ZrFifoValidBytes;

FlagT gft_NotFirstDTU;
//FlagT gft_ForwardDtusToPPE = 0;
//FlagT gft_EnableXdtuWrite;
//FlagT gft_InsertRRC;

uint8 guc_ReTX_CRC1_ReportTS;
uint16 gus_ReTX_crc1;

//XDSLRTFW-1634 (Start)
FlagT  gft_Qrx_Full;
uint16 gus_QFullCntr;
uint16 gus_dbg_QreTx_full_cntr;
uint16 gus_DropPktCntr;
uint16 gus_BufOverWriteCntr;
uint32 gul_cons_bad_dtu =0;
uint32 gul_max_cons_bad_dtu = 0;
uint32 gul_cons_good_dtu = 0;
int16 cnt_pll_freq = 0;
int16 cnt_pll_loop = 0;


uint8 guc_maxdtuout = 2;
uint8 guc_EstimatedTS;

uint8 guc_Wr_SID_idx; //To be write Index of the Translation table
uint8 guc_Curr_Wr_DTU_idx;
uint8 guc_Rd_SID_idx; //To be read Index of the Translation table
uint8 guc_Prev_Rd_SID;
uint8 guc_Prev_Rd_SID_idx; //Index of the DTU already forwared to the PPE.
uint8 guc_Prev_Rd_DTU_idx;

uint8  guc_DsQRx;
uint8  guc_DsQTx;
uint8  guc_NRET;
uint16 gus_DTUSizeDS;
uint16 gus_DTUPayloadSizeDS;
uint16 gus_DTUSizeInSymbolsDS;
//XDSLRTFW-1634 (End)

//XDSLRTFW-1223 (Start)
#ifdef  PLL_ADAPTATION_SHOW
FlagT gft_first_showtime = 1;
FlagT gft_av_done = 0;
uint8 guc_av_cnt;
uint8 guc_delay_count;
int16 gs_MaxPhaseErrorThreshold_save;
int32 gl_tan_prv;
int32 gl_tan;
int32 gl_err;
int32 gl_err_prv;
int32 gl_err_diff;
int32 gl_thresh = 0xa0;
int32 gl_pll_freq_offset_prv;
int32 gl_pll_loopfilter_out_prv;
int32 gl_sum_err_diff = 0;
#endif

//XDSLRTFW-1223 (End)

// XDSLRTFW-3662 (Start)
uint16 gusa_PPA_FW[2];  // This information is provided/configured by host.
uint16 gusa_PPE_FW[2];  // This value is read out from DREG register DREG3
// XDSLRTFW-3662 (End)

#ifdef DEBUG_STREAMING
// Structures to provide CMV control and filter of Debug Streams
DebugStreamControl_t gt_debugStreamControl;
DebugStreamConfigure_t gt_debugStreamConfigure;
DSH_Statics_t gt_DshStatics;
uint16 gus_Dbg_RequeueCnt;
uint16 gus_RequeueBGFunction;
uint16 gus_Dbg_DSH_skip_BGF_add;
uint16 gus_Dbg_msg_length;
DSH_ModemFsmState *gpt_DSH_ModemFsmState;
int16 gs_DSH_PrevMacroState;
uint8 guc_DSH_VersionInfoStreamed;
HMP_DebugStreamMsg_t gt_DebugStreamMsg;
#endif

#ifdef DEBUG_GINP_MSGS
// debug ReTX training messages
uint8 guc_DebugReTXTrainingMsg; // 1 - debug OMSG1; 2 - debug OPTS; 3 - OPMS
uint8 *gpuca_GINP_MsgBuf;
int32 gl_GINP_StartIdx;
int32 gl_GINP_MsgLength;
#endif

//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)


//=======================================================================================
// Debug variables
FlagT gft_StopDSL=0;            // Normally 0.  Set to 1 to halt state machine and DSL.
int16 gs_PauseMarker;           // Global variable that takes on value of most recent argument to Pause().
volatile FlagT gft_Resume;      // Gets set to 0 after a call to Pause().  Use external write to set to 1 to continue
// past the Pause().
//XDSLRTFW-1634 (Start_End)
FlagT gft_PauseOff=TRUE;                // Set this flag to 1 in a script to disable all Pauses().
PtrToFunc gl_CurrentBGTask;             //log the current BGTask address
uint16 gus_BgLoopCnt;       //log the Bg task loops to see whether its incrementing
//=======================================================================================
#ifndef ADSL_62
// temporary variables
int16 gs_dec_path_delay;
#endif

/* Kernel Variables */

// these variable are loaded in (banked) LOCAL_LD_ST mem space and will be manually
// initialized by the kernel code; that means the data are linked into
// a pure memory section (not a swap page).
#ifdef ADSL_62
DATA_LD_ST_MKERNEL_BEGIN
uint8 guc_ch_id = 0;
uint8 guc_PortMode = 0;         //0: 1-port mode, 1: 2-port mode
uint8 guc_num_ports = 1;

uint8 guc_adma_reg_offset;              // will be set to 0 or (DSP_ADMA1_CTRL - DSP_ADMA0_CTRL) for port0 and port1 respectively
uint8 guc_xdma_reg_offset;              // will be set to 0 or (DSP_XDMA1_CTRL - DSP_XDMA0_CTRL) for port0 and port1 respectively

int32 gl_MaxBgDuration;
int32 gl_CurrentStackPointer;

uint8 guc_KernelState;                  // first interrupts or not
DATA_MAP_END

DATA_PORTMODECONTROL_BEGIN
#ifdef TARGET_HW
PortModeControl_t gt_PortModeControl;
#else
//PortModeControl_t gt_PortModeControl = {0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0};
PortModeControl_t gt_PortModeControl = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
#endif
DATA_MAP_END

FlagT gft_ByPassAfe = FALSE;
FlagT gft_ByPassCustomerMsgHandling = FALSE;
#endif

//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
uint8 guc_s_44k_owner;
uint16 gus_Zep_Tx_DelayCnt;
uint16 gus_LinkDownState_SymCount;
//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)
uint16 gus_nFunctionCalls_InitGlobalVariables = 0; // Number of function call: InitGlobalVariables()
//G.Fast
uint32 gul_OperationModeCapable_G_Fast; // XDSLRTFW-2298

//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start): Already initialized later in gdata.c
// XDSLRTFW-211 Enhance_DS_ALL_ALL_Delt_Calibration (Start)
//#ifndef ISDN  //Annex A
//DATA_BULKO1_BEGIN
//int32 gl_Rx_QLN_Power = 0;
//DATA_MAP_END
//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (End)
//#endif
// XDSLRTFW-211 Enhance_DS_ALL_ALL_Delt_Calibration (End)
/*********************************************************/
/***** map following variables to LOCAL LD ST memory *****/
/*********************************************************/

DATA_MAP_LOCAL_LD_ST_BEGIN

uint8 guc_CL_minINP;
FlagT gft_CL_Message_Once;
int16 gs_GlobalInterruptFlag;
int16 gs_InterruptEnableMask;
int16 gs_InterruptMask;
int16 gs_IntNextFrameEnable;

TCB_t gt_TaskArray[NUM_TASK_BUFFERS];   /* allow at most 5 tasks */
PtrToFunc gt_BGTaskArray[NUM_BG_BUFFERS];
FunctionFifo_t gt_BGTaskFifoBuf,*gp_BGTaskFifo;

/* use Fifos to allow multiple loading functions per TC task    */
// First entry of array is # of valid entries in rest of array, so add +1 to array size.
PtrToLoadingFunction gp_TxLoadingFunctionFifo[LOADING_FUNCTION_FIFO_SIZE+1];
PtrToLoadingFunction gp_RxLoadingFunctionFifo[LOADING_FUNCTION_FIFO_SIZE+1];

/*  State machine variables */
StateMachCntrlStruc_t gt_StateMachCntrl;

DATA_MAP_END
/*********************************************************/
/***** end mapping to LOCAL LD ST memory *****/
/*********************************************************/

int32 gl_TxSymbolCount;                         /*  Tx state symbol counts */
int32 gl_RxSymbolCount;                         /*  Rx state symbol counts */
int32 gl_RxSymbolRunningCount=0;        /* Rx symbol count that does not get reset to 0 with each state */
int16 gs_RxState;                                                       /*  current Rx states */
int16 gs_TxState;                                                       /* current Tx state */

int32 gl_save_RxSymbolCount, gl_save_TxSymbolCount;
int16 gs_save_RxSubState, gs_save_TxSubState;
int16 gs_save_RxState, gs_save_TxState;

int16 gsa_CRCincrement[NUM_DATA_PATHS]= {0x100,0x100}; /* Used to accumulate normalized CRC count (8.8 Format)*/
int16 gsa_RxPilotTone_mem[2] = {0, 0};


/*********************************************************/
/***** map following variables to LOCAL LD ST memory *****/
/*********************************************************/

DATA_MAP_LOCAL_LD_ST_BEGIN

int16 gs_TxSubState, gs_RxSubState;                                             /*  current substates */
int16 gs_TxNextState, gs_RxNextState;                                   /*  next states */
int16 gs_TxStopState,  gs_RxStopState;                                  /*  stop states */
int16 gs_TxDoneState, gs_RxDoneState;                                   /*  done states */
int16 gs_TxStateJumpTo, gs_RxStateJumpTo;                               /*  jump-to states */
int16 gs_TxStateJumpFrom, gs_RxStateJumpFrom, gs_RxSubStateJumpFrom;                    /*  jump-from states */
int16 gs_TxSubStateCnt, gs_RxSubStateCnt;                               /*  substate symbol counts */
int16 gs_TxDECTrainSymbolCount, gs_RxDECTrainSymbolCount;
int16 gs_StartDECTraining;


DATA_MAP_END

/*********************************************************/
/***** end mapping to LOCAL LD ST memory *****/
/*********************************************************/
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START_END)
// ADSLRTFW-1404_XDSLRTFW-1594_IOP_A_DS_CTNW_BisPlus_ShortenGHS  (START_END))
FlagT gft_CTNW_Shorten_GHS;
//XDSLRTFW-443: FEATURE_DS_BisPlus_ALL_BitSwapReTx (Start)
int16 gs_target_margin; // Minimum margin per Tone during BitSwap.
// Increase of delta step size in MinTonemargin during BitSwap
int16 gs_delta_step = 128; //0.5 dB
// Flag to indicate increase min tone margin based on margin.
FlagT gft_BitSwapUp = 0;
// Flag to indicate reduce min tone margin based on margin.
FlagT gft_BitSwapDown = 0;
//XDSLRTFW-443: FEATURE_DS_BisPlus_ALL_BitSwapReTx (End)


/* Algorithm State Machine Variables                    */
/*                                                                                              */
/*     Each Algorithm State Machine is embedded within a particular state machine       */
/* substate and is called once per frame until complete. The purpose of the                     */
/* Algorithm State Machine is to simplify re-use of the training sequence for           */
/* each block, e.g. AEC, Frame Alignment, TDQ, DEC, etc. Encapsulating the                      */
/* sequence allows the code to be reused both across time (i.e. multiple times          */
/* within a single train) or across operation modes (e.g. DMT and BIS).                         */



int16 gs_rx_framecnt;
uint8 guc_BkgdTaskState;                        // Generic, reusable flag for indicating background task completion.
uint8 guc_TdqTrainingState;                     /*  TDQ training status flag */
uint8 guc_FdqTrainingState;                     /*  FDQ training status flag */
uint8 guc_EcTrainingState;                      /*  DEC training status flag */
uint8 guc_AecTrainingState;                     /*  AEC training status flag */
uint8 guc_AvgAecLmsSequences;
FlagT gft_BitloadState ;                                /*  Bitloading status flag */
uint8 guc_SnrCalcState ;              /*  SNR calculation status flag */
uint8 guc_AccumState ;                          /*  Accumulation status flag */
uint8 guc_RxSyncFrameProcessingState ;
uint8 guc_ShowTimeRxState ;                     /* Showtime task layer Rx initialization status flag */
uint8 guc_ShowTimeTxState ;                     /* Showtime task layer Tx initialization status flag */
uint8 guc_RxDataPumpState ;                     /* Showtime DSL engine Rx initialization status flag */
int16 gs_RxDataPumpLoadState;
volatile uint8 guc_RxToneOrderLoadState;
uint8 guc_TxDataPumpState ;                     /* Showtime DSL engine Tx initialization status flag */
int16 gs_TxDataPumpLoadState;
uint8 guc_PgaTrainingState ;
uint8 guc_HandshakeDone;

#ifdef DANUBE
volatile uint8 guc_TxIlvInitState;       /* Danube ILV initialization status flag */
volatile uint8 guc_RxDilvInitState;     /* Danube DILV initialization status flag */
#ifdef AMAZON_SE
FlagT gft_Fixadma;
#endif  //#ifdef AMAZON_SE
#endif  //#ifdef DANUBE

uint8 guc_ibits[4];
//store all erasure-based global variables  in Bulko1
#if defined (DANUBE_WB) || defined (VR9_ERASURE)
//Erasure Feature
//int16 gs_erasure_set; //XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (Start_End)
int16 gs_wb_maxscore = 0xFFE;
FlagT gft_erasure_on; //per IFX request, gft_erasure_on =0 implies erasure is on
FlagT gft_allow_reset_erasure;

//Danube metrics to calculate the threshold to discard frames
FlagT gft_frame_with_lowmetric, gft_cal_discard_metric_threshold = 1;
uint16 gus_metric_eval_cnt, gus_metric_eval_period = 4000;
uint16 gus_lowmetric_discard_cnt, gus_lowmetric_discard_max = 17;
uint16 gus_lowmetric_detect_cnt, gus_lowmetric_detect_period = 40;
uint8 guc_metric_discard_threshold;
uint8 guc_max_metric;
uint8 guc_min_metric = 0xFF;
uint32 gul_num_frame_lowmetric;
#endif //#if defined (DANUBE_WB) || defined (VR9_ERASURE)



#ifdef TX_NOISESHAPER_RESET
int8 gc_afeResetDelayCnt;         // Used to control timing of applying reset to Noise shaper to stop periodic self noise.
#endif
// this structure is used in both DMT and BIS regardless of the name!!!
ME_HDLC_Params_t gt_ME_HDLC_Params;     // ME_HDLC parameters
FineGainInfo_t gt_FineGainInfo;

/*********************************************************/
/***** map following variables to LOCAL LD ST memory *****/
/*********************************************************/

DATA_MAP_LOCAL_LD_ST_BEGIN

/*  Modem configuration variables */
int16 gs_TxNumTones;
int16 gs_TxFirstChannel;
int16 gs_TxLastChannel;
int16 gs_TxFirstBd_LeftChn, gs_TxFirstBd_RightChn, gs_TxSecondBd_LeftChn, gs_TxSecondBd_RightChn;
int16 gs_TxFftLength;
int16 gs_TxLog2FftLength1;
int16 gs_TxCPLength;
int16 gs_TxLog2FftScaling;

#ifdef ADSL_62
// Vr9 uses an oversampled IFFT.
// In order to share the code with 3.x, 4.x and 5.x,  we let gs_TxFftLength = TX_IFFT_LENGTH = 2*TX_NUM_TONES
// but use gs_TxFftLength_Oversample when configuraring QT/FT/FTB/FDF
int16 gs_TxFftLength_Oversample;
int16 gs_TxLog2FftLength1_Oversample;
int16 gs_TxCPLength_Oversample;
#endif

int16 gs_RxNumTones;
int16 gs_RxLog2NumTones;
int16 gs_RxFirstChannel;
int16 gs_RxBitLoadFirstChannel;
int16 gs_RxLastChannel;
int16 gs_RxBitLoadLastChannel;
int16 gs_RxFftLength;
int16 gs_RxLog2FftLength1;
int16 gs_RxCPLength;
int16 gs_RxLog2FftScaling;
int16 gs_RxSamplesPerFrame;
int16 gs_Log2RxSamplesPerFrame;

int16 gs_DS2US_RateRatio;
int16 gs_Log2DS2US_RateRatio;

int16 gus_TxSineGain ; /*  applied Tx gain */
int16 gus_TxGain_NoCutBack ;
int16 gus_TxGain_NoCutBack_3A ;
int16 gus_TxGain_NoCutBack_3L ;
int16 gus_TxGain_NoCutBack_3M ;
int16 gus_TxGain_NoCutBack_5A ;
int16 gus_TxGain_NoCutBack_5M ;

uint8 guca_QLN[RX_NUM_TONES];   // XDSLRTFW-441

/* TCM/Max Concatenated (RS+TCM) Coding gain*/
/* By default the first two variables are used. Only in interleave path of G992.1/2,
   do the _intlv_ variables used (the change takes place in DecodeCInfo1) */
int16 gs_tcm_coding_gain ;
int16 gs_max_coding_gain ;
int16 gs_intlv_tcm_coding_gain ;
int16 gs_intlv_max_coding_gain ;

int16 gs_Capacity;
int16 gs_RxExtraBits ;                                          /* extra bits allocated due to use fine gains */
int16 *gpsa_MeasuredSnrBuf;                                             /* pointer to meansured SNRs */
uint8 guc_MaxAllocBitsPerTone ; /* maximum bits per tone allocated to upstream channel */
uint8 guc_Log2MaxConstSize;                                             /* maximum allowed bits per tone for downstream channel */
int16 gs_HighestAllowedRxTone;
//int16 gsa_RxFineGainPlusBitChannel[RX_LAST_CHANNEL+1];                                                                                                /*  store indices of channels where a extra bit is used */
int16 *gsa_RxFineGainPlusBitChannel;

int16 gs_max_fine_gain;         // max fine  gain
int16 gs_min_fine_gain;         // min fine gain

/*  SNR's (in dB) required for QAM */
int16 gsa_ConstellationSNR[16] ;

int16 gsa_SNRRequired[RX_MAX_BITS_PER_TONE+1];  /* required SNR buffer */

int16 gs_HPFEq_actual;
int16 gs_HybA_actual;
int16 gs_HybB_actual;

/* Sync */
uint16 gus_SyncOffset ;                                                         /*  offset in words to beginning of code word */
uint16 gus_SyncOffset_Corr_Method;                                      /*  offset in words to beginning of code word, calculated by max correlation method */
int16 gs_SyncOffsetDelta;                                               /* Original Sync offset delta between gus_SyncOffset and gus_SyncOffset_Corr_Method*/
int16 gs_PreSyncOffset ;
uint8 guc_AlignmentPreProcState;
uint8 guc_AlignmentTrainingState;
uint8 guc_AlignmentPostProcState;
uint8 guc_log_idx;
uint8 guca_NMS_dbg[6*1024];

   int16 *gpsa_RCReverb_Quiet_Snr;
   int16 *gpsa_RCReverb_Silence_Snr;
   int16 *gpsa_PGA_Snr;
   int16 *gpsa_deltaPGA_Snr;
   int16 *gpsa_Medley_Vector;
   int16 *gpsa_New_NMS_Vector;

int16  *gpsa_EchoLog            ; //overlay with gpsa_Medley_Vector
int16  *gpsa_NMS_Vector     ; //Pointer to NMS
uint8 *gpuca_NMSPilotLog; //pointer to ping/pong buffer of size 2k
//uint32 guca_bhadra_Rev2_SymLog[16];
//uint8 guca_bhadra_Rev2_subState[20];
uint32 gsa_RxBitSwap_Before[16];
uint32 gsa_RxBitSwap_Decision[16];
uint32 gsa_RxBitSwap_After[16];
uint16 gsa_SNR_update_cnt[16];
int16  gs_brk_dbg;


DATA_MAP_END
//XDSLRTFW-3603 (start)
 uint8 guc_NoTones_Qln = 180;
 uint8 guc_NoTones_Qln_Force = 160;
 uint8 guc_NOISE_THRESHOLD_138;
 uint16 gus_XtalkLowerThan_m138dBmHz;
 //XDSLRTFW-3603 (End)

DATA_BULK_DATA2_BEGIN
int16 gsa_NMS_Vector[RX_NUM_TONES];
#ifdef DEBUG_STREAMING
uint8 guca_DSH_R_PARAMS_debug[2500];
#endif
DATA_MAP_END

/*********************************************************/
/***** end mapping to LOCAL LD ST memory *****/
/*********************************************************/

//XDSLRTFW-254  XDSLRTFW-221 Feature_ALL_T1413_ALL_Bringup (START)
int32 gl_t1413_crevelle_tone_power = 0;  //T1413 - CReveille Tone Linear Power
int16 gs_t1413_crevelle_tone_power_dB = 0; //T1413 - CReveille Tone Power in dB Q8.8
int16 gs_t1413_PGA_set = 0;  //Debug
int16 gs_t1413_tdq_exp = 0;  //Debug
//XDSLRTFW-254  XDSLRTFW-221 Feature_ALL_T1413_ALL_Bringup (END)

int16 gsa_TxToneBufArray[TX_FFT_LENGTH+2];                      /*  tone buffer prior to IFFT (Tx)  */

int16 gs_TxReverb12FirstCh;
#ifdef ISDN
// IOP_DS_DMT_TI_UseBroaderTxReverbSignal (Start_End)
int16 gs_TxReverb12LastCh;
#endif
int16 gs_TxMedleyFirstCh;
int16 gs_TxMedleyLastCh;

/*  gusa_txgain[i] is the scale factor required to provide a downstream  */
/*  transmit PSD  of (-40 - (2*i)) dBm/Hz in Q4.12 format */
int16 gus_TxGainCutBackFactor ;
//const int16 gusa_txgain[32] = {
//      4096, 3254, 2584, 2053, 1631, 1295, 1029, 817,
//      649,  516,  409,  325,  258,  205,  163,  130,
//      103,  82,   65,   52,   41,   33,   26,   21,
//      16,   13,   10,   8,    6,    5,    4,    3
//};

//=========================
/*  Data Buffers */
//=========================

// Multi-purpose buffers.  These buffers are used for different purposes at different stages.
int16 *gsa_RxBuffer8X_0;
int16 *gsa_RxBuffer8X_1;

int16 *gsa_TxToneBuf ;
int16 *gsa_Showtime_TxToneBuf;

// Buffer of size (2*RX_NUM_TONES) 16-bit words
int16 *gpsa_RxToneBuf_sav2;




#ifdef ISI_ANALYSIS_ON                                                                  /* RX Cyclic Prefix (CP) buffer */
int16 gsa_RxCPBuf[RX_PREFIX_LENGTH];
int16 gsa_RxMedleyCaptureBuf[(RX_NUM_TONES*2+RX_PREFIX_LENGTH)*RX_MEDLEY_NUM_FRAMES+2]; /* RX Medley capture (CP included) buffer */
int16 gsa_RxRepFrameCaptureBuf[RX_FFT_LENGTH];  /* RX Reverb2 representative frame buffer */
int16 gsa_RxChannelEstimateBuf[RX_FFT_LENGTH];  /* RX channel estimate buffer */
#endif

#ifdef AEC_ANALYSIS_ON
int32 gl_error;
int16 gsa_RxLMSCaptureBuf[(AEC_ORDER+3)*NUM_AEC_LMS_ITERATIONS];
#endif

#ifdef SPECTRUM_ANALYSIS_ON
int16 gs_log2_NumFramesAvg_SpectrumEst; /* log2 number of frames averaged for spectrum estimation */
#endif

int16 *gsa_CQuietRefTones;                                              /*  C_Quiet signal (in frequency) */

// Required size = (2*RX_NUM_TONES+2) words.
int16 *gsa_CReverbRefTones;                                             /*  C_Reverb signal (in frequency) */

/*  SNR buffers */

#if defined(DANUBE) || defined(ADSL_62)
DATA_MAP_deILV_PTR_SPACE
#else
DATA_BULKO1_BEGIN
#endif

#ifdef CALC_REVERB_SNR
//int16 gsa_ReverbSnrBuf[RX_NUM_TONES];                         /*  REVERB SNR buffer without echo */
#endif

#ifdef CALC_REVERB_ECHO_SNR
#ifndef ADSL_62
int16 gsa_ReverbEchoSnrBuf[RX_NUM_TONES] =              /*  REVERB SNR buffer with echo */
{
#ifdef DANUBE
//int16 gsa_Amazon_BisRxAFEFiltEqOff_dB[112] = {
    9843,   9999,  10127,  10232,  10329,  10413,  10491,  10562,
    10628,  10680,  10736,  10783,  10834,  10877,  10918,  10962,
    10992,  11026,  11058,  11090,  11115,  11141,  11167,  11192,
    11218,  11236,  11256,  11282,  11295,  11315,  11333,  11350,
    11360,  11384,  11397,  11410,  11423,  11435,  11448,  11461,
    11474,  11487,  11499,  11512,  11525,  11533,  11543,  11552,
    11563,  11576,  11584,  11593,  11602,  11611,  11622,  11627,
    11640,  11652,  11657,  11666,  11673,  11682,  11691,  11704,
    11704,  11717,  11722,  11730,  11735,  11743,  11750,  11755,
    11759,  11768,  11771,  11781,  11781,  11786,  11794,  11794,
    11799,  11801,  11804,  11804,  11807,  11812,  11814,  11814,
    11816,  11822,  11822,  11826,  11830,  11833,  11839,  11846,
    11854,  11863,  11873,  11881,  11890,  11897,  11906,  11915,
    11923,  11932,  11941,  11949,  11958,  11967,  11974,  11983,

// int16 gsa_Amazon_PlusRxAFEFiltEqOff_dB[121] = {
    10490,  10800,  11041,  11220,  11374,  11499,  11604,  11694,
    11770,  11847,  11910,  11962,  12014,  12052,  12094,  12140,
    12167,  12199,  12231,  12257,  12282,  12307,  12321,  12346,
    12359,  12385,  12398,  12410,  12423,  12449,  12462,  12474,
    12487,  12500,  12513,  12526,  12526,  12538,  12551,  12564,
    12577,  12590,  12590,  12602,  12615,  12618,  12628,  12641,
    12643,  12654,  12654,  12666,  12679,  12679,  12692,  12692,
    12705,  12705,  12718,  12718,  12718,  12730,  12730,  12743,
    12743,  12756,  12756,  12756,  12769,  12769,  12782,  12782,
    12782,  12782,  12791,  12794,  12794,  12794,  12794,  12794,
    12794,  12794,  12794,  12794,  12794,  12793,  12782,  12782,
    12778,  12769,  12756,  12743,  12730,  12718,  12705,  12692,
    12678,  12654,  12641,  12615,  12590,  12577,  12550,  12526,
    12500,  12473,  12448,  12426,  12404,  12380,  12360,  12340,
    12325,  12314,  12304,  12299,  12291,  12290,  12293,  12294,
    12293,

// int16 gsa_Amazon_PlusRxAFEFiltEqOn_dB[121] = {  //same as Eqoff for danube. We switched to reference AFE setting with EqOff
    10490,  10800,  11041,  11220,  11374,  11499,  11604,  11694,
    11770,  11847,  11910,  11962,  12014,  12052,  12094,  12140,
    12167,  12199,  12231,  12257,  12282,  12307,  12321,  12346,
    12359,  12385,  12398,  12410,  12423,  12449,  12462,  12474,
    12487,  12500,  12513,  12526,  12526,  12538,  12551,  12564,
    12577,  12590,  12590,  12602,  12615,  12618,  12628,  12641,
    12643,  12654,  12654,  12666,  12679,  12679,  12692,  12692,
    12705,  12705,  12718,  12718,  12718,  12730,  12730,  12743,
    12743,  12756,  12756,  12756,  12769,  12769,  12782,  12782,
    12782,  12782,  12791,  12794,  12794,  12794,  12794,  12794,
    12794,  12794,  12794,  12794,  12794,  12793,  12782,  12782,
    12778,  12769,  12756,  12743,  12730,  12718,  12705,  12692,
    12678,  12654,  12641,  12615,  12590,  12577,  12550,  12526,
    12500,  12473,  12448,  12426,  12404,  12380,  12360,  12340,
    12325,  12314,  12304,  12299,  12291,  12290,  12293,  12294,
    12293,

#else
    /* gsa_Amazon_BisRxAFEFiltEqOff_dB[112] for the straight loop hybrid. */
    10381,  10445,  10496,  10560,  10618,  10630,  10688,  10714,
    10746,  10758,  10790,  10797,  10835,  10842,  10867,  10880,
    10899,  10893,  10925,  10918,  10938,  10950,  10957,  10976,
    10976,  10982,  10970,  10982,  10976,  11002,  10995,  11008,
    11014,  11008,  11008,  11014,  11014,  11021,  11014,  11027,
    11014,  11027,  11027,  11027,  11034,  11021,  11046,  11027,
    11034,  11021,  11040,  11008,  11034,  11027,  11014,  11021,
    11008,  11027,  11021,  11008,  11014,  11014,  11014,  11027,
    11014,  11021,  11027,  11021,  11021,  11014,  11014,  11021,
    11034,  11040,  11034,  11027,  11053,  11034,  11034,  11040,
    11053,  11059,  11059,  11066,  11053,  11046,  11053,  11066,
    11059,  11059,  11053,  11066,  11053,  11059,  11072,  11034,
    11072,  11053,  11040,  11059,  11059,  11078,  11053,  11066,
    11046,  11059,  11066,  11046,  11059,  11053,  11053,  11066,

    /* gsa_Amazon_PlusRxAFEFiltEqOff_dB[121] for the straight loop hybrid. */
    11066,  11219,  11328,  11405,  11482,  11558,  11590,  11635,
    11648,  11667,  11706,  11699,  11712,  11738,  11738,  11750,
    11757,  11770,  11776,  11776,  11776,  11763,  11795,  11776,
    11795,  11789,  11789,  11802,  11789,  11814,  11808,  11795,
    11802,  11802,  11827,  11808,  11808,  11795,  11808,  11782,
    11789,  11782,  11795,  11789,  11795,  11789,  11795,  11782,
    11770,  11782,  11770,  11770,  11763,  11757,  11763,  11750,
    11750,  11731,  11744,  11731,  11718,  11712,  11712,  11712,
    11686,  11693,  11712,  11680,  11674,  11661,  11674,  11654,
    11648,  11654,  11654,  11642,  11642,  11635,  11629,  11622,
    11616,  11610,  11603,  11622,  11597,  11590,  11584,  11584,
    11584,  11571,  11552,  11546,  11558,  11546,  11526,  11526,
    11501,  11494,  11488,  11475,  11475,  11456,  11443,  11430,
    11418,  11398,  11386,  11386,  11373,  11379,  11334,  11334,
    11322,  11328,  11328,  11315,  11328,  11309,  11309,  11277,
    11302,

    /* gsa_Amazon_PlusRxAFEFiltEqOn_dB[121] for the straight loop hybrid. */
    11066,  11245,  11373,  11456,  11539,  11584,  11622,  11674,
    11725,  11750,  11776,  11814,  11827,  11840,  11866,  11885,
    11904,  11904,  11942,  11955,  11962,  11994,  11974,  12019,
    12032,  12051,  12064,  12083,  12070,  12096,  12109,  12109,
    12128,  12154,  12166,  12160,  12166,  12192,  12224,  12224,
    12230,  12230,  12262,  12282,  12275,  12282,  12282,  12288,
    12301,  12314,  12346,  12358,  12346,  12365,  12378,  12352,
    12365,  12397,  12371,  12403,  12397,  12371,  12410,  12416,
    12397,  12416,  12416,  12422,  12448,  12429,  12435,  12448,
    12461,  12461,  12454,  12461,  12467,  12467,  12480,  12480,
    12474,  12486,  12493,  12486,  12493,  12525,  12493,  12499,
    12480,  12531,  12531,  12525,  12512,  12506,  12512,  12506,
    12493,  12525,  12493,  12493,  12474,  12480,  12499,  12480,
    12493,  12474,  12474,  12467,  12474,  12429,  12461,  12429,
    12442,  12448,  12442,  12429,  12442,  12454,  12416,  12448,
    12454,
#endif //#ifdef DANUBE
};
#endif // ADSL_62
#endif // CALC_REVERB_ECHO_SNR


// Raw SNR buffer (no coding gain) at C_R_Medley.
// Required size=RX_NUM_TONES words.
#ifndef ADSL_62
int16 gsa_MedleySnrBuf[RX_NUM_TONES];
#endif

#if defined(DANUBE) || defined(ADSL_62)
DATA_MAP_END

DATA_BULKO1_BEGIN
#endif // DANUBE


//T1.413 C-ACT tone detection state and count
int16 gs_C_ACT_flag;
int16 gs_DetectCACT_State;
int16 gs_DetectCACT_AccumCount;
//XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching (Start_End)
uint32 gul_T1413_ACT_TimeOUT_Cnt;


/* Bit allocation table  */
uint8 guca_TxBat[TX_NUM_TONES];

/* Fine gain table (init to 1.0 in Q3.13 format) */
int16 gsa_TxFineGains[TX_NUM_TONES];

// variables associated with C-REVERB detection during transceiver training

int32 gl_Rx_Total_Power;                                                                /*  average received signal power */
int32 gl_Rx_Total_Power_Quiet;                                                  /*  average received signal power for Quiet state */
int32 gl_Atten_Rx_Total_Power;                                                  /* signal power used for line attenuation calculation */
int32   gl_Rx_Frame_Power;

int16 gs_num_snr_training_symbols;                      /* Number of snr training symbols  */
int16 gs_log2_num_snr_training_symbols;                 /* log2 of (Number of snr training symbols) */

int16 gs_num_fdq_training_symbols;                      /* Number of FDQ training symbols  */
int16 gs_log2_num_fdq_training_symbols;                 /* log2 of (Number of FDQ training symbols) */
//ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved (Start)
int16 gs_deltaLp_max;
//int16 gs_sraOffset;
int16 gus_Scale_FractINP;
//ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved (START)
int16 gs_delta_INP = 0;
//int16 gs_MaxLp;
//int16 gs_MinLp;
//int16 gs_MaxRateLp;
//int16 gs_MinRateLp;
uint16  gus_ToneNumNon15Bits;
FlagT gft_FrameCheckForSRA;
//ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved (END)
//ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved (End)
//ADSLRTFW-1705 : BugFix_DS_BisPlus_All_TR105SRAChanges (start)
FlagT gft_OneStepSRA = FALSE;
FlagT gft_UpShift_DSProcess = FALSE;
FlagT gft_DnShift_USProcess = FALSE;

uint16 gus_DSorUS_Process_Interval_Timer = 0;
uint16 gus_DSorUS_Process_Dbg = 0 ;

DATA_MAP_END //DATA_BULKO1_BEGIN

int16 gs_MinValBisChan_VR9 = 0;

//XDSLRTFW-3717 (Start_End)
//Removed memory section BULK_O10/PILOT_518_RAM and moved the foll tables to BULK_DATA_RAM2 memory section
DATA_BULK_DATA2_BEGIN
//Support for A21_old LIF hybrid QLN/HLOG compensation tables
#ifdef ISDN /* Annex B */
int16 gsa_VR9_PlusRxAFEFilt_A21_old_dB[129] = { /* Q9.7 */
   10272,   10272,   10272,   10304,   10304,   10323,   10336,   10381,
   10406,   10496,   10669,   10912,   11258,   11590,   11968,   12288,
   12608,   12864,   13056,   13248,   13376,   13504,   13581,   13658,
   13715,   13760,   13824,   13843,   13888,   13888,   13952,   13952,
   13952,   14003,   14016,   14016,   14016,   14035,   14074,   14080,
   14080,   14080,   14080,   14093,   14118,   14138,   14144,   14144,
   14144,   14144,   14144,   14144,   14144,   14144,   14144,   14144,
   14170,   14170,   14202,   14195,   14202,   14208,   14208,   14208,
   14208,   14208,   14208,   14208,   14208,   14208,   14208,   14208,
   14208,   14336,   14208,   14208,   14208,   14208,   14208,   14208,
   14208,   14208,   14208,   14208,   14208,   14208,   14208,   14208,
   14208,   14208,   14208,   14208,   14208,   14208,   14208,   14208,
   14208,   14208,   14208,   14208,   14208,   14208,   14208,   14208,
   14208,   14208,   14208,   14208,   14208,   14214,   14221,   14208,
   14208,   14208,   14208,   14208,   14157,   14144,   14144,   14080,
   14074,   14016,   13958,   13946,   13888,   13850,   13824,   13824, 13824
};

int16 gsa_VR9_BisRxAFEFilt_A21_old_dB[129] = { /* Q9.7 */
   6061, 6240, 6419, 6598, 6778, 6957, 7136, 7315,
   7494, 7674, 7853, 8032, 8211, 8390, 8570, 8749,
   8928, 9107, 9286, 9466, 9645, 9824,  10003,  10182,
   10368,   10547,   10746,   10925,   11130,   11290,   11462,   11648,
   11776,   11917,   12058,   12160,   12288,   12410,   12480,   12544,
   12614,   12672,   12736,   12800,   12851,   12864,   12928,   12928,
   12992,   12992,   12992,   13037,   13056,   13056,   13062,   13114,
   13120,   13120,   13120,   13152,   13184,   13184,   13184,   13184,
   13203,   13242,   13248,   13248,   13248,   13248,   13248,   13248,
   13248,   13254,   13248,   13286,   13293,   13312,   13306,   13312,
   13312,   13312,   13312,   13312,   13312,   13312,   13338,   13357,
   13376,   13376,   13376,   13376,   13376,   13376,   13376,   13376,
   13376,   13376,   13376,   13376,   13376,   13376,   13376,   13376,
   13376,   13376,   13382,   13427,   13434,   13434,   13440,   13440,
   13440,   13440,   13421,   13408,   13376,   13376,   13344,   13312,
   13254,   13248,   13184,   13171,   13120,   13075,   13056,   13056, 13056
};

int16 gsa_VR9_DMTRxAFEFilt_A21_old_dB[129] = { /* Q9.7 */
   6061, 6240, 6419, 6598, 6778, 6957, 7136, 7315,
   7494, 7674, 7853, 8032, 8211, 8390, 8570, 8749,
   8928, 9107, 9286, 9466, 9645, 9824,  10003,  10182,
   10368,   10547,   10746,   10925,   11130,   11290,   11462,   11648,
   11776,   11917,   12058,   12160,   12288,   12410,   12480,   12544,
   12614,   12672,   12736,   12800,   12851,   12864,   12928,   12928,
   12992,   12992,   12992,   13037,   13056,   13056,   13062,   13114,
   13120,   13120,   13120,   13152,   13184,   13184,   13184,   13184,
   13203,   13242,   13248,   13248,   13248,   13248,   13248,   13248,
   13248,   13254,   13248,   13286,   13293,   13312,   13306,   13312,
   13312,   13312,   13312,   13312,   13312,   13312,   13338,   13357,
   13376,   13376,   13376,   13376,   13376,   13376,   13376,   13376,
   13376,   13376,   13376,   13376,   13376,   13376,   13376,   13376,
   13376,   13376,   13382,   13427,   13434,   13434,   13440,   13440,
   13440,   13440,   13421,   13408,   13376,   13376,   13344,   13312,
   13254,   13248,   13184,   13171,   13120,   13075,   13056,   13056, 13056
};

#else
int16 gsa_VR9_AnxA_PlusRxAFEFilt_A21_old_dB[129] = { /* Q9.7 */
 10502,  10592,  10790,  11034,  11520,  11789,  12122,  12384,
 12512,  12634,  12800,  12915,  13030,  13152,  13235,  13306,
 13395,  13472,  13549,  13574,  13651,  13664,  13766,  13766,
 13792,  13837,  13830,  13888,  13901,  13926,  13952,  13952,
 13971,  14016,  14016,  14016,  14016,  14035,  14080,  14080,
 14080,  14080,  14093,  14118,  14112,  14144,  14144,  14144,
 14144,  14144,  14144,  14144,  14144,  14144,  14144,  14157,
 14170,  14157,  14189,  14202,  14208,  14208,  14208,  14208,
 14208,  14208,  14208,  14208,  14208,  14208,  14208,  14208,
 14208,  14208,  14208,  14208,  14208,  14208,  14208,  14208,
 14208,  14208,  14208,  14208,  14208,  14208,  14208,  14208,
 14208,  14221,  14208,  14208,  14208,  14208,  14208,  14208,
 14208,  14208,  14208,  14208,  14208,  14208,  14208,  14208,
 14208,  14208,  14208,  14208,  14208,  14208,  14208,  14208,
 14208,  14208,  14208,  14208,  14150,  14144,  14138,  14080,
 14080,  14016,  13958,  13946,  13888,  13862,  13824,  13824,
 13824
};

int16 gsa_VR9_AnxA_BisRxAFEFilt_A21_old_dB[129] = { /* Q9.7 */
 10189,  10189,  10189,  10189,  10189,  10221,  10240,  10323,
 10483,  10643,  10816,  10989,  11136,  11232,  11360,  11462,
 11590,  11712,  11789,  11878,  11962,  12013,  12083,  12134,
 12218,  12269,  12326,  12371,  12442,  12486,  12493,  12557,
 12582,  12621,  12646,  12685,  12742,  12742,  12800,  12806,
 12845,  12870,  12870,  12928,  12934,  12934,  12992,  12992,
 12998,  12998,  13050,  13056,  13062,  13056,  13088,  13120,
 13120,  13120,  13126,  13139,  13178,  13184,  13184,  13184,
 13203,  13235,  13248,  13248,  13248,  13248,  13248,  13248,
 13254,  13248,  13254,  13274,  13274,  13267,  13312,  13312,
 13312,  13312,  13312,  13312,  13312,  13312,  13318,  13350,
 13350,  13376,  13376,  13376,  13376,  13376,  13376,  13376,
 13376,  13376,  13376,  13376,  13376,  13376,  13376,  13376,
 13376,  13376,  13376,  13395,  13434,  13434,  13440,  13427,
 13440,  13427,  13421,  13376,  13376,  13376,  13325,  13312,
 13254,  13248,  13184,  13152,  13120,  13082,  13056,  13056,
 13056
};

int16 gsa_VR9_AnxA_DmtRxAFEFilt_A21_old_dB[129] = { /* Q9.7 */
   8870,   8947,   9024,   9101,   9178,   9254,   9331,   9408,
   9485,   9562,   9638,   9715,   9792,   9869,   9946,  10022,
  10099,  10176,  10253,  10368,  10464,  10547,  10624,  10688,
  10758,  10816,  10893,  10944,  10976,  11040,  11091,  11130,
  11194,  11219,  11251,  11309,  11347,  11392,  11405,  11456,
  11482,  11507,  11533,  11578,  11590,  11610,  11635,  11654,
  11686,  11699,  11738,  11757,  11776,  11789,  11802,  11821,
  11834,  11840,  11846,  11872,  11885,  11930,  11904,  11936,
  11962,  11962,  11968,  11987,  12006,  12006,  12000,  12019,
  12038,  12026,  12032,  12038,  12045,  12064,  12083,  12064,
  12090,  12096,  12096,  12109,  12122,  12147,  12147,  12160,
  12160,  12154,  12160,  12160,  12166,  12173,  12173,  12192,
  12179,  12205,  12198,  12192,  12205,  12205,  12198,  12218,
  12218,  12224,  12230,  12230,  12250,  12250,  12269,  12250,
  12269,  12269,  12256,  12224,  12230,  12218,  12186,  12160,
  12115,  12077,  12045,  12000,  11968,  11936,  11923,  11904,
  11913
};
#endif
DATA_MAP_END


DATA_MAP_deILV3_BIS
#ifdef ISDN /* Annex B */
int16 gsa_VR9_PlusRxAFEFilt_dB[129] = { /* Q9.7 */
   10477,   10477,   10477,   10483,   10496,   10522,   10541,   10598,
   10688,   10829,   11104,   11443,   11795,   12166,   12531,   12826,
   13088,   13318,   13504,   13664,   13760,   13862,   13939,   13990,
   14022,   14048,   14080,   14099,   14112,   14112,   14144,   14144,
   14163,   14182,   14170,   14195,   14208,   14202,   14195,   14208,
   14208,   14208,   14221,   14227,   14221,   14221,   14227,   14214,
   14227,   14221,   14259,   14234,   14208,   14214,   14214,   14214,
   14227,   14227,   14221,   14227,   14227,   14227,   14246,   14234,
   14240,   14246,   14234,   14259,   14259,   14246,   14259,   14259,
   14246,   14266,   14253,   14240,   14227,   14253,   14234,   14214,
   14227,   14214,   14221,   14234,   14234,   14234,   14221,   14240,
   14221,   14240,   14234,   14234,   14234,   14221,   14221,   14208,
   14214,   14208,   14208,   14202,   14202,   14189,   14208,   14208,
   14208,   14214,   14208,   14214,   14214,   14214,   14221,   14227,
   14208,   14208,   14202,   14202,   14170,   14144,   14118,   14080,
   14048,   14016,   13958,   13926,   13888,   13843,   13818,   13818, 13818
};

int16 gsa_VR9_BisRxAFEFilt_dB[129] = { /* Q9.7 */
   10547,   10490,   10534,   10464,   10528,   10458,   10522,   10419,
   10534,   10483,   10541,   10470,   10522,   10445,   10522,   10381,
   10541,   10483,   10534,   10464,   10528,   10611,   10861,   10854,
   11194,   11322,   11539,   11642,   11859,   11936,   12134,   12166,
   12435,   12506,   12653,   12685,   12826,   12858,   12966,   12960,
   13075,   13107,   13197,   13184,   13242,   13203,   13293,   13242,
   13312,   13312,   13344,   13318,   13363,   13331,   13370,   13338,
   13402,   13363,   13402,   13395,   13414,   13389,   13427,   13376,
   13446,   13434,   13440,   13440,   13472,   13446,   13478,   13446,
   13472,   13459,   13478,   13459,   13459,   13466,   13478,   13440,
   13472,   13459,   13485,   13453,   13491,   13459,   13504,   13472,
   13510,   13485,   13498,   13466,   13491,   13459,   13498,   13459,
   13491,   13478,   13498,   13466,   13472,   13472,   13485,   13459,
   13510,   13472,   13510,   13491,   13530,   13504,   13517,   13485,
   13536,   13517,   13523,   13472,   13466,   13427,   13414,   13370,
   13370,   13306,   13299,   13216,   13222,   13133,   13171,   13082, 13082
};

int16 gsa_VR9_DMTRxAFEFilt_dB[129] = { /* Q9.7 */
   10547,   10490,   10534,   10464,   10528,   10458,   10522,   10419,
   10534,   10483,   10541,   10470,   10522,   10445,   10522,   10381,
   10541,   10483,   10534,   10464,   10528,   10611,   10861,   10854,
   11194,   11322,   11539,   11642,   11859,   11936,   12134,   12166,
   12435,   12506,   12653,   12685,   12826,   12858,   12966,   12960,
   13075,   13107,   13197,   13184,   13242,   13203,   13293,   13242,
   13312,   13312,   13344,   13318,   13363,   13331,   13370,   13338,
   13402,   13363,   13402,   13395,   13414,   13389,   13427,   13376,
   13446,   13434,   13440,   13440,   13472,   13446,   13478,   13446,
   13472,   13459,   13478,   13459,   13459,   13466,   13478,   13440,
   13472,   13459,   13485,   13453,   13491,   13459,   13504,   13472,
   13510,   13485,   13498,   13466,   13491,   13459,   13498,   13459,
   13491,   13478,   13498,   13466,   13472,   13472,   13485,   13459,
   13510,   13472,   13510,   13491,   13530,   13504,   13517,   13485,
   13536,   13517,   13523,   13472,   13466,   13427,   13414,   13370,
   13370,   13306,   13299,   13216,   13222,   13133,   13171,   13082, 13082
};

#else
//XDSLRTFW-3250
int16 gsa_VR9_AnxA_PlusRxAFEFilt_dB[129] = { /* Q9.7 */
 10739,  10797,  11194,  11622,  12083,  12429,  12717,  12928,
 13120,  13293,  13427,  13472,  13619,  13677,  13690,  13824,
 13805,  13869,  13882,  13939,  13984,  13997,  14016,  14042,
 14042,  14106,  14093,  14074,  14112,  14118,  14144,  14118,
 14163,  14202,  14176,  14182,  14176,  14163,  14189,  14170,
 14182,  14157,  14227,  14202,  14208,  14214,  14240,  14202,
 14221,  14189,  14195,  14227,  14227,  14202,  14208,  14214,
 14189,  14240,  14208,  14214,  14195,  14227,  14189,  14240,
 14202,  14202,  14246,  14221,  14221,  14221,  14240,  14208,
 14246,  14246,  14246,  14208,  14202,  14221,  14208,  14221,
 14214,  14221,  14234,  14214,  14214,  14214,  14234,  14240,
 14227,  14214,  14214,  14189,  14221,  14234,  14221,  14195,
 14214,  14208,  14214,  14195,  14227,  14227,  14189,  14182,
 14214,  14170,  14234,  14189,  14189,  14240,  14202,  14221,
 14227,  14202,  14157,  14182,  14170,  14138,  14112,  14086,
 14048,  13965,  13926,  13907,  13882,  13850,  13792,  13798, 13798

};

int16 gsa_VR9_AnxA_BisRxAFEFilt_dB[129] = { /* Q9.7 */
 10541,  10477,  10541,  10477,  10746,  10854,  11117,  11290,
 11552,  11699,  11885,  11930,  12128,  12192,  12314,  12288,
 12499,  12518,  12634,  12627,  12762,  12736,  12826,  12794,
 12941,  12890,  12979,  12947,  12992,  12947,  13126,  13030,
 13114,  13126,  13184,  13146,  13190,  13190,  13210,  13178,
 13274,  13242,  13280,  13242,  13306,  13286,  13325,  13312,
 13318,  13312,  13376,  13331,  13382,  13318,  13318,  13293,
 13389,  13344,  13402,  13370,  13414,  13370,  13395,  13376,
 13440,  13434,  13459,  13421,  13453,  13408,  13472,  13382,
 13459,  13440,  13446,  13408,  13446,  13434,  13459,  13466,
 13453,  13421,  13446,  13421,  13498,  13459,  13459,  13402,
 13478,  13459,  13504,  13440,  13517,  13478,  13498,  13434,
 13530,  13453,  13472,  13485,  13459,  13459,  13510,  13491,
 13504,  13498,  13491,  13446,  13504,  13466,  13536,  13472,
 13510,  13510,  13517,  13446,  13466,  13395,  13408,  13363,
 13363,  13274,  13267,  13216,  13171,  13133,  13158,  13075, 13075

};

int16 gsa_VR9_AnxA_DmtRxAFEFilt_dB[129] = { /* Q9.7 */
  10541,  10477,  10541,  10477,  10746,  10854,  11117,  11290,
  11552,  11699,  11885,  11930,  12128,  12192,  12314,  12288,
  12499,  12518,  12634,  12627,  12762,  12736,  12826,  12794,
  12941,  12890,  12979,  12947,  12992,  12947,  13126,  13030,
  13114,  13126,  13184,  13146,  13190,  13190,  13210,  13178,
  13274,  13242,  13280,  13242,  13306,  13286,  13325,  13312,
  13318,  13312,  13376,  13331,  13382,  13318,  13318,  13293,
  13389,  13344,  13402,  13370,  13414,  13370,  13395,  13376,
  13440,  13434,  13459,  13421,  13453,  13408,  13472,  13382,
  13459,  13440,  13446,  13408,  13446,  13434,  13459,  13466,
  13453,  13421,  13446,  13421,  13498,  13459,  13459,  13402,
  13478,  13459,  13504,  13440,  13517,  13478,  13498,  13434,
  13530,  13453,  13472,  13485,  13459,  13459,  13510,  13491,
  13504,  13498,  13491,  13446,  13504,  13466,  13536,  13472,
  13510,  13510,  13517,  13446,  13466,  13395,  13408,  13363,
  13363,  13274,  13267,  13216,  13171,  13133,  13158,  13075, 13075
};
#endif //#ifdef ISDN
DATA_MAP_END

// Rx Bit allocation table.
// Required size = [RX_NUM_TONES] words.
uint8 guca_RxBat[RX_NUM_TONES];                                                 /* Bit allocation table             */

int16 gs_ToneDetectScale;
int16 gs_DecimatorPhaseIdx;
FlagT gft_DecimatorPhaseSelectDone;
//SMS00900615 IOP_DS_BISPLus_ALL_AllowUpshiftSRA (Start End)
FlagT gft_AllowUpshiftSRA = FALSE; //Flag is used for Allowing the Upshift SRA event

// SMS00827680 IOP_DS_CNXT_Gdmt_CPilot1Det (START)
#ifndef  ISDN // Only for Annex - A
int32 gl_Ghs_PilotAccR;
int32 gl_Ghs_PilotAccI;
int32 gl_Ghs_NoiseAccH;
int32 gl_Ghs_NoiseAccL;
int32 gl_Ghs_PilotSNR;
int16 gs_Ghs_ToneDetectScale = 10;
FlagT gft_Ghs_CPilot1Det_Enabled;
#endif // ifndef ISDN
// SMS00827680 IOP_DS_CNXT_Gdmt_CPilot1Det (END)
int16 gs_NumAttenuationSymbols;                                                 /* symbol count to compute loop attenuation */
int16 gs_MaxToneForFast ;                               /* Number of tones whose bits are allocated to fast path */
int16 gs_FirstNonzeroTone ;                                             /* Set by tone ordering function */
int16 gs_FirstNonzeroTxTone ;                                           /* First non zero Tx tone index. */
int16 gs_FirstNonzeroRxTone ;                                           /* First non zero Rx tone index. */


//XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START)
uint16 gus_NumbDsVnBrkPoints;
int16 gs_DSL_FeaturesControl;
FlagT gft_Enable_DsVnInMedley;


DATA_BULKO1_BEGIN
DsVnPSDDescriptorTable_t gt_DS_RefVirtNoiseLevel_ADSL2;

int16 *gpsa_RxSnrBufWoVN;  //Pointer refers to memory location which contains
                           //show time SNR with out virtual noise.
                           //This is used only when DS VN feature is enabled &
                           //Received DS VN PSD Break points in G.Hs & C-MSG-PCB
DATA_MAP_END

//XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (End)

DATA_BULKO2_BEGIN
#ifndef ISDN
//17 is the Adsl2AllInfo_t blocks in this memory, used for Annex-A build.
uint8 guca_hs_dummy[sizeof(Adsl2AllInfo_t)*17];
#else//
//9 is the Adsl2AllInfo_t blocks in this memory, used for Annex-B build.
uint8 guca_hs_dummy[sizeof(Adsl2AllInfo_t)*17];
#endif//ISDN
DATA_MAP_END //DATA_BULKO2_BEGIN

#ifdef PILOT_CAPTURE_518
DATA_BULKO10_BEGIN
int16 gsa_518Pilot[10000];
uint32 gul_518Pilot_Cnt;
DATA_MAP_END
#endif

// Buffer for holding Medley pseudo-random reference sequence.
// Required size = RX_FFT_LENGTH words.
int16 *gsa_RefTonesMedleySNR;


// Buffer for holding average of time-domain frames for initial frame alignment.
// Required size = RX_FFT_LENGTH words.
int16 *gsa_RxRepFrameAlignBuf;

#ifdef FLOAT_IN_SW
// Used to hold Reverb reference signal for TDQ training. Re-used by TDQ init for other purposes.
// Required size = 2*RX_NUM_TONES+2 words.
int16 *gsa_TDQTrainingSignal;

// Floating point version of TDQ input signal.
// Required size is RX_FFT_LENGTH*2 words = RX_FFT_LENGTH doublewords.
Float32 *gfa_TDQSignalIn;
#endif

// Buffer for holding average of frequency-domain frames for FDQ training
// Required size = RX_FFT_LENGTH words.
int16 *gsa_RxRepFDQTrainBuf;

//  Buffer (no coding gain) for showtime sync frame SNR computations.
// Required size = RX_NUM_TONES words
int16 *gsa_RxShowtimeSnrBuf;

//  Buffer for accumulating Rx showtime sync frame noise power.
// Accumulators are 48 bits wide (require 4 words each).
// Required size = 4*RX_NUM_TONES words
int32 *gla_RxShowtimeSnrAccumBuf;

//  Buffer for accumulating Rx showtime sync frame FFTs.
// Accumulators are 32 bits wide.
// Required size = 4*RX_NUM_TONES words
int16 *gsa_RxShowtimeFDQAccumBuf;

//  Buffer containing representative (average) sync frame FFT.
// Required size = 2*RX_NUM_TONES words
int16 *gsa_RxShowtimeFDQRepBuf;

// Buffer containing the cross correlation between the transmitted
// DEC training sequence and the average received signal
// Required size depends on DEC length and DEC upsampling factor
int32 *gla_RxDECXcorr;

// Accumulated Rx frames.  Used for multiple purposes.
// Required size = 2*(RX_FFT_LENGTH+FFT_IMPLEMENTATION_OVERHEAD) doublewords

int32 *gla_RxAccumBuf;

#ifdef NOISEACC_COMB2
int32 gla_AccumBufComb[2*(C_COMB_INDEX_CNT_G992_5 + 20)];
#endif
//int16 gsa_RxFineGains[RX_NUM_TONES];
int16 *gsa_RxFineGains;   // required size is RX_NUM_TONES


// This array has 1 bit per tone.  It can be used to indicate which tones have been changed
// when reallocating bits for a bitswap or OLR.
RxToneFlags  guca_RxBitswapTones;

// One-bit-per-tone array used to indicate which tones the CO intends to transmit starting
// with channel analysis.
RxToneFlags p_SUPPORTEDset_DS;

// One-bit-per-tone array used to indicate which tones (except the pilot) the CO will actually transmit starting
// with channel analysis.  Though this differs from the g.992.3/.5 spec, we clear the bit for the pilot
// tone so that this array may be used by bitloading to indicate which tones may be bitloaded.
// So, the DS MEDLEYset is the DS SUPPORTEDset minus the DS BLACKOUT tones and minus the pilot tone.
//
RxToneFlags p_MEDLEYset_DS;

// One-bit-per-tone array used to indicate which tones the CO intends to transmit starting
// with channel analysis.
TxToneFlags gp_SUPPORTEDset_US;

// One-bit-per-tone array used to indicate which tones (except the pilot) the CPE will actually transmit starting
// with channel analysis.  The US MEDLEYset is the US SUPPORTEDset minus the US BLACKOUT tones.
TxToneFlags gp_MEDLEYset_US;

// One-bit-per-tone array used to indicate which tones are allocated to Latency Path #1
RxToneFlags p_TonesAllocatedtoLP1_DS;
//DATA_BULKO1_BEGIN
RxToneFlags p_FINEGAINSKIPset;
//DATA_MAP_END//DATA_BULKO1_BEGIN
//============================================
// End of Data buffers
//============================================

//DO_T1413_ISSUE2 : Flags for T1.413 issue 2
FlagT gft_ShortRSilent0;        // If TRUE R-SILENT1 lasts for 100ms (HS/T1 multimode), otherwise 2 seconds.

#ifdef  T1413_SUPPORT_EES_OFF
FlagT gft_T1413_EesFlag;        // =TRUE, perform Expanded exchange sequence for T1.413 issue 2
#endif

DATA_MAP_deILV3_BIS
int16 gs_Medley_OffsetXtra;
FlagT gft_Tones1To32SupportCO = FALSE;
FlagT gft_Tones1To32SupportRT = TRUE;
FlagT gft_C_ACT_flag;
int16 gs_r_c_quiet2_wait;                  /* Wait time after detection of C_ACT, to assume it's finished */
int16 gs_NumT1Restarts;         /* Number of T1413 activation restarts due to timeout in R-QUIET2 */

// Power level threshold for tone detection
int16 gs_DetectMin;

// General purpose variable to count detections in state machine functions (preferred over using gs_RxSubStateCnt).
int16 gs_RxDetectCnt;
DATA_MAP_END

uint16  gft_FrameMode;                                                                  /*  Indicates which {0, 1, 2, 3} framing mode is used */

DATA_MAP_DMT
#ifdef ISDN
// IOP_DS_DMT_ADI_SendNcloadedEqualToZero (Start_End)
FlagT gft_ADI_ANCDA_minSNR_flag = FALSE;
#endif
// Flags and Indicators for S=1/2:
int16 gs_MuxFrameSize_Half[NUM_DATA_PATHS][2];
int16 gs_CodewordSize[NUM_DATA_PATHS][2];
int16 gs_First_Byte[2];
int16 *gpsa_RxShowtimeSnrBuf;   //showtime SNR pointer used in Rx DMT bitswap decision
FlagT gft_BitSwapPerform;               //Flag indicate the Bkgd PerformRxBitSwap status
DATA_MAP_END

#ifndef TARGET_HW
/*  Buffer sizes for DLI */
int16 gs_Tx_OutBuf_Size;                                                                /*  Tx output frame size        (in 16-bit samples) */
int16 gs_Rx_InBuf_Size;                                                                 /*  Rx input frame size (in 16-bit samples) */
int16 gs_DtoABuf_Size;                                                                  /* DAC output frame size */
int16 gs_AtoDBuf_Size;                                                                  /* ADC input buffer size */
int16 gs_TxOutSymbolCount = 0;          /*  <= 0, no tx samples output on this frame */
#endif

/* =============================================== */
/* global variable declarations for SNR margin  */
/* =============================================== */

/* Bit loading */
Adsl1_Control_t gt_ADSL1_Control;

uint16 gus_ncloaded;                                                                            /*  no. of channels with non-zero bit loads */
uint16 gus_ncloaded_LP1=0;                                                              // number of tones for LP1 with non_zero bitloading
uint16 gus_DS_max_bits_per_symbol;                                              /*  the maximum number of bits per symbol for DS channel */
uint16 gus_US_max_bits_per_symbol;                                              /*  the maximum number of bits per symbol for US channel */
int16 gs_RxDesiredMargin;                                                               /*  desired SNR margin in Q8.8 format */
// XDSLRTFW-632 XDSLRTFW_523 BugFix_DS_BisPlus_AB_All_UpdateATTNDRds_SRA (SATRT_END)
int16 gs_RxDesiredMargin_original;

//XDSLRTFW-310 Improve_BisPlus_DS_All_AdjustTargetMarginThroughCMV (Start_End)
//int16 gs_RxDesiredMargin_Delta_bis;                                           // (8.8 format) Used to adjust the DS snr margin in bitloading. //Moved to HERC CMV OPTN 28

int16 gs_RxMinRequestedSTMargin ;                                       /*  Min margin for Showtime, as requested from CO, 1 dB steps */

FlagT gft_BitloadOK ;                                           /* indicator if bit loading is done, either FAIL or SUCCEED */

int16 gs_init_AvMargin;                                                 // Average SNR margin computed at the end of Medley in Q8.8
int16 gs_init_MinMargin;                                                // Min SNR Margin at the end of Medley in Q8.8

int16 gs_RxAvMargin;                                                    /* average SNR margin in Q8.8 */
int16 gs_RxMinMargin;                                                   /* minimum SNR margin in Q8.8 */
int16 gs_RxMinMarginTone;                                               /* Tone with the minimum SNR margin */
int16 gs_MarginLimit;                                                   // Value used in computation of avg margin
int16 gs_RxAvFineGain;                                                  /* average fine gain in Q8.8  */
int16 gs_RequestedRxMaxMargin;                                  // Requested Max Margin in dB (Q8.8)
int16 gs_ExcessMarFDQBoost;                                             // FDQ boost = 1/(Fine gain reduction) [3.13 format]
int32 gl_SumFGainLinSq =0;                                              // Sum of fine gain linear square
int32 gl_SumGiSqTssiSq = 0;                                             // sum gi square tssi square
int32 gl_save_SumFGainLinSq;                                    // Saved copy of gl_SumFGainLinSq to be restored on OLR/PM abort or L2 exit.
int32 gl_save_SumGiSqTssiSq;                                    // Saved copy of gl_SumGiSqTssiSqto be restored on OLR/PM abort or L2 exit.
int16 gs_MaxNOMATP_DS = 0;                                                      // MAx NOMATP_DS
//XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(start)
int16 gs_IncBitInBinReduced;
int16 gs_RxPrevAvgMargin;
//XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(end)
int16 gs_Margin;        /* 8.8 format */
int16 gs_Margin_Point1dB; // DS snr margin with 0.1dB resolution

int16 gs_SnrMargin_OneOverTen_dB_Resolution;    // DS snr margin with 0.1dB resolution

uint16 gus_10sec_SNRUpdate;
uint16 gus_10sec_NegSNRMTimer;
uint16 gus_PrevSNRUpdateCnt;

int32 gl_MaxSumGiSqTssiSqLin;
FlagT gft_EnableNomATP = 1;
//XDSLRTFW-1564 / XDSLRTFW-1665 (Start)
FlagT gft_FTMarginTune = 0;
int16 gs_RxAvMarginOnNon15bits;
int16 gs_RxAvMarginNoCap;
int16 gs_RxAvMarginWithCap;
int16 gs_ReportMargin;
//XDSLRTFW-1564 / XDSLRTFW-1665 (End)
int16 gs_RxMaxMargin;                     /* maximum SNR margin in Q8.8 dbgVar*/
int16 gs_RxMaxMarginTone;                 /* Tone with the maximum SNR margin dbgVar*/

int16 gs_forceeven1bit_notonefound = 0;    // flag to indicate that forceeven1bit can't find a tone to add bits

int16 gsa_TotalCodingGain[2]; /*  the total coding gain in dB applied to each path       */

//XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (Start)
uint16 gus_TxPathControl;
int16  gs_DEC_SHIFT;
int16  gs_DEC_SHIFT_INIT;
//XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (End)

int16 gs_TxPayload;                                                             /*  number of payload data bytes per frame (US rate)*/
int16 gs_RxPayload;                                                             /*  number of payload data bytes per frame (DS rate) */

int16 gs_TotalBitsSupported;                                    /*  maximum number of bits supported */

DATA_MAP_deILV3_BIS
int16 gs_DetSegueFlag;                                                                  /* TX and RX communication flag */

/* Reed Solomon Coding Gain */
uint8 guca_RSCodingGain[9] ; /* in Q15.1 format */


/* Reed Solomon Coding Gain */
/*uint8 guca_CodingGain_TCMON[9][7]={
        {0,0,0,0,0,0,0},
        {24,24,24,24,24,24,24},
        {48,48,48,48,48,48,48},
        {56,56,56,56,56,56,56},
        {64,64,64,64,64,64,64},
        {72,72,72,72,72,72,72},
        {80,80,80,80,80,80,80},
        {80,80,80,80,80,80,80},
        {88,88,88,88,88,88,88}
}; */ /* in Q4.4 format */

DATA_MAP_END

// !!!Moved to LOCAL_LD_ST memory!!!
/* TCM/Max Concatenated (RS+TCM) Coding gain*/
/* By default the first two variables are used. Only in interleave path of G992.1/2,
   do the _intlv_ variables used (the change takes place in DecodeCInfo1) */
//int16 gs_tcm_coding_gain ;
//int16 gs_max_coding_gain ;
//int16 gs_intlv_tcm_coding_gain ;
//int16 gs_intlv_max_coding_gain ;

//int16 gs_Capacity;
//int16 gs_RxExtraBits ;                                                /* extra bits allocated due to use fine gains */
//uint8 guc_Log2MaxConstSize;                                           /* maximum allowed bits per tone for downstream channel */
//int16 *gpsa_MeasuredSnrBuf;                                           /* pointer to meansured SNRs */
//uint8 guc_MaxAllocBitsPerTone ; /* maximum bits per tone allocated to upstream channel */
////int16 gsa_RxFineGainPlusBitChannel[RX_LAST_CHANNEL+1];                                                                                              /*  store indices of channels where a extra bit is used */
//int16 *gsa_RxFineGainPlusBitChannel;

//int16 gs_max_fine_gain;               // max fine  gain
//int16 gs_min_fine_gain;               // min fine gain

/*  SNR's (in dB) required for QAM */
//int16 gsa_ConstellationSNR[16] ;

//int16 gsa_SNRRequired[RX_MAX_BITS_PER_TONE+1];        /* required SNR buffer */

/* Sync */
//uint16 gus_SyncOffset ;                                                               /*  offset in words to beginning of code word */
//uint16 gus_SyncOffset_Corr_Method;                                    /*  offset in words to beginning of code word, calculated by max correlation method */
//int16 gs_SyncOffsetDelta;                                             /* Original Sync offset delta between gus_SyncOffset and gus_SyncOffset_Corr_Method*/
//int16 gs_PreSyncOffset ;
//uint8 guc_AlignmentPreProcState;
//uint8 guc_AlignmentTrainingState;
//uint8 guc_AlignmentPostProcState;

//int16 gs_HPFEq_actual;
//int16 gs_HybA_actual;
//int16 gs_HybB_actual;

//=================================================
/* Flags and indicators */
//=================================================
DATA_MAP_DMT
FlagT gft_RCExchRARcvFlag;                              /*  flag indicating the status of reception of C_Exch_RA */
FlagT gft_RCExch2RcvFlag;                               /*  flag indicating the status of reception of C_Exch2 */
FlagT gft_RCSegue3RcvFlag;                              /*  flag indicating the status of reception of C_Segue3 */
uint8 *gpft_RCExchRcvFlag;
uint8 *gpft2_RCExchRcvFlag;

FlagT gft_TxInFastRetrain_flag ;
FlagT gft_RxInFastRetrain_flag ;

FlagT gft_TxFastInputEnabled;           /*  (SWEngine Only) Flag for enabling TX input data reads for fast path */
FlagT gft_TxInlvInputEnabled;           /*  (SWEngine Only) Flag for enabling TX input data reads for interleaved path */


FlagT gft_FailOnCRCBurst;    /*  == TRUE, enables abort showtime on CRC error burst */
/*  == FALSE, disables abort showtime on CRC error burst */
FlagT gft_FR_trigger_on_CRC ;   /*  = TRUE, enables jump to fast retrain on CRC Burst */


FlagT gft_FastSyncAvailable_Flag;   /* Used to indicate whether the Fast Byte  */
/* MAY be used for Synchronization Control */
FlagT gft_InlvSyncAvailable_Flag;   /* Used to indicate whether the Sync Byte  */

DATA_MAP_END

FlagT gft_TcmFlag ;                                                         /* TCM coding flag (DEFAULT is OFF.) */
int16 gs_Tx_TCM_Ovhd;
int16 gs_Rx_TCM_Ovhd;

FlagT gft_RCExch1RcvFlag;                               /*  flag indicating the status of reception of C_Exch1 */
/*  This flag is also used in BIS diagmode msg exchange states */

FlagT  gft_ShowTimeFirstPassTx ;                                        /*  flag to set intial buffer sizes for showtime TX */
FlagT  gft_ShowTimeFirstPassRx ;                                        /*  flag to set intial buffer sizes for showtime RX */

FlagT gft_C_PILOT1_1A_flag      ;                                       /*  = TRUE, when C-PILOT1 or C-PILOT1A is detected */

FlagT gft_PilotOnDecTraining;                                   /*  flag indicating type of RX signal during DEC training */
FlagT gft_FlagPilotAccDone;                     /* Flag indicating to tx that pilot accumulation is done, it can start sending dec training sequence */
FlagT gft_RS_Support            ;                                               /*  flag to indicate supported Reed-Solomon code length (8 or 16) */
FlagT gft_TransferMode      ;                           /* flag indicating if ATM or STM bit is set in G.994.1 MS message */


/*  Switches, which can be turn on (FALSE) or off (TRUE) */
FlagT gft_HpfFlag;                                      /*  flag indicating if the high-pass filter should be */
/*  used (TRUE) or not (FALSE) */
//FlagT gft_CutBackOn   ;                                               /*  TX PowerCutback Enable Flag FALSE = cut back disabled */

FlagT gft_FineGainOn;                                           /*  flag indicating if US fine gain should be used (TRUE) or not (FALSE) */

FlagT gft_ShowTimeSnrFlag;                                      /*  flag indicating if SNR is calculated in showtime */
/*  FALSE - not calculated, TRUE - calculated */


FlagT gft_LOSDetectFlag;                                                /*  == TRUE, Loss Of Signal detection during showtime enabled */

FlagT gft_SEFDetectFlag;                                                /*  == TRUE, detect Severely Errored Frames */

FlagT gft_ShowtimeSnrUpdateFlag ; /* if showtime SNR has just been updated, this flag is set to TRUE */

/* when gft_IFFT_On is set to TRUE, the IFFT is triggered during the Tx Interrupt       */
/* when gft_IFFT_On is set to FALSE, the IFFT is not triggered during the Tx Interrupt  */

FlagT gft_IFFT_On;
FlagT gft_TxDataPump_On;                                                        /* Allows data pump to start independently of showtime and be Time Critical */



FlagT gft_CopyRxBuffer;
FlagT gft_RxFdqDoneIntOnly ;
FlagT gft_DisableGetRxTones ;
FlagT gft_LoadEngineFFTInput ;
FlagT gft_GetEngineFFTOutput ;
FlagT gft_GetEngineFFTOutputDone ;

FlagT gft_ReorderDEC ;  /* when TRUE, reorder DEC coefficients in background (in BgDECTrain2) */
/* when FALSE (default), reordering is done in LoadDEC */

FlagT gft_BgDetectMultiTonesResult;     // Set by BgDetectMultiTones background task.

#ifndef ISDN
// IOP_A_US_T1413_OldIFX_SwitchToTIVID (START_END)
FlagT gft_IFTN_T1413LongLoop_TIVID;
#endif
//=================================================
/* End of Flags and indicators */
//=================================================

//XDSLRTFW-340 BugFix_DS_DMT_ALL_SelectedTcModeAfterG.Hs (Start)
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (Start_End)
Report_Hsk_TCMode_t gt_ADSL_TcMode_Reprt;
//XDSLRTFW-340 BugFix_DS_DMT_ALL_SelectedTcModeAfterG.Hs (End)
FlagT gft_Anx_InformationSet = 0;

/* Others */
Config_t gt_rx_config;                                                                  /*  RX configuration */
Config_t gt_tx_config;                                                                  /*  TX configuration */
uint16 gus_tx_config_num ;                                                      /*  configuration number for TX */
uint16 gus_rx_config_num ;                                                      /*  configuration number for RX */

// Specfies Bearer Channel to Latency Path Mapping
uint8  guca_txBCnToLPp[NUM_US_BEARER_CHANNELS_SUPPORTED];
uint8  guca_rxBCnToLPp[NUM_DS_BEARER_CHANNELS_SUPPORTED];

uint16 gus_R_CRC;                                                                               /*  CRC to be transmitted        */
uint16 gus_RC_CRC_computed;                                                             /*  CRC computed in RX - primary tones */
uint16 gus_RC_CRC_received;                                                             /*  CRC received  - primary tones */
uint16 gus_RC_bkpCRC_computed;                                                  /*  CRC computed in RX - secondary tones */
uint16 gus_RC_bkpCRC_received;                                                  /*  CRC received - secondary tones */
uint16 gus_RC_meanCRC_computed;                                         /*  CRC computed in RX */
uint16 gus_RC_meanCRC_received;                                         /*  CRC received */

int16 gs_AlignmentOffset;                               /* input variable for Alignment functions */
int16 gs_CumulativeAlignmentOffset;             /* sum of the medley adjustments */
int16 gs_UC;                                            /*  Absolute Upstream Fast Retrain Power Cutback; 0 in full rate*/
int16 gs_RDC ;                                          /*  Relative Downstream Fast Retrain Power Cutback; */
int16 gs_DPF;                                           /*  Fast Retrain Politeness Power Cutback; */

DATA_MAP_DMT
/* Frame Counters */
int16 gs_MuxFrameCntTxFastPath;
int16 gs_MuxFrameCntTxInlvPath;
int16 gs_MuxFrameCntRxFastPath;
int16 gs_EOC_RateCounter;            /* Number of possible EOC frames that  */
/* may be used for Synchronization Control  */
/* until the minimum EOC rate is not maintained */

/* MAY be used for Synchronization Control */
DATA_MAP_END

uint32 gul_TotalRxDataFrameCnt;                                 // Total number of Rx frames received since start of showtime.
uint16 gus_1Sec_RxShowtimeFrameCnt;                             // 1 sec timer based on the showtime Rx Frames
uint16 gus_1Sec_TxShowtimeFrameCnt;          // XDSLRTFW-2070(Start_End)
uint16 gus_4096SymbolCnt;                 // // XDSLRTFW-2923 , A new counter for averaging gl_pll_freq_offset value for 4096 symbol
// XDSLRTFW-575: Counter Write back in ADSL mode (Start)
uint16 gus_1Sec_RxTrnFrameCnt;               // 1 sec timer based on the training Rx Frames
// XDSLRTFW-575: Counter Write back in ADSL mode (End)

//SMS00954738:Feature_AB_DS_BISPlus_ALL_IncreaseAccuracySRAStep(START)
//SMS00966298 SMS00951973 IOP_DS_BISPlus_ALL_SRATargetMarginFix (Start)
FlagT gft_SRAUpShift_process;
FlagT gft_SRADnShift_process;
//SMS00966298 SMS00951973 IOP_DS_BISPlus_ALL_SRATargetMarginFix(End)
//SMS00954738:Feature_AB_DS_BISPlus_ALL_IncreaseAccuracySRAStep(END)
/* Showtime counters for background updates*/

int16 gus_ShowtimeSNRUpdateCount;                               // Indicates number of SNR updates performed since entering showtime
int16 gus_ShowtimeFDQUpdateCount;                               // Indicates number of FDQ updates performed since entering showtime
int16 gus_ShowtimeDECUpdateCount;               // Indicates number of DEC updates performed since entering showtime

int16 gs_num_preproc_frames;                                                    /*  no. of frames processed before showtime starts */
void gNopFunction(void) {}
int16 gs_CRC_burst_thresh;


DATA_MAP_deILV3_BIS
#ifndef  ISDN  // Only for Annex - A
// PERF_DS_ALL_TI&CNXT_ChIDfrmTone1 (Start_End)
int16 gs_RxFirstChannelSave;  // Rx First chnl saved here, during RCReverb2(DMT), RCReverb3
// (Bis/Plus) while doing Chnl identification.
#endif // ifndef ISDN
uint16   gus_TxGain_NoCutBack_default;
FlagT gft_Enable_IFFT64;
#ifdef  ISDN  // Only for Annex - B
// IOP_DS_DMT_TI_ReduceHSPwrToGetLowDSPCB (Start)
// IOP_DS_DMT_ADI_ReduceReverbPwrToGetLowDSPCB (Start)
int16  gs_Required_TxPCB;
//0dB,  -1dB.   -2dB,  -3dB,  -4dB,  -5db, -6dB
uint16   gusa_TxPwrCut_Table[7] = {16384, 14602, 13014, 11599, 10338, 9213, 8212 };
// IOP_DS_DMT_TI_ReduceHSPwrToGetLowDSPCB (End)
// IOP_DS_DMT_ADI_ReduceReverbPwrToGetLowDSPCB (End)
#endif
/*  G.Hs Variables */
FlagT gft_AnxL_PSD_selected;                               /* set when we changed to anxL PSD */
int16 gs_HandShake_Cnt;                                 /* record the number of times going through GHS */
FlagT gft_EscFromFR_Flag ;                                              /*  Flag indicating G.hs is initiated from Fast Retrain */
uint8 guc_received_ACK2_count;                      // counts the number of times ACK2 message is received in response to
int32 gl_Ghs_ReferencePower_EchoLoop;
DATA_MAP_END

/* Exception handler variables */
uint32 gus_ExceptionCode;                                                               /*  exception code indicating the cause of exception */
uint16 gus_ExceptionState;                                                              /*  state where exception occurs */
uint8  guc_ErrorCode;                           /* Error Code indication in STAT 5 0 */
uint8  guc_SubErrorCode;                        /* SubError Code Indication in STAT 5 0 */
uint16 gus_WarningCode;                                                                 /* an error condition that doesn't cause exception */

// Bitload_bis exception
uint16 gus_BitloadExceptionCode;

/* AFE & PGA control variables */
int32 gl_Pa;                                                                                    /*  average received power */
int16 gs_PGA_required;                                                                  /*  receommended PGA, in dB (Q8.8) */
int16 gs_test_PGA_required;                                                             /*  debug variable to verify that PGA Set has indeed taken effect, in dB (Q8.8) */
int16 gs_PGA_margin ;                           /*  margin added to PGA cutback to provide  */
int16 gs_PGA_margin_AGC1 ;                           /* AGC1 margin added to PGA   */
int16 gs_PGA_margin_AGC2 ;                           /* AGC2 margin added to PGA  */
int16 gs_AGC1_margin = 0;

#ifdef DANUBE_AFE
int16 gs_Force_HPFEq_Setting;
int16 gs_Force_HybridReg_Setting;
int16 gs_PGA1_Calc;
int16 gs_PGA2_Calc;
#endif

int16 gs_PGA_set ;                                                                      /*  current PGA setting, in dB (Q8.8) */
int16 gs_PGA_before_lineprobe ;                                         /*  PGA value before R_LINE_PROBE_TX state */
int16 gs_PGA_Reg_Setting;
int16 gs_PGA_set_In_HLOG;                       //XDSLRTFW_3753 gs_PGA_Set back up for HLOG
int16 gs_PGA_required_In_GHS ;                                          /* PGA value in GHS after R_C_Tones_RX state */
int16 gs_PGA_required_In_RCComb1;
int16 gs_PGAStepDown;                           /* Tracks the number of PGA reduction steps during G.hs and T1413 activation. */
int16 gs_CumulAnlgGain;                         /* Cumulative analog gain used for DMT line attenuation
                                                                           Depends on PGA, Gain/Boost for Eagle 6480. Equal to PGA for all other AFE's */
int32 gl_Pa_RxOnly;
int16 gs_PGA_required_RxOnly;
int16 gs_PGA_margin_Threshold;
int16 gs_PGA_margin_delta_AnxL_BTloops; // extra pga margin delta for anxL BT loops (8.8)
int16 gs_PGA_margin_delta_DMT_VR9;

int16 gs_PGA_InitVal_For_LineProbe = PGA_INITVAL_FOR_LINEPROBE;
int16 gs_PGA_During_LineProbe = 0; /* PGA during LineProbe */


int16 gs_RxAvNoisePSD; // Average noise PSD, average of Qln (in dBmper Hz)
int16 gs_LowestMinPCB = 0; //  for some modems we will use a minimum PCB >0.
int16 gs_HighestMinPCB = 12; //  MAX_DS_POWER_CUTBACK
int16 gs_DSPCB_COMB_ALGO = 0;
int16 gs_DSPCB_GHsPOW_ALGO = 0;
int16 gs_DSPCB_Selected_ALGO = 0;
int16 gsa_DSPCB_DBG_idx = 0;
int16 gsa_DSPCB_DBG_currPCB[20];
int16 gsa_DSPCB_DBG_calcPCB[20];
int32 gla_DSPCB_DBG_pwr[20];
int16 gs_firstSupportedTone; // [ not showtime: Can move to ILV] // Tested to determine Cabinet mode applications.

/* =============================================== */
/* global variables used by Frame Sync */
/* ===============================================               */
int16 gs_CXY_Threshold;
int16 gs_CXY_Threshold_Rsh;
int16 gs_MaxEnergyRsh;

//XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR (START)
int16 gs_lpr_frmcnt;
int16 gs_lpr_frmcnt_before_drop_line; //320 symbols = 80 ms
int32 gl_TxIbFiFoWriteCnt;
//XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR (END)

DATA_MAP_DMT
/*  AOC variables */
TxAocHandlerStruc_t     gt_TxAocHandler;                                                /* structure of TX AOC handler variables */
TxAocHandlerStruc_t *gpt_TxAocHandler;                                          /* pointer to TxAocHandler data structure */
RxAocHandlerStruct_t  gt_RxAocHandler;                                          /* structure of RX AOC handler variables */
RxAocHandlerStruct_t  *gpt_RxAocHandler;                                        /* pointer to RxAocHandler data structure */

AocMsgStruc_t gt_RxAocMsgBSA;                   /* structure containing RX BSA message */
AocMsgStruc_t gt_TxAocMsgBSR;                   /* structure containing TX BSR message */
AocMsgStruc_t gt_RxMsgUTC;                              /* structure containing RX UTC message */
AocMsgStruc_t gt_RxMsgPMA;                              /* structure containing RX PMA message */
AocMsgStruc_t gt_TxMsgPMR;                      /* structure containing TX PMR message */

MessageFifo_t gt_TxAocFifo;
uint16 gus_TxAocBuffer[TXAOCBUFFER_SIZE];

int16 gus_RxAocRegister;                                /* variable to hold AOC message read from Engine Layer */
uint8 guca_AOCRxBuffer[AOC_MAX_MSG_LENGTH*AOC_MSG_REPEAT_CNT+1];
uint8 *gpuc_AOCRxPutPtr;
uint8 *gpuc_AOCRxGetPtr;
int16 gs_AOCRxDecoderState;
int16 gs_AOCRxMsgId;
int16 gs_AOCRxMsgLength;
int16 gs_AOCRxBlockLength;

FlagT gft_SendAocMsg_Flag;      /* flag to indicate if an Aoc message should be sent */
uint8 guc_AocTxMaxRetries;      /* maximum number of retries for an aoc message */
uint8 guc_aoc_msg_id ;


FlagT gft_TxBitSwapFlag ;               /* TRUE means requesting TX bit swap */
FlagT gft_RxBitSwapFlag ;               /* TRUE means requesting RX bit swap */
//XDSLRTFW-686: PERF_DS_DMT_ALL_Bitswap(start)
FlagT gft_BitswapAlgoExcecutionInProgress;
FlagT gft_InvalidSNR;
FlagT gft_InterimStrdSNRBitswapOn;
//XDSLRTFW-686: PERF_DS_DMT_ALL_Bitswap(end)
BitSwapInfoStruc_t gt_TxBitSwapInfo;    /* structure for TX bit swap information */
BitSwapInfoStruc_t gt_RxBitSwapInfo;    /* structure for TX bit swap information */

int16 gs_pre_frame_number;                              /* previous frame number */
//BugFix_DS_ADSL1_ALL_SuddenRFI (START)
//Applicable for ADSL1 mode only, i.e DMT, T1413
uint16 gus_1sec_tx_sframe_count = 0;
//BugFix_DS_ADSL1_ALL_SuddenRFI (END)
DATA_MAP_END

int16 gs_bitswap_rx_sframe_count;
int16 gs_bitswap_tx_sframe_count;               /* bitswap tx super frame count */

int32 gl_tx_sframe_count;                               /* tx super frame count */
int16 gs_tx_sframe_count_lsw;           /* tx super frame count (lower byte)*/
int16 gs_tx_sframe_count_msw;           /* tx super frame count (upper byte)*/
int32 gl_rx_sframe_count;                               /* rx super frame count */

DATA_MAP_DMT
uint8 guc_next_rx_profile_number ;      /* next RX profile number */
uint8 guc_remote_max_profiles ; /* the maximum no. of profiles supported by remote site */
uint8 guc_num_rx_profiles_stored ;                      /* number of stored RX profiles */
uint8 guc_num_tx_profiles_stored ;                      /* number of stored TX profiles */
DATA_MAP_END

/* =============================================== */
/* global variables used by FDQ() */
/* ===============================================               */
// Freq. domain equalizer coefficient mantissas
// Required size = [2*RX_NUM_TONES] words.
int16 *gsa_pre_FDQ_coef;

// Freq. domain equalizer coefficient exponents
// Required size = [RX_NUM_TONES] bytes.
uint8 *guca_pre_FDQ_exp;

/* Buffer for saving the original FDQ coef mantissas during Medley multi-sync */
// Required size = [RX_NUM_TONES*2] words.
int16 *gsa_FDQ_coef_sav;

/* Buffer for saving the original FDQ coef exponents during Medley multi-sync */
uint8 *guca_FDQ_exp_sav;

/* Buffer for saving FDQ coef mantissas with TDQ on during Medley */
// Required size = [RX_NUM_TONES*2] words.
int16 *gsa_FDQ_coef_best;

/* Buffer for saving FDQ coef exponents with TDQ on during Medley */
uint8 *guca_FDQ_exp_best;

// Buffer for holding CO Pilot estimate for DEC training.
// Required size = RX_FFT_LENGTH words.

/* =============================================== */
/* global vairables used by FDQAdjust() */
/* ===============================================               */
int16 *gsa_FDQ_coef_in;
uint8 *guca_FDQ_exp_in;
int16 *gsa_FDQ_coef_out;
uint8 *guca_FDQ_exp_out;

/* =========================================================================== */
/* global vairables used by BgNoiseAcc() and BgMedleyToReverbAccum() in Medley */
/* =========================================================================== */
int32 *gla_NoisePower;
int16 *gsa_recv_tones;
int16 gs_MedleyOffset;
int16 gs_MedleyModulo;
int16 *gsa_ref_tones;
int16 gs_TrainCnt;
int16 gs_log2_TrainCnt;
uint8 guc_TxSilence;
FlagT gft_NMSTxSilence;


/* =========================================================================== */
/* global variables used by BgDetectMultiTones_Comb()                                                   */
/* =========================================================================== */



/* =========================================================================== */
/* global variables for reporting link results to ME                                                    */
/* =========================================================================== */

int32 gla_DSDataRate[NUM_DATA_PATHS];
int32 gla_USDataRate[NUM_DATA_PATHS];

int16 gsa_DSLatency[NUM_DATA_PATHS];
int16 gsa_USLatency[NUM_DATA_PATHS];

int16 gsa_DSInp[NUM_DATA_PATHS];
int16 gsa_USInp[NUM_DATA_PATHS];



/* Counters for statistics */

//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (Start)
// TODO:Check whether it can be clubbed with "gusa_CRC_count[1]"
uint32 gul_CRC_count_ReTx = 0;
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (End)


//XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start)
uint16 gusa_CRC_count[NUM_DATA_PATHS] = { 0 , 0 };                      /*  CRC error count */
uint16 gusa_good_count[NUM_DATA_PATHS];                         /* SF's with no CRC indication */
//XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start)
uint32 gula_CRC_count[NUM_DATA_PATHS];                   // 32  crc error count.

int16 gs_CRCf_burst_count;              /*  CRC error burst count, fast path */
int16 gs_CRCi_burst_count;              /*  CRC error burst count, interleaved path */

#ifndef ADSL_62
#ifdef HERCULES_ADSL_CPE
int32 gla_g997_CRC_Runningcnt[NUM_DATA_PATHS];
int32 gla_g997_FEC_Runningcnt[3*NUM_DATA_PATHS];
int32 gla_g997_cell_bit_errs[NUM_DATA_PATHS];
int32 gla_g997_FE_CRC_Runningcnt[NUM_DATA_PATHS];
int32 gla_g997_FE_FEC_Runningcnt[NUM_DATA_PATHS];
#endif // HERCULES_ADSL_CPE

/*  Reed-Solomon error counters */
int16 gs_UncorrectableRSCodewordCnt[NUM_DATA_PATHS];    // # of uncorrectable Reed-Solomon codewords in each latency path since start of showtime.
int16 gsa_CorrectedRSErrors[NUM_DATA_PATHS] = { 0 , 0 }; // # of corrected Reed-Solomon errors (not # of corrected codewords) in each latency path since start of showtime.
uint32 gula_CorrectedRSErrors[NUM_DATA_PATHS];    // 32bit # of corrected Reed-Solomon errors in each latency path since start of showtime
int16 gsa_RSi_err_count[NUM_RS_CODE];                                   // RS error count, interleaved path

int16 gs_RCRecovBurstCnt;
#endif


TxShowTimeStruc_t gt_TxShowTimeVars;
RxShowTimeStruc_t gt_RxShowTimeVars;

/* Tone Reorder Buffers */
int16 gsa_TxToneOrder[TX_NUM_TONES];            /* Tone indices after tone ordering in TX */

// Tone indices after tone ordering in RX.
// Required size = [RX_NUM_TONES]
int16 *gsa_RxToneOrder;


DATA_MAP_SIM
TXBERTDEF gta_TxBertStat[NUM_US_BEARER_CHANNELS];    /* Tx BERT states (in a structure) */
RXBERTDEF gta_RxBertStat[NUM_DS_BEARER_CHANNELS];    /* Rx BERT states (in a structure) */

/* Global variables for BERT */
uint8 guc_BERT_DELAY = 0;                       // This (unused var) was set to 0 in HWE, 1 in SWE
uint8 guc_Start_BERT_Rx = 0;
uint8 guc_Start_BERT_Tx = 0;
DATA_MAP_END

#ifdef USE_ENGINE_FOR_BG_FFTS
//=======================================================
// Flags and parameters for engine-based background FFTs
//=======================================================
int16 gs_EngineFFTSize;                 // Size of FFT. Either 128 or 256.
int16 *gpsa_EngineFFTInput;             // Pointer to time-domain input data.
int16 *gpsa_EngineFFTOutput;            // Pointer to Fast FFT output data.
volatile FlagT gft_StartEngineFFT;                      // Flag asserted by background task to initiate Fast FFT.
volatile FlagT gft_EngineFFT_Done;                      // Flag to indicate completion of Fast FFT.
int16 gs_EngineFFT_Substate;            // Substate indicator for Fast FFT state machine.
#endif

/* ===============================================      */
/* QAM related variables                                                        */
/* ===============================================      */

/* Table of Mask bits */
CONSTANT        uint8  guca_ByteMaskTable[9] =
{
    0x0,
    0x1,
    0x3,
    0x7,
    0xF,
    0x1F,
    0x3F,
    0x7F,
    0xFF
};

// Pseudorandom bit sequence used for g.992.1/g.992.3 upstream Reverb.
// Generated by the rules:
//      d_n = 1,                                        for n=1 to 6
//      d_n = d_{n-5} XOR d_{n-6}       for n=7 to 64
// The least significant bit (LSB) of the first 16-bit value in the array is d_0, the most significant bit (MSB) is d_15.
// The LSB of the second 16-bit value is d_16, the MSB is d_31, and so on.
//
//XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching (Start)
// moved some variables to BULK01 to fit in the DM
DATA_BULKO1_BEGIN
CONSTANT        uint16 gusa_PN512Tab[64] =
{
    0xe1ff, 0x9a1d, 0x85ed, 0x2433, 0x7aea, 0x39d2, 0x9770, 0x0a57,
    0x7d54, 0xd82d, 0x0d6d, 0x8fba, 0x5967, 0xa2c7, 0x34bf, 0x18ca,
    0x5330, 0xdf93, 0xec92, 0x15a7, 0xdc8a, 0x86f4, 0x4e55, 0x2118,
    0xc440, 0xd5c4, 0x91c6, 0xcd8a, 0xd1e7, 0x094e, 0x1732, 0x83df,
    0xf0ff, 0xcd0e, 0xc2f6, 0x1219, 0x3d75, 0x1ce9, 0xcbb8, 0x052b,
    0xbeaa, 0xec16, 0x06b6, 0xc7dd, 0xacb3, 0xd163, 0x1a5f, 0x0c65,
    0xa998, 0x6fc9, 0xf649, 0x0ad3, 0x6e45, 0xc37a, 0x272a, 0x108c,
    0x6220, 0x6ae2, 0x48e3, 0xe6c5, 0x68f3, 0x04a7, 0x8b99, 0xc1ef
};
DATA_MAP_END
//XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching (End)
uint16 *gpusa_MedleySeq;

/* QAM encoder gain table */
int16 gsa_QAMEncGainTab[16] ;
/* QAM decoder constellation gain table */
int16 gsa_QAMDecGainTab[16];

DATA_BULKO1_BEGIN
int16 gsa_TxCombinedGains[TX_NUM_TONES];                /* Combined encoder gain */
DATA_MAP_END //DATA_BULKO1_BEGIN

// Rx Combined decoder gain (constellation gain * fine gain)
// Required size = [RX_NUM_TONES] words
int16 *gsa_RxCombinedGains;


DATA_MAP_deILV3_BIS
/*  Fast retrain variables */
int16 gs_US_Profile, gs_DS_Profile;
int16 gsa_rx_profile_ord[NUM_PROFILES];

FlagT gft_Quiet_Transit; //Flag indicate whether to transit to true DMT RCQuiet2RxF function or not

DATA_MAP_END

DATA_MAP_SIM
// Rx profiles (G.Lite).
// Required size is: NUM_PROFILES * (size in words of RXProfileStruc_t)
int16 RXProfile[4096] ;

int16 gsa_FRSnrBuf[256];
// Tx profiles (G.Lite).
// Required size is: NUM_PROFILES * (size in words of TXProfileStruc_t)
int16 TXProfile[4096];
DATA_MAP_END

DATA_MAP_DMT
TXProfileStruc_t *gta_TXProfile;
RXProfileStruc_t *gta_RXProfile;
DATA_MAP_END

DATA_MAP_deILV2_BIS
int16 gs_CarSet_FirstTone_For_LineProbe = R_LINEPROBE_TONE1; /*  Carrier Set First Tone for LineProbe */
int16 gsa_CarSet_During_LineProbe[NUM_LINEPROBE_TONES]; /* Carrier Set during LineProbe */

int16 gus_TxSineGain_Before_LineProbe;                                  /*  Tx sine gain before entering R_LINE_PROBE_TX state */
uint8 guc_lineprobe_cutback;                                                    /*  counts the number of 2dB cutbacks */
uint8 guc_lineprobe_iter_cnt;                                                   /*  counts the number of times we measure the energy in the harmonics during line probing */
int32 gla_HarmonicsPower[NUM_LINEPROBE_CUTBACK_CNT];    /*  Line probe Harmonics' energy */
uint16 gus_TxSineGain_InitVal_For_LineProbe = (uint16)SINEGAIN_INITVAL_FOR_LINEPROBE;
uint16 gusa_TxSineGain_During_LineProbe[NUM_LINEPROBE_CUTBACK_CNT] = {0}; /* SineGain during Iterations of LineProbe */
DATA_MAP_END //DATA_MAP_deILV2_BIS

DATA_MAP_deILV3_BIS
uint8 guca_RMsgFR1Tab[R_MSG_FR1_NUM_BYTES];                             /*  transmitted R_MSG_FR1 data */
uint8 guca_RMsgFR2Tab[R_MSG_FR2_NUM_BYTES];                             /*  transmitted R_MSG_FR2 data */
uint8 guca_R_C_Msg_FR1[R_C_MSG_FR1_NUM_BYTES];                  /*  received R_C_MSG_FR1 information */
uint8 guca_R_C_Msg_FR2[R_C_MSG_FR2_NUM_BYTES];                  /*  received R_C_MSG_FR1 information */
DATA_MAP_END

DATA_MAP_DMT
uint8 guc_ProfileLoadOK;                                                                /*  can be either FAIL or SUCCEED */
uint8 guc_TXProfileLoadOK;                                                              /*  can be either FAIL or SUCCEED */
FlagT gft_FR_Truncate_Flag ;
DATA_MAP_END

FlagT gft_QosMode ;


/* gsa_fr_cutback_thresh[0]=ConvertToDB(((0x2000^2+0x2000^2))>>RXPWR_GUARD_BITS),  */
/* in Q8.8, where RXPWR_GUARD_BITS=8 */
/* gsa_fr_cutback_thresh[n + 1] = gsa_fr_cutback_thresh[n] + 1dB */
DATA_MAP_deILV3_BIS
CONSTANT int16 gsa_fr_cutback_thresh[32] =
{
    0x3932,
    0x3a32,
    0x3b32,
    0x3c32,
    0x3d32,
    0x3e32,
    0x3f32,
    0x4032,
    0x4132,
    0x4232,
    0x4332,
    0x4432,
    0x4532,
    0x4632,
    0x4732,
    0x4832,
    0x4932,
    0x4a32,
    0x4b32,
    0x4c32,
    0x4d32,
    0x4e32,
    0x4f32,
    0x5032,
    0x5132,
    0x5232,
    0x5332,
    0x5432,
    0x5532,
    0x5632,
    0x5732,
    0x5832

};
DATA_MAP_END

#ifdef NEW_SOC_BUILD
/* =========================================================================================*/
/*  build flag                                                                                                                                                          */
/* =========================================================================================*/
int32 gl_ImageSize;
#endif

/* =========================================================================================*/
/*  debug flags                                                                                                                                                         */
/* =========================================================================================*/

FlagT gft_MedleyFlag;
FlagT gft_ISIanalysis;
FlagT gft_OfflineTdq;

int16 gs_tx_ConstSize;
int16 gs_rx_ConstSize;
int16 gs_Num1BitTones;

/* =========================================================================================*/
/*                                                                                                                                                                                      */
/* =========================================================================================*/
FlagT gft_ResetDmaPtr = FALSE;

int16 AfeCalibrateFlag;

int32 gl_FrameSyncStart;
int32 gl_FrameSyncEnd;
int32 gl_BitloadStart;
int32 gl_BitloadEnd;
int32 gl_TdqStart;
int32 gl_TdqEnd;
int32 gl_FdqStart;
int32 gl_FdqEnd;
int32 gl_DecStart;
int32 gl_DecEnd;
int32 gl_AecStart;
int32 gl_AecEnd;


/* =============================================== */
/* global variable declarations for EOC  */
/* =============================================== */
DATA_MAP_DMT
TxEocHandlerStruct_t gt_TxEocHandler;                                    /* structure of the TX EOC handler variables */
TxEocHandlerStruct_t *gpt_TxEocHandler;                                                                  /* pointer to this structure */

TxEocNetworkStruct_t gt_TxEocNetworkHandler;                                 /* structure of the TX EOC Network variables */
TxEocNetworkStruct_t *gpt_TxEocNetworkHandler;                                                   /* pointer to this structure */

RxEocHandlerStruct_t gt_RxEocHandler;                                    /* pointer to gt_RxEocHandler */
RxEocHandlerStruct_t *gpt_RxEocHandler;                                                                  /* pointer to this structure */

TxEocDgaspStruct_t gt_TxEocDgasp;
TxEocDgaspStruct_t *gpt_TxEocDgasp;                                                                              /* pointer to gt_TxEocDgasp */

uint16 gus_TxEocRegister;

/* EOC Fifo variables                                                           */
MessageFifo_t gt_TxEocFifo;
uint16 gus_TxEocBuffer[TXEOCBUFFER_SIZE];

TxEocNetworkStruct_t gt_TxEocNetworkInput;                               /* structure of the TX EOC Network variables */
TxEocNetworkStruct_t *gpt_TxEocNetworkInput;                                                     /* pointer to this structure */

/* =============================================== */
/* global variable declarations for Rx EOC*/
/* =============================================== */
RxEocDecodStruct_t gt_RxEocDecod;                       /* structure containing RX msg decoder variables */
RxEocDecodStruct_t *gpt_RxEocDecod;                                             /* pointer to gt_RxEocDecod */
RxEocReadStruct_t gt_EocRxReadBuf;
RxEocReadStruct_t *gpt_EocRxReadBuf;                                    /* pointer to gt_EocRxReadBuf */

uint16 gus_RxEocRegister;                                                               /* variable to hold EOC message at SW Engine Layer      */

/* EOC Fifo variables                                                           */
MessageFifo_t gt_RxEocFifo;
uint16 gus_RxEocBuffer[RXEOCBUFFER_SIZE];
/*  Power management variables */
FlagT gft_response_to_powerdown;                        /*  = GRANTED, if GNTPDN is received in response to REQPDN */
/*  = REJECTED, if REJPDN is received in response to REQPDN */
FlagT gft_tx_msg_pending;
uint16 gus_eoc_register_data;

/* ========================== */
/*  Global Variables for IB*/
/* ========================== */
TxIbDataStruct_t    gt_TxIbData;    /* structure containing TX Indicator Bits variables */
RxIbDataStruct_t    gt_RxIbData;        /* structure containing RX Indicator Bits variables */

DATA_MAP_END

FlagT gft_send_crc_corrupt_bits_flag ;                            /*  = FALSE, stop sending corrupt crc bits from ATU-R */
FlagT gft_receive_crc_corrupt_bits_flag ;                         /*  = FALSE, stop receiving corrupt crc bits from ATU-C */
FlagT gft_no_sync_flag;
// Sriram : Modify the UsTssi Value for Connexant CO( delete FW Retrain)
FlagT gft_USPerf_Gspn; //XDSLRTFW-1584 XDSLRTFW-1585 IOP_US_BISPlus_CNXT_USRateImprovement (START_END)

/*  global variables */
uint32 gul_RxIbInfo; /* contains 3 bytes of indicator bits for NTC processing during sync frame */

//XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (Start)
//Memory optimization. Moved the following "3" buffers from gadata.c file to VR9_1port_debug_data.c file
// (ADSL2 only) The system vendor info is obtained by sending an Inventory message to the CO.
//uint8 guca_fe_SystemVendorID[VENDOR_ID_LENGTH];
//uint8 guca_fe_SystemVersionNum[VERSION_NUM_LENGTH];
//uint8 guca_fe_SystemSerialNum[SERIAL_NUM_LENGTH];
//XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (End)

/* near end, from CPE */
// The G9941 vendor ID is sent during G.hs.
uint8 guca_ne_G9941_VendorID[VENDOR_ID_LENGTH] =
{
    G9941_COUNTRY_CODE_BYTE0,
    G9941_COUNTRY_CODE_BYTE1,
    G9941_PROVIDER_CODE_BYTE0,
    G9941_PROVIDER_CODE_BYTE1,
    G9941_PROVIDER_CODE_BYTE2,
    G9941_PROVIDER_CODE_BYTE3,
    G9941_VENDOR_INFO_BYTE0,
    G9941_VENDOR_INFO_BYTE1
};

uint8 guca_ne_SystemVendorID[VENDOR_ID_LENGTH];
uint8 guca_ne_SystemVersionNum[VERSION_NUM_LENGTH];
uint8 guca_ne_SystemSerialNum[SERIAL_NUM_LENGTH];

FlagT gft_FlagDiagMode = 0;

//T1413 Vendor ID
int16 gs_ne_T1413_VendorID = T1413_VENDOR_ID;
int16 gs_fe_T1413_VendorID = 0;
FlagT gft_SyncScalingForGenericCOinDMT;                 /* Flag used for enabling the the Sync symbol scaling for DMT mode */

/* =============================================== */
/* global variable declarations for TDQ  */
/* =============================================== */

int16 gsa_pre_tdq_h[TDQ_LENGTH];                /* TDQ filter coefficients' mantissas */
int16 gs_pre_tdq_h_exp;                                 /* TDQ filter coefficients' common exponent */

#ifndef FLOAT_IN_SW
float gf_TdqNoiseLevel;         /* noise level added to A matrix */
#else
Float32 gf_TdqNoiseLevel;       /* noise level added to A matrix */
#endif

int16 gs_TDQLen;


/* =============================================== */
/* global variable declarations for Multi TDQ  */
/* =============================================== */

int16 gs_MultiTdqFlag;                                                  /* when 1 enables MultiTdq processing                           */
int16 *gsa_MultiTdqRxSignal;            /* rotated avg C-REVERB Rx signal following             */
/* frame alignment                                                                      */

DATA_MAP_deILV2_BIS

int16 gsa_MultiTdqTaps[TDQ_LENGTH*MULTI_TDQ_FILTERS];   /* stores Multiple TDQ Filters                          */
/* sized based on max TDQ_LENGTH                        */
int16 gsa_MultiTdqCapacity[MULTI_TDQ_FILTERS+1][POSTSYNCH_SEARCH_OFFSET*2+1];
/* stores capacity for Multiple TDQ Filters                     */

int16 gsa_MultiTdqExp[MULTI_TDQ_FILTERS];               /* stores Multiple TDQ Filters                                          */
int16 gsa_MultiTdqPreSyncs[MULTI_TDQ_FILTERS];  /* stores the synch adjustments, relative to the        */
/* MultiTdqRxSignal, to be used in calculating TDQs     */
int16 gs_presync_stepsize;

#ifndef TX_NOISESHAPER_RESET
#ifdef AMAZON_AFE
// Tx tone on which to send min energy during Tx quiet in order to keep AFE noise shaper from generating periodic noise.
int16 gs_TxToneForNoiseShaper;
#endif
#endif
DATA_MAP_END


/* Fine gains adjustment to make the CO transmit more power */
int16 gs_fgain_adjust;                          /* (8.8 format) Actual amount of adjustment - gets set from gs_fgain_adjust_dmt
                                                                           for G.dmt links (for Bis it remains currently at 0, as set in InitStateMachine()*/
int16 gs_fgain_adjust_ncload3; // Very long loop threshold.


int16 gs_pre_aec_h_exp;
int16 gs_pre_aec_h_delay;
int16 gsa_pre_aec_h[AEC_ORDER];

#ifndef TARGET_HW
int16 gs_aec_h_exp;
int16 gs_aec_h_delay;
int16 gsa_aec_h[AEC_ORDER];
#endif//TARGET_HW

#ifndef FIXED_POINT_AEC
Float32 gfa_aec_h[AEC_ORDER];
#endif  /*FIXED_POINT_AEC*/

FlagT gft_ModemType ;
FlagT  gft_AutoRestartFlag ;                                            /*  = TRUE: auto restart; = FALSE: do not auto restart */

DATA_MAP_SIM
/* Rx BERT Buffer Select Flags -- Selects the Rx ping-pong buffers to be used to store the rx BERT data */
/* 0 -- Uses ping buffer to store data */
/* 1 -- Uses pong buffer to store data */
/* Concept: Since BIS has Zephyr Alphaeus running more than once, we can receive BERT Rx buffer data as the */
/* the previously received BERT buffer is being processed. Hence, for Rx path we use two bert buffers so that */
/* as we are receiving data in one BERT buffer, we are processing the other BERT buffer and the below flag is */
/* used to select the appropriate BERT buffer to receive data */
uint8 guc_BERT_RX_Select ;
DATA_MAP_END

/* Zephyr Rx Path Byte Stuffing (g.bis and g.dmt framing mode 0) and Robbing (g.dmt framing mode 0) */
/* In the absence of Alphaeus, to convey to the DSP of byte stuffing/robbing */
/* DMT Framing Mode 0:
        if(guca_fciRxBSR[x] == 0) Bytes_To_Transfer = Nominal_Bytes + 2;
        if(guca_fciRxBSR[x] == 1) Bytes_To_Transfer = Nominal_Bytes + 1;
        if(guca_fciRxBSR[x] == 3) Bytes_To_Transfer = Nominal_Bytes - 1;
   BIS Framing Mode:
        if(guca_fciRxBSR[x] == 0) Bytes_To_Transfer = Nominal_Bytes + 1;
where Nominal_Bytes is bytes allocated for the bearer channel
*/
uint8 guca_fciRxBSR[NUM_BEARER_CHANNELS];
/* Zephyr Tx Path Byte Stuffing (g.bis, Tp > 1) */
/* In the absence of Alphaeus, to convey to the DSP of byte stuffing */
/* BIS Framing Mode:
        if(guca_fciTxBS[x] == 0) Bytes_To_Transfer = Nominal_Bytes + 1;
where Nominal_Bytes is bytes allocated for the bearer channel
*/
uint8 guca_fciTxBS[NUM_BEARER_CHANNELS];

DATA_BULKO1_BEGIN
int16 gs_DS_MeasurementPeriod_ChanEst;  // Number of frames accumulated for impulse response estimate (frame align, TDQ).
int16 gs_RxLog2AccumLenChanEst;                 // Log of number of frames accumulated for impulse response estimate (frame align, TDQ).
int16 gs_RxLog2AccumLenHLin;                    // Log of number of frames accumulated for HLin estimate.

//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start)
//#ifndef ISDN  // PERF_DS_PLUS_ANNEXA_FIXED_RFI_DISTURBER_SINGLE_NOTCH SMS01364242 (Start)

uint32 cordic_ctab[24] = {0x3243F6A8, 0x1DAC6705, 0x0FADBAFC, 0x07F56EA6, 0x03FEAB76, 0x01FFD55B, 0x00FFFAAA, 0x007FFF55,
                                                  0x003FFFEA, 0x001FFFFD, 0x000FFFFF, 0x0007FFFF, 0x0003FFFF, 0x0001FFFF, 0x0000FFFF, 0x00007FFF,
                                                  0x00003FFF, 0x00001FFF, 0x00000FFF, 0x000007FF, 0x000003FF, 0x000001FF, 0x000000FF, 0x0000007F};
                                        ///*0x0000003F, 0x0000001F, 0x0000000F, 0x00000008, 0x00000004, 0x00000002, 0x00000001, 0x00000000*/};


int16 gs_activefilterfreq = 0;
int16 gs_EstimatedLoopLength;

int32 gl_Rx_QLN_Power = 0;
uint8 guc_numNotchedDisturber;
//uint8 guc_NumberOfRfiNotch;
uint8 guc_numDisturber;
int16 gs_activefilterfreq2;

int16 gs_active_Power = -2000;//(POWER_THRESHOLD_FOR_RFI_NOTCH-1885);

//int16 gs_DSL_AlgControl4;     // PERF_DS_PLUS_ANNEXA_FIXED_RFI_DISTURBER_SINGLE_NOTCH SMS01364242 (Start_End)
DATA_MAP_END //DATA_BULKO1_BEGIN
QLNInfo_t *p_QLNInfo;
vrx5afe_dsl_config_t gt_vrx5afe_dsl_config;
vrx5dfe_dsl_config_t gt_vrx5dfe_dsl_config;

//#ifndef ISDN  // PERF_DS_PLUS_ANNEXA_FIXED_RFI_DISTURBER_SINGLE_NOTCH SMS01364242 (Start)
//int16 gs_RixedRfiNotchFilterCMVControl = 1;
int16 gs_NotchFilterEnable = 0;
int16 gs_FORCEactivefilterfreq =0, gs_FORCEactivefilterfreq2=0;
//Enhance_DS_Bis_plus_DEC_Adapt_SlowDown (start_end)
uint8 guc_NoOfNotchFilters= 0;
//#endif // PERF_DS_PLUS_ANNEXA_FIXED_RFI_DISTURBER_SINGLE_NOTCH SMS01364242 (End)
 //XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (End)



FlagT gft_ADSL2_doingHlinEstimate;              // Used for ADSL2 only.  This flag indicates whether ChannelEstimate is being called
// for the first or second time.  The first time is used for the impulse response
// on which we base frame alignment and TDQ. The second time is used for calculating
// HLin and linear DS tssi.

/* Rx Interleave Startup Delay */
/* For DMT: In terms of the number of PMD Symbols */
/* For BIS: In termes of the number of muxframes */
uint16 gus_RxInterleaveStartupDelay[NUM_DATA_PATHS] = {0, 0};

/*Following variables are used when trellis is enabled*/
uint16 gus_Tx_Tcm_Num1bits ; /* Number of 1 bit loaded tones in the TX BAT table*/
uint16 gus_Rx_Tcm_Num1bits ; /* Number of 1 bit loaded tones in the RX BAT table*/
FlagT  gft_Tx_Tcm_X0_YGT1 ; /* Flag that shows if X=0, Y>=2 trellis tone pairing occurs for the given TX BAT table*/
FlagT  gft_Rx_Tcm_X0_YGT1 ; /* Flag that shows if X=0, Y>=2 trellis tone pairing occurs for the given RX BAT table*/

/* Index of first and last tones processed in the TRT table*/
/* Used for iridia IR_TONES register update when "hwengine" is used*/
uint16 gus_Rx_MinToneIndx ;
uint16 gus_Rx_MaxToneIndx ;

uint8 guc_NonZeroPart;

/* Number of Tx and Rx 'C' Channel counters */
uint8 gus_numTxC_Channel;
uint8 gus_numRxC_Channel;

/* FFT Buffer Scenario Transition  */
RxScenarioTransition_t gt_RxScenarioTransition;

/* For R_C_Medley -- Moved from Platform to Task Layer */
int16 gs_RxFirstPNbit;

/* these variables are used by handshake to indicate which bearer channels are supported, in dmt */
uint8 guc_DS_BearerChannels ; /* each bit of this variable corresponds to one bearer channel. Set that bit to indicate that bearer channel is supported. */
/* for example, if bearer channels AS0,AS1, LS0 are supported, then we need to set this variable to */
/* (AS0_DN | AS1_DN | LS0_DN) */
uint8 guc_US_BearerChannels ; /* each bit of this variable corresponds to one bearer channel. Set that bit to indicate that bearer channel is supported. */
/* for example, if bearer channels LS0 and LS1 are supported, then we need to set this variable to */
/* (LS0_UP | LS1_UP) */

/* used for hardware based sequence generation in TxProcessTones */
/* TRUE implies trigger QAM */
FlagT gft_QAM_On;
/* used to choose between iridia hardware generated tx sequence */
/* 0 -- R_REVERB, 1 -- R_SEGUE, 2 -- DMT MEDLEY, 3 -- BIS MEDLEY */
uint8 guc_sequenceToGenerate;

// Alcatel starts transmitting from tone 38.These default values are needed only for Fast Retrain.
int16 gs_RSDetect_NumBins=8;
int16 gs_RSDetect_NumBins_L2 = 8; // 8 * 4/5 // XDSLRTFQ-416 : Enhancement_ALL_BisPLus_ALL_L2
int16 gsa_RSDetect_Bins[NUM_REVERB_SEGUE_BINS] = {40, 41, 42, 43, 44, 45, 46, 47};
int16 gsa_RSDetect_PNSeq[(NUM_REVERB_SEGUE_BINS+7)>>3] = {0x39d2};
//All other modes use the below threshold and ReverbEcho Snrs to compute the above @ run time
int16 gs_RSDetect_SnrThreshold; /* in dB, Q8.8 format */

int16 gs_RxSyncToneType;        /* Specifies the Rx sync tone type i.e. Reverb(0) or Segue(1) */

int16 gs_AlignForRotation;
FlagT gft_ChanRespBeyondNyquist;

//Disables Tx scrambler for both latency paths when set to TRUE
FlagT gft_disableZephyrTxScrambler;
//Disables Rx scrambler for both latency paths when set to TRUE
FlagT gft_disableZephyrRxScrambler;
//Disables Tx Byte Flip for both latency paths when set to TRUE
FlagT gft_disableAlphaeusTxByteFlip;
//Disables Rx Byte Flip for both latency paths when set to TRUE
FlagT gft_disableAlphaeusRxByteFlip;

// Copy of 16-bit overflow registers read from the DSL engine.
uint16 gus_IRI_Tx_Ovflw;                // MTE Tx
uint16 gus_IRI_Rx_Ovflw;                // MTE Rx
uint16 gus_STR_Ovflw;                   // FDF Tx, Rx

// Tx overflow counter arrays.
// Count definitions:
//      Index           Stage
//      0                       IFFT
//      1                       POTSHPF
//      2                       Tx gain
//      3                       AEC
//      4                       DEC
uint16 gusa_TxOverflowCnts[NUM_TX_OVFLOW_CNTRS];

// Rx overflow counter arrays.
// Count definitions:
//      Index           Stage
// 0                    Rx SRC
// 1                    TDQ
// 2                    FFT
// 3                    FDQ
// 4                    Gainscale

uint16 gusa_RxOverflowCnts[NUM_RX_OVFLOW_CNTRS];


uint16 gus_RS_Overhead; /* in Q1.15 format */

DATA_MAP_deILV3_BIS
int16 gs_RoundCheckByteLite[17]= {0,1,2,2,4,4,4,8,8,8,8,8,8,16,16,16,16};
DATA_MAP_END

int16 gft_RestoreShowtimeBGState; /* set when codeswap is done and the BG showtime
                                   processing states are restored */
int16 gft_RxinitSwap;         /* Indicates whether we are going to swap during
                                r_c_reverb5 */

CONSTANT int16 gs_zero_cmv = 0;

FlagT gft_SnrOrFdqUpdate;  /* variable that controls to alternate SNR and FDQ in showtime */

// Number of loaded tones in TxBat
int16 gs_TxNumLoadedTones;

DATA_MAP_DMT
// DMT specific -- Sync frame gain
int16 gs_TxSyncFrameGain;
int16 gs_RxSyncFrameGain;
DATA_MAP_END

// Make the # of iterations for LMS based AEC training a variable
// from the previously fixed NUM_AEC_LMS_ITERATIONS(=16)
// Enables us to finish the AEC training in RCReverb1 when we use a
// 1024 samples per frame by reducing the # of iterations at run time
// Note: This is a short term fix
int16 gs_numAecLMSIterations;

// Specifes the Rx Rate Buffer Size to be used for each latency path
// Constant for Socrates where the Deilv and rate buffers are in two separate memory banks
// Variable for Socrates+ since the Deilv and rate buffers share a single memory bank
int16 gsa_RxRateBufferSize[NUM_DATA_PATHS];

//      Specifies to which CO this CPE simulation is connected...
int16 gs_COChannel;

#ifdef COLLECT_EOCAOCIB_INFO
int16 gs_RxOverheadBufferIndex, gs_InitRxOverheadBufferIndex, gs_RxOverHeadSymbolCount;
int16 gs_CollectRxOverheadInfoEnable;
#endif

#ifdef COLLECT_SHOWTIME_EVENTS_INFO
int16 gs_RxShowtimeEventsInfoBufferIndex, gs_InitRxShowtimeEventsInfoBufferIndex, gs_RxShowtimeEventsInfoEnable;
int16 gs_RxShowtimeEventsError_threshold, gs_RxShowtimeEventsInfo_SyncSymbolThreshold;
#endif


//////////////////////////////////////////////////
// Showtime Processing (moved from synsyml_Data.c)
//////////////////////////////////////////////////
FdqAdaptStruc_t gt_FdqAdaptInput;                       /*  FDQadapt input structure */
uint16 gus_ShowtimeSNRFrameCnt;                         /*  RX showtime SNR count */
uint16 gus_ShowtimeFDQFrameCnt;                         /*  FDQ adapt count */
uint8 guc_ShowtimeSnrCalcState;
uint8 guc_FdqAdaptationState;

/*  LOS Detection Variables */
uint8 guc_LOSDetectState;                   /*  LOS detection state */

//XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start)
int32 gl_AvgPilotPow;                                   /*  accumulated LOS detection power */
int32 gl_AvgPilotPow_Thresh;
int16 gs_LosDefect_state_cnt;                                   /*  number sync symbols accumulated */
uint8 guc_LosDefect_state;
//XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (End)

/*  SEF detection variables */
uint8 guc_SEFDetectState;                                       /*  SEF_DETECT_ENABLED / SEF_DETECT_DISABLED  */
int16 gs_SEF_sframe_cnt;                                        /*  number of the 2 last sync symbols that  */
FlagT gft_SEF_currentframe;
uint16 gus_SEF_totalcount;
int16 gs_sef_event_cnt;

//XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers (start)
DATA_BULKO1_BEGIN
//counter to store 4 consecutive period LCD info
int8 gca_NEFourOHPeriodLCDInfo[NUM_DATA_PATHS]; //used for storing four consecutive near end LCD defect info
int8 gca_FEFourOHPeriodLCDInfo[NUM_DATA_PATHS];//used for storing fourconsecutive near end LCD defect info
int32 gla_NESymbolCountOH[NUM_DATA_PATHS]; //used to keep track of near end OH period
int32 gla_NESymbolCountOHPeriod[NUM_DATA_PATHS];//used to store near end OH period
int32 gla_FESymbolCountOH[NUM_DATA_PATHS];//used to keep track of far end OH period
int32 gla_FESymbolCountOHPeriod[NUM_DATA_PATHS];//used to store far end OH period
DATA_MAP_END
//XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers (end)
///////////////////////////////////////
// Data Directed (DD) Snr/Fdq Updates
///////////////////////////////////////
// Flag to enable data directed snr and fdq updates. Turns of sync frame based snr/fdq updates
FlagT gft_doDDSnrFdqUpdate;
int16 gs_DD_rxFDQOutput_Buffer_Select;

// All these buffers are allocated on X-Y memory
// Buffer to save Rx data during data symbol for dd snr/fdq update
int16 *gsa_DD_rxQAMOutput;              // Required size = (2*DD_MAX_TONES_PER_SYMBOL) words.
int16 *gsa_DD_rxFDQOutput[2];   // Required size = (2*DD_MAX_TONES_PER_SYMBOL) words.

// Bufer to store 1/rx_combined_gains to avoid divide operation
int16 *gpsa_DD_1byRxCombinedGains;

// Bufer to store # of right shifts in Gain Scale Operation
int16 *gpsa_DD_RxGainScaleShifts;

// Bufer to store Noise Error
int16 *gpsa_DD_NoiseError;

// Bufer to enable fast Dual Mac based complex multiplication
int16 *gpsa_DD_CmplxMultScratchPadX, *gpsa_DD_CmplxMultScratchPadY;

// Bufer to store fdq error correlation
int16 *gpsa_DD_rxFDQErrCorrBuf;

// Handles DD state machine processing
uint8 guc_ddProcState;
int16 gs_DD_RxFirstChannel, gs_DD_RxLastChannel, gs_DD_RxChannelsPerSymbol;
int16 gs_DD_MaxRxChannelsPerSymbol;

// Slew (step size) to change fdq coef in SSLMS algorithm used by DD Fdq adaptation
int16 gs_DD_FdqAdaptSlew;

// Counters to keep track of rate of fdq adaptation
int16 gs_DD_1SecFdqUpdateCount, gs_DD_min1SecFdqUpdateCount;

// Indicates that data frame is to be discarded during DD processing
FlagT gfta_DD_discardCurrDataFrame[2];
int32 gl_DD_numDiscardedDataFrames;     // total # of data frames discarded

// Bypass XY-Decode (and XY Check) for DD processing
int32   gl_XYDec_DD_rxQAMOutput_Y32,
        gl_XYDec_DD_rxQAMOutput_Y16,
        gl_XYDec_DD_rxFDQOutput_X16,
        gl_XYDec_DD_rxFDQOutput0_X16,
        gl_XYDec_DD_rxFDQOutput1_X16,
        gl_XYDec_DD_1byRxCombinedGains_X32,
        gl_XYDec_DD_RxGainScaleShifts_X16,
        gl_XYDec_DD_NoiseError_Y16,
        gl_XYDec_DD_CmplxMultScratchPadX_X16,
        gl_XYDec_DD_CmplxMultScratchPadY_Y16,
        gl_XYDec_DD_rxFDQErrCorrBuf_X16,
        gl_XYDec_RxShowtimeSnrAccumBuf_X32,
        gl_XYDec_RxToneBuf_X32,
        gl_XYDec_FdqCoef_Y16;

/* Disable DD Processing for the duration of these number of frames to avoid instantaneous Mips peaks */
int16 gs_DD_NumFramesProcDisable;
///////////////////////////////////////

// PMD frame count of the symbol in fft/fdq buffer (logical buffer 1).
// This counter goes from 0 to 68 like gs_RxPMDFrameCnt */
// Note: gs_RxPMDFrameCnt is the data symbol currently being processed (ie.e in logical buffer 2, QAM buffer)
int16 gs_RxPMDFrameCnt_FftFdqBufferSymbol;

// showtime Timer
Timer_t gt_Timer, gt_Saved_CO_Timer;
FlagT gft_COSetTimer;   // Flag indicate that CO has sent SET TIME command

// CPE preferred PSD modes/masks shown in CLR
// -1 indicates corresponding Annex not supported
// Different PSD masks in a supported Annex are numbered from 0, 1, ..., NUM_G992_xx_PSDMASK_SUPPORTED
int16   gs_Preferred_PSDMask_G9923x[NUM_G992_3_ANNEX_SUPPORTED];
int16   gs_Preferred_PSDMask_G9925x[NUM_G992_5_ANNEX_SUPPORTED];

uint32  gul_ModeControl;

int16 gs_InitFailCauseFarEnd;
int16 gs_InitFailCauseNearEnd;

int16 gs_min_pga_setting, gs_max_pga_setting;   /* in Q8.8 format */
int16 gs_pgaStepDownValue;                                              /* in Q8.8 format */
int16 gs_min_pga_setting_RefPCB;

FlagT gft_fdqState;     //FDQ_DISABLED or FDQ_ENABLED, updated in DisableFDQ() and LoqdFDQ()

/* Used by DetectTone Algorithm for REVERB/C-TREF Detection in presence of strong echo */
int32 gl_DetectTone_RevRefPwr;
#ifdef HERCULES_ADSL_CPE
FlagT gft_PilotPowerOK;
#endif


#ifdef HERCULES_ADSL_CPE
// AFE HW configuration
AFEConfig_t gt_AFEConfig;
#endif

int16 gs_DetectTone_PwrCalcShifts;

/* Used to protect against Micro-Interruptions */
int32 gl_PilotTone_PwrThresh;           // Set to 6dB below nominal post-FDQ power level of pilot tone (8192,8192).
FlagT gft_PilotPowerOK;                         // Only valid prior to showtime. Gets set to 0 if pilot tone power is < gl_PilotTone_PwrThresh
int16 gs_DetectMicroInterrupt_PhaseErrThresh;

int16 gs_FrameBufferSize[2];
//XDSLRTFW-2893
uint32 gul_fe_G994VendorID;
uint8 guc_ClrControl;
FlagT gft_GotoFailStateOnTimeOut_FromHandshake = TRUE;
int16 gs_cl_bonding;
int16 gs_clr_bonding;


//bitswap trigger variables
int16 gs_BITSWAP_TRIGGER_DELTA;
int16 gs_Bitswap_Accept_Delta;
int16 gs_MinTargetSnrMargin;

// Temp Multi-purpose Array to store RxFineGains
int16 *gsa_TempRxFineGains;

/* Variable(s) used for RX-TX frame alignment. */
FlagT gft_TxFrameAlignEnable;
FlagT gft_RxFrameSynchDoneFlag;

// AR8_TF:IOP_ALL_BISPLus_CNXT_1bitConstellation
int16 gs_ChIdx_1bitTo2bit; // Cnxt TI AR8

/* Variable(s) used for outband signal insertion for DEC adaptation. */
int16 gs_TxOutBandGain;
uint16 gus_NumOutBandTones_right;
uint16 gus_NumOutBandTones_left;
FlagT gft_TxOutBandSignalEnable;
// XDSLRTFW-3479(Start)
FlagT gft_BlockOOBSignal_BecauseOf_OngoingUSOLR = FALSE;
// XDSLRTFW-3479(End)
uint8 guc_Iridia_Revision_Number;     // Iridia revision number. = 0x20 corresponds to 3.0 iridia BM
// = 0x21 corresponds to 3.1 iridia BM

uint8 guc_Zephyr_Revision_Number;     // Zephyr revision number. = 0x30 corresponds to 3.0 zephyr BM
// = 0x31 corresponds to 3.1 zephyr BM

uint8 guc_Strymon_Revision_Number;    // Strymon revision number. = 0x32 corresponds to 3.2 Strymon BM

Params_t gt_NearEndParam;       //near end test parameter structure variable
Params_t gt_FarEndParam;        //far end test parameter structure variable

//common variable for both BIS and DMT QLN collection
MeasurementPeriod_t gt_DS_MeasurementPeriod;

/* =============================================== */
/* From RCMedley_Data.c + */
/* =============================================== */
int16 * gsa_unpk_PN512;

int16 gs_MedleySyncOffset;      /* offset from pre-sync offset for a given TDQ */
int16 *gps_TdqFilter;           /* pointer to current set of Multi-TDQ coeffs */

int16 gs_MaxPostSync = 4;                                                       /* Max number we can complete during C-MEDLEY-TX */
int16 gs_TdqIdx;                                                        /* index pointer for current TDQ */
int16 gs_last_tdq_idx;                                          /* number of TDQ cases that will be tested. */
int16 gs_TdqOffIdx;                                                     /* index pointer for TDQ off case. */
int16 gft_OfflinePreSyncs = FALSE;                      /* flag to allow setting multi-tdq synch points offline */
int16 gs_MultiTdqTrainingState;
int16 gs_NumMultiTdq = MULTI_TDQ_FILTERS;                                       /* Number of multi-tdqs */
int16 gsa_Best[4]= {0};                                         /* stores synch point and capacity for best TDQ */
int16 gsa_Chosen[4]= {0};                                       /* stores synch point and capacity for chosen TDQ */
int16 gs_dbgChosen=1;                                           /* Debug parameter that determines max difference between Chosen and Best Tdq */
int16 gs_UnpackPNState;
FlagT gft_SkipOneFrame;
int16 gsa_FDQ_coef_pilot_UnityTdq[2];
uint8 guc_FDQ_exp_pilot_UnityTdq;
// AR8_TF: PERF_DS_Bis_CNXT_ForceUnityTDQ (Start_End)
FlagT gft_ForceUnityTDQ = FALSE; /* To enable Noise Margin Separation while Forcing Unity TDQ */

/* =============================================== */
/* end of from RCMedley_Data.c */
/* =============================================== */


uint8 *gpuca_RMSG8_LD;

/* Noise detection variables. */
uint8 guc_5T1_NOISE_THRESHOLD1;
uint8 guc_5T1_NOISE_THRESHOLD2;
uint8 guc_24HDSL_NOISE_THRESHOLD;
// Enhc_DS_ALL_ALL_ByPassPLLBWIncrease(Start)
uint8 guc_24DSL_NOISE_THRESHOLD;
uint8 guc_24DSL_NOISE_THRESHOLD1;
// Enhc_DS_ALL_ALL_ByPassPLLBWIncrease(End)
uint8 guc_M140WHITE_NOISE_THRESHOLD;
// IOP_DS_ALL_VINAX_SetWhiteNoiseLevelToM130dBmHz (Start_End)
uint8 guc_M130WHITE_NOISE_THRESHOLD;
// XDSLRTFW-1214:IOP_DS_Plus_IKNS_ShortLoopDSCRC(Start)
uint8 guc_M140WHITE_NOISE_THRESHOLDS_shortLoop;
uint8 guc_FSNB_NOISE_THRESHOLDS_shortLoop;
// XDSLRTFW-1214:IOP_DS_Plus_IKNS_ShortLoopDSCRC(End)

#ifdef ISDN
uint8 guc_ISDN_DISTURB_NOISE_THRESHOLD = 134;     //  -90 dBm/Hz
FlagT gft_ISDN_DISTURBER_Noise;
#endif

FlagT gft_5T1Noise;
FlagT gft_24HDSLNoise;
// Enhc_DS_ALL_ALL_ByPassPLLBWIncrease(Start_End)
FlagT gft_M140WhiteNoise;
// IOP_DS_ALL_VINAX_SetWhiteNoiseLevelToM130dBmHz (Start_End)
FlagT gft_M130WhiteNoise;
FlagT gft_FBnoise;
// XDSLRTFW-1214:IOP_DS_Plus_IKNS_ShortLoopDSCRC(Start)
FlagT gft_M140WhiteNoise_ShortLoop;
FlagT gft_FBnoise_ShortLoop;
// XDSLRTFW-1214:IOP_DS_Plus_IKNS_ShortLoopDSCRC(End)
//XDSLRTFW-1586 IOP_DS_A_GMX_DMT_LowRate (START)
#ifndef ISDN
FlagT gft_Adtran_GMX_DMT;
#endif
//XDSLRTFW-1586 IOP_DS_A_GMX_DMT_LowRate (END)
//XDSLRTFW-957 VR9_VRX318_ADSL_FW_PPE_MISMATCH
uint16 gus_TcModeUsed_PPE;

int16 gs_Tcm_Oh;


int16 gs_PN_US_LEN;
int16 gs_PN_US_Step;

int16 gs_MpFileControl = 1;

// Rx Clear EOC CMV structure
RxClearEocBuf_t gt_RxClearEocBuf_CMV;
uint8 *guca_Tx_ME_HDLCMsgBuffer;
uint8 *guca_Rx_ME_HDLCMsgBuffer;

// HDLC variables used for ADSL2 and DMT Clear EOC.
uint8 *guca_rx_hdlc_msg_buffer;         // Required size = MAX_RX_HDLC_MSG_SIZE-6 bytes
uint16 gus_rx_msg_index;
HDLCMsgStruct_t gt_RxHDLCMsg;
// The following global variables are primarily for debug purpose
int16 gs_Bis_OvhdMsgIndex = 2*MAX_STATES;        // Initialize the log index to be a maximum value, so that by default we
// are not going to save Rx ovhd msg into gsa_StatesTrail[] array
uint16 gus_Rx_HDLCIndex = 0;                     // Total Rx ovhd msg counter

// Counts of bad HDLC message types.
int16 gs_Invalid_Ovhd_Msg_FCS = 0;
int16 gs_Invalid_Ovhd_Msg_BadEscape = 0;
int16 gs_Invalid_Ovhd_Msg_Large = 0;
int16 gs_Invalid_Ovhd_Msg_Small = 0;

FlagT gft_HdlcMsgInProgress = FALSE;                    // If true, Rx HDLC msg being received.
FlagT gft_escape_octet_received ;                               // Last HDLC octet received was 0x7D escape character.
int16 gs_ResidualGain = 0;
int16 gs_HybridGainRef = 0;
DATA_MAP_deILV3_BIS
/* Variable(s) used during programable hybrid training. */
uint8 guc_HybTssiOff;
uint8 guc_HybNumHybrids;
int16 gs_HybIndex;
int16 gs_LoadHybIndex;
int16 gs_BgHybIndex;
int16 gs_HybridAccumCnt;
int16 gs_Log2HybridAccumCnt;
int16 gs_BgHybAccumShift;
int16 gs_HybMaxMetric;
int16 gs_HybMaxIndex;
int16 gs_HybSecondBestMetric;
int16 gs_HybSecondBestIndex;
int16 gs_HybZeroMetric;
int16 gs_HpfEqPowerBoost;
int32 gl_HybMetricSum;
int32 *gpla_BgHybAccumBuf;              // Buffer length: (2*(HYB_DECIM_FACTOR * HYB_DECIM_POINTS + 1))*sizeof(int32)
int32 *gpla_HybRevRefPwr;               // Buffer length: HYB_NUM_HYBRIDS*sizeof(int32)
int16 *gpsa_SignalPSD;                  // Buffer length: (HYB_DECIM_POINTS+1)*HYB_NUM_HYBRIDS*sizeof(int16)
#ifdef AMAZON_AFE
#ifdef HYB_REG_POINTERS
uint16 *gpusa_HybridReg0;               // Buffer length: HYB_NUM_HYBRIDS*sizeof(uint16)
#ifdef DANUBE_AFE
uint16 *gpusa_HybridReg1;               // Buffer length: HYB_NUM_HYBRIDS*sizeof(uint16)
#endif
uint16 *gpusa_HpfEqReg;                 // Buffer length: HYB_NUM_HYBRIDS*sizeof(uint16)
#else
uint16 gpusa_HybridReg0[HYB_NUM_HYBRIDS];
#ifdef DANUBE_AFE
uint16 gpusa_HybridReg1[HYB_NUM_HYBRIDS];
#endif
uint16 gpusa_HpfEqReg[HYB_NUM_HYBRIDS];
#endif
int16 *gpsa_PGARegTable;                // Buffer length: HYB_NUM_HYBRIDS*sizeof(int16)
int16 *gpsa_PGARequiredTable;   // Buffer length: HYB_NUM_HYBRIDS*sizeof(int16)
FlagT gft_VDSL2OOB_Noise; // Flag to indicate VDSL2OOB detected
#endif  /* End of #ifdef AMAZON_AFE */
DATA_MAP_END

#if defined(INFINEON) && defined(ISDN)
FlagT gft_LowAvgNoise; // strong noise, if AveragenoisePSD (in dBMper Hz) < -135
//VDSL2OOB detection
int16 gs_SignalPowerVDSL2OOB ;  //power when decimation by a factor of 4 is used
int16 gs_Dec6SignalPowerVDSL2OOB ;      //power when decimation by 6 is done
uint8 guc_PGAmarginForVDSL2OOB ; //  extra PGA pargin for VDSL2OOB noise
#endif

FlagT gft_SetPGADisable = FALSE;        /* Do not set PGA if TRUE */
FlagT gft_AFEBypassMode = FALSE;        /* Do not modify non PGA related AFE registers if TRUE. */

FlagT gft_AC_CLK_NotEnabled;

int16 gs_NE_LPR_indication;             //Near End LPR indication
int16 gs_GPIO_PowerOn;                          //value of GPIO_DyingGasp_Pin during power-on

int16 *gpsa_MedleyUnityTDQSnr;

SelfTestResult_t gt_SelfTestResult;  //Hook up with INFO 66

/* Records max phase error during noise accumulation for each of these snrs */
int16 gs_dbgMaxPhErrRev, gs_dbgMaxPhErrRevEcho, gs_dbgMaxPhErrMed;
int16 gs_dbgChoosePilot, gs_dbgChoosePilotCD;   // Set this to override pilot chosen by below code

FuncPtr_t gt_TaskFuncPtr; //Task function pointer structure

#ifndef ISDN
uint8 guc_AnnexMCarSet_Detect;
#endif


volatile int32* gl_StackMem;   //memory address of stack top

int32 gl_ShowTimeEventTrig=0; //  Used to hold status if one of the showtime Events has been triggered. Byte per event.

/* cyclic prefix insertion control */
int32 gl_CyclicPrefixInsertCnt;
int16 gs_FRCyclicPrefixInsertCnt;

int16 *gpsa_NoiseSeparationSnrAdj;
int16 gs_ReverbNoiseMarginReduction;
int16 gs_EchoNoiseMargin;
int16 gs_ISIMargin;
#ifdef AMAZON_AFE       /* Infineon Amazon-A AFE IC */
int16 gs_AlcatelReverbReductionAdj;
#endif  /* End of #ifdef AMAZON_AFE */

int16 gs_UnityTDQExp;
int16 gs_UnityTDQScalingRMS;
int16 gs_UnityTDQScalingFD;
int16 gs_UnityTDQScalingDCRatio;

// Derived frame properties, including actual latency, INP.
DerivedFrameProp_t gt_DerivedFrameProperties_DS;
DerivedFrameProp_t gt_DerivedFrameProperties_US;

#ifdef DANUBE
//Danube Tx Pseudo Rate Buffer
int16 gt_Tx_PseudoRBWRCont[2],gt_Tx_PseudoRBRDCont[2];
#ifdef AMAZON_SE
uint8 guc_postL2_fastpll_sframe;
FlagT gft_postL2_fastpll;
#endif
#endif

#ifdef HERCULES_ADSL_CPE

// used for ILVB/DILVB FIFO management RAM initialization
uint8 guc_ConfigZephyrIlvTxIFMState;
uint8 guc_ConfigZephyrIlvRxDFMState;

// # bytes to transfer from RxDTB buffer to DILVB buffer per a given frame
int16 gsa_RxDTSize[NUM_DATA_PATHS];
int16 gsa_RxDTSize_Memory[NUM_DATA_PATHS];

int16 gs_RxBitsInFifo=0;
int16 gs_RxBitsInFifo_numfailures=0;
FlagT gft_L2_Detect=0;
#endif // HERCULES_ADSL_CPE



#ifdef PCM_INTERFACE_SUPPORT
MessageOvhdFifo_t gt_PCMInterface[2]; //0: TxChannel; 1: RxChannel
uint8 guc_PCMState;             /* 0 -- off, 1 -- on, 2 -- start, 3 -- active */
int16 gsa_PCMInfo[3];   /* hooked up with PCM INFO CMV */
uint8 guca_PCMSWFIFO[PCM_FIFO_SIZE<<1];
#endif

FlagT gft_useRxWin;
INFX_CMV gt_INFX_CMV;           //INFX-specific cmv

DATA_MAP_deILV2_BIS
#if (!defined(DANUBE) && !defined(ADSL_62))
//An alternative POTS-HPF to be used to make some AFEs PSD compliant with the standard
//This filter will be used to overwrite the coeff in "gt_StrymonCPE_FilterTable" at
//the "linkstart" stage based on a CMV bit.
//Matlab-command to obtain the filter.
//prop3_hpf= firls(64,[0 9/276 28/276 1],[0 0 1 1],[50 1])';
//prop3_hpf = prop3_hpf-mean(prop3_hpf);
//prop3_hpf = 2^(1-16)*round(prop3_hpf*2^(16-1));
int16 gsa_Alt_Co_POTSHPF_1[/*MAX_POTSHPF_LEN_DIV_2*/] =
{
    (uint16)-68 , (uint16)-75 , (uint16) -76 , (uint16) -70 , (uint16) -56,
    (uint16)-32 , (uint16)   1 , (uint16)  43 , (uint16)  91 , (uint16) 143,
    (uint16)196 , (uint16) 246 , (uint16) 287 , (uint16) 314 , (uint16) 322,
    (uint16)307 , (uint16) 264 , (uint16) 190 , (uint16)  84 , (uint16) -56,
    (uint16)-226 , (uint16)-426 , (uint16)-649 , (uint16)-889 , (uint16)-1138,
    (uint16)-1388 , (uint16)-1630 , (uint16)-1855 , (uint16)-2052 , (uint16)-2216,
    (uint16)-2337 , (uint16)-2413 , (uint16) 30330
};
#endif
DATA_MAP_END

//Time period used for monitoring the Rx Delineated cell count
uint8 guc_RxCellDelineatePeriod;

// GPIO
#ifdef TARGET_HW
Gpio_t gt_Gpio;
uint32 gul_GPIO_Data = 0;                       // contains the most recent 16-bit value written to the GPIO_DATA register
int gl_AdslProgFlashLedCtr;                     // used to count the period of the programmable flash GPIO/LED signal
uint16 gus_ProgFlashState=0;            // Binary signal indicating current polarity of the programmable flash signal.
int gl_AdslProgFlashLedCtrMax=4000; // Max value of counter from which is counted down.  This value determines flash frequency.
#endif

//auto SRA related
FlagT gft_Poll_SRACond;
FlagT gft_DownShiftFlag;
FlagT gft_UpShiftFlag;
FlagT gft_AutoSRA_ErrorCondition;       // If TRUE, the CO has given inconsistent values for MIN/DSHIFT/TARGET/UPSHIFT/MAX margins.
FlagT gft_Auto_SRA_Completed;
//ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved (START)
FlagT gft_enable_new_adaptation;
//ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved (END)
uint16 gus_ra_Interval_Timer;

//OLR/PM counter, including bitswap, DRR, SRA for now
OLRPMCntInfo_t gt_DSOLRPMCnt;
OLRPMCntInfo_t gt_USOLRPMCnt;

#ifdef AMAZON_AFE       /* Infineon Amazon-A AFE IC */
#ifdef ISDN
uint16 gus_AnnexMHybridReg0;
#ifdef DANUBE_AFE
uint16 gus_AnnexMHybridReg1;
#endif
#endif
#endif  /* End of #ifdef AMAZON_AFE */

/* Annex B/M/J Interp1_3 LPF coefficients. */
// After the Interp1 filter is configured, this array is subsequently reused for
// different purposes.  The sizing of this array is based on the requirement
// for those other purposes.
uint16 gusa_AnnexBMJInterp1_3[RX_NUM_TONES>>1] =
{


#if defined(DANUBE) && defined(TARGET_HW)
#include "STR_TxInterp_AnnexM_data.h" // This file holds the iir filter designs for Danube
#else


    /* EU32_PSDMASK (Mask1) Interp1 filter. */
// i = 2*firls(51,[0 30 43.5 128]/128,[1 1 0 0],[1 4]).'

    (uint16) -12, (uint16) 27, (uint16) 90, (uint16) 116,
    (uint16) 40, (uint16) -130, (uint16) -275, (uint16) -233,
    (uint16) 54, (uint16) 428, (uint16) 573, (uint16) 250,
    (uint16) -436, (uint16) -1000, (uint16) -878, (uint16) 86,
    (uint16) 1349, (uint16) 1889, (uint16) 926, (uint16) -1312,
    (uint16) -3392, (uint16) -3341, (uint16) 106, (uint16) 6468,
    (uint16) 13442, (uint16) 17990,

    /* EU36_PSDMASK (Mask2) Interp1 filter. */
// i = 2*firls(51,[0 34 47.5 128]/128,[1 1 0 0],[1 4]).'
    (uint16) -22, (uint16) -75, (uint16) -92, (uint16) -11,
    (uint16) 141, (uint16) 223, (uint16) 95, (uint16) -210,
    (uint16) -430, (uint16) -272, (uint16) 256, (uint16) 726,
    (uint16) 593, (uint16) -236, (uint16) -1129, (uint16) -1143,
    (uint16) 76, (uint16) 1692, (uint16) 2116, (uint16) 384,
    (uint16) -2605, (uint16) -4209, (uint16) -1785, (uint16) 5099,
    (uint16) 13760, (uint16) 19766,

    /* EU40_PSDMASK (Mask3) Interp1 filter. */
// i = 2*firls(51,[0 38 51.5 128]/128,[1 1 0 0],[1 4]).'
    (uint16) 45, (uint16) 82, (uint16) 32, (uint16) -103,
    (uint16) -184, (uint16) -57, (uint16) 220, (uint16) 342,
    (uint16) 67, (uint16) -422, (uint16) -569, (uint16) -37,
    (uint16) 755, (uint16) 882, (uint16) -76, (uint16) -1299,
    (uint16) -1320, (uint16) 354, (uint16) 2246, (uint16) 2008,
    (uint16) -1025, (uint16) -4295, (uint16) -3555, (uint16) 3353,
    (uint16) 13790, (uint16) 21579,

    /* EU44_PSDMASK (Mask4) Interp1 filter. */
// i = 2*firls(51,[0 43 56.5 128]/128,[1 1 0 0],[1 4]).'
    (uint16) -46, (uint16) -77, (uint16) -2, (uint16) 136,
    (uint16) 136, (uint16) -92, (uint16) -296, (uint16) -125,
    (uint16) 328, (uint16) 467, (uint16) -70, (uint16) -720,
    (uint16) -509, (uint16) 573, (uint16) 1182, (uint16) 195,
    (uint16) -1470, (uint16) -1501, (uint16) 803, (uint16) 2832,
    (uint16) 1267, (uint16) -3242, (uint16) -5112, (uint16) 943,
    (uint16) 13404, (uint16) 23721,

    /* EU48_PSDMASK (Mask5) Interp1 filter. */
// i = 2*firls(51,[0 47 61.5 128]/128,[1 1 0 0],[1 4]).'
    (uint16) 42, (uint16) 49, (uint16) -43, (uint16) -125,
    (uint16) -13, (uint16) 200, (uint16) 151, (uint16) -216,
    (uint16) -364, (uint16) 97, (uint16) 590, (uint16) 214,
    (uint16) -712, (uint16) -721, (uint16) 572, (uint16) 1341,
    (uint16) -13, (uint16) -1889, (uint16) -1095, (uint16) 2072,
    (uint16) 2879, (uint16) -1422, (uint16) -5714, (uint16) -1337,
    (uint16) 12650, (uint16) 25599,

    /* EU52_PSDMASK (Mask6) Interp1 filter. */
// i = 2*firls(51,[0 50 66.5 128]/128,[1 1 0 0],[1 4]).'
    (uint16) -27, (uint16) -10, (uint16) 60, (uint16) 50,
    (uint16) -93, (uint16) -128, (uint16) 108, (uint16) 253,
    (uint16) -77, (uint16) -423, (uint16) -37, (uint16) 617,
    (uint16) 275, (uint16) -798, (uint16) -678, (uint16) 903,
    (uint16) 1285, (uint16) -839, (uint16) -2148, (uint16) 462,
    (uint16) 3395, (uint16) 536, (uint16) -5492, (uint16) -3315,
    (uint16) 11648, (uint16) 27235,

    /* EU56_PSDMASK (Mask7) Interp1 filter. */
// i = 2*firls(51,[0 55 70.5 128]/128,[1 1 0 0],[1 4]).'
    (uint16) 31, (uint16) -8, (uint16) -74, (uint16) 6,
    (uint16) 140, (uint16) 6, (uint16) -234, (uint16) -33,
    (uint16) 363, (uint16) 84, (uint16) -535, (uint16) -172,
    (uint16) 760, (uint16) 313, (uint16) -1053, (uint16) -535,
    (uint16) 1442, (uint16) 883, (uint16) -1988, (uint16) -1458,
    (uint16) 2841, (uint16) 2530, (uint16) -4512, (uint16) -5239,
    (uint16) 10266, (uint16) 28947,

    /* EU60_PSDMASK (Mask8) Interp1 filter. */
// i = 2*firls(51,[0 60 75.5 128]/128,[1 1 0 0],[1 4]).'
    (uint16) -31, (uint16) 16, (uint16) 71, (uint16) -45,
    (uint16) -122, (uint16) 104, (uint16) 183, (uint16) -206,
    (uint16) -244, (uint16) 364, (uint16) 289, (uint16) -593,
    (uint16) -298, (uint16) 910, (uint16) 237, (uint16) -1335,
    (uint16) -62, (uint16) 1906, (uint16) -306, (uint16) -2707,
    (uint16) 1035, (uint16) 3993, (uint16) -2645, (uint16) -6886,
    (uint16) 8407, (uint16) 30730,

    /* EU64_PSDMASK (Mask9) Interp1 filter. */
// i =2*firls(51,[0 64 75.5 128]/128, [1 1 0 0], [1 4])
    (uint16) -84, (uint16)-71, (uint16) 138, (uint16) 86,
    (uint16) -234, (uint16) -69, (uint16) 362, (uint16) 0,
    (uint16) -511, (uint16) 144, (uint16) 662, (uint16) -388,
    (uint16) -784, (uint16) 752, (uint16) 835, (uint16) -1259,
    (uint16) -755, (uint16) 1944, (uint16)  454, (uint16) -2884,
    (uint16) 246, (uint16) 4321, (uint16) -1873, (uint16) -7363,
    (uint16) 7695, (uint16) 31340,



    /* Alternative Annex A DMT/Bis Interp1 filter (cutoff frequency around tone 32). */
// i = 2*firls(25,[0 30 43.5 64]/64,[1 1 0 0],[1 8]).';
    (uint16) 25, (uint16) 226, (uint16) -115, (uint16) -553,
    (uint16) 551, (uint16) 895, (uint16) -1595, (uint16) -875,
    (uint16) 3568, (uint16) -318, (uint16) -7457, (uint16) 6184,
    (uint16) 32298

#endif  //else danube
};


/* Variable for Annex B/M/J Interp1 selection based on negotiated US PSD mask. */
int16 gs_AnnexBMJPSDMaskIdx;

// Flag indicating whether an extra IFFT scaleback is being used.  Necessary for
// certain Annex M, J masks to prevent clipping.

FlagT gft_XtraIfftCutback;



/* Variables for the margin correction due to CO TX nonlinearity. */
FlagT gft_NonLinMgnCorrEnable;
int16 gs_NonLinMgnCorr;

#ifdef INFINEON /* Infineon only feature */
/* Variables for HPF corner frequency selection. */
int16 gs_PGAatEstLoopLength;

#endif  /* End of #ifdef INFINEON */
int16 gs_pga_margin_AnxL_BTLoops; // Extra PGA margin hack required for AnxL bridge tap loops
// IOP_DS_DMT_ALL_EnableDsBitSwap (Start)
#ifndef ISDN   // Only for Anx-A
uint16 guc_TimeWindow_DS_BitSwaps;
uint16 guc_TimeWindow_DS_BitSwaps_Delay;
#endif // ifndef ISDN
// IOP_DS_DMT_ALL_EnableDsBitSwap (End)

/* Variable controlling the FDQ training for unity TDQ if multi TDQ is disabled. */
FlagT gft_TrainFdqIfMultiTdqDisabled;

/* Flag controlling the reconfiguration of the default Interp1 TX LPF filters with alternative ones. */
FlagT gft_AltInterp1TxLPF;

#ifdef VINAX_ADSL_AFE
int32 gl_DO_17MHZ = (3<<10);
int16 gft_EnableADCCal=0;

#define DEBUG_AFE

#ifndef ADSL_62
DATA_MAP_deILV2_BIS
#endif

#ifdef DEBUG_AFE // begin debug section added for Vinax ADSL
int16 debug_AFE_Analog_LA1_Reg_Content = 0;
int16 debug_AFE_Analog_LA2_Reg_Content = 0;
int16 debug_AFE_Analog_PREFI_Reg_Content = 0;
int16 debug_AFE_Analog_POSTFI_Reg_Content = 0;
int16 debug_AFE_Analog_ADC1_Reg_Content = 0;
int16 debug_AFE_Analog_ADC2_Reg_Content = 0;
int16 debug_AFE_Analog_ADC3_Reg_Content = 0;
int16 debug_AFE_Analog_DAC_Reg_Content = 0;
int16 debug_AFE_Analog_POCO_Reg_Content = 0;
int16 debug_AFE_Analog_CLKDIST_Reg_Content = 0;
int16 debug_AFE_Analog_BIAS1_Reg_Content = 0;
int16 debug_AFE_Analog_BIAS2_Reg_Content = 0;
int16 debug_AFE_Analog_BIAS3_Reg_Content = 0;
int16 debug_AFE_Analog_BIAS4_Reg_Content = 0;
int16 debug_AFE_Analog_BIAS5_Reg_Content = 0;
#endif // end debug section added for Vinax ADSL

#ifdef DEBUG_AFE // begin debug section added for Vinax ADSL
int16 debug_AFE_Digital_Reg_0_Content = 0;
int16 debug_AFE_Digital_Reg_1_Content = 0;
int16 debug_AFE_Digital_Reg_2_Content = 0;
int16 debug_AFE_Digital_Reg_3_Content = 0;
int16 debug_AFE_Digital_Reg_4_Content = 0;
int16 debug_AFE_Digital_Reg_5_Content = 0;
int16 debug_AFE_Digital_Reg_6_Content = 0;
int16 debug_AFE_Digital_Reg_7_Content = 0;
int16 debug_AFE_Digital_Reg_8_Content = 0;
int16 debug_AFE_Digital_Reg_9_Content = 0;
int16 debug_AFE_Digital_Reg_10_Content = 0;
int16 debug_AFE_Digital_Reg_11_Content = 0;
int16 debug_AFE_Digital_Reg_12_Content = 0;
int16 debug_AFE_Digital_Reg_13_Content = 0;
int16 debug_AFE_Digital_Reg_14_Content = 0;
int16 debug_AFE_Digital_Reg_15_Content = 0;
int16 debug_AFE_Digital_Reg_16_Content = 0;
int16 debug_AFE_Digital_Reg_17_Content = 0;
int16 debug_AFE_Digital_Reg_18_Content = 0;
int16 debug_AFE_Digital_Reg_19_Content = 0;
int16 debug_AFE_Digital_Reg_20_Content = 0;
int16 debug_AFE_Digital_Reg_60_Content = 0;
#endif // end debug section added for Vinax ADSL

DATA_MAP_END //DATA_MAP_deILV2_BIS
#endif  // #ifdef VINAX_ADSL_AFE
//Flag to indicate whether or not we should update the SW Rev/Seg Detector tones
FlagT gft_ChangeRSBin;

//Pre-computed Rev/Seg Detector tones before reaching showtime or OLR/PM during showtime
int16 gsa_PreSel_RSDetectBins[NUM_REVERB_SEGUE_BIN_CHECKS];

#ifdef DANUBE
// arc image/bin file variable
int32 gl_ImageSize;
#endif  // DANUBE
/*****************************************PTM CHANGES**************************************/
#ifdef DANUBE_PTM_SUPPORT
uint8 guc_PtmOctet;
uint8 guc_PtmOctet_DS_BC0;
uint8 guc_PtmOctet_US_BC0;
FlagT gft_ForcePTM;
FlagT gft_DisByteFlip;
#endif//if defined DANUBE_PTM_SUPPORT
/*********************************PTM CHANGES*************************************/
#ifdef HERC_API
DATA_MAP_HERC_API_BEGIN
HercADSL_RateCMV_t                  gt_HercADSL_USRateCMV;
HercADSL_RateCMV_t                  gt_HercADSL_DSRateCMV;

HercADSL_AINFCMV_PCB_t              gt_HercADSL_PCB;
HercADSL_AINFCMV_Framing_t          gt_HercADSL_Framing;
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping(Start_End)
HercADSL_TPS_TC_BearerChannel_t     gt_HercADSL_TPS_TC_Params[4];

//XDSLRTFW-310 Improve_BisPlus_DS_All_AdjustTargetMarginThroughCMV (Start_End)
HercADSL_OPTN_MarginControl_t       gt_HercADSL_OPTNMap_MarginControl;
// XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead
HercADSL_OPTN_EocPollControl_t      gt_HercADSL_OPTNMap_EocPollControl;

HercADSL_OPTN_ModeControl_t         gt_HercADSL_OPTNMap_ModeControl;
HercADSL_OPTN_AlgControl_t          gt_HercADSL_OPTNMap_AlgControl;
//XDSLRTFW-380: Feature_US_BisPlus_All_USSRA_CMVRemap (start_end)
HercADSL_OPTN_OlrControl_t          gt_HercADSL_OPTNMap_OlrControl;
HercADSL_INFO_ChanMeasParams_t      gt_HercADSL_INFOMap_ChanMeasParamsDS;
HercADSL_INFO_ChanMeasParams_t      gt_HercADSL_INFOMap_ChanMeasParamsUS;

HercADSL_STAT_MacroState_t          gt_HercADSL_STATMap_MacroState;
HercADSL_STAT_ModeSelect_t          gt_HercADSL_STATMap_ModeSelect;
HercADSL_FailStateInfo_t            gt_FailStateInfo_Prev;

HercADSL_g997_LinePerfCount_t           gt_HercADSL_CNTRMap_g997_NE_LinePerfCount;
HercADSL_g997_LinePerfCount_t           gt_HercADSL_CNTRMap_g997_FE_LinePerfCount;

// XDSLRTFW-575: Counter Write back in ADSL mode (Start)
HercADSL_g997_ChPerf_CRCStats_t     gt_HercADSL_CNTRMap_g997_NE_ChPerf_CRCStats;
HercADSL_g997_ChPerf_FECStats_t     gt_HercADSL_CNTRMap_g997_NE_ChPerf_FECStats;

HercADSL_g997_ChPerf_CRCStats_t     gt_HercADSL_CNTRMap_g997_FE_ChPerf_CRCStats;
HercADSL_g997_ChPerf_FECStats_t     gt_HercADSL_CNTRMap_g997_FE_ChPerf_FECStats;
// XDSLRTFW-575: Counter Write back in ADSL mode (End)


//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (start)
HercADSL_g997_NE_FE_PtmPerf_t           gt_HercADSL_CNTRMap_g997_PtmPerf_NE;
//HercADSL_g997_NE_FE_PtmPerf_t         gt_HercADSL_CNTRMap_g997_PtmPerf_FE;
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (end)
HercADSL_g997_DataPathPerfCount_t   gt_HercADSL_CNTRMap_g997_NE_DataPathPerfCount;
//XDSLRTFW-151 :Feature_AB_ALL_ALL_NE_ATM_TC_CNTRS_Mapping (Start_End)

//XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping (Start_End)
HercADSL_g997_DataPathPerfCount_t   gt_HercADSL_CNTRMap_g997_FE_DataPathPerfCount;

// XDSLRTFw-1481 (Start_End)
HercADSL_g997_DataPathFailureStatus_t gt_HercADSL_PLAMMap_g997_DataPathFailureStatus;

HercADSL_g997_NE_AtmPerf_TxCell_t        gt_g997_AtmPerf_TX_UICELL;
HercADSL_MONI_EventConfigure_t      gt_HercADSL_MONIMap_EventConfigure;
int16                               gsa_HercADSL_MONIMap_AlarmCnfg[2];
// XDSLRTFW-3648 (Start)
// Earlier we had only Parameter 2 in MODEM MONITOR 0. But now due to POWER DOWN state, we have 3 parameters
// in MODEM MONITOR 0. Hence, we need to increase the size by 1 more.
uint16                               gusa_HercADSL_MONIMap_Curr[4];
uint16                               gusa_HercADSL_MONIMap_Prev[4];
// XDSLRTFW-3648 (End)
int16                               gsa_HercADSL_MONIMap_StateMachineConfig = 0;
//Feature_ALL_ALL_FT_ReInit_Triggers (Start)
HercADSL_ReInit_Config_t            gsa_HercADSL_MONIMap_ShowFailConditions[2];
//Feature_ALL_ALL_FT_ReInit_Triggers (End)
int16                               gs_AutoMsgHandlerState;
int16                               gs_showtime_tc_sync_first_time; //  0=TC Sync not achieved, 1=TC Sync achieved for 1st time,
//  2=TC Sync achieved after losing it at least one time.

Params_t                            gt_HercADSL_NearEndParam;   //near end test parameter structure variable
int16                               gs_Fw_ImageInfoGet;
int16                               gs_En_RxFG_MaptoHerc=1;
DATA_MAP_END
#endif  // #ifdef HERC_API

DATA_LOCAL_LD_ST_BEGIN
//XDSLRTFW-1727
#ifndef ISDN
uint16 gusa_RxL2CombinGains[512];
#endif
// ADSL_BONDING
//------------------
#ifdef ADSL_BONDING
// flag to enable GHS only exchange for bonding


// data structures to provide control and status of
// for GHs bonding negotiation
Bonding_DiscAggr_Control_t gt_Bonding_DiscAggr_Control;
Bonding_DiscAggr_Status_t  gt_Bonding_DiscAggr_Status;
Bonding_Continue_t         gt_Bonding_Continue;
uint16   gus_Bonding_PME_ID;     // XDSLRTFW-2382 (Start_End)
int16 gs_DsMinDelayDeltaForBonding = 1; // Delta between DS max delay and DS min delay in msec (not used)
FlagT gft_EnableBondingExchangeOnly;
FlagT gft_FE_Not_Bondable;
uint8 guc_ID_SPar1;
uint8 guc_ID_SPar1_02;
#endif   // ifdef ADSL_BONDING
DATA_MAP_END


#ifdef IFX_XTC
XtcIfConfigInput_t gt_RxXtcIfConfigInput;
XtcIfConfigInput_t gt_TxXtcIfConfigInput;
#endif

//XDSLRTFW-471 Enhance_DS_ALL_ALL_REIN_IMMUNITY_TRAINING (Start)
//Enable droping of Impulse/Rein affected frames for FDQ and SNR accumulation
//during training. This improves performance at presence of REIN
//Flags
//#if defined (DANUBE) && defined (TARGET_HW)

int16  gft_indEnable = 0xF;
//int16  gft_indEnable = 0;
FlagT gft_Choose = 1;
//FlagT gft_Choose = 0;

//#else
//int16  gft_indEnable = 0;
//FlagT gft_Choose = 0;
//#endif
//XDSLRTFW-471 Enhance_DS_ALL_ALL_REIN_IMMUNITY_TRAINING (End)
int16  jg_pause = 0;

// accumulation interval
int16  gs_IndTime16 = 16;
int16  gs_IndTimeTestSnr = 8;
int16  gs_indTimeRevSnr = 16;

// metric scales based on accumulation time
uint8  guc_indScaleTestSnr = 3;
uint8  guc_indScaleRevFdq = 4;
uint8  guc_indScale1 = 4;
int16  gs_KT = 3;

//indication tones
int16 gs_NumIndTones=4;
int16 gs_chooseStep = 7;
int16 gsa_indTones[8];
int16 gsa_RxToneAvg[8];

//counter for dropped frames due to impulse
int16 gs_droppedMedley = 0;
int16 gs_droppedMedleyFdq = 0;
int16 gs_droppedMedleyTest = 0;
int16 gs_droppedReverbSnr = 0;

// metric threshold related varibales
int16 gs_numSymbolsIgnored;
int16 gsa_indMax[MAX_IMP_WIDTH+3]  ;
int32 gl_indThresh;
int32 gl_ind_metric_acc;

int16  gs_statesToWait=0 ;
int16 gs_mode;
int16 xLimScale = 3; // range from .875 to 1.125
int16 iWatch = 3;

int32 *pl_XDumpAddr = (int32 *)0x170c00;
int32 *pl_XDumpStart = (int32 *)0x170c00;
int32 *pl_XDumpEnd   = (int32 *)0x170ffc;

// Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting (start_end)
int16 gs_DSL_EDcontrol;

int16 gs_bis_Adjust_LATN = 256; //2dB
int16 gs_plus_Adjust_LATN = 128; //1dB

//below are variables to deal with impulse for non-erasure platform
int16 gs_pilot_snir_threshold; //Signal to noise plus impulse ratio for pilot tone
int16 gs_DD_imp_pwr_allowed = 10; // the noise+impulse threshold for performing data directed snr and fdq
uint16 gus_frame_discard_cnt, gus_frame_discard_max = 17;
uint16 gus_frame_detect_cnt, gus_frame_detect_period = 40;
FlagT gft_frame_with_noisypilot;
int16 gs_instant_snir;
int16 gs_pilot_STsnr_avg;//SMS00838915:DS_PERF_ALL_PllSnrThresshold (START END)
//impulse characterization
//This set could be put into local memory
int16  gs_sliding_idx;
int32  gl_accu_pwr_old =0 ;
int32  gl_accu_pwr_new =0 ;
int32  gl_window_pwr_lb  = 0x7FFFFFFF;
int32  gl_window_pwr_ub  = 0;
//SMS01438029 Perf_DS_ALL_24Kb_Ilv_Memory (Start)
DATA_MAP_deILV2_BIS
int32  gla_sym_pwr[18];   //Sriram : Moved from bulk_data_ram to dilv2
DATA_MAP_END
//SMS01438029 Perf_DS_ALL_24Kb_Ilv_Memory (End)
int32  gl_imp_power;
int32  l_imp_detect_threshold;
int32  gl_ave_imp_power;
int16  s_imp_cnt =0, s_noimp_cnt =0;
int16  gs_num_impulse,  gs_imp_period;
uint16  gus_impulse_coarse_detect;
int16  gs_power_up_cnt, gs_power_down_cnt;
int16  gus_max_imp_symbol = 0, gus_max_noimp_symbol=0;
uint8  guc_impulse_noise_present;
uint8  guc_pwr_accu_shift_bits = 8;
FlagT  gft_HighREIN_NOISE;


// XDSLRTFW-654 XDSLRTFW-248 Bug_DS_All_All_IntentionalReTrainToReduceTrainTime (Start)
// Variable to indicate whether retrain is intentional or not
uint8  guc_Forced_Retrain;
// guc_Forced_Retrain indicates a CPE initiated retrain.
// Currently following intentional retrains are supported
//              guc_Forced_Retrain = 0x01:      E_CODE_GHS_Dis_CTLMWorkAroundforNon_CTLM
//              guc_Forced_Retrain = 0x02:      E_CODE_GHS_Dis_CTLMWorkAroundfor_CTLM
//              guc_Forced_Retrain = 0x03:      E_CODE_Vinax_DSNomPSDBug
//              guc_Forced_Retrain = 0x04:      E_CODE_GHS_VDSL_SUPPORT_FAREND_LONG_LOOP
//              guc_Forced_Retrain = 0x05:      E_CODE_ADI_CHANGE_MEDLEX_TX_NOISE_LEVEL
//              guc_Forced_Retrain = 0x06:      E_CODE_ADI_REDUCE_REVPWR_LOW_DSPCB_RATE_OPTIONS_RETRAIN or
//                                                                      E_CODE_ADI_REDUCE_REVPWR_LOW_DSPCB_RATE_OPTIONS_TX_MEDLEY_NOISE_RTN
//              guc_Forced_Retrain = 0x07:      E_CODE_TI_REDUCE_GHSPWR_LOW_DSPCB_RETRAIN
//              guc_Forced_Retrain = 0x08:      E_CODE_RCReverb7Rx_Bis_C_SEGUE_Quiet_Failure
//                                                                      exception code is misleading: this excpetion mainly happens in DMT mode
//                                                                      when training with TI AC-5 (fail state: RCReverb5RxF)
//                                                                      (this is not a intentional retrain, but as this happens very often, so
//                                                                      it should not increase the API retrain counter, otherwise false ADSL->VDSL
//                                                                      mode switches were seen with TI AC-5
//     guc_Forced_Retrain = 0x09:       E_CODE_BRCM_DISABLE_ANNEX_L
// XDSLRTFW-654 XDSLRTFW-248 Bug_DS_All_All_IntentionalReTrainToReduceTrainTime (End)


//SMS01438029 Perf_DS_ALL_24Kb_Ilv_Memory(Start)
#ifdef ADSL_62
FlagT gft_Ilv_Buf24k;
int32 gl_DS_Intlv_buf_size;
#endif
//SMS01438029 Perf_DS_ALL_24Kb_Ilv_Memory (End)

//XDSLRTFW-699: Fix_AB_US_All_GHsToneSetSelection (Start_End)
int16 gs_GhsCarSetCfg;          // E.g. A43, B43, etc.

//XDSLRTFW-148:SMS00918205 SMS00918215 Feature_AB_US_BisPlus_ALL_Optional_US_interlever_depth (Start_End)
US_Interleave_Depth_t gt_Optional_US_InlvDepth;

// PERF_DS_PLUS_ALL_GeneralizedPcb (Start)
int16 gs_PGAforLoopLengthEstimation = 0;
FlagT gft_StrongNoiseForDsPcb = FALSE;
// PERF_DS_PLUS_ALL_GeneralizedPcb (End)
FlagT gft_TxImages;

RdyOvfUdf_t  gt_RdyOvfUdfStatus;
// Indicator for the attached hybrid module
uint16 gus_HybridType;
uint16 gus_LD_Mode;
// XDSLRTFW-1630 (Start_End)
uint16 gus_Choosen_LD_Mode;

// XDSLRTFW-201 Feature_US_ALL_ALL_LPR(start_end)
uint16 gus_Set_LPR;
#ifdef ADSL_62

//XDSLRTFW-315: Feature_ALL_ALL_ALL_DSL_PPE_CLOCK_CONTROL (Start)
 // Variables Mapped to DSL cmvs
uint16 gus_PpeClockControl;    //[DSL_PPE_CLOCK_CONTROL]
uint16 gus_PPEClockConfigure = FSCALE_AUTO_A;      // This variable is linked to CMV DSL 34 --> It indicates the Mode configured for PPE clock Frequency scaling
//XDSLRTFW-315: Feature_ALL_ALL_ALL_DSL_PPE_CLOCK_CONTROL (End)

// XDSLRTFW-3566 (Start_End)
uint16 gus_PPEClock_Configured;

//XDSLRTFW-2442 (Start)
//XDSLRTFW-561 Enhancement_All_All_All_FreqOffset [Start]
int16 gs_InitFreqOffsetDelta_ppm;
//XDSLRTFW-561 Enhancement_All_All_All_FreqOffset [End]
int16 gs_lowOscOffset_ppm;
//XDSLRTFW-2442 (End)

int16 gsa_RxPilotToneInCReverb34[2]; //XDSLRTFW-1633 SMS01261908 SMS001231692 PERF_DS_ADSL1_AB_Ciena_PLL_TRACKING_REVERB3(Start_End)
//==============================================================================
// active/inactive pointers to HW Ping-Pong tables
//==============================================================================
uint8 *ghpuca_TxBat_Active; // HW pointer to active TX bit allocation table (BAT)
#if 0
uint8 *ghpuca_RxBat_Active; // HW pointer to active RX bit allocation table (BAT)
int16 *ghpsa_TxFineGains_Active; // HW pointer to active TX fine gain table (GST)
int16 *ghpsa_RxFineGains_Active; // HW pointer to active RX fine gain table (GST)
uint8 *ghpuca_TxExtGains_Active; // HW pointer to active TX extended gain table (EGT)
uint8 *ghpuca_RxExtGains_Active; // HW pointer to active RX extended gain table (EGT)
int16 *ghpsa_TxToneOrder_Active; // HW pointer to active TX tone ordering table (TRT)
int16 *ghpsa_RxToneOrder_Active; // HW pointer to active RX tone ordering table (TRT)

uint8 *ghpuca_TxBat_Inactive; // HW pointer to inactive TX bit allocation table (BAT)
uint8 *ghpuca_RxBat_Inactive; // HW pointer to inactive RX bit allocation table (BAT)
int16 *ghpsa_TxFineGains_Inactive; // HW pointer to inactive TX fine gain table (GST)
int16 *ghpsa_RxFineGains_Inactive; // HW pointer to inactive RX fine gain table (GST)
uint8 *ghpuca_TxExtGains_Inactive; // HW pointer to inactive TX extended gain table (EGT)
uint8 *ghpuca_RxExtGains_Inactive; // HW pointer to inactive RX extended gain table (EGT)
int16 *ghpsa_TxToneOrder_Inactive; // HW pointer to inactive TX tone ordering table (TRT)
int16 *ghpsa_RxToneOrder_Inactive; // HW pointer to inactive RX tone ordering table (TRT)

int16 *ghpsa_SFDQMantissa;
uint8 *ghpuca_SFDQExponet;
#endif

int16 gs_RtvSelect;

uint16 gus_segment_size;
uint8 guc_TxQtInactiveTblSeg;
uint8 guc_TxQtActiveTblSeg;
uint8 guc_RxQtInactiveTblSeg = 1;
uint8 guc_RxQtActiveTblSeg = 1;
int16 gs_TxIIRFilterSelect;
int16 gs_RxIIRFilterSelect;
FlagT gft_fw_pilot_fdq;
int16 gs_td_fd_pwr_offset;

uint32 gul_FD_RNG0Shadow;
uint32 gul_FD_RNG0CNTShadow =0;
uint32 gul_RX_MISC_Shadow;


FlagT gft_V14;
FlagT gft_interpdec_phase_align;
FlagT gft_DECAdaptDisable;
// XDSLRTFW-576: IOP_DS_BisPlus_ALL_LinkDropADMAError (start_end)
FlagT gft_Dec_Init = FALSE;
#ifdef HW_VECPOW_ACCUM
int16  gs_NPR_GuardBits;
int32  gl_Pa_VecPow;
#endif

FlagT gft_StrymonLpbkMode;// = STR_NO_LPBK; //configure strymon lookback mode
uint32 gul_qttx_active_reg_sav;
#endif
#ifdef PPE_ENGINE
//PPE configuration variables
uint32 gula_DREG_AT_CFG_Cnfg[NUM_BEARER_CHANNELS];
uint32 gula_DREG_AR_CFG_Cnfg[NUM_BEARER_CHANNELS];
uint32 gula_DREG_AR_CELL_Shadow[NUM_BEARER_CHANNELS];
uint32 gula_DREG_AR_IDLE_CNT_Shadow[NUM_BEARER_CHANNELS];
uint32 gula_DREG_AR_AIIDLE_CNT_Shadow[NUM_BEARER_CHANNELS];
uint32 gula_DREG_AR_BE_CNT_Shadow[NUM_BEARER_CHANNELS];
uint32 gula_DREG_AR_HEC_CNT_Shadow[NUM_BEARER_CHANNELS];
uint32 gula_DREG_AR_CD_CNT_Shadow[NUM_BEARER_CHANNELS];
uint32 gula_DREG_AT_CELL_Shadow[NUM_BEARER_CHANNELS];
uint32 gula_DREG_AT_IDLE_CNT_Shadow[NUM_BEARER_CHANNELS];
#endif //#ifdef PPE_ENGINE
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (START - END)
#if     defined (ZEP_DEBUG_BLD) || defined (ZEP_DEBUG_BLD_RX)

//Data used for capture the scrambler input and output data
int16 gs_TxScamNumBytesPerSym;  //the estimated number of bytes per symbol to going to TX scrambler
int16 gs_CapturedTxScamSyms;    //the captured TX number of symbols
int16 gs_TxCapBufFullness;              //the number of bytes left in TX capture buffer
int16 gs_TxPreWRPTR;                    //the previous TX FIFO3 write pointer

int16 gs_RxScamNumBytesPerSym;  //the estimated number of bytes per symbol to going to RX scrambler
int16 gs_CapturedRxScamSyms;    //the captured RX number of symbols
int16 gs_RxCapBufFullness;              //the number of bytes left in RX capture buffer
int16 gs_RxPreWRPTR;                    //the previous RX FIFO3 write pointer

FlagT gft_TxFifo3Capture;               //TX FIFO3 capture flag: TRUE, FALSE or -1 (indicating the wrap around occurs)
FlagT gft_RxFifo3Capture;               //RX FIFO3 capture flag: TRUE, FALSE or -1 (indicating the wrap around occurs)
FlagT gft_EnableFifo3Capture = 1; //if set to 1 enable FIFO3 capture

#ifndef TARGET_HW
uint8 guca_TxFifo3CapBuf[4096];
uint8 guca_RxFifo3CapBuf[4096];
#endif //#ifdef TARGET_COCOMO

#endif //#if    defined (ZEP_DEBUG_BLD) || defined (ZEP_DEBUG_BLD_RX)

//#ifdef VR9_HYB_TRAIN_DEBUG
#if 0
/* Sriram : Commented out  for data memory free -up */

int16 gs_dbg_count = 10;
int16 gs_dbg_type = 10;
int16 gs_dbg_hybindex = 10;
#endif
//#endif //VR9_HYB_TRAIN_DEBUG
int16 gs_dbg_DecimPoints = 50;
int16 gs_force_Decimpoints = 0;

//VR9_AnxAB_HybImp Start
int16  gs_HybStartTone;
int16  gs_HybEndTone;
//VR9_AnxAB_HybImp End

//Debug
int16 gs_Set_Pause = 0;
//#ifdef VR9_HYB_TRAIN_DEBUG
int32 gl_HYbPGATrain_SymCount = 0;
int32 gl_HybTrainSigPSD_SymCount = 0;
//#endif //VR9_HYB_TRAIN_DEBUG
//PERF_US_T1413_T1&CNXT_64ptIFFT (START - END)
FlagT gft_IFFT64_T1413_TxImages = 0;

// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (START)
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
#ifndef ISDN
uint8 guc_NLNF_Enable = 0;

//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect Integrate_HybridPGA_Algo (Start_End)
FlagT gft_NLNF_HybridTraining = 0;

// XDSLRTFW-364: Feature_DS_All_All_NLNF_TrainingInfo (START_END)
int16 gs_NLNF_avg_snr;
#endif //#ifndef ISDN
#endif //#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
//XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching (Start_End)
uint16 gus_Cnfg_Misc = 0;

//XDSLRTFW-713 Feature_AB_All_All_All_SendVectorCodePointerInGHs (Start_End)
uint16 gus_DsmCtrlCmv;

//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect_CMVRemap(start)
//SMS01544218 FEATURE_ALL_DS_ALL_LoopEstimate (START)
LooplengthEst_t gt_LoopLength_ft;
//SMS01544218 FEATURE_ALL_DS_ALL_LoopEstimate (END)
HybridInfo_t gt_HybridInfo;
// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (END)
ApiOptions_t gt_ApiOptions;

uint16 gus_DSL_FW_InternalControl;

//XDSLRTFW-508 Fix_DS_All_All_SuppressCounterWriteFromDSLAPI (Start_End)
InteropOptions_t gt_InteropOptions;

Dsl_Operator_Select_t gt_Dsl_Operator_Select; // XDSLRTFW-1792 (Start_End)

//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect_CMVRemap(end)
//Enhance_DM_Optimisation (start)
FlagT gft_LinkStartFlag = FALSE;
// IOP_ALL_ALL_ALL_USDSSRA_PML2_PML3_mode (START)
//XDSLRTFW-380: Feature_US_BisPlus_All_USSRA_CMVRemap (start)
//FlagT gft_EnableAutoSRA = TRUE;
//FlagT gft_EnableUSSRA  = TRUE;
//XDSLRTFW-380: Feature_US_BisPlus_All_USSRA_CMVRemap (end)
FlagT gft_EnableL2Mode = FALSE;
FlagT gft_EnableL3Mode = FALSE;
// IOP_ALL_ALL_ALL_USDSSRA_PML2_PML3_mode (END)

//uint8 guc_temp_vdsl2_mode[3] = {0}; //not used
uint8 guc_temp_vdsl2_mode1 =0x3F; //TODO : debug Variable ,Remove
// XDSLRTFW-1214:IOP_DS_Plus_IKNS_ShortLoopDSCRC(Start_End)
uint16 gs_Add_minPCB_NVLT = 6;
//Enhance_DM_Optimisation (end)
//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start_End)
int16 gs_DSL_AlgControl4;
//int16 gs_v1,gs_v2,gs_v3,gs_v4,gs_v5,gs_v6,gs_v7;



FlagT gft_Amd4_L2_Entry;
//XDSLRTFW-1727
FlagT gft_FineGainShaping;
int16 gs_DeltaPcb;
//FlagT gft_isL2_LpGtL0_LpBy2_Ena = 1; //the new L2 delay constraint (delay(L2)<=2*delay(L0) which means rate(L2)>=rate(L0)/2)
FlagT gft_pwr_limit = 0;

#if 0
int16 gs_pcbDsL2SymAfterAtprCheck_dbg;
int16 gs_pcbDsL2SymBefAtprCheck_dbg;
int16 gs_RMSGI_L2_Log_dbg;
int16 gs_xs_power_cut_dbg;
#endif


int16 gs_ATPR_L2;
int16 gs_Offset_L2rmsFG_power;
int32 gl_Offset_Gi_power_lin;
int16 gs_L2ActualDeltaSumLp;

//int16 gs_ATPR_L2;
int16 gs_Offset_L2rmsFG_power_prv;
int16 gs_gi_power_change_dB;
int16 gs_gi_power_change_dB_prv;
int16 gs_L2ActualDeltaSumLp;


//XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (Start)
FlagT gft_TonesWithStrongNoise;
int16 gs_BITSWAP_TRIGGER;
int16 gs_bitswap_evacuation_thrd;
RxToneFlags guca_TimeVaryNoise_Ind_sav;
//XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (End)
//XDSLRTFW-541: Platform_VR9_VRX318 (START)
int16 gs_Zep_Tx_DelayCnt = 0;
//XDSLRTFW-541: Platform_VR9_VRX318 (END)

//XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map (Start)
ModemFeatureMap_t gt_AdslFeatureMap;
//XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map (End)
int16 gs_OlrReq;
uint16 gs_TX_IMAGE_NYQ;
FlagT gft_erasure_hw_on;
FlagT gft_CNXT_ANNEXL_ADSL2;
FlagT gft_CNXT_A_LongLoops;
FlagT gft_CNXT_ANNEXL_BTLoops;

uint32 gul_Preamble_CMSG1;

uint16 gus_DacTrimVal;
uint32 gl_HybTrSymcnt[5]; //debug can be removed
uint32 gl_HybTrSymcnt_start;
uint32 gl_HybTrSymcnt_end;

ReInit_Thresholds_t gt_ReInit_Threshold;
FlagT gft_flag_explicitrate=0;
FlagT gft_Flag_limitCause = 0; /* 0: No limit, 1: RMS Fine Gain, 2: MaxNomATP,
                                3: Fixed rate (achieved required bits)*/
FlagT gft_ErasureGainForRate = FALSE;
int16 gs_INP_erasure;
int16 gs_INP_no_erasure;

// TC switchover
uint16 gus_Required_TC_Info;
FlagT gft_TC_autonomous_msg = FALSE;

FlagT gft_AddNMS = FALSE;

//XDSLRTFW-682: BugFix_DS_DMT_CNXT_Improve_DS_Performance_In_BTLoops (Start)
//int16 gs_XtalkMatch=0, gs_XtalkMatch2=0, gs_XtalkMatch_LowN=0, gs_XtalkMatch_VLowN=0, gs_XtalkMatch1=0;
//int16 gs_XtalkMatch_FB=0, gs_XtalkMatch_M130M140WN=0;
//XDSLRTFW-682: BugFix_DS_DMT_CNXT_Improve_DS_Performance_In_BTLoops (End)
//XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (Start)
#ifdef DEBUG_DEC_ADAPT
FlagT gft_DbgDecLogEnable = TRUE;
uint16 gus_DbgDecUpdateCount = 0;
uint16 gt_DbgIdx =0;
uint32 gula_dbg_DecSetting[20];
#endif //#ifdef DEBUG_DEC_ADAPT

uint32 gul_DecHW_WaitCount = 0;
uint16 gus_dbg_DecHW_StruckCount = 0;
uint8  guc_RxDecCaptureState = 0;
//XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (End)
//XDSLRTFW-1086 / ADSLRTFW-1611 IOP_DS_ADSL2p_CNXT_RFITest_BitSwap (start_end)
FlagT gft_CNXT_RFI_BS; //debugVar
#ifdef DEBUG_TRACES
// XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer(START)
DebugBufferStatus_t gt_DebugBufferStatus; //Debug buffer status CMV updating
DebugBufferControl_t gt_DebugBuffControl;
// XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer(END)

#endif // #ifdef DEBUG_TRACES


//Moved variables from pll_misc.c to here
DATA_MAP_LOCAL_LD_ST_BEGIN
// DD Pilot
FlagT gft_DDPilot;               /* 0 -- Decision Directed Pilot Off, 1 -- Decision Directed Pilot On */

// Aux Pilot Tone (DMT Specific, Do NOT move into gdata_dmt.c, used in LinkStart)
FlagT gft_AuxPilot;              /* 0 -- Aux Pilot Disable, 1 -- Aux Pilot Enable, 2 -- Aux Pilot Active */
int16 gs_MinAuxPilotToneIdx ;
int16 gs_MaxAuxPilotToneIdx ;

// Pilot Tone Indexes
int16 gs_PilotToneIdx;           /* pilot tone index */
int16 gs_AuxPilotToneIdx;        /* aux pilot tone index */
int16 gs_CPilotTone;          /* cpilot tone index */

// XDSLRTFW-2579 (Start)
uint8 guc_MaxEDMetric = 0;
uint8 guc_EDMetricThreshold;
uint8 guc_metric_value;
//uint16 gusa_EDMetricLog[16];                    // for debugging only
uint16 gus_MicroInterruptionDetectionCnt;         // number of symbol with micro interruption
uint16 gus_SymbolWithLowEdMetricCnt;              // numbr of symbol with external nosie ( eg. REIN, PEIN, SHINE)
uint32 gul_PpmDriftCnt;
int16 gs_ExtraDelayBeforeChangingPllLF;
// XDSLRTFW-2579 (End)

// PLL Frquency Offset
int32 gl_pll_freq_offset = 0;    // PLL frequency offset
int32 gl_pll_loopfilter_out = 0; // Output of PLL loop filter
int32 gl_pll_freq_offset_avg = 0;

// Pilot Tone Index Specific
int16 gs_PllScaling;
int16 gs_PilotPeriod;         /* For Annexes A and C: gs_PilotPeriod represents the number of samples in one period, */

// Pilot Tone Signal Buffer
int16 gsa_RxPilotTone[2];     /* received Pilot Tone */
int16 gsa_PllRefTone[2];      /* reference Pilot Tone */
int16 gsa_NewRefTone[2];

// Phase Error
FlagT gft_EnablePLL;
int16 gs_PhaseError;
int16 gs_MaxPhaseErrorThreshold;

int16 gs_PLL_Mode = 0;                   // -1: FREQ_DRIFT_TRACKING_OFF
                                         //  0: FREQ_DRIFT_TRACKING_ON____STABLE_FREQUENCY
                                         //  1: FREQ_DRIFT_TRACKING_ON____FREQUENCY_DRIFTS

// H/W Timing Recovery variables
int16 gs_UpdateTimingRecoveryHWEnable;
FlagT gft_EnableNoiseShaping ;
int32 gl_initfreqoffset;         // value is based on clock freq used for PLL
                                 // 35.328/36.66 = 2^22/(2^22 + gl_initfreqoffset)
int32 gl_PilotTonePower;

int16 gs_RotationIdx;
DATA_MAP_END




// XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer(START)
//XDSLRTFW-599 FEATURE_ALL_ALL_ALL_Debug_Buffer(START)
DATA_GHS_TO_SHOW_BEGIN
/* XDSLRTFW-2464 */
//#ifdef ISDN
Avm_PllRotInfo_t ga_PllRotInfo[20];
int32 gla_pll_freq_offset[SIZE_PLL_FREQ_OFFSET_BUFFER] ={0};

int32 gl_Pll_Freq_delta = 0;
uint8 guc_Pll_idx = 0;
int16 gs_Last_Reported_Phase_Error   = 0;
int16 gs_New_Phase_Error   = 0;
int16 gs_Prev_Phase_Error  = 0;
int16 gs_NumOfIdenticalAdjacentPTPhases = 0;
int16 gs_MinNumberOfAdjPhaseErrorsToDeclareNewPhase = 1;
uint16 gus_PhaseErrorReporting_Idx = 0;
int32 gl_RxPilotTone_SqErr_Threshold_temp = 0;
//#endif
/* XDSLRTFW-2464 */


#ifdef REIN_DBG_CODE
uint16 gusa_pll_err_log[9216] = {0};                  /* PLL error trace */
int16 gs_pll_err_index = 0;
uint32 gul_UncorrectedDtuCnt_Last = 0;
#endif
#ifdef DEBUG_TRACES
uint16 gusa_DebugBuf[DEBUG_INTERNAL_BUFFER_MAX_SIZE_BYTES/2];
uint16 *gpusa_debugBuff ;
DebugTrailCollectControl_t gt_debugBufStatus; // structure which is used for index and length controlling while writing to guca_DebugBuf[]
DebugShowTimeBuffSymbol_t gt_DebugBuffSymbol;
DebugShowTimeBuffSuperframe_t gt_DebugBuffSuperframe;
DebugShowTimeBuffSuperframeReTxEnabled_t gt_DebugBuffSuperframeReTxEnabled;
uint16 gus_PrevMsg_Length;


uint8 *gpuca_debugBuff; //pointer to ping/pong buffer of size 2k
uint16 gus_LenDebugBuff; // length of bytes written in ping+pong buffer
uint8 *gpuc_offChipBuffShowtime; //pointer to SDRAM in showtime buffer
uint32 gul_LenoffChipBuffShowtime; //Length of Data written in SDRAM in showtime
uint32 gul_DMA_Busy_Error;
uint8 guc_StLengthFlag;
uint8 guc_ShowtimeEnter;

#endif // #ifdef DEBUG_TRACES

//XDSLRTFW-965 Task_DS_BisPlus_All_AttachHercCMVINFO85 (Start_End)
uint8 guca_SNRBuf_NE[RX_NUM_TONES];              //the buffer storing near end SNR per subcarrier (reporting format, as per standard)

//XDSLRTFW-1634 (Start)
#ifdef ENABLE_RETX_DS_DEBUG
uint16 gus_ReTxDebugBufIdx;
uint8  guc_ReTxDebugBufWrEnable;
uint8  guca_ReTxDebugBuf[8*1024];
#endif
//XDSLRTFW-1634 (End)
int16 gsa_NMS_ResetPllRefToneInput_Save[2];
int16 gs_NMS_AGC1_Gain_Save;
int16 gs_PGA_required_Save;

uint8 guc_NMS_AlgHandler;
//XDSLRTFW-1983
FlagT gft_DisabledVDSL2InCLR;
FlagT gft_HlogMeasurement;    //XDSLRTFW_3753 Hlog measurement indication

DATA_MAP_END
// XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer(END)
//XDSLRTFW-599 FEATURE_ALL_ALL_ALL_Debug_Buffer(END)

