/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   initfifo.c
*
*  Functions for initializing FIFOs, TCBs.
*
*-------------------------------------------------------------------------
*/
#include "typedef.h"
#include "gdata.h"
#include "states.h"
#include "dec_adap.h"



/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void tcb_init(void);
*
*   Description:
*
*     Initializes the Task Control Blocks for each interrupt.
*  This includes assigning the Time Critical (TC) and Non-Time
*  Critical (NTC) Tasks for each interrupt.
*
*  Arguments:
*     none
*
*  Global Variables:
*     gt_TaskArray   --  Array of Task Control Block structures.
*
*-------------------------------------------------------------------
*^^^
*/

void tcb_init(void) {
   int16 i;

   /* Setup the task control block for each interrupt */
   for (i=0;i<NUM_INTERRUPTS;i++)
   {
      gt_TaskArray[i].Next= (TCB_t *) NULL;
      gt_TaskArray[i].TaskID = i;
      gt_TaskArray[i].NonTimeCriticalTask = (PtrToFunc) NULL;
      gt_TaskArray[i].TimeCriticalTask= (PtrToFunc) NULL;
   }

   /* Setup the initial Enabled Interrupt Vector */
   gt_TaskArray[TX_FRAME_START].TimeCriticalTask = TxProcessTones;
   gt_TaskArray[TX_FRAME_START].NonTimeCriticalTask = TxForeGround;

#ifdef ADSL_62
    gt_TaskArray[RX_TSC_INT].TimeCriticalTask = RxProcessTones;
    gt_TaskArray[RX_TSC_INT].NonTimeCriticalTask = RxForeGround;

    gt_TaskArray[RX_FRAME_START].TimeCriticalTask = NULL;
    gt_TaskArray[RX_FRAME_START].NonTimeCriticalTask = NULL;
#else
   gt_TaskArray[RX_FDQ_DONE].TimeCriticalTask =    RxProcessTones;
   gt_TaskArray[RX_FDQ_DONE].NonTimeCriticalTask = RxForeGround;
   gt_TaskArray[RX_QAM_DONE].TimeCriticalTask =    RxProcessTones;
   gt_TaskArray[RX_QAM_DONE].NonTimeCriticalTask = RxForeGround;

   /* Don't enable the interrupt for RX_FRAME_START, but set up RxForeGround */
   gt_TaskArray[RX_FRAME_START].TimeCriticalTask = RxProcessTime;
   gt_TaskArray[RX_FRAME_START].NonTimeCriticalTask = RxForeGround;
   gt_TaskArray[TX_IFFT_DONE].TimeCriticalTask = GetDECAdaptationTxData;
#endif

   gt_TaskArray[RX_AAI_DONE].TimeCriticalTask =    RShowtimeRxTC_BIS_B;
#ifdef DANUBE
   gt_TaskArray[TX_FCI_DONE].TimeCriticalTask =    RShowtimeTxTC_BIS_B;
#else
   gt_TaskArray[TX_TDT_DONE].TimeCriticalTask =    RShowtimeTxTC_BIS_B;
#endif

   gt_TaskArray[TX_AAI_DONE].TimeCriticalTask =    RShowtimeTxTC_C;


   SizeTcb = sizeof(TCB_t);
}
/*************
The following function handle the background queue: We will use the same TCB structures, but
will only fill the non-time critical tasks
**************/

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : InitBackground
 *
 *
 *  Prototype:
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 * Return:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

void InitBackground(void) {
   int16 i;


   for (i=0;i<NUM_BG_BUFFERS;i++)
      gt_BGTaskArray[i]= (PtrToFunc) NULL;

   gp_BGTaskFifo=&gt_BGTaskFifoBuf;

   gp_BGTaskFifo->BufferSize=NUM_BG_BUFFERS;
   gp_BGTaskFifo->ErrorCode=0;
   gp_BGTaskFifo->FunctionBuffer= &gt_BGTaskArray[0];
   gp_BGTaskFifo->IndexOfOldest=0;
   gp_BGTaskFifo->NextAvailable=0;
   gp_BGTaskFifo->PendingFunctionCount=0;
}


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : InitTxLoadingFunctionFifo
 *
 *  Prototype:  void InitTxLoadingFunctionFifo(void)
 *
 *    initializes the fifo used to hold the TxLoadingFunctions.
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 * Return:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */



void InitTxLoadingFunctionFifo(void) {
   gp_TxLoadingFunctionFifo[0] = 0;

}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : InitRxLoadingFunctionFifo
 *
 *  Prototype:  void InitRxLoadingFunctionFifo(void)
 *
 *    initializes the fifo used to hold the RxLoadingFunctions.
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 * Return:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */



void InitRxLoadingFunctionFifo(void) {
   gp_RxLoadingFunctionFifo[0] = 0;
}

