/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *-------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   int48toFloat32.c
 *
 *
 *-------------------------------------------------------------------------
 */
#include "common.h"
#include "ieee_flt.h"
#include "norm_acc48.h"
#include "states.h"

/*****************************************************************************
;  Subroutine Name: leftshift48
;
;  Description:
;
;  Prototype:
;     leftshift48(int32 *high, int32 *low,int shift)
;
;  Input Arguments:
;
;  Output Arguments:
;     none
;
;  Return Value:
;     none
;
;  Global Variables Used:
;****************************************************************************/

void leftshift48(int32 *high, int32 *low, int shift)
{
  int iter;
  int32 last_bit;

  if(shift==0)
    return;

  for(iter=1; iter<= shift; iter++)
    {
      (*high) <<= 1;
      last_bit = (*low)& 0x8000; // Test the 16th bit
      (*low) <<= 1;
      (*low) &= 0xffff;

      if(last_bit!=0)
      *high += 1;

      // printf("%ld %ld %ld\n",*high, *low, last_bit);
    }
}

/*****************************************************************************
;  Subroutine Name: int48toFloat32
;
;  Description:
;
;        Convert 48 bit number represented by 2^16*num_h
;        + num_l to IEEE floating-point representation.
;
;  Prototype:
;     int48toFloat32(int32 num_h, int32 num_l)
;
;  Input Arguments:
;
;  Output Arguments:
;     none
;
;  Return Value:
;     none
;
;  Global Variables Used:
;****************************************************************************/

Float32 int48toFloat32(int32 num_h, int32 num_l)
{

#define START_WORD_SIZE 48
#define END_WORD_SIZE 32
#define MANT_SIZE 23
#define EXP_SIZE 8
#ifndef NEGATIVE
#define NEGATIVE (1)
#endif // #ifndef NEGATIVE

#ifndef NON_NEGATIVE
#define NON_NEGATIVE (0)
#endif // #ifndef NON_NEGATIVE

  short int shift;
  Float32 lsb, out, exp;
  FlagT   ft_sign = NON_NEGATIVE;

/* if(num_h==0)
   return int32toFloat32(num_l); */

  norm_acc48(&num_h, &num_l); // Normalizes the accumulator so that num_l has
                              // lower 16 bits of result.
                              // This normalization also allows us to determine
                              // if the int48 equals 0.


  /* Check for 0 */
  if((num_h==0) && (num_l==0))
    return 0x0L;

  /* convert negative number into non-negative before proceeding */
  if(num_h< 0) {
   ft_sign = NEGATIVE;
   num_l = -num_l;
   num_h = -num_h;
   norm_acc48(&num_h, &num_l); // Normalizes again to ensure that num_l has
                        // lower 16 bits of result.
  }

  // printf("%ld \t %ld \n", num_h, num_l);

// Assume 47 bits size to avoid signed integer issues

  for(shift=0; num_h < 0x40000000L; shift++)
    {
    leftshift48(&num_h, &num_l,1);
    // printf("%ld %ld %d\n",num_h, num_l,shift);
    }

  // printf("%d\n",shift);

  num_h >>= ((END_WORD_SIZE-1)-(MANT_SIZE+2)); // Move MSB to 24th bit position
                                         // before round off

  // printf("%ld\n",num_h);

  lsb = num_h & 0x1L;
  num_h >>= 1;
  num_h += lsb; // Round off

  // printf("%ld\n",num_h);

  /* possible error above if all bits are one */

  out = num_h & 0x7fffff; // Mask out implicit bit 24

  // printf("%ld\n",out);

  exp = 126+(START_WORD_SIZE-1) - (Float32) shift;

  // printf("%ld\n",out);

  out += (exp << MANT_SIZE);

  if(ft_sign == NEGATIVE)
    out ^= NEG32;

  return out;
}
