/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*****************************************************************************
;
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  matrix.c
;  Matrix utility functions with the option for floating point emulation.
;
;******************************************************************************/

#include "common.h"
#include "ieee_flt.h"
#include "matrix.h"
#if 0
#include "stdio.h"
#endif

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void MatrixMult(Float32 *pfa_mat_x, Float32 *pfa_mat_y, Float32 *pfa_mat_z,
*              int16 s_xdim, int16 s_ydim, int16 s_xydim, int16 s_transpose);
*
*  Description: matrix multiply z = x*y or (x'*y) if s_transpose != 0
*               dimensions are,
*               for s_transpose != 0
*               x (s_xdim, s_xydim), y(s_xydim, ydim)
*               for s_transpose == 0
*               x(s_xydim, s_xdim), y(s_xydim, ydim)
*
*-------------------------------------------------------------------
*^^^
*/
#ifdef FLOAT_IN_SW
C_SCOPE void MatrixMult(Float32 *pfa_mat_x, Float32 *pfa_mat_y, Float32 *pfa_mat_z,
            int16 s_xdim, int16 s_ydim, int16 s_xydim, int16 s_transpose)
{
   int16 i, j, k;

   Float32 *pfa_x, *pfa_y, *pfa_z;

   pfa_z = pfa_mat_z;

   if (!s_transpose) {
      /* do straight multiplication */
      for (i=0; i<s_xdim; i++) {
         for (j=0; j<s_ydim; j++) {
            /* start pfa_mat_x at beginning of row and pfa_mat_y at beginning of column */
            pfa_x = pfa_mat_x + (i * s_xydim);
            pfa_y = pfa_mat_y + j;
            *pfa_z = 0;
            for (k=0; k<s_xydim; k++) {
               *pfa_z = addf32(*pfa_z, mpyf32((*pfa_x++),(*pfa_y)) );
               pfa_y += s_ydim;
            }
            pfa_z++;
         }
      }
   }
   else {
      /* do s_transpose multiplication */
      for (i=0; i<s_xdim; i++) {
         for (j=0; j<s_ydim; j++) {
            /* start x at beginning of column and y at beginning of column */
            pfa_x = pfa_mat_x + i;
            pfa_y = pfa_mat_y + j;
            *pfa_z = 0;
            for (k=0; k<s_xydim; k++) {
               *pfa_z = addf32(*pfa_z, mpyf32((*pfa_x),(*pfa_y)) );
               pfa_x += s_xdim;
               pfa_y += s_ydim;
            }
            pfa_z++;
         }
      }
   }

   return;
}





C_SCOPE Float32 RdLMat(Float32 *pfa_L, int16 i, int16 j, int16 s_M) {

   return (pfa_L[(j-i)+(2*s_M-i+1)*i/2]);

}


#else /*  NOT FLOAT_IN_SW */

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void MatrixMult(Float32 *pfa_mat_x, Float32 *pfa_mat_y, Float32 *pfa_mat_z,
*              int16 s_xdim, int16 s_ydim, int16 s_xydim, int16 s_transpose);
*
*  Description: matrix multiply z = x*y or (x'*y) if s_transpose != 0
*               dimensions are,
*               for s_transpose != 0
*               x (s_xdim, s_xydim), y(s_xydim, ydim)
*               for s_transpose == 0
*               x(s_xydim, s_xdim), y(s_xydim, ydim)
*
*-------------------------------------------------------------------
*^^^
*/
void MatrixMult(float *x, float *y, float *z,
            int16 s_xdim, int16 ydim, int16 s_xydim, int s_transpose)
{
   int i, j, k;

   float *xp, *yp, *zp;

   zp = z;

   if (!s_transpose) {
      /* do straight multiplication */
      for (i=0; i<s_xdim; i++) {
         for (j=0; j<ydim; j++) {
            /* start x at beginning of row and y at beginning of column */
            xp = x + (i * s_xydim);
            yp = y + j;
            *zp = 0.0;
            for (k=0; k<s_xydim; k++) {
               *zp += (*xp++)*(*yp);
               yp += ydim;
            }
            zp++;
         }
      }
   }
   else {
      /* do s_transpose multiplication */
      for (i=0; i<s_xdim; i++) {
         for (j=0; j<ydim; j++) {
            /* start x at beginning of column and y at beginning of column */
            xp = x + i;
            yp = y + j;
            *zp = 0.0;
            for (k=0; k<s_xydim; k++) {
               *zp += (*xp)*(*yp);
               xp += s_xdim;
               yp += ydim;
            }
            zp++;
         }
      }
   }

   return;
}



float RdLMat(float *L, int i, int j, int M) {

   return (L[(j-i)+(2*M-i+1)*i/2]);

}


#endif /*  FLOAT_IN_SW */

