/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *-------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   norm_acc48.c
 *
 *-------------------------------------------------------------------------
 */
#include "common.h"

/*****************************************************************************
;  Subroutine Name: norm_acc48
;
;   Normalizes a 48-bit accumulator A. The 48-bit accumulator
;   is created by using a 32-bit HI portion overlapped with a 32-bit LO
;   portion.
;
;   The 48 bits number is represented as   HI * 2^16 + LO
;   Example: HI = 0x00345678, LO = 0x00123456, then
;
;                 0x00345678
;                       00123456 +
;                 --------------
;             A = 0x0034568A3456
;
;   If A is normalized, then bits 16-31 of LO is all zero: HI = 0x0034568A,
;   LO = 0x00003456
;
;   Typically, A is left unnormalized during the accumulation process and
;   normalization happens at the very end.
;
;  Prototype:
;       void norm_acc48(int32 *pl_AccH, int32 *pl_AccL)
;
;  Input Arguments:
;     pl_AccH        - pointer to the HI part of the 48 bits accum.
;     pl_AccL        - pointer to the LO part of the 48 bits accum.
;
;  Output Arguments:
;
;  Return:
;     Returns the normalized accum. in *pl_AccH and *pl_AccL.
;
;  Global Variables:
;     none
;
*******************************************************************************/

void norm_acc48(int32 *pl_AccH, int32 *pl_AccL)
{
   int32 l_temp;

   // Normalizes the high and low part of uacc48
   l_temp = *pl_AccL;
   *pl_AccL  = (l_temp & 0xFFFF);
   *pl_AccH += (l_temp >> 16);

}
