/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   post_hsk.c
 *
 *   Definition of the function BGInitModem_PostHandshake
 *
 *------------------------------------------------------------------------
 */

 // ****************************************************************************************************
// post_hsk.c
// History :
//  27/05/2013 Varun : Added code(Debug option) to capture raw data of all Tx(R-MSG-FMT in particular) and Rx-
//                   training messages (G.Hs + training)
//                   Grep for "XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
//****************************************************************************************************

#include "DSLEngin.h"
#include "stateini.h"
#include "gdata.h"
#include "cmv.h"
#include "tx_ops2.h"
#include "profile1.h"
#include "DebugBuffer.h"

void BGInitModem_PostHandshake(void)
{
   /* Generate reference C_Reverb signal */
   /* In BIS, this may have to be regenerated later after selecting the pilot tone */
   Gen_Reverb_Ref_fd(gsa_CReverbRefTones, GEN_REVERB_TYPE_CO, gs_RxNumTones,
               gs_RxFirstChannel, gs_RxLastChannel, (int16)(DEC_QPSK_GAIN));
#ifndef ISDN
   // If G.Lite
   if ((STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_AB) || (STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_C))
   {
      gta_RXProfile = (RXProfileStruc_t *)(void *)RXProfile;
      gta_TXProfile = (TXProfileStruc_t *)(void *)TXProfile;
#ifdef INCLUDE_FASTRETRAIN_CODE
      InitProfile();
#endif
      InitModemEngine_PostHandshake();
   }
#endif //ISDN
#ifdef DEBUG_TRACES
   // XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer(START)
   //for debug purpose, log GHS messages recieved
   LogMessages(1,END_OF_THE_MSG,DEBUG_BUFFER_DELIMETER_GHS_END);

   RequestSwap_DebugBuff_GHS_OR_TRAINING_Tomem();
   gt_debugBufStatus.s_debugTrailLen=0;
   // XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer(END)
#endif // #ifdef DEBUG_TRACES

   guc_HandshakeDone =  TRUE;
}
