/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/***************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  File Name: rndnoiseacc2.c
;
;  Version of rndnoiseacc.c used only in RC-Comb2RxF
;
;***************************************************************************/
#include "common.h"
#include "gdata.h"
#include "medley.h"
#include "rcmedly2.h"
#include "round_acc48.h"
#include "noiseacc.h"

/********************************************************************************************
;  Subroutine Name: RoundNoiseAccum2
;
;  Description:
;     This routine rounds and shifts the 48-bit accumulator array generated by
;     the NoiseAcc function into an array of 32 bit numbers.  RoundNoiseAccum does not
;     check for saturation or overflow.  The user is responsible for ensuring that the
;     shift value s_bit_position is large enough so that all the final array entries will
;     fit into a 32-bit integer.  RoundNoiseAccum is also not guaranteed to work for
;     shift values greater than 16 or less than 0.  So the user must make sure that
;     0<= s_bit_position <=16.
;
;  Prototype:
;     void RoundNoiseAccum2(int32 *pla_in, int32 *pla_round, int16 s_first_chan, int16 s_last_chan, int16 s_bit_position);
;
;  Input Arguments:
;     pla_in         -- pointer to the array of 48-bit accumulators
;     s_first_chan   -- first channel
;     s_last_chan    -- last channel
;     s_bit_position -- the lowest bit position preserved after shifting
;
;  Output Arguments:
;     pla_round      -- pointer to the array of rounded and shifted numbers
;
;  Return Value:
;     none
;
;  Global Variables:
;     none
;
;****************************************************************************/
#ifdef TARGET_HW
int32 round64(int32 l_AccH, int32 l_AccL, int16 s_bit_position);
#endif
C_SCOPE void RoundNoiseAccum2(int32 *pla_in, int32 *pla_round, int16 s_first_chan, int16 s_last_chan, int16 s_bit_position)
{
   int16 i, s_num_chan;

   pla_round += s_first_chan;
   pla_in    += 2*s_first_chan;
   s_num_chan = s_last_chan - s_first_chan+1;
   for (i=0; i<s_num_chan; i++)
   {
#ifdef TARGET_HW
      if(gs_RxState != R_C_COMB2_RX_BIS)
         *pla_round++ = round64(*(pla_in+1), *pla_in, s_bit_position);
      else
#endif
         *pla_round++ = round_acc48(*(pla_in+1), *pla_in, s_bit_position);
      pla_in += 2;
   }
}
