/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  File Name: sqrt32.c
;
;
;***************************************************************************/

#include "typedef.h"
#include "dsp_op2.h"

/***************************************************************************************
;  Subroutine Name: sqrt32
;
;  Description:
;     This function returns the square root of absolute value of the 32-bit
;     signed input l_in.
;
;  Prototype:
;     int16 sqrt32(int32 l_in)
;
;  Input Arguments:
;     l_in
;
;  Output Arguments:
;
;
;  Return Value: round( sqrt (abs(l_in)))
;
;**********************************************************************************************/
C_SCOPE int16 sqrt32(int32 l_in)
{

   int16 s_exp;
   int16 s_sqrt, s_test;
   int32 l_temp,l_sqrtXsqrt = 0;

   if(l_in < 0) {
      l_in = -l_in;
   }
   s_sqrt = 0;
   for(s_exp=1<<14; s_exp>=1; s_exp>>=1) {

      s_test = s_sqrt + s_exp;
      l_temp = (int32)s_test*s_test;
      if(l_in >= l_temp) {
         s_sqrt = s_test;
         l_sqrtXsqrt = l_temp;
      }
   }

   // Loop stops with s_sqrt as highest integer less than sqrt(in)
   // Do rounding if not at Max +ve.

   if (s_sqrt < 0x7fff ){

      // Round up if  input > (sqrt+.5)**2 = (sqrt*sqrt + sqrt +.25)
   if (l_in > l_sqrtXsqrt + s_sqrt)  s_sqrt++;
   }

   return(s_sqrt);
}

