/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *-------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   tx_ops.c
 *
 *   Transmitter operations.
 *
 *-------------------------------------------------------------------------
 */

#include "common.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "tx_ops_bis.h"
#include "pn_tab.h"
#include <string.h>
#include "tx_ops2.h"
#include "fifo.h"
#include "cmv.h"
#include "applyblackoutbits.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : TxReverbSegueSetUp
 *
 *  Description:
 *
 *    Fills global transmit buffer gsa_TxToneBuf with
 *    freq domain samples for sending either the R_Reverb or R_Segue signal.
 *
 *    The R_Reverb signal is created by encoding the psuedo random upstream
 *    sequence (UPRD) on all channels from s_RRvrbFirstChn to gs_TxLastChannel.
 *
 *    The R_Segue signal is generated by a tone-by-tone 180 degree phase
 *    reversal of R_Reverb.
 *
 *  Prototype:
 *    void TxReverbSegueSetUp(int16 s_RRvrbFirstChn, int16 s_RRvrbLastChn, int16 s_Reverb);
 *
 *  Input Arguments:
 *      int16 s_RRvrbFirstChannel - lowest channel on which to send R_Reverb
 *    int16 s_RRvrbFirstChannel - highest channel on which to send R_Reverb
 *      int16 s_Reverb            - ( = 0) transmit R_Reverb
 *                                 ( = 1) transmit R_Segue
 *
 *  Output Arguments:
 *    None
 *
 *  Return:
 *    None
 *
 *
 *  Global Variables Used:
 *      gusa_PN_US_Tab[32] - (I) bit pattern table for R_Reverb signal
 *      gsa_TxToneBuf[]   - (O) frequency domains samples
 *
 *------------------------------------------------------------------------
 *^^^
 */
void TxReverbSegueSetUp(int16 s_RRvrbFirstChn, int16 s_RRvrbLastChn, int16 s_Reverb) {

   int16 s_gain;

   // If h/w generates Reverb/Segue sequence
   if((TESTArray[TEST_HWSequenceGeneration] & TEST_HwReverbSegueSequenceGeneration) != 0) {
      // If TxDataPumpSetup will be triggered in this state,
      // disable h/w based sequence generation
      if(gs_TxState == R_REVERB7_TX_BIS || gs_TxState == R_REVERB5_TX ||   gs_TxState == R_REVERB_FR7_TX) {
         TESTArray[TEST_HWSequenceGeneration] &= ~TEST_HwReverbSegueSequenceGeneration;
         gft_QAM_On = FALSE;
      } else {
         guc_sequenceToGenerate = (uint8)s_Reverb;
         AddFunctionToFifo(gp_TxLoadingFunctionFifo,TxHwSequenceGenerationSetup);
         return;
      }
   }

   /* ==================================================================== */
   /*  Encode the psuedo random sequence, use positive gain for R_Reverb, */
   /*  negative gain for R_Segue */
   /* ==================================================================== */
   if(s_Reverb == R_REVERB)
      s_gain = ENCGAIN2;
   else
      s_gain = 0 - ENCGAIN2;


   Gen_Reverb_Ref_fd(gsa_TxToneBuf, GEN_REVERB_TYPE_RT, (int16)(gs_TxFftLength>>1), s_RRvrbFirstChn, s_RRvrbLastChn, s_gain);

   if(gft_ModemType == G_DMT_BIS)
   {
      if((gs_TxState > R_SEGUE1_TX_BIS) || (gs_TxState == R_SHOWTIME_TX))
         ClearTonesNotInUsMedleySet(gsa_TxToneBuf);
      else
         ApplyBlackoutBits(gsa_TxToneBuf);
   }

}

