/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *-------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   tx_ops2.c
 *
 *   Functions from tx_ops.c which are called by both the state machine
 *   and the BG Tasks.
 *
 *-------------------------------------------------------------------------
 */

#include "common.h"
#include "ifft_fix.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "pn_tab.h"
#include <string.h>
#include "spectral_shape_bis.h"
#include "cmv.h"
#include "pll.h"

/*****************************************************************************
;  Subroutine Name: SyncSymbol(psa_QamEncOutput, s_num_tones, pusa_PNsequence, s_Gain)
;
;  Description:
;     This subroutine uses the input PN sequence to produce "s_num_tones" number of
;     QAM output (X,Y) pairs. Given a bit pattern table pointed by pusa_PNsequence and s_Gain,
;     every pair of bits, d(2i), d(2i+1), in the table is mapped to a QAM output,
;     represented by Xi and Yi value, for i=1, 2, ..., s_num_tones-1, according to the following rule:
;
;     indix = {d(2i+1), d(2i) }           Xi    Yi
;     ------------------------------------------------------------------------
;        0     0     0                 s_Gain      s_Gain
;        1     0     1                 -s_Gain     s_Gain
;        3     1     1                 -s_Gain     -s_Gain
;        2     1     0                 s_Gain      -s_Gain
;     -------------------------------------------------------------------------
;
;     where s_Gain is the constelation gain
;     Set X0 = Y0 = 0.
;
;  Prototype:
;     void SyncSymbol(int16* psa_QamEncOutput, int16 s_num_tones, uint16* pusa_PNsequence, int16 s_Gain);
;
;  Input Arguments:
;     s_num_tones -- number of frequency tones or bands (DC and Nyquist tone is consider to be one tone)
;     pusa_PNsequence -- pointer to the pesudo random bit-pattern sequence
;     s_Gain -- constellation gain applied to each constellation point
;
;  Output Arguments:
;     psa_QamEncOutput -- pointer to the QAM encoder output buffer which stores data in
;              the order of {0, 0, Xr[1], Xi[1], Xr[2], Xi[2], ..., Xr[sNTones-1], Xi[sNTones-1]}
;              where the first two entries are corresponding to DC and Nyquist tones,
;              Xr[k] and Xi[k] are corresponding to I and Q of a QAM symbol for tone i.
;
;  Global Variables Used:
;     guca_ByteMaskTable[8] -- bit mask table
;
;****************************************************************************/
void SyncSymbol(int16* psa_QamEncOutput, int16 s_num_tones, uint16* pusa_PNsequence, int16 s_Gain)
{
   int i, j;
   uint16 *pusa_PNtable, us_datum, us_datum1;
   int16 *ps_output;

   pusa_PNtable = pusa_PNsequence;
   ps_output = &(psa_QamEncOutput[0]);

   /* ======================================================================= */
   /* Expand bit pairs to QAM symbols */
   /* (Here always assume the number of tones is multiple of 16) */
   /* ======================================================================= */
   for(i = 0; i<(s_num_tones>>3); i++) {
      us_datum = *pusa_PNtable++;

      for(j=0; j<8; j++) {
         us_datum1 = us_datum & guca_ByteMaskTable[2];
         us_datum >>= 2;
         if(us_datum1 == 0) {
            *ps_output++ = s_Gain;
            *ps_output++ = s_Gain;
         }
         else if(us_datum1 == 2) {
            *ps_output++ = s_Gain;
            *ps_output++ = -s_Gain;
         }
         else if(us_datum1 == 3) {
            *ps_output++ = -s_Gain;
            *ps_output++ = -s_Gain;
         }
         else {
            *ps_output++ = -s_Gain;
            *ps_output++ = s_Gain;
         }
      }
   }

   /* Set DC and Nyquist tone to 0 */
   psa_QamEncOutput[0] = psa_QamEncOutput[1] = 0;
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: Gen_Reverb_Ref_fd
 *
 *  Description:
 *    Generates the frequency domain representation of the
 *    C_Reverb or R_REVERB signal.
 *
 *  Prototype:
 *    void Gen_Reverb_Ref(int16 *psa_OutBuf,
 *                         int16 s_signal_id,
 *                         int16 s_NumChn,
 *                                  int16 s_RvrbFirstchn,
 *                                  int16 s_RvrbLastChn,
 *                         int16 s_Gain);
 *
 *  Input Arguments:
 *    s_signal_id       - indicates which signal (C_REVERB or R_REVERB) to generate
 *    s_NumChn       - total number of channels
 *      s_RvrbFirstChn     - first channel to send C_Reverb
 *      s_RvrbLastChn      - last channel to send C_Reverb
 *    s_Gain            - amplitude of each frequency component
 *
 *  Output Arguments:
 *      int16 *psa_OutBuf  - pointer to the freqency domain representation of C_Reverb signal
 *
 *  Return:
 *    none
 *
 *------------------------------------------------------------------------
 *^^^
 */
void Gen_Reverb_Ref_fd(int16 *psa_OutBuf, int16 s_signal_id, int16 s_NumChn,
                       int16 s_RvrbFirstChn, int16 s_RvrbLastChn, int16 s_Gain)
{

   int i;

    /* ==================================================================== */
   /*  Encode the psuedo random sequence */
   /* ==================================================================== */
    if(s_signal_id == GEN_REVERB_TYPE_CO) {
      SyncSymbol(psa_OutBuf, s_NumChn, gusa_PN512Tab, s_Gain);

      /* Insert pilot tone */
      if (gft_AuxPilot == AUX_PILOT_DISABLE ||
         !(( gl_SelectedMode & (MODE_ADSL2)  )))
      {
         psa_OutBuf[2*gs_CPilotTone] = s_Gain;
         psa_OutBuf[2*gs_CPilotTone+1] = s_Gain;
      }
   }
   else
      // Generate RT Reverb.  Always set number of channels to gs_TxNumTones.
      SyncSymbol(psa_OutBuf, gs_TxNumTones, gusa_PN_US_Tab, s_Gain);

   /* ==================================================================== */
   /*  Clear unused frequency bins */
   /* ==================================================================== */

   /*  clear below first channel */
   for (i=0; i < s_RvrbFirstChn; i++) {
      psa_OutBuf[2*i] = 0;
      psa_OutBuf[2*i+1] = 0;
   }
   /*  clear above last channel */
   for (i = (s_RvrbLastChn + 1); i < s_NumChn; i++) {
      psa_OutBuf[2*i] = 0;
      psa_OutBuf[2*i+1] = 0;
   }
}
