/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#include "gdata.h"
#include "dsp_op.h"
#include "dsp_op2.h"
#include "decimalgain.h"
#include "mul.h"

/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*       int16 ComputeRMSFineGain(uint8 *psa_Bat, int16 *psa_FineGains, int16 s_NumTones, int16 s_CurrentCoChipset, FlagT ft_FineGainsAreLinear)
*
*   Abstract:
*       This function computes the RMS value of the fine gains over
*     the downstream or upstream tones with non-zero bit-loading.
*
*   Input Parameters:
*
*  Return:
*     RMS fine gain in 3.13 format.
*
*  Global Variables:
*
*-----------------------------------------------------------------------------
^^^*/
C_SCOPE int16 ComputeRMSFineGain(uint8 *psa_Bat, int16 *psa_FineGains, int16 s_NumTones, int16 s_CurrentCoChipset, FlagT ft_FineGainsAreLinear, FlagT ft_UseAllTones)
{
   int16 i, s_ncloaded, s_num_exp, s_denom_exp, s_quot, s_quot1_exp, s_quot2_exp;
   int16 s_FineGain;
   int32 l_LSW, l_MSW, l_Prod;

   s_ncloaded = 0;
   l_MSW = l_LSW = 0;
   for(i=0; i<s_NumTones; i++) {

      s_FineGain = psa_FineGains[i];
      if (!ft_FineGainsAreLinear)
         s_FineGain = DecimalGain(s_FineGain);

      if( (psa_Bat[i] > 0) ||       // Spec averages if b_i > 0 ; ALA seems to average if g_i >0
         ((s_CurrentCoChipset==ALA_CO_CHIPSET) && (s_FineGain>0)) ||
         ((ft_UseAllTones) && (i>=gs_TxFirstChannel))  )
      {
         s_ncloaded++;
         MULS16(l_Prod,s_FineGain, s_FineGain);
         l_LSW += (l_Prod & 0xffff);
         l_MSW += (l_Prod >> 16);
      }
   }

   s_denom_exp = -norm_l((int32)s_ncloaded)+16;
   s_ncloaded <<= -s_denom_exp;

   s_num_exp = -norm_l(l_LSW);
   l_LSW <<= -s_num_exp;
   Divide_32by16bit(l_LSW, s_num_exp, s_ncloaded, s_denom_exp, &s_quot, &s_quot1_exp);
   l_LSW = (int32) s_quot;

   s_num_exp = -norm_l(l_MSW);
   l_MSW <<= -s_num_exp;
   Divide_32by16bit(l_MSW, s_num_exp, s_ncloaded, s_denom_exp, &s_quot, &s_quot2_exp);
   l_MSW = (int32) s_quot;

   l_Prod = l_LSW >> -s_quot1_exp;
   l_Prod += l_MSW << (16+s_quot2_exp);

   return(sqrt32(l_Prod));
}
