/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             atm_tx_processing.c
 * DESCRIPTION:
 *
 **********************************************************************/

/**********************************************************************/
// atm_tx_processing.c
//
// History
//
// 09/01/2013 Ram: Using appropriate variables to capture US Tx ATM counters.
//                 Variable 'gula_fe_tot_cell_cnt' was wrongly being used for US Tx Atm processing.
//                 It is being be used to capture FE counter values in func
//                 RxPlamProcessor_bis() (File: rx_plam_bis.c)
//                 Grep for XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping
// ******************************************************************

#include "common.h"
#include "typedef.h"
#include "gdata.h"
#include "tx_plam.h"
#include "cmv.h"

//==============================

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void do_atm_tx_processing(void)
*
*   Description:
*     Atm processing (gets atm status)
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
C_SCOPE void do_atm_tx_processing(void)
{
   int i;
   // Get Far end Tx ATM cell counter

      for (i = 0; i < gt_tx_config.s_Nbc; i++)
      {
         //XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping (Start)
         //Using appropriate variables to capture US Tx ATM counters
         gula_tx_idle_cell_cnt[i] += GetTxIdleCellCnt((int16)i);
         gula_tx_non_idle_cell_cnt[i] += GetTxNonIdleCellCnt((int16)i);
         gula_tx_tot_cell_cnt[i] = (gula_tx_idle_cell_cnt[i] + gula_tx_non_idle_cell_cnt[i]);
         //XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping (End)
         ResetATCellCnt((int16)i);
      }


}

