/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1212
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: cnfgshwt.c
;
;  Configuration routines for "showtime-only" tests, i.e. a test that skips over
;  hanshake and initialization.
;
*****************************************************************************/

#include "common.h"
#include "gdata.h"

#define MANTISSA (0x54CD>>(16 - FDQ_MANTISSA_WORDLENGTH))
#define EXP1 (FDQ_MANTISSA_FRAC_BITS - 12 + (16 - FDQ_MANTISSA_WORDLENGTH) - 1)
#define EXP2 (FDQ_MANTISSA_FRAC_BITS - 11 + (16 - FDQ_MANTISSA_WORDLENGTH) - 1)

/* The following choice of coefficients is to make the output of FDQ equal to 0x2000 for QPSK case, */
/* when there is no channel effect and no FDQ initialization being done. */
/* The scaling factor used is obtained from: */
/* (0x4000/ENCGAIN2=0x2000/0x304D) = MANTISSA * 2^(-14) */
/* Since the IFFT/FFT has a total of 1/4 scaling, so the FDQ coefficient becomes MANTISSA*2^(-3) */
/* Such, ps_coef[i] = MANTISSA, ps_exp[i] = 3 (right shifts) */

void InitShowtimeTestFDQ(int16 s_RxNumTones)
{
    int16 i;

    /* coefficients of FDQ */
    for(i=0; i<s_RxNumTones; i++)
    {
        gsa_pre_FDQ_coef[2*i] = MANTISSA;
        gsa_pre_FDQ_coef[2*i+1] = 0;
    }

   /* Since the IFFT/FFT has a total of 1/8 scaling, so ps_exp[i] = 4 (right shifts)         */
   for(i=0; i<s_RxNumTones; i++)
   {

      guca_pre_FDQ_exp[i] = EXP2;

   }
}
