/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             showinit.c
 * DESCRIPTION:      Functions that implement the showtime state.
 *
 **********************************************************************/

#include <stdio.h>
#include "common.h"
#include "gdata.h"
#include "dslengin.h"
#include "dec_gain.h"
#include "cmv.h"
#include "tone_ord.h"
#include "bitload.h"
#include "rx_m3oh.h"
#include "tx_m3oh.h"
#include "enc_gain.h"
#include "dec_adap.h"
#include "gdata_bis.h"
#include "trailend.h"
#include "ovhd_ini_bis.h"
#include "aoc_ini.h"
#include "tx_eoc.h"
#include "rx_eoc.h"
#include "tx_ib.h"
#include "rx_ib.h"
#include "tx_ovrhd_bis.h"
#include "rx_ovrhd_bis.h"
#include "showinit.h"
#include "T1413.h"
#include "ghs.h"



/*****************************************************************************
;  Subroutine Name: CalcPathDelay(int16 s_Path, Config_t *pt_config)
;
;
;  Prototype:
;     int32 CalcPathDelay(int16 s_Path, Config_t *pt_config)
;
;  Input Arguments:
;
;
;  Output Arguments:
;
;
;  Return:
;
;
;  Global Variable used by this file:
;
;****************************************************************************/

C_SCOPE int32 CalcPathDelay(int16 s_Path, Config_t *pt_config)
{

   int16 i,s_temp;
   int16 s_Nfec_p;
   int16 s_Kp = 0;
   int32 l_Path_delay = 0;

   /* Kp = Bp0 + Bp1 + 1 */

   for (i = 0; i< NUM_DS_BEARER_CHANNELS; i++)
      s_Kp = s_Kp + pt_config->sa_Bpn[s_Path][i];

   s_Kp = s_Kp + 1;

   /* Nfecp = Mp * Kp + Rp */
   s_Nfec_p = pt_config->s_Mp[s_Path] * s_Kp + pt_config->s_Rp[s_Path];

   /* Delay = Sp *  Dp */
   /* Delay = ( 8 * Nfec_p * Dp) / Lp */

   /* Delay = [ 8 * Nfec_p *  Dp * Lp0 * Lp1 ] / Lp */
   /* Get rid of the denominator, by multiplying with Lp0* Lp1 */

   s_temp = 8 * s_Nfec_p;

   l_Path_delay = s_temp * pt_config->s_Dp[s_Path] * pt_config->s_Lp[1 - s_Path];

   return(l_Path_delay);
}


/*****************************************************************************
;  Subroutine Name: ComputePathWithSmallestLatency(Config_t *pt_config)
;
;  Prototype:
;     int16 ComputePathWithSmallestLatency(Config_t *pt_config)
;
;  Input Arguments:
;
;
;  Output Arguments:
;
;
;  Return:
;     Returns 0 if LP0 is the lowewst latency path
;     Returns 1 if LP1 is the lowest latency path
;
;  Global Variable used by this file:
;
;****************************************************************************/

C_SCOPE int16 ComputePathWithSmallestLatency(Config_t *pt_config)
{
   if(!pt_config->s_Lp[LP1_DATA_PATH] ||
      CalcPathDelay(LP0_DATA_PATH, pt_config) <= CalcPathDelay(LP1_DATA_PATH, pt_config))
   {
      return(LP0_DATA_PATH);
   }
   else
   {
      return(LP1_DATA_PATH);
   }
}

/*****************************************************************************
;  Subroutine Name: int16 ComputeSEQ(int16 s_Path,Config_t *pt_config)
;
;
;  Prototype:
;     int16 ComputeSEQ(int16 s_Path,Config_t *pt_config)
;
;  Input Arguments:
;
;
;  Output Arguments:
;
;
;  Return:
;
;
;  Global Variable used by this file:
;
;****************************************************************************/


C_SCOPE int16 ComputeSEQ(int16 s_Path,Config_t *pt_config)
{

   int16 s_LowestLatencyPath, s_SEQ;
   s_LowestLatencyPath = pt_config->s_IBITSlp;

   if(s_Path == pt_config->s_MSGlp)
   {
      if(s_Path == s_LowestLatencyPath)
      {
         s_SEQ = pt_config->s_MSGc + 6;
      }
      else
      {
         s_SEQ = pt_config->s_MSGc + 2;
      }
   }
   else if(s_Path != pt_config->s_MSGlp)
   {
      if(s_Path == s_LowestLatencyPath)
      {
         s_SEQ =  6;
      }
      else
      {
         s_SEQ =  2;
      }
   }

   return(s_SEQ);
}

