/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             preshow.c
 * DESCRIPTION:      Functions that implement the showtime state.
 *
 **********************************************************************/
#include <string.h>
#include "common.h"
#include "gdata.h"
#include "dslengin.h"
#include "fifo.h"
#include "mp.h"
#include "cmv.h"
#include "bert.h"
#include "engine_const.h"
#include "tx_ops.h"
#include "preshow.h"
#include "states.h"
#include "data_alloc.h"
#include "showtime_bis.h"




#ifndef TARGET_HW

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void RPreShowtimeTxTC
*
*   Description:
*
*  Time-critical task associated with Pre-Showtime Tx Frames.
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
void RPreShowtimeTxTC(void)
{
   /* ======================================================================================= */
   /* Time-critical task for Tx interrupt during Pre-showtime state (showtime-only testing)   */
   /* ======================================================================================= */

   /* If there are pending loading functions, then run them.      */

   ExecuteQueuedLoadingFunctions(gp_TxLoadingFunctionFifo);

   if(gft_ModemType != G_DMT_BIS)
   {
      if (gft_TxDataPump_On == TRUE)
      {
         StartTxDataPump_DMT();
      }
   }
}

/*****************************************************************************
;  Subroutine Name: RPreShowtimeTxF(void)
;
;  Non-time critical task for pre-showtime state.  This state is starting state for
;  showtime-only tests.  It is not entered during normal use.
;
;
;  Prototype:
;     void RPreShowtimeTxF(void)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;
;****************************************************************************/
void RPreShowtimeTxF(void)
{
   if (gl_TxSymbolCount == (R_PRE_SHOWTIME_LEN - gs_num_preproc_frames - FRAME_LATENCY_TX_SHOWTIME))

      AddFunctionToFifo(gp_TxLoadingFunctionFifo, EnableTxIntlvFraming);

   if (gl_TxSymbolCount > (R_PRE_SHOWTIME_LEN - gs_num_preproc_frames - FRAME_LATENCY_TX_SHOWTIME))

      gft_TxDataPump_On = TRUE;

#ifndef ADSL_62
   if (gl_TxSymbolCount == (R_PRE_SHOWTIME_LEN - FRAME_LATENCY_TX_SHOWTIME - 1))
      AddFunctionToFifo(gp_TxLoadingFunctionFifo, Enable_MTE_Tx);
   if (gl_TxSymbolCount == (R_PRE_SHOWTIME_LEN - FRAME_LATENCY_TX_SHOWTIME))
      AddFunctionToFifo(gp_TxLoadingFunctionFifo, EnableTxFastFraming);
#endif

#ifdef ADSL_62
   if (gl_TxSymbolCount == (R_PRE_SHOWTIME_LEN - 3)){
#else
   if (gl_TxSymbolCount == (R_PRE_SHOWTIME_LEN - 1)){
#endif
      gs_TxNextState = R_SHOWTIME_TX;
      if (gft_ModemType == G_DMT_BIS) {
         gt_TaskArray[TX_FRAME_START].TimeCriticalTask=RShowtimeTxTC_BIS_A;
         gpF_TxStateFunc = (PtrToFunc)RShowtimeTxF_BIS;
      }
      else {
         gt_TaskArray[TX_FRAME_START].TimeCriticalTask=RShowtimeTxTC_DMT;
         gpF_TxStateFunc = (PtrToFunc)RShowtimeTxF_DMT;
      }

      /* ================================================================================= */
      /* Update gsa_TxToneBuf with synch symbol (the reverb signal)                 */
      /* ================================================================================= */
      TxReverbSegueSetUp(gs_TxFirstChannel, gs_TxLastChannel, R_REVERB);
   }

   /* New BERT code */
#ifndef DISABLE_BERT
   if ((TESTArray[TEST_Control] & TEST_BertControl) != 0)
      TxPNSequenceSetup();
#endif
}

/*****************************************************************************
;  Subroutine Name: RPreShowtimeRxF(void)
;
;  Non-time critical task for pre-showtime state.  This state is starting state for
;  showtime-only tests.  It is not entered during normal use.
;
;
;  Prototype:
;     void RPreShowtimeRxF(void)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;
;****************************************************************************/
void RPreShowtimeRxF(void)
{
   int16 s_R_PRE_SHOWTIME_LEN;         // Length pf R_PRE_SHOWTIME stage.

   int16 s_Sachmo_Timing_Adjustment;   // Timing adjustment for pseudo CO connectivity test using Sachmo.
                              // Needed for connecting Beacon Hill CPE to pseudo CO.

   if(((TESTArray[TEST_Control2] & TEST_ConnTypeBit0) != 0) &&
      ((TESTArray[TEST_Control2] & TEST_ConnTypeBit1) == 0))
      s_Sachmo_Timing_Adjustment = 2;     // Sachmo is used
   else
      s_Sachmo_Timing_Adjustment = 0;     // DLI or Sample-based DLI is used

   /* Compute the effective length of R_PRE_SHOWTIME */
   s_R_PRE_SHOWTIME_LEN = R_PRE_SHOWTIME_LEN;
   if (TESTArray[TEST_Control] & TEST_ConnControl)
   {
   /* if running connectivity tests, increase RX pre-showtime length by 3 frames */

      s_R_PRE_SHOWTIME_LEN = R_PRE_SHOWTIME_LEN + 3;

   }
   /* Account for extra frame of latency in case of a pre-showtime(train) fft scenario 4 */
   if((OPTNArray[OPTN_FFTBufferControl] & OPTN_FFTBufferTrainControlMask) == OPTN_TrainScenario4)
      s_R_PRE_SHOWTIME_LEN++;

#ifdef ADSL_62
      memcpy(gsa_RxBuffer8X_1, gsa_pre_FDQ_coef, sizeof(int16)*gs_RxSamplesPerFrame);

      //move FDQ coefficients array to YMEM (L2 functionality requires FDQ reside in XYmem).
      gsa_FDQ_coef_out = gsa_pre_FDQ_coef = (int16 *) gsa_RxBuffer8X_1;
        //move RxToneBuf to YExtended
      gsa_RxToneBuf = (int16 *) gsa_YBlock_Extended;

   MemSetBuffer(gsa_RxToneBuf, 0, 0, (int16)(sizeof(int16)*(2*gs_RxNumTones)));

#endif
   /* Train to showtime transition */
   DoRxFFTBufferScenarioTransition((int16)(gl_RxSymbolCount+1), s_R_PRE_SHOWTIME_LEN);
}

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void RPreShowtimeRxTC
*
*   Description:
*
*  Time-critical task associated with Pre-Showtime Rx Frames.
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/


void RPreShowtimeRxTC(void)
{

   /* ===========================================================================   */
   /* The RxLoading function is used to modify the engine. It can be used for    */
   /* cyclic prefix insertion, loading equalizer taps, etc                    */
   /* ===========================================================================   */

   /* If there are pending loading functions, then run them */

   ExecuteQueuedLoadingFunctions(gp_RxLoadingFunctionFifo);
}
#endif
