/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             showinit_rx_qam.c
 * DESCRIPTION:      Functions that do QAM configuration
 *
 **********************************************************************/
//******************************************************************************
//showinit_rx_qam.c
//
//08/11/2012 Anantha: Assigning value SUCCEED to gft_BitloadOK if total bits after removal of TCM overhead is matching with
//             bitloading before bitswap
//           grep for XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap
//
// 12/06/2013 Balbath: Link drops when there is a change number of 1bit loaded tones after bitswap.
//             Link drops were observed with Annex M mode only, AnnexA cases seems fine
//             Did experiments by disabling one bit tone modifications during bit-swap, and link is stable.
//             Required RX_MIN_ADDR (IR_ACT_ADDRD) programming to be (gs_RxFirstChannel-1) when No. of 1 bit
//             tones are not multiple of 4. With this fix, AnnexM link is stable.
//             Triggering of continuous bitswaps in these profiles: to be decided ?
//             Grep for XDSLRTFW-945 Bug_DS_BisPlus_SRACappedprofile_Lindrops
//*******************************************************************************

#include "common.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "states.h"
#include "bitload_support.h"
#include "rinfotbl.h"

/********************************************************************************
;  Subroutine Name: void VerifyAndUpdateRxQAMParameters(void)
;
;
;  Prototype:
;     void VerifyAndUpdateRxQAMParameters(void)
;
;  Input Arguments:
;
;
;  Output Arguments:
;
;
;  Return:
;
;
;  Global Variable used by this file:
;
;****************************************************************************/


C_SCOPE void VerifyAndUpdateRxQAMParameters(void)
{
   FlagT ft_TcmFlag;
   // XDSLRTFW-945 Bug_DS_BisPlus_SRACappedprofile_Lindrops (start_end)
   FlagT ft_EvenNumer;
   int16 s_bits;
   int s_RxTotalDataBits;
   uint8 *puca_BAT;

   puca_BAT = gt_rx_config.psa_BAT;

   if(gft_ModemType == G_DMT_BIS) ft_TcmFlag =  gft_TcmFlag_bis_DS;
   else ft_TcmFlag = gft_TcmFlag;

   s_RxTotalDataBits = gt_rx_config.s_Lp[LP0_DATA_PATH] + gt_rx_config.s_Lp[LP1_DATA_PATH];

   GetBatStats(puca_BAT, gs_RxNumTones, ft_TcmFlag, &gus_ncloaded,(int16 *)(void *)&gus_Rx_Tcm_Num1bits, &gs_Rx_TCM_Ovhd, &s_bits, COMBINED_LP);


   // XDSLRTFW-945 Bug_DS_BisPlus_SRACappedprofile_Lindrops (start)
   /* Compute Actual Min Tone Indx based on # of tones loaded, TCM On and # of 1 bit pairs */
   // Observed programming of "gus_Rx_MinToneIndx" is neccessary only when " gs_RxFirstChannel " is even.
   if((gs_RxFirstChannel&0x1) == 0)
      ft_EvenNumer = TRUE;
   else
      ft_EvenNumer = FALSE;

   if(ft_EvenNumer == TRUE)
   gus_Rx_MinToneIndx = gus_Rx_MaxToneIndx - gus_ncloaded + 1;

   if (ft_TcmFlag==TRUE)
   {
      s_bits -= gs_Rx_TCM_Ovhd;
      if(((gus_ncloaded - (gus_Rx_Tcm_Num1bits>>1)) & 0x1) == 1)
      {
         gft_Rx_Tcm_X0_YGT1 = TRUE;

         if(ft_EvenNumer == TRUE)
            gus_Rx_MinToneIndx--;

      }
   }

   // Even though the actual min tone index as computed above can be much larger than gs_RxFirstChannel;
   // for various reasons we set the gus_Rx_MinToneIndx to an even/odd value <= gs_RxFirstChannel
   if(ft_EvenNumer == TRUE)
   {
      if((gs_RxFirstChannel&0x1) == (gus_Rx_MinToneIndx & 1))
         gus_Rx_MinToneIndx = gs_RxFirstChannel;
      else
         gus_Rx_MinToneIndx = gs_RxFirstChannel-1;
   }
   // XDSLRTFW-945 Bug_DS_BisPlus_SRACappedprofile_Lindrops (end)
    //XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(start_end)
   //Assigning value SUCCEED if total bits after removal of TCM overhead is matching with
   //bitloading before bitswap
   // Check Lp + TCM overhead = SUM(Bi) and if Trellis is on, we don't have odd number of 1 bit tones
   if((s_bits != s_RxTotalDataBits) || ( (ft_TcmFlag==TRUE) && (gus_Rx_Tcm_Num1bits & 0x1) ))
   {
      gft_BitloadOK = FAIL;
   }
   else if(!TESTArray[Test_DisableBitSwapImprvmnt])
   {
      gft_BitloadOK = SUCCEED;
   }

}
