/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             showinit_tx_qam.c
 * DESCRIPTION:      Functions that configures QAM
 *
 **********************************************************************/
//****************************************************************************
//showinit_tx_qam.c
//
// History
//
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//*****************************************************************************************

#include "common.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "bitload_support.h"

/********************************************************************************
;  Subroutine Name: FlagT VerifyAndUpdateTxQAMParameters(uint8* uca_BAT, int16* sa_Lp)
;
;
;  Prototype:
;     FlagT VerifyAndUpdateTxQAMParameters(uint8* uca_BAT, int16* sa_Lp)
;
;  Input Arguments:
;
;
;  Output Arguments:
;
;
;  Return:
;
;
;  Global Variable used by this file:
;
;****************************************************************************/

C_SCOPE FlagT VerifyAndUpdateTxQAMParameters(uint8* uca_BAT, int16* sa_Lp)
{
   FlagT ft_TcmFlag;
   int16 s_bits;
   int s_TotalDataBits_tx;

   if(gft_ModemType == G_DMT_BIS) ft_TcmFlag =  gft_TcmFlag_bis_US;
   else ft_TcmFlag = gft_TcmFlag;


   GetBatStats(uca_BAT, gs_TxNumTones, ft_TcmFlag, (uint16 *)(void *)&gs_TxNumLoadedTones, (int16*)(void *)&gus_Tx_Tcm_Num1bits, &gs_Tx_TCM_Ovhd, &s_bits, COMBINED_LP);
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
//SMS01435809:FEATURE_US_BisPlus_ALL_UReTx_RRC_feature Begin
//   if((gt_ReTxConfigInfo.ft_ReTxOn == 1) && (gt_ReTxConfigInfo.us_ReTxConfigOptionBits & SEND_LpRCC))
   if(gt_ReTxConfigInfo.ft_ReTxOn == 1)
   {
      s_TotalDataBits_tx = sa_Lp[LP0_DATA_PATH] + DS_RRC_BITS;  //add 24 bits of LpRRC
   }
   else
   {
      s_TotalDataBits_tx = sa_Lp[LP0_DATA_PATH] + sa_Lp[LP1_DATA_PATH];
   }
//SMS01435809:FEATURE_US_BisPlus_ALL_UReTx_RRC_feature End
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
   if (ft_TcmFlag==TRUE) {
      s_bits -= gs_Tx_TCM_Ovhd;
      //BugFix_BisPlus_ALL_USBitSwapFix (Start_End)
      gft_Tx_Tcm_X0_YGT1 = FALSE; // Re-initialise
      if((gs_TxNumLoadedTones - (gus_Tx_Tcm_Num1bits>>1)) &0x1 == 1)
         gft_Tx_Tcm_X0_YGT1 = TRUE;
   }

   // Check Lp + TCM overhead = SUM(Bi) and if Trellis is on, we don't have odd number of 1 bit tones
   if((s_bits != s_TotalDataBits_tx) || ((ft_TcmFlag==TRUE) && (gus_Tx_Tcm_Num1bits & 0x1)))
      return (FALSE);
   else
      return (TRUE);
}
