/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
*
* Aware DMT Technology. Proprietary and Confidential.
*
* ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
* TELEPHONE:        781.276.4000
* FAX:              781.276.4001
* WEB:              http://www.aware.com
*
* FILE:             showinitrx.c
* DESCRIPTION:      Functions that implement the showtime state.
*
**********************************************************************/
// ******************************************************************
// showinitrx.c
//
// History
//
// 19/04/2010 Nihar: For debugging purposes it's very helpfull to have information
//            about the previous exception state/code available. So, put previous
//            Exc.Code/State into persistent memory and map it to CMVs
//            cr STAT 22 0 -> Prev. Exception State
//            cr STAT 23 0 -> Prev. Exception Code
//            Grep for Feature_ALL_ALL_ALL_PrevExceptionsCMV
//
// 05/08/2010 Nihar : Compute and Report the Impulse Noise protection in 0.1 DMT symbol representation
//       format entering to showtime for erasure decoding ON and OFF.
//       Grep for Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting
//
// 09/08/2010 Nihar : Added the code changes to skip the excess margin reduction using finegains
//                for   pilot tone in ALL modes.
//             Grep for Perf_DS_ALL_ALL_Pll_NoExMarginReduction
//
// 23/8/2011 Vinjam: Renamed "gl_LOS_detect_power" to "gl_AvgPilotPow".
//           renamed "gs_LOS_sframe_cnt" to "gs_LosDefect_state_cnt".
//           Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//
// 10/01/2012 Shakil/Bhadra: Random link drops seen in ADSL2p mode in a noisy line of DTAG customer house.CPE dropped the link
//             due to near end LOS generated by excessive Downstream CRCs. According to our reboot criterion it
//             requires more than 1000 downstream CRCs to declare LOS from the CPE side but while we supressed
//             the LOS generation (cw test 29 0 0x4) we did not see the issue and the maximum CRC was less
//             than 300. Since we expected more than 1000 CRCs when the LOS was supressed the root cause was in
//             the LOS based on CRC block of the code where we did not increase gsa_good_count_ variable atall which
//             trigerred LOS if CRC is increased by more than 40 in 20 seconds interval. The reason that gsa_good_count
//             did not increased is, it resides in a function called ProcessFramingBytes() which was excluded in the VR9
//             compilation process(executes only ifndef HERCULES_ADSL_CPE). Asa fix this variable was moved to the
//             correct place to be compiled and incremented correctly.
//             Code Grep: XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC
// 25/01/2012 Kannan: No of FDQ adaptation Channels increased from 32 to 48 for ADSL1 mode
//            to do the showtime SNR update faster, which will help to do the
//            bitswap faster while applying sudden RFI
//       Grep BugFix_DS_ADSL1_ALL_SuddenRFI
//
// 21/12/2011 Raghu:Stress test (FT stress test) has a marginal fail (1.07 e-07 instead of 1.0 e-07) on the
//                      Lucent Stinger linecard A2P72-HBI.
//                      1) Increase number of frames used for SNR averaging from 512 to 2048 When the margin
//                      goes below 2dB.
//                      2) Block size used for updating SNR and FDQ are inreased from 32 to 48 to reduces the
//                      response time which got increased due to increase in the frames used for averaging.
//                      Currently this is enabled only for CNXT DSLAMS.
//                      For code changes grep for XDSLRTFW-358 Enh_DS_BisPlus_CNXT_StressTest
//
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 19/06/2012 Ram: Merged "ReTx" related MGMT counters and Test Params code from
//                 ARX ADSL code base (Grep: FEATURE_DS_BisPlus_ALL_ReTx_MGMTCntrs_TestParams)
//                 Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 04/07/2012 Ram: Merged "ReTx" Bitswap code from ARX ADSL code base.
//                 Grep for "XDSLRTFW-443 FEATURE_DS_BisPlus_ALL_BitSwapReTx"
//
// 05/07/2012 Ram: Merged "ReTx" Segmented Bitswap Request code from ARX ADSL code base.
//   To cope with sweeping and fixed RFI, the following changes are done.
//   1. Below changes #2,#4,#5,#6 are under cmv control INFO 103 23 bitmask(0x0040). This bit is one (enabled) by default.
//   2. Modify the maximum number of bits for bitswap (gs_REDUCE_LP_DELTA_BITSWAP) from 20 to 120.
//   3. Increase Tx HDLC buffer size (MAX_TX_HDLC_MSG_SIZE, MAX_TX_HDLC_BUFFER_SIZE) from 700 to 1000.
//   4. Increase the maximum tone number (gs_MaxTonePerOvhdMsg) in one HDLC segment from 160 to 240.
//   5. Enable segmented bitswap request.
//   6. Change gs_DD_RxChannelsPerSymbol from 16 to 32 to improve SNR updating frequency.
//   7. Once marign on tones were ever dropped to below -6 dB, then bitswap is triggered when minimum margin is below 0 dB.
//      The threshold (-6dB by default) can be changed with cmv INFO 119 0.
//   8. Do not move bits to the tones whose margin were ever dropped to below -6 dB since these tones were very likely
//      to be affected by RFI before, and will be affected by RFI again. This mechanism is under cmv control
//      INFO 103 23 bitmask(0x0080). This bit is one (enabled) by default.
//   9. If bitswap is failed, checking of #7 condition will be ignored. Then bitswap will be tried again.
//   10. Include fix SMS01320806 IOP_A_BisPlus_CNXT_ImprovedBitSwap.
//   Grep for "XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest"
//
// 24/8/2012 Vinjam: Clearing CRC & FEC counters (global variables) are moved to CMV_ReMap and controlled by "DSL 19 0 Bit#0
//           Grep for XDSLRTFW-508 Fix_DS_All_All_SuppressCounterWriteFromDSLAPI (Start)
//
// 23/11/2012  Bhadra:XDSLRTFW-543:AVM rported Bug in ADSL FW "cmv_remap.c" resulting in wrong
//             "ActualInterleaveDelay" reporting for ADSL2 and ADSL2+.
//             This is becasue variables(s_Kp)of struct "DerivedFramePropLatencyPath_t" are under HERC_API
//             and these are not populated. There was an agreement with API team that future API version
//             including the one for PACE) will read Herc-cmv RATE 1 9 (verified in API 4.11.5 check Jira,XDSLRTFW-437)
//             And for backward compatibility of API versions, Add code to populate these variable(s_Kp,s_NFECp &s_Sp)
//             this code is taken from Vinax ref.
//              Also added code change for ActualPSD(ActPSD = RefPSD + RMSGI)population in NearEnd/FarEnd params structure
//             (which were n't populted earlier)
//             For code changes Grep for "XDSLRTFW-543:BugFix_BisPlus_DS_ALL_IntlvDelay"
//
////08/11/2012 Anantha:1.Initialize global varibale in bitswap improvement
//                2.Enable 21/12/2011 change by Raghu to all the DSLAMs
//             grep for XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap
//
// 07/01/2103 Ram: Added fix for JIRA 575 - According to Msg Spec ver 1.9, SW/DSL-API can
//                 overwrite Uncorrectable FEC/RS codeword count. Hence removing the initialization.
//                 Grep for XDSLRTFW-575: Counter Write back in ADSL mode
//
// 20/02/2013 Mahesh:  Removed Ananta's bitswap enhancement changes for L2 & SRA
//
// 18/02/2013 Vinjam: Report downstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 1 [14:15]" & "CMV_RATE 1 [16:17] respectively.
//            Also, Report upstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 0 [14:15]" & "CMV_RATE 0 [16:17] respectively.
//            Modified enable/disable of Erasuredecoder logic as per VRx Msg Spec through "CMV DSL 1 0"
//            Grep for XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec
//26-03-2013 Anantha: Initializing data structure used for triggering bitswap over stored SNR to increase bitswap speed
//             during RFI test
//          grep pattern XDSLRTFW-686: PERF_DS_DMT_ALL_Bitswap
// 22-04-2013 Anantha: Initializing variables used for pilot averaging
//              grep pattern XDSLRTFW-673: Enh_DS_ALL_ALL_ClkChg
//
// 18-06-2013 Ram: FW is setting Latency of unused path (Lp = 0) to -1. This is leading to Very High interleaver delay being displayed by
//                 SW API in command "g997csg". SW API normally sums up values corresponding to both paths LP0 and LP1 and the result is
//                 displayed. It expects only one of them (either LP0 or LP1) to have non-zero value. Hence fixed the bug by setting latency
//                 of unused path to ZERO.
//                 Grep for ADSLRTFW-1689: BugFix_DS_All_All_IncorrectIntlDelayReported
//
// 09/09/2014 ChihWen: HW acceleration for FDQ adaptation and SNR measurement.
//            Grep for XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ
//
// 04/01/2015 Anantha Ramu: Enabled CMV(CMV_ENA_PLL_FIX_UNCORR_DTU) bit for PLL fix of uncorrected DTUs.
//            Grep for XDSLRTFW-1223.
//
//  2/12/2015 Sriram Shastry : Observed Quartz instabilities with  AVM  fritzbox[7490]. Added Detection algorithm for frequency drift and  phase drift
//  such that PLL adapt's to  fast setting  instead of  showtime setting .It helps to avoid showtime link drops in field
//
// Grep for : XDSLRTFW-2464
//
// *******************************************************************************************************************************************

#include <stdio.h>
#include "common.h"
#include "gdata.h"
#include "dslengin.h"
#include "dec_gain.h"
#include "cmv.h"
#include "tone_ord.h"
#include "bitload.h"
#include "rx_m3oh.h"
#include "dec_adap.h"
#include "gdata_bis.h"
#include "trailend.h"
#include "ovhd_ini_bis.h"
#include "rx_eoc.h"
#include "rx_ovrhd_bis.h"
#include "showinit.h"
#include "states.h"
#include "ComputeRMSFineGain.h"
#include "memsetbf.h"
#include "snr.h"
#include "dsp_op2.h"
#include "diagparam_bis.h"
#include "gdata_bis_diag.h"
#include "ss_snrfdq.h"
#include "tx_ops_bis.h"
#include "CalcRate_BIS.h"
#include "CalcSigAttnDiag.h"
#include "pll.h"
#include "bitload_const.h"
#include <string.h>

FlagT gft_xmitAllTones = 0;

//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)
#ifdef HW_SNR_FDQ
int16 gsa_pilot_FDQ_coef[2];
uint8 guc_pilot_FDQ_exp;
#endif
//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (END)

/* define constants to clarify code */


/*****************************************************************************
;  Subroutine Name: RxInit(pt_config)
;
;  This subroutine conducts initialization for ADSL RX-side operations.
;
;
;  Prototype:
;     void RxInit(Config_t *pt_config)
;
;  Input Arguments:
;     pt_config -- pointer to a structure containing a set of configuration parameters
;
;  Output Arguments:
;     All static variables described below are initialized to proper values
;
;  Return:
;     number of raw data bytes per frame.
;
;  Global Variable used by this file:
;     gt_RxShowTimeVars, this stucture contains:
;
;     s_in_frame_number -- input frame number
;     s_out_frame_number   -- output frame number
;       t_FastParms_rx      -- Fast path parameter structure
;       t_InlvParms_rx      -- Interleaved path parameter structure
;       s_FastPathType_rx   --  = FAST_DATA_PATH
;       s_InlvPathType_rx   --  = INTERLEAVE_DATA_PATH
;     s_D               -- interleave depth
;     s_S               -- number of DMT symbols per FEC codeword
;     s_Rf_rx           -- number of FEC redundancy bytes, fast path
;     s_Ri_rx           -- number of FEC redundancy bytes, interleaved path
;     s_RawFrameSizef_rx   -- number of raw bytes per frame, fast path
;     s_RawFrameSizei_rx   -- number of raw bytes per frame, interleaved path
;     s_MuxFrameSizef      -- raw bytes + framing overhead bytes, fast path
;     s_MuxFrameSizei      -- raw bytes + framing overhead bytes, interleaved path
;       s_Lf_rx             -- number of LEX bytes in the fast path
;       s_Li_rx             -- number of LEX bytes in the interleaved path
;       sa_Bf_alloc         -- number of bytes allocated to each bearer channel
;                              in the fast path
;       sa_Bi_alloc         -- number of bytes allocated to each bearer channel
;                              in the interleaved path
;       sa_Bf_in            -- number of bytes received in each bearer channel
;                              in the fast path
;       sa_Bi_in            -- number of bytes received in each bearer channel
;                              in the interleaved path
;       Ft_C_Chan_Enabledf_rx   -- indicates if 'C' channel is enabled on LS0
;                                  for the fast path
;       Ft_C_Chan_Enabledi_rx   -- indicates if 'C' channel is enabled on LS0
;                                  for the interleaved path
;     s_CodewordSize    -- number of bytes per codeword
;     s_FecFrameSize    -- codewordSize/s_S
;     s_CodewordSize_Odd   -- s_CodewordSize_odd = s_CodewordSize + 1 if s_CodewordSize is even
;                       s_CodewordSize_odd = s_CodewordSize if s_CodewordSize is odd
;     psBAT_rx            -- pointer to bit loading table
;       psa_FineGains_rx    -- pointer to the fine gains table
;     uc_CRCf           -- CRC seed, fast path
;     uc_CRCi           -- CRC seed, interleaved path
;     ul_descramble_state_f   -- descrambler state, fast path
;     ul_descramble_state_i   -- descrambler state, interleaved path
;     s_first_byte      -- index of first valid byte in a codeward
;     s_ilv_start_loc      -- interleave buffer start location
;     s_ilv_buf_size    -- interleave buffer size
;     s_ilv_in_ptr      -- interleave buffer input pointer
;     s_frame_count     -- count for number of frames per codeword
;     s_deilv_frame_count  -- count for number of available deinterleaved frames
;     s_codeword_count  -- count for number of codewords in interleave buffer
;     uca_ilv_buf[MAX_RX_INTERLEAVE_BUF_SIZE] -- interleaved data buffer
;       s_inlv_frame_index  -- Start of interleaved path FEC frame within
;                              internal data buffer
;
;
;  Other Global Variables:
;
;     gft_FrameMode            -- (O) negotiated framing mode
;       gusa_CRC_count     -- (I/O) CRC error count
;     gsa_SnrReverbRefTones[] -- (I/O) reverb reference tones
;
;****************************************************************************/
void RxInit(Config_t *pt_config)
{
    FlagT ft_TcmFlag;
    int i, j, dummyByte;
    int16 s_numBearerChannel, s_DEFAULT_MAXNOMATP_DS;
    int32 l_temp = 0, l_temp_real, l_temp_imag;
    int16 s_shift;
    int16 s_majorVer;
    int16 s_minorVer;
    /*
    int16 s_bits, s_NumLoadedTones;
    int16 s_RxTotalDataBits;

*/
    if(gft_ModemType == G_DMT_BIS) ft_TcmFlag =  gft_TcmFlag_bis_DS;
    else ft_TcmFlag = gft_TcmFlag;

    // set DS MaxNomATP
    if (gl_SelectedMode & ANNEX_B)
    s_DEFAULT_MAXNOMATP_DS = DEFAULT_MAXNOMATP_DS_199;
    else
    s_DEFAULT_MAXNOMATP_DS = DEFAULT_MAXNOMATP_DS_204;

    /* load RxShowTimeVars with the pointer to the config structure  */
    //   gt_RxShowTimeVars.pt_Config = pt_config;

    gft_FrameMode = pt_config->s_FramingMode;
    STATArray[STAT_DMTFramingMode] = (STATArray[STAT_DMTFramingMode] & (~STAT_FramingModeMask)) | gft_FrameMode;


    gt_RxShowTimeVars.t_FrameParms[LP1_DATA_PATH].s_PathType = LP1_DATA_PATH;

    gt_RxShowTimeVars.t_FrameParms[LP0_DATA_PATH].s_PathType = LP0_DATA_PATH;
    //XDSLRTFW-1223 (Start-End)
#ifdef  PLL_ADAPTATION_SHOW
    gt_ReTxConfigInfo.us_ReTxConfigOptionBits |= (CMV_ENA_PLL_FIX_UNCORR_DTU);   /* Sriram : Disabled   */
#endif

#ifndef ISDN
    //XDSLRTFW-673: Enh_DS_ALL_ALL_ClkChg(start)
   gla_RxPilotSum[1] =0;
   gla_RxPilotSum[0] =0;
   gs_ClkCount1 = 0;
   gul_ClkCount2 = 0;
    if((gs_EstimatedLoopLength > 10000)&&
            (!TESTArray[Test_DisableShowClkAveraging])) {
        gs_ClkAvgFact = 32;
        gs_LogClkAvgFact = 5;
    } else {
        gs_ClkAvgFact = 0;
        gs_LogClkAvgFact = 0;
    }
    //XDSLRTFW-673: Enh_DS_ALL_ALL_ClkChg(end)
#endif
    for(i = 0; i < NUM_DATA_PATHS; i++) {
        gt_RxShowTimeVars.t_FrameParms[i].s_R = pt_config->s_Rp[i];
        gt_RxShowTimeVars.t_FrameParms[i].s_RawFrameSize = 0;

#ifdef DANUBE
        // If this CMV is set to TRUE then we skip the clearing of CRC counts, so that it can
        // be continous across retrains.
        if((gt_INFX_CMV.s_DFE_Options & TR69COUNTER_SUPPORT)  == 0)
        {
#endif
         //XDSLRTFW-508 Fix_DS_All_All_SuppressCounterWriteFromDSLAPI (Start)
         //Below 2 lines are commented out as enable/disable counter write-back is moved to CMV_ReMap and controlled by "DSL 19 0 Bit#0
            /* Set CRC error counts = 0; */
            //gusa_CRC_count[i] = 0; //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)
            //gsa_CorrectedRSErrors[i] = 0;  // # of corrected Reed-Solomon errors (not # of corrected codewords) in fast path since start of showtime.
         //XDSLRTFW-508 Fix_DS_All_All_SuppressCounterWriteFromDSLAPI (End)

            //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (Start End)
            gul_CRC_count_ReTx = 0;

#ifdef DANUBE
        }
#endif

        gusa_good_count[i] = 0; //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)

        /* Set RS error counts */
        // XDSLRTFW-575: Counter Write back in ADSL mode (Start)
        // gsa_UncorrectableRSCodewordCnt[i] = 0;  // # of uncorrectable Reed-Solomon codewords in fast path since start of showtime.
        // XDSLRTFW-575: Counter Write back in ADSL mode (End)
    }
    gs_CRCf_burst_count = 0;
    gs_CRCi_burst_count = 0;
    gs_RCRecovBurstCnt=0;


    for(i = 0; i < NUM_BEARER_CHANNELS; i++) {
        gt_RxShowTimeVars.t_BCParms[i].sa_BC_Bytes = 0;
        gt_RxShowTimeVars.t_BCParms[i].sa_BC_BytesIn = 0;
        gt_RxShowTimeVars.t_BCParms[i].sa_BC_LPath = -1;    // Undefined
        gt_RxShowTimeVars.t_BCParms[i].sa_BC_LSXASX = -1;      // Undefined
        gt_RxShowTimeVars.t_BCParms[i].sa_BC_CChan = FALSE;    // Not a C Channel
    }
    s_numBearerChannel = 0;   // Keeps track of mapping from ASx,LSx to BCx
    gus_numRxC_Channel = 0; // Keeps track of Rx 'C' Channels

    /* =========================================== */
    /*  Check if 16 kbps 'C' channel is enabled */
    /* =========================================== */
    if(gft_ModemType == G_DMT)
    {
        for(i = 0; i < NUM_DATA_PATHS; i++) {
            if (pt_config->sa_Bpn[i][DS_LS0_BEARER_CHANNEL] == 255) {
                gt_RxShowTimeVars.t_FrameParms[i].Ft_C_Chan_Enabled = TRUE;
                pt_config->sa_Bpn[i][DS_LS0_BEARER_CHANNEL] = 0;
                gt_RxShowTimeVars.t_BCParms[s_numBearerChannel].sa_BC_Bytes = 0;
                gt_RxShowTimeVars.t_BCParms[s_numBearerChannel].sa_BC_BytesIn = 0;
                gt_RxShowTimeVars.t_BCParms[s_numBearerChannel].sa_BC_LPath = i;
                gt_RxShowTimeVars.t_BCParms[s_numBearerChannel].sa_BC_LSXASX = DS_LS0_BEARER_CHANNEL;
                gt_RxShowTimeVars.t_BCParms[s_numBearerChannel].sa_BC_CChan = TRUE;
                gus_numRxC_Channel++;
                s_numBearerChannel++;
            } else {
                gt_RxShowTimeVars.t_FrameParms[i].Ft_C_Chan_Enabled = FALSE;
            }
        }

        /* =============================================================*/
        /*  Determine number of payload bytes from ASX Bearer channels  */
        /*  for both the fast and interleaved paths                  */
        /*  Also, Compute the number of bytes for bearer channel 0 and 1*/
        /* =============================================================*/
        gt_RxShowTimeVars.ft_BC1isAS1 = 0;
        for (i = 0; i < ASX_BEARER_CHANNELS; i++) {
            for(j = 0; j < NUM_DATA_PATHS; j++) {
                gt_RxShowTimeVars.t_FrameParms[j].s_RawFrameSize +=
                pt_config->sa_Bpn[j][i];
                gt_RxShowTimeVars.t_FrameParms[j].sa_B_alloc[i] =
                pt_config->sa_Bpn[j][i];
                gt_RxShowTimeVars.t_FrameParms[j].sa_B_in[i] = 0;
                if(pt_config->sa_Bpn[j][i]) {
                    if(s_numBearerChannel < NUM_BEARER_CHANNELS) {
                        if(i == DS_AS1_BEARER_CHANNEL) { /* AS1 Bearer Channel */
                            gt_RxShowTimeVars.ft_BC1isAS1 = 1;
                        }
                        gt_RxShowTimeVars.t_BCParms[s_numBearerChannel].sa_BC_Bytes = pt_config->sa_Bpn[j][i];
                        gt_RxShowTimeVars.t_BCParms[s_numBearerChannel].sa_BC_BytesIn = pt_config->sa_Bpn[j][i];
                        gt_RxShowTimeVars.t_BCParms[s_numBearerChannel].sa_BC_LPath =  j;
                        gt_RxShowTimeVars.t_BCParms[s_numBearerChannel].sa_BC_LSXASX = i;
                        s_numBearerChannel++;
                    } else {
                        //printf("More than %d bearer channels nota allowed\n", NUM_BEARER_CHANNELS);
                    }
                }
            }
        }

        /* =================================================================== */
        /*  Determine the number of AEX bytes in the fast and interleaved path */
        /* =================================================================== */
        for(i = 0; i < NUM_DATA_PATHS; i++) {
            if((gft_FrameMode == FULL_ASYNC) || (gft_FrameMode == FULL_SYNC)) {
                /*  in full overhead modes, there is one AEX if any ASX channels */
                /*  are enabled in the coressponding latency path */
                gt_RxShowTimeVars.t_FrameParms[i].s_A =
                ( (gt_RxShowTimeVars.t_FrameParms[i].s_RawFrameSize == 0) ? 0 : 1);
            } else {
                /*  in reduced overhead modes there are no AEX bytes */
                gt_RxShowTimeVars.t_FrameParms[i].s_A = 0;
            }
        }

        /* =============================================================*/
        /*  Add the number of payload bytes from LSX Bearer channels    */
        /*  for both the fast and interleaved paths to the respective   */
        /*  totals of payload bytes                            */
        /*  Also, Compute the number of bytes for bearer channel 0 and 1*/
        /* =============================================================*/
        for (i = ASX_BEARER_CHANNELS; i < NUM_DS_BEARER_CHANNELS; i++) {
            for(j = 0; j < NUM_DATA_PATHS; j++) {
                gt_RxShowTimeVars.t_FrameParms[j].s_RawFrameSize +=
                pt_config->sa_Bpn[j][i];
                gt_RxShowTimeVars.t_FrameParms[j].sa_B_alloc[i] =
                pt_config->sa_Bpn[j][i];
                gt_RxShowTimeVars.t_FrameParms[j].sa_B_in[i] = 0;

                if(pt_config->sa_Bpn[j][i]) {
                    if(s_numBearerChannel < NUM_BEARER_CHANNELS) {
                        gt_RxShowTimeVars.t_BCParms[s_numBearerChannel].sa_BC_Bytes = pt_config->sa_Bpn[j][i];
                        gt_RxShowTimeVars.t_BCParms[s_numBearerChannel].sa_BC_BytesIn = pt_config->sa_Bpn[j][i];
                        gt_RxShowTimeVars.t_BCParms[s_numBearerChannel].sa_BC_LPath =  j;
                        gt_RxShowTimeVars.t_BCParms[s_numBearerChannel].sa_BC_LSXASX = i;
                        s_numBearerChannel++;
                    } else {
                        //printf("More than %d bearer channels nota allowed\n", NUM_BEARER_CHANNELS);
                    }
                }
            }
        }

        /* =================================================================== */
        /*  Determine the number of LEX bytes in the fast and interleaved path */
        /* =================================================================== */
        for(i = 0; i < NUM_DATA_PATHS; i++) {
            if((gft_FrameMode == FULL_ASYNC) || (gft_FrameMode == FULL_SYNC)) {
                /*  in full overhead modes, there is one LEX if any ASX or LSX channels */
                /*  are enabled in the coressponding latency path */
                gt_RxShowTimeVars.t_FrameParms[i].s_L =
                ( (gt_RxShowTimeVars.t_FrameParms[i].s_RawFrameSize == 0) ? 0 : 1);

                /*  check if 'C' channel is enabled */
                if (gt_RxShowTimeVars.t_FrameParms[i].Ft_C_Chan_Enabled == TRUE) {
                    gt_RxShowTimeVars.t_FrameParms[i].s_L = 1;
                }
            }
            else {
                /*  in reduced overhead modes there are no LEX bytes */
                gt_RxShowTimeVars.t_FrameParms[i].s_L = 0;
            }
        }

        /* ===================================================================== */
        /*  Determine the Mux data frame size (payload + framing overhead) */
        /*  for the fast and interleaved paths */
        /* ===================================================================== */
        if (gft_FrameMode != REDUCED_MERGED) {
            for(i = 0; i < NUM_DATA_PATHS; i++) {
                gt_RxShowTimeVars.t_FrameParms[i].s_MuxFrameSize =
                gt_RxShowTimeVars.t_FrameParms[i].s_RawFrameSize +
                gt_RxShowTimeVars.t_FrameParms[i].s_A +
                gt_RxShowTimeVars.t_FrameParms[i].s_L + 1;
            }
        } else {
            if (gt_RxShowTimeVars.t_FrameParms[FAST_DATA_PATH].s_RawFrameSize != 0) {
                gt_RxShowTimeVars.t_FrameParms[FAST_DATA_PATH].s_MuxFrameSize =
                gt_RxShowTimeVars.t_FrameParms[FAST_DATA_PATH].s_RawFrameSize + 1;
                gt_RxShowTimeVars.t_FrameParms[INTERLEAVE_DATA_PATH].s_MuxFrameSize = 0;
            } else {
                gt_RxShowTimeVars.t_FrameParms[FAST_DATA_PATH].s_MuxFrameSize = 0;
                gt_RxShowTimeVars.t_FrameParms[INTERLEAVE_DATA_PATH].s_MuxFrameSize =
                gt_RxShowTimeVars.t_FrameParms[INTERLEAVE_DATA_PATH].s_RawFrameSize + 1;
            }
        }

        for(i = 0; i < NUM_DATA_PATHS; i++) {

            if(gt_rx_config.s_Mp[i] == S_HALF) {

                gs_MuxFrameSize_Half[i][0] =
                (gt_RxShowTimeVars.t_FrameParms[i].s_MuxFrameSize & 0x01) ?
                (gt_RxShowTimeVars.t_FrameParms[i].s_MuxFrameSize+1)>>1 :
                gt_RxShowTimeVars.t_FrameParms[i].s_MuxFrameSize >> 1;
                gs_MuxFrameSize_Half[i][1] =
                gt_RxShowTimeVars.t_FrameParms[i].s_MuxFrameSize - gs_MuxFrameSize_Half[i][0];
                gt_RxShowTimeVars.t_FrameParms[i].s_sHalfCodeWordSize[0] = gs_CodewordSize[i][0] =
                (gs_MuxFrameSize_Half[i][0] + gt_RxShowTimeVars.t_FrameParms[i].s_R);
                gt_RxShowTimeVars.t_FrameParms[i].s_sHalfCodeWordSize[1] = gs_CodewordSize[i][1] =
                (gs_MuxFrameSize_Half[i][1] + gt_RxShowTimeVars.t_FrameParms[i].s_R);
                gt_RxShowTimeVars.t_FrameParms[i].s_FecFrameSize =
                gs_CodewordSize[i][0] + gs_CodewordSize[i][1];

                /* ========================================================================== */
                /* Following assignment is to take care of the case having even size codeword */
                /* ========================================================================== */
                if( (gt_RxShowTimeVars.t_FrameParms[i].s_sHalfCodeWordSize[0] & 0x1) &&
                        (gt_RxShowTimeVars.t_FrameParms[i].s_sHalfCodeWordSize[1] & 0x1) ) {
                    gt_RxShowTimeVars.t_FrameParms[i].s_sHalfCntl = 0;  /* Odd - Odd   */
                } else if( (gt_RxShowTimeVars.t_FrameParms[i].s_sHalfCodeWordSize[0] & 0x1) &&
                        !(gt_RxShowTimeVars.t_FrameParms[i].s_sHalfCodeWordSize[1] & 0x1) ) {
                    gt_RxShowTimeVars.t_FrameParms[i].s_sHalfCntl = 1;  /* Odd - Even  */
                } else if(  !(gt_RxShowTimeVars.t_FrameParms[i].s_sHalfCodeWordSize[0] & 0x1) &&
                        (gt_RxShowTimeVars.t_FrameParms[i].s_sHalfCodeWordSize[1] & 0x1) ) {
                    gt_RxShowTimeVars.t_FrameParms[i].s_sHalfCntl = 2;  /* Even - Odd  */
                } else {
                    gt_RxShowTimeVars.t_FrameParms[i].s_sHalfCntl = 3;  /* Even - Even    */
                }
                gt_RxShowTimeVars.t_FrameParms[i].s_CodewordSize =
                gt_RxShowTimeVars.t_FrameParms[i].s_sHalfCodeWordSize[0];
                gt_RxShowTimeVars.t_FrameParms[i].s_CodewordSize_Odd =
                gt_RxShowTimeVars.t_FrameParms[i].s_sHalfCodeWordSize[0] +
                (gt_RxShowTimeVars.t_FrameParms[i].s_sHalfCntl > 1);

            } else {

                gt_RxShowTimeVars.t_FrameParms[i].s_CodewordSize =
                (gt_RxShowTimeVars.t_FrameParms[i].s_MuxFrameSize *
                pt_config->s_Mp[i]) +
                pt_config->s_Rp[i];
                gt_RxShowTimeVars.t_FrameParms[i].s_FecFrameSize =
                gt_RxShowTimeVars.t_FrameParms[i].s_CodewordSize / pt_config->s_Mp[i];
                /* ========================================================================== */
                /* Following assignment is to take care of the case having even size codeword */
                /* ========================================================================== */
                if(gt_RxShowTimeVars.t_FrameParms[i].s_CodewordSize&0x1)
                dummyByte = 0;
                else
                dummyByte = 1;
                gt_RxShowTimeVars.t_FrameParms[i].s_CodewordSize_Odd = gt_RxShowTimeVars.t_FrameParms[i].s_CodewordSize + dummyByte;
            }
        }

        /* ========================================================================== */
        /* Set the Data Rate managment variables in units of bits/sec         */
        /* ========================================================================== */
        for(i = 0; i < NUM_DATA_PATHS; i++) {
            gla_DSDataRate[i] = (gt_RxShowTimeVars.t_FrameParms[i].s_RawFrameSize)*32000;
        }
#ifdef HERCULES_ADSL_CPE
        gul_RxIbInfo = 0x00FF3FFF ;    // Initialize to all good, other than NCD-i,NCD-f
#endif

    } /* if(gft_ModemType == G_DMT) */
    else if (gft_ModemType == G_DMT_BIS)
    {
        for (i = 0; i < NUM_BEARER_CHANNELS; i++)
        {

            j = guca_rxBCnToLPp[i];


            if (j != DISABLED_LP)
            {
                // If we have valid latency path associated with the bearer channel
                gt_RxShowTimeVars.t_FrameParms[j].s_RawFrameSize +=
                pt_config->sa_Bpn[j][i];
                gt_RxShowTimeVars.t_FrameParms[j].sa_B_alloc[i] =
                pt_config->sa_Bpn[j][i];
                gt_RxShowTimeVars.t_FrameParms[j].sa_B_in[i] = 0;

                gt_RxShowTimeVars.t_BCParms[i].sa_BC_Bytes = pt_config->sa_Bpn[j][i];
                gt_RxShowTimeVars.t_BCParms[i].sa_BC_BytesIn = pt_config->sa_Bpn[j][i];
                gt_RxShowTimeVars.t_BCParms[i].sa_BC_LPath =   j;
                gt_RxShowTimeVars.t_BCParms[i].sa_BC_LSXASX = i;
            }

        }

        /* ========================================================================= */
        /* Verify if codeword size < 256 (BIS Showtime,OLR Only)*/
        /* Also computes parameters for Rx framer block configuration */
        /* ========================================================================= */

        if(gs_InitFailCauseNearEnd == 0)
        VerifyAndUpdateRxFramerParameters();
      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
      if (gt_ReTxConfigInfo.ft_ReTxOn == 1)
      {
         pt_config->s_IBITSlp = LP0_DATA_PATH;
      }
      else
      {
      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
         pt_config->s_IBITSlp = ComputePathWithSmallestLatency(pt_config);
      } //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START_END)

        for(i=0; i< NUM_DATA_PATHS; i++)
        {
            // For faster Rx Data Pump processing -- ZA Run Count Mechanism
            gsa_RxMuxFrameCount[i] = 0;
            /* if next mux frame cnt = mux frames/codeword - 1 */
            if (gsa_RxMuxFrameCount[i] == (gt_rx_config.s_Mp[i]-1))
            {
                gusa_PreconfigIRSize[i] = gsa_RxMuxFrameSize[i][1];
                gsa_RxMuxFrameCount[i] = 0;
            }
            else
            {
                gusa_PreconfigIRSize[i] = gsa_RxMuxFrameSize[i][0];
                gsa_RxMuxFrameCount[i]++;
            }
            gusa_PreconfigACfg[i] = 0;
            if(guca_rxBCnToLPp[0] == i)
            {
                gusa_PreconfigACfg[i] |= (1<<13);
            }
            if(guca_rxBCnToLPp[1] == i)
            {
                gusa_PreconfigACfg[i] |= (1<<11);
            }

            /* ===================================================================== */
            /*  Determine SEQp                              */
            /* ===================================================================== */
            gsa_rx_SEQp[i] = ComputeSEQ((int16) i,pt_config);

            CheckForBpnReconfig(gt_RxShowTimeVars.t_FrameParms[i].s_CodewordSize,
            gt_rx_config.s_Lp[i],
            gt_rx_config.s_Rp[i],
            gt_rx_config.s_Dp[i],
            &(gft_RxBpnReconfigAllowed[i]));

        }


    } /*    else if (gft_ModemType == G_DMT_BIS)  */

    if(gft_ModemType == G_DMT)
    {
        gft_BitSwapPerform = 0;     //Flag indicate the Bkgd PerformRxBitSwap status

        for(i=0; i< NUM_DATA_PATHS; i++)
        gt_rx_config.s_Lp[i] = (gt_RxShowTimeVars.t_FrameParms[i].s_FecFrameSize << 3); /* Lp is in bits and not bytes */

#ifdef HERCULES_ADSL_CPE
        // set IBITSlp (this should be revisited)
        if (pt_config->s_Lp[FAST_DATA_PATH] > 0)
        pt_config->s_IBITSlp = FAST_DATA_PATH;
        else
        pt_config->s_IBITSlp = INTERLEAVE_DATA_PATH;
#endif // HERCULES_ADSL_CPE
    }

    // Indicate DS active LP(7:0) and BC(15:8) in cmv
    for (i = 0; i < NUM_BEARER_CHANNELS; i++)
    {
        j = gt_RxShowTimeVars.t_BCParms[i].sa_BC_LPath;
        if (j != -1)
        STATArray[STAT_ACTIVEBCLP_DS] |= (1<<j) | ((1<<i)<<8);
    }

    // get derived frame properties
    for (j = 0; j < NUM_DATA_PATHS; j++)
    {
        int32 l_latency, l_INP;
        int16 s_latency, s_INP, s_Lp;

        // latency  ceil(S*D) (units are ms*4) in Q14.2
        l_latency= (int32)(gt_RxShowTimeVars.t_FrameParms[j].s_CodewordSize * pt_config->s_Dp[j])<<3;
        s_Lp = pt_config->s_Lp[j];
        s_latency = 0;
        //ADSLRTFW-1689: BugFix_DS_All_All_IncorrectIntlDelayReported (Start)
        if (s_Lp == 1) {
           s_latency = (int16)l_latency;
        } else if (s_Lp == 0) {
           //Set delay to ZERO for Latency path that is not used. SW API sums up both LP0 and LP1 values
           //and the result is displayed. SW API expects only one of them to have non-zero value.
           s_latency = 0; //(int16)0xFFFF;
        } else {
           while (l_latency >= s_Lp) {
               l_latency -= (int32)s_Lp;
               s_latency++;
           }
           if (l_latency != 0)
           s_latency++;
        }
        //ADSLRTFW-1689: BugFix_DS_All_All_IncorrectIntlDelayReported (End)
        gt_DerivedFrameProperties_DS.PropPerLp[j].s_Latency = s_latency;
        /**************************************************************************************
                INP is impulse noise protection = (1/2) (S*D) (R/CWSize),  Actual INP (*10)
        ***************************************************************************************/
        if( (s_Lp!= 0) && (gl_SelectedMode & MODE_ADSL2) )
        {
            l_INP = (int32)((pt_config->s_Dp[j] * pt_config->s_Rp[j])*400);
            s_INP = (int16)(l_INP/s_Lp+5)/10;
        }
        else
        s_INP=0;

        gt_DerivedFrameProperties_DS.PropPerLp[j].s_INP = s_INP;
      //XDSLRTFW-543:BugFix_BisPlus_DS_ALL_IntlvDelay (start)
#ifdef HERC_API
      gt_DerivedFrameProperties_DS.PropPerLp[j].s_Kp    = pt_config->sa_Bpn[j][0] + pt_config->sa_Bpn[j][1] + 1;
#endif
         //XDSLRTFW-543:BugFix_BisPlus_DS_ALL_IntlvDelay (end)
    }


    /* ========================================================================= */
    /* Verify if frame size matches to bit allocation table (DMT/BIS Showtime,OLR,L2)*/
    /* Also computes parameters for Rx QAM/TCM block configuration*/
    /* ========================================================================= */
    VerifyAndUpdateRxQAMParameters();

    if (gft_BitloadOK == FAIL)
    {
        // set Exception code
        gus_ExceptionCode = E_CODE_BAT_RX;
        gs_InitFailCauseNearEnd = 2;
    }

    /* ========================================================================= */
    // Below AnnexC code commented out since it wasnt serving any purpose and was
    // causing hindrance in forming the above generic function
    // VerifyAndUpdateRxQAMParameters() which works with DMT, BIS, OLR, L2
    // Function can be updated later when we figure out what purpose below code
    // needs ro serve
    /* ========================================================================= */
    /*

*/

    /* Compute the decoder combined gains from the dB fine gains */
    CalcDecodGain(guca_RxBat, gsa_RxFineGains, gsa_RxCombinedGains, 0, gs_RxNumTones, FALSE, NULL);


    if (!(OPTNArray[OPTN_PwrManControl] & OPTN_ExMarginRedDisable))
    {
        /* Take care of Fine gain reduction in FDQ. */
        for(j = gs_RxBitLoadFirstChannel; j <= gs_RxBitLoadLastChannel; j++)
        {
            // Perf_DS_ALL_ALL_Pll_NoExMarginReduction (START)
            // Skip Pilot Tone
            if ((j == gs_CPilotTone) || (j == gs_AuxPilotToneIdx))
                continue;
            // Perf_DS_ALL_ALL_Pll_NoExMarginReduction (END)

            // right shift because gs_ExcessMarFDQBoost value is in 3.13 format
            l_temp_real = ((int32)gsa_pre_FDQ_coef[2*j] * gs_ExcessMarFDQBoost) >> 13;
            l_temp_imag = ((int32)gsa_pre_FDQ_coef[2*j+1] * gs_ExcessMarFDQBoost) >> 13;

            // determine if the result is representable in the FDQ_Mantissa_wordlength; else shift more
            RightNormalizeSignedPair(&l_temp_real, &l_temp_imag, FDQ_MANTISSA_WORDLENGTH, &s_shift);

            s_shift += (int16)guca_pre_FDQ_exp[j];
            if (s_shift < 0)
            {
                /* If negative, force to zero and shift mantissas accordingly. */
                l_temp_real >>= -s_shift;
                l_temp_imag >>= -s_shift;
                s_shift = 0;
            }
            else if (s_shift > FDQ_EXPONENT_MAX)
            {
                /* Saturate if necessary. */
                s_shift = FDQ_EXPONENT_MAX;
            }

            gsa_pre_FDQ_coef[2*j] = (int16) l_temp_real;
            gsa_pre_FDQ_coef[2*j+1] = (int16) l_temp_imag;
            guca_pre_FDQ_exp[j] = (uint8) s_shift;
        }
    }

    if (( gl_SelectedMode & (MODE_ADSL2)  ))
    {
        int idx, s_RxFineGain;
        int16 jlast ;

        /* Recalculate fine gains in linear format using combined gains and bat table */
        /* we use the calcdecodgain function but interchange the calling function arguments such that */
        /* input is bat table and combined gains and output is fine gains */
        // The loss of precision in calculating these fine gains from combined gains instead of
        // directly from dB gains is insignificant (~1 LSB max).
        CalcDecodGain(guca_RxBat, gsa_RxCombinedGains, (int16 *)gsa_TempRxFineGains, 0, gs_RxNumTones, TRUE, NULL);

        // Format and copy fine gains into R-PARAMS message buffer.
        idx = 14;

        //********************************************************//
        // Determine if we need to transmit -12dB on unused tones //
        //  geminax 7.11 or 7.12 in 5B mode.
        s_majorVer = ((gs_CurrentCoVendorID>>12)&0xf);
        s_minorVer = ((gs_CurrentCoVendorID>>4)&0xff);


        gft_xmitAllTones = 0 ;
        jlast = gs_RxNumTones-1;
        // geminax 7.11 or 7.12
        if ((gs_CurrentCoChipset == IFTN_CO_CHIPSET )
                    && ( s_majorVer == 0x7 )
                    && ( s_minorVer == 0x11 || s_minorVer == 0x12)
                    && ( gl_SelectedMode & (MODE_G992_5) )  // plus mode
                    )
        {
            gft_xmitAllTones = 1;

            // find last tone used, including monitored tones.
            for (j = gs_RxNumTones-1; j > gs_RxFirstChannel; j--) {
                if  (gsa_TempRxFineGains[j] > 0) {
                    jlast = j;
                    break;
                }
            } //for

        }
        //*************************************************************//
        for(j=1; j< gs_RxNumTones; j++)
        { // start from tone 1 to 255


            s_RxFineGain = gsa_TempRxFineGains[j];
            if (!(OPTNArray[OPTN_PwrManControl] & OPTN_ExMarginRedDisable))
            {
                // Perf_DS_ALL_ALL_Pll_NoExMarginReduction (START)
                //Skip Pilot Tone
                if (j != gs_CPilotTone)
                {
                    /* Reduce fine gains if excess margin reduction is on. */
                    s_RxFineGain =
                    (int16) (((int32) s_RxFineGain *
                    gt_FineGainInfo.s_ExcessMarFGReduction) >> 13);
                }
                // Perf_DS_ALL_ALL_Pll_NoExMarginReduction (END)
            }

            if ( (j > jlast) && gft_xmitAllTones )
            {
                if (IS_TONEFLAGSET(p_MEDLEYset_DS,j) )
                s_RxFineGain = 0x800;  // 1/4 = -12dB for additional monitored tones.
            }
            guca_R_PARAMS_bis[idx++] = (uint8)(((s_RxFineGain + 0x8) & 0xF0) | (guca_RxBat[j] & 0x0F));
            guca_R_PARAMS_bis[idx++] = (uint8)(s_RxFineGain>>8);

        }
#ifndef TARGET_HW
        if (TESTArray[TEST_InitState] == TEST_GhsInitState) {
#endif
            //Compute NOMATPds here while fine gains still in linear format
            gt_TxPMDControl.s_NOMATP_DS = CalcNOMATP(gt_TxPMDControl.s_NOMPSD_DS,(int16)DEFAULT_NOMPSD_DS,s_DEFAULT_MAXNOMATP_DS,gsa_TempRxFineGains,gt_FineGainInfo.s_ExcessMarFGReduction,gusa_DS_Tssi_Value,p_MEDLEYset_DS,gs_RxNumTones, &(gt_TxPMDControl.s_NOMPSD_DS_dBmHz));
            //XDSLRTFW-543:BugFix_BisPlus_DS_ALL_IntlvDelay (start)
            // Copied from Vinax Ref
            // Actual PSD computation
            // ActPSD = RefPSD + RMSGI
            gt_NearEndParam.s_ActualPSD =  gt_TxPMDControl.s_NOMPSD_DS_dBmHz - gt_TxPMDControl.us_pwr_cutback_DS*10 + ((gt_TxPMDControl.us_RMSGI_DS * 10 + (1<<7))>>8) ;
            if (gt_NearEndParam.s_ActualPSD < OUT_OF_RANGE_ACTPSD) gt_NearEndParam.s_ActualPSD = OUT_OF_RANGE_ACTPSD;
            //XDSLRTFW-543:BugFix_BisPlus_DS_ALL_IntlvDelay (end)


#ifndef TARGET_HW
        }
#endif

    }

    else // g.992.1, g.992.2
    {
        int16 s_RMSFineGaindB_all ;

        // compute rms fine gain
        l_temp = (int32) ComputeRMSFineGain(gt_rx_config.psa_BAT, gt_rx_config.psa_FineGains, gs_RxNumTones, gs_CurrentCoChipset, 0, 0);

        // RMS fine Gain according to spec for sync symbol scaling
        gt_TxPMDControl.us_RMSGI_DS = 2* (ConvertToDB(l_temp)  -  ConvertToDB(8192));

        // Now over all tones (including the US band too, since the DEFAULT_MAXNOMATP_DS assumes whole band) for total Rx power
        l_temp = (int32) ComputeRMSFineGain(gt_rx_config.psa_BAT, gt_rx_config.psa_FineGains, gs_RxNumTones, gs_CurrentCoChipset, 0, 1);
        s_RMSFineGaindB_all = 2* (ConvertToDB(l_temp)  -  ConvertToDB(8192));

        if (!(OPTNArray[OPTN_PwrManControl] & OPTN_ExMarginRedDisable))
        {

            gt_TxPMDControl.us_RMSGI_DS  -= gt_FineGainInfo.s_ExcessMarRedDB;

            // Modify the average fine gain value
            gs_RxAvFineGain -= gt_FineGainInfo.s_ExcessMarRedDB;
            s_RMSFineGaindB_all -= gt_FineGainInfo.s_ExcessMarRedDB;
        }

        gt_TxPMDControl.s_NOMATP_DS = (s_RMSFineGaindB_all*10>>8);
    }

#ifndef TARGET_HW
    if (TESTArray[TEST_InitState] == TEST_GhsInitState)
    {
#endif
        // Compute Far-end Actual Aggregate Transmit Power (ACTATP) for R-PARAMS
        gt_NearEndParam.s_ActualAggregateXmtPwr = CalcACTATP(gt_TxPMDControl.s_NOMATP_DS, s_DEFAULT_MAXNOMATP_DS);
        if (gl_SelectedMode & (MODE_ADSL2))
        {
            gs_DS_ACTATP_L0 = gt_NearEndParam.s_ActualAggregateXmtPwr;
            guc_ACTATP_LSB = (uint8)(gs_DS_ACTATP_L0 & 0xFF);
            guc_ACTATP_MSB = (uint8)((gs_DS_ACTATP_L0 >> 8) & 0xFF);  //include sign bit extention
        }
        gt_NearEndParam.us_SignalAttenuation = SignalAttenu_BIS(gsa_RxHlogDS,gt_StateMachCntrl.psa_RXSNRBuf,gsa_RxFineGains, (int16)(gt_TxPMDControl.s_NOMATP_DS + s_DEFAULT_MAXNOMATP_DS));

#ifndef TARGET_HW
    }
#endif

    if(!gft_doDDSnrFdqUpdate)
    {
        //Need this only for Cocomo SWEngine since it doesnt use DD Snr/Fdq
        GenShowtimeCReverbRef(l_temp, gsa_TempRxFineGains);
    }




    /* Perform tone ordering if we're running G992_1 */
    if (!(STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_AB)) {
        // Create a tone ordering table
        if ( (( gl_SelectedMode & (MODE_ADSL2)  )) && (TESTArray[TEST_InitState] != TEST_ShowtimeInitState) )
        RxToneOrderingBis(gt_rx_config.psa_BAT, gs_RxNumTones, (int16)gus_ncloaded, gus_Rx_Tcm_Num1bits, gsa_RxToneOrder);
        else
        ToneOrdering(gt_rx_config.psa_BAT, gs_RxNumTones, (int16)guc_MaxAllocBitsPerTone, gsa_RxToneOrder);
        gs_FirstNonzeroRxTone = gs_FirstNonzeroTone;     /* gs_FirstNonzeroTone is set by ToneOrdering() */

    } // if (!(STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_AB))
    else
    {

        for(i=0;i<gs_RxNumTones;i++) {
            gsa_RxToneOrder[i]=i;
        }

    }

    /* Initialize the synch byte handler */
    RxSyncByteHandlerInit();

    gs_NumAttenuationSymbols = 0;   /* symbol count for line attenuation calculation */

    //ATM Byte Flip control
    if (OPTNArray[OPTN_ATMAddrConfig] & OPTN_ATM_BYTEFLIP_ENABLE) //Force byte flip on
    gft_disableAlphaeusRxByteFlip =0;   //BYTE_FLIP (0: enable)
    else if (OPTNArray[OPTN_ATMAddrConfig] & OPTN_ATM_BYTEFLIP_DISABLE) //Force byte flip off
    gft_disableAlphaeusRxByteFlip= 1;   //BYTE_FLIP (1: disable)

    //XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)
    #ifdef HW_SNR_FDQ
    gsa_pilot_FDQ_coef[0] = gsa_pre_FDQ_coef[gs_PilotToneIdx*2];
    gsa_pilot_FDQ_coef[1] = gsa_pre_FDQ_coef[gs_PilotToneIdx*2+1];
    guc_pilot_FDQ_exp = guca_pre_FDQ_exp[gs_PilotToneIdx];
    #endif
    //XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (END)

    // Feature_ALL_ALL_ALL_PrevExceptionsCMV (Start)
    // Once the modem is in Showtime, these vairables need to be
    // initialized again, since the last initialization
    gus_ExceptionCode_Persis = gus_ExceptionCode;
    gus_ExceptionState_Persis = gus_ExceptionState;
    // Feature_ALL_ALL_ALL_PrevExceptionsCMV (End)
}

/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*       void InitRxConfigFromProfile(void);
*
*   Abstract:
*       Loads configuration from the profile in fast retrain.
*
*   Input Parameters:
*     none
*
*  Return: None
*
*  Global Variables:
*     gt_rx_config   -- (O) RX configuration structure
*     gft_RxInFastRetrain_flag -- (O) Fast Retrain flag
*     gta_RxProfile  -- (I) RxProfiles
*-----------------------------------------------------------------------------
^^^*/
void InitRxConfigFromProfile(void)
{
#ifdef INCLUDE_FASTRETRAIN_CODE
    gt_rx_config.sa_Bpn[LP0_DATA_PATH][0] =
    ( (gta_RXProfile[gs_DS_Profile].s_ReqdBits >> 3) -
    gta_RXProfile[gs_DS_Profile].s_R - 1);
    if(gta_RXProfile[gs_DS_Profile].s_S == S_HALF) {
        gt_rx_config.s_Rp[LP0_DATA_PATH] = gta_RXProfile[gs_DS_Profile].s_R;
    } else {
        gt_rx_config.s_Rp[LP0_DATA_PATH] = gta_RXProfile[gs_DS_Profile].s_R *
        gta_RXProfile[gs_DS_Profile].s_S;
    }
    gt_rx_config.s_Mp[LP0_DATA_PATH] = gta_RXProfile[gs_DS_Profile].s_S;
    gt_rx_config.s_Dp[LP0_DATA_PATH] = gta_RXProfile[gs_DS_Profile].s_D;
    gft_FrameMode = REDUCED_MERGED;
    gft_RxInFastRetrain_flag = FALSE;
#endif
}


/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*       void InitNonDMTMembersRx(void);
*
*   Abstract:
*       Initialize non G.DMT members of Rx Config structure.
*
*   Input Parameters:
*     none
*
*  Return: None
*
*  Global Variables:
*     gt_rx_config   -- (O) TX configuration structure
*-----------------------------------------------------------------------------
^^^*/
void InitNonDMTMembersRx(void)
{
    gt_rx_config.s_Mp[LP1_DATA_PATH] = 1;

    gt_rx_config.s_Tp[LP1_DATA_PATH] = 1;
    gt_rx_config.s_Tp[LP0_DATA_PATH] = 1;

    gt_rx_config.s_Dp[LP1_DATA_PATH] = 1;

    gt_rx_config.s_MSGc = 62;
}


/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*       void InitShowTimeRx(void);
*
*   Abstract:
*       Perform initialization for running showtime RX. This function forms
*  configuration structure and then call RxInit().
*
*   Input Parameters:
*     none
*
*  Return:
*     none
*
*  Global Variables:
*     gs_US_RateOption -- (I) selected downstream rate option
*     gsa_RxBat[]    -- (I) TX bit allocation table
*-----------------------------------------------------------------------------
^^^*/
void InitShowTimeRx(void)
{

    int16 i = 0, j;
    int16 s_Margin = 0;
    //XDSLRTFW-543:BugFix_BisPlus_DS_ALL_IntlvDelay (start_end)
   int16 s_Sp_denum, s_Sp_exp;


    /* Initialize non G.DMT members of Rx Config structure */
    if(gft_ModemType == G_DMT)
    {
        InitNonDMTMembersRx();
        gs_rx_framecnt = 0;   /* counter used in RxDataPumpMisc */
        gs_MuxFrameCntRxFastPath = RX_SYMBOLS_PER_SFRAME;
        //ChihWen: VRX518 DMT AnxB bring up (START_END)
        //_RxOLRPMVars.uc_rxOLRPMState = L0_STEADY_STATE;
    }
    /* Initialize OLR and PM state variables of G.BIS */
    else
    {
#ifndef TARGET_HW
        gt_RxOLRPMVars.uc_rxOLRPMState = L0_STEADY_STATE;
#else
        gt_RxOLRPMVars.uc_rxOLRPMState = STATE_NOT_DEFINED;
#endif
        gt_RxOLRPMVars.uc_l2ProcState = PM_L0_STATE;
        gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL0Symbols = gt_TxPMDControl.us_pwr_cutback_DS;
        gt_RxOLRPMVars.t_L2PowerCutBack.s_L2FdqGaindB = 0;

        gs_RxPMDFrameCnt = RX_SYMBOLS_PER_SFRAME;
    }
    //XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(start)
   //Initialize previous avg and min margin to target margin
   gs_RxPrevAvgMargin = gs_RxDesiredMargin;

   for(i=0; i < 32; i++) {
      gsa_dsPrevSNRMargnPerBand[i] = gs_RxDesiredMargin;
      gsa_dsPresentSNRMargnPerBand[i] = gs_RxDesiredMargin;
   }
   gs_OlrReq=0;
      //XDSLRTFW-686: PERF_DS_DMT_ALL_Bitswap(start)
   if(gft_ModemType == G_DMT) {
      memcpy(gpsa_TempSnrBuff, gsa_MedleySnrBuf, 256*2);
      gft_BitswapAlgoExcecutionInProgress = 0;
      gft_InvalidSNR = 1;
        gft_InterimStrdSNRBitswapOn = 0;
   }
   //XDSLRTFW-686: PERF_DS_DMT_ALL_Bitswap(end)
    //XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(end)

    gs_RxSyncToneType   = C_REVERB;
    gs_RxPMDFrameCnt_FftFdqBufferSymbol = RX_SYMBOLS_PER_SFRAME;

    /*  flag to set intial buffer sizes for showtime RX */
    gft_ShowTimeFirstPassRx = FALSE;
   /* XDSLRTFW-2464 */
//#ifdef ISDN
   for(i=0; i < SIZE_PLL_FREQ_OFFSET_BUFFER; i++)
    {
       gla_pll_freq_offset[i] = gl_pll_freq_offset;
    }
//#endif
   /* XDSLRTFW-2464 */
    gul_TotalRxDataFrameCnt = 0;

    gus_ShowtimeSNRUpdateCount = 0;    // Indicates number of SNR updates performed since entering showtime
    gus_ShowtimeFDQUpdateCount = 0;    // Indicates number of FDQ updates performed since entering showtime
    gus_ShowtimeDECUpdateCount = 0;     // Indicates number of DEC updates performed since entering showtime

    /* =================================================================== */
    /*  initialize FDQ adapt input structure  */
    /* =================================================================== */
    gt_FdqAdaptInput.psa_rcvbuf = gsa_RxShowtimeFDQRepBuf;
    gt_FdqAdaptInput.psa_refbuf = gsa_CReverbRefTones;
    gt_FdqAdaptInput.psa_FDQ_coef = gsa_pre_FDQ_coef;
    gt_FdqAdaptInput.psa_FDQ_exp = guca_pre_FDQ_exp;
    gt_FdqAdaptInput.s_CurrChannel = gs_RxFirstChannel;



    gft_ShowtimeSnrUpdateFlag = FALSE; /* If = TRUE-> SNR has been recomputed, else not updated */
    guc_FdqAdaptationState = FDQ_ADAPTATION_DISABLE;     /*  disable FDQ adaption for now */

    guc_ShowtimeSnrCalcState = SHOWTIME_SNR_CALC_DISABLE;      /*  disable SNR calculation for now */

    /* initialize showtime SNR with medley SNR */
    memcpy(gsa_RxShowtimeSnrBuf, gsa_MedleySnrBuf,gs_RxNumTones * sizeof(int16));

    //#ifdef AMAZON_SE
    /* initialize the showtime pilot signal-to-noise-and-impulse threshold for DDsnrfdq*/
    /* we try to pick the tone close to the pilot but try to avoid the PARR tones */
    if (gsa_MedleySnrBuf[gs_PilotToneIdx -1] > 0 && guca_RxBat[gs_PilotToneIdx -1] >0)
    gs_pilot_snir_threshold = gsa_MedleySnrBuf[gs_PilotToneIdx -1] - gs_DD_imp_pwr_allowed*256;
    else if (gsa_MedleySnrBuf[gs_PilotToneIdx +1] > 0 && guca_RxBat[gs_PilotToneIdx +1] >0)
    gs_pilot_snir_threshold = gsa_MedleySnrBuf[gs_PilotToneIdx +1] - gs_DD_imp_pwr_allowed*256;
    else
    gs_pilot_snir_threshold = gsa_MedleySnrBuf[gs_PilotToneIdx -2] - gs_DD_imp_pwr_allowed*256;
    //#endif
    gs_pilot_STsnr_avg = 0; //SMS00838915:DS_PERF_ALL_PllSnrThresshold (START END)
    /*  clear SNR's array of unused tones */
    MemSetBuffer(gsa_RxShowtimeSnrBuf, 0, 0, (int16)(sizeof(int16)*(gs_RxFirstChannel)));
    MemSetBuffer(gsa_RxShowtimeSnrBuf, (int16)(gs_RxLastChannel+1), 0, (int16)(sizeof(int16)*(gs_RxNumTones - 1 - gs_RxLastChannel)));

   //XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (Start)
    MemSetBuffer((int16 *)(void *)guca_TimeVaryNoise_Ind_sav, 0, 0, sizeof(RxToneFlags));
    gft_TonesWithStrongNoise = FALSE;
   gs_BITSWAP_TRIGGER = 0; //0dB
   //XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (End)

    /* Data Directed (DD) Snr/Fdq Updates - Initilaize Variables */
    if(gft_doDDSnrFdqUpdate)
    {
#ifdef AMAZON_SE
        // Limit this to 16 as part of workaround for RTV DMA issue.
        gs_DD_MaxRxChannelsPerSymbol = 16;
#else
      //BugFix_DS_ADSL1_ALL_SuddenRFI (START)
      if (( gl_SelectedMode & (MODE_ADSL2)  ))
      {
         gs_DD_MaxRxChannelsPerSymbol = 32;
         gs_DD_RxChannelsPerSymbol = 32;
      }
      else
      {
         //ADSL1 mode increased the no of channels to 48 to reduce the time involved in FDQ adaptation
         //and SNR update process to do the Bitswap faster. This is required to avoid link drop
         //due to DS CRC while applying RFI.
         gs_DD_MaxRxChannelsPerSymbol = 48;
         gs_DD_RxChannelsPerSymbol = 48;
      }
      //BugFix_DS_ADSL1_ALL_SuddenRFI (END)

      // XDSLRTFW-358 Enh_DS_BisPlus_CNXT_StressTest (start)
      //Increase number of frames used for SNR averaging from 512 to 2048.
      // To compensate for the increase in number of frames, block size used in FDQ updates and SNR updates
      // are increased from 32 to 48 tones. Due to lack of memeory it is not increased to the required
      // size of 96 tones.
      // Also as per John, the Zepyhr in VR9 works on N Bytes per Go strobe- processing as many codewords as necessary.
      // So ARC mips shouldnot change much based on 1/s.
      if ((gs_CurrentCoChipset == GSI_CO_CHIPSET)&&
          (gt_INFX_CMV.us_OperatorSpBits6 & CMV_TO_ENABLE_EXTRA_Log2NumShowtimeSNRTrainingSymbols)
         )
      {
         gs_DD_MaxRxChannelsPerSymbol = 48;
         gs_DD_RxChannelsPerSymbol = 48;
      }
      // XDSLRTFW-358 Enh_DS_BisPlus_CNXT_StressTest (end)

#endif
      gs_DD_RxFirstChannel = gs_RxFirstChannel; //Assure that gs_RxFirstChannel is initialized earlier
        gs_DD_RxLastChannel  = gs_DD_RxFirstChannel + gs_DD_RxChannelsPerSymbol - 1;
    }
    guc_ddProcState = DD_PROC_DISABLE;

    /* parameters used for LOS and SEF detection during showtime */
    //gs_LosDefect_state_cnt = 0;  //Not required

    guc_LOSDetectState = LOS_DETECT_DISABLED;

    guc_SEFDetectState  = SEF_DETECT_DISABLED;

    if (TESTArray[TEST_InitState] != TEST_ShowtimeInitState) {
        switch(gft_ModemType) {

        case G_DMT:


#ifdef INCLUDE_FASTRETRAIN_CODE
            if (gft_RxInFastRetrain_flag == FALSE) {/*  full initialization */
#endif

                for (i = 0; i < NUM_DS_BEARER_CHANNELS; i++) {
                    gt_rx_config.sa_Bpn[LP1_DATA_PATH][i] = (int16) gta_DS_options[gs_DS_RateOption].pus_ReqBytes[LP1_DATA_PATH*NUM_DS_BEARER_CHANNELS + i];
                    gt_rx_config.sa_Bpn[LP0_DATA_PATH][i] = (int16) gta_DS_options[gs_DS_RateOption].pus_ReqBytes[LP0_DATA_PATH*NUM_DS_BEARER_CHANNELS + i];
                }
                gt_rx_config.s_Rp[LP1_DATA_PATH] = gta_DS_options[gs_DS_RateOption].puc_CheckBytes[LP1_DATA_PATH];

                if(gta_DS_options[gs_DS_RateOption].uc_S == S_HALF) {
                    gt_rx_config.s_Rp[LP0_DATA_PATH] = gta_DS_options[gs_DS_RateOption].puc_CheckBytes[LP0_DATA_PATH];
                } else {
                    gt_rx_config.s_Rp[LP0_DATA_PATH] = gta_DS_options[gs_DS_RateOption].puc_CheckBytes[LP0_DATA_PATH] *
                    gta_DS_options[gs_DS_RateOption].uc_S;
                }
                gt_rx_config.s_Mp[LP0_DATA_PATH]  = gta_DS_options[gs_DS_RateOption].uc_S;
                gt_rx_config.s_Dp[LP0_DATA_PATH]  = gta_DS_options[gs_DS_RateOption].us_D;

#ifdef INCLUDE_FASTRETRAIN_CODE
            } else {
                InitRxConfigFromProfile();
            }
#endif

            gt_rx_config.s_FramingMode  = gft_FrameMode;     /*  set framing mode */

            break;

        case G_DMT_BIS:

            if ((CNTLArray[0] & CNTL_ExpilictRate)== 0)  {/* No explicit rate control */
                for (j = 0; j < NUM_DS_BEARER_CHANNELS_SUPPORTED; j++) {
                    gt_rx_config.sa_Bpn[LP0_DATA_PATH][j] = gt_PMSParams.sa_Bpn[LP0_DATA_PATH][j];
                    gt_rx_config.sa_Bpn[LP1_DATA_PATH][j] = gt_PMSParams.sa_Bpn[LP1_DATA_PATH][j];
                }

                for (i  =0; i < NUM_DATA_PATHS; i++){
                    gt_rx_config.s_Rp[i] = gt_PMSParams.s_Rp[i];
                    gt_rx_config.s_Mp[i] = gt_PMSParams.s_Mp[i];
                    gt_rx_config.s_Dp[i] = gt_PMSParams.s_Dp[i];
                    gt_rx_config.s_Tp[i] = gt_PMSParams.s_Tp[i];
                    gt_rx_config.s_Lp[i] = gt_PMSParams.s_Lp[i];
                  //XDSLRTFW-543:BugFix_BisPlus_DS_ALL_IntlvDelay (start)
                    #ifdef HERC_API
                    if (gt_rx_config.s_Mp[i] > 0)
                    {
                        gt_DerivedFrameProperties_DS.PropPerLp[i].s_Kp    = gt_rx_config.sa_Bpn[i][0] + gt_rx_config.sa_Bpn[i][1] + 1;
                        gt_DerivedFrameProperties_DS.PropPerLp[i].s_NFECp = gt_rx_config.s_Mp[i] * gt_DerivedFrameProperties_DS.PropPerLp[i].s_Kp + gt_rx_config.s_Rp[i];
                        Divide_32by16bit(((gt_DerivedFrameProperties_DS.PropPerLp[i].s_NFECp * 8)<<8), 1, gt_rx_config.s_Lp[i], 1, &s_Sp_denum, &s_Sp_exp);
                        gt_DerivedFrameProperties_DS.PropPerLp[i].s_Sp    =  (s_Sp_denum >> (-s_Sp_exp));
                    }
                    else
                    {
                        gt_DerivedFrameProperties_DS.PropPerLp[i].s_Kp    = 0;
                        gt_DerivedFrameProperties_DS.PropPerLp[i].s_NFECp = 0;
                        gt_DerivedFrameProperties_DS.PropPerLp[i].s_Sp    = 0;
                    }
                    #endif
                  //XDSLRTFW-543:BugFix_BisPlus_DS_ALL_IntlvDelay (end)
                }

                gt_rx_config.s_MSGlp = gt_PMSParams.s_MSGlp;
                gt_rx_config.s_IBITSlp = gt_PMSParams.s_IBITSlp;
                gt_rx_config.s_MSGc = gt_PMSParams.s_MSGc;
            } /* end of no explicit rate control */

            gt_rx_config.s_FramingMode  = G_BIS_MODE;     /*  set framing mode */

            break;
        }

        gt_rx_config.psa_BAT        = guca_RxBat;        /* set BAT table pointer */
        gt_rx_config.psa_FineGains  = gsa_RxFineGains;  /* set fine gain pointer */

    }  /*   if Initial State != SHOWTIME  */




    for(i = 0; i < NUM_DATA_PATHS; i++)
    {
        gt_rx_config.s_currentLp[i] = gt_rx_config.s_Lp[i];

        for(j = 0; j < NUM_BEARER_CHANNELS; j++)
        {
            gt_rx_config.sa_currentBpn[i][j] = gt_rx_config.sa_Bpn[i][j];
        }
    }

    if(gft_ModemType == G_DMT_BIS)
    {
        /* Initialize HDLC / IB data. */
        RxOvhdInit();
        RxInitIb_bis();
        InitRxOvhdRegisters();

    }


    /* Initialise the loop attenuation and SNR values */
    /**************************************************/
    // The following are needed until the showtime-obtained values are calculated
    // The mapping of the margin from 8.8 format to 15.1 is simpler than the (accurate) one in synsymbl.c,
    // since the one here is used for a very short span of Showtime

    s_Margin = ((gs_RxAvMargin) >> 7);

    if (s_Margin > 127)
    s_Margin = 127;

    gt_NearEndParam.s_SnrMargin = s_Margin;
    gs_SnrMargin_OneOverTen_dB_Resolution = FormSNRM(gs_RxAvMargin);

    if(gft_ModemType != G_DMT_BIS)
    {
        gpt_EocRxReadBuf->c_snr_margin[0] = (int8) s_Margin;
        gpt_EocRxReadBuf->uc_line_attenuation[0] = (uint8) gt_RMsg2.us_AvLoopAttenu;
    }

    //If the rate option selected uses S=1/2, Ri is divided by 2
    if(gt_rx_config.s_Mp[LP0_DATA_PATH] == S_HALF) {
        gt_rx_config.s_Rp[LP0_DATA_PATH] >>= 1;
    }

    RxInit(&gt_rx_config);
   #ifndef ISDN
   //XDSLRTFW-623 BugFix_T1413_Ghs_Xtalk_Activation_Stuck (START_END)
   guc_Ghs_fails_count = 0; // Reset to 0 for all modes
   #endif
   guc_log_idx = 0;

}


void BgInitShowTimeRx(void)
{
    InitShowTimeRx();
    guc_ShowTimeRxState = TRAINING_DONE;
}
