/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             showinittx.c
 * DESCRIPTION:      Functions that implement the showtime state.
 *
 **********************************************************************/
// ******************************************************************
// showinittx.c
//
// History
//
// 15/09/2011 Kannan: DEC coefficient download state initialization.
//      Grep for XDSLRTFW-251 PERF_DS_PlusBisDmt_ALL_DECTraining
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 23/11/2012  Bhadra:XDSLRTFW-543:AVM rported Bug in ADSL FW "cmv_remap.c" resulting in wrong
//             "ActualInterleaveDelay" reporting for ADSL2 and ADSL2+.
//             This is becasue variables(s_Kp)of struct "DerivedFramePropLatencyPath_t" are under HERC_API
//             and these are not populated. There was an agreement with API team that future API version
//             including the one for PACE) will read Herc-cmv RATE 1 9 (verified in API 4.11.5 check Jira,XDSLRTFW-437)
//             And for backward compatibility of API versions, Add code to populate these variable(s_Kp,s_NFECp &s_Sp)
//             this code is taken from Vinax ref.
//              Also added code change for ActualPSD(ActPSD = RefPSD + RMSGI)population in NearEnd/FarEnd params structure
//             (which were n't populted earlier)
//             For code changes Grep for "XDSLRTFW-543:BugFix_BisPlus_DS_ALL_IntlvDelay"
//
// 07/12/2012  Bhadra:XDSLRTFW-547: Jira XDSLRTFW-543 adress the DS intlv delat through the API command
//             ./dsl_cpe_pipe.sh g997csg 0 1, The same needs to be addressed for ./dsl_cpe_pipe.sh g997csg 0 0
//             ie., in the US direction to complete for  XDSLRTFW-547.ie., "ActualInterleaveDelay"
//             reporting in US direction for ADSL2 and ADSL2+. The reasons are same as exapleined in XDSLRTFW-543
//             ie., variables(s_Kp)of struct "DerivedFramePropLatencyPath_t" are under HERC_API
//             and these are not populated. There was an agreement with API team that future API version
//             including the one for PACE) will read Herc-cmv RATE 0 9 (verified in API 4.11.5 check Jira,XDSLRTFW-437)
//             And for backward compatibility of API versions, Add code to populate these variable(s_Kp,s_NFECp &s_Sp)
//             this code is taken from Vinax ref.
//             For code changes Grep for "XDSLRTFW-547:BugFix_BisPlus_US_ALL_IntlvDelay"
//
// 25-06-2013 Ram: FW is setting Latency of unused path (Lp = 0) to -1. This is leading to Very High interleaver delay being displayed by
//                 SW API in command "g997csg". SW API normally sums up values corresponding to both paths LP0 and LP1 and the result is
//                 displayed. It expects only one of them (either LP0 or LP1) to have non-zero value. Hence fixed the bug by setting latency
//                 of unused path to ZERO.
//                 Grep for ADSLRTFW-1689: BugFix_DS_All_All_IncorrectIntlDelayReported
// 10/09/2014 Balabath: Modifications in handling of CRC's and FEC counters for API reporting and reporting to DSLAM through OHM
//            Report always running counters to API and control thorugh CMV DSL 22 0 bit#0 for DSLAM Reporting
//            Bit#0 of DSL 22 0 is 1 and will report only per session counters (default)
//            if Bit#0 of DSL 22 0 is reset running counter will be reported.
//             Added IOP fix for CNXT ie., default case (report only per session counters).
//            Grep for XDSLRTFW-2003
// ******************************************************************
#include <stdio.h>
#include <string.h>           // for memset
#include "common.h"
#include "gdata.h"
#include "dslengin.h"
#include "dec_gain.h"
#include "cmv.h"
#include "tone_ord.h"
#include "bitload.h"
#include "tx_m3oh.h"
#include "enc_gain.h"
#include "dec_adap_Data.h"
#include "ec_data.h"
#include "gdata_bis.h"
#include "trailend.h"
#include "ovhd_ini_bis.h"
#include "aoc_ini.h"
#include "tx_eoc.h"
#include "rx_eoc.h"
#include "tx_ib.h"
#include "tx_ovrhd_bis.h"
#include "showinit.h"
#include "T1413.h"
#include "ghs.h"
#include "states.h"
#include "ComputeRMSFineGain.h"
#include "dsp_op2.h"
#include "mul.h"
#include "snr.h"
#include "DebugBuffer.h"
#include "diagparam_bis.h"  //XDSLRTFW-3717 (Start_End)

/*****************************************************************************
;  Subroutine Name: TxInit(void)
;
;  This subroutine conducts initialization for ADSL TX-side operations.
;
;
;  Prototype:
;     void TxInit(void)
;
;  Input Arguments:
;     None
;
;  Output Arguments:
;     All static and global variables described below are initialized to proper values
;
;  Global Variables:
;     gt_TxShowTimeVars -- structure containing all following global variables used by tx.c:
;
;       s_D_tx              --  D for interleave depth
:       s_S_tx              --  number of DMT symbols per FEC codeword,
;                               intreleaved path
:       t_FastParms_tx      --  structure of fast path parameters
:       t_InlvParms_tx      --  structure of fast path parameters
;       s_FastPathType_tx   --  = FAST_DATA_PATH
;       s_InlvPathType_tx   --  = INTERLEAVED_DATA_PATH
:       s_Rf_tx             --  number of FEC redundancy bytes, fast path
:       s_Ri_tx             --  number of FEC redundancy bytes, interleaved path
:       s_RawFrameSizef_tx  --  number of payload data bytes per frame,
;                               fast path
:       s_RawFrameSizei_tx  --  number of payload data bytes per frame,
;                               interleaved path
:       s_MuxFrameSizef     --  payload bytes + overhead bytes, fast path
:       s_MuxFrameSizei    --  payload bytes + overhead bytes, interleaved path
:       s_Af_tx             --  Number of AEX bytes in the fast path
:       s_Ai_tx             --  Number of AEX bytes in the interleaved path
:       s_Lf_tx             --  Number of LEX bytes in the fast path
:       s_Li_tx             --  Number of LEX bytes in the interleaved path
:       sa_Bf_alloc         --  Array of bearer channel byte allocations for
;                               the fast path
:       sa_Bi_alloc         --  Array of bearer channel byte allocations for
;                               the interleaved path
:       sa_Bf_out           --  Array of bearer channel bytes to transmit for
;                               the fast path
:       sa_Bi_out           --  Array of bearer channel bytes to transmit for
;                               the interleaved path
;       Ft_C_Chan_Enabledf_tx -- indicates if the 'C' channel is enabled on
;                                LS0 for the fast path
;       Ft_C_Chan_Enabledi_tx -- indicates if the 'C' channel is enabled on
;                                LS0 for the interleaved path
:       s_CodewordSize      --  number of bytes per codeword, interleaved path
:       s_FecFrameSize      --  CodewordSize/S
:       s_CodewordSize_Odd  --  = CodewordSize + 1-(s_CodewordSize&1)
:       psa_BAT_tx          --  pointer to bit loading table
:       psa_FineGains_tx    --  pointer to a table fine gains
;
;****************************************************************************/

void ComputeFramingConstraints(int16 s_latency, FlagT ft_isDownstream, Config_t* t_config, int16 s_MaxNumTones, uint8* puca_BCnToLPp, int16 s_SEQp, DerivedFramePropLatencyPath_t* t_DerivedFrameProperties);

void TxInit(void)
{
   FlagT ft_TcmFlag;
   int i, j;
   int16 dummyByte;
   int16 s_numBearerChannel, s_DEFAULT_MAXNOMATP_US;
   int32 l_temp;
   int16 s_Sp_denum, s_Sp_exp;

   if(gft_ModemType == G_DMT_BIS) ft_TcmFlag =  gft_TcmFlag_bis_US;
   else ft_TcmFlag = gft_TcmFlag;

   // set upstream MaxNomATP
   if (gl_SelectedMode & (ANNEX_B | ANNEX_I))
      s_DEFAULT_MAXNOMATP_US = DEFAULT_MAXNOMATP_US_133;    /* absolute default DS MAXNOMATP*10 (0.1 dB step-size) */
   else if (gl_SelectedMode & ANNEX_J)
      s_DEFAULT_MAXNOMATP_US = DEFAULT_MAXNOMATP_US_134;    /* absolute default DS MAXNOMATP*10 (0.1 dB step-size) */
   else
      s_DEFAULT_MAXNOMATP_US = DEFAULT_MAXNOMATP_US_125;    /* absolute default DS MAXNOMATP*10 (0.1 dB step-size) */


   gft_FrameMode = gt_tx_config.s_FramingMode;
   STATArray[STAT_DMTFramingMode] = (STATArray[STAT_DMTFramingMode] & (~STAT_FramingModeMask)) | gft_FrameMode;


   gt_TxShowTimeVars.t_FrameParms[LP1_DATA_PATH].s_PathType = LP1_DATA_PATH;

   gt_TxShowTimeVars.t_FrameParms[LP0_DATA_PATH].s_PathType = LP0_DATA_PATH;

   for(i = 0; i < NUM_DATA_PATHS; i++) {
      gt_TxShowTimeVars.t_FrameParms[i].s_R = gt_tx_config.s_Rp[i];
      gt_TxShowTimeVars.t_FrameParms[i].s_RawFrameSize = 0;
   }

   for(i = 0; i < NUM_BEARER_CHANNELS; i++) {
      gt_TxShowTimeVars.t_BCParms[i].sa_BC_Bytes = 0;
      gt_TxShowTimeVars.t_BCParms[i].sa_BC_BytesOut = 0;
      gt_TxShowTimeVars.t_BCParms[i].sa_BC_LPath = -1;      // Undefined
      gt_TxShowTimeVars.t_BCParms[i].sa_BC_LSX = -1;     // Undefined
      gt_TxShowTimeVars.t_BCParms[i].sa_BC_CChan = FALSE;   // Not a C Channel
   }
   s_numBearerChannel = 0; // Keeps track of mapping from ASx,LSx to BCx
   gus_numTxC_Channel = 0; // Keeps track of Tx 'C' Channels

   if(gft_ModemType == G_DMT)
   {

      /* =========================================== */
      /*  Check if 16 kbps 'C' channel is enabled */
      /* =========================================== */
      for(i = 0; i < NUM_DATA_PATHS; i++) {
         if (gt_tx_config.sa_Bpn[i][US_LS0_BEARER_CHANNEL] == 255) {
            gt_TxShowTimeVars.t_FrameParms[i].Ft_C_Chan_Enabled = TRUE;
            gt_tx_config.sa_Bpn[i][US_LS0_BEARER_CHANNEL] = 0;
            gt_TxShowTimeVars.t_BCParms[s_numBearerChannel].sa_BC_Bytes = 0;
            gt_TxShowTimeVars.t_BCParms[s_numBearerChannel].sa_BC_BytesOut = 0;
            gt_TxShowTimeVars.t_BCParms[s_numBearerChannel].sa_BC_LPath =  i;
               gt_TxShowTimeVars.t_BCParms[s_numBearerChannel].sa_BC_LSX = US_LS0_BEARER_CHANNEL;
            gt_TxShowTimeVars.t_BCParms[s_numBearerChannel].sa_BC_CChan = TRUE;
            gus_numTxC_Channel++;
            s_numBearerChannel++;
         } else {
            gt_TxShowTimeVars.t_FrameParms[i].Ft_C_Chan_Enabled = FALSE;
         }
      }

      /* =============================================================*/
      /*  Determine number of payload bytes from LSX Bearer channels    */
      /*  for both the fast and interleaved paths to the respective  */
      /*  totals of payload bytes                           */
      /* Also, Compute the number of bytes for bearer channel 0 and 1*/
      /* =============================================================*/
      for (i = 0; i < NUM_US_BEARER_CHANNELS; i++) {
         for(j = 0; j < NUM_DATA_PATHS; j++) {
            gt_TxShowTimeVars.t_FrameParms[j].s_RawFrameSize +=
               gt_tx_config.sa_Bpn[j][i];
            gt_TxShowTimeVars.t_FrameParms[j].sa_B_alloc[i] =
               gt_tx_config.sa_Bpn[j][i];
            gt_TxShowTimeVars.t_FrameParms[j].sa_B_out[i] =
               gt_tx_config.sa_Bpn[j][i];

            if(gt_tx_config.sa_Bpn[j][i]) {
               if(s_numBearerChannel < NUM_BEARER_CHANNELS) {
                  gt_TxShowTimeVars.t_BCParms[s_numBearerChannel].sa_BC_Bytes = gt_tx_config.sa_Bpn[j][i];
                  gt_TxShowTimeVars.t_BCParms[s_numBearerChannel].sa_BC_BytesOut = gt_tx_config.sa_Bpn[j][i];
                  gt_TxShowTimeVars.t_BCParms[s_numBearerChannel].sa_BC_LPath =  j;
                  gt_TxShowTimeVars.t_BCParms[s_numBearerChannel].sa_BC_LSX = i;
                  s_numBearerChannel++;

                  STATArray[STAT_ACTIVEBCLP_US] |= (1<<j) | ((1<<i)<<8);
               } else {
                  //printf("More than %d bearer channels nota allowed\n", NUM_BEARER_CHANNELS);
               }
            }
         }
      }
      //XDSLRTFW-547:BugFix_BisPlus_US_ALL_IntlvDelay (start)
      for(j = 0; j < NUM_DATA_PATHS; j++)
            gt_DerivedFrameProperties_US.PropPerLp[j].s_Kp    = gt_tx_config.sa_Bpn[j][0] + gt_tx_config.sa_Bpn[j][1] + 1;
      //XDSLRTFW-547:BugFix_BisPlus_US_ALL_IntlvDelay (end)

      /* =================================================================== */
      /*  Determine the number of LEX bytes in the fast and interleaved path */
      /* =================================================================== */
      for(i = 0; i < NUM_DATA_PATHS; i++) {
         if((gft_FrameMode == FULL_ASYNC) || (gft_FrameMode == FULL_SYNC)) {
         /*  in full overhead modes, there is one LEX if any LSX channels */
         /*  are enabled in the coressponding latency path */
            gt_TxShowTimeVars.t_FrameParms[i].s_L =
               ( (gt_TxShowTimeVars.t_FrameParms[i].s_RawFrameSize == 0) ? 0 : 1);

         /*  check if 'C' channel is enabled */
            if (gt_TxShowTimeVars.t_FrameParms[i].Ft_C_Chan_Enabled == TRUE) {
               gt_TxShowTimeVars.t_FrameParms[i].s_L = 1;
            }
         } else {
         /*  in reduced overhead modes there are no LEX bytes */
            gt_TxShowTimeVars.t_FrameParms[i].s_L = 0;
         }

      /* ========================================================================== */
      /* Set the Data Rate managment variables in units of bits/second        */
      /* ========================================================================== */
         gla_USDataRate[i] = (gt_TxShowTimeVars.t_FrameParms[i].s_RawFrameSize )*32000;
      }

      /* ===================================================================== */
      /*  Determine the Mux data frame size (payload + framing overhead) */
      /*  for the fast and interleaved paths */
      /* ===================================================================== */
      if (gft_FrameMode != REDUCED_MERGED) {
         for(i = 0; i < NUM_DATA_PATHS; i++) {
            gt_TxShowTimeVars.t_FrameParms[i].s_MuxFrameSize =
               gt_TxShowTimeVars.t_FrameParms[i].s_RawFrameSize +
               gt_TxShowTimeVars.t_FrameParms[i].s_L + 1;
         }
      } else {
         if (gt_TxShowTimeVars.t_FrameParms[LP1_DATA_PATH].s_RawFrameSize != 0) {
            gt_TxShowTimeVars.t_FrameParms[LP1_DATA_PATH].s_MuxFrameSize =
               gt_TxShowTimeVars.t_FrameParms[LP1_DATA_PATH].s_RawFrameSize + 1;
            gt_TxShowTimeVars.t_FrameParms[LP0_DATA_PATH].s_MuxFrameSize = 0;
         } else {
            gt_TxShowTimeVars.t_FrameParms[LP1_DATA_PATH].s_MuxFrameSize = 0;
            gt_TxShowTimeVars.t_FrameParms[LP0_DATA_PATH].s_MuxFrameSize =
               gt_TxShowTimeVars.t_FrameParms[LP0_DATA_PATH].s_RawFrameSize + 1;
         }
      }

   } /* if(gft_ModemType == G_DMT) */
   else if (gft_ModemType == G_DMT_BIS)
   {
      for (i = 0; i < NUM_BEARER_CHANNELS; i++)
      {
         j = guca_txBCnToLPp[i];
         if (j != DISABLED_LP)
         {
            gt_TxShowTimeVars.t_FrameParms[j].s_RawFrameSize +=
               gt_tx_config.sa_Bpn[j][i];
#ifndef DISABLE_BERT
            gt_TxShowTimeVars.t_FrameParms[j].sa_B_alloc[i] =
               gt_tx_config.sa_Bpn[j][i];
            gt_TxShowTimeVars.t_FrameParms[j].sa_B_out[i] =
               gt_tx_config.sa_Bpn[j][i];

            gt_TxShowTimeVars.t_BCParms[i].sa_BC_LSX = i;

#endif

            gt_TxShowTimeVars.t_BCParms[i].sa_BC_Bytes = gt_tx_config.sa_Bpn[j][i];
            gt_TxShowTimeVars.t_BCParms[i].sa_BC_BytesOut = gt_tx_config.sa_Bpn[j][i];
            gt_TxShowTimeVars.t_BCParms[i].sa_BC_LPath = j;

            STATArray[STAT_ACTIVEBCLP_US] |= (1<<j) | ((1<<i)<<8);
         }
      }


      for(i=0; i < NUM_DATA_PATHS; i++)
      {
         if (gt_tx_config.s_Lp[i] > 0)
            gt_TxShowTimeVars.t_FrameParms[i].s_MuxFrameSize = gt_TxShowTimeVars.t_FrameParms[i].s_RawFrameSize + 1;
         else
            gt_TxShowTimeVars.t_FrameParms[i].s_MuxFrameSize = 0;

         // For faster Rx Data Pump processing -- ZA Run Count Mechanism
         gsa_TxMuxFrameSize[i][0] = gt_TxShowTimeVars.t_FrameParms[i].s_MuxFrameSize;
         gsa_TxMuxFrameSize[i][1] = (gsa_TxMuxFrameSize[i][0] + gt_tx_config.s_Rp[i]);
      }

      gt_tx_config.s_IBITSlp = ComputePathWithSmallestLatency(&gt_tx_config);

      for(i=0; i < NUM_DATA_PATHS; i++)
      {
         gusa_PreconfigACfgTx[i] = 0;
         for (j = 0; j < 2; j++)
         {
            if(guca_txBCnToLPp[j] == i)
            {
               gusa_PreconfigACfgTx[i] |= (1<<(12-2*j));
               // When Utopia workaround is enabled, we cant support dual bearer channels (or dual latency)

            }
         }
         gsa_tx_SEQp[i] = ComputeSEQ(i,&gt_tx_config);

#ifdef DANUBE
//PPE Workaround 2.  For US B=0, must  enable two BCs.
        if ((gt_TxShowTimeVars.t_BCParms[0].sa_BC_Bytes ==0) || (gt_TxShowTimeVars.t_BCParms[1].sa_BC_Bytes ==0) )
            gusa_PreconfigACfgTx[i] |= 0x1400;
#endif
      }
   }

   for(i = 0; i < NUM_DATA_PATHS; i++)
   {

      gt_TxShowTimeVars.t_FrameParms[i].s_CodewordSize =
         (gt_TxShowTimeVars.t_FrameParms[i].s_MuxFrameSize *
         gt_tx_config.s_Mp[i]) +
         gt_tx_config.s_Rp[i];

      if (gt_tx_config.s_Mp[i] > 0) {
         gt_TxShowTimeVars.t_FrameParms[i].s_FecFrameSize =
            gt_TxShowTimeVars.t_FrameParms[i].s_CodewordSize / gt_tx_config.s_Mp[i];

         /* ========================================================================== */
         /* Following assignment is to take care of the case having even size codeword */
         /* ========================================================================== */
         if(gt_TxShowTimeVars.t_FrameParms[i].s_CodewordSize&0x1)
            dummyByte = 0;
         else
            dummyByte = 1;

         gt_TxShowTimeVars.t_FrameParms[i].s_CodewordSize_Odd =
            gt_TxShowTimeVars.t_FrameParms[i].s_CodewordSize + dummyByte;
            //XDSLRTFW-547:BugFix_BisPlus_US_ALL_IntlvDelay (start)
            #ifdef HERC_API
            gt_DerivedFrameProperties_US.PropPerLp[i].s_Kp    = gt_tx_config.sa_Bpn[i][0] + gt_tx_config.sa_Bpn[i][1] + 1;
            gt_DerivedFrameProperties_US.PropPerLp[i].s_NFECp = gt_tx_config.s_Mp[i] * gt_DerivedFrameProperties_US.PropPerLp[i].s_Kp + gt_tx_config.s_Rp[i];
            Divide_32by16bit(((gt_DerivedFrameProperties_US.PropPerLp[i].s_NFECp * 8)<<8), 1, gt_tx_config.s_Lp[i], 1, &s_Sp_denum, &s_Sp_exp);
            gt_DerivedFrameProperties_US.PropPerLp[i].s_Sp    =  (s_Sp_denum >> (-s_Sp_exp));
            #endif
            //XDSLRTFW-547:BugFix_BisPlus_US_ALL_IntlvDelay (end)
      }
      else
      {
         gt_TxShowTimeVars.t_FrameParms[i].s_FecFrameSize = 0;
         gt_TxShowTimeVars.t_FrameParms[i].s_CodewordSize_Odd = 0;
         //XDSLRTFW-547:BugFix_BisPlus_US_ALL_IntlvDelay (start)
         #ifdef HERC_API
         gt_DerivedFrameProperties_US.PropPerLp[i].s_Kp    = 0;
         gt_DerivedFrameProperties_US.PropPerLp[i].s_NFECp = 0;
         gt_DerivedFrameProperties_US.PropPerLp[i].s_Sp    = 0;
         #endif
         //XDSLRTFW-547:BugFix_BisPlus_US_ALL_IntlvDelay (End)
      }
   }

   if(gft_ModemType == G_DMT)
   {
      for(i=0; i< NUM_DATA_PATHS; i++)
         gt_tx_config.s_Lp[i] = (gt_TxShowTimeVars.t_FrameParms[i].s_FecFrameSize << 3); /* Lp is in bits and not bytes */
#ifdef HERCULES_ADSL_CPE
      // set IBITSlp (this should be revisited)
      if (gt_tx_config.s_Lp[FAST_DATA_PATH] > 0)
         gt_tx_config.s_IBITSlp = FAST_DATA_PATH;
      else
         gt_tx_config.s_IBITSlp = INTERLEAVE_DATA_PATH;
#endif // HERCULES_ADSL_CPE
   }

   // get derived frame properties
   for (j = 0; j < NUM_DATA_PATHS; j++)
   {
      int32 l_latency, l_INP;
      int16 s_latency, s_INP, s_Lp;

      // latency  ceil(S*D) (units are ms*4) in Q14.2
      l_latency= (int32)(gt_TxShowTimeVars.t_FrameParms[j].s_CodewordSize * gt_tx_config.s_Dp[j])<<3;
      s_Lp = gt_tx_config.s_Lp[j];
      s_latency = 0;
      //ADSLRTFW-1689: BugFix_DS_All_All_IncorrectIntlDelayReported (Start)
      if (s_Lp == 1) {
         s_latency = (int16)l_latency;
      } else if (s_Lp == 0) {
         //Set delay to ZERO for Latency path that is not used. SW API sums up both LP0 and LP1 values
         //and the result is displayed. SW API expects only one of them to have non-zero value.
         s_latency = 0; //(int16)0xFFFF;
      } else {
         while (l_latency >= s_Lp) {
            l_latency -= (int32)s_Lp;
            s_latency++;
         }
         if (l_latency != 0)
            s_latency++;
      }
      //ADSLRTFW-1689: BugFix_DS_All_All_IncorrectIntlDelayReported (End)
      gt_DerivedFrameProperties_US.PropPerLp[j].s_Latency = s_latency;
      /**************************************************************************************
            INP is impulse noise protection = (1/2) (S*D) (R/CWSize),  Actual INP (*10)
      ***************************************************************************************/
        if( (s_Lp!= 0) && (gl_SelectedMode & MODE_ADSL2) )
      {
            l_INP = (int32)((gt_tx_config.s_Dp[j] * gt_tx_config.s_Rp[j])*400);
            s_INP = (int16)(l_INP/s_Lp+5)/10;
      }
      else
            s_INP=0;

      gt_DerivedFrameProperties_US.PropPerLp[j].s_INP = s_INP;
   }

   /* ========================================================================= */
   /* Verify frame size matches to bit allocation table (DMT/BIS Showtime,OLR)*/
   /* ========================================================================= */
   if (!VerifyAndUpdateTxQAMParameters(gt_tx_config.psa_BAT, gt_tx_config.s_Lp))
   {
      gs_TxNextState = FAIL_TX;
      gpF_TxStateFunc = (PtrToFunc)ExceptionHandler;

      /* Set exception handler variable */
      gus_ExceptionState   = gs_TxState;
      gus_ExceptionCode = E_CODE_BAT_TX;
   }

   //calculate US RMS fine gain (Q8.8)
   l_temp = (int32) ComputeRMSFineGain(gt_tx_config.psa_BAT, gt_tx_config.psa_FineGains, gs_TxNumTones, gs_CurrentCoChipset, 1, 0);

   gt_TxPMDControl.us_RMSGI_US   = 2* (ConvertToDB(l_temp)  -  ConvertToDB(8192));

   /* If BIS mode, Check if Bpn reconfiguration is allowed  */
   if(gft_ModemType == G_DMT_BIS)
   {
      for(i=0; i < NUM_US_LATENCY_PATHS; i++)
         CheckForBpnReconfig(gt_TxShowTimeVars.t_FrameParms[i].s_CodewordSize,
         gt_tx_config.s_Lp[i],
         gt_tx_config.s_Rp[i],
         gt_tx_config.s_Dp[i],
         &(gft_TxBpnReconfigAllowed[i]));
   }
   /* In DMT Mode, Fine gain computations for sync symbol */
   else
   {
      int32 l_Prod;
      int16 s_TxRMSFineGaindB_all;

        if( (!(STATArray[STAT_Misc] & STAT_T1413_Signal_Detected) && ((gs_CurrentCoChipset==ALA_CO_CHIPSET) || (gft_SyncScalingForGenericCOinDMT==1))) ||
         (gs_CurrentCoChipset==IFTN_CO_CHIPSET) ||
         (gs_CurrentCoChipset==BDCM_CO_CHIPSET) )
      {
         MULS16(l_Prod, l_temp, ENCGAIN2);
         gs_TxSyncFrameGain = (int16) (l_Prod >> 13);
      }
      else
      {
         gs_TxSyncFrameGain = ENCGAIN2;
      }

      // Compute RMS for all tones above TxFirstChannel
      l_Prod = (int32) ComputeRMSFineGain(gt_tx_config.psa_BAT, gt_tx_config.psa_FineGains, gs_TxNumTones, gs_CurrentCoChipset, 1, 1);
      s_TxRMSFineGaindB_all = 2* (ConvertToDB(l_Prod)  -  ConvertToDB(8192));
      gt_FarEndParam.s_ActualAggregateXmtPwr = s_DEFAULT_MAXNOMATP_US + (s_TxRMSFineGaindB_all*10>>8);
   }



   /* Compute the encoder gain.  ADSL2 uses dB format for fine gains, while ADSL1 uses linear format. */
   CalcEncodGain(gt_tx_config.psa_BAT, gt_tx_config.psa_FineGains,
      &gsa_TxCombinedGains[0]);


   /* Perform tone ordering if we're running G992_1 */

   if (!(STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_AB)) {
      if (gft_ModemType == G_DMT || TESTArray[TEST_InitState] == TEST_ShowtimeInitState)
      {
         ToneOrdering(gt_tx_config.psa_BAT, gs_TxNumTones, (int16)TX_MAX_BITS_PER_TONE, gsa_TxToneOrder);
         gs_FirstNonzeroTxTone = gs_FirstNonzeroTone;    /* gs_FirstNonzeroTone is set by ToneOrdering() */
      }
   }

   else

      for(i=0;i<gs_TxNumTones;i++) {
         gsa_TxToneOrder[i] = i;
      }



   if ( gl_SelectedMode & (MODE_ADSL2))
   {
      if(TESTArray[TEST_InitState] == TEST_GhsInitState)
         //Compute NOMATPus here after blackout bits applied to fine gains
         gt_TxPMDControl.s_NOMATP_US = CalcNOMATP(gt_TxPMDControl.s_NOMPSD_US,(int16)DEFAULT_NOMPSD_US,s_DEFAULT_MAXNOMATP_US,gt_tx_config.psa_FineGains,0x2000,gusa_US_Tssi_Value,gp_MEDLEYset_US,gs_TxNumTones, &(gt_TxPMDControl.s_NOMPSD_US_dBmHz));
      //XDSLRTFW-543:BugFix_BisPlus_DS_ALL_IntlvDelay (start)
      //  Populate FarEnd ACTPSD
      gt_TxPMDControl.s_REFPSD_US = gt_TxPMDControl.s_NOMPSD_US - gt_TxPMDControl.us_pwr_cutback_US*10;
      gt_FarEndParam.s_ActualPSD =  gt_TxPMDControl.s_NOMPSD_US_dBmHz - gt_TxPMDControl.us_pwr_cutback_US*10 + ((gt_TxPMDControl.us_RMSGI_US * 10 + (1<<7))>>8) ;
      if (gt_FarEndParam.s_ActualPSD < OUT_OF_RANGE_ACTPSD) gt_FarEndParam.s_ActualPSD = OUT_OF_RANGE_ACTPSD;
      //XDSLRTFW-543:BugFix_BisPlus_DS_ALL_IntlvDelay (end)
      for (i = 0; i < gt_rx_config.s_Nlp; i++)
         ComputeFramingConstraints(i, TRUE, &gt_rx_config, gs_RxNumTones, guca_rxBCnToLPp, gsa_rx_SEQp[i], &gt_DerivedFrameProperties_DS.PropPerLp[i]);

      for (i = 0; i < gt_tx_config.s_Nlp; i++)
         ComputeFramingConstraints(i, FALSE,&gt_tx_config, gs_TxNumTones, guca_txBCnToLPp, gsa_tx_SEQp[i], &gt_DerivedFrameProperties_US.PropPerLp[i]);

   }
   /* Init. super frame count */
   gs_bitswap_tx_sframe_count = 0;

#ifndef TARGET_HW
   /* Don't allow Sync Action until enabled by showtime functions */
   gft_FastSyncAvailable_Flag = NO_SYNC_ALLOWED;
   gft_InlvSyncAvailable_Flag = NO_SYNC_ALLOWED;
#endif



//ATM Byte Flip control
      if (OPTNArray[OPTN_ATMAddrConfig] & OPTN_ATM_BYTEFLIP_ENABLE) //Force byte flip on
         gft_disableAlphaeusTxByteFlip =0;   //BYTE_FLIP (0: enable)
      else if (OPTNArray[OPTN_ATMAddrConfig] & OPTN_ATM_BYTEFLIP_DISABLE) //Force byte flip off
         gft_disableAlphaeusTxByteFlip= 1;   //BYTE_FLIP (1: disable)
}


/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*       void InitTxConfigFromProfile(void);
*
*   Abstract:
*       Loads configuration from the profile in fast retrain.
*
*   Input Parameters:
*     none
*
*  Return: None
*
*  Global Variables:
*     gt_tx_config   -- (O) TX configuration structure
*     gft_TxInFastRetrain_flag -- (O) Fast Retrain flag
*     gta_TxProfile  -- (I) TxProfiles
*-----------------------------------------------------------------------------
^^^*/
void InitTxConfigFromProfile(void)
{
#ifdef INCLUDE_FASTRETRAIN_CODE
   gt_tx_config.sa_Bpn[LP0_DATA_PATH][0] =
                     ( (gta_TXProfile[gs_US_Profile].s_ReqdBits >> 3) -
                     gta_TXProfile[gs_US_Profile].s_R - 1);
   gt_tx_config.s_Rp[LP0_DATA_PATH] = gta_TXProfile[gs_US_Profile].s_R *
                                    gta_TXProfile[gs_US_Profile].s_S;
   gt_tx_config.s_Mp[LP0_DATA_PATH] = gta_TXProfile[gs_US_Profile].s_S;
   gt_tx_config.s_Dp[LP0_DATA_PATH] = gta_TXProfile[gs_US_Profile].s_D;
   gft_FrameMode = REDUCED_MERGED;
   gft_TxInFastRetrain_flag = FALSE;
#endif
}


/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*       void InitNonDMTMembersTx(void);
*
*   Abstract:
*       Initialize non G.DMT members of Tx Config structure.
*
*   Input Parameters:
*     none
*
*  Return: None
*
*  Global Variables:
*     gt_tx_config   -- (O) TX configuration structure
*-----------------------------------------------------------------------------
^^^*/
void InitNonDMTMembersTx(void)
{
   gt_tx_config.s_Mp[LP1_DATA_PATH] = 1;

   gt_tx_config.s_Tp[LP1_DATA_PATH] = 1;
   gt_tx_config.s_Tp[LP0_DATA_PATH] = 1;

   gt_tx_config.s_Dp[LP1_DATA_PATH] = 1;

   gt_tx_config.s_MSGc = 62;
}


/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*       int16 InitShowTimeTx(void);
*
*   Abstract:
*       Perform initialization for running showtime TX. This function forms
*  configuration structure and then call TxInit().
*
*   Input Parameters:
*     none
*
*  Return:
*     number of frames should be processed before SHOWTIME starts to
*     avoid underflow of output buffer
*
*  Global Variables:
*     gs_DS_RateOption -- (I) selected downstream rate option
*     gsa_TxBat[]    -- (I) TX bit allocation table
*     gt_rx_config   -- (O) RX configuration structure
*     gt_tx_config   -- (O) TX configuration structure
*-----------------------------------------------------------------------------
^^^*/

int16 InitShowTimeTx(void)
{
   //Changes from R3.5 (Start)
   int16 s_sc, s_temp;
   //Changes from R3.5 (End)
   int i;

   /* Initialize non G.DMT members of Tx Config structure */
   if(gft_ModemType == G_DMT)
   {
      InitNonDMTMembersTx();
   }
   /* Initialize OLR and PM state variables of G.BIS */
   else
   {
#ifndef TARGET_HW
      gt_TxOLRVars.uc_txOLRState = STATE_NOT_DEFINED;
#else
      gt_TxOLRVars.uc_txOLRState = L0_STEADY_STATE;
#endif
      gs_TxSyncToneType = R_REVERB;
   }

   /*  flag to set intial buffer sizes for showtime TX */
   gft_ShowTimeFirstPassTx = FALSE;

   /* Initialize DEC adaptation state machine flags. */
   guc_DECAdaptationState = DEC_ADAPTATION_DISABLED;
   guc_DECRxCaptureFlag = WAIT;
   guc_DECTxCaptureFlag = WAIT;
   guc_DECCoefUpdateFlag = WAIT;
   guc_DECCoefDnloadFlag = WAIT;
   guc_DECCoefDnloadState = LOAD_TDQ; //XDSLRTFW-251 PERF_DS_PlusBisDmt_ALL_DECTraining (START-END)
   guc_CalcDECCaptureOffsetFlag =WAIT;
   gft_SynchSymbolChange = FALSE;
   gft_CorruptedSynchFrame = FALSE;
   /* Initialize variables for DEC adaptation. */
   gs_TxFrameLength = gs_TxFftLength_Oversample + gs_TxCPLength_Oversample;
   gs_Log2DECUpsamplingFactor = 0;
   gs_DECLengthPerPhase = gs_DEC_ORDER;
   for (i = gs_DECUpsamplingFactor; i > 1; i >>= 1)
   {
      gs_Log2DECUpsamplingFactor++;
      gs_DECLengthPerPhase >>= 1;
   }
   gs_DECTxDataCaptureLength = gs_DECLengthPerPhase - 1 + (DEC_RX_DATA_CAPTURE_LEN >> gs_Log2DECUpsamplingFactor);
   gl_numCorruptedSynchFrames = 0;
   /* Modify the number of out of band tones such that we transmit out of band energy */
   /* starting from tone (gs_TxMedleyLastCh + 1). */
   i = gs_TxNumTones - gs_TxMedleyLastCh - 1;
   if ((gs_TxFftLength == 128) && (gs_TxNumTones == 32))
   {
      gus_NumOutBandTones_right += i;
   }
   else
   {
      gus_NumOutBandTones_right = i;
   }

// it is seen currently that performance in ISDN is good when we have 3 right tones and 3 left outr of band tones.
   if (gus_NumOutBandTones_left > gus_NumOutBandTones_right) gus_NumOutBandTones_left = gus_NumOutBandTones_right;

   if ( gus_NumOutBandTones_left > (gs_TxFirstChannel - 1))
      gus_NumOutBandTones_left = gs_TxFirstChannel - 1;
//Changes from R3.5 (Start)
   if (gl_SelectedMode & ANNEX_J)
   {
      // decide outband power based on number of tones used
      s_sc = 0;
      s_temp = gus_NumOutBandTones_right>>1;

      while (s_temp > 1)
      {
         s_sc = s_sc + 1;
         s_temp >>= 1;
      }

      gs_TxOutBandGain = (gs_TxOutBandGain>> s_sc);

   }
//Changes from R3.5 (End)
   /* Calculate coefficient update exponent taking into account the LMS stepsize */
   /* (depends on the number of samples used in block LMS to update a coefficient) */
   /* and the exponent of the DEC coefficients. Limit to 1 needed for rounding to */
   /* work in the LMS algorithm and for performance. */
   gs_DECAdaptExp = gs_DECAdaptExp - gs_Log2DECUpsamplingFactor + gs_pre_dec_h_exp;
   if (gs_DECAdaptExp <= 0)
   {
      gs_DECAdaptExp = 1;
   }
#ifndef ADSL_62
   /* Initialize buffer for Rx data accumulation. */
   memset(gpla_DECAdaptationRxDataAccum, 0, DEC_RX_DATA_CAPTURE_LEN*sizeof(int32));
#endif
   /* Initialize the array of DEC coefficient LSWs. */
   memset(gpusa_pre_dec_h_lsw, 0, gs_DEC_ORDER*sizeof(uint16));

   /* For Lite mode only */
   if((STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_AB) || (STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_C)) {

#ifdef INCLUDE_FASTRETRAIN_CODE
      if (gft_TxInFastRetrain_flag == FALSE)
      {  /*  Full initialization */
         /* Set the flag so that a profile management request message */
         /* is sent out each time the showtime is entered from  */
         /* full initialization */
         gft_SendAocMsg_Flag = OUTSTANDING;

      }
      else
      {  /* Fast Retrain */
         gft_SendAocMsg_Flag = IDLE;
      }
#else
        // No Fast Retrain, so no need to send the PMR request
        gft_SendAocMsg_Flag = IDLE;
#endif
   }

   if (TESTArray[TEST_InitState] != TEST_ShowtimeInitState)
   {

      switch(gft_ModemType) {

      case G_DMT:

#ifdef INCLUDE_FASTRETRAIN_CODE
         if (gft_TxInFastRetrain_flag == FALSE) {     /*  full initialization */
#endif

            for (i = 0; i < NUM_US_BEARER_CHANNELS; i++)
            {
               gt_tx_config.sa_Bpn[LP1_DATA_PATH][i] = (int16) gta_US_options[gs_US_RateOption].pus_ReqBytes[LP1_DATA_PATH*NUM_US_BEARER_CHANNELS + i];
               gt_tx_config.sa_Bpn[LP0_DATA_PATH][i] = (int16) gta_US_options[gs_US_RateOption].pus_ReqBytes[LP0_DATA_PATH*NUM_US_BEARER_CHANNELS + i];
            }
            gt_tx_config.s_Rp[LP1_DATA_PATH] = gta_US_options[gs_US_RateOption].puc_CheckBytes[LP1_DATA_PATH];

            gt_tx_config.s_Rp[LP0_DATA_PATH] = gta_US_options[gs_US_RateOption].puc_CheckBytes[LP0_DATA_PATH] *
                                          gta_US_options[gs_US_RateOption].uc_S;
            gt_tx_config.s_Mp[LP0_DATA_PATH]  = gta_US_options[gs_US_RateOption].uc_S;
            gt_tx_config.s_Dp[LP0_DATA_PATH]  = gta_US_options[gs_US_RateOption].us_D;

#ifdef INCLUDE_FASTRETRAIN_CODE
         }
         else
            InitTxConfigFromProfile();
#endif

         gt_tx_config.s_FramingMode  = gft_FrameMode;     /*  set framing mode */

         break;

      case G_DMT_BIS:

         // Populating gt_tx_config structure is mostly done in DecodeCParams() function.

         gt_tx_config.s_FramingMode  = G_BIS_MODE;     /*  set framing mode */
         break;
      } // switch(gft_ModemType)

      gt_tx_config.psa_BAT        = guca_TxBat;        /* set BAT table pointer */
      gt_tx_config.psa_FineGains = gsa_TxFineGains;   /* set fine gain pointer */
   }

/* #endif */



   /* Initialize AOC, EOC, and indicator bits data. */

   if(gft_ModemType == G_DMT_BIS)
   {
      TxOvhdInit();
      InitTxOvhdRegisters();
      TxInitIb_bis();
   }

   TxInit();

#ifdef DEBUG_TRACES
   guc_ShowtimeEnter=1;
#endif
   // XDSLRTFW-1782 : CAPTURE_CONFIGURATION_MESSAGES (START)
      Decode_Config_Info();
   // XDSLRTFW-1782 : CAPTURE_CONFIGURATION_MESSAGES (END)

   //XDSLRTFW-2003 (start_end)
   if(gs_CurrentCoChipset == GSI_CO_CHIPSET)
   {
      //Enable per session reporting
      gt_InteropOptions.us_InterOp_Bits0 |= RESET_CRC_FEC_COUNTERS_AT_LINKSTART_TO_0_FOR_EOC_REPORTING;
   }

   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
   // init gt_RrcStat
    if (gt_ReTxConfigInfo.ft_ReTxOn == 1)
    {
        // these fields must have been initialized during training
        // gt_RrcStat.uc_CWsPerDtu = 30;

        gt_RrcStat.ull_64MostRecentDtuStats = 0;
        gt_RrcStat.ft_RrcStatUpdated = 0;

        // AbsDtuCnt is set to 0x1F so that upon the first DTU received
        // in showtime, it will be incremented to 0
        gt_RrcStat.uc_AbsDtuNum = 0x1F;
    }
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)

#ifndef HERCULES_ADSL_CPE
   /* for g. bis, we will run zephyr as many times as necessary  and hence do not start */
   /* zephyr early for preprocessing of frames in case of multi-frame codeword. this is not */
   /* true for dmt. In dmt we always run zephyr once and hence, in case of multi-frame codewords, */
   /* we have to start zephyr early */
   if (( gl_SelectedMode & (MODE_ADSL2)  ))
   {
      int16 sa_AZRunCnt[NUM_DATA_PATHS];
      int l_TxMuxFrameCount = 0;

      gs_TxPMDFrameCnt = TX_SYMBOLS_PER_SFRAME; /* initialize */
      for(i=0; i< NUM_DATA_PATHS; i++)
      {
         sa_AZRunCnt[i] = 0;
      }
      for(i=0; i<MAX_AZ_RUNS; i++)
      {
         gsa_ItSizeRegValue[i] = 0;
      }
      gs_maxAZRunCnt = 0;

      gs_AZRunCnt = 0;
      s_k = 0;
      for(i=0; i<gt_tx_config.s_Nlp; i++)
      {
         int16 s_NBits_In_RateBuffer=0, s_TransferSize, s_maxAZRunCnt;
         int16 s_den;
         int l_extrabits_needed, l_bits_generated;
         int32 ul_num;

         MULU16(ul_num, gt_tx_config.s_Mp[i], gt_tx_config.s_Lp[i]);
         //s_maxAZRunCnt = ceil(Mp/Sp)
         s_den = gt_TxShowTimeVars.t_FrameParms[i].s_CodewordSize<<3;
         s_maxAZRunCnt = 0;
         if (s_den == 1)
            s_maxAZRunCnt = (int16)ul_num;
         else {
            while (ul_num >= s_den) {
               ul_num -= s_den;
               s_maxAZRunCnt++;
            }
            if (ul_num != 0)
               s_maxAZRunCnt++;
         }

         if (s_maxAZRunCnt > gs_maxAZRunCnt)
            gs_maxAZRunCnt = s_maxAZRunCnt;

         gs_total_extrabitsNeeded = 0;
         do
         {
            l_extrabits_needed = 0;
            s_TransferSize = 0;
            l_bits_generated = 0;

            for (j = 0; j < s_maxAZRunCnt; j++)
            {

               /* Compute Transfer size for next PMS run */
               /* if (mux_frame_count == (Mp -1)   */
               /*    s_TransferSize = Kp + Rp      */
               /* else                       */
               /*    s_TransferSize = Kp;          */
               if(l_TxMuxFrameCount == (gt_tx_config.s_Mp[i] -1))
               {
                  s_TransferSize = gsa_TxMuxFrameSize[i][1];
                  l_TxMuxFrameCount = 0;
               }
               else
               {
                  s_TransferSize = gsa_TxMuxFrameSize[i][0];
                  l_TxMuxFrameCount++;
               }

               l_bits_generated += s_TransferSize << 3;
            }

            l_extrabits_needed = gt_tx_config.s_Lp[i] - l_bits_generated;
            if (l_extrabits_needed > 0)
               gs_total_extrabitsNeeded += l_extrabits_needed;


         }while (l_extrabits_needed > 0);

         l_TxMuxFrameCount = 0;

         /* get the AZ Run Cnt for pre-processing*/
         while(s_NBits_In_RateBuffer < gs_total_extrabitsNeeded)
         {
            /* Compute Transfer size for next PMS run */
            /* if (mux_frame_count == (Mp -1)   */
            /*    s_TransferSize = Kp + Rp      */
            /* else                       */
            /*    s_TransferSize = Kp;          */
            if(l_TxMuxFrameCount == (gt_tx_config.s_Mp[i] -1))
            {
               s_TransferSize = gsa_TxMuxFrameSize[i][1];
               l_TxMuxFrameCount = 0;
            }
            else
            {
               s_TransferSize = gsa_TxMuxFrameSize[i][0];
               l_TxMuxFrameCount++;
            }

            gsa_TxMuxFrameCount[i] = l_TxMuxFrameCount;

            /* Initialize variables- These are used in StartRxDataPump_BIS() to determine transfer size*/
            gusa_ACfgRegValue[sa_AZRunCnt[i]] |= gusa_PreconfigACfgTx[i];
            gusa_ZtLineRegValue[sa_AZRunCnt[i]] |= ((1<<11)<<i);
            gsa_ItSizeRegValue[sa_AZRunCnt[i]] |= (s_TransferSize << (8*i));

            s_NBits_In_RateBuffer += (s_TransferSize << 3); /* convert to bits */
            sa_AZRunCnt[i]++;
         }

         if (gs_AZRunCnt < sa_AZRunCnt[i]) gs_AZRunCnt = sa_AZRunCnt[i];
      }
      if (gs_AZRunCnt>0) s_k=1;
#ifdef DEBUG_AZRUN
      gs_preAZRunCnt = gs_AZRunCnt;
#endif

   }
   else
   {

      gs_MuxFrameCntTxFastPath = TX_SYMBOLS_PER_SFRAME; /* initialize */

      /* Compute the number of early start frames, k, to avoid underflow of output buffer */
      /* Criterion: Choose k such that k*s_FecFrameSize >= (S-1)*(N-K*D) */
      /* (S: NUM of symbols per CW; N: FecFrameSize; K:MuxFrameSize; D:Interleave Depth */
      s_FecFrameSize = gt_TxShowTimeVars.t_FrameParms[LP0_DATA_PATH].s_FecFrameSize;
      s_MuxFrameSize = gt_TxShowTimeVars.t_FrameParms[LP0_DATA_PATH].s_MuxFrameSize;
      s_IntlvDepth = gt_tx_config.s_Dp[LP0_DATA_PATH];
      s_total_overhead_bytes = (gt_tx_config.s_Mp[LP0_DATA_PATH] - 1) * (s_FecFrameSize - s_MuxFrameSize * s_IntlvDepth);
      s_k = 0;
      while(s_total_overhead_bytes > (s_k*s_FecFrameSize) )
         s_k++;
   }

   return(s_k);
#else    //HERCULES
   if (( gl_SelectedMode & (MODE_ADSL2)  ))
   {
      gs_TxPMDFrameCnt = TX_SYMBOLS_PER_SFRAME; /* initialize */
   }
   else
   {
      gs_MuxFrameCntTxFastPath = TX_SYMBOLS_PER_SFRAME; /* initialize */
   }
   return(0);
#endif
}


void BgInitShowTimeTx(void)
{
   /* Initialize Showtime TX, where gs_num_preproc_frames */
   /* is the number of frames which should be processed before SHOWTIME */
   /* to avoid underflow of output */
   gs_num_preproc_frames = InitShowTimeTx();
   guc_ShowTimeTxState = TRAINING_DONE;
}
