/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             showtime_dmt.c
 * DESCRIPTION:      Functions that implement the Rx showtime non-time critical tasks.
 *
 **********************************************************************/
// ******************************************************************
// showtime_dmt.c
//
// History
//
// 06/08/10 Nihar: Added code to delay DS BitSwap
//       for all DSLAMs in DMT mode. Grep for the following
//       (i) IOP_DS_DMT_ALL_EnableDsBitSwap
//
// 10/08/2010 Nihar: Clear Persistent memory bit which was being used to get
//            Reduced C-RATES-RA option in ADSL1 Mode. Grep for
//            PERF_DS_DMT/T1413_ALL_ReduceBmaxInRMsgRA_ToGetLessCratesRAOptions
//
// 02/08/2011 Vinjam: LOS due to CRC count is taken out.
//                    LOS is triggered only with drop in pilot power.
//                    Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//
// 23/08/2011 Vinjam: detect_LOS( ) routine is called for every symbol.
//                    call to detect_LOS( ) routine is taken out from sync symbol handler
//                    It is placed in show tme NTC task function.
//                    Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
// 19/08/2011 Sriram : Enabled Bitswap for g.dmt mode for all DSLAM
//       Grep for XDSLRTFW-325 BugFix_ALL_DMT_ALL_EnableBitSwap
//
// 06/09/2011 Vinjam: Report LOS Due to DS CRC through a CMV PLAM 0 0 Bit-14 (Mask: 0x4000)
//                    Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//26-03-2013 Anantha: Logic added to trigger bitswap over stored SNR to increase bitswap speed
//             during RFI test
//          grep pattern XDSLRTFW-686: PERF_DS_DMT_ALL_Bitswap
//
// 25/06/2013 Kannan:
//            DEC Rx Samples capture state machine is controlled through
//            intermediate DEC state variables to control DEC Capture
//            HW state machine. This is required to avoid DEC HW state machine
//            to be in intermediate state indefinetely.
// Grep for XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest.
//
// 10/04/2014 Sriram Shastry: To avoid showtime link drop and long training time against ECI/Pulsecom DSLAM
//      at AT&T lab with AT&T capped US/DS lower data rates profiles, the following changes are introduced:
//      (1) US Tx powercutback by 4dB on all loops to avoid US linkdrop.
//      (2) Preferred to select pilot tone #48 and reduced the pilot power threshold
//          to avoid US/DS link drop due to polit tone corruption.
//      (3) Limited US max bits/bin to 8.
//      The above changes are protected by PLSE CO vendor ID and CMV
//      info 103 26 0x0800 with default value 0 (Disabled).
//      Enabling the CMV bit may introduce side-effects for both US and DS performance.
//      It is only recommended for AT&T profiles with the capped US/DS lower data rates
//      attached in the Jira entry.
//         Grep for ADSLRTFW-1412_XDSLRTFW-1591_IOP_A_DS_ADSL1_ECI_PLSE_LinkDrop
//
//  2/12/2015 Sriram Shastry : Observed Quartz instabilities with  AVM  fritzbox[7490]. Added Detection algorithm for frequency drift and  phase drift
//  such that PLL adapt's to  fast setting  instead of  showtime setting .It helps to avoid showtime link drops in field
//
// Grep for : XDSLRTFW-2464
//
// *****************************************************************************************

#include <stdio.h>
#include "stdlib.h"
#include "common.h"
#include "gdata.h"
#include "xgdata.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "tx_eoc.h"
#include "aoc.h"
#include "aoc_ini.h"
#include "pn_tab.h"
#include "states.h"
#include "mtkernel.h"
#include "enc_gain.h"
#include "dec_gain.h"
#include "tx_m3oh.h"
#include "rx_m3oh.h"
#include "rt_tones.h"
#include "rt_state.h"
#include "ib.h"
#include "tx_ib.h"
#include "rx_ib.h"
#include "synsymbl.h"
#include "datasymbl.h"
#include "tone_ord.h"
#include "bitload.h"
#include "fifo.h"
#include "cmv.h"
#include "mp.h"
#include "dslengin.h"
#include "qos.h"
#include "rx_eoc.h"
#include "rx_eoc1.h"
#include "rx_aoc.h"
#include "dec_adap.h"
#include "pll.h"
#include "timercov.h"
#include "bitswap.h"
#include "tx_aoc.h"
#include "rx_aoc.h"
#include "tx_plam.h"
#include "rx_plam.h"
#include "prf_man.h"
#include "bert.h"
#include "detect.h"
#include "RRecovTxF.h"
#include "RCRecovRxF.h"
#include "showinit_olr.h"
#include "trail.h"
#include "impulse_detect.h"
#include <string.h>

//XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (Start_End)
extern uint8  guc_RxDecCaptureState;


#ifdef COLLECT_SYNCSYMBOL_INFO
   extern void CollectSyncSymbols(void);
#endif

#ifdef COLLECT_SHOWTIME_EVENTS_INFO
   extern void CollectBadSyncSymbols(void);
#endif
// IOP_DS_DMT_ALL_EnableDsBitSwap (Start)
#ifndef ISDN   // Only for Anx-A
extern void Check_DsBitSwapTimeWindow(void);
#define FIRST_BITSWAP_SFRAMES_DELAY 50
#define NEXT_BITSWAP_SFRAMES_DELAY  20
#define FIRST_BITSWAP_SFRAMES_DELAY_CTLM 2000
#define NEXT_BITSWAP_SFRAMES_DELAY_CTLM  200
#endif // ifndef ISDN
// IOP_DS_DMT_ALL_EnableDsBitSwap (End)
extern void Check_RxCellDelineation(void);

/*****************************************************************************
;  Subroutine Name: RShowtimeRxF_DMT
;
;  This subroutine runs RX state to perform the following
;  operations:
;     process synchronization symbol (SNR calculation and FDQ adaptation)
;     perform QAM decoding
;     perform deinterleaving
;     perform Reed Solomon decoding
;     perform descrambling
;     perform CRC check
;     extract sync byte
;     perform byte flip
;
;  Prototype:
;     void RShowtimeRxF_DMT(void);
;
;  Arguments:
;     none
;
;  Global Variable Used By This File:
;     gs_CRC_err_count  -- CRC error count
;     gsa_RxToneBuf[]      -- RX tone buffer
;     gsa_FFT_InBuf[]      -- buffer of input samples to FFT
;     gt_TDQInput       -- TDQ interface structure
;
;****************************************************************************/
extern uint16 gus_last_crc_cnt;  //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)
// XDSLRTFW-325 BugFix_ALL_DMT_ALL_EnableBitSwap (Start_End)
int16 gs_bitswap_rx_sframe_count_4_times =0;
void RShowtimeRxF_DMT(void)
{


   int16 s_LPath, s_ActiveLPath, s_deltaCnt;
   int16 s_temp_snr, s_temp_SnrDiff;//SMS00838915:DS_PERF_ALL_PllSnrThresshold (START END)

   gul_TotalRxDataFrameCnt++;       // Increment count of total showtime Rx frames.
//#ifdef ISDN
   UpdatePLLAdaption(gsa_RxPilotTone);    /* XDSLRTFW-2464 */
//#endif
   gus_4096SymbolCnt = (gus_4096SymbolCnt+1) & 0xFFF;
   // Get the 1 sec timer based on the showtime Rx Frames, exclude 1 frame per superframe
    if(gs_RxPMDFrameCnt_FftFdqBufferSymbol !=  RX_SYMBOLS_PER_SFRAME)
   gus_1Sec_RxShowtimeFrameCnt++;
   if (gus_1Sec_RxShowtimeFrameCnt == FRAME_COUNT_FOR_ONE_SEC)
   {
      gus_1Sec_RxShowtimeFrameCnt = 0;
      if (gs_DD_1SecFdqUpdateCount < gs_DD_min1SecFdqUpdateCount)
         gs_DD_min1SecFdqUpdateCount = gs_DD_1SecFdqUpdateCount;
      gs_DD_1SecFdqUpdateCount = 0;
   }

   /* ============================================================================= */
   /*  Note: All EC, TDQ, FFT and FDQ operations are done in RunModem() and GetRxTones() */
   /* ============================================================================= */
    if (gft_ShowTimeFirstPassRx == 0)
   {
      gft_ShowTimeFirstPassRx = 1;
        // XDSLRTFW-1481 (Start)
        gt_DS_StPilotDescriptorTable.s_NumPilotTones = 1;
        gt_DS_StPilotDescriptorTable.s_PilotTones = gs_PilotToneIdx;
        // XDSLRTFW-1481 (End)

      if (OPTNArray[OPTN_AlgControl2] & OPTN_ForceAutoBitswap)
      {
         OPTNArray[OPTN_AlgControl] &= ~OPTN_DSAutoBitSwapDisable;
      }
      else
      {
         // Only enable Auto Bitswap when we run against ALCATEL and BRCM CO
            //if ((gs_CurrentCoChipset != ALA_CO_CHIPSET) &&
            // (gs_CurrentCoChipset != BDCM_CO_CHIPSET)&&
            // (gs_CurrentCoChipset != TI_CO_CHIPSET) &&
            // (gs_CurrentCoChipset != IFTN_CO_CHIPSET) &&
            // (gs_CurrentCoChipset != GSI_CO_CHIPSET) )
            // OPTNArray[OPTN_AlgControl] |= OPTN_DSAutoBitSwapDisable;


            // IOP_ALL_GLite_ALL_DisableAllBitswaps (Start)
         // XDSLRTFW-325 BugFix_ALL_DMT_ALL_EnableBitSwap (Start_End)
         if (STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_AB)
         {
            OPTNArray[OPTN_AlgControl] |=(OPTN_DSAutoBitSwapDisable | OPTN_USBitSwapDisable);
         }
            // IOP_ALL_GLite_ALL_DisableAllBitswaps (End)

            // IOP_DS_DMT_ALL_EnableDsBitSwap (Start)
#ifndef ISDN   // Only for Anx-A
            if (!(OPTNArray[OPTN_AlgControl] & OPTN_DSAutoBitSwapDisable))
            {
                //Increased waiting time before initiating DS bitswap against CTLM

                //Applied the logic to all CTLM CO in AnnexA based on AR7 IOP workaround.
                if (gs_CurrentCoChipset == CTLM_CO_CHIPSET)
                {
                    guc_TimeWindow_DS_BitSwaps = FIRST_BITSWAP_SFRAMES_DELAY_CTLM;
                    guc_TimeWindow_DS_BitSwaps_Delay = NEXT_BITSWAP_SFRAMES_DELAY_CTLM;
                }
                else
                {
                    // Provide 50 superframes delay for the first bitswap &
                    // provide 20 superframes dealy between the bitswap requests.
                    guc_TimeWindow_DS_BitSwaps = FIRST_BITSWAP_SFRAMES_DELAY;
                    guc_TimeWindow_DS_BitSwaps_Delay = NEXT_BITSWAP_SFRAMES_DELAY;
                }
                OPTNArray[OPTN_AlgControl] |= OPTN_DSAutoBitSwapDisable;
            }
#endif // ifndef ISDN
            // IOP_DS_DMT_ALL_EnableDsBitSwap (End)
        }
    }
   if (gft_RestoreShowtimeBGState == 1)
   {
      gft_RestoreShowtimeBGState = 2;
#ifdef TARGET_HW
      //ChihWen: VRX518 DMT AnxB bring up (START_END)
      //gft_DECAdaptDisable = 1;
      /* Enable DEC adaptation if not disabled. */
      if (gft_DECAdaptDisable ==0)
      {
         /* Enable DEC adaptation */
         guc_DECAdaptationState = DEC_ADAPTATION_INITIALIZE;
      }
#endif

#ifdef PCM_INTERFACE_SUPPORT
   if (CNTLArray[CNTL_ME_HDLC] & CNTL_ME_Start_PCM)
   {
      // Start PCM state m/c state
      if (guc_PCMState == 0)
         guc_PCMState = 1;
   }
#endif   //#ifdef PCM_INTERFACE_SUPPORT

      //enable showtime processing state machine
      OLRPM_RxPostProcessing(0);
      STATArray[STAT_Misc] |= STAT_AllCodeSwapsDone;
#ifndef ISDN   // Only for Anx-A
        // Clear the bit in showtime, because there may be an intentional CO(Gmx) retrain in the
        // Training.
        // PERF_DS_DMT/T1413_ALL_ReduceBmaxInRMsgRA_ToGetLessCratesRAOptions
        gus_Persistent_UserDefBits &= (~REDUCE_BMAX_IN_RMSGRA_FOR_ADSL1);
#endif // ifndef ISDN
//ADSLRTFW-1412_XDSLRTFW-1591_IOP_A_DS_ADSL1_ECI_PLSE_LinkDrop  (START)
#ifndef ISDN   // Only for Annex-A
   gft_workaround_ECI_PLSE = FALSE;
#endif // ifndef ISDN
//ADSLRTFW-1412_XDSLRTFW-1591_IOP_A_DS_ADSL1_ECI_PLSE_LinkDrop  (END)
   }

    /* Do EOC Processing in NTC task */
   RxEocProcessor();

   /* Do AOC Processing in NTC task */
   RxAocProcessor();

   //SMS00914848 DS_PERF_ALL_PllSnrThresshold (START)
   if ( (OPTNArray[OPTN_AlgControl3] & CMV_TO_ENABLE_TEMPCHAMBER_PLL_THRESSHOLD)
      && (!(gul_TotalRxDataFrameCnt % 8192 )) && (gul_TotalRxDataFrameCnt > 4000) )
   {
         s_temp_snr = gsa_RxShowtimeSnrBuf[gs_PilotToneIdx];

      if ( (s_temp_snr > 0) && (gs_pilot_STsnr_avg > 0) )
      {
            s_temp_SnrDiff = s_temp_snr - gs_pilot_STsnr_avg;

         s_temp_SnrDiff = abs((int32) s_temp_SnrDiff);//+ve

         if (s_temp_SnrDiff > 0x0500) //>5db
         {
            gs_pilot_STsnr_avg = (gs_pilot_STsnr_avg + s_temp_snr) >> 1;//Avg of SNR's

         gs_pilot_snir_threshold = gs_pilot_STsnr_avg - 0x0A00; //10dB = 10 * 256

            if(gs_pilot_snir_threshold < 0)
               gs_pilot_snir_threshold = 0;  //restricting min value to 16*256=4096=16dB
         }

      }
      else
      {
            gs_pilot_STsnr_avg = s_temp_snr;
      }
   }
   //SMS00914848 DS_PERF_ALL_PllSnrThresshold (END)


   /* Activate Rx data capture for DEC adaptation */
   if (guc_DECAdaptationState != DEC_ADAPTATION_DISABLED)
   {
#ifdef ADSL_62
      // The DEC Capture Enable should be set in advance of setting the Sync Frame bit in the V_RX_EXTEN register
      //XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (Start)
      if ((gs_MuxFrameCntRxFastPath == RX_SYMBOLS_PER_SFRAME - DECADAPT_PRESTART-5) && (guc_DECCoefDnloadFlag == WAIT)
         && (guc_RxDecCaptureState == 0) && (guc_DECRxCaptureFlag == START))
      {
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,ActivateDECAdaptationRxCapture);
         guc_RxDecCaptureState = 1;
      }
      else if ((gs_MuxFrameCntRxFastPath == RX_SYMBOLS_PER_SFRAME - DECADAPT_PRESTART) && (guc_DECCoefDnloadFlag == WAIT)
               && (guc_RxDecCaptureState == 1))
      {
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,SetRxSyncFrame);
         guc_RxDecCaptureState = 2;
      }
      else if ((gs_MuxFrameCntRxFastPath == RX_SYMBOLS_PER_SFRAME - DECADAPT_PRESTART + 1) && (guc_DECCoefDnloadFlag == WAIT)
               && (guc_RxDecCaptureState == 2))
      {
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,SupressDECAdaptationRxCapture);
         guc_RxDecCaptureState = 3;
      }
      else if ((gs_MuxFrameCntRxFastPath == RX_SYMBOLS_PER_SFRAME-1) &&(guc_DECCoefDnloadFlag == WAIT) &&(gs_TxState == R_SHOWTIME_TX)
                && (guc_RxDecCaptureState == 3))
      {
         /* Copy captured Rx and Tx data for DEC adaptation from the engine to the task layer. */
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,GetDECAdaptationRxData);
      }
      //XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (End)
#else
      if ((gs_MuxFrameCntRxFastPath == RX_SYMBOLS_PER_SFRAME - DECADAPT_PRESTART) && (guc_DECRxCaptureFlag == START))
      {
         guc_DECRxCaptureFlag = ACTIVE;
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,ActivateDECAdaptationRxCapture);
      }
      else if (gs_MuxFrameCntRxFastPath == RX_SYMBOLS_PER_SFRAME - DECADAPT_PRESTART +1)
      {
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,SupressDECAdaptationRxCapture);
      }

#endif //#ifdef ADSL_62
   }

    //XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start)
    /* Detect LOS */
    if (guc_LOSDetectState == LOS_DETECT_ENABLED)
    {
      detect_LOS();
   }
    //XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (End)

   if(gs_MuxFrameCntRxFastPath == (RX_SYMBOLS_PER_SFRAME - 1))
   {
      gs_bitswap_rx_sframe_count++;
      if(gs_bitswap_rx_sframe_count == MAX_SFRAME_COUNT)
      {
         gs_bitswap_rx_sframe_count = 0 ;

         // DMT workaround for "Lock up" issue
         s_LPath = STATArray[STAT_ACTIVEBCLP_DS] & 0xFF;
         s_ActiveLPath = s_LPath - 1;

            ////XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start)
         // set gus_last_crc_cnt to the SW-initialized CRC-count value once at showtime-start
         if (gus_last_crc_cnt == 0)
            gus_last_crc_cnt = gusa_CRC_count[s_ActiveLPath];
         // assume no overflow, we could consider overflow situation,
         // but don't know whether it is worthwhile for this situation
         s_deltaCnt = gusa_CRC_count[s_ActiveLPath] - gus_last_crc_cnt;
            //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (End)


#if 0
         if (!(TESTArray[TEST_SuppressErrorReportingToME] & TEST_SuppressCRCBasedLosToME) &&
            s_deltaCnt >= 250)
         {
            // report LOS failure to ME if the cmv is not set
            gs_NearEndFailure |= PLAM_LOS_FailureBit;

                //XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start_End)
                //Report LOS due to DS CRC
                gs_NearEndFailure |= PLAM_LOS_DueToCRC_FailureBit;

            gs_los_cnt++;     /* Count of LOS defects per second */

            gt_TxIbData.uc_flos_def = PRESENT;
         }
#else
      // XDSLRTFW-325 BugFix_ALL_DMT_ALL_EnableBitSwap (Start)
      if (!(TESTArray[TEST_SuppressErrorReportingToME] &
                 TEST_SuppressCRCBasedLosToME) && s_deltaCnt >= 250)
            {
               gs_bitswap_rx_sframe_count_4_times++;
               if (gs_bitswap_rx_sframe_count_4_times > 4)
               {
                  gs_bitswap_rx_sframe_count_4_times = 0;
                  // report LOS failure to ME if the cmv is not set
                  gs_NearEndFailure |= PLAM_LOS_FailureBit;

                  //XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start_End)
                  //Report LOS due to DS CRC
                  gs_NearEndFailure |= PLAM_LOS_DueToCRC_FailureBit;

                  gs_los_cnt++;  /* Count of LOS defects per second */
                  gt_TxIbData.uc_flos_def = PRESENT;
            // Pending Job.
                // gt_INFX_FW_REBOOT_CMV.s_RebootIndication |= CMV_REBOOT_NE_LOS_DUE_TO_CRC;
               }  // if (gs_bitswap_rx_sframe_count_4_times > 4)
            }  // if (!(TESTArray[TEST_SuppressErrorReportingToME] & TEST_SuppressCRCBasedLosToME)
               // &&
            else
            {
               gs_bitswap_rx_sframe_count_4_times = 0;   // reset the counter
            }
#endif
      // XDSLRTFW-325 BugFix_ALL_DMT_ALL_EnableBitSwap (End)
         gus_last_crc_cnt = gusa_CRC_count[s_ActiveLPath];  //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)
      }

      /* Check to see if RX Bit Swap should be performed    */
      if(gft_RxBitSwapFlag == TRUE)
         CheckForRxBitSwap();
   }

    /* ================================================================    */
   /*  when gs_MuxFrameCntRxFastPath, captured in the previous TC task,    */
   /* indicates a Sync Frame, then call the SyncSymbolHandler routine.  */
   /* ================================================================     */
   if(gs_MuxFrameCntRxFastPath == RX_SYMBOLS_PER_SFRAME)
    {
        // IOP_DS_DMT_ALL_EnableDsBitSwap (Start)
#ifndef ISDN   // Only for Anx-A
        if (OPTNArray[OPTN_AlgControl] & OPTN_DSAutoBitSwapDisable)
        {
            Check_DsBitSwapTimeWindow();
        }
#endif // ifndef ISDN
        // IOP_DS_DMT_ALL_EnableDsBitSwap (Start)
      /* ========================================================================= */
      /* Process synchronization symbol */
      /* ========================================================================= */

#ifdef COLLECT_SYNCSYMBOL_INFO
      CollectSyncSymbols();
#endif

#ifdef COLLECT_SHOWTIME_EVENTS_INFO
      CollectBadSyncSymbols();
#endif

      /* if gft_RxinitSwap == NO_CODESWAP, then the SynchSymbolHandler code   */
      /* is always present.  If gft_RestoreShowtimeBGState == 2, then the     */
      /* SynchsymbolHandler has been swapped in.  Either case indicates    */
      /* that the function may be called. */

      if ((gft_RxinitSwap == NO_CODESWAP)|| (gft_RestoreShowtimeBGState == 2)){
         SynchSymbolHandler(gsa_RxToneBuf);
      }

      /* ========================================================================= */
      /* Initiate/Perform RX Bit Swap if desired */
      /* ========================================================================= */

      if(TESTArray[TEST_Control] & TEST_TestBitSwap)
      {
         /* If no outstanding TX AOC message  */
         if(gft_SendAocMsg_Flag == IDLE)
         {
            /* If the SNR margin exceeds bit-swap threshold, initiate Bit Swap by */
            /* setting gft_SendAocMsg_Flag to OUTSTANDING */
            //assigned the correct showtime SNR buffer address, for AnnexC compatibility
            gpsa_RxShowtimeSnrBuf = gsa_RxShowtimeSnrBuf;
            AddFunctionToBkgdFifo((PtrToBkgdFunc)RxBitSwapDecision);
         }
      }
      else if(!(OPTNArray[OPTN_AlgControl] & OPTN_DSAutoBitSwapDisable))
      {

         /* If the following flag == TRUE, the SNR buffer has been updated */
         //XDSLRTFW-686: PERF_DS_DMT_ALL_Bitswap(start)
         if(gft_ShowtimeSnrUpdateFlag == TRUE)
         {
            gft_InvalidSNR = 1;

            memcpy(gpsa_TempSnrBuff, gsa_RxShowtimeSnrBuf, 256*2);
            /* reset flag to false */
            gft_ShowtimeSnrUpdateFlag = FALSE;
         }
         // flag  gft_InterimStrdSNRBitswapOn will be one during RFI noise is injected
         if(!gft_BitswapAlgoExcecutionInProgress &&
            (gft_InterimStrdSNRBitswapOn || (gft_InvalidSNR == 1)))
         {
            gft_InvalidSNR = 0;
            /* If no outstanding TX AOC message  */
            if(gft_SendAocMsg_Flag == IDLE)
            {
               gft_BitswapAlgoExcecutionInProgress = 1;
               /* If the SNR margin exceeds bit-swap threshold, initiate Bit Swap by */
               /* setting gft_SendAocMsg_Flag to OUTSTANDING */
               //assigned the correct showtime SNR buffer address, for AnnexC compatibility
               gpsa_RxShowtimeSnrBuf = gpsa_TempSnrBuff;
               AddFunctionToBkgdFifo((PtrToBkgdFunc)RxBitSwapDecision);
            }
         } /* if(gft_ShowtimeSnrUpdateFlag == TRUE) */
         //XDSLRTFW-686: PERF_DS_DMT_ALL_Bitswap(end)
      } /* if(!(OPTNArray[OPTN_AlgControl] & OPTN_DSAutoBitSwapDisable))  */



#ifdef INCLUDE_FASTRETRAIN_CODE
      /* ============================================================================= */
      /* Try to detect C_Recov from ATU-C */
      /* ============================================================================= */
      if ((STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_AB) || (STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_C)) {
         if( DetectTone(gsa_RxToneBuf, C_RECOV_TONE, C_RECOV_TONE_MIN, C_RECOV_TONE_MAX, (DETECT_SCALE*256)) ) {
            gs_RCRecovBurstCnt++;
         }
         else {
            gs_RCRecovBurstCnt = 0;
         }

         /* =============================================== */
         /*  get ready for fast retrain */
         /* =============================================== */
         if ((OPTNArray[OPTN_AlgControl] & OPTN_ForceFR) ||
            (gs_RCRecovBurstCnt == R_C_RECOV_BURST_CNT) ||
            ((gft_FR_trigger_on_CRC == TRUE) && (gs_CRCi_burst_count > CRC_BURST_THRESHOLD))) {

            /*  set next states */
            gs_RxNextState = R_C_RECOV_RX;
            gpF_RxStateFunc = (PtrToFunc)RCRecovRxF;

            /* shut down Rx processing after FFT and remove Rx cyclic prefix */
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,RemoveRxCP);
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,Disable_MTE_Rx);
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,DisableRxFraming);

            /* Switch time critical task for FDQ done interrupt. */
            gt_TaskArray[RX_FDQ_DONE].TimeCriticalTask = RxProcessTones;
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, EnableFDQDoneInterrupt);
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, DisableQAMDoneInterrupt);
         }
      }
#endif

      /* put indicator bits into global struct RxIbData and initiate PLAM processing */
      RxIbProcessor();

      /* Update super frame count */
      gl_rx_sframe_count++;



#ifdef DO_PLAM
      /* Rx PLAM function */
      RxPlamProcessor();
#endif /* DO_PLAM */

   }
    /* =======================================================================   */
   /* Else indicates a Data Frame,                                */
   /* ======================================================================= */
   else
   {
      /* ======================================================================= */
      /* do snr and fdq updates                                      */
      /* ======================================================================= */
      if ((gft_RxinitSwap == NO_CODESWAP)|| (gft_RestoreShowtimeBGState == 2)){
         DataSymbolHandler();
      }

      /* ======================================================================= */
      /* do BERT processing if BERT control enabled                        */
      /* ======================================================================= */
#ifndef DISABLE_BERT          /* do BERT processing if BERT controlenabled. */
      if ((TESTArray[TEST_Control] & TEST_BertControl) != 0)
      {
         RxPNSequence();
      }
#endif
   }

   return;
}

/*
#undef s_MuxFrameSizef
#undef s_MuxFrameSizei
*/
