/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             showtime_dmt_tx.c
 * DESCRIPTION:      Functions that implement the showtime non-time critical tasks.
 *
 **********************************************************************/
// ******************************************************************
// showtime_dmt_tx.c
//
// History
//
// 9/09/2011 Anantha Ramu: Added feature to try GHS MAX_ALLOWED_GHS_FAILS times before trying T1413
//                         if T1413 is one of the configured modes in CPE.
//                         Grep for  XDSLRTFW-326 Feature_ALL_Try_GHS_Before_T1413_ALL
//
//
//
// 20/06/2013 Varun : Added code(Debug option) to capture important showtime variables
//                   Grep for "XDSLRTFW-599 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
// 18/11/2014 : Vinay : Added a new CMV (INFO 241) to capture the configuration of ADSL as a debug feature.
//       Grep for XDSLRTFW-1782 : CAPTURE_CONFIGURATION_MESSAGES
//
//********************************************************************************************
#include <stdio.h>
#include "common.h"
#include "gdata.h"
#include "xgdata.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "tx_eoc.h"
#include "aoc.h"
#include "aoc_ini.h"
#include "pn_tab.h"
#include "states.h"
#include "mtkernel.h"
#include "enc_gain.h"
#include "dec_gain.h"
#include "tx_m3oh.h"
#include "rx_m3oh.h"
#include "rt_tones.h"
#include "rt_state.h"
#include "ib.h"
#include "tx_ib.h"
#include "rx_ib.h"
#include "synsymbl.h"
#include "tone_ord.h"
#include "bitload.h"
#include "fifo.h"
#include "cmv.h"
#include "mp.h"
#include "dslengin.h"
#include "qos.h"
#include "rx_eoc.h"
#include "rx_eoc1.h"
#include "rx_aoc.h"
#include "dec_adap.h"
#include "pll.h"
#include "timercov.h"
#include "bitswap.h"
#include "tx_aoc.h"
#include "rx_aoc.h"
#include "tx_plam.h"
#include "rx_plam.h"
#include "prf_man.h"
#include "bert.h"
#include "detect.h"
#include "RRecovTxF.h"
#include "RCRecovRxF.h"
#include "tx_ops2.h"
#include "trail.h"

extern void  Decode_Config_Info(void);
extern void updateShowtimeBuffSymbol(void);
extern void updateShowtimeBuffSuperframe(void);

/* =============================================== */
/* constants used by this file only */
/* =============================================== */
/* define constants to clarify code */



/* #define FAST_SCRAMBLER_DISABLED    */
/* #define INLV_SCRAMBLER_DISABLED */
/* #define FAST_DESCRAMBLER_DISABLED */
/* #define INLV_DESCRAMBLER_DISABLED */
/*
#define s_MuxFrameSizef       gt_TxShowTimeVars.t_FastParms.s_MuxFrameSize
#define s_MuxFrameSizei       gt_TxShowTimeVars.t_InlvParms.s_MuxFrameSize
*/



/*****************************************************************************
;  Subroutine Name: RShowtimeTxF_DMT
;
;  This subroutine controls TX showtime state to perform the following
;   ADSL-TX side operations:
;     process the interleaved path
;       process the fast path
;     perform QAM encoding
;     perform IFFT
;     generate cyclic prefix
;     generate synchronization symbol
;
;  Prototype:
;     void RShowtimeTxF_DMT(void);
;
;  Input Arguments:
;     None

;  Output Arguments:
;       None

;  Global Variables:
;     gt_TxShowTimeVars -- structure containing all following global variables used by tx.c:
;
;       s_D_tx              --  D for interleave depth
:       s_S_tx              --  number of DMT symbols per FEC codeword,
;                               intreleaved path
:       t_FastParms_tx      --  structure of fast path parameters
:       t_InlvParms_tx      --  structure of fast path parameters
;       s_FastPathType_tx   --  = FAST_DATA_PATH
;       s_InlvPathType_tx   --  = INTERLEAVED_DATA_PATH
:       s_Rf_tx             --  number of FEC redundancy bytes, fast path
:       s_Ri_tx             --  number of FEC redundancy bytes, interleaved path
:       s_RawFrameSizef_tx  --  number of payload data bytes per frame,
;                               fast path
:       s_RawFrameSizei_tx  --  number of payload data bytes per frame,
;                               interleaved path
:       s_MuxFrameSizef     --  payload bytes + overhead bytes, fast path
:       s_MuxFrameSizei    --  payload bytes + overhead bytes, interleaved path
:       s_Af_tx             --  Number of AEX bytes in the fast path
:       s_Ai_tx             --  Number of AEX bytes in the interleaved path
:       s_Lf_tx             --  Number of LEX bytes in the fast path
:       s_Li_tx             --  Number of LEX bytes in the interleaved path
:       sa_Bf_alloc         --  Array of bearer channel byte allocations for
;                               the fast path
:       sa_Bi_alloc         --  Array of bearer channel byte allocations for
;                               the interleaved path
:       sa_Bf_out           --  Array of bearer channel bytes to transmit for
;                               the fast path
:       sa_Bi_out           --  Array of bearer channel bytes to transmit for
;                               the interleaved path
;       Ft_C_Chan_Enabledf_tx -- indicates if the 'C' channel is enabled on
;                                LS0 for the fast path
;       Ft_C_Chan_Enabledi_tx -- indicates if the 'C' channel is enabled on
;                                LS0 for the interleaved path
:       s_CodewordSize      --  number of bytes per codeword, interleaved path
:       s_FecFrameSize      --  CodewordSize/S
:       s_CodewordSize_Odd  --  = CodewordSize + 1-(s_CodewordSize&1)
:       psa_BAT_tx          --  pointer to bit loading table
:       psa_FineGains_tx    --  pointer to a table fine gains
;
;   Other Global Variables Used:
;     gsa_TxToneBuf[TX_FFT_LENGTH+2]      - (O) buffer to monitor TX tone
;                                               modified in PostQAMProc()
;     gs_Tx_OutBuf_Size             - (I/O) number of samples written out per frame
;
;****************************************************************************/


void RShowtimeTxF_DMT(void)
{
// XDSLRTFW-1782 : CAPTURE_CONFIGURATION_MESSAGES (START)
   Decode_Config_Info();
// XDSLRTFW-1782 : CAPTURE_CONFIGURATION_MESSAGES (END)

   /* New BERT code */
#ifndef DISABLE_BERT
   if ((TESTArray[TEST_Control] & TEST_BertControl) != 0)
      if (gs_MuxFrameCntTxFastPath != TX_SYMBOLS_PER_SFRAME - 1)
         TxPNSequenceSetup();
#endif

    /* If we have just switched to showtime, re-init buffer sizes */
   /* and switch to use showtime time critical function        */
   if (gft_ShowTimeFirstPassTx==0)
    {
      /* Use this variable to indicate progress of any last BgTasks using */
      /* R_NOSHOW page before we bring in SHOWBG1 and SHOWBG2 pages     */
      /* Currently, there are no Bg process in showtime that makes use of R_NOSHOW */
      guc_BkgdTaskState = BKGDTASK_DONE;

      gft_ShowTimeFirstPassTx=1;
      if (gft_ModemType == G_DMT_BIS)
         gt_TaskArray[TX_FRAME_START].TimeCriticalTask=RShowtimeTxTC_BIS_A;
      else
         gt_TaskArray[TX_FRAME_START].TimeCriticalTask=RShowtimeTxTC_DMT;
      /* ================================================================================= */
      /* Generate synch symbol (the reverb signal) */
      /* ================================================================================= */
      Gen_Reverb_Ref_fd(gsa_Showtime_TxToneBuf, GEN_REVERB_TYPE_RT, (int16)(gs_TxFftLength>>1), gs_TxFirstChannel, gs_TxLastChannel, gs_TxSyncFrameGain);
   }

#ifdef INCLUDE_FASTRETRAIN_CODE
   if ((STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_AB) || (STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_C)) {
      /* Check if we should go to fast retrain . */
      if(gs_RxNextState == R_C_RECOV_RX) {

         /*  set next state */
         gs_TxNextState = R_RECOV_TX;

         gpF_TxStateFunc = (PtrToFunc)RRecovTxF;

         /* shut down Tx path before IFFT and remove Tx cyclic prefix */
         gft_TxDataPump_On = FALSE;
         AddFunctionToFifo(gp_TxLoadingFunctionFifo,RemoveTxCP);
         AddFunctionToFifo(gp_TxLoadingFunctionFifo,Disable_MTE_Tx);
         AddFunctionToFifo(gp_TxLoadingFunctionFifo,DisableTxFraming);

         /* Switch time critical task for Tx frame start interrupt. */
         gt_TaskArray[TX_FRAME_START].TimeCriticalTask = TxProcessTones;

      }
   }
#endif

#ifdef DEBUG_TRACES

   //XDSLRTFW-599 FEATURE_ALL_ALL_ALL_Debug_Buffer(START)
      if(((STATArray[STAT_MacroState] == STAT_ShowTimeTCSyncState) || (STATArray[STAT_MacroState] == STAT_ShowTimeState)) && (((gs_MuxFrameCntTxFastPath+1)%gt_DebugBuffControl.s_debugBuffer_STCaptureXSymbol)==0) && (guc_IntoL2!=1))
         updateShowtimeBuffSymbol();

         if((gs_MuxFrameCntTxFastPath == TX_SYMBOLS_PER_SFRAME) && ((STATArray[STAT_MacroState] == STAT_ShowTimeTCSyncState) || (STATArray[STAT_MacroState] == STAT_ShowTimeState))&& (guc_IntoL2!=1))
            updateShowtimeBuffSuperframe();
//XDSLRTFW-599 FEATURE_ALL_ALL_ALL_Debug_Buffer(END)

#endif //#ifdef DEBUG_TRACES

   if (gs_MuxFrameCntTxFastPath != (TX_SYMBOLS_PER_SFRAME-1)) {

      // If next frame is a data frame, check whether IB, EOC or AOC bytes will be needed.
      if (gt_TxShowTimeVars.t_FrameParms[LP0_DATA_PATH].s_MuxFrameSize != 0)
      {
         ShowTimeInlvHandler_TX();
      }

      if (gt_TxShowTimeVars.t_FrameParms[LP1_DATA_PATH].s_MuxFrameSize != 0)
      {
         ShowTimeFastHandler_TX();
      }
   }

   /* ===================================================================================== */
   /* Check if there is a bit swap request message to send */
   /* ===================================================================================== */

#ifdef INCLUDE_FASTRETRAIN_CODE
   if ((STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_AB) || (STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_C))
   {
      Check_SendPMR();
   }
   else
   {
#endif
      if(gft_SendAocMsg_Flag == OUTSTANDING)
      {
         if(TxAocMsgPut(&gt_TxAocMsgBSR) == SUCCEED)
            gft_SendAocMsg_Flag = SUCCEED;
      }

#ifdef INCLUDE_FASTRETRAIN_CODE
   }
#endif

   if (gs_MuxFrameCntTxFastPath == (TX_SYMBOLS_PER_SFRAME-1)) {

   /* The gs_MuxFrameCntTxFastPath is read during the prior */
   /* TC task.  Therefore the current NTC task is actually setting up s_out_frame_number + 1 */
   /* In this particular case, the SetUp function is called to load TxToneBuf[] at frame     */
   /* 67, which is subsequently used to generate the SYNC frame for frame 68              */

      /* Update super frame count */
      gs_bitswap_tx_sframe_count++;
      if(gs_bitswap_tx_sframe_count == MAX_SFRAME_COUNT)
         gs_bitswap_tx_sframe_count = 0;

      gl_tx_sframe_count++;
      gs_tx_sframe_count_lsw = (gl_tx_sframe_count) & 0x0000FFFF;
      gs_tx_sframe_count_msw = ((gl_tx_sframe_count) >> 16) & 0x0000FFFF;


      /* Check to see if TX bit swap should be performed */
      if(gft_TxBitSwapFlag == TRUE)
            CheckForTxBitSwap();


#ifdef DO_PLAM
      /* Tx PLAM function */
      TxPlamProcessor();
#endif /* DO_PLAM */
   }

//XDSLRTFW-326 Feature_ALL_Try_GHS_Before_T1413_ALL (Start)
#ifndef ISDN
    if((STATArray[STAT_Mode] & STAT_ConfigMode_T1413) != 0)
    {
        guc_Ghs_fails_count = 0;
    }
#endif
//XDSLRTFW-326 Feature_ALL_Try_GHS_Before_T1413_ALL (End)

   /* DEC adaptation state machine */
   if (guc_DECAdaptationState != DEC_ADAPTATION_DISABLED)
      ControlDECAdaptation();

}
/*
#undef s_MuxFrameSizef
#undef s_MuxFrameSizei
*/



