/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             showtime_tc_dmt.c
 * DESCRIPTION:      Functions that implement the dmt showtime time critical tasks.
 *
 **********************************************************************/
// **********************************************************************************************//
// showtime_tc_dmt.c
//
// History
// 10/01/2010 Abraham Binu : Addition of the transition to state 8(TC Sync) from state 7(No TC Sync)
//                           based on the TC Status indicated in the PPE DREG register DREG_AR_STATx,
//                           bit 1, which has inverted logic, i.e, 0 - TC Sync, 1 - No TC Sync.
//       Grep for SMS01357654
//
// **********************************************************************************************//
#include <stdio.h>
#include "common.h"
#include "gdata.h"
#include "xgdata.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "tx_eoc.h"
#include "aoc.h"
#include "aoc_ini.h"
#include "pn_tab.h"
#include "states.h"
#include "mtkernel.h"
#include "enc_gain.h"
#include "dec_gain.h"
#include "tx_m3oh.h"
#include "rx_m3oh.h"
#include "rt_tones.h"
#include "rt_state.h"
#include "ib.h"
#include "tx_ib.h"
#include "rx_ib.h"
#include "synsymbl.h"
#include "tone_ord.h"
#include "bitload.h"
#include "fifo.h"
#include "cmv.h"
#include "mp.h"
#include "qos.h"
#include "rx_eoc.h"
#include "rx_eoc1.h"
#include "rx_aoc.h"
#include "dec_adap.h"
#include "pll.h"
#include "bitswap.h"
#include "tx_aoc.h"
#include "rx_aoc.h"
#include "tx_plam.h"
#include "rx_plam.h"
#include "prf_man.h"
#include "bert.h"
#include "detect.h"
#include "DSLEngin.h"
#include "trail.h"

#if defined(HERCULES_ADSL_CPE) || defined(AMAZON_SE)
   #define TWO_FFT_BUFFERS       1
   #define  QAM_DISABLED_FRAME       RX_SYMBOLS_PER_SFRAME
   #define SYNC_LOGICAL_BUFFER      DD_FFTFDQ_LOGICAL_BUFFER
   #define  BEFORE_QAM_DISABLED_FRAME       (RX_SYMBOLS_PER_SFRAME-1)
#else
   #define QAM_DISABLED_FRAME 0
   #define SYNC_LOGICAL_BUFFER      DD_GSRCD_LOGICAL_BUFFER
   #define  BEFORE_QAM_DISABLED_FRAME       RX_SYMBOLS_PER_SFRAME
#endif

extern void DisableRxPms(void);
/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void do_atm_processing(void)
*
*   Description:
*     Atm processing (gets atm status)
*     - read hec err and idle/non-idle cell cnts
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
void do_atm_processing_dmt(void)
{
   int16 s_bc, s_latencyPath;
   uint16 us_temp;

   for(s_bc = 0; s_bc < NUM_BEARER_CHANNELS; s_bc++)
   {
      s_latencyPath = gt_RxShowTimeVars.t_BCParms[s_bc].sa_BC_LPath;

      if(s_latencyPath < 0)
         continue;

      /* Get ATM status for each active bearer channel. */
      us_temp = Get_ATM_Status(s_bc);
        if(STATArray[STAT_MacroState] != STAT_FailState)
      {
         //if (((us_temp & 0x2) >> 1) == TRUE)  //OLD Implementation
         //XDSLRTFW-2050
         //Latest Spec for ATM PPE
         //Status Bit 1 = 0 No TC Sync
         //Status Bit 1 = 1 TC Sync
         if (((us_temp & 0x2) >> 1) == FALSE)
         { // SMS01357654 No TC Synch, Inverted logic, 1 - No TC Sync, 0 - TC Sync
            STATArray[STAT_MacroState] = STAT_ShowTimeState;
            gt_HercADSL_STATMap_MacroState.s_Offset0 = STAT_ShowTimeState;
            gusa_HercADSL_MONIMap_Curr[0] = MONI_SHOWTIME_TC_NOSYNC;
         }
         else
         { // TC Sync.
#ifdef TARGET_HW
            STATArray[STAT_MacroState] = STAT_ShowTimeTCSyncState;
            gt_HercADSL_STATMap_MacroState.s_Offset0 = STAT_ShowTimeTCSyncState;
            gusa_HercADSL_MONIMap_Curr[0] = MONI_SHOWTIME_TC_SYNC;
#endif
         } //SMS01357654 - End
      }
      /* Update flags of data path to which the bearer channel is assigned. */
      if(s_latencyPath == FAST_DATA_PATH) {
         if(us_temp & 2)
            //gt_TxIbData.uc_cd_f_flag = FALSE; //inverted logic
            gt_TxIbData.uc_cd_f_flag = TRUE; //inverted logic
         else if(us_temp == 0)
            gt_TxIbData.uc_cd_f_flag = FALSE; //inverted logic

         if(us_temp & 1)
            gt_TxIbData.uc_hec_f_flag = TRUE;
      }
      else if(s_latencyPath == INTERLEAVE_DATA_PATH) {
         if(us_temp & 2)
            //gt_TxIbData.uc_cd_i_flag = FALSE; //inverted logic
            gt_TxIbData.uc_cd_i_flag = TRUE; //inverted logic
         else if(us_temp == 0)
            gt_TxIbData.uc_cd_i_flag = FALSE; //inverted logic

         if(us_temp & 1)
            gt_TxIbData.uc_hec_i_flag = TRUE;
      }



      /*====================================================================*/
      /* Count Near End total cell count */
      /*====================================================================*/
      Get_ATM_Counters(s_bc);

      ResetARCellCnt(s_bc);
   }
}

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void do_sync_frame_processing_dmt(void)
*
*   Description:
*     Data frame processing
*     - do atm processing
*     - Load Fdq
*     - GetRxTones
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
void do_sync_frame_processing_dmt(void)
{
   /* load received indicator bits into 4-byte global variable for later processing */
   GetIndicatorBits();

#ifdef COLLECT_EOCAOCIB_INFO
   CollectIbInfo();
#endif //#ifdef COLLECT_EOCAOCIB_INFO

   /* Collect data for NCD-I/F and HEC-I/F Tx indicator bits */
   gt_TxIbData.uc_cd_i_flag = TRUE; //no anomaly
   gt_TxIbData.uc_cd_f_flag = TRUE; //no anomaly
   gt_TxIbData.uc_hec_i_flag = FALSE;
   gt_TxIbData.uc_hec_f_flag = FALSE;

#ifdef IFX_XTC
   if (gft_AlphaeusSel)
#endif
   do_atm_processing_dmt();

#ifndef HERCULES_ADSL_CPE
#ifndef TARGET_HW
   if (!gft_doDDSnrFdqUpdate)
   {
      /* Load/activate new FDQ coefficients if available.               */
      /* If this takes too long, it will need to be delayed or broken      */
      /* up over several sync frames.                             */

      /* load FDQ coefficient calculated by adaptation routine       */
      if (guc_FdqAdaptationState == FDQ_ADAPTATION_LOAD_COEFFICIENTS) {
         LoadFDQ();
         /* Once all new FDQ coefficients are loaded, change state for FDQ adaptation. */
         guc_FdqAdaptationState = FDQ_ADAPTATION_COEFFICIENTS_LOADED;
      }


      /* load FDQ coefficient set manually   */
      if (guc_FdqAdaptationState == FDQ_MANUAL_LOAD_COEFFICIENTS) {
         LoadFDQ();
         /* Once all new FDQ coefficients are loaded, change state for FDQ adaptation. */
         guc_FdqAdaptationState = FDQ_MANUAL_COEFFICIENTS_LOADED;
      }
   }
#endif // #ifndef TARGET_HW
#endif // HERCULES_ADSL_CPE

   /* Update synch frame buffer when the previous synch frame processing is done */
   if ((guc_RxSyncFrameProcessingState == TRAINING_DONE) ||
      (guc_RxSyncFrameProcessingState == TRAINING_WAITING))
   {
      GetRxData(gsa_RxToneBuf, SYNC_LOGICAL_BUFFER, 0, gs_RxNumTones);
   }
}

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void RShowtimeRxFdqTC_DMT(void)
*
*   Description:
*
*  TC task for fdq done interrupt
*  Time-critical task associated with Showtime Rx Sync Frames.
*  Also
*     - Used to collect freq domain data (fdq o/p)
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
void RShowtimeRxFdqTC_DMT(void)
{
    uint32 ul_metric_value;
#ifdef PROFILE_TASKS
   LogMips(ST_RX_TC_FDQ, TC_NTC_START_FLAG);
#endif

   /* update PMD frame counter. This counter goes from 0 to 68 */
   GetRxFastFrameCounter(&gs_RxPMDFrameCnt_FftFdqBufferSymbol);
   /* After being updated, the counter identifies the PMD that originated this interrupt */

   /* fdq done interrupt does not control state m/c-- except in the absence of QAM done interrupt */
   gt_TaskArray[RX_FDQ_DONE].NonTimeCriticalTask = NULL;
   //==============================
   // Book Keeping in absence of QAM interrupt
   //==============================
   if (gs_RxPMDFrameCnt_FftFdqBufferSymbol == QAM_DISABLED_FRAME) /* TRUE for sync frames */
   {
      /* state machine processing handled by FDQ done interrupt's TC task */
      /* If there are pending loading functions, then run them */
      ExecuteQueuedLoadingFunctions(gp_RxLoadingFunctionFifo);

      /* update QAM PMD frame counter. This counter goes from 0 to 68 */
      GetRxFastFrameCounter(&gs_MuxFrameCntRxFastPath);

#ifdef PCM_INTERFACE_SUPPORT
   if (guc_PCMState >= 2)
   {
      pcm_rxProcessing();
   }
#endif   //#ifdef PCM_INTERFACE_SUPPORT

      RxDataPumpMisc_DMT();

      /* this call is moved to time critical task from rxeochandler() in rx_eoc.c */
      GetRxEocMessage_AddToFifo();

      GetAocMessage((uint16 *)(void *)&gus_RxAocRegister);

      /* Get the count of RS errors for fast path and interleaver path      */
      GetRSErrorCnt();

      //==============================
      // Sync frame processing
      //==============================
      do_sync_frame_processing_dmt();

      /* fdq done interrupt controls state m/c-- assign NTC task to this interrupt */
      gt_TaskArray[RX_FDQ_DONE].NonTimeCriticalTask = RxForeGround;

      /* if this were a sync symbol -- re-enable GS-QAM block for subsequent frame */
      RxSyncFrameTearDown();  /* prepare for a oncoming data symbol */
   }

   /* disable GS-QAM block for subsequent frame */
   if(gs_RxPMDFrameCnt_FftFdqBufferSymbol == BEFORE_QAM_DISABLED_FRAME)
      RxSyncFrameSetup();     /* prepare for a oncoming sync symbol */

   /* load FDQ coefficient calculated by DD adaptation routine       */
   if (guc_FdqAdaptationState == FDQ_ADAPTATION_LOAD_COEFFICIENTS)
   {
      LoadDDFDQ();
      guc_FdqAdaptationState = FDQ_ADAPTATION_INITIALIZE;
   }

    //XDSLRTFW-2579 (Start)
    // Read and store ED metric value (for DMT mode)
    ReadCoreReg (IRI_QT_REG_RX_RMETRIC_VAL_ADDR, &ul_metric_value);
    guc_metric_value = (uint8)(ul_metric_value & 0xFF);
   // XDSLRTFW-2579 (End)


   if(gs_RxPMDFrameCnt_FftFdqBufferSymbol == RX_SYMBOLS_PER_SFRAME)
   {
      /* read pilot tone, pll processing, micro-interruption check etc */
      do_showtime_pilot_processing(TRUE);
   }
   else
   {
      //==============================
      // Data frame processing
      //==============================
#ifndef AMAZON_SE
#ifndef HERCULES_ADSL_CPE
      // no need to toggle for Hercules build
      /* Toggle buffer select */
      gs_DD_rxFDQOutput_Buffer_Select = (1-gs_DD_rxFDQOutput_Buffer_Select);  //Toggle buffer select
#endif // HERCULES_ADSL_CPE
#endif

      /* read pilot tone, pll processing, micro-interruption check etc */
      do_showtime_pilot_processing(FALSE);

      /* TC Task data collection for DD snr and fdq updates */
      /* read fdq output for fdq frame cnts (0,67) -- no DDHandler() on sync symbol */
#ifdef AMAZON_SE
      // As part of RTV DMA workaround, read one more tone than required.  This assumes DD_RxNumChannelsPerSymbol < 32.
        if (!gft_Fixadma)
            Get_Rx_RTV_Data(&gsa_DD_rxFDQOutput[0][0], 0, (int16)(gs_DD_RxLastChannel-gs_DD_RxFirstChannel+2));
        else
         Get_Rx_RTV_Data(&gsa_DD_rxFDQOutput[0][0], 0, (int16)(gs_DD_RxLastChannel-gs_DD_RxFirstChannel+1));

#else
      GetRxData(&gsa_DD_rxFDQOutput[gs_DD_rxFDQOutput_Buffer_Select][0], DD_FFTFDQ_LOGICAL_BUFFER, gs_DD_RxFirstChannel, (int16)(gs_DD_RxLastChannel-gs_DD_RxFirstChannel+1));
#endif
   }


#ifdef PROFILE_TASKS
   LogMips(ST_RX_TC_FDQ, TC_NTC_END_FLAG);
#endif

#ifdef ADSL_62
      DisableRxPms(); //zep rx doesn't like to run on sync frame, with dt_size =0. (fixme m-code)
#endif
}

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void RShowtimeRxTC_DMT
*
*   Description:
*
*  TC task for qam done interrupt
*  Time-critical task associated with Showtime Rx Data Frames.
*
*  Arguments:
*     none
*
*  Global Variables:
*
*     gft_CopyPilotTone -- (I) set to TRUE to capture Pilot Tone
*                       information.  It is set in the state
*                       machine.
*
*-------------------------------------------------------------------
*^^^
*/

void RShowtimeRxTC_DMT(void)
{

#ifdef PROFILE_TASKS
   LogMips(ST_RX_TC_QAM, TC_NTC_START_FLAG);
#endif

#ifdef   TWO_FFT_BUFFERS
   // call FDQ_DONE TC task at the beginning of QAM_DONE TC task
   // since there is no FDQ_DONE interrupt available in Hercules
   RShowtimeRxFdqTC_DMT();
   // this is to save memory. Wasn't used anyway
   // skip QAM_DONE TC task for sync frame
   if (gs_RxPMDFrameCnt_FftFdqBufferSymbol == QAM_DISABLED_FRAME){
#ifdef PROFILE_TASKS
      LogMips(ST_RX_TC_QAM, TC_NTC_END_FLAG);
#endif
      return;
   }
#endif      // TWO_FFT_BUFFERS

   /* If there are pending loading functions, then run them */
   ExecuteQueuedLoadingFunctions(gp_RxLoadingFunctionFifo);

   /* ===========================================================================   */
   /* Get the Fast and Inlv path mux frame counts                          */
   /* ===========================================================================   */

    GetRxFastFrameCounter(&gs_MuxFrameCntRxFastPath);

   RxDataPumpMisc_DMT();

    /* this call is moved to time critical task from rxeochandler() in rx_eoc.c */
   GetRxEocMessage_AddToFifo();

   GetAocMessage((uint16 *)(void *)&gus_RxAocRegister);

    /*  =========================================================================== */
    /* Get the count of RS errors for fast path and interleaver path      */
    /*  =========================================================================== */

    GetRSErrorCnt();

    /*  =========================================================================== */
    /* Count CRC errors once per super frame.                                       */
    /*  =========================================================================== */
    if (gs_MuxFrameCntRxFastPath == 1)
        GetCRCErrorCnt();


      /* Start the Rx Data Pump to complete the Rx processing */
      //==============================
      // Data frame processing
      //==============================
      /* TC Task data collection for DD snr and fdq updates */
      if (gft_doDDSnrFdqUpdate)
      {
         /* read consdec output for frames (0,67) */
#ifdef AMAZON_SE //Constellation decisions
      //The new RTV contains Constellation decisions with different format(matching GS). Since there is no benefit
      //in precision in a constellation decision, we read this data from the FFT buffer instead of RTV.
      GetRxData(&gsa_DD_rxQAMOutput[0], 1, gs_DD_RxFirstChannel, (int16)(gs_DD_RxLastChannel-gs_DD_RxFirstChannel+1));
#else
      GetRxData(&gsa_DD_rxQAMOutput[0], DD_GSRCD_LOGICAL_BUFFER, gs_DD_RxFirstChannel, (int16)(gs_DD_RxLastChannel-gs_DD_RxFirstChannel+1));
#endif
      }

      StartRxDataPump_DMT();

//       if (gft_QosMode == 1){
//       PerformQos();
//       }
#ifndef HERCULES_ADSL_CPE
#ifndef TARGET_HW
#ifndef AMAZON_SE
   }
#endif
#endif
#endif // HERCULES_ADSL_CPE

#ifdef PROFILE_TASKS
   LogMips(ST_RX_TC_QAM, TC_NTC_END_FLAG);
#endif
}


/*
#undef s_MuxFrameSizef
#undef s_MuxFrameSizei
*/




