/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             showtime_tx_tc_dmt.c
 * DESCRIPTION:      Functions that implement the Tx dmt showtime time critical tasks.
 *
 **********************************************************************/

#include <stdio.h>
#include "common.h"
#include "gdata.h"
#include "xgdata.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "tx_eoc.h"
#include "aoc.h"
#include "aoc_ini.h"
#include "pn_tab.h"
#include "states.h"
#include "mtkernel.h"
#include "enc_gain.h"
#include "dec_gain.h"
#include "tx_m3oh.h"
#include "rx_m3oh.h"
#include "rt_tones.h"
#include "rt_state.h"
#include "ib.h"
#include "tx_ib.h"
#include "rx_ib.h"
#include "synsymbl.h"
#include "tone_ord.h"
#include "bitload.h"
#include "fifo.h"
#include "cmv.h"
#include "mp.h"
#include "qos.h"
#include "rx_eoc.h"
#include "rx_eoc1.h"
#include "rx_aoc.h"
#include "dec_adap.h"
#include "pll.h"
#include "timercov.h"
#include "bitswap.h"
#include "tx_aoc.h"
#include "rx_aoc.h"
#include "tx_plam.h"
#include "rx_plam.h"
#include "prf_man.h"
#include "bert.h"
#include "detect.h"
#include "DSLEngin.h"
#include "trail.h"

#include "atm_tx_processing.h"
#if defined(CUSTOMER_TASKS) && defined(IFX_XTC)
   #include "customertasks.h"
#endif


/* =============================================== */
/* constants used by this file only */
/* =============================================== */
/* define constants to clarify code */



/* #define FAST_SCRAMBLER_DISABLED    */
/* #define INLV_SCRAMBLER_DISABLED */
/* #define FAST_DESCRAMBLER_DISABLED */
/* #define INLV_DESCRAMBLER_DISABLED */
/*
#define s_MuxFrameSizef       gt_TxShowTimeVars.t_FastParms.s_MuxFrameSize
#define s_MuxFrameSizei       gt_TxShowTimeVars.t_InlvParms.s_MuxFrameSize
*/



/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : RShowtimeTxTC_DMT
 *
 *  Description: Tx time-critical operation in showtime
 *
 *  Prototype:
 *      void RShowtimeTxTC_DMT(void)
 *
 *  Input Arguments:
 *      None
 *
 *  Output Arguments:
 *      None
 *
 *  Return:
 *      None
 *
 *  Global Variables Used:
 *
 *      gs_MuxFrameCntTxFastPath : Tx Fast path frame count
 *      gs_MuxFrameCntTxInlvPath : Tx Interleave path frame count
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RShowtimeTxTC_DMT(void)
{
#ifdef PROFILE_TASKS
   LogMips(ST_TX_TC_FS, TC_NTC_START_FLAG);
#endif

   /* If there are pending loading functions, then run them.  */
   ExecuteQueuedLoadingFunctions(gp_TxLoadingFunctionFifo);

   GetTxFastFrameCounter(&gs_MuxFrameCntTxFastPath);

   /* set up iridia for sync frame processing */
   if (gs_MuxFrameCntTxFastPath == TX_SYMBOLS_PER_SFRAME)
   {
#ifdef PCM_INTERFACE_SUPPORT
      if (guc_PCMState==1)
      {
         pcm_enable();
      }
#endif   //#ifdef PCM_INTERFACE_SUPPORT

#ifdef IFX_XTC
      if (gft_AlphaeusSel)
#endif
         do_atm_tx_processing();
      TxSyncFrameSetup();
   }
   /* data frame */
   else
   {
#ifdef PCM_INTERFACE_SUPPORT
      if (guc_PCMState >= 2)
      {
         pcm_txProcessing();
      }
#endif   //#ifdef PCM_INTERFACE_SUPPORT

      /* set up iridia for non-sync frame processing */
      if (gs_MuxFrameCntTxFastPath == 0)
      {
         TxSyncFrameTearDown();
      }
   }

#ifndef DISABLE_BERT
   TxBERTSetup();
#endif

   StartTxDataPump_DMT();

   /* Copy captured Rx data for DEC adaptation from  */
   /* the engine to the task layer.                  */
   if (guc_DECAdaptationState != DEC_ADAPTATION_DISABLED)
   {
#ifndef ADSL_62
      GetDECAdaptationRxData();
#endif //ADSL_62
   }

#ifdef ADSL_62
   ReadAndClearHWOverflow(&gus_IRI_Tx_Ovflw, &gus_IRI_Rx_Ovflw, &gus_STR_Ovflw);
#endif

#ifdef PROFILE_TASKS
   LogMips(ST_TX_TC_FS, TC_NTC_END_FLAG);
#endif
}

/*
#undef s_MuxFrameSizef
#undef s_MuxFrameSizei
*/

/*
#define s_MuxFrameSizei         gt_RxShowTimeVars.t_InlvParms.s_MuxFrameSize
#define s_MuxFrameSizef         gt_RxShowTimeVars.t_FastParms.s_MuxFrameSize
*/



