/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1995 Aware Incorporated
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------
*
*       All Rights Reserved
*
*     40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*     Phone (781) 276 - 4000
*     Fax   (781) 276 - 4001
*
*       cmv.c
*
*
*
*-------------------------------------------------------------------
*/
// ******************************************************************
// cmv.c
//
// History
//
// 22/04/2010 Nihar: Low US performance on long loops with Ericsson 312 (BRCM based)
//                    On long white-noise loops the US performance is too low because of echo effects
//                    Increase US performance by blacking out DS tones on long loops
//                    use gs_PGA_required_In_RCComb1 for loop-length estimation (as G.HS estimation not
//                    yet implemented)
//                    Unfortunately this estimation works only if no ISDN noise is present on CPE side
//                    DTAG is currently testing without ISDN noise
//                    loop length:                           1500 1700 1800 1900 2000 2500 3000 3500 4000
//                    gs_PGA_required_In_RCComb1 (ISDN off):   1B   1E   21   21   24   2A   30   39   3C
//                    gs_PGA_required_In_RCComb1 (ISDN on):    1B   1E   21   21   21   21   21   21   21
//             By default, the fix is enabled based on vendor & vendor specific information
//             To disable it, reset bit 9 of OPTN 25 0
//                    Grep for IOP_US_BISPLUS_BRCM_IncreaseUSperfByDSBlackout
//
// 03/06/2010 Bhadra: CMV INFO 107 is used to know the status of AFE, DFE and 3 GLP interface(VR9)
//                    underflow overflow and not ready condtions.
//                    Grep for "Feature_ALL_ALL_ALL_AFE_DFE_3GLP_Status"
//
// 21/06/2010 Bhadra : Added new CMV group "DSL". And 3GLP status mapped to DSL CMV 7
//                      "DSL_STATUS_AFE_DFE_3GLP"
//                      Grep for  Enhancement_AB_ALL_ALL_ALL_Added_DSL_CMV_GROUP
// 16/07/2010 Sriram/Bhadra : Added new code pointers to support Amendment 3 to G.994.1 for Optional US interleaver depth.
//             OPTN 25 0 Bit-13 (mask: 0x2000) to enable/disable the upstream enhanced framing feature.
//             (acts like a master control switch) (i)   0 = disabled (default) (ii)   1 = enabled.
//             CNFG 45 0 ==> Upstream D0 max value supported in CLR message (Allowed values: 2, 6 & 14 R/W).
//                  Default value: 0x8
//             CNFG 45 1 ==> Upstream D0 max value received in CL message for LP0 ( Read Only)
//             Grep for XDSLRTFW-148:SMS00918205 SMS00918215 Feature_AB_ALL_BisPlus_ALL_Optional_US_interlever_depth
//
// 05/08/2010 Nihar : In the R PARAMS message octet 8 if MSB bit set to One if erasure decoding is
//             not used on the downstream latency paths.If MSB bit is set Zero, then R-Params
//             report support for erasure decoding
//                Grep for Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting
//
// 19/07/2010  Bhadra:Added code for mapping of NE Tx counters(Idle Cell /Non Idle cells) to CMV CNTR 53
//             Grep for " XDSLRTFW-151 :Feature_AB_ALL_ALL_NE_ATM_TC_CNTRS_Mapping "
//
// 22/03/2011 Vinjam: Added "ARX208" support through DSL CMV.
//            Grep for XDSLRTFW-278: Feature_AB_ALL_ALL_ARX208_Support_DSL_CMV
//
// 26/08/2011 Sriram Shastry : Add support for PTM transfer mode (in addition to ATM mode which is normally used in ADSL).
// This includes support in G.HS to indicate PTM support and evaluate CO response regarding possible PTM support
// Interface towards PPE engine -> Exchange of data-> reading of TC status counters from PPE engine and forwarding them to the
// related CMVs such that API can read them
// This feature is contolled via
// cnfg 0 0 2  // 1 : PTM 2: ATM 3: PTM+ATM
// cnfg 2 0 2  // 1 : PTM 2: ATM 3: PTM+ATM
// Default : ATM mode
// Grep for XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping
//
// 30/8/2011 Vinjam: Integrated "DSL_PPE_CLOCK_CONTROL" code from VR9 VDSL2 code (544316)
//          Add PPE clock change CMV as DSL 15. Bits 0:1 are the new clock setting,
//           Bit 4 is a trigger bit that will be cleared by FW after the register write is done.
//           Grep for XDSLRTFW-315: Feature_ALL_ALL_ALL_DSL_PPE_CLOCK_CONTROL
//
// 20/9/2011 Vinjam: Attached "gt_INFX_CMV" to "CMV INFO 103" for both Annex-A & Annnex-B.
//           Grep for Feature_ALL_ALL_ALL_EnableInfxCMV
//
// 23/09/2011 Kannan: Linked "gt_INFX_CMV" structure to INFO CMV array for AnxA mode too.
//            Grep for XDSLRTFW-332 IOP_A_DS_BisPlus_CNXT_BitswapDuetoRFI
//
// 30/09/2011 Stefan : Upsteam performance fixes from Stefan.
//                     Vinjam integrated them to Vr9 R4.3 ADSL mainline
//                     Grep for XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl
//
// 09/11/2011 ChihWen/Bhadra: The fix for "ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved":
//       1. The orginal code will start the searching (for max delta_Lp) from 2880, which will take very long time
//          to find the max delta_Lp and fail the training. The maximum allowed starting point (for max delta_Lp)
//          is set to 2000, which will take about 15384 symbols (from 12642 to 28026).
//       2. Considering the max_Lp (Lp + max_delta_Lp) and min_Lp (Lp - min_delta_Lp) before requesting SRA.
//       3. The searching for SRA will be enabled when it is BDCM CO or INFO 103 26 bitmask(0x0400) being one (it is zero by default).
//       Grep for ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved
//
// 09/11/2011 ChihWen/Bhadra:a)Enabling one-step SRA against CNXT causing causing segmented SRA message.
//       For this message CNXT CO didn't respond. Limit sra_step of 0x7fff(Segmented message of One step SRA )
//       to BRCM only. And thus don't sent segmented SRA message to others.
//       Grep for ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved
//
// 21/11/2011 Hanyu: Ported MFD code to VRx. Mapped NLNF structure pointer to CMV INFO 121.
//            Forced G.dmt Annex A for NLNF measurement.
//            This feature is triggered by "cw cntl 0 0 0x09" similar to sleep test mode.
//            Additinally, it is triggered by SW API 3.16.5.9 or newer during modem power up
//            and can be disabled by CMV bit-15 (default "0" means enabled) of INFO 121 0.
//        Grep for XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect
//
// 02/12/2011 Balabath:Added new microstate STATs18D and 19D CMV DSL 16 is used inplace of INFO 121
//       for NLNF measurement.INFO 103 (6:11) are mapped to DSL 18 0 5 (Hybrid information)..
//            Additinally, DSL13 bit2 is used inplace of CMV bit-15 (default "0" means enabled) of INFO 121 0.
//        Grep for XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect_CMVRemap
//
// 30/12/2011 Sriram Shastry : Indicate VDSL2 annex bit and the corresponding Full CLR code points in handshake  during Full CLR message
//    Grep for XDSLRTFW-321 Feature_AB_ALL_ALL_ALL_VDSL_HSK_InADSLFullCLR_Msg
//
// 04/01/2012 Balabath:Support US SRA and controlling US SRA" between Hercules CMV "OPTN 15 0 x0002"
//                   to Socrates "OPTN 15 0 0x0100
//       Grep for XDSLRTFW-380: Feature_US_BisPlus_All_USSRA_CMVRemap
//
// 21/02/2012 Balabath:Too low DS Rate and too high DS SNRM in the SingTel
//            SRA Profile / ADSL2+ Mode / Huawei MA5600 / H568ADGG / BDCM Line card.
//            The reason for this is this DSLAM doesn't support extended interleaverdepths and 1/S0min is received
//            as 3. with SRA profiles and sraoffset set to 14 dB, and gs_deltaLp_max = 2400 as input
//            the framing parameters computed results very low Lp becasue of delay(1/S0min) constraints.
//             Similar behaviour is observed with other DSLAMs also in SRA profiles with cmv info 26 bit10(0x400)
//             and 1/S0min as 3 The solution is to force 1/S0min to 4 which results much higher Lp while entering showtime
//            And the meets 1/S0min constraints also.For results check the JIRA XDSLRTFW-422
//             Risk: CRC's may be observed becasue of 1/S0min voilations if HW support is not there in DSLAMs.
//           For code changes grep for XDSLRTFW-422 ENH_DS_BisPlus_All_SRAInterleaved_OneOverS0min
//
//12/01/2012: Balabath: Added CMV to trigger LPR in idication.DSL 5 0 1 will trigger this.By default
//                      this bit is set to zero.
//                Grep for XDSLRTFW-201 Feature_US_ALL_ALL_LPR
//
// 31/01/2012 Vinjam: CMV Remap for "HERC OPTN 15 0" to "SOC OPTN 2 0" for
//            enabling/disabling US BitSwap & DS BitSwap
//            Grep for XDSLRTFW-395 Feature_All_All_All_BitSwap_CMVRemap
//
//16/01/2012 Shakil/Balabath:Non Standard T1413 GHS Activation switching required by Telefonica Spain.
//          By default , if no CO activation tones detected the CPE switches between T1413 and GHS activation
//          at every two seconds (i.e. 2 seconds of t1413 followed by 2 seconds of GHS and so on...).
//          This feature changes the switching time from 2 seconds to 60 seconds
//          (i.e. 60 seconds of t1413 followed by 60 seconds of GHS and so on...).
//          This feature is CMV controlled and by default disabled.
//          CNFG 58 0 -> bit 0  (Non standard T1413-GHS activation switching enabled/disabled)
//                   0: disabled (default)
//                   1: enabled
//          CNFG 58 0-> bit 1 (T1413/GHS Activation startup)
//                   0 -> GHS Activation startup (Default)
//                   1-> T1413 activation startup
//       For code changes Grep for XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching
//
// 16/2/2012 Vinjam: Allow adjusting the target DS margin via CMV/message in ADSL mode.
//           Option to add additional DS margin (additional to what is requested as target margin by the CO).
//           This margin would be added on all tones (i.e. flat). The reported margin must be the real margin
//          (i.e. including the additional margin configured). The goal of the CMV is not margin cheating.
//          This CMV will also be helpful for debugging purposes and it will also allow to decrease the margin
//          (i.e. increase DS performance by sacrificing margin/stability) HERC CMV "OPTN 28" is used for setting deltaTARSNRMds.
//          grep for "XDSLRTFW-310 Improve_BisPlus_DS_All_AdjustTargetMarginThroughCMV" to see the code changes.
//
//
// 07/06/2012 Vinjam: Added new CMV "INFO 114" to read the received downstream virtual noise break points.
//          The CMV "INFO 114" contains the valid data from channel discovery phase onwards.
//          Grep for XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise
//
// 26/06/2012 Ram: Added code for mapping of ReTX Status counters to CMV CNTR 43,44 and
//                 CMV RATE 2
//                 Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 04/07/2012 Vinjam: Set "HERC STAT 0 1" to "0x3" if link is not in show timwe (Not STEADY_STATE), as per VR9 Message Specifications.
//                   Comment: Modified Logic need to be Re-Visted during "PM L3" feature release.
//                   Grep for XDSLRTFW-486: Fix_ALL_ALL_ALL_PM_L3_NotSteadyState
//
// 05/07/2012 Ram: Merged "ReTx" Segmented Bitswap Request code from ARX ADSL code base.
//   To cope with sweeping and fixed RFI, the following changes are done.
//   1. Below changes #2,#4,#5,#6 are under cmv control INFO 103 23 bitmask(0x0040). This bit is one (enabled) by default.
//   2. Modify the maximum number of bits for bitswap (gs_REDUCE_LP_DELTA_BITSWAP) from 20 to 120.
//   3. Increase Tx HDLC buffer size (MAX_TX_HDLC_MSG_SIZE, MAX_TX_HDLC_BUFFER_SIZE) from 700 to 1000.
//   4. Increase the maximum tone number (gs_MaxTonePerOvhdMsg) in one HDLC segment from 160 to 240.
//   5. Enable segmented bitswap request.
//   6. Change gs_DD_RxChannelsPerSymbol from 16 to 32 to improve SNR updating frequency.
//   7. Once marign on tones were ever dropped to below -6 dB, then bitswap is triggered when minimum margin is below 0 dB.
//      The threshold (-6dB by default) can be changed with cmv INFO 119 0.
//   8. Do not move bits to the tones whose margin were ever dropped to below -6 dB since these tones were very likely
//      to be affected by RFI before, and will be affected by RFI again. This mechanism is under cmv control
//      INFO 103 23 bitmask(0x0080). This bit is one (enabled) by default.
//   9. If bitswap is failed, checking of #7 condition will be ignored. Then bitswap will be tried again.
//   10. Include fix SMS01320806 IOP_A_BisPlus_CNXT_ImprovedBitSwap.
//   Grep for "XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest"
//
// 23/08/2012 Vinjam: Added a structure "gt_InteropOptions" for Interop bits common to ADSL/VDSL, attached to "CMV DSL 19"
//            Grep for "XDSLRTFW-508 Fix_DS_All_All_SuppressCounterWriteFromDSLAPI"
//
// 07/9/2012 Vinjam: "gt_HercADSL_STATMap_MacroState.s_Offset1 = STATArray[STAT_PowerMode]" is moved to MapSocStatMacrosttoHerc( )
//            Grep for STATArray[STAT_PowerMode]
//
// 17/09/2012 Ram: Added code to support the foll CMVs
//                 "CNFG 80" -> Enable/Disable ReTx mode during G.HS
//                 "INFO 229" -> ReTx DS Showtime Status: ReTx On/OFF
//                 Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx_CMV_CNFG_80_INFO_229 "
//
// 26/11/2012 Kannan: Included header file for compilation.
//   Grep for "XDSLRTFW-541: Platform_VR9_VRX318"
//
// 24/12/2012 ChihWen/Vinjam: Integration of R3.5 dying Gasp code changes to R5.2.
//            Overwrite one time the Tx IB FIFO with LPR indication when dying gasp event is happening (GPIO pin 15), so that the LPR will be indicated
//       in the next US OHC frame. The reason for doing so was that there could be one OHC frame delay between the dying gasp event and
//       the time when Tx IB FIFO was empty. This delay would cause one OHC frame later for indicating LPR.
//             Grep for XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR
//
// 24/12/2012 Vinjam: Change in CMV. CMV_TO_ENABLE_LINK_DROP_FOR_DYING_GASP is moved from "OPTN 25 0 0x4000" to "OPTN 16 0 0x0001"
//       Grep for XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR
//
//03/08/2012 Anantha: Initialized pointer to info CMV pointer array correponding to T1413 information
//Grep pattern XDSLRTFW-496: Feature_T1413_Info
//
// 07/01/2013 Ram: Added fix for JIRA 575, 459.
//                 a) 575: Seperate out and align FW internal counters as per Msg spec
//                 b) 459: Implement CMV 'CNTR 51'
//            Grep for XDSLRTFW-575: Counter Write back in ADSL mode
//            Grep for XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping
//
// 10/01/2013 Vinjam: Relocated "SOC OPTN 25" CMVs to "SOC OPTN 33" &
//            Added a new CMV "OPTN 33 0 0x0400" to Fix an issue with C-TREF1 detection in long loops
//            Reason: As per VRx message spec, "OPTN 25" is reserved for "Polling" far-end counters
//            Grep for XDSLRTFW-656 Fix_AB_DS_All_All_RelocateOptn25ToOptn33
//
// 16/01/2013 Ram: Fix added for JIRA 285 - Implement a 'Feature MAP' indicating the features supported by ADSL FW
//                 Added a new variable to implement CMV 'DSL 19' (Refer Msg Spec ver 1.9 for more details on CMV)
//                 Grep for XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map
//
// 04/02/2013 Sooraj: Added Support for CMV "OPTN 25" to control EOC polling.
//            Grep for XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead
//
// 07/02/2013 Vinjam: Added support for "CMV CNFG 45" to select "G.Hs Toneset" as per VRx Msg Spec.
//            Inturn, "enale/disable" of "optional upstream interleaver depth" feature is moved to "CMV CNFG 46".
//            Grep for XDSLRTFW-699: Fix_AB_US_All_GHsToneSetSelection
// 11/02/2013 Kannan:
//          1. Orderly shutdown algo implementation and it is applicable for both
//             VR9 & VRX318.
//             Grep for "XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown"
//
// 07/02/2013 Vinjam: Send "Vector" code pointer in "VDSL2 code pointers" in ADSL G.Hs Short CLR Message.
//            Vector feature is enabled using "CMV CNFG 82". If enabled, then set "SPAR2 OCTET2 Bit-3(0x8)" & NPAR3 OCTET1 Bit-0(0x1).
//            Grep for XDSLRTFW-713 Feature_AB_All_All_All_SendVectorCodePointerInGHs
//
// 20/2/2013 Vinjam: Enable/disable US & DS Bitswaps as per VRx Message Spec.
//            Grep for XDSLRTFW-731 FIX_All_All_All_EnableBitSwapsAsPerVRxMsgSpec
//
// 20/2/2013 Vinjam: Enable/disable US & DS Bitswaps as per VRx Message Spec.
//            Grep for XDSLRTFW-731 FIX_All_All_All_EnableBitSwapsAsPerVRxMsgSpec
//
// 25/02/2013 Ram: Fix added for JIRA 285 - Implement a 'Feature MAP' indicating the features supported by VDSL FW
//                 Added a new variable to implement CMV 'DSL 20' (Refer Msg Spec ver 1.9 for more details on CMV)
//                 Grep for XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map
//
// 27/02/2013 Mahesh: Added crystal drive changes for Jira - XDSLRTFW -561
//                 new CMV DSL 25 added & mapped to delta freq offset
//                 Grep for XDSLRTFW-561 Enhancement_All_All_All_FreqOffset
//
// 07/03/2013 Vinjam: Enable PM L3 Feature so that it honours (i) API request for PM L3 & (ii) CO request to go to PM L3
//                 Grep for XDSLRTFW-750 Fix_DS_BisPlus_All_PML3EnableByDefault
// 16/05/2013 Kannan:
//            AFE init fail indication is enabled by default. It was disabled earlier due to adc trim exception.
//            Now adc trim exception is fixed and AFE init fail exception is enabled by default.
//            Grep for "XDSLRTFW-938 Improvement_VR9_VRX318_AdcTrimException"
//
// 24/5/2013 Vinjam: Added mapping of "HERC CMV INFO 85" to "Showtime SNR with out Virtual Noise" and the existing
//                   HERC/SOC CMV INFO 85 (INFO_RX_CLEAR_EOC) is moved to HERC/SOC CMV INFO 130
//                   Grep for XDSLRTFW-965 Task_DS_BisPlus_All_AttachHercCMVINFO85
//
// 27/5/2013 Vinjam: Clean up HERC CMV CNFG 17.
//            Grep for XDSLRTFW-230 Bug_All_All_All_HercCnfg17_CleanUp
//
// 27/5/2013 Vinjam: Added CMV remap for INFO 221 using Hercules CMV dictionary entry
//            Grep for XDSLRTFW-230 Bug_All_All_All_CmvRemapInfo221
//
// 28/5/2013 Vinjam: Incorporated the review comment as per CRXDSLRTFW-24. Modified pointer initialization for INFO_221_Map[].
//            Grep for XDSLRTFW-230 Bug_All_All_All_CmvRemapInfo221
//
// 07/05/2013 Hanyu: Ported ChihWen: To avoid the lower DS sync-up rate against BDCM CO (in some SRA test cases), the searching for maximum gs_deltaLp_max
//                is modified to make DS rate not too much less than the original DS rate (when gs_deltaLp_max = 0).
//                The exact DS rate degradation can be controlled by OPTN 33 0, it is 5 by default, which means at most 5 percent rate degradation.
//            Grep for XDSLRTFW-930 ADSLRTFW-1517 ENH_DS_BisPlus_BDCM_SRA_EnhanceDsSyncUpRate
//
// 26/06/2013 Ram: Added new CMV DSL 31 to read G.Hs Handshake Control structure using DCT
//            Grep for XDSLRTFW-361 Enh_All_All_All_GetHandshakeControlInfo
//
// 04/12/2013  Sriram Shastry: It  has seen in DTAG lab that due to  Xtalk from neighbouring  line , there is false Ctone detection
//             Fine tuned GHs detection scale factor. cmv OPTN 33 0 bit 13 (0x2000) enabled by default.
//              Grep for :  XDSLRTFW-1402 :IOP_DS_ALL_ALL_BoostGhsToneDetectScale_XtalkForceDmtT1413
//
//
// 10/12/2013 Kannan:
//                DEC adaptation was disabled through CMV "(OPTNArray[OPTN_AlgControl] & OPTN_DECAdaptDisable)"
//                and "gft_DECAdaptDisable" is linked to this CMV.
//                This causes to disable the DEC permanently.
//                So disabling of DEC in the FW is not required, it needs to be enabled to pass the temp chamber test
//                if DEC is required to be disabled, it needs to be done through CMV.
//                Note: "HERCULES_ADSL_CPE" is defined for VR9/VRX318
//                Grep for XDSLRTFW-1439
//
// 18/11/2014 : Vinay : Added a new CMV (INFO 241) to capture the configuration of ADSL as a debug feature.
//       Grep for XDSLRTFW-1782 : CAPTURE_CONFIGURATION_MESSAGES
//
// 18/01/2016 Vinay: Changed the addresses of DSL 27 and DSL 28. Initially they were hard coded and now it is pointing to a variable.
//                   Also added few variables to BAR15 register.
//                   Grep: XDSLRTFW-1942
// 15/12/2017 Sriram shastry: DCT tool does not work in ADSL mode for VRX518 FW R5
// Added Support towards VRX518 Platform for  debug traces ( Updated address field )
// Search  Pattern XDSLRTFW-3638
// **************************************************************************************************************************************

#include "typedef.h"
#include "cmv.h"
#include "gdata.h"
#include "ec_data.h"
#include "ghs.h"
#include "eoc.h"
#include "timestmp.h"
#include "version.h"
#include "exchdata.h"
#include "rinfotbl.h"
#include "hndshk_data.h"
#include "gdata_bis.h"
#include "gdata_bis_diag.h"
#include "rt_state.h"
#include "snr.h"
#include "rx_plam.h"
#include "trail.h"

#ifdef DO_PLAM
#include "plam.h"
#include "tx_plam.h"
#endif /* DO_PLAM */

#ifdef TARGET_HW
#include "gpio.h"
#endif
//#ifdef DANUBE
//#ifdef TARGET_HW
#include "dataswap.h"
//#endif
//#endif
#include "rx_plam_bis.h"
//XDSLRTFW-541: Platform_VR9_VRX318 (START)
#include "nlnf.h"

#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"

//XDSLRTFW-541: Platform_VR9_VRX318 (END)
/*******************************************************************************
*
*  Prototype: void CMVInit_PreHandshake(void)
*
*  This function initializes all CMV's known at the start of the handshake
*  phase. The remaining entries are initialized
*  with INFOMAP_UNDEFINED_ADDR.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*******************************************************************************/

void CMVInit_PreHandshake(void)
{
    int16 i;
#ifdef PCM_INTERFACE_SUPPORT
    int32 l_Addr;
#endif
    /*========================================================================*/
    /* clear all CMV's */
    /*========================================================================*/

    for (i=0;i<CNTLARRAY_SIZE;i++) CNTLArray[i] = 0;
    for (i=0;i<STATARRAY_SIZE;i++) STATArray[i] = 0;
    for (i=0;i<TESTARRAY_SIZE;i++) TESTArray[i] = 0;

//XDSLRTFW-486: Fix_ALL_ALL_ALL_PM_L3_NotSteadyState (Start)
    // Upon powerup the gft_EnterL3afterNextReboot flag value is undefined but will
    // probably not be equal to STAT_PM_L3.  Not a serious problem if it is.
//    if (gft_EnterL3afterNextReboot == STAT_PM_L3)
    STATArray[STAT_PowerMode] = (int16) STAT_PM_L3;
//    else
//    STATArray[STAT_PowerMode] = (int16) STAT_INIT_STATE;
//XDSLRTFW-486: Fix_ALL_ALL_ALL_PM_L3_NotSteadyState (End)

//#ifdef HERC_API
    // Necessary for L3 Operation.  This CMV needs to be mapped immediately
    // after CPE Reboot.
    /*
    *-------------------------------------------------------------------------------------------
    *   CMV MAP                     StratiPHY   Adr Idx bits    ->      Hercules    Adr Idx bits
    *   Power Mode                  STAT        18   0   0              STAT        0   1   15:0
    *-------------------------------------------------------------------------------------------   */
    //This is moved to MapSocStatMacrosttoHerc( )
    //gt_HercADSL_STATMap_MacroState.s_Offset1 = STATArray[STAT_PowerMode];
//#endif

    /* Default Encoder Gain in sleep.c */
    TESTArray[TEST_EncoderGain]  = ENCGAIN2;
    TESTArray[TEST_SuppressErrorReportingToME] = 0;

    // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start)
    //Disable 'SNR Stuck' check by default. Enable this check again, once we solve 'SNR Stuck issue during L2 entry'.
    TESTArray[TEST_SuppressErrorReportingToME] |= TEST_SuppressShowtimeSNRUpdateCntStuckToME;
    // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (End)

    TESTArray[TEST_OLR_SRA_SettlingTime] = DEFAULT_SRA_SETTLING_TIME;
    TESTArray[TEST_OLR_SRA_DeltaLpchange] = DEFAULT_SRA_DELTA_LP_CHANGE;
    //   TESTArray[TEST_OffsetRxCalibration] = 160;                        // example: 160 = 1.25 dB in Q9.7

#if defined  (DANUBE_WB) || defined (VR9_ERASURE)

    TESTArray[TEST_ERASURE_WB3_control] = 0x404;
#ifdef TARGET_HW
    TESTArray[TEST_ERASURE_METRIC_control] = 0x18;
#else
    TESTArray[TEST_ERASURE_METRIC_control] = 0x18;
#endif

#endif //#if defined  (DANUBE_WB) || defined (VR9_ERASURE)

    for (i=0;i<OPTNARRAY_SIZE;i++) OPTNArray[i] = 0;
    for (i=0;i<INFOMAP_SIZE;i++) INFOMap[i] = &gs_zero_cmv;
    for (i=0;i<RATEMAP_SIZE;i++) RATEMap[i] = &gs_zero_cmv;
    for (i=0;i<PLAMMAP_SIZE;i++) PLAMMap[i] = &gs_zero_cmv;
    //Enhancement_AB_ALL_ALL_ALL_Added_DSL_CMV_GROUP (Start_End)
    for (i=0;i<DSLMAP_SIZE;i++)  DSLMap[i] = &gs_zero_cmv;


#ifdef HERC_API
    for (i=0;i<CNTRMAP_SIZE;i++) CNTRMap[i] = &gs_zero_cmv;
    for (i=0;i<AINFMAP_SIZE;i++) AINFMap[i] = &gs_zero_cmv;
    for (i=0;i<MONIMAP_SIZE;i++) MONIMap[i] = &gs_zero_cmv;
#endif

    // Support Multimode.  The default value can be overwritten by the CMV setting
#ifdef ISDN
    OPTNArray[OPTN_ModeControl] = (int16)(OPTN_ConfigMode_G992_1_B | OPTN_ConfigMode_G992_3_B | OPTN_ConfigMode_G992_5_B);
#else
//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (START)
// Force G.dmt Annex A for NLNF measurement.
// This can be enabled by CMV bit-2 of DSL 13 0
// (default "0" means enabled)
// and "cw test 7 0 0x7FD0" without SW API support
// or enabaled by cw cntl 0 0 0x09 with SW API support.
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
   //XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect_CMVRemap (start_end)

  if (((gt_ApiOptions.us_Opt_Offset0 & CMV_BIT2_TO_ENABLEE_NLNF_STARTUP) &&
      (TESTArray[TEST_RxSubState] == CMV_TEST70_RX_NLNF_TRIGGERED)) ||
      (CNTLArray[CNTL_ModemControl] == CNTL_ModemNLNF))
  {
      OPTNArray[OPTN_ModeControl] = (int16) OPTN_ConfigMode_G992_1_A;
  }
  else
  {
#endif //#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
    OPTNArray[OPTN_ModeControl] = (int16)(OPTN_ConfigMode_T1413 | OPTN_ConfigMode_G992_1_A | OPTN_ConfigMode_G992_3_A | OPTN_ConfigMode_G992_3_L | OPTN_ConfigMode_G992_5_A);
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
  }
#endif //#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (END)
#endif   /* End of #ifdef/#else ISDN */
#ifdef REIN_DBG_CODE
   TESTArray[Test_Erasure_HW_Block] &= ~Test_Erasure_HW_Block_ON;
#endif

   OPTNArray[OPTN_ModeControl1] = (int16)(0);                     // do not enable ETSI Annex-C

   // XDSLRTFW-321 Feature_AB_ALL_ALL_ALL_VDSL_HSK_InADSLFullCLR_Msg(Start)
#ifdef HERC_API
   // Give the control the API
   // OPTNArray[OPTN_ModeControl1] = (int16)(OPTN_ConfigMode_G993_2);    // enable VDSL2_G.993.2 Annex
   // Give control to DSL API to turn on the VDSL2 G.993.2 Annex Mode
   OPTNArray[OPTN_ModeControl1] = (int16)(gs_OPTN_ConfigMode_G993_2_Control);    // enable VDSL2_G.993.2 Annex
#endif
   // XDSLRTFW-321 Feature_AB_ALL_ALL_ALL_VDSL_HSK_InADSLFullCLR_Msg (End)

    // By default use short CLR.  Signal Revision 1, meaning no support for MP (mode proposal) or
    // message retransmission.
    OPTNArray[OPTN_GhsControl] = OPTN_RTMMode_ShortCLR | OPTN_Ghs_Rev1;

    OPTNArray[OPTN_DMTLinkControl] = OPTN_FM3 | OPTN_ATM_TransferMode;

    // set default values to OPTN_AlgControl cmvs
    OPTNArray[OPTN_AlgControl] =  OPTN_IFFT128_Enable | OPTN_MedleyTdqOffEnable | OPTN_MedleyTdqEnable;
#ifdef ISDN
    //OPTNArray[OPTN_AlgControl] |=  OPTN_DECAdaptDisable;
#endif
   //XDSLRTFW-731 FIX_All_All_All_EnableBitSwapsAsPerVRxMsgSpec (Start)
   //Below 2 lines are addded to convey the required information.
   //Need to clear the required bits to enable the US/DS bitswaps.
   //This is already done in the above line.
   // Enable DS BitSwap
    //OPTNArray[OPTN_AlgControl] &= ~OPTN_DSAutoBitSwapDisable;
    // Enable US BitSwap
    //OPTNArray[OPTN_AlgControl] &= ~OPTN_USBitSwapDisable;
   //XDSLRTFW-731 FIX_All_All_All_EnableBitSwapsAsPerVRxMsgSpec (Start)

    OPTNArray[OPTN_AlgControl] &= 0xFFFD;
    OPTNArray[OPTN_AlgControl] &= 0xFFFE;
#ifdef DANUBE
    OPTNArray[OPTN_AlgControl] |= ( OPTN_AECDnldDisable ) ;

#endif
    // Set default value of OPTN_AlgControl2 to enable Dying Gasp
    OPTNArray[OPTN_AlgControl2] = OPTN_EnableDGasp;
   //SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (START)
   OPTNArray[OPTN_AlgControl3] &= ~CMV_TO_ENABLE_ANNEXM_B43_J43_TONES_BRCM;
   //   OPTNArray[OPTN_AlgControl3] |= CMV_TO_ENABLE_ANNEXM_B43_J43_TONES_BRCM;
   //SMS01354295 BugFix_ALL_ALL_ALL_DisableB43J43Detection (END)

   //XDSLRTFW-656 Fix_AB_DS_All_All_RelocateOptn25ToOptn33 (Start_End)
   //Fix didn't solve the training link drop issue
   //It only helped to detect C-TREF1, link drops during MSG1 decoding.
   OPTNArray[OPTN_AlgControl3] &= ~CMV_TO_DETECT_CTREF_LONG_LOOPS;

   //XDSLRTFW-938 Improvement_VR9_VRX318_AdcTrimException (START)
   //ADC trim exception "E_CODE_ADC_TRIM_FSCALE_TIMEOUT_ERROR" was
   //observed in VRX318, some of the ADC trim functions needs
   //to executed as fast as possible. But ADC trim code was kept in PDBRAM.
   //Looks like executing code from the PDBRAM introduces some delay(how much?)
   //as compared to the code executing from IIBRAM. So moved the adc trim code
   //from PDBRAM to IIBRAM to execute faster.
   //Note: adc trim exceptioin was not observed in VDSL mode
   //since adc trim code was already available in IIBRAM.
   //So AFE Init fail exception can be enabled.
   //XDSLRTFW-181: VR9_VRX318_AFE_Init_Fail_Indication (START)
   //Found Link hole if we enable by default, Not clear ?.
   //Later while testing some other modules, Observed the Exception code '247'
   //during AFE initialization, i.e E_CODE_ADC_TRIM_FSCALE_TIMEOUT_ERROR
   //Need to debug.
   //OPTNArray[OPTN_AlgControl3] &= ~CMV_TO_ENABLE_AFE_FAIL_EXCEPTION;
   OPTNArray[OPTN_AlgControl3] |= CMV_TO_ENABLE_AFE_FAIL_EXCEPTION;
   //XDSLRTFW-181: VR9_VRX318_AFE_Init_Fail_Indication (END)
   //XDSLRTFW-938 Improvement_VR9_VRX318_AdcTrimException (END)
   //XDSLRTFW-1313 XDSLRTFW-1208 : BugFix_DS_BisPlus_All_TR105SRAChanges (start)
   OPTNArray[OPTN_AlgControl3] &= ~CMV_TO_ENABLE_FRACTIONAL_INP_FRAMEWORK;
   OPTNArray[OPTN_ExtraINP] = 1;//=0.1 in 0.1 granularity.
   //XDSLRTFW-1313 XDSLRTFW-1208 : BugFix_DS_BisPlus_All_TR105SRAChanges (end)

#ifdef ADSL_62
    OPTNArray[OPTN_AlgControl] |=   OPTN_AECDnldDisable ;
#endif
   //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved (START_END)
   OPTNArray[OPTN_SRA_OFFSET] = 0x0E00;  //default is 14 dB
   //XDSLRTFW-422 ENH_DS_BisPlus_All_SRAInterleaved_OneOverS0min (start_end)
   OPTNArray[OPTN_INVSMIN_SRA_NoOptIntlvDepth]= 4;
   //XDSLRTFW-148:SMS00918205 SMS00918215 Feature_AB_US_BisPlus_ALL_Optional_US_interlever_depth (Start_End)
   //XDSLRTFW-322 Fix_AB_US_BisPlus_All_EnhancedFramingMovedToDSLCMVgroup (Start_End)
   //OPTNArray[OPTN_AlgControl3] &= ~CMV_TO_ENABLE_US_INLV_DEPTH_STD;   // Def.   //Moved to DSL 13 //DSLMap[DSL_OPTIONS]
   //XDSLRTFW-158:Feature_ALL_ALL_VDSL2Modes_shortCLR(Start_End)
   OPTNArray[OPTN_AlgControl3] &= ~CMV_TO_SEND_VDSL_MODES_IN_SHORT_CLR; // Default.
   //ChihWen: bug fix of no sync when shine noise is injected (START_END)
   OPTNArray[OPTN_AlgControl3] &= ~CMV_TO_DISABLE_HW_SNR_FDQ;

   //XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR (Start)
   //As per VRx Msg Spec 1.9, "OPTN 25 Bits(15:9)" is reserved for "FE counter polling"
   //So, while integrating the fix from VR9 R3.5 to R5.2, CMV is moved to "OPTN 16 Bit-0"
   OPTNArray[OPTN_AlgControl2] &= ~CMV_TO_ENABLE_LINK_DROP_FOR_DYING_GASP;
   //XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR (End)

//XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING(Start)
#ifdef ADSL_BONDING
    //XDSLRTFW-230 Bug_All_All_All_HercCnfg17_CleanUp (Start)
   CNFGMap[CNFG_Bonding_DiscAggr_Control] = (int16*)(void *)&gt_Bonding_DiscAggr_Control;
   // Disable the Bonding feature by default.
   gt_Bonding_DiscAggr_Control.s_PCS_control = 0;
    //XDSLRTFW-230 Bug_All_All_All_HercCnfg17_CleanUp (End)

   DSLMap[DSL_BONDING_CONTINUE]  =  (int16*)(void *)&gt_Bonding_Continue;
#endif   //ifdef ADSL_BONDING
//XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING(End)
    TESTArray[Test_DoublePGATraining] = Test_Enable_DoublePGATraining_Xcvr;

    //XDSLRTFW-1887: (Start_End)
    TESTArray[TEST_FREEZE_CPE_TX] = 0;
    TESTArray[Test_ErasureGains] = 3;//default earsure gain 1.7

    // Set default G992.3 US PSD Preferred value
    OPTNArray[OPTN_AnnexControl] = OPTN_G992_3_AnnexA_PreferredModeA;

    // Set default values to three OPTNs
    OPTNArray[OPTN_FFTBufferControl] =  OPTN_ShowtimeScenario3 | OPTN_TrainScenario1 ;
    OPTNArray[OPTN_Log2NumShowtimeFDQTrainingSymbols] = DEFAULT_LOG2_NUM_SHOWTIME_FDQ_TRAINING_SYMBOLS;
    OPTNArray[OPTN_Log2NumShowtimeSNRTrainingSymbols] = DEFAULT_LOG2_NUM_SNR_TRAINING_SYMBOLS_SHOWT;
    OPTNArray[OPTN_Log2NumShowtimeDECTrainingSymbols] = DEFAULT_LOG_DEC_ADAPT_NUM_FRAME_AVG;

    // Set default value of fgain adjust, margin adjust
    OPTNArray[OPTN_FgainAdjust_ShortLoop] = 0x0000; // (Q8.8)
    OPTNArray[OPTN_FgainAdjust_MedLoop] =   0x0080; // (Q8.8)
    OPTNArray[OPTN_FgainAdjust_LongLoop] =  0x0100; // (Q8.8)
    OPTNArray[OPTN_FgainAjust_Threshold] =  130;    // upper limit of ncloaded for long loops.
    OPTNArray[OPTN_FgainAjust_Threshold2] = 190;    // upper limit of ncloaded for med loops.

    OPTNArray[OPTN_MarginDelta] = 0 ;

    //XDSLRTFW-310 Improve_BisPlus_DS_All_AdjustTargetMarginThroughCMV (Start_End)
    OPTNArray[OPTN_DesiredMarginAdjust] = 0;

    OPTNArray[OPTN_MaxNomAtpAdjust] = 0 ;

    OPTNArray[OPTN_StateMachineCtrl] = (int16)(OPTN_SONEFOURTH_ENABLE | OPTN_PilotOnDecTraining_DMT); // Disable Quiet on Dec training in DMT

//XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (Start)
   // OPTN_TXPathControl - initialize to '0'
   // bit  0:  STATUS      (ReadOnly, 0: US-performance-code bypassed, 1: US-performance code used in training)
   // bit  1:  ENABLE_DMT  (not supported)
   // bit  2:  ENABLE_BIS  (not supported)
   // bit  3:  ENABLE_PLUS (0: disabled, 1: enabled, to be set by API)
    OPTNArray[OPTN_TXPathControl] = 0;
//XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (End)

#ifdef TARGET_HW
    /* Set cmv bit to enable 1024 pt FFT */
    OPTNArray[OPTN_StateMachineCtrl] |= OPTN_FFT1024_Enable;
#else
    /* In Cocomo, enable pilot during DEC training */
    OPTNArray[OPTN_StateMachineCtrl] |= OPTN_PilotOnDecTraining_Bis;
#endif

#ifdef   INFINEON
#ifndef VINAX_ADSL_AFE
    OPTNArray[OPTN_OLRControl_DS] |= OPTN_EnableAutoSRA;
#endif
#endif

   //XDSLRTFW-380: Feature_US_BisPlus_All_USSRA_CMVRemap (start)
   // By default DS SRA and US SRA are disabled
#ifdef ADSL_62
   OPTNArray[OPTN_OLRControl_DS] &= ~OPTN_EnableAutoSRA;
   OPTNArray[OPTN_OLRControl_DS] |= OPTN_DisableUSSRA;
   //XDSLRTFW-750 Fix_DS_BisPlus_All_PML3EnableByDefault (Start_End)

#endif
   //XDSLRTFW-380: Feature_US_BisPlus_All_USSRA_CMVRemap (end)

#ifdef  ISDN
   // IOP_US_BISPLUS_BRCM_IncreaseUSperfByDSBlackout (Start_End)
   OPTNArray[OPTN_AlgControl3] |= CMV_TO_ENABLE_DTAG_US_PERF_DS_PERF;
   // XDSLRTFW-1402 :IOP_DS_ALL_ALL_BoostGhsToneDetectScale_XtalkForceDmtT1413(Start)
   OPTNArray[OPTN_AlgControl3] |= CMV_TO_IncreaseGhsToneDetectScale; /* XDSLRTFW-2191 */
   // XDSLRTFW-1402 :IOP_DS_ALL_ALL_BoostGhsToneDetectScale_XtalkForceDmtT1413(End)
#endif


   //XDSLRTFW-930 ADSLRTFW-1517 ENH_DS_BisPlus_BDCM_SRA_EnhanceDsSyncUpRate (START_END)
   OPTNArray[OPTN_SRA_RATE_DEGRADATION] = 5; //5 percent rate degradation

#ifdef HERC_API
    // Set Defaults from OPTN Array
    gt_HercADSL_OPTNMap_ModeControl.s_Offset0 =                 OPTNArray[OPTN_ModeControl];
    gt_HercADSL_OPTNMap_ModeControl.s_Offset1 =                 0;

    gt_HercADSL_OPTNMap_AlgControl.s_Offset0 =                  OPTNArray[OPTN_AlgControl] & 0x5FDF;
    gt_HercADSL_OPTNMap_AlgControl.s_Offset1 =                  0;
    gt_HercADSL_OPTNMap_AlgControl.s_Offset2 =                  0;

    gs_AutoMsgHandlerState =                                    CHECK_MODEM_MACRO_STATE;
    // XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead (START)
    gt_HercADSL_OPTNMap_EocPollControl.us_EocPollControl = OPTN_25_HERC_EocPollPrio1_ENABLE | OPTN_25_HERC_EocPollPrio2_ENABLE;
    gt_HercADSL_OPTNMap_EocPollControl.us_EocPollControl |= (0x1 << 8); // EOC Polling Period Scaling Factor, Bits 15 to 8
                                                                        // default = 1, configures a polling cycle of 5s/10s for prio1/prio2.
    // XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead (END)


    STAT_0_Map[0] = (int16*)(void *)&gt_HercADSL_STATMap_MacroState;
    STAT_1_Map[0] = (int16*)(void *)&gt_HercADSL_STATMap_ModeSelect;
    STAT_5_Map[0] = (int16*)(void *)&gt_HercADSL_STATMap_FailureState;

    OPTN_0_Map[0] =  (int16*)(void *)&gt_HercADSL_OPTNMap_ModeControl;
    OPTN_2_Map[0] =  (int16*)(void *)&gt_HercADSL_OPTNMap_AlgControl;
    //XDSLRTFW-380: Feature_US_BisPlus_All_USSRA_CMVRemap (start_end)
    OPTN_15_Map[0] = (int16*)&gt_HercADSL_OPTNMap_OlrControl;

   //XDSLRTFW-731 FIX_All_All_All_EnableBitSwapsAsPerVRxMsgSpec (Start_End)
    gt_HercADSL_OPTNMap_OlrControl.s_Offset0 |= (OPTN_15_HERC_BitSwap_US|OPTN_15_HERC_BitSwap_DS);

    //XDSLRTFW-310 Improve_BisPlus_DS_All_AdjustTargetMarginThroughCMV (start_end)
    OPTN_28_Map[0] = (int16*)(void *)&gt_HercADSL_OPTNMap_MarginControl;
    // XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead
    OPTN_25_Map[0] = (int16*)&gt_HercADSL_OPTNMap_EocPollControl;

    gt_HercADSL_MONIMap_EventConfigure.s_Offset0 =              0;
    gt_HercADSL_MONIMap_EventConfigure.s_Offset1 =              0;

    MONIMap[MONI_STATE_TRANSITIONS] = &gt_HercADSL_MONIMap_EventConfigure.s_Offset0;
    MONIMap[MONI_NE_LINE_FAILURES] = &gsa_HercADSL_MONIMap_AlarmCnfg[0];
    MONIMap[MONI_FE_LINE_FAILURES] = &gsa_HercADSL_MONIMap_AlarmCnfg[1];
    MONIMap[MONI_STATE_MACHINE_CONTROL] = &gsa_HercADSL_MONIMap_StateMachineConfig;
    MONIMap[MONI_NE_SHOW_FAIL_CONDITIONS] = (int16*)(void *)&gsa_HercADSL_MONIMap_ShowFailConditions[0];
    MONIMap[MONI_FE_SHOW_FAIL_CONDITIONS] = (int16*)(void *)&gsa_HercADSL_MONIMap_ShowFailConditions[1];

    // Initialization of the default reinit triggers.
    *(MONIMap[MONI_NE_SHOW_FAIL_CONDITIONS]) |= MONI_LOM_FAILURE;
    *(MONIMap[MONI_NE_SHOW_FAIL_CONDITIONS]) |= MONI_LOS_FAILURE;
#ifdef ISDN
   gt_HercADSL_OPTNMap_MarginControl.us_NMS_Ctrl = 0;
#else // New NMS implementation for AnnexA
    gt_HercADSL_OPTNMap_MarginControl.us_NMS_Ctrl =   (OPTN_NoiseMarginChange_NM_Ctrl_NMS_EN); // Add NMS to medley
    gt_HercADSL_OPTNMap_MarginControl.us_NMS_Ctrl |=  OPTN_NoiseMarginChange_NM_Ctrl_TxNoise_REVERB;// Tx noise during REVERB
    gt_HercADSL_OPTNMap_MarginControl.us_NMS_Ctrl |=  OPTN_NoiseMarginChange_NM_Ctrl_ADC_REVERB_EN; // ADC noise in REVERB
    gt_HercADSL_OPTNMap_MarginControl.us_NMS_Ctrl |=  OPTN_NoiseMarginChange_NM_Ctrl_NMS_PllRef; //copy back pll ref
    gt_HercADSL_OPTNMap_MarginControl.us_NMS_Ctrl |=  OPTN_NoiseMarginChange_NM_Ctrl_NMS_SNR_Save; // back up of Rev SNR, Medley SNR
    //gt_HercADSL_OPTNMap_MarginControl.us_NMS_Ctrl |=  OPTN_NoiseMarginChange_NM_Ctrl_UseEchoSNR_For_Medley;
    gt_HercADSL_OPTNMap_MarginControl.us_NMS_Ctrl |=  OPTN_NoiseMarginChange_NM_Ctrl_NMS_ST_Changes;
#endif

#endif //HERC_API

    /*========================================================================*/
    /* initialize CNFG */
    /*========================================================================*/
    //these cmvs are used by G9923x handshake
#ifdef HERC_API
    CNFG_0_Map[0] = (int16 *)(void *)(&gt_HercADSL_TPS_TC_Params[0]);
    CNFG_1_Map[0] = (int16 *)(void *)(&gt_HercADSL_TPS_TC_Params[1]);

    CNFG_2_Map[0] = (int16 *)(void *)(&gt_HercADSL_TPS_TC_Params[2]);
    CNFG_3_Map[0] = (int16 *)(void *)(&gt_HercADSL_TPS_TC_Params[3]);
    //XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching (Start)
    CNFG_58_Map[0] = (int16 *)(void *)&gus_Cnfg_Misc;
    //XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching (End)

    //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx_CMV_CNFG_80_INFO_229  (Start)
    CNFG_80_Map[0] =  (int16*)(void *)&gt_ReTxConfigInfo.us_ReTxConfigOptionBits;
    //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx_CMV_CNFG_80_INFO_229  (End)

   //XDSLRTFW-713 Feature_AB_All_All_All_SendVectorCodePointerInGHs (Start)
   gus_DsmCtrlCmv = G9935_VECTORING_DISABLED;            //Disable G.Vectoring mode by default
    CNFG_82_Map[0] =  (int16*)(void *)&gus_DsmCtrlCmv;
    //XDSLRTFW-2382 (Start_End)
    CNFG_89_Map[0] =  (int16 *)(void *)&gus_Bonding_PME_ID;
   //XDSLRTFW-713 Feature_AB_All_All_All_SendVectorCodePointerInGHs (End)
   PLAM_5_Map[0] =  (int16*)&gt_HercADSL_PLAMMap_g997_DataPathFailureStatus.s_OOS_Failure; // XDSLRTFW-1481 (Start_End)

#endif

#ifdef ISDN
#ifndef HERC_API
    CNFGMap[CNFG_TPS_TC_DS0] = (int16 *)(&gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_B]->ta_DSBearerChannel[0]);
    CNFGMap[CNFG_TPS_TC_DS1] = (int16 *)(&gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_B]->ta_DSBearerChannel[1]);

    CNFGMap[CNFG_TPS_TC_US0] = (int16 *)(&gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_B]->ta_USBearerChannel[0]);
    CNFGMap[CNFG_TPS_TC_US1] = (int16 *)(&gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_B]->ta_USBearerChannel[1]);
#endif
    CNFGMap[CNFG_HDLC_Overhead_Requirements] = (int16 *)(void *)(&gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_B]->t_Overhead);

    CNFGMap[CNFG_PMS_TC_DS0] = (int16 *)(void *)(&gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_B]->ta_DSLatencyPath[0]);
    CNFGMap[CNFG_PMS_TC_DS1] = (int16 *)(void *)(&gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_B]->ta_DSLatencyPath[1]);

    CNFGMap[CNFG_PMS_TC_US0] = (int16 *)(void *)(&gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_B]->ta_USLatencyPath[0]);
    CNFGMap[CNFG_PMS_TC_US1] = (int16 *)(void *)(&gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_B]->ta_USLatencyPath[1]);

    CNFGMap[CNFG_PMD_PARAMETERS] = (int16 *)(void *)(&gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_B]->t_PMD_Npar2);
#else
#ifndef HERC_API
    CNFGMap[CNFG_TPS_TC_DS0] = (int16 *)(&gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_A]->ta_DSBearerChannel[0]);
    CNFGMap[CNFG_TPS_TC_DS1] = (int16 *)(&gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_A]->ta_DSBearerChannel[1]);

    CNFGMap[CNFG_TPS_TC_US0] = (int16 *)(&gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_A]->ta_USBearerChannel[0]);
    CNFGMap[CNFG_TPS_TC_US1] = (int16 *)(&gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_A]->ta_USBearerChannel[1]);
#endif

    CNFGMap[CNFG_HDLC_Overhead_Requirements] = (int16 *)(void *)(&gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_A]->t_Overhead);

    CNFGMap[CNFG_PMS_TC_DS0] = (int16 *)(void *)(&gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_A]->ta_DSLatencyPath[0]);
    CNFGMap[CNFG_PMS_TC_DS1] = (int16 *)(void *)(&gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_A]->ta_DSLatencyPath[1]);

    CNFGMap[CNFG_PMS_TC_US0] = (int16 *)(void *)(&gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_A]->ta_USLatencyPath[0]);
    CNFGMap[CNFG_PMS_TC_US1] = (int16 *)(void *)(&gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_A]->ta_USLatencyPath[1]);

    CNFGMap[CNFG_PMD_PARAMETERS] = (int16 *)(void *)(&gpt_TxInfo->pta_G9923xInfo[G992_3_ANNEX_A]->t_PMD_Npar2);
#endif

    //these cmvs are used by plus handshake
#ifdef ISDN
    CNFGMap[CNFG_TPS_TC_DS0_PLUS] = (int16 *)(void *)(&gpt_TxInfo->pta_G9925xInfo[G992_5_ANNEX_B]->ta_DSBearerChannel[0]);
    CNFGMap[CNFG_TPS_TC_DS1_PLUS] = (int16 *)(void *)(&gpt_TxInfo->pta_G9925xInfo[G992_5_ANNEX_B]->ta_DSBearerChannel[1]);

    CNFGMap[CNFG_TPS_TC_US0_PLUS] = (int16 *)(void *)(&gpt_TxInfo->pta_G9925xInfo[G992_5_ANNEX_B]->ta_USBearerChannel[0]);
    CNFGMap[CNFG_TPS_TC_US1_PLUS] = (int16 *)(void *)(&gpt_TxInfo->pta_G9925xInfo[G992_5_ANNEX_B]->ta_USBearerChannel[1]);

    CNFGMap[CNFG_HDLC_Overhead_Requirements_PLUS] = (int16 *)(void *)(&gpt_TxInfo->pta_G9925xInfo[G992_5_ANNEX_B]->t_Overhead);

    CNFGMap[CNFG_PMS_TC_DS0_PLUS] = (int16 *)(void *)(&gpt_TxInfo->pta_G9925xInfo[G992_5_ANNEX_B]->ta_DSLatencyPath[0]);
    CNFGMap[CNFG_PMS_TC_DS1_PLUS] = (int16 *)(void *)(&gpt_TxInfo->pta_G9925xInfo[G992_5_ANNEX_B]->ta_DSLatencyPath[1]);

    CNFGMap[CNFG_PMS_TC_US0_PLUS] = (int16 *)(void *)(&gpt_TxInfo->pta_G9925xInfo[G992_5_ANNEX_B]->ta_USLatencyPath[0]);
    CNFGMap[CNFG_PMS_TC_US1_PLUS] = (int16 *)(void *)(&gpt_TxInfo->pta_G9925xInfo[G992_5_ANNEX_B]->ta_USLatencyPath[1]);

    CNFGMap[CNFG_PMD_PARAMETERS_PLUS] = (int16 *)(void *)(&gpt_TxInfo->pta_G9925xInfo[G992_5_ANNEX_B]->t_PMD_Npar2);
#else
    CNFGMap[CNFG_TPS_TC_DS0_PLUS] = (int16 *)(void *)(&gpt_TxInfo->pta_G9925xInfo[G992_5_ANNEX_A]->ta_DSBearerChannel[0]);
    CNFGMap[CNFG_TPS_TC_DS1_PLUS] = (int16 *)(void *)(&gpt_TxInfo->pta_G9925xInfo[G992_5_ANNEX_A]->ta_DSBearerChannel[1]);

    CNFGMap[CNFG_TPS_TC_US0_PLUS] = (int16 *)(void *)(&gpt_TxInfo->pta_G9925xInfo[G992_5_ANNEX_A]->ta_USBearerChannel[0]);
    CNFGMap[CNFG_TPS_TC_US1_PLUS] = (int16 *)(void *)(&gpt_TxInfo->pta_G9925xInfo[G992_5_ANNEX_A]->ta_USBearerChannel[1]);

    CNFGMap[CNFG_HDLC_Overhead_Requirements_PLUS] = (int16 *)(void *)(&gpt_TxInfo->pta_G9925xInfo[G992_5_ANNEX_A]->t_Overhead);

    CNFGMap[CNFG_PMS_TC_DS0_PLUS] = (int16 *)(void *)(&gpt_TxInfo->pta_G9925xInfo[G992_5_ANNEX_A]->ta_DSLatencyPath[0]);
    CNFGMap[CNFG_PMS_TC_DS1_PLUS] = (int16 *)(void *)(&gpt_TxInfo->pta_G9925xInfo[G992_5_ANNEX_A]->ta_DSLatencyPath[1]);

    CNFGMap[CNFG_PMS_TC_US0_PLUS] = (int16 *)(void *)(&gpt_TxInfo->pta_G9925xInfo[G992_5_ANNEX_A]->ta_USLatencyPath[0]);
    CNFGMap[CNFG_PMS_TC_US1_PLUS] = (int16 *)(void *)(&gpt_TxInfo->pta_G9925xInfo[G992_5_ANNEX_A]->ta_USLatencyPath[1]);

    CNFGMap[CNFG_PMD_PARAMETERS_PLUS] = (int16 *)(void *)(&gpt_TxInfo->pta_G9925xInfo[G992_5_ANNEX_A]->t_PMD_Npar2);
#endif

    CNFGMap[CNFG_tx_Cnfg_Nbc] = &gt_tx_config.s_Nbc;
    CNFGMap[CNFG_tx_Cnfg_Nlp] = &gt_tx_config.s_Nlp;
    CNFGMap[CNFG_tx_Cnfg_Rp] = &gt_tx_config.s_Rp[0];
    CNFGMap[CNFG_tx_Cnfg_Mp] = &gt_tx_config.s_Mp[0];
    CNFGMap[CNFG_tx_Cnfg_Lp] = &gt_tx_config.s_Lp[0];
    CNFGMap[CNFG_tx_Cnfg_Dp] = &gt_tx_config.s_Dp[0];
    CNFGMap[CNFG_tx_Cnfg_Tp] = &gt_tx_config.s_Tp[0];
    CNFGMap[CNFG_tx_Cnfg_Bpn] = &gt_tx_config.sa_Bpn[0][0];
    CNFGMap[CNFG_tx_Cnfg_FramingMode] = (int16*)(void *)&(gt_tx_config.s_FramingMode);
    CNFGMap[CNFG_tx_Cnfg_MSGLp] = &gt_tx_config.s_MSGlp;
    CNFGMap[CNFG_tx_Cnfg_MSGc] = &gt_tx_config.s_MSGc;

    CNFGMap[CNFG_rx_Cnfg_Nbc] = &gt_rx_config.s_Nbc;
    CNFGMap[CNFG_rx_Cnfg_Nlp] = &gt_rx_config.s_Nlp;
    CNFGMap[CNFG_rx_Cnfg_Rp] = &gt_rx_config.s_Rp[0];
    CNFGMap[CNFG_rx_Cnfg_Mp] = &gt_rx_config.s_Mp[0];
    CNFGMap[CNFG_rx_Cnfg_Lp] = &gt_rx_config.s_Lp[0];
    CNFGMap[CNFG_rx_Cnfg_Dp] = &gt_rx_config.s_Dp[0];
    CNFGMap[CNFG_rx_Cnfg_Tp] = &gt_rx_config.s_Tp[0];
    CNFGMap[CNFG_rx_Cnfg_Bpn] = &gt_rx_config.sa_Bpn[0][0];
    CNFGMap[CNFG_rx_Cnfg_FramingMode] = (int16*)(void *)&(gt_rx_config.s_FramingMode);
    CNFGMap[CNFG_rx_Cnfg_MSGLp] = &gt_rx_config.s_MSGlp;
    CNFGMap[CNFG_rx_Cnfg_MSGc] = &gt_rx_config.s_MSGc;

    CNFGMap[CNFG_tx_Cnfg_BCnToLPp] = (int16*)(void *)&guca_txBCnToLPp[0];
    CNFGMap[CNFG_rx_Cnfg_BCnToLPp] = (int16*)(void *)&guca_rxBCnToLPp[0];

    CNFGMap[CNFG_ADSL1_CONTROL] = (int16 *) (&gt_ADSL1_Control.DsRateCap);

   //XDSLRTFW-699: Fix_AB_US_All_GHsToneSetSelection (Start_End)
    CNFGMap[CNFG_GHS_CarSet] = (int16*)&gs_GhsCarSetCfg;

    //XDSLRTFW-148:SMS00918205 SMS00918215 Feature_AB_ALL_BisPlus_ALL_Optional_US_interlever_depth (Start End)
    CNFGMap[CNFG_US_PMS_TC_CTRL] = (int16 *)(void *)&gt_Optional_US_InlvDepth;

    /*========================================================================*/
    /* initialize INFO */
    /*========================================================================*/

#ifdef DANUBE
#ifdef TARGET_HW
    INFOMap[INFO_DebugTrail] = (int16*)&gsa_TrainStatesTrail;
#else
    INFOMap[INFO_DebugTrail] = (int16*)&gsa_StatesTrail;
#endif
#else
    INFOMap[INFO_DebugTrail] = (int16*)(void *)&gsa_StatesTrail;
#endif // DANUBE

#ifdef CALC_REVERB_SNR
    INFOMap[INFO_ReverbSnrBuf] = gsa_ReverbSnrBuf;
#endif
#ifdef CALC_REVERB_ECHO_SNR
    INFOMap[INFO_ReverbEchoSnrBuf] = gsa_ReverbEchoSnrBuf;
#endif
    INFOMap[INFO_MedleySnrBuf] = gsa_MedleySnrBuf;
   INFOMap[INFO_RxShowtimeSnrBuf] = gsa_RxShowtimeSnrBuf;

   //XDSLRTFW-965 Task_DS_BisPlus_All_AttachHercCMVINFO85 (Start_End)
   INFOMap[INFO_SNR_DS] = (int16*)(void *)guca_SNRBuf_NE;

   INFOMap[INFO_DECdelay] = &gs_pre_dec_h_delay;
    INFOMap[INFO_DECExponent] = &gs_pre_dec_h_exp;
    INFOMap[INFO_DECTaps] = gsa_pre_dec_h;

    //#ifndef HERC_API
    INFOMap[INFO_USBat] = (int16 *)(void *)guca_TxBat;
    INFOMap[INFO_DSBat] = (int16 *)(void *)guca_RxBat;
    INFOMap[INFO_USFineGains] = gsa_TxFineGains;
    INFOMap[INFO_DSFineGains] = gsa_RxFineGains;
    //#endif // #ifndef HERC_API

    INFOMap[INFO_TxState] = &gs_TxState;
    INFOMap[INFO_RxState] = &gs_RxState;
    INFOMap[INFO_TxNextState] = &gs_TxNextState;
    INFOMap[INFO_RxNextState] = &gs_RxNextState;
    INFOMap[INFO_TxStateJumpFrom] = &gs_TxStateJumpFrom;
    INFOMap[INFO_RxStateJumpFrom] = &gs_RxStateJumpFrom;

    // JumpTo CMVs are no longer valid, they are also removed from MP files.
    // Two new global variables "gpF_TxStateJumpTo" and "gpF_RxStateJumpTo"will
    // be added in and initialized as Done State function pointer.
    // THERE IS NO CMV CONTROL FOR IT. The only way to changes their values is
    // by a "memory write" command in WinHost.

    //!!! The following 2 lines need to be deleted soon!
    //   INFOMap[INFO_TxStateJumpTo] = &gs_TxStateJumpTo;
    //   INFOMap[INFO_RxStateJumpTo] = &gs_RxStateJumpTo;

    INFOMap[INFO_AECdelay] = &gs_pre_aec_h_delay;
    INFOMap[INFO_AECExponent] = &gs_pre_aec_h_exp;
    INFOMap[INFO_AECTaps] = gsa_pre_aec_h;
    INFOMap[INFO_TDQExponent] = &gs_pre_tdq_h_exp;
    INFOMap[INFO_TDQTaps] = gsa_pre_tdq_h;
    INFOMap[INFO_FDQExponent] = (int16 *)(void *)guca_pre_FDQ_exp;
    INFOMap[INFO_FDQTaps] = gsa_pre_FDQ_coef;
    INFOMap[INFO_BitloadFirstChannel] = &gs_RxBitLoadFirstChannel;
    INFOMap[INFO_BitloadLastChannel] = &gs_RxBitLoadLastChannel;
    INFOMap[INFO_RCMsgs1] = (int16*)(void *)&gt_RCMsgs1_bis;
    INFOMap[INFO_RMsgs1] = (int16*)(void *)&gt_RMsgs1;
    INFOMap[INFO_RMsgRA] = (int16*)(void *)&gt_RMsgRA;
    INFOMap[INFO_RCMsgRA] = (int16*)(void *)&gt_RCMsgRA;
    INFOMap[INFO_RMsg2] = (int16*)(void *)&gt_RMsg2;
    INFOMap[INFO_RCMsg2] = (int16*)(void *)&gt_RCMsg2;
    INFOMap[INFO_BitLoadOK] = (int16*)(void *)&gft_BitloadOK;
    INFOMap[INFO_RCRates1] = (int16*)(void *)guca_R_C_Rates1;
    INFOMap[INFO_RRates1Tab] = (int16*)(void *)&guca_RRates1Tab;
    INFOMap[INFO_RMsgs1Tab] = (int16*)(void *)&guca_RMsgs1Tab;
    INFOMap[INFO_RMsgRATab] = (int16*)(void *)&guca_RMsgRATab;
    INFOMap[INFO_RRatesRA] = (int16*)(void *)&guc_RRatesRA;
    INFOMap[INFO_RCRatesRA] = (int16*)(void *)&gsa_RCRatesRA;
    INFOMap[INFO_RRates2] = (int16*)(void *)&guc_RRates2;
    INFOMap[INFO_RCRates2] = (int16*)(&gs_RCRates2);
    INFOMap[INFO_MemoryBasePtr] = (int16*)(void *)(&INFOMap[INFO_MemoryPtr]);
    INFOMap[INFO_RxBitSwapFlag] = (int16*)(void *)&gft_RxBitSwapFlag;
    INFOMap[INFO_ExcessMarginReduction] = (int16*)(void *)&gt_FineGainInfo;
    INFOMap[INFO_ShowtimeSNRUpdateCount] = (int16*)(&gus_ShowtimeSNRUpdateCount);
    INFOMap[INFO_ShowtimeFDQUpdateCount] = (int16*)(&gus_ShowtimeFDQUpdateCount);
    INFOMap[INFO_ShowtimeDECUpdateCount] = (int16*)(&gus_ShowtimeDECUpdateCount);
    INFOMap[INFO_CopyRxBuffer]=(int16*)(void *)&gft_CopyRxBuffer;
    INFOMap[INFO_RxToneBuf]=gsa_RxToneBuf;
    INFOMap[INFO_TxToneBuf]=gsa_TxToneBuf;
    INFOMap[INFO_Version]=(int16 *)(void *)gusa_FW_version_number; //XDSLRTFW-3364 (Start_End)
    INFOMap[INFO_TimeStamp]=(int16*)(void *)&guca_TimeStampString;
    INFOMap[INFO_feSystemVendorID] = (int16*)(void *)guca_fe_SystemVendorID;
    INFOMap[INFO_feSystemVersionNum] = (int16*)(void *)guca_fe_SystemVersionNum;
    INFOMap[INFO_feSystemSerialNum] = (int16*)(void *)guca_fe_SystemSerialNum;
    INFOMap[INFO_MemoryPtr] = (int16*)0x10000;  //Start of Bulk memory in Socrates.  Can be modified using INFO 45.
    INFOMap[INFO_neSystemVendorID] = (int16*)(void *)guca_ne_SystemVendorID;
    INFOMap[INFO_neSystemSerialNum] = (int16*)(void *)guca_ne_SystemSerialNum;
    INFOMap[INFO_neSystemVersionNum] = (int16*)(void *)guca_ne_SystemVersionNum;
    INFOMap[INFO_DSBlackoutTone] = (int16*)(void *)&guca_RMsgPCBTab[4];
    INFOMap[INFO_feG9941VendorID] = (int16*)(void *)&guca_fe_G9941_VendorID;
    INFOMap[INFO_neG9941VendorID] = (int16*)(void *)&guca_ne_G9941_VendorID;
    INFOMap[INFO_neT1413VendorID] = &gs_ne_T1413_VendorID;
    INFOMap[INFO_feT1413VendorID] = &gs_fe_T1413_VendorID;

   //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START)
   INFOMap[INFO_DS_VIRTUAL_NOISE] = &gs_zero_cmv;
      //Note: This CMV is initialized to "gt_DS_RefVirtNoiseLevel_ADSL2" in
      //RCQuiet1RxF_BIS( ), as "gt_DS_RefVirtNoiseLevel_ADSL2" is placed in
      //"DATA_BULKO1" section , which is available after G.Hs.
   //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (END)

    //populate SelfTestResult
    gt_SelfTestResult.ps_NE_LPR = &gs_NE_LPR_indication;;
    INFOMap[INFO_SelfTestResult] = (int16*)(void *)&gt_SelfTestResult;
    INFOMap[INFO_feSystemCapabilities] = (int16*)(void *)&guca_FE_ModeCapabilities;

    //populate near/far end TestParams
#ifndef HERC_API
    INFOMap[INFO_TestParamsDS] = (int16*)&gt_NearEndParam;
#else
    INFOMap[INFO_TestParamsDS] = (int16*)(void *)&gt_HercADSL_NearEndParam;
#endif // #ifndef HERC_API
    INFOMap[INFO_TestParamsUS] = (int16*)(void *)&gt_FarEndParam;
    INFOMap[INFO_LD_OtherDS] = (int16*)(void *)&gt_DS_LDParam;
    INFOMap[INFO_LD_OtherUS] = (int16*)(void *)&gt_US_LDParam;



    INFOMap[INFO_HLIN_DS] = gpsa_RxHlin;
    INFOMap[INFO_HLIN_US] = (int16*)(void *)gpuca_R_C_MSG2_LD;
#ifdef HERC_API
    INFO_74_Map[0] = gsa_RxHlogDS;
    INFO_76_Map[0] = (int16*)(void *)guca_QLN;
#else
    INFOMap[INFO_HLOG_DS] = gsa_RxHlogDS;
    INFOMap[INFO_QLN_DS] = (int16*)(guca_QLN);
#endif
    // XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead (START)
    // @note: SOORAJ, 02-Jan-2013 - INFO 75, 77 & 78 assigned only for Loop Diagnostics mode;
    // To extend the CMV support for all (Showtime) links, reinitialising the pointers with showtime buffers.
    INFOMap[INFO_HLOG_US] = (int16*)(void *)gus_US_Hlogf_m;
    INFOMap[INFO_QLN_US] = (int16*)(void *)guca_US_Quiet_Line_Noise;
    INFOMap[INFO_SNR_US] = (int16*)(void *)guca_US_ShowtimeSNR;
    // XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead (END)

#ifdef HERC_API

    // ADSL Group Size = 1 per Standard.  Set = 2 as workaround
    // to instruct ME of the sub-sampling currently used.
    gt_HercADSL_INFOMap_ChanMeasParamsDS.s_HLING    =   1;
    gt_HercADSL_INFOMap_ChanMeasParamsDS.s_HLOGG    =   1;
    gt_HercADSL_INFOMap_ChanMeasParamsDS.s_QLNG     =   1;
    gt_HercADSL_INFOMap_ChanMeasParamsDS.s_SNRG     =   1;
    gt_HercADSL_INFOMap_ChanMeasParamsUS.s_HLING    =   1;
    gt_HercADSL_INFOMap_ChanMeasParamsUS.s_HLOGG    =   1;
    gt_HercADSL_INFOMap_ChanMeasParamsUS.s_QLNG     =   1;
    gt_HercADSL_INFOMap_ChanMeasParamsUS.s_SNRG     =   1;

    INFOMap[INFO_MeasuremtTimesDS] = (int16*)(void *)&gt_HercADSL_INFOMap_ChanMeasParamsDS;
    INFOMap[INFO_MeasuremtTimesUS] = (int16*)(void *)&gt_HercADSL_INFOMap_ChanMeasParamsUS;
#else
    INFOMap[INFO_MeasuremtTimesDS] = (int16*)(&gt_DS_MeasurementPeriod);
    INFOMap[INFO_MeasuremtTimesUS] = (int16*)(&gt_US_MeasurementPeriod);
#endif  // #ifdef HERC_API

    INFOMap[INFO_ME_HDLC_TxBuffer] = (int16*)(void *)guca_Tx_ME_HDLCMsgBuffer;
    INFOMap[INFO_ME_HDLC_RxBuffer] = (int16*)(void *)guca_Rx_ME_HDLCMsgBuffer;
    INFOMap[INFO_ME_HDLC_Params] = (int16*)(void *)&gt_ME_HDLC_Params;

    INFOMap[INFO_RX_CLEAR_EOC] = (int16*)(void *)&gt_RxClearEocBuf_CMV;

    INFOMap[INFO_DebugTrail_Trigger] = (int16*)(void *)&gt_debugTrailTriggerControl;
    INFOMap[INFO_DebugTrail_Collect] = (int16*)(void *)&gt_debugTrailCollectControl;

#ifdef PCM_INTERFACE_SUPPORT
    l_Addr = (int32)(&(gt_PCMInterface[0]));
    gsa_PCMInfo[0] = l_Addr & 0xFFFF;
    gsa_PCMInfo[1] = (l_Addr>>16) & 0xFFFF;
    gsa_PCMInfo[2] = 1;
    INFOMap[INFO_PCM_Interface] = (int16*)&(gsa_PCMInfo[0]);
#endif

    INFOMap[INFO_TxMedleyFirstCh]   = (int16*)&gs_TxMedleyFirstCh ;
    INFOMap[INFO_TxMedleyLastCh] = (int16*)&gs_TxMedleyLastCh ;

#ifdef TARGET_HW
    INFOMap[INFO_GPIO_Control] = (int16*)(void *)&gt_Gpio;
#endif
    INFOMap[INFO_DerivedProps_LatencyPath_DS] = (int16*)(void *)&gt_DerivedFrameProperties_DS;
    INFOMap[INFO_DerivedProps_LatencyPath_US] = (int16*)(void *)&gt_DerivedFrameProperties_US;
    INFOMap[INFO_NominalTxPower] = (int16*)&gus_TxGain_NoCutBack;
    INFOMap[INFO_US_OLRPMCnt] = (int16*)(void *)&gt_USOLRPMCnt;
    INFOMap[INFO_DS_OLRPMCnt] = (int16*)(void *)&gt_DSOLRPMCnt;

    INFOMap[INFO_ADI_CMV] = (int16*)0x40000; //dummy, start of deilv memory;


    INFOMap[INFO_DSHandshakeBIS] = (int16*)(void *)&gt_HandshakeBis;

    INFOMap[INFO_StructureSizeOffset] = (int16*)(void *)&gt_StructureSizeInfo;

    //map the G.HS Tssi info structure
    INFOMap[INFO_GHS_US_TSSI_INFO] = (int16*)(void *)&gt_GHS_USTssiInfo;
    INFOMap[INFO_GHS_DS_TSSI_INFO] = (int16*)(void *)&gt_GHS_DSTssiInfo;

    INFOMap[INFO_PMD_CONTROL] = (int16*)(void *)&gt_TxPMDControl;

   //XDSLRTFW-332 IOP_A_DS_BisPlus_CNXT_BitswapDuetoRFI (START-END)
//#ifdef ISDN   //Feature_ALL_ALL_ALL_EnableInfxCMV (Start_End)
    INFOMap[INFO_Infx_CMV] = (int16*)(void *)&gt_INFX_CMV;
//#endif       //Feature_ALL_ALL_ALL_EnableInfxCMV (Start_End)

   //XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (Start)
   INFOMap[INFO_BITSWAP_EVACUATION_THRESHOLD] = (int16 *)&gs_bitswap_evacuation_thrd;
   //XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (End)
   //XDSLRTFW-496: Feature_T1413_Info(start)
    INFOMap[INFO_VR9NeT1413VendorID] = &gs_ne_T1413_VendorID;
    INFOMap[INFO_VR9FeT1413VendorID] = &gs_fe_T1413_VendorID;
    INFOMap[INFO_VR9NeT1413RevisionNum] = (int16*)(void *)&gt_RMsgs1.us_T1413_RevNo;
    INFOMap[INFO_VR9FeT1413RevisionNum] = (int16*)(void *)&gt_RCMsgs1.us_T1413_RevNo;
    INFOMap[INFO_VR9NeT1413VendorRevisionNum] = (int16*)(void *)&gt_RMsgs1.us_T1413_Vendor_RevNo;
    INFOMap[INFO_VR9FeT1413VendorRevisionNum] = (int16*)(void *)&gt_RCMsgs1.us_T1413_Vendor_RevNo;
   //XDSLRTFW-496: Feature_T1413_Info(end)
#ifdef VRX518
   INFOMap[INFO_AFECHIP] = (int16*)(void *)&gs_HybTableForce;
   //gus_AfeChipId not used in VRx518
#else
   INFOMap[INFO_AFECHIP] = (int16*)(void *)&gus_AfeChipId;
#endif
    INFOMap[INFO_DEBUG_VAR] = (int16*)(void *)&gsa_NMS_Force;
    gs_ctune_poco_bin_force = -1;
    INFOMap[INFO_CTUNE_VAL] = (int16*)(void *)&gs_ctune_poco_bin_force;
    INFOMap[INFO_HYBIDX_FORCE] = (int16*)(void *)&gs_HybTrIndexDbg;


#ifdef DANUBE
#ifdef TARGET_HW
    INFOMap[INFO_RxMarginBuf] = (int16*)(ADSL_IMAGE_BASE_ADDR + XMEM_RX_MARGIN_BUF_ADDR);
#endif // TARGET_HW
#endif // DANUBE

#ifdef HERC_API
#ifdef DEBUG_STREAMING
   INFOMap[INFO_DEBUG_STREAM_CONTROL] = (int16*)(void *)&gt_debugStreamControl;
   INFOMap[INFO_DEBUG_STREAM_CONFIGURE] = (int16*)(void *)&gt_debugStreamConfigure;
#endif

    INFO_203_Map[0] = (int16*)(void *)&guca_FE_ModeCapabilities;
    INFO_209_Map[0] = &gs_Fw_ImageInfoGet;

   //XDSLRTFW-230 Bug_All_All_All_CmvRemapInfo221 (Start_End)
   INFO_221_Map[0] = (int16*)(void *)&gt_Bonding_DiscAggr_Status;


   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx_CMV_CNFG_80_INFO_229  (Start)
    INFO_229_Map[0] = (int16*)(void *)&gt_ReTxConfigInfo.ft_ReTxOn;
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx_CMV_CNFG_80_INFO_229  (End)

   // XDSLRTFW-1782 : CAPTURE_CONFIGURATION_MESSAGES (START)
   INFO_241_Map[0] = (int16*)(void *)&gt_Decoded_ProfileInfo_t;
   // XDSLRTFW-1782 : CAPTURE_CONFIGURATION_MESSAGES (END)

   // XDSLRTFW-3566 (Start_End)
   INFO_244_Map[0] = (int16 *)(void *)&gus_PPEClock_Configured;
#endif // #ifdef HERC_API

    /*========================================================================*/
    /* initialize RATE */
    /*========================================================================*/

#ifndef HERC_API
    RATEMap[RATE_UsRate] = (int16*)(gla_USDataRate);
    RATEMap[RATE_DsRate] = (int16*)(gla_DSDataRate);
#else
    RATEMap[RATE_UsRate] = (int16*)(void *)&gt_HercADSL_USRateCMV;
    RATEMap[RATE_DsRate] = (int16*)(void *)&gt_HercADSL_DSRateCMV;
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (Start)
    RATEMap[RATE_RETX_DsETR] = (int16*)(void *)&gt_ReTXStats.ul_ReTX_ReceiverETR;
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (End)
#endif // #ifndef HERC_API

    RATEMap[RATE_AvgMargin] = &gs_RxAvMargin;
    RATEMap[RATE_USFastBytes] = &gt_TxShowTimeVars.t_FrameParms[FAST_DATA_PATH].s_RawFrameSize;
    RATEMap[RATE_USIntlBytes] = &gt_TxShowTimeVars.t_FrameParms[INTERLEAVE_DATA_PATH].s_RawFrameSize;
    RATEMap[RATE_USFastCheckBytes] = &gt_TxShowTimeVars.t_FrameParms[FAST_DATA_PATH].s_R;
    RATEMap[RATE_USIntlCheckBytes] = &gt_TxShowTimeVars.t_FrameParms[INTERLEAVE_DATA_PATH].s_R;
    RATEMap[RATE_USIntlDepth] = &gt_tx_config.s_Dp[INTERLEAVE_DATA_PATH];
    RATEMap[RATE_USSymCodeWord] = &gt_tx_config.s_Mp[INTERLEAVE_DATA_PATH];
    RATEMap[RATE_USFastCodeWordSize] = &gt_TxShowTimeVars.t_FrameParms[FAST_DATA_PATH].s_CodewordSize;
    RATEMap[RATE_USIntlCodeWordSize] = &gt_TxShowTimeVars.t_FrameParms[INTERLEAVE_DATA_PATH].s_CodewordSize;
    RATEMap[RATE_DSFastBytes] = &gt_RxShowTimeVars.t_FrameParms[FAST_DATA_PATH].s_RawFrameSize;
    RATEMap[RATE_DSIntlBytes] = &gt_RxShowTimeVars.t_FrameParms[INTERLEAVE_DATA_PATH].s_RawFrameSize;
    RATEMap[RATE_DSFastCheckBytes] = &gt_RxShowTimeVars.t_FrameParms[FAST_DATA_PATH].s_R;
    RATEMap[RATE_DSIntlCheckBytes] = &gt_RxShowTimeVars.t_FrameParms[INTERLEAVE_DATA_PATH].s_R;
    RATEMap[RATE_DSIntlDepth] = &gt_rx_config.s_Dp[INTERLEAVE_DATA_PATH];
    RATEMap[RATE_DSSymCodeWord] = &gt_rx_config.s_Mp[INTERLEAVE_DATA_PATH];
    RATEMap[RATE_DSFastCodeWordSize] = &gt_RxShowTimeVars.t_FrameParms[FAST_DATA_PATH].s_CodewordSize;
    RATEMap[RATE_DSIntlCodeWordSize] = &gt_RxShowTimeVars.t_FrameParms[INTERLEAVE_DATA_PATH].s_CodewordSize;

#ifdef DO_PLAM
    /*========================================================================*/
    /* initialize PLAM */
    /*========================================================================*/

    /* Near End Performance Counts */
    PLAMMap[PLAM_NearEndFailureFlags] = &gs_NearEndFailureReported;
    PLAMMap[PLAM_NearEndCrcCnt] = (int16*)(void *)&gusa_CRC_count[0];
    PLAMMap[PLAM_CorrectedRSErrors] = &gsa_CorrectedRSErrors[0];
    PLAMMap[PLAM_LongNearEndCrcCnt] = (int16*)(void *)&gula_CRC_count[0];
    PLAMMap[PLAM_LongCorrectedRSErrors] = (int16*)(void *)&gula_CorrectedRSErrors[0];

    PLAMMap[PLAM_NearEndECSCnt]     = &gs_fec_err_sec_cnt;
    PLAMMap[PLAM_NearEndESCnt]      = &gs_err_sec_cnt;
    PLAMMap[PLAM_NearEndSESCnt]     = &gs_sev_err_sec_cnt;
    PLAMMap[PLAM_NearEndLOSSCnt]    = &gs_los_err_sec_cnt;
    PLAMMap[PLAM_NearEndUASLCnt]    = &gs_unavail_err_sec_cnt;
    PLAMMap[PLAM_NearEndSfCntLSW]   = &gs_tx_sframe_count_lsw;
    PLAMMap[PLAM_NearEndSfCntMSW]   = &gs_tx_sframe_count_msw;

    PLAMMap[PLAM_NearEndHECErrCnt] = (int16*)(void *)&gula_hec_error_cnt[0];
    PLAMMap[PLAM_SEFCnt] = &gs_sef_event_cnt;

    PLAMMap[PLAM_NearEndCellTotCnt] = (int16*)(void *)&gula_tot_cell_cnt[0];
    //Initialise PLAM 19 Idle Cell Bit Error Count
    PLAMMap[PLAM_NearEndIdleCellBitErrs] = (int16*)(void *)&gula_bit_error_cnt[0];
    PLAMMap[PLAM_NearEndCDTotCnt_BuffFull] = (int16*)(void *)&gula_dropped_cell_fullbuffer_cnt[0];
    PLAMMap[PLAM_NearEndHECTotCnt] = (int16*)(void *)&gula_tot_hec_cnt[0];
    //XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping (Start)
    PLAMMap[PLAM_NearEndTxIdleCellCnt] = (int16*)(void *)&gula_tx_idle_cell_cnt[0];
    PLAMMap[PLAM_NearEndTxNonIdleCellCnt] = (int16*)(void *)&gula_tx_non_idle_cell_cnt[0];
    //XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping (End)

    /* Far End Performance Counts */
    PLAMMap[PLAM_FarEndFailureFlags] = &gs_FarEndFailure;

    PLAMMap[PLAM_FarEndFebeCnt] = &gsa_febe_cnt[0];

    PLAMMap[PLAM_FarEndFecCnt] = &gsa_ffec_cnt[0];


    PLAMMap[PLAM_LongFarEndFebeCnt] = (int16*)(void *)&gla_febe_cnt[0];

    PLAMMap[PLAM_LongFarEndFecCnt] = (int16*)(void *)&gla_ffec_cnt[0];
    PLAMMap[PLAM_FarEndFECSCnt] = &gs_ecs_fe_cnt;
    PLAMMap[PLAM_FarEndESCnt] = &gs_es_fe_cnt;
    PLAMMap[PLAM_FarEndSESCnt] = &gs_ses_fe_cnt;
    PLAMMap[PLAM_FarEndLOSSCnt] = &gs_loss_fe_cnt;
    PLAMMap[PLAM_FarEndUASLCnt] = &gs_uasl_fe_cnt;

    /* (these are left out temporarily and will be populated soon) */
    PLAMMap[PLAM_FarEndHECErrCnt] = (int16*)(void *)&gula_fhec_cnt[0];

    PLAMMap[PLAM_FarEndCellTotCnt] = (int16*)(void *)&gula_fe_tot_cell_cnt[0];

    PLAMMap[PLAM_FarEndHECTotCnt] = (int16*)(void *)&gula_fe_tot_hec_cnt[0];
    PLAMMap[PLAM_FarEndIdleCellBitErrs] = (int16*)(void *)&gula_fe_bit_error_cnt[0];

    PLAMMap[PLAM_SNRMargin] = &(gt_NearEndParam.s_SnrMargin);
    PLAMMap[PLAM_SNRMargin_OneOverTen_dB_Resolution] = &gs_SnrMargin_OneOverTen_dB_Resolution;



#endif /* DO_PLAM */

#ifdef HERC_API
    CNTRMap[CNTR_NE_LinePerfCount] = (int16*)(void *)&gt_HercADSL_CNTRMap_g997_NE_LinePerfCount;
    CNTRMap[CNTR_FE_LinePerfCount] = (int16*)(void *)&gt_HercADSL_CNTRMap_g997_FE_LinePerfCount;

    // XDSLRTFW-575: Counter Write back in ADSL mode (Start)
    CNTRMap[CNTR_NE_CRC_Running] = (int16*)(void *)&gt_HercADSL_CNTRMap_g997_NE_ChPerf_CRCStats; //gla_g997_CRC_Runningcnt[0];
    CNTRMap[CNTR_NE_FEC_Running] = (int16*)(void *)&gt_HercADSL_CNTRMap_g997_NE_ChPerf_FECStats; //gla_g997_FEC_Runningcnt[0];

    CNTRMap[CNTR_FE_CRC_Running] = (int16*)(void *)&gt_HercADSL_CNTRMap_g997_FE_ChPerf_CRCStats; //gla_g997_FE_CRC_Runningcnt[0];
    CNTRMap[CNTR_FE_FEC_Running] = (int16*)(void *)&gt_HercADSL_CNTRMap_g997_FE_ChPerf_FECStats; //gla_g997_FE_FEC_Runningcnt[0];
    // XDSLRTFW-575: Counter Write back in ADSL mode (End)

    CNTRMap[CNTR_NearEndHECErrCnt] = (int16*)(void *)&gula_hec_error_cnt[0];
    CNTRMap[CNTR_NearEndHECTotCnt] = (int16*)(void *)&gula_tot_hec_cnt[0];
    CNTRMap[CNTR_NearEndCellTotCnt] = (int16*)(void *)&gula_tot_cell_cnt[0];
    CNTRMap[CNTR_NearEndIdleCellBitErrs] = (int16*)(void *)&gla_g997_cell_bit_errs[0];
    //XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (start_end)
    CNTR_45_Map[0] = (int16*)(void *)&gt_HercADSL_CNTRMap_g997_PtmPerf_NE;
    CNTR_46_Map[0] = (int16*)(void *)&gt_HercADSL_CNTRMap_g997_NE_DataPathPerfCount;
    AINFMap[AINF_ADSL_PCB] = (int16*)(void *)&gt_HercADSL_PCB;
    AINFMap[AINF_DS_FRAMING_INFO_LP0] = (int16*)(void *)&gt_HercADSL_Framing;
    AINFMap[AINF_US_FRAMING_INFO_LP0] = (int16*)(void *)&gt_HercADSL_Framing;
    AINFMap[AINF_DS_FRAMING_INFO_LP1] = (int16*)(void *)&gt_HercADSL_Framing;
    AINFMap[AINF_US_FRAMING_INFO_LP1] = (int16*)(void *)&gt_HercADSL_Framing;

    AINFMap[AINF_US_BAT] = (int16 *)(void *)guca_TxBat;
    AINFMap[AINF_DS_BAT] = (int16 *)(void *)guca_RxBat;
    AINFMap[AINF_US_FINEGAINS] = gsa_TxFineGains;
    //AINFMap[AINF_DS_FINEGAINS] = &gsa_HercADSL_RxFineGains[0];

    //XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping (Start_End)
    CNTR_51_Map[0] = (int16*)(void *)&gt_HercADSL_CNTRMap_g997_FE_DataPathPerfCount;

    //XDSLRTFW-151 :Feature_AB_ALL_ALL_NE_ATM_TC_CNTRS_Mapping (Start_End)
    CNTR_53_Map[0] = (int16*)(void *)&gt_g997_AtmPerf_TX_UICELL;

    // XDSLRTFW-201 Feature_US_ALL_ALL_LPR(start_End)
    DSLMap[DSL_LPR_TRIGGER] = (int16*)(void *)&gus_Set_LPR;

   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (Start)
    CNTR_43_Map[0] = (int16 *)(void *)&gt_ReTXStats.ul_ErrorFreeBits;
    //XDSLRTFW-1634 (Start_End)
    CNTR_44_Map[0] = (int16 *)(void *)&gt_ReTXStats.ul_RetransmittedDtuCnt;
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (End)

    //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
    CNTR_56_Map[0] = (int16*)(void *)&gus_Zep_Tx_DelayCnt;
    CNTR_57_Map[0] = (int16*)(void *)&gus_LinkDownState_SymCount;
    //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)

#endif // HERC_API

    //Feature_ALL_ALL_ALL_AFE_DFE_3GLP_Status (Start_End)
    //Enhancement_AB_ALL_ALL_ALL_Added_DSL_CMV_GROUP (Start_End)
    DSLMap[DSL_STATUS_AFE_DFE_3GLP] = (int16 *)(void *)&gt_RdyOvfUdfStatus;
    DSLMap[DSL_HYBRID_TYPE]         = (int16*)(void *)&gus_HybridType;
    // Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting (Start_End)
    DSLMap[DSL_EDcontrol]           =  &gs_DSL_EDcontrol;
    DSLMap[DSL_LD_MODE]             = (int16*)(void *)&gus_LD_Mode;
    //XDSLRTFW-278: Feature_AB_ALL_ALL_ARX208_Support_DSL_CMV (Start_End)
    DSLMap[DSL_AFE_ChipDetails]         =  (int16 *)(void *)&gusa_AfeChipId[0];
   //XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping(Start_End)
   DSLMap[DSL_ADSL_HNSK_TC_MODE] = (int16 *)(void *)&gt_ADSL_TcMode_Reprt;

   //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START)
   DSLMap[DSL_FeaturesControl] = &gs_DSL_FeaturesControl;

   // XDSLRTFW-1481 (Start)
   DSLMap[DSL_DS_Pilot_Indexes] =  (int16*)(void *)(DsStPilotDescriptorTable_t*)&gt_DS_StPilotDescriptorTable;
   // XDSLRTFW-1481 (End)

   DSL_4_Map[0] = (int16*)(void *)&gt_AFEConfig; //XDSLRTFW-3705 (Start_End)

#ifdef ADSL_62
//XDSLRTFW-315: Feature_ALL_ALL_ALL_DSL_PPE_CLOCK_CONTROL (Start)
   DSLMap[DSL_PPE_CLOCK_CONTROL] =  (int16*)(void *)&gus_PpeClockControl;
//XDSLRTFW-315: Feature_ALL_ALL_ALL_DSL_PPE_CLOCK_CONTROL (End)

//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect_CMVRemap(start)
//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (START)
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
   DSLMap[DSL_NLNF_METRICS_IBS] = (int16 *)(void *)&gt_nlnf_metrics_ibs;
#endif //#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
   //XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (END)
   DSLMap[DSL_LOOPLENGTH_ESTIMATION] = (int16 *)(void *)&gt_LoopLength_ft;
   DSLMap[DSL_HYBRID_INFO] = (int16 *)(void *)&gt_HybridInfo;
   DSLMap[DSL_OPTIONS] = (int16 *) &gt_ApiOptions;

   //XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map (Start)
   DSLMap[DSL_ADSL_FEATURE_MAP] = (int16 *)(void *)&gt_AdslFeatureMap;
   //XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map (End)

   DSLMap[DSL_OPERATOR_SELECT]      =  (int16*)&gt_Dsl_Operator_Select; // XDSLRTFW-1792 (Start_End)

   //XDSLRTFW-508 Fix_DS_All_All_SuppressCounterWriteFromDSLAPI (Start_End)
   DSLMap[DSL_INTEROP_OPTIONS] = (int16 *) &gt_InteropOptions;
   //XDSLRTFW-957 VR9_VRX318_ADSL_FW_PPE_MISMATCH (Start_End)
   DSLMap[DSL_TC_MODE_USED] = (int16 *)(void *)&gus_TcModeUsed_PPE;

   DSLMap[DSL_FW_InternalControl] = (int16 *)(void *)&gus_DSL_FW_InternalControl;

   //XDSLRTFW-2442 (Start)
//XDSLRTFW-561 Enhancement_All_All_All_FreqOffset [Start]
   gs_InitFreqOffsetDelta_ppm = 0;
   DSLMap[DSL_CRYSTAL_OFFSET] = (int16 *)&gs_InitFreqOffsetDelta_ppm;
//XDSLRTFW-561 Enhancement_All_All_All_FreqOffset [End]
   //XDSLRTFW-2442 (End)

   // XDSLRTFW-1205 ENH_DS_ALL_ALL_LOMx_ReInit (Start)
   DSLMap[DSL_CONFIG_REINIT_THRESH] = (int16*)(void *)&gt_ReInit_Threshold;
   // XDSLRTFW-1205 ENH_DS_ALL_ALL_LOMx_ReInit (End)

   // XDSLRTFW-3566se (Start_End)
   DSLMap[DSL_PPE_CLOCK_CONFIGURE] = (int16 *)(void *)&gus_PPEClockConfigure;

   // XDSLRTFW-3662 (Start)
   DSLMap[DSL_PPA_FW_VERSION] = (int16 *)(void *)&gusa_PPA_FW[0];
   DSLMap[DSL_PPE_FW_VERSION] = (int16 *)(void *)&gusa_PPE_FW[0];
   // XDSLRTFW-3662 (End)

   // CRXDSLRTFW-79 (Start)
   gt_ReInit_Threshold.s_LOM_ReInit_Threshold = 60;
   gt_ReInit_Threshold.s_SESx_ReInit_Threshold = 30;
   gt_ReInit_Threshold.s_ESx_ReInit_Threshold = 90;
   // CRXDSLRTFW-79 (End)
   //XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect_CMVRemap(end)

#ifdef DEBUG_TRACES
// XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer(START)

   //Debug Buffer CMV initialization
   DSLMap[DSL_DEBUGBUFF_STATUS]              = (int16 *)(void *)&gt_DebugBufferStatus;
   DSLMap[DSL_DEBUGBUF_CONTROL]              = (int16 *)(void *)&gt_DebugBuffControl;
   // XDSLRTFW-3648(Start)
   DSLMap[DSL_DEBUGBUFF_GHS_TO_EXCHANGE]     = (int16 *)(void *)&gula_DebugBuffer_BAR15[0];
   DSLMap[DSL_DEBUGBUF_SHOWTIME]             = (int16 *)(void *)&gula_DebugBuffer_BAR15[500];
   // XDSLRTFW-3648(End)
   DSLMap[DSL_DEBUGBUF_CONTROL]              = (int16 *)(void *)&gt_DebugBuffControl;

         //initialize Debug Buffer Control structures
   gt_DebugBuffControl.s_debugBuffer_STCaptureXSymbol=LOG_PER_X_SYMBOL_DEBUG_BUFFER;
   gt_DebugBuffControl.us_debugBuffer_StopStartCaptureData=STOP_SHOW_TIME_CAPTURE;
   // XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer(END)
#endif // #ifdef DEBUG_TRACES

   //XDSLRTFW-361 Enh_All_All_All_GetHandshakeControlInfo (Start_End)
   DSLMap[DSL_HNSK_CONTROL_INFO] = (int16 *)(void *)&gt_hsc; //CMV DSL 31
#endif
   DSLMap[DSL_PREV_FAILSTATE]        = (int16 *)(void *)&gt_FailStateInfo_Prev;     // DSL_37: XDSLRTFW-3665
   DSLMap[DSL_PREV_EXCEPTION_CODES]  = (int16 *)(void *)&gula_FailStateHistory[0];  // DSL_38: XDSLRTFW-3665

}

/*******************************************************************************
*
*  Prototype: void CMVInit_UtopiaFix(void)
*
*  This function initializes cmv to enable utopia work around.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*******************************************************************************/

void CMVInit_UtopiaFix(void)
{

#ifdef TARGET_HW

#endif

}


