/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   cmv_remap.c
*
*   Functions for mapping between Soc and Herc CMVs.
*
*-------------------------------------------------------------------------
*/

// ******************************************************************
// cmv_remap.c
//
// History
//
// 19/07/2010  Bhadra:Added code for mapping of NE Tx counters(Idle Cell /Non Idle cells) to CMV CNTR 53
//               Grep for " XDSLRTFW-151 :Feature_AB_ALL_ALL_NE_ATM_TC_CNTRS_Mapping "
//
// 09/08/2011 Vinjam: Added code to populate "System error code" & Sub system error code" for
//                    show time near end failures in "gt_HercADSL_STATMap_FailureState.ul_ExceptionCode".
//                    Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//
// 06/09/2011 Vinjam: Added a new Sub system error code for "SUB_ERROR_CODE_EXCESS_DOWNSTREAM_CRC_ERRORS"
//                    It indicates link drop to excess Downstream CRC errors
//                    Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
// 26/08/2011 Sriram Shastry : Add support for PTM transfer mode (in addition to ATM mode which is normally used in ADSL).
//                This includes support in G.HS to indicate PTM support and evaluate CO response regarding possible PTM support
//                  Interface towards PPE engine -> Exchange of data-> reading of TC status counters from PPE engine and forwarding them to the
//                  related CMVs such that API can read them
//                  This feature is contolled via
//                cnfg 0 0 2   // 1 : PTM 2: ATM 3: PTM+ATM
//                cnfg 2 0 2   // 1 : PTM 2: ATM 3: PTM+ATM
//                Default : ATM mode
//                Grep for XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping
// 16/09/2011 Sriram Shastry : Extended the cnfg remap support from Annex-A to Annex-I & Annex-M. This is done so as to support Annex-M feature.
//
//            Grep for : Enhancement_AB_ALL_ALL_NE_CNFGcmv_remap_Allmodes
//
// 04/01/2012 Balabath:Support US SRA and controlling US SRA" between Hercules CMV "OPTN 15 0 x0002"
//                   to Socrates "OPTN 15 0 0x0100
//       Grep for XDSLRTFW-380: Feature_US_BisPlus_All_USSRA_CMVRemap
//
//12/01/2012: Balabath: Added CMV to trigger LPR in idication.DSL 5 0 1 will trigger this.By default
//                      this bit is set to zero.
//                Grep for XDSLRTFW-201 Feature_US_ALL_ALL_LPR
//
// 31/01/2012 Vinjam: CMV Remap for "HERC OPTN 15 0" to "SOC OPTN 2 0" for
//            enabling/disabling US BitSwap & DS BitSwap
//            Grep for XDSLRTFW-395 Feature_All_All_All_BitSwap_CMVRemap
//
// 03/02/2012 Sriram Shastry : Modifed the SYS_ERROR_CONFIG_NOT_FEASIBLE to SYS_ERROR_COMM_ERROR ( as per the discussion with Stefan)
//            Grep for Enhc_AB_ALL_ALL_ALL_VDSL_HSK_InADSLShortCLR_Msg
//
//09/02/2012 Balabath: XTSE-status (STAT 1) must be updated during init/training/showtime according to following table:
//           1. while sending out G.Hs activation tones: (XTSE-status = all G.Hs modes as configured by API, e.g. DMT-Anx-A + BIS-AnxA + PLUS-AnxA + VDSL, NO T1.413)
//          2. while sending out T1.413 activation signal: (XTSE-status = T1.413 mode)
//          3. in G.Hs: (XTSE-status = all G.Hs modes as configured by API, e.g. DMT-Anx-A + BIS-AnxA + PLUS-AnxA + VDSL)
//          4. in ADSL training: (XTSE-status = ADSL mode of current training, i.e. outcome of modeselect in G.HS or T1.413)
//          5. in T1.413 training: (XTSE-status = T1.413 mode)
//          6. in ADSL showtime: (XTSE-status = ADSL mode, same as 4.)
//          7. in T1.413 showtime: (XTSE-status = T1.413 mode)
//            For code changes grep for "XDSLRTFW-415 Enh_all_all_STAT1_update"
//
// 16/2/2012 Vinjam: Allow adjusting the target DS margin via CMV/message in ADSL mode.
//           Option to add additional DS margin (additional to what is requested as target margin by the CO).
//           This margin would be added on all tones (i.e. flat). The reported margin must be the real margin
//          (i.e. including the additional margin configured). The goal of the CMV is not margin cheating.
//          This CMV will also be helpful for debugging purposes and it will also allow to decrease the margin
//          (i.e. increase DS performance by sacrificing margin/stability) HERC CMV "OPTN 28" is used for setting deltaTARSNRMds.
//          grep for "XDSLRTFW-310 Improve_BisPlus_DS_All_AdjustTargetMarginThroughCMV" to see the code changes.
//
// 04/07/2012 Vinjam: Code pointers to enable/disable PM L2 using HERC CMV MONI 4 0 0x100
//                   PM L2 enable "HERC MONI 4 0 Bit-8" is remapped to "SOC OPTN    15 0 Bit-9 (inverted logic)"
//                   Grep for XDSLRTFW-403: Enhancement_ALL_BisPLus_ALL_L2_HercCMVreMap
//
// 04/07/2012 Anantha: Added code to update LCD and NCD show time near-end failures to cmv STAT5 .
//                    Grep for XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers
//
// 23/8/2012 Vinjam: Added a CMV control (DSL 19 0 0x1) to Disable the CRC/FEC counter write-back by DSLAPI
//                   Grep for XDSLRTFW-508 Fix_DS_All_All_SuppressCounterWriteFromDSLAPI
//
// 07/9/2012 Vinjam: Renamed "CMV_TO_SUPPRESS_HercCNTRtoSOCPLAM_SWWRITEOPTION" to "CMV_TO_SUPPRESS_CRC_FEC_WriteBackOption".
//                   Grep for XDSLRTFW-508 Fix_DS_All_All_SuppressCounterWriteFromDSLAPI
//
// 07/9/2012 Vinjam: Code modified to get CRC errors per link (useful for debugging purpose)
//                   Grep for Fix_DS_All_All_ModifiedToGetCRCPerLink
//
// 07/12/2012  Bhadra:XDSLRTFW-547: Jira XDSLRTFW-543 adress the DS intlv delat through the API command
//             ./dsl_cpe_pipe.sh g997csg 0 1, The same needs to be addressed for ./dsl_cpe_pipe.sh g997csg 0 0
//             ie., in the US direction to complete for  XDSLRTFW-547.ie., "ActualInterleaveDelay"
//             reporting in US direction for ADSL2 and ADSL2+. The reasons are same as exapleined in XDSLRTFW-543
//             ie., variables(s_Kp)of struct "DerivedFramePropLatencyPath_t" are under HERC_API
//             and these are not populated. There was an agreement with API team that future API version
//             including the one for PACE) will read Herc-cmv RATE 0 9 (verified in API 4.11.5 check Jira,XDSLRTFW-437)
//             And for backward compatibility of API versions, Add code to populate these variable(s_Kp,s_NFECp &s_Sp)
//             this code is taken from Vinax ref.
//                         For code changes Grep for "XDSLRTFW-547:BugFix_BisPlus_US_ALL_IntlvDelay"
//
// 26/12/2012 Stefan/Vinjam: Integrated R3.5 fix to R5.2 Mainline.
//            To avoid long training times in ADSL mode and too early false mode switches to VDSL binary,
//             FW sends the intentional retrain information (using a global variable guc_Forced_Retrain) to SW/DSL API.
//            Code changes connected to Jira XDSLRTFW-248" and Jira XDSLRTFW-255.
//             Grep for XDSLRTFW-654 XDSLRTFW-248 Bug_DS_All_All_IntentionalReTrainToReduceTrainTime
//
// 28/12/2012 Vinjam: SUB_ERROR_CODE_INTENTIONAL_RETRAIN is causing some problem (no retrain even with auto boot daemon) with "UGW5.2+DSL-API 4.11.5" in Annex-B modes.
//           This need to be cross checked with Thomas Drews. Disabled the code which conveys the "SUB_ERROR_CODE_INTENTIONAL_RETRAIN" in "STAT 5 0".
//             Grep for XDSLRTFW-654 XDSLRTFW-248 Bug_DS_All_All_IntentionalReTrainToReduceTrainTime
// 14/12/2012 Mahesh: Added L2 entry - Amd 4 changes.
//          Grep for XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4
// 28/12/2012 Mahesh: Updated with latest msg cat ver 1.9 for L2 Amd 4 changes.
//          Grep for XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4
//
// 07/01/2013 Ram: Added fix for JIRAs 575, 459.
//                 a) When SW/DSL-API either GETs/SETs 'a' CMV (perf counter),
//                    contents of the entire CMV set (CNTR 2,4,8,10,12,14) is being read/written.
//                    This mass read/write is being prevented now by passing the 'CMV number under interest'
//                    as an argument to mapping function.
//                    Grep for XDSLRTFW-575: Counter Write back in ADSL mode
//
//                 b) Implementing CMV 'CNTR 51'.
//                    Grep for XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping
//
// 07/12/2012  Bhadra:XDSLRTFW-437: Change the interleave delay reporting from ms to (1/100) ms
//             This is required for precision in delay reporting.
//             For code changes Grep for "XDSLRTFW-437:Enh_BisPlus_ALL_ALL_IntlvDelayIn1By100ms "
//
// 10/01/2013 Vinjam: Convey upstream & downstream data rate in 1kbps granularity over
//            "CMV RATE 0 0" (for upstream) & "CMV RATE 1 0" (for downstream).
//            Grep for XDSLRTFW-717 Task_AB_All_All_All_RateIn1kbpsGranularity
//
// 20/2/2013 Vinjam: Enable/disable US & DS Bitswaps as per VRx Message Spec.
//            cleaned up CMV-Remap functions for enabling/disabling US/DS bitswap using HERC OPTN 15
//            Grep for XDSLRTFW-731 FIX_All_All_All_EnableBitSwapsAsPerVRxMsgSpec
//
//23/01/2013 Bhadra:1)There were some FW intentional retrains for CNXT DSLAMs which are not indicated to API.
//           This requires code changes of Exception Code in 32 bit. (Currently we do reporting of 32 bit
//           only for certain cases in CMV_Remap.c, This has to be modified for all ExceptionCodes).
//           2) Code has been Optimized to avoid certain retrains like FailureState:172 - E_CODE_RCMsg1_Bis_CNXT_USPerfMidLoopTSSI
//           3) Since we have problems in mis-detecting cross talk as C-tones
//           (and thus indicating HS entered to API even though CO is not connected to ADSL modes),
//           Move indicating the HS entered (STAT 0 0 -> 5 ) after C-GALF1 is detected.
//           This will give clear picture whether HS is entered or not?
//           4) If time out occurs at C-GLAF1 phase, most probably this is C-Tone mis-detection.
//           So goto silence phase again instead of Failstate and also API will not reset the Timer.
//               This is CMV controlled  INFO 103 bit#1 (0x0002) default this is enabled.
//           5) Corrected the bug introduced as part of fix XDSLRTFW-507."Temp_AnxCnt" is initialised to total octets in msg till  SI-SPAR(1)
//           instead of SI-SPAR(1) octets. In general we can check for MAX SPAR1 octets (5).
//           For  Code Changes grep for XDSLRTFW-626: Enh_all_all_TelfonicaLongTraining
//
// 18/02/2013 Vinjam: Report downstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 1 [14:15]" & "CMV_RATE 1 [16:17] respectively.
//            Also, Report upstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 0 [14:15]" & "CMV_RATE 0 [16:17] respectively.
//            Modified enable/disable of Erasuredecoder logic as per VRx Msg Spec through "CMV DSL 1 0"
//            Grep for XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec
//
// 26/2/2013 Vinjam: Computed upstream "ActInpNoErasure" and reported it through "CMV RATE 0 [14:15]"
//           Report "ActInpNoErasure" in 0.1 DMT Symbol Granularity
//            Grep for XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec
//
// 27/2/2013 Vinjam: Report "ActINPErasure = ActINPnoErasure" in upstream direction, if CPE doesn't get far-end ActINP through EOC Test Parameter message.
//            Grep for XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec
//
// 25/06/2013 Ram: Added fix to prevent divide-by-zero condition during INP computation.
//                 Grep for ADSLRTFW-1689: BugFix_DS_All_All_IncorrectINPReported
//
// 24/01/2014 Balabath :- Correction of bugs and implementation as per the ErasureDecoding implementation
//                      -Change of Default settings of DSL 1 0 CMV settings
//                      - IOP issues resolved with EBLT-C
//                      for Code Changes grep for " XDSLRTFW-1502 "
//
// 05/03/2014 Prashant: FW was not considering MSW for NE and FE Line performance counters (32 bit counters) as FW had 16 bit soc
//            counters for these. To maintain the 32 bit counters the following chages are done w.r.t. these counters. (CNTR 2 & CNTR 4)
//            Increment HERC 32 bit counters at the places where SOC 16bit counters are incremented inside the firmware.
//            Comment out copying SOC to HERC counters in CMV remap functions.
//            Grep for XDSLRTFW-1562
//
// 10/09/2014 Balabath: Modifications in handling of CRC's and FEC counters for API reporting and reporting to DSLAM through OHM
//            Report always running counters to API and control thorugh CMV DSL 22 0 bit#0 for DSLAM Reporting
//            Bit#0 of DSL 22 0 is 1 and will report only per session counters (default)
//            if Bit#0 of DSL 22 0 is reset running counter will be reported.
//            Grep for XDSLRTFW-2003
//
// 03/12/2018 Abu Rahman
//            XDSLRTFW-4039: Disable Autonomous State Event Messaging in ADSL mode
//            Autonomous State Event messaging was introduced with XDSLRTFW-3548(ADSL) & XDSLRTFW-3513 (VDSL) jiras. This functionality
//            required special message handling capability in SW which was introduced in UGW 8.1.1. It looks like concept were not adequate
//            to meet all the corner cases. This new feature often leads instabilities ( ie No TC Sync reporting in VDSL
//            mode, link drop in ADSL mode etc.) Due to these consequences the feature is decided to be disabled in FW
//            by default. If API tries to enable this feature then FW reports an exception (i.e E_CODE_MODEM_FSM_EVENT_NOT_ALLOWED_CONFIGURATION)
//
//            To enable or disable Autonomous state events handling in FW "test 46 0"  bit mask 0x0800 cmv is used
//            Enable Autonomous Message Handling : test 46 0  bit mask 0x0800 value 1 (dmms 2E44 0 1 0800 0800)
//            Disable Autonomous Message Handling : test 46 0  bit mask 0x0800 value 0 (dmms 2E44 0 1 0800 0000) default configuration.
//            Grep pattern:  XDSLRTFW-4039
// ********************************************************************************************************************************

#ifdef HERC_API

#include "typedef.h"
#include "common.h"
#include "gdata.h"
#include "cmv.h"
#include "gdata_bis.h"
#include "gdata_bis_diag.h"
#include "cmv_remap.h"
#include "hndshk_data.h"
#include "tx_plam.h"
#include "rx_plam.h"
#include "hmp.h"
#include "hmp_data.h"
#include "decimalgain.h"
#include "states.h"
#include "string.h"

extern int16 SubmitAutoMsg(AutoMsgPayLoadEntry_t *pt_PayLoadEntry, uint16 us_MailboxCode, uint16 us_MsgWord0,
               uint16 us_MsgWord1, uint16 us_MsgWord2, uint16 us_MsgWord3, uint16 us_MsgWord4);

/*^^^
 *-------------------------------------------------------------------
 *
 *  Prototype: void HercMonitorUpdate(void);
 *
 *  Description:
 *      .
 *
 *-------------------------------------------------------------------
 *^^^
 */
void HercMonitorUpdate(void) {

   int s_FailureMap=0,automsgsubmit=0;
   uint16 s_MailboxCode, s_Word0, s_Word1, s_Word2, s_Word3, s_Word4;

   if ((gt_HercADSL_STATMap_MacroState.s_Offset0 == STAT_ShowTimeTCSyncState) && (gs_showtime_tc_sync_first_time == 1) && (gt_HercADSL_MONIMap_EventConfigure.s_Offset0 & MONI_FIRST_SHOWTIME_TC_SYNC))
   {
      gusa_HercADSL_MONIMap_Curr[0] |= MONI_FIRST_SHOWTIME_TC_SYNC;
   }
   if ((gt_HercADSL_MONIMap_EventConfigure.s_Offset0 & MONI_DIAG_COMPLETE) && (gt_HercADSL_STATMap_MacroState.s_Offset0 == STAT_IdleState))
   {
      // Diag data is available at the end of medley, so this msg could be triggered then.
      // For now tell ME it is available when diag is complete (idle)
      gusa_HercADSL_MONIMap_Curr[0] |= MONI_NE_DIAG_DATA_AVAILABLE;
   }

   // XDSLRTFW-3648 (Start)
   if ((gt_HercADSL_MONIMap_EventConfigure.s_Offset1 & MONI_DSL_POWER_DOWN) && (gusa_HercADSL_MONIMap_Curr[3] != gusa_HercADSL_MONIMap_Prev[3]))
   {
      gusa_HercADSL_MONIMap_Curr[3] = MONI_DSL_POWER_DOWN;
   }
   // XDSLRTFW-3648 (End)

   // Create Mask for PLAM Offsets which match MONI Offsets
   s_FailureMap = MONI_LOS_FAILURE | MONI_LOF_FAILURE | MONI_LPR_FAILURE;
   s_FailureMap |= MONI_NCD_FAILURE_BC0 | MONI_NCD_FAILURE_BC1 | MONI_LCD_FAILURE_BC0 | MONI_LCD_FAILURE_BC1;

   gusa_HercADSL_MONIMap_Curr[1] = gs_NearEndFailureReported & (gsa_HercADSL_MONIMap_AlarmCnfg[0] & s_FailureMap);

   if ((*PLAMMap[PLAM_SNRMargin] < 0) && (gsa_HercADSL_MONIMap_AlarmCnfg[0] & MONI_LOM_FAILURE))
   {
      gusa_HercADSL_MONIMap_Curr[1] |= MONI_LOM_FAILURE;
   }

   gusa_HercADSL_MONIMap_Curr[2] = gs_FarEndFailure & (gsa_HercADSL_MONIMap_AlarmCnfg[1] & s_FailureMap);

   s_MailboxCode = AUTONOMOUS_MSG_NOTIFICATION;
   s_Word0 = AUTO_MSG_CR_HEADER_0;
   s_Word3 = AUTO_MSG_CR_HEADER_3;

   switch(gs_AutoMsgHandlerState)
   {
      case CHECK_MODEM_MACRO_STATE:
         // XDSLRTFW-3714 (Start_End)
         // Please check XDSLRTFW-4039: Disable Autonomous State Event Messaging in ADSL mode
         if (((gusa_HercADSL_MONIMap_Prev[0] != gusa_HercADSL_MONIMap_Curr[0]) && (gusa_HercADSL_MONIMap_Curr[0] != 0) && (gusa_HercADSL_MONIMap_Curr[0] & gt_HercADSL_MONIMap_EventConfigure.s_Offset0)) ||
            ((gusa_HercADSL_MONIMap_Prev[3] != gusa_HercADSL_MONIMap_Curr[3]) && (gt_HercADSL_MONIMap_EventConfigure.s_Offset1 & MONI_DSL_POWER_DOWN)))
         {
            s_Word1 = AUTO_MSG_STAT0_HEADER_1;
            s_Word2 = AUTO_MSG_STAT0_HEADER_2;
            s_Word4 = AUTO_MSG_STAT0_HEADER_4;

            gt_EventConfigurePayLoad.uc_PayLoadLength = STAT_0_SIZE;
            gt_EventConfigurePayLoad.uc_PayLoadSent = 0;
            gt_EventConfigurePayLoad.pus_PayLoad= &gt_HercADSL_STATMap_MacroState.s_Offset0;

            SubmitAutoMsg(&gt_EventConfigurePayLoad, s_MailboxCode, s_Word0, s_Word1, s_Word2, s_Word3, s_Word4);
            gusa_HercADSL_MONIMap_Prev[0] = gusa_HercADSL_MONIMap_Curr[0];
            gusa_HercADSL_MONIMap_Prev[3] = gusa_HercADSL_MONIMap_Curr[3];
            gs_AutoMsgHandlerState = SUBMIT_MODEM_STAT_FAILURE_INFO;
         }
         else
         {
            gs_AutoMsgHandlerState = CHECK_AUTOMESSAGE_ON_LINE_FAILURES_NE;
         }
         break;

      case SUBMIT_MODEM_STAT_FAILURE_INFO:
         if (gusa_HercADSL_MONIMap_Prev[0] & MONI_FAIL)
         {
            s_Word1 = AUTO_MSG_STAT5_HEADER_1;
            s_Word2 = AUTO_MSG_STAT5_HEADER_2;
            s_Word4 = AUTO_MSG_STAT5_HEADER_4;

            gt_ModemStatFailPayLoad.uc_PayLoadLength = 1;
            gt_ModemStatFailPayLoad.uc_PayLoadSent = 0;
            gt_ModemStatFailPayLoad.pus_PayLoad= (uint16 *)(void *)&gt_HercADSL_STATMap_FailureState;

            SubmitAutoMsg(&gt_ModemStatFailPayLoad, s_MailboxCode, s_Word0, s_Word1, s_Word2, s_Word3, s_Word4);
            gusa_HercADSL_MONIMap_Prev[0] = gusa_HercADSL_MONIMap_Curr[0];
         }
         gs_AutoMsgHandlerState = CHECK_AUTOMESSAGE_ON_LINE_FAILURES_NE;
         break;

      case CHECK_AUTOMESSAGE_ON_LINE_FAILURES_NE:
         if ((gusa_HercADSL_MONIMap_Prev[1] != gusa_HercADSL_MONIMap_Curr[1]) && (gusa_HercADSL_MONIMap_Curr[1] != 0) && (isShowtime()))
         {
            s_Word1 = AUTO_MSG_PLAM0_HEADER_1;
            s_Word2 = AUTO_MSG_PLAM0_HEADER_2;
            s_Word4 = AUTO_MSG_PLAM0_HEADER_4;

            gt_NearEndFailure.uc_PayLoadLength = 1;
            gt_NearEndFailure.uc_PayLoadSent = 0;
            gt_NearEndFailure.pus_PayLoad= (uint16 *)(void *)&gs_NearEndFailureReported;

            SubmitAutoMsg(&gt_NearEndFailure, s_MailboxCode, s_Word0, s_Word1, s_Word2, s_Word3, s_Word4);
            gusa_HercADSL_MONIMap_Prev[1] = gusa_HercADSL_MONIMap_Curr[1];
         }
         gs_AutoMsgHandlerState = CHECK_AUTOMESSAGE_ON_LINE_FAILURES_FE;
         break;

      case CHECK_AUTOMESSAGE_ON_LINE_FAILURES_FE:
         if ((gusa_HercADSL_MONIMap_Prev[2] != gusa_HercADSL_MONIMap_Curr[2]) && (gusa_HercADSL_MONIMap_Curr[2] != 0) && (isShowtime()))
         {
            s_Word1 = AUTO_MSG_PLAM1_HEADER_1;
            s_Word2 = AUTO_MSG_PLAM1_HEADER_2;
            s_Word4 = AUTO_MSG_PLAM1_HEADER_4;

            gt_FarEndFailure.uc_PayLoadLength = 1;
            gt_FarEndFailure.uc_PayLoadSent = 0;
            gt_FarEndFailure.pus_PayLoad= (uint16 *)(void *)&gs_FarEndFailure;

            SubmitAutoMsg(&gt_FarEndFailure, s_MailboxCode, s_Word0, s_Word1, s_Word2, s_Word3, s_Word4);
            gusa_HercADSL_MONIMap_Prev[2] = gusa_HercADSL_MONIMap_Curr[2];
         }
         gs_AutoMsgHandlerState = CHECK_AUTOMESSAGE_TC_LOADED;
         break;
      case CHECK_AUTOMESSAGE_TC_LOADED :
         if (gft_TC_autonomous_msg)
         {
            //XDSLRTFW-3105 (Start)
            if((TESTArray[TEST_Control3] & TEST_DisableAutoMsgTcMode))
            {
               gft_TC_autonomous_msg = FALSE;
            }
            else
            //XDSLRTFW-3105 (End)
            {
               s_Word1 = AUTO_MSG_DSL14_HEADER1;
               s_Word2 = AUTO_MSG_DSL14_HEADER2;
               s_Word4 = AUTO_MSG_DSL14_HEADER4;
               gt_Required_TC.uc_PayLoadLength = 1;
               gt_Required_TC.uc_PayLoadSent = 0;
               gt_Required_TC.pus_PayLoad = (uint16 *)(void *)&gus_Required_TC_Info;

               SubmitAutoMsg(&gt_Required_TC, s_MailboxCode, s_Word0, s_Word1, s_Word2, s_Word3, s_Word4);
               gft_TC_autonomous_msg = FALSE;
            }
         }
         gs_AutoMsgHandlerState = CHECK_MODEM_MACRO_STATE;
         break;
   }
}

/*^^^
 *-------------------------------------------------------------------
 *
 *  Prototype: void MapSocStatModetoHerc(void);
 *
 *  Description:
 *      Map StratiPHY Input to Hercules Input CMVs.
 *
 *-------------------------------------------------------------------
 *^^^
 */
void MapSocStatModetoHerc(void)
{
   int s_temp;

   s_temp = STATArray[STAT_Mode] &0xE30D;

   /*
    *-------------------------------------------------------------------------------------------
    *   CMV MAP                     StratiPHY   Adr Idx bits    ->     Hercules    Adr Idx bits
    *   G.992.5I                    STAT        17   0   0              STAT        1   0   6
    *   G.992.5J                    STAT        17   0   1              STAT        1   0   7
    *   G.992.5M                    STAT        17   0   2              STAT        1   0   1
    *   G.992.3I                    STAT        1   0   10              STAT        1   0   4
    *   G.992.3J                    STAT        1   0   11              STAT        1   0   5
    *   G.992.3L(Mask1)             STAT        1   0   12              STAT        1   0   11
    *   G.992.3L(Mask2)             STAT        1   0   12              STAT        1   0   12
    *-------------------------------------------------------------------------------------------
    */

   s_temp  |= ((STATArray[STAT_Mode] & STAT_ConfigMode_G992_3_I) | (STATArray[STAT_Mode] & STAT_ConfigMode_G992_3_J))>> 6;

   //XDSLRTFW-2137 (Start_End)
   s_temp  |= ((STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_AB) << 9);

   if (( (gl_SelectedMode & (MODE_G992_3))) && (gl_SelectedMode & (ANNEX_L)  ))
   {
      // if AnnexL enabled indicate AnnexL only
      s_temp = 0; //XDSLRTFW-960 (start_end)
      if(STATArray[STAT_Misc] & STAT_AnnexL_US_Mask2_PSD)
         s_temp  |= (STATArray[STAT_Mode] & STAT_ConfigMode_G992_3_L);
      else
         s_temp  |= (STATArray[STAT_Mode] & STAT_ConfigMode_G992_3_L)>>1;
   }

   s_temp  |= (((STATArray[STAT_Mode1] & STAT_ConfigMode_G992_5_I)  |(STATArray[STAT_Mode1] & STAT_ConfigMode_G992_5_J)) << 6)  |((STATArray[STAT_Mode1] & STAT_ConfigMode_G992_5_M) >> 1);
   //XDSLRTFW-415 Enh_all_all_STAT1_update(start_end)
   gt_HercADSL_STATMap_ModeSelect.s_Offset0 |= s_temp;
}

/*^^^
 *-------------------------------------------------------------------
 *
 *  Prototype: void MapSocOptnAlgtoHerc(void);
 *
 *  Description:
 *      Map StratiPHY Input to Hercules Input CMVs.
 *
 *-------------------------------------------------------------------
 *^^^
 */
void MapSocOptnAlgtoHerc(void) {

   /*  Map StratiPHY CMV settings to HERC CMVs
    *-------------------------------------------------------------------------------------------
    *   CMV MAP                     StratiPHY   Adr Idx bits    ->      Hercules    Adr Idx bits
    *   DEC Adapt Disable           OPTN        2   0   4               OPTN        2   0   2
    *   TX TCM Enable               Not Available                     OPTN        2   2   0
    *   RX TCM Enable               OPTN        2   0   13              OPTN        2   2   1
    *   TX Bitswap Enable           OPTN        2   0   15              OPTN        2   2   2
    *   Autonomous DS Bitswap       OPTN        2   0   5               OPTN        2   2   3
    *   Disable Showtime FDQ        OPTN        16  0   12              OPTN        2   2   4
    *   Showtime MFDQ               Not Available                       OPTN        2   2   5
    *   Showtime SNR                Not Available                       OPTN        2   2   6
    *   Use DS Fine Gains           TEST        28  0   1               OPTN        2   2   7
    *   Transmit Scale Enabled      Not Available                       OPTN        2   2   8
    *   Reserved                                                        OPTN                15:9
    *   STAT PowerMode              STAT        18  0   0               STAT        0   1   0
    *-------------------------------------------------------------------------------------------
    */

   gt_HercADSL_OPTNMap_AlgControl.s_Offset0 = OPTNArray[OPTN_AlgControl] & 0x5FCB;

   if (OPTNArray[OPTN_AlgControl] & OPTN_DECAdaptDisable)
   {
      gt_HercADSL_OPTNMap_AlgControl.s_Offset0 |= (OPTN_DECAdaptDisable>>2);
   }
   else
   {
      gt_HercADSL_OPTNMap_AlgControl.s_Offset0 &= ~(OPTN_DECAdaptDisable>>2);
   }

   if (OPTNArray[OPTN_AlgControl] & OPTN_TCM_Disable)
   {
      gt_HercADSL_OPTNMap_AlgControl.s_Offset2 |= (OPTN_TCM_Disable>>12);
   }
   else
   {
      gt_HercADSL_OPTNMap_AlgControl.s_Offset2 &= ~(OPTN_TCM_Disable>>12);
   }

   if (OPTNArray[OPTN_AlgControl2] & OPTN_FdqAdaptDisable)
   {
      gt_HercADSL_OPTNMap_AlgControl.s_Offset2 |= (OPTN_FdqAdaptDisable>>8);
   }
   else
   {
      gt_HercADSL_OPTNMap_AlgControl.s_Offset2 &= ~(OPTN_FdqAdaptDisable>>8);
   }

   if (TESTArray[TEST_Control3] & TEST_FineGainDisable)
   {
      gt_HercADSL_OPTNMap_AlgControl.s_Offset2 |= (TEST_FineGainDisable<<7);
   }
}

/*^^^
 *-------------------------------------------------------------------
 *
 *  Prototype: void MapHercOptnAlgtoSOC(void);
 *
 *  Description:
 *      Map Hercules OPTN Algcontrol to Socrates
 *
 *-------------------------------------------------------------------
 *^^^
 */
void MapHercOptnAlgtoSOC(void)
{
   OPTNArray[OPTN_AlgControl] = gt_HercADSL_OPTNMap_AlgControl.s_Offset0 & 0x5FCB;

   if (gt_HercADSL_OPTNMap_AlgControl.s_Offset0 & (OPTN_DECAdaptDisable>>2))
   {
      OPTNArray[OPTN_AlgControl] |= OPTN_DECAdaptDisable;
   }
   else
   {
      OPTNArray[OPTN_AlgControl] &= ~OPTN_DECAdaptDisable;
   }

   if (gt_HercADSL_OPTNMap_AlgControl.s_Offset2 & (OPTN_TCM_Disable>>12))
   {
      OPTNArray[OPTN_AlgControl] |= OPTN_TCM_Disable;
   }
   /*   else
      {
      OPTNArray[OPTN_AlgControl] &= ~OPTN_TCM_Disable;
      }    */

   if (gt_HercADSL_OPTNMap_AlgControl.s_Offset2 & (OPTN_FdqAdaptDisable>>8))
   {
      OPTNArray[OPTN_AlgControl2] |= OPTN_FdqAdaptDisable;
   }
   else
   {
      OPTNArray[OPTN_AlgControl2] &= ~OPTN_FdqAdaptDisable;
   }

   if (gt_HercADSL_OPTNMap_AlgControl.s_Offset2 & (TEST_FineGainDisable<<7))
   {
      TESTArray[TEST_Control3] |= TEST_FineGainDisable;
   }
   /*   else
      {
      TESTArray[TEST_Control3] &= ~TEST_FineGainDisable;
      }*/

}
//XDSLRTFW-380: Feature_US_BisPlus_All_USSRA_CMVRemap (start)
/*^^^
 *-------------------------------------------------------------------
 *
 *  Prototype: void MapHercOptnOlrtoSOC(void);
 *
 *  Description:
 *      Map Hercules OPTN Olrcontrol to Socrates
 *
 *-------------------------------------------------------------------
 *^^^
 */
void MapHercOptnOlrtoSOC(void)
{

   if (gt_HercADSL_OPTNMap_OlrControl.s_Offset0 & (OPTN_15_HERC_AutoSRA_US))
   {
      // Enable US SRA
      OPTNArray[OPTN_OLRControl_DS] &= ~OPTN_DisableUSSRA;
   }
   else
   {
      // Disable US SRA
      OPTNArray[OPTN_OLRControl_DS] |= OPTN_DisableUSSRA;
   }
   if (gt_HercADSL_OPTNMap_OlrControl.s_Offset0 & (OPTN_EnableAutoSRA ))
   {
      // Enable DS SRA
      OPTNArray[OPTN_OLRControl_DS] |= OPTN_EnableAutoSRA;
   }
   else
   {
      // Disable DS SRA
      OPTNArray[OPTN_OLRControl_DS] &= ~OPTN_EnableAutoSRA;
   }

   //XDSLRTFW-395 Feature_All_All_All_BitSwap_CMVRemap (Start)
   if (gt_HercADSL_OPTNMap_OlrControl.s_Offset0 & (OPTN_15_HERC_BitSwap_US))
   {
      // Enable US BitSwap
      OPTNArray[OPTN_AlgControl] &= ~OPTN_USBitSwapDisable;
   }
   else
   {
      // Disable US BitSwap
      OPTNArray[OPTN_AlgControl] |= OPTN_USBitSwapDisable;
   }

   if (gt_HercADSL_OPTNMap_OlrControl.s_Offset0 & (OPTN_15_HERC_BitSwap_DS))
   {
      // Enable DS BitSwap
      OPTNArray[OPTN_AlgControl] &= ~OPTN_DSAutoBitSwapDisable;
   }
   else
   {
      // Disable DS BitSwap
      OPTNArray[OPTN_AlgControl] |= OPTN_DSAutoBitSwapDisable;
   }
   //XDSLRTFW-395 Feature_All_All_All_BitSwap_CMVRemap (End)

}
//XDSLRTFW-380: Feature_US_BisPlus_All_USSRA_CMVRemap (end)


//XDSLRTFW-310 Improve_BisPlus_DS_All_AdjustTargetMarginThroughCMV (start)
/*^^^
 *-------------------------------------------------------------------
 *
 *  Prototype: void MapHercOptnMarginDeltatoSOC(void);
 *
 *  Description:
 *      Map Hercules OPTN Margin Delta to Socrates
 *
 *-------------------------------------------------------------------
 *^^^
 */
void MapHercOptnMarginDeltatoSOC(void)
{

   OPTNArray[OPTN_DesiredMarginAdjust] = gt_HercADSL_OPTNMap_MarginControl.s_deltaTARSNRMds;

}
//XDSLRTFW-310 Improve_BisPlus_DS_All_AdjustTargetMarginThroughCMV (end)



/*^^^
 *-------------------------------------------------------------------
 *
 *  Prototype: void MapHercOptnModetoSOC(void);
 *
 *  Description:
 *      Map Hercules OPTN Algcontrol to Socrates
 *
 *-------------------------------------------------------------------
 *^^^
 */
void MapHercOptnModetoSOC(void)
{

   //XDSLRTFW-2137 (Start)
   /*
    *-------------------------------------------------------------------------------------------
    *   CMV MAP                     StratiPHY   Adr Idx bit     <-      Hercules    Adr Idx bit
    *   T.1413                      OPTN        0   0   0               OPTN        0   0   0
    *   G.992.2AB                   OPTN        0   0   1               OPTN        0   0   10
    *   G.992.1A                    OPTN        0   0   2               OPTN        0   0   2
    *   G.992.1B                    OPTN        0   0   3               OPTN        0   0   3
    *   G.992.1C                    OPTN        0   0   4               ---- NOT DEFINED  ----
    *   G.992.2C                    OPTN        0   0   5               ---- NOT DEFINED  ----
    *   G.992.3A                    OPTN        0   0   8               OPTN        0   0   8
    *   G.992.3B                    OPTN        0   0   9               OPTN        0   0   9
    *   G.992.3I                    OPTN        0   0   10              OPTN        0   0   4
    *   G.992.3J                    OPTN        0   0   11              OPTN        0   0   5
    *   G.992.3L(Mask-1&2)          OPTN        0   0   12              OPTN        0   0   11 (Mask-1)
    *                                                                   OPTN        0   0   12 (Mask-2)
    *   G.992.3M                    OPTN        0   0   13              OPTN        0   0   13
    *   G.992.5B                    OPTN        0   0   14              OPTN        0   0   14
    *   G.992.5A                    OPTN        0   0   15              OPTN        0   0   15
    *-------------------------------------------------------------------------------------------
    */

   OPTNArray[OPTN_ModeControl] = gt_HercADSL_OPTNMap_ModeControl.s_Offset0 & 0xF30D;
   OPTNArray[OPTN_ModeControl] |= ((gt_HercADSL_OPTNMap_ModeControl.s_Offset0 & 0x400) >> 9); // OPTN_ConfigMode_G992_2_AB;
   //XDSLRTFW-2137 (End)

   /*
    *-------------------------------------------------------------------------------------------
    *   CMV MAP                     StratiPHY   Adr Idx bits    <-      Hercules    Adr Idx bits
    *   G.992.5I                    OPTN        7   0   0               OPTN        0   0   6
    *   G.992.5J                    OPTN        7   0   1               OPTN        0   0   7
    *   G.992.5M                    OPTN        7   0   2               OPTN        0   0   1
    *   G.992.3I                    OPTN        0   0   10              OPTN        0   0   4
    *   G.992.3J                    OPTN        0   0   11              OPTN        0   0   5
    *   G.992.3L(Mask1)             OPTN        0   0   12              OPTN        0   0   11
    *   G.993.1                     OPTN        7   0   10              OPTN        0   1   0
    *   G.993.2                     OPTN        7   0   9               OPTN        0   1   2
    *-------------------------------------------------------------------------------------------
    */

   OPTNArray[OPTN_ModeControl1] |= ((gt_HercADSL_OPTNMap_ModeControl.s_Offset0 & 0x40) | (gt_HercADSL_OPTNMap_ModeControl.s_Offset0 & 0x80) )>>6;

   OPTNArray[OPTN_ModeControl1] |= (gt_HercADSL_OPTNMap_ModeControl.s_Offset0 & 0x2)<<1;

   OPTNArray[OPTN_ModeControl] |= ((gt_HercADSL_OPTNMap_ModeControl.s_Offset0 & 0x10) | (gt_HercADSL_OPTNMap_ModeControl.s_Offset0 & 0x20))<<6;
   OPTNArray[OPTN_ModeControl] |= (gt_HercADSL_OPTNMap_ModeControl.s_Offset0 & 0x800)<<1;

   OPTNArray[OPTN_ModeControl1] |= (gt_HercADSL_OPTNMap_ModeControl.s_Offset1 & 0x1)<<10;
   OPTNArray[OPTN_ModeControl1] |= (gt_HercADSL_OPTNMap_ModeControl.s_Offset1 & 0x4)<<7;

   OPTNArray[OPTN_ModeControl1] |= ((gt_HercADSL_OPTNMap_ModeControl.s_Offset1 & 0x100)<<3); // G.Fast
}



/*^^^
 *-------------------------------------------------------------------
 *
 *  Prototype: void MapSocOptnModeCnttoHerc(void);
 *
 *  Description:
 *      Map StratiPHY Input to Hercules Input CMVs.
 *
 *-------------------------------------------------------------------
 *^^^
 */
void MapSocOptnModeCnttoHerc(void)
{
   gt_HercADSL_OPTNMap_ModeControl.s_Offset0 = OPTNArray[OPTN_ModeControl]  & 0xF30D;

   /*
    *-------------------------------------------------------------------------------------------
    *   CMV MAP                     StratiPHY   Adr Idx bits    ->     Hercules    Adr Idx bits
    *   G.992.5I                    OPTN        7   0   0               OPTN        0   0   6
    *   G.992.5J                    OPTN        7   0   1               OPTN        0   0   7
    *   G.992.5M                    OPTN        7   0   2               OPTN        0   0   1
    *   G.992.3I                    OPTN        0   0   10              OPTN        0   0   4
    *   G.992.3J                    OPTN        0   0   11              OPTN        0   0   5
    *   G.992.3L(Mask1)             OPTN        0   0   12              OPTN        0   0   11
    *   G.993.1                     OPTN        7   0   10              OPTN        0   1   0
    *   G.993.2                     OPTN        7   0   9               OPTN        0   1   2
    *-------------------------------------------------------------------------------------------
    */


   gt_HercADSL_OPTNMap_ModeControl.s_Offset0 |= ((OPTNArray[OPTN_ModeControl1] & 0x0001) | (OPTNArray[OPTN_ModeControl1]  & 0x0002)) << 6;
   gt_HercADSL_OPTNMap_ModeControl.s_Offset0 |= (OPTNArray[OPTN_ModeControl1] & 0x0004) >> 1;

   gt_HercADSL_OPTNMap_ModeControl.s_Offset0 |= ((OPTNArray[OPTN_ModeControl] & 0x400) | (OPTNArray[OPTN_ModeControl] & 0x800)) >> 6;
   gt_HercADSL_OPTNMap_ModeControl.s_Offset0 |= (OPTNArray[OPTN_ModeControl] &0x1000) >> 1;

   gt_HercADSL_OPTNMap_ModeControl.s_Offset1 |= (OPTNArray[OPTN_ModeControl1] & 0x400) >> 10;
   gt_HercADSL_OPTNMap_ModeControl.s_Offset1 |= (OPTNArray[OPTN_ModeControl1] & 0x200 ) >> 7;

   gt_HercADSL_OPTNMap_ModeControl.s_Offset1 |= ((OPTNArray[OPTN_ModeControl1] & OPTN_ConfigMode_G9701) >> 3);//G.Fast
}


/*^^^
 *-------------------------------------------------------------------
 *
 *  Prototype: void MapSocStatFailtoHerc(void);
 *
 *  Description:
 *      Map StratiPHY Input to Hercules Input CMVs.
 *
 *-------------------------------------------------------------------
 *^^^
 */
void MapSocStatFailtoHerc(void)
{
//XDSLRTFW-626: Enh_all_all_TelfonicaLongTraining (Start)
uint32 ul_Errorcode;
uint16 us_FWFailurecode;
uint8  uc_FWFailurecode;

#if 0
    if (STATArray[STAT_FailureState] == (E_CODE_GHS_NoCommonMode & 0xffff))
   {
      gt_HercADSL_STATMap_FailureState.ul_ExceptionCode = (STATArray[STAT_FailureState]<<16) |
         // Enhc_AB_ALL_ALL_ALL_VDSL_HSK_InADSLShortCLR_Msg(Start_End)
         (SUB_ERROR_CODE_NO_COMMON_MODE << 8) | SYS_ERROR_COMM_ERROR;
   }
    else if (STATArray[STAT_FailureState] == (E_CODE_GHS_VDSL_SUPPORT_FAREND & 0xffff))
   {
      gt_HercADSL_STATMap_FailureState.ul_ExceptionCode = (STATArray[STAT_FailureState]<<16) |
         (SUB_ERROR_CODE_VDSL_SUPPORT_FAREND << 8) | SYS_ERROR_COMM_ERROR;
   }
    else if (STATArray[STAT_FailureState] == (E_CODE_INCORRECT_LIF_MODULE & 0xfff)) // False Hybrid
   {
      gt_HercADSL_STATMap_FailureState.ul_ExceptionCode = (STATArray[STAT_FailureState]<<16)|
         (SUB_ERROR_CODE_FALSE_HYBRID << 8) | SYS_ERROR_CONFIG_ERROR;
   }
   //XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start)
    else if (STATArray[STAT_FailureState] == (E_CODE_ShowtimeMargin_Failure & 0xffff)) // Showtime LOM
   {
      gt_HercADSL_STATMap_FailureState.ul_ExceptionCode = (STATArray[STAT_FailureState]<<16)|
         (SUB_ERROR_CODE_LOSS_OF_MARGIN << 8) | SYS_ERROR_SHOWTIME_NEAREND_FAILURE;
   }
    else if (STATArray[STAT_FailureState] == (E_CODE_ShowtimeLOS_Failure & 0xffff)) // Showtime LOS due to fall in Signal strength on pilot tone
   {
      gt_HercADSL_STATMap_FailureState.ul_ExceptionCode = (STATArray[STAT_FailureState]<<16)|
         (SUB_ERROR_CODE_LOSS_OF_SIGNAL << 8) | SYS_ERROR_SHOWTIME_NEAREND_FAILURE;
   }
   //XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers (start)
   //update stat 5 0 cmv with NCD failure exception
   else if (STATArray[STAT_FailureState] == (E_CODE_ShowtimeNCD_Failure & 0xffff))
   {
      gt_HercADSL_STATMap_FailureState.ul_ExceptionCode = (STATArray[STAT_FailureState]<<16)|
         (SUB_ERROR_CODE_NCD_BC0 << 8) | SYS_ERROR_SHOWTIME_NEAREND_FAILURE;
   }
   //update stat 5 0 cmv with LCD failure exception
   else if (STATArray[STAT_FailureState] == (E_CODE_ShowtimeLCD_Failure & 0xffff))
   {
      gt_HercADSL_STATMap_FailureState.ul_ExceptionCode = (STATArray[STAT_FailureState]<<16)|
         (SUB_ERROR_CODE_LCD_BC0 << 8) | SYS_ERROR_SHOWTIME_NEAREND_FAILURE;
   }
   //XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers (end)
   //XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start)
    else if (STATArray[STAT_FailureState] == (E_CODE_ShowtimeLOS_DueToCRC_Failure & 0xffff)) // Showtime LOS Due to excess Down Stream CRC errors
   {
      gt_HercADSL_STATMap_FailureState.ul_ExceptionCode = (STATArray[STAT_FailureState]<<16)|
         (SUB_ERROR_CODE_EXCESS_DOWNSTREAM_CRC_ERRORS << 8) | SYS_ERROR_SHOWTIME_NEAREND_FAILURE;
   }
   //XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (End)
    else if (STATArray[STAT_FailureState] == (E_CODE_ShowtimeLOF_Failure & 0xffff)) // Showtime LOF
   {
      gt_HercADSL_STATMap_FailureState.ul_ExceptionCode = (STATArray[STAT_FailureState]<<16)|
         (SUB_ERROR_CODE_LOSS_OF_FRAME << 8) | SYS_ERROR_SHOWTIME_NEAREND_FAILURE;
   }
    else if (STATArray[STAT_FailureState] == (E_CODE_ShowtimeOOS_Failure & 0xffff)) // Showtime OOS
   {
      gt_HercADSL_STATMap_FailureState.ul_ExceptionCode = (STATArray[STAT_FailureState]<<16)|
         (SUB_ERROR_CODE_OOS_BC0 << 8) | SYS_ERROR_SHOWTIME_NEAREND_FAILURE;
   }
    else if ((STATArray[STAT_FailureState] == (E_CODE_ESE_FAILURE & 0xffff)) ||
             (STATArray[STAT_FailureState] == (E_CODE_SES30_FAILURE & 0xffff)) ||
             (STATArray[STAT_FailureState] == (E_CODE_ES90_FAILURE &0xffff)))
   {  // Showtime Excessive severe errors
      gt_HercADSL_STATMap_FailureState.ul_ExceptionCode = (STATArray[STAT_FailureState]<<16)|
         (SUB_ERROR_CODE_EXCESSIVE_SEVERE_ERRORS << 8) | SYS_ERROR_SHOWTIME_NEAREND_FAILURE;
   }
   //XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (End)
   // XDSLRTFW-201 Feature_US_ALL_ALL_LPR(start)
   else if (STATArray[STAT_FailureState] == (E_CODE_ShowtimeLPR_Failure & 0xffff))
   {
      gt_HercADSL_STATMap_FailureState.ul_ExceptionCode = (STATArray[STAT_FailureState]<<16)|
         (SUB_ERROR_CODE_LOSS_OF_POWER << 8) | SYS_ERROR_SHOWTIME_NEAREND_FAILURE;
   }

#if 0 //commented for testing purpose
   //Some issue with "SUB_ERROR_CODE_INTENTIONAL_RETRAIN" with "UGW5.2+API 4.11.5"
   //Check with Thomas drews on this
   // XDSLRTFW-201 Feature_US_ALL_ALL_LPR(End)
   //XDSLRTFW-654 XDSLRTFW-248 Bug_DS_All_All_IntentionalReTrainToReduceTrainTime (Start)
   // In Steinfurt lab this excpetion was seen multiple time (50% of G.Hs sessions)
   // To avoid long training times and too early false mode switches to VDSL binary
   // the API is send now the information that this has been an intentional retrain
    else if (STATArray[STAT_FailureState] == (E_CODE_GHS_TONE_LOSS_OR_TIME_OUT & 0xffff)) // GHs timeout
    {
        gt_HercADSL_STATMap_FailureState.ul_ExceptionCode = (STATArray[STAT_FailureState]<<16)|
                (SUB_ERROR_CODE_INTENTIONAL_RETRAIN << 8) | SYS_ERROR_CONFIG_ERROR;
    }
    else if (guc_Forced_Retrain > 0) // Retrain is intentional indicate this to ME.
   {
      gt_HercADSL_STATMap_FailureState.ul_ExceptionCode = (STATArray[STAT_FailureState]<<16)|
         (SUB_ERROR_CODE_INTENTIONAL_RETRAIN << 8) | SYS_ERROR_COMM_ERROR;
    }
   //XDSLRTFW-654 XDSLRTFW-248 Bug_DS_All_All_IntentionalReTrainToReduceTrainTime (End)
#endif

    else
#endif
    {
        //gt_HercADSL_STATMap_FailureState.ul_ExceptionCode = (STATArray[STAT_FailureState]<<16);
      ul_Errorcode = (gus_ExceptionCode >> 16) & (0xFFFF);
      us_FWFailurecode = (gus_ExceptionCode  & 0xFFFF);
        uc_FWFailurecode =  (us_FWFailurecode & 0xff);
      gt_HercADSL_STATMap_FailureState.ul_ExceptionCode = (us_FWFailurecode <<16) | (ul_Errorcode);
    }
    if (guc_Forced_Retrain != 0) // Retrain is intentional indicate this to ME.
    {
        gt_HercADSL_STATMap_FailureState.ul_ExceptionCode = (STATArray[STAT_FailureState]<<16)|
                (SUB_ERROR_CODE_INTENTIONAL_RETRAIN << 8) | SYS_ERROR_COMM_ERROR;
    }
#if 1 // Todo revisit if VDSL FW detects GHS at long loops
    // For MultiMode handling not to switch to VDSL FW
    else if((uc_FWFailurecode >= 50   && uc_FWFailurecode <= 80)
            &&(( gl_SelectedMode & MODE_G992_3) && (gs_hsk_tone_power_dB < 2000))
           )
    {
        gt_HercADSL_STATMap_FailureState.ul_ExceptionCode = (us_FWFailurecode<<16)|
                        (SUB_ERROR_CODE_INTENTIONAL_RETRAIN << 8) | SYS_ERROR_COMM_ERROR;

    }
#endif
//XDSLRTFW-626: Enh_all_all_TelfonicaLongTraining (End)
}

/*^^^
 *-------------------------------------------------------------------
 *
 *  Prototype: void MapSocStatMacrosttoHerc(void);
 *
 *  Description:
 *      Map StratiPHY Input to Hercules Input CMVs.
 *
 *-------------------------------------------------------------------
 *^^^
 */
void MapSocStatMacrosttoHerc(void)
{
   /*
    *-------------------------------------------------------------------------------------------
    *   CMV MAP                     StratiPHY   Adr Idx bits    ->      Hercules    Adr Idx bits
    *   Power Mode                  STAT        18   0   0              STAT        0   1   15:0
    *   Link Mode                   STAT        1    0   15:0           STAT        1   0   15:0
    *-------------------------------------------------------------------------------------------
    */
   gt_HercADSL_STATMap_MacroState.s_Offset1 = STATArray[STAT_PowerMode];
   gt_HercADSL_STATMap_MacroState.s_Offset0 = STATArray[STAT_MacroState];
}


/*^^^
 *-------------------------------------------------------------------
 *
 *  Prototype: void MapSocCNFGtoHercAINF(void);
 *
 *  Description:
 *      Map StratiPHY Input to Hercules Input CMVs.
 *
 *-------------------------------------------------------------------
 *^^^
 */
void MapSocCNFGtoHercAINF(uint16 us_AddrField)
{
   int j=-1;
   /*
    *-------------------------------------------------------------------------------------------
    *   CMV MAP          StratiPHY  Adr Idx             ->      Hercules    Adr Idx
    *   US PCB           INFO       102 6                       AINF        0   1
    *   DS PCB           INFO       102 7                       AINF        0   0
    *
    *   DS Rp LP0,1      CNFG       23  0,1                     AINF        1,3 0
    *   DS Sp LP0,1      N/A                                    AINF        1,3 1
    *   DS Dp LP0,1      CNFG       27  0,1                     AINF        1,3 2
    *   DS Kp LP0,1      Derived from Bpn                       AINF        1,3 3
    *   DS Mp LP0,1      CNFG       24  0,1                     AINF        1,3 4
    *   DS Lp LP0,1      CNFG       25  0,1                     AINF        1,3 5
    *   DS # TCM Bits    N/A                                    AINF        1,3 6
    *   DS ADSL1 FM      CNFG       29  0                       AINF        1,3 7
    *
    *   US Rp LP0,1      CNFG       12  0,1                     AINF        2,4 0
    *   US Sp LP0,1      N/A                                    AINF        2,4 1
    *   US Dp LP0,1      CNFG       16  0,1                     AINF        2,4 2
    *   US Kp LP0,1      Derived from Bpn                       AINF        2,4 3
    *   US Mp LP0,1      CNFG       13  0,1                     AINF        2,4 4
    *   US Lp LP0,1      CNFG       14  0,1                     AINF        2,4 5
    *   US # TCM Bits    N/A                                    AINF        2,4 6
    *   uS ADSL1 FM      CNFG       18  0                       AINF        2,4 7
    *
    *-------------------------------------------------------------------------------------------
    */
   switch (us_AddrField)
   {
      case 0:
         gt_HercADSL_PCB.s_PCB_DS = gt_TxPMDControl.us_pwr_cutback_DS*10;
         gt_HercADSL_PCB.s_PCB_US = gt_TxPMDControl.us_pwr_cutback_US*10;
         break;

      case 1:
         //DS LP0
         j=0;
         // Fall through
      case 3:
         //DS_LP1
         if (j==-1)   j=1;

         gt_HercADSL_Framing.s_Num_TCM_Bits = gs_Rx_TCM_Ovhd;


         gt_HercADSL_Framing.s_SEQp = gsa_rx_SEQp[j];

         gt_HercADSL_Framing.s_Kp = gt_DerivedFrameProperties_DS.PropPerLp[j].s_Kp;

         MapConfigtoAINF(&gt_HercADSL_Framing, &gt_rx_config, j);



         if (gta_DS_options[j].uc_S == S_HALF)
            gt_HercADSL_Framing.s_Sp = (int16)0x8000;   /*  S = 1/2 */
         else
            gt_HercADSL_Framing.s_Sp = gta_DS_options[j].uc_S;

         break;


      case 2:
         //US LP0
         j=0;
      case 4:
         // US_LP1
         if (j==-1)    j=1;

         // US LP0 & LP1

         gt_HercADSL_Framing.s_Num_TCM_Bits = gs_Tx_TCM_Ovhd;
         gt_HercADSL_Framing.s_Kp = gt_DerivedFrameProperties_US.PropPerLp[j].s_Kp;

         gt_HercADSL_Framing.s_SEQp = gsa_tx_SEQp[j];


         gt_HercADSL_Framing.s_Sp = gta_US_options[j].uc_S;

         MapConfigtoAINF(&gt_HercADSL_Framing,&gt_tx_config, j);


         break;
   }

   if (gl_SelectedMode & MODE_ADSL2)
   {
      gt_HercADSL_Framing.s_Sp = 0;
      gt_HercADSL_Framing.s_ADSL1_Framing_Mode = 0;
   }
   else
   {
      gt_HercADSL_Framing.s_Kp = 0;
   }
}


void MapConfigtoAINF(HercADSL_AINFCMV_Framing_t *pt_HercADSL_Framing, Config_t *pt_config, int16 j)
{
   pt_HercADSL_Framing->s_MSGc = pt_config->s_MSGc;

   pt_HercADSL_Framing->s_Rp = pt_config->s_Rp[j];

   pt_HercADSL_Framing->s_Dp = pt_config->s_Dp[j];

   pt_HercADSL_Framing->s_Mp = pt_config->s_Mp[j];

   pt_HercADSL_Framing->s_Lp = pt_config->s_Lp[j];

   pt_HercADSL_Framing->s_Tp = pt_config->s_Tp[j];
   pt_HercADSL_Framing->s_ADSL1_Framing_Mode = pt_config->s_FramingMode;


}



/*^^^
 *-------------------------------------------------------------------
 *
 *  Prototype: void MapHercCNFGtoSOC(void);
 *
 *  Description:
 *      Map Hercules Input to StratiPHY Input CMVs that are used
 *      prior to initialization ONLY.
 *
 *-------------------------------------------------------------------
 *^^^
 */
void MapHercCNFGtoSOC(void)
{

   int i,j,k;

#ifndef ISDN
   int s_linkmode = G992_3_ANNEX_A;   // same G992_5_ANNEX_A  0
#else
   int s_linkmode = G992_3_ANNEX_B;   // same  G992_5_ANNEX_B 0
#endif


   /*
    *-------------------------------------------------------------------------------------------
    *   Channel                                 X                       Link Mode
    *   ------                                -----                     ---------
    *   DS Bearer Channel 0                     0                       G.992.3A
    *   DS Bearer Channel 1                     1                       G.992.3A
    *   US Bearer Channel 0                     2                       G.992.3A
    *   US Bearer Channel 1                     3                       G.992.3A
    *
    *   CMV MAP                     StratiPHY   Adr Idx bits    ->      Hercules    Adr Idx bits
    *   Control                     CNFG        X   0   15:0            CNFG        X   0   15:0
    *
    *   PTM Min Data Rate           CNFG        X   13  15:0            CNFG        X   1   15:0
    *   PTM Max Data Rate           CNFG        X   14  15:0            CNFG        X   2   15:0
    *   PTM Min Res Data Rate       CNFG        X   15  15:0            CNFG        X   3   15:0
    *   PTM Max Latency             CNFG        X   16  15:0            CNFG        X   4   15:0
    *   PTM TPS-TC OPTION           Not Available                       CNFG            5   9:8
    *   PTM BER                     CNFG        X   17  15:0            CNFG        X   5   1:0
    *   PTM IMA and INP Control     CNFG        X   18  15:0            CNFG        X   6   15:0
    *
    *   ATM Min Data Rate           CNFG        X   7   15:0            CNFG        X   7   15:0
    *   ATM Max Data Rate           CNFG        X   8   15:0            CNFG        X   8   15:0
    *   ATM Min Res Data Rate       CNFG        X   9   15:0            CNFG        X   9   15:0
    *   ATM Max Latency             CNFG        X   10  15:0            CNFG        X   10  15:0
    *   ATM BER                     CNFG        X   11  15:0            CNFG        X   11  1:0
    *   ATM IMA and INP Control     CNFG        X   12  15:0            CNFG        X   12  15:0
    *
    *   STM Min Data Rate           CNFG        X   1   15:0            CNFG        X   13  15:0
    *   STM Max Data Rate           CNFG        X   2   15:0            CNFG        X   14  15:0
    *   STM Min Res Data Rate       CNFG        X   3   15:0            CNFG        X   15  15:0
    *   STM Max Latency             CNFG        X   4   15:0            CNFG        X   16  15:0
    *   STM BER                     CNFG        X   5   15:0            CNFG        X   17  1:0
    *   STM IMA and INP Control     CNFG        X   6   15:0            CNFG        X   18  15:0
    *-------------------------------------------------------------------------------------------
    */

   //XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (start)
   // Sriram :G992_3_ANNEX_A = 0,G992_3_ANNEX_I =1,G992_3_ANNEX_M =2
   // Enhancement_AB_ALL_ALL_NE_CNFGcmv_remap_Allmodes(Start_End)
   for (s_linkmode = 0;s_linkmode < 3;s_linkmode++)
   {
      for (j=0;j<1;j++)
      {
         //gpt_TxInfo->pta_G9923xInfo[s_linkmode]->ta_DSBearerChannel[j].s_Control &= 0xFFFC;
         gpt_TxInfo->pta_G9923xInfo[s_linkmode]->ta_DSBearerChannel[j].s_Control = 0xFC;
         gpt_TxInfo->pta_G9925xInfo[s_linkmode]->ta_DSBearerChannel[j].s_Control = 0xFC;

         if ((gt_HercADSL_TPS_TC_Params[j].s_TPS_TC_Control & 0x3)== 1)   // As per HERC_API.doc
         {
            gpt_TxInfo->pta_G9923xInfo[s_linkmode]->ta_DSBearerChannel[j].s_Control = TPSTC_TYPE_PTM;
            gpt_TxInfo->pta_G9925xInfo[s_linkmode]->ta_DSBearerChannel[j].s_Control = TPSTC_TYPE_PTM;
            gt_HercADSL_TPS_TC_Params[j].s_TPS_TC_Control |= (0x1 << 8);   // As per Herc doc :Preferred Type
            gt_INFX_CMV.us_PTM_Options_Indicated = 0xB820;

         }
         else if ((gt_HercADSL_TPS_TC_Params[j].s_TPS_TC_Control & 0x3) == 2) // As per HERC_API.doc
         {
            gpt_TxInfo->pta_G9923xInfo[s_linkmode]->ta_DSBearerChannel[j].s_Control = TPSTC_TYPE_ATM;
            gpt_TxInfo->pta_G9925xInfo[s_linkmode]->ta_DSBearerChannel[j].s_Control = TPSTC_TYPE_ATM;
            gt_HercADSL_TPS_TC_Params[j].s_TPS_TC_Control |= (0x2 << 8);   // As per Herc doc :Preferred Type
         }

         else if ((gt_HercADSL_TPS_TC_Params[j].s_TPS_TC_Control & 0x3) == 3)   // requirement as per Jira entry
         {
            gpt_TxInfo->pta_G9923xInfo[s_linkmode]->ta_DSBearerChannel[j].s_Control = TPSTC_TYPE_PTM | TPSTC_TYPE_ATM;
            gpt_TxInfo->pta_G9925xInfo[s_linkmode]->ta_DSBearerChannel[j].s_Control = TPSTC_TYPE_PTM | TPSTC_TYPE_ATM;
            gt_HercADSL_TPS_TC_Params[j].s_TPS_TC_Control |= (0x3 << 8);      // As per Herc doc :Preferred Type
            gt_INFX_CMV.us_PTM_Options_Indicated = 0xB820;

         }


         gpt_TxInfo->pta_G9923xInfo[s_linkmode]->ta_USBearerChannel[j].s_Control = 0xFC;
         gpt_TxInfo->pta_G9925xInfo[s_linkmode]->ta_USBearerChannel[j].s_Control = 0xFC;

         if ((gt_HercADSL_TPS_TC_Params[j+2].s_TPS_TC_Control  & 0x3) == 1)
         {
            gpt_TxInfo->pta_G9923xInfo[s_linkmode]->ta_USBearerChannel[j].s_Control = TPSTC_TYPE_PTM;
            gpt_TxInfo->pta_G9925xInfo[s_linkmode]->ta_USBearerChannel[j].s_Control = TPSTC_TYPE_PTM;

            gt_HercADSL_TPS_TC_Params[j+2].s_TPS_TC_Control |= ( 0x1 << 8);   // As per Herc doc :Preferred Type
            gt_INFX_CMV.us_PTM_Options_Indicated = 0xB820;
         }


         else if ((gt_HercADSL_TPS_TC_Params[j+2].s_TPS_TC_Control & 0x3) == 2)
         {
            gpt_TxInfo->pta_G9923xInfo[s_linkmode]->ta_USBearerChannel[j].s_Control = TPSTC_TYPE_ATM;
            gpt_TxInfo->pta_G9925xInfo[s_linkmode]->ta_USBearerChannel[j].s_Control = TPSTC_TYPE_ATM;
            gt_HercADSL_TPS_TC_Params[j+2].s_TPS_TC_Control |= (0x2 << 8);  // As per Herc doc :Preferred Type
         }
         else if ((gt_HercADSL_TPS_TC_Params[j+2].s_TPS_TC_Control  & 0x3) == 3)
         {
            gpt_TxInfo->pta_G9923xInfo[s_linkmode]->ta_USBearerChannel[j].s_Control = TPSTC_TYPE_PTM | TPSTC_TYPE_ATM;
            gpt_TxInfo->pta_G9925xInfo[s_linkmode]->ta_USBearerChannel[j].s_Control = TPSTC_TYPE_PTM | TPSTC_TYPE_ATM;

            gt_HercADSL_TPS_TC_Params[j+2].s_TPS_TC_Control |= ( 0x3 << 8);   // As per Herc doc :Preferred Type
            gt_INFX_CMV.us_PTM_Options_Indicated = 0xB820;
         }
         //XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (end)
      }
   }

   // Sriram :G992_3_ANNEX_A = 0,G992_3_ANNEX_I =1,G992_3_ANNEX_M =2 & same for Adsl2plus modes
   // Enhancement_AB_ALL_ALL_NE_CNFGcmv_remap_Allmodes(Start_End)
   for (s_linkmode = 0;s_linkmode < 3;s_linkmode++)
   {
      for (i=0;i<=1;i++)
      {
         for (j=0,k=2;j<=2;j++,k--)
         {
            //3A,3I,3M,3B,3J,
            gpt_TxInfo->pta_G9923xInfo[s_linkmode]->ta_DSBearerChannel[i].ta_TpsTcType[j].s_MinNetDataRate      = gt_HercADSL_TPS_TC_Params[i].ta_TPS_TC_Type[k].s_MinNetDataRate;
            gpt_TxInfo->pta_G9923xInfo[s_linkmode]->ta_DSBearerChannel[i].ta_TpsTcType[j].s_MaxNetDataRate      = gt_HercADSL_TPS_TC_Params[i].ta_TPS_TC_Type[k].s_MaxNetDataRate;
            gpt_TxInfo->pta_G9923xInfo[s_linkmode]->ta_DSBearerChannel[i].ta_TpsTcType[j].s_MinResNetDataRate   = gt_HercADSL_TPS_TC_Params[i].ta_TPS_TC_Type[k].s_MinResNetDataRate;
            gpt_TxInfo->pta_G9923xInfo[s_linkmode]->ta_DSBearerChannel[i].ta_TpsTcType[j].s_MaxLatency          = gt_HercADSL_TPS_TC_Params[i].ta_TPS_TC_Type[k].s_MaxLatency;
            gpt_TxInfo->pta_G9923xInfo[s_linkmode]->ta_DSBearerChannel[i].ta_TpsTcType[j].uc_MaxBER             = gt_HercADSL_TPS_TC_Params[i].ta_TPS_TC_Type[k].uc_MaxBER;
            gpt_TxInfo->pta_G9923xInfo[s_linkmode]->ta_DSBearerChannel[i].ta_TpsTcType[j].s_IMAxINP             = gt_HercADSL_TPS_TC_Params[i].ta_TPS_TC_Type[k].s_IMAxINP;
            // XDSLRTFW-1481 (Start_End) TPSTCoptions is part of paramater 7 as per message spec.
            gpt_TxInfo->pta_G9923xInfo[s_linkmode]->ta_DSBearerChannel[i].ta_TpsTcType[j].uc_TPSTCoptions        = gt_HercADSL_TPS_TC_Params[i].ta_TPS_TC_Type[k].uc_TPSTCoptions;

            gpt_TxInfo->pta_G9923xInfo[s_linkmode]->ta_USBearerChannel[i].ta_TpsTcType[j].s_MinNetDataRate      = gt_HercADSL_TPS_TC_Params[i+2].ta_TPS_TC_Type[k].s_MinNetDataRate;
            gpt_TxInfo->pta_G9923xInfo[s_linkmode]->ta_USBearerChannel[i].ta_TpsTcType[j].s_MaxNetDataRate      = gt_HercADSL_TPS_TC_Params[i+2].ta_TPS_TC_Type[k].s_MaxNetDataRate;
            gpt_TxInfo->pta_G9923xInfo[s_linkmode]->ta_USBearerChannel[i].ta_TpsTcType[j].s_MinResNetDataRate   = gt_HercADSL_TPS_TC_Params[i+2].ta_TPS_TC_Type[k].s_MinResNetDataRate;
            gpt_TxInfo->pta_G9923xInfo[s_linkmode]->ta_USBearerChannel[i].ta_TpsTcType[j].s_MaxLatency          = gt_HercADSL_TPS_TC_Params[i+2].ta_TPS_TC_Type[k].s_MaxLatency;
            gpt_TxInfo->pta_G9923xInfo[s_linkmode]->ta_USBearerChannel[i].ta_TpsTcType[j].uc_MaxBER             = gt_HercADSL_TPS_TC_Params[i+2].ta_TPS_TC_Type[k].uc_MaxBER;
            gpt_TxInfo->pta_G9923xInfo[s_linkmode]->ta_USBearerChannel[i].ta_TpsTcType[j].s_IMAxINP             = gt_HercADSL_TPS_TC_Params[i+2].ta_TPS_TC_Type[k].s_IMAxINP;
         // XDSLRTFW-1481 (Start_End) TPSTCoptions is part of paramater 7 as per message spec
            gpt_TxInfo->pta_G9923xInfo[s_linkmode]->ta_USBearerChannel[i].ta_TpsTcType[j].uc_TPSTCoptions        = gt_HercADSL_TPS_TC_Params[i+2].ta_TPS_TC_Type[k].uc_TPSTCoptions;

            //5A,5I,5M,5B,5J,
            gpt_TxInfo->pta_G9925xInfo[s_linkmode]->ta_DSBearerChannel[i].ta_TpsTcType[j].s_MinNetDataRate      = gt_HercADSL_TPS_TC_Params[i].ta_TPS_TC_Type[k].s_MinNetDataRate;
            gpt_TxInfo->pta_G9925xInfo[s_linkmode]->ta_DSBearerChannel[i].ta_TpsTcType[j].s_MaxNetDataRate      = gt_HercADSL_TPS_TC_Params[i].ta_TPS_TC_Type[k].s_MaxNetDataRate;
            gpt_TxInfo->pta_G9925xInfo[s_linkmode]->ta_DSBearerChannel[i].ta_TpsTcType[j].s_MinResNetDataRate   = gt_HercADSL_TPS_TC_Params[i].ta_TPS_TC_Type[k].s_MinResNetDataRate;
            gpt_TxInfo->pta_G9925xInfo[s_linkmode]->ta_DSBearerChannel[i].ta_TpsTcType[j].s_MaxLatency          = gt_HercADSL_TPS_TC_Params[i].ta_TPS_TC_Type[k].s_MaxLatency;
            gpt_TxInfo->pta_G9925xInfo[s_linkmode]->ta_DSBearerChannel[i].ta_TpsTcType[j].uc_MaxBER             = gt_HercADSL_TPS_TC_Params[i].ta_TPS_TC_Type[k].uc_MaxBER;
            gpt_TxInfo->pta_G9925xInfo[s_linkmode]->ta_DSBearerChannel[i].ta_TpsTcType[j].s_IMAxINP             = gt_HercADSL_TPS_TC_Params[i].ta_TPS_TC_Type[k].s_IMAxINP;
            // XDSLRTFW-1481 (Start_End) TPSTCoptions is part of paramater 7 as per message spec
         gpt_TxInfo->pta_G9925xInfo[s_linkmode]->ta_DSBearerChannel[i].ta_TpsTcType[j].uc_TPSTCoptions       = gt_HercADSL_TPS_TC_Params[i].ta_TPS_TC_Type[k].uc_TPSTCoptions;

            gpt_TxInfo->pta_G9925xInfo[s_linkmode]->ta_USBearerChannel[i].ta_TpsTcType[j].s_MinNetDataRate      = gt_HercADSL_TPS_TC_Params[i+2].ta_TPS_TC_Type[k].s_MinNetDataRate;
            gpt_TxInfo->pta_G9925xInfo[s_linkmode]->ta_USBearerChannel[i].ta_TpsTcType[j].s_MaxNetDataRate      = gt_HercADSL_TPS_TC_Params[i+2].ta_TPS_TC_Type[k].s_MaxNetDataRate;
            gpt_TxInfo->pta_G9925xInfo[s_linkmode]->ta_USBearerChannel[i].ta_TpsTcType[j].s_MinResNetDataRate   = gt_HercADSL_TPS_TC_Params[i+2].ta_TPS_TC_Type[k].s_MinResNetDataRate;
            gpt_TxInfo->pta_G9925xInfo[s_linkmode]->ta_USBearerChannel[i].ta_TpsTcType[j].s_MaxLatency          = gt_HercADSL_TPS_TC_Params[i+2].ta_TPS_TC_Type[k].s_MaxLatency;
            gpt_TxInfo->pta_G9925xInfo[s_linkmode]->ta_USBearerChannel[i].ta_TpsTcType[j].uc_MaxBER             = gt_HercADSL_TPS_TC_Params[i+2].ta_TPS_TC_Type[k].uc_MaxBER;
            gpt_TxInfo->pta_G9925xInfo[s_linkmode]->ta_USBearerChannel[i].ta_TpsTcType[j].s_IMAxINP             = gt_HercADSL_TPS_TC_Params[i+2].ta_TPS_TC_Type[k].s_IMAxINP;
         // XDSLRTFW-1481 (Start_End) TPSTCoptions is part of paramater 7 as per message spec
            gpt_TxInfo->pta_G9925xInfo[s_linkmode]->ta_USBearerChannel[i].ta_TpsTcType[j].uc_TPSTCoptions       = gt_HercADSL_TPS_TC_Params[i+2].ta_TPS_TC_Type[k].uc_TPSTCoptions;


         }
      }
   }
   //memcpy(&gpt_TxInfo->pta_G9925xInfo[s_linkmode], &gpt_TxInfo->pta_G9923xInfo[s_linkmode], sizeof(Adsl2AllInfo_t));

}


/*^^^
 *-------------------------------------------------------------------
 *
 *  Prototype: void MapHERCMonitoSocOPTN(void);
 *
 *  Description:
 *      Map Hercules Moni to Soc OPTN (Loop Diag enable).
 *
 *-------------------------------------------------------------------
 *^^^
 */
void MapHERCMonitoSocOPTN(void)
{
   /*
    *------------------------------------------------------------------------------------------------------------
    *   CMV MAP                     StratiPHY   Adr Idx bits    <-                    Hercules    Adr Idx bits
    *   Loop Diag Mode Enable  OPTN        9   0   2                              MONI        4   0   2
    *   PM L2 enable                OPTN       15   0   Bit-9 (inverted logic)   <-    MONI        4   0   Bit-8
    *------------------------------------------------------------------------------------------------------------
    */

   OPTNArray[OPTN_StateMachineCtrl] |= (gsa_HercADSL_MONIMap_StateMachineConfig & MONI_LOOP_DIAG_MODE_ENABLE);

   //XDSLRTFW-403: Enhancement_ALL_BisPLus_ALL_L2_HercCMVreMap (Start)
   if(gsa_HercADSL_MONIMap_StateMachineConfig & MONI_L2_LOW_POWER_ENABLE)
   {
      OPTNArray[OPTN_OLRControl_DS] &= ~OPTN_DisableL2Mode;
// XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [Start]
      if(gsa_HercADSL_MONIMap_StateMachineConfig & MONI_L2_RFI_AUTO_EXIT)
      {
          OPTNArray[OPTN_Power_Management] |= OPTN_L2_Exit_Based_on_RFI;
      }
      else
      {
          OPTNArray[OPTN_Power_Management] &= ~OPTN_L2_Exit_Based_on_RFI;
      }
      if(gsa_HercADSL_MONIMap_StateMachineConfig & MONI_L2_AMD4_SUP)
      {
          OPTNArray[OPTN_Power_Management] |= OPTN_L2_Amd4_Enable;
      }
      else
      {
          OPTNArray[OPTN_Power_Management] &= ~OPTN_L2_Amd4_Enable;
      }
// XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [End]
   }
   else
    {
      OPTNArray[OPTN_OLRControl_DS] |= OPTN_DisableL2Mode;
// XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [Start]
      OPTNArray[OPTN_Power_Management] &=~OPTN_L2_Amd4_Enable;
      OPTNArray[OPTN_Power_Management] &= ~OPTN_L2_Exit_Based_on_RFI;
      OPTNArray[OPTN_Power_Management] &= ~OPTN_L2_Amd4_Enable;
// XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [End]
    }
   //XDSLRTFW-403: Enhancement_ALL_BisPLus_ALL_L2_HercCMVreMap (End)

}


/*^^^
 *-------------------------------------------------------------------
 *
 *  Prototype: void MapSocOutputstoHercRate(void);
 *
 *  Description:
 *      Map StratiPHY Output to Hercules Output CMVs.
 *
 *-------------------------------------------------------------------
 *^^^
 */
void MapSocOutputstoHercRate(void) {

   int i,j,s_NCDMap=0;
   uint16 us_ComputedINP;
   int16 s_ErasureGains[7] = {0x0100, 0x0180, 0x019A, 0x01B3, 0x01CD, 0x01E6, 0x0200};

   for(j=0; j< NUM_DATA_PATHS; j++)
   {

      /*
       *-----------------------------------------------------------------------------------------------
       *   CMV MAP                     StratiPHY   Adr Idx bits    ->          Hercules    Adr Idx bits
       *   DS Rate (bps)   LP0 LSW     RATE        1   0   15:0      (Kpbs)    RATE        1   0   15:0
       *                   LP0 MSW     RATE        1   1   15:0                RATE        1   1   15:0
       *                   LP1 LSW     RATE        1   2   15:0                RATE        1   2   15:0
       *                   LP1 MSW     RATE        1   3   15:0                RATE        1   3   15:0
       *   DS Delay        LP0         INFO        92  1   15:0                RATE        1   8   15:0
       *                   LP1         INFO        92  3   15:0                RATE        1   9   15:0
       *   DS Intl Depth   LP0         CNFG        27  0   15:0                RATE        1   10  15:0
       *                   LP1         CNFG        27  1   15:0                RATE        1   11  15:0
       *   DS Parity       LP0         CNFG        23  0    7:0                RATE        1   12   7:0
       *                   LP1         CNFG        23  1    7:0                RATE        1   13   7:0
       *   DS TCM          LP0         STAT        4   0      4                RATE        1   12     8
       *                   LP1         STAT        4   0      4                RATE        1   13     8
       *-----------------------------------------------------------------------------------------------
       */

      gt_HercADSL_DSRateCMV.s_TCM_Parity[j]   =   (STATArray[STAT_Misc] & STAT_TCM_DS)<<4;
   //XDSLRTFW-717 Task_AB_All_All_All_RateIn1kbpsGranularity (Start_End)
      gt_HercADSL_DSRateCMV.s_DataRate[j]     =   gla_DSDataRate[j] / 1000;   // Divide by 1000 to get 1kbps granularity
      //gt_HercADSL_DSRateCMV.s_ActualDelay[j]  =   (gt_DerivedFrameProperties_DS.PropPerLp[j].s_Latency + 2) >> 2; // rounding to nearest ms based on G993.2 spec
      // Fix for XDSLRTFW-437 is required for precision. API Change required enable the below line
      //XDSLRTFW-437:Enh_BisPlus_ALL_ALL_IntlvDelayIn1By100ms (start_end)
      gt_HercADSL_DSRateCMV.s_ActualDelay[j]  =   (gt_DerivedFrameProperties_DS.PropPerLp[j].s_Latency)*25; // report 1/100 th of msec
      gt_HercADSL_DSRateCMV.s_IntlDepth[j]    =   gt_rx_config.s_Dp[j];
      gt_HercADSL_DSRateCMV.s_TCM_Parity[j]   |=  gt_RxShowTimeVars.t_FrameParms[j].s_R;

      /*
       *-----------------------------------------------------------------------------------------------
       *  CMV MAP                      StratiPHY   Adr Idx bits    ->          Hercules    Adr Idx bits
       *  US Rate (bps)    LP0 LSW     RATE        0   0   15:0      (Kpbs)    RATE        0   0   15:0
       *                   LP0 MSW     RATE        0   1   15:0                RATE        0   1   15:0
       *                   LP1 LSW     RATE        0   2   15:0                RATE        0   2   15:0
       *                   LP1 MSW     RATE        0   3   15:0                RATE        0   3   15:0
       *  US Delay         LP0         INFO        93  1   15:0                RATE        0   8   15:0
       *                   LP1         INFO        93  3   15:0                RATE        0   9   15:0
       *  US Intl Depth    LP0         CNFG        16  0   15:0                RATE        0   10  15:0
       *                   LP1         CNFG        16  1   15:0                RATE        0   11  15:0
       *  US Parity        LP0         CNFG        12  0    7:0                RATE        0   12   7:0
       *                   LP1         CNFG        12  1    7:0                RATE        0   13   7:0
       *  US TCM           LP0         STAT        4   0      7                RATE        0   12     8
       *                   LP1         STAT        4   0      7                RATE        0   13     8
       *-----------------------------------------------------------------------------------------------
       */

      gt_HercADSL_USRateCMV.s_TCM_Parity[j]   =   (STATArray[STAT_Misc] & STAT_TCM_US)<<1;
   //XDSLRTFW-717 Task_AB_All_All_All_RateIn1kbpsGranularity (Start_End)
      gt_HercADSL_USRateCMV.s_DataRate[j]     =   gla_USDataRate[j] / 1000;   // Divide by 1000 to get 1kbps granularity
      //gt_HercADSL_USRateCMV.s_ActualDelay[j]  =   (gt_DerivedFrameProperties_US.PropPerLp[j].s_Latency + 2 ) >> 2; // rounding to nearest ms based on G993.2 spec
      // Fix for XDSLRTFW-437 is required for precision. API Change required enable the below line
      //XDSLRTFW-437:Enh_BisPlus_ALL_ALL_IntlvDelayIn1By100ms (start_end)
      gt_HercADSL_USRateCMV.s_ActualDelay[j]  =   (gt_DerivedFrameProperties_US.PropPerLp[j].s_Latency)*25; // report 1/100 th of msec
      gt_HercADSL_USRateCMV.s_IntlDepth[j]    =   gt_tx_config.s_Dp[j];
      gt_HercADSL_USRateCMV.s_TCM_Parity[j]   |=  gt_TxShowTimeVars.t_FrameParms[j].s_R;

   //XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (Start)
     //ADSLRTFW-1689: BugFix_DS_All_All_IncorrectINPReported (Start)
     us_ComputedINP = 0;
     if (gt_tx_config.s_Lp[j] != 0) { //To prevent divide-by-zero
        us_ComputedINP = (40 * (gt_tx_config.s_Dp[j] ) * (gt_tx_config.s_Rp[j]))/gt_tx_config.s_Lp[j];

        if(us_ComputedINP > 0x00FE)  //capping as per the standard
           us_ComputedINP = 0x00FF;
     }
     //ADSLRTFW-1689: BugFix_DS_All_All_IncorrectINPReported (End)
   gt_HercADSL_USRateCMV.s_ActInpNoErasure[j] = us_ComputedINP; //Reporting in 0.1 DMT symbol Granularity
   //Added as a work-around, if CO DSLAM doesn't support the "ActINP" EOC Test parameter
   if(gt_HercADSL_USRateCMV.s_ActInpErasure[j] == 0)
      gt_HercADSL_USRateCMV.s_ActInpErasure[j] = us_ComputedINP;
   //XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (End)
   }

   //XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (Start)
   for (j = 0; j < 2; j++)  //Maximum supported gt_rx_config.s_Nbc = 2
    {
        i = guca_rxBCnToLPp[j];
        //SMS00855449 CR_DS_ALL_ALL_MoveErasureDecoderControlsToDSLgroup (Start_End)
      //XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (Start_End)

      //INP with No Erasure decoding
      /*INP = 4 * (Rp) * Dp / Lp */
        //ADSLRTFW-1689: BugFix_DS_All_All_IncorrectINPReported (Start)
        us_ComputedINP = 0;
        if (gt_rx_config.s_Lp[i] != 0) { //To prevent divide-by-zero
           us_ComputedINP = (40 * (gt_rx_config.s_Dp[i] ) * (gt_rx_config.s_Rp[i]))/gt_rx_config.s_Lp[i];

           if(us_ComputedINP > 0x00FE)  //capping as per the standard
             us_ComputedINP = 0x00FF;
        }
        //ADSLRTFW-1689: BugFix_DS_All_All_IncorrectINPReported (End)
        gt_HercADSL_DSRateCMV.s_ActInpNoErasure[i] = us_ComputedINP;

        //if ((gs_DSL_EDcontrol & (ERASURE_DECODING_ENABLE| ERASURE_MAX_INP)) == (ERASURE_DECODING_ENABLE|ERASURE_MAX_INP))
        //XDSLRTFW-1502 (start_end)
        if((gs_DSL_EDcontrol & ERASURE_DECODING_ENABLE) &&
             (gt_ErasureDecoding_Reprt.ft_Report_ED == TRUE)
           )
        {
#if 0
            //XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (Start)
            //As per VR9 bitloading algorithm
            //Effective INP with erasure decoding (ActINPerasure) = 8* Rp * Dp / Lp;
            /*INP = 8* (Rp) * Dp / Lp */
            /* INP != INP_no_erasure*/
            us_ComputedINP <<= 1;
#else
            int16 s_idx;
            s_idx = TESTArray[Test_ErasureGains];
            us_ComputedINP   = (us_ComputedINP *s_ErasureGains[s_idx]+0x80)>>8;
#endif
            if(us_ComputedINP > 0x00FE) //capping as per the standard
               us_ComputedINP = 0x00FF;
            gt_HercADSL_DSRateCMV.s_ActInpErasure[i] = us_ComputedINP;
            //XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (End)
        }
        else
        {
            /*INPp = INP_no_erasurep.*/
            /*4* Rp * Dp / Lp*/
            /* Use the Reporting representation format (in terms of 0.1 DMT symbol)*/
            gt_HercADSL_DSRateCMV.s_ActInpErasure[i] = us_ComputedINP;
        }
    }
   //XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (End)

}

/*^^^
 *-------------------------------------------------------------------
 *
 *  Prototype: void MapSocPLAMtoHercAINF(uint16 us_CMVNum);
 *
 *  Description:
 *      Map StratiPHY PLAM Output to Hercules CNTR CMVs.
 *
 *-------------------------------------------------------------------
 *^^^
 */

// XDSLRTFW-575: Counter Write back in ADSL mode (Start)
void MapSocPLAMtoHercCNTR(uint16 us_CMVNum)
{
   int j;

   switch(us_CMVNum)
   {
      case  CNTR_NE_LinePerfCount: //CNTR 2
         /*
          *-----------------------------------------------------------------------------------------------
          *  CMV MAP                      StratiPHY   Adr Idx bits    ->          Hercules    Adr Idx bits
          *  NE ECS CNT           LSW     PLAM        6   0   15:0       LSW      CNTR        2   0   15:0
          *                                                              MSW      CNTR        2   1   15:0
          *  NE ES CNT            LSW     PLAM        7   0   15:0       LSW      CNTR        2   2   15:0
          *                                                              MSW      CNTR        2   3   15:0
          *  NE SES CNT           LSW     PLAM        8   0   15:0       LSW      CNTR        2   4   15:0
          *                                                              MSW      CNTR        2   5   15:0
          *  NE LOSS CNT          LSW     PLAM        9   0   15:0       LSW      CNTR        2   6   15:0
          *                                                              MSW      CNTR        2   7   15:0
          *  NE UAS CNT           LSW     PLAM        10  0   15:0       LSW      CNTR        2   8   15:0
          *                                                              MSW      CNTR        2   9   15:0
          *-----------------------------------------------------------------------------------------------
          */
         // XDSLRTFW-1562 (Start)
         //gt_HercADSL_CNTRMap_g997_NE_LinePerfCount.ul_FECSecCnt   =   (int32 )((uint16)(*PLAMMap[PLAM_NearEndECSCnt]));
         //gt_HercADSL_CNTRMap_g997_NE_LinePerfCount.ul_ESCnt    =   (int32 )((uint16)(*PLAMMap[PLAM_NearEndESCnt]));
         //gt_HercADSL_CNTRMap_g997_NE_LinePerfCount.ul_SESCnt    =   (int32 )((uint16)(*PLAMMap[PLAM_NearEndSESCnt]));
         //gt_HercADSL_CNTRMap_g997_NE_LinePerfCount.ul_LOSSCnt  =   (int32 )((uint16)(*PLAMMap[PLAM_NearEndLOSSCnt]));
         //gt_HercADSL_CNTRMap_g997_NE_LinePerfCount.ul_UASLCnt  =   (int32 )((uint16)(*PLAMMap[PLAM_NearEndUASLCnt]));
      // XDSLRTFW-1562 (End)
         break;

      case CNTR_FE_LinePerfCount:  //CNTR 4
         /*
          *-----------------------------------------------------------------------------------------------
          *  CMV MAP                      StratiPHY   Adr Idx bits    ->          Hercules    Adr Idx bits
          *  FE ECS CNT           LSW     PLAM        32  0   15:0       LSW      CNTR        4   0   15:0
          *                                                              MSW      CNTR        4   1   15:0
          *  FE ES CNT            LSW     PLAM        33  0   15:0       LSW      CNTR        4   2   15:0
          *                                                              MSW      CNTR        4   3   15:0
          *  FE SES CNT           LSW     PLAM        34  0   15:0       LSW      CNTR        4   4   15:0
          *                                                              MSW      CNTR        4   5   15:0
          *  FE LOSS CNT          LSW     PLAM        35  0   15:0       LSW      CNTR        4   6   15:0
          *                                                              MSW      CNTR        4   7   15:0
          *  FE UAS CNT           LSW     PLAM        36  0   15:0       LSW      CNTR        4   8   15:0
          *                                                              MSW      CNTR        4   9   15:0
          *-----------------------------------------------------------------------------------------------
          */
         // XDSLRTFW-1562 (Start)
         //gt_HercADSL_CNTRMap_g997_FE_LinePerfCount.ul_FECSecCnt   =   (int32 )((uint16)(*PLAMMap[PLAM_FarEndFECSCnt]));
         //gt_HercADSL_CNTRMap_g997_FE_LinePerfCount.ul_ESCnt    =   (int32 )((uint16)(*PLAMMap[PLAM_FarEndESCnt]));
         //gt_HercADSL_CNTRMap_g997_FE_LinePerfCount.ul_SESCnt    =   (int32 )((uint16)(*PLAMMap[PLAM_FarEndSESCnt]));
         //gt_HercADSL_CNTRMap_g997_FE_LinePerfCount.ul_LOSSCnt  =   (int32 )((uint16)(*PLAMMap[PLAM_FarEndLOSSCnt]));
         //gt_HercADSL_CNTRMap_g997_FE_LinePerfCount.ul_UASLCnt  =   (int32 )((uint16)(*PLAMMap[PLAM_FarEndUASLCnt]));
      // XDSLRTFW-1562 (End)
         break;

      case  CNTR_NE_CRC_Running:   //CNTR 8
         /*
          *-----------------------------------------------------------------------------------------------
          *  CMV MAP                      StratiPHY   Adr Idx bits    ->          Hercules    Adr Idx bits
          *  DS CRC Long      LSW LP0     PLAM        4   0   15:0       LSW LP0  CNTR        8   0   15:0
          *                   MSW LP0     PLAM            1   15:0       MSW LP0  CNTR            1   15:0
          *                   LSW LP1     PLAM            2   15:0       LSW LP1  CNTR            2   15:0
          *                   MSW LP1     PLAM            3   15:0       MSW LP1  CNTR            3   15:0
          *-----------------------------------------------------------------------------------------------
          */
         for(j=0; j < NUM_DATA_PATHS; j++)
         {
            //XDSLRTFW-2003 (start_end)
            gt_HercADSL_CNTRMap_g997_NE_ChPerf_CRCStats.ula_g997_CRC_RunningCnt[j] = (gula_CRC_count_Prev[j] +
                                                                                    gula_CRC_count[j]);
         }

         break;

      case CNTR_NE_FEC_Running: //CNTR 10
         /*
          *-----------------------------------------------------------------------------------------------
          *  CMV MAP                      StratiPHY   Adr Idx bits    ->          Hercules    Adr Idx bits
          *  DS FEC Long      LSW LP0     PLAM        5   0   15:0       LSW LP0  CNTR        10  0   15:0
          *                   MSW LP0     PLAM            1   15:0       MSW LP0  CNTR            1   15:0
          *                   LSW LP1     PLAM            2   15:0       LSW LP1  CNTR            2   15:0
          *                   MSW LP1     PLAM            3   15:0       MSW LP1  CNTR            3   15:0
          *-----------------------------------------------------------------------------------------------
          */
         for(j=0; j < NUM_DATA_PATHS; j++)
         {
            //XDSLRTFW-2003 (start)
            gt_HercADSL_CNTRMap_g997_NE_ChPerf_FECStats.ula_g997_FEC_RunningCnt[j] = (gula_CorrectedRSErrors[j]+
                                                                                       gula_CorrectedRSErrors_Prev[j]);

#ifdef ADSL_62
            gt_HercADSL_CNTRMap_g997_NE_ChPerf_FECStats.ula_FECV_RunningCnt[j] = (gula_UncorrectableRSCodewordCnt[j]+
                                                                                   gula_UncorrectableRSCodewordCnt_Prev[j]);

            gt_HercADSL_CNTRMap_g997_NE_ChPerf_FECStats.ula_TotalCW_RunningCnt[j] =
                                 (  gt_HercADSL_CNTRMap_g997_NE_ChPerf_FECStats.ula_g997_FEC_RunningCnt[j] +
                                    gt_HercADSL_CNTRMap_g997_NE_ChPerf_FECStats.ula_FECV_RunningCnt[j]);
            //XDSLRTFW-2003 (end)
#endif
         }

         break;

      case CNTR_FE_CRC_Running: //CNTR 12
         /*
          *-----------------------------------------------------------------------------------------------
          *  CMV MAP                      StratiPHY   Adr Idx bits    ->          Hercules    Adr Idx bits
          *  US CRC Long      LSW LP0     PLAM        25   0   15:0       LSW LP0  CNTR        12   0   15:0
          *                   MSW LP0     PLAM             1   15:0       MSW LP0  CNTR             1   15:0
          *                   LSW LP1     PLAM             2   15:0       LSW LP1  CNTR             2   15:0
          *                   MSW LP1     PLAM             3   15:0       MSW LP1  CNTR             3   15:0
          *-----------------------------------------------------------------------------------------------
          */

         for(j=0; j < NUM_DATA_PATHS; j++)
         {
            gt_HercADSL_CNTRMap_g997_FE_ChPerf_CRCStats.ula_g997_CRC_RunningCnt[j] = gla_febe_cnt[j];
         }

         break;

      case  CNTR_FE_FEC_Running: //CNTR 14
         /*
          *-----------------------------------------------------------------------------------------------
          *  US FEC Long      LSW LP0     PLAM        26   0   15:0       LSW LP0  CNTR        14   0   15:0
          *                   MSW LP0     PLAM             1   15:0       MSW LP0  CNTR             1   15:0
          *                   LSW LP1     PLAM             2   15:0       LSW LP1  CNTR             2   15:0
          *                   MSW LP1     PLAM             3   15:0       MSW LP1  CNTR             3   15:0

          *-----------------------------------------------------------------------------------------------
          */

         for(j=0; j < NUM_DATA_PATHS; j++)
         {
            gt_HercADSL_CNTRMap_g997_FE_ChPerf_FECStats.ula_g997_FEC_RunningCnt[j] = gla_ffec_cnt[j];
         }
         break;
   }
}
// XDSLRTFW-575: Counter Write back in ADSL mode (End)

//XDSLRTFW-151 :Feature_AB_ALL_ALL_NE_ATM_TC_CNTRS_Mapping(Start)
/*^^^
 *-------------------------------------------------------------------
 *
 *  Prototype: void MapSocPLAMNETxCntrs(void);
 *
 *  Description:
 *      Map ATM near End Counters to Hercules CNTR CMVs _ 53.
 *
 *-------------------------------------------------------------------
 *^^^
 */
void MapSocPLAMNETxCntrs(void)
{

   /*
    *-----------------------------------------------------------------------------------------------
    *  CMV MAP                      StratiPHY   Adr Idx bits    ->          Hercules    Adr Idx bits
    *  TxUserCell cnt NE BC0, LSW   PLAM        39   0   15:0       LSW      CNTR       53   0   15:0
    *                         MSW                    1   15:0       MSW      CNTR       53   1   15:0
    *  TxIdleCell cnt NE BC0, LSW   PLAM        38   0   15:0       LSW      CNTR       53   2   15:0
    *                         MSW                    1   15:0       MSW      CNTR       53   3   15:0
    *-----------------------------------------------------------------------------------------------
    */
   //XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping (Start)
   //Tx User Cell Count (TxCU) NE BC0
   gt_g997_AtmPerf_TX_UICELL.ul_UCELL_P_count   =   gula_tx_non_idle_cell_cnt[0];
   // Tx Idle Cell Count (TxIdle) NE BC0
   gt_g997_AtmPerf_TX_UICELL.ul_ICELL_P_count    =  gula_tx_idle_cell_cnt[0];
   //XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping (End)
}
//XDSLRTFW-151 :Feature_AB_ALL_ALL_NE_ATM_TC_CNTRS_Mapping (End)

//XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping (Start)
/*^^^
 *-------------------------------------------------------------------
 *
 *  Prototype: void MapSocPLAMtoHercNEDPPerfCntrs(void);
 *
 *  Description:
 *      Map Near-End ATM data path performance monitoring counters from SOC
 *      to Herc.
 *
 *-------------------------------------------------------------------
 *^^^
 */
void MapSocPLAMtoHercNEDPPerfCntrs(void)
{
   /*
    *-----------------------------------------------------------------------------------------------
    *  CMV MAP                      StratiPHY   Adr Idx bits    ->          Hercules    Adr Idx bits
    *  NE HECp CNT          LSW     PLAM        11   0   15:0       LSW      CNTR       46   0   15:0
    *                       MSW                      1   15:0       MSW      CNTR       46   1   15:0
    *  NE CDp CNT           LSW     PLAM        16   0   15:0       LSW      CNTR       46   2   15:0
    *                       MSW                      1   15:0       MSW      CNTR       46   3   15:0
    *  NE CUp CNT           LSW     PLAM        18   0   15:0       LSW      CNTR       46   4   15:0
    *                       MSW                      1   15:0       MSW      CNTR       46   5   15:0
    *  NE IBEp CNT          LSW     PLAM        19   0   15:0       LSW      CNTR       46   6   15:0
    *                       MSW                      1   15:0       MSW      CNTR       46   7   15:0
    *-----------------------------------------------------------------------------------------------
    */
   //Near-end Hec Violation Count
   gt_HercADSL_CNTRMap_g997_NE_DataPathPerfCount.l_HECp   =   gula_hec_error_cnt[0];
   //Near-end Delineated Total Cell Count
   gt_HercADSL_CNTRMap_g997_NE_DataPathPerfCount.l_CDp    =   gula_tot_hec_cnt[0];
   // Near-end User Total Cell Count
   gt_HercADSL_CNTRMap_g997_NE_DataPathPerfCount.l_CUp    =   gula_tot_cell_cnt[0];
   //Near-end Idle Cell Bit Error Count
   gt_HercADSL_CNTRMap_g997_NE_DataPathPerfCount.l_IBEp =   gula_bit_error_cnt[0];
}

/*^^^
 *-------------------------------------------------------------------
 *
 *  Prototype: void MapSocPLAMtoHercFEDPPerfCntrs(void);
 *
 *  Description:
 *      Map Far-End ATM data path performance monitoring counters from
 *      SOC to Herc
 *
 *-------------------------------------------------------------------
 *^^^
 */
void MapSocPLAMtoHercFEDPPerfCntrs(void)
{
   /*
    *-----------------------------------------------------------------------------------------------
    *  CMV MAP                      StratiPHY   Adr Idx bits    ->          Hercules    Adr Idx bits
    *  NE HECp CNT          LSW     PLAM        11   0   15:0       LSW      CNTR       51   0   15:0
    *                       MSW                      1   15:0       MSW      CNTR       51   1   15:0
    *  NE CDp CNT           LSW     PLAM        16   0   15:0       LSW      CNTR       51   2   15:0
    *                       MSW                      1   15:0       MSW      CNTR       51   3   15:0
    *  NE CUp CNT           LSW     PLAM        18   0   15:0       LSW      CNTR       51   4   15:0
    *                       MSW                      1   15:0       MSW      CNTR       51   5   15:0
    *  NE IBEp CNT          LSW     PLAM        19   0   15:0       LSW      CNTR       51   6   15:0
    *                       MSW                      1   15:0       MSW      CNTR       51   7   15:0
    *-----------------------------------------------------------------------------------------------
    */
   //Far-end Hec Violation Count
   gt_HercADSL_CNTRMap_g997_FE_DataPathPerfCount.l_HECp   =   gula_fhec_cnt[0];
   //Far-end Delineated Total Cell Count
   gt_HercADSL_CNTRMap_g997_FE_DataPathPerfCount.l_CDp    =   gula_fe_tot_hec_cnt[0];
   //Far-end User Total Cell Count
   gt_HercADSL_CNTRMap_g997_FE_DataPathPerfCount.l_CUp    =   gula_fe_tot_cell_cnt[0];
   //Far-end Idle Cell Bit Error Count
   gt_HercADSL_CNTRMap_g997_FE_DataPathPerfCount.l_IBEp   =   gula_fe_bit_error_cnt[0];

}
//XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping (End)

/*^^^
 *-------------------------------------------------------------------
 *
 *  Prototype: void MapSocPLAMtoHercPTMRxPerf(void);
 *
 *  Description:
 *      Copy PTM counters to Hercules CNTR CMVs.
 *
 *-------------------------------------------------------------------
 *^^^
 */
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping(Start)
void MapSocPLAMtoHercPTMRxPerf(void)
{

   /*
    *-----------------------------------------------------------------------------------------------
    *  CMV MAP                      StratiPHY   Adr Idx bits    ->          Hercules    Adr Idx bits
    *  NE ul_CRC_P_cnt      LSW     PLAM        xx   0   15:0       LSW      CNTR       45   0   15:0
    *                       MSW                      1   15:0       MSW      CNTR       45   1   15:0
    *  NE ul_CVC_P_cnt      LSW     PLAM        xx   0   15:0       LSW      CNTR       45   2   15:0
    *                       MSW                      1   15:0       MSW      CNTR       45   3   15:0
    *  NE ul_CRC_NP_cnt     LSW     PLAM        xx   0   15:0       LSW      CNTR       45   4   15:0
    *                       MSW                      1   15:0       MSW      CNTR       45   5   15:0
    *  NE ul_CVC_NP_cnt     LSW     PLAM        xx   0   15:0       LSW      CNTR       45   6   15:0
    *                       MSW                      1   15:0       MSW      CNTR       45   7   15:0
    *-----------------------------------------------------------------------------------------------
    */
   //Near-end Hec Violation Count
   gt_HercADSL_CNTRMap_g997_PtmPerf_NE.ul_CRC_P_cnt   =   gul_CRC_P_cnt;
   //Near-end Delineated Total Cell Count
   gt_HercADSL_CNTRMap_g997_PtmPerf_NE.ul_CVC_P_cnt   =   gul_CVC_P_cnt;
   // Near-end User Total Cell Count
   gt_HercADSL_CNTRMap_g997_PtmPerf_NE.ul_CRC_NP_cnt   =  gul_CRC_NP_cnt;
   //Near-end Idle Cell Bit Error Count
   gt_HercADSL_CNTRMap_g997_PtmPerf_NE.ul_CVC_NP_cnt   =   gul_CVC_NP_cnt;
}
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping(End)

/*^^^
 *-------------------------------------------------------------------
 *
 *  Prototype: void MapHercCNTRtoSOCPLAM(uint16 us_CMVNum);
 *
 *  Description:
 *      Map Hercules CNTR CMVs to StratiPHY PLAM.
 *
 *-------------------------------------------------------------------
 *^^^
 */
// XDSLRTFW-575: Counter Write back in ADSL mode (Start)
void MapHercCNTRtoSOCPLAM(uint16 us_CMVNum)
{
   int j;

   switch(us_CMVNum)
   {
      case CNTR_NE_LinePerfCount: //CNTR 2
         /*
          *   Allow ME to overwrite Counters prior to init to maintain counters value over multiple links
          *-----------------------------------------------------------------------------------------------
          *  CMV MAP                      StratiPHY   Adr Idx bits    <-          Hercules    Adr Idx bits
          *  NE ECS CNT           LSW     PLAM        6   0   15:0       LSW      CNTR        2   0   15:0
          *                                                              MSW      CNTR        2   1   15:0
          *  NE ES CNT            LSW     PLAM        7   0   15:0       LSW      CNTR        2   2   15:0
          *                                                              MSW      CNTR        2   3   15:0
          *  NE SES CNT           LSW     PLAM        8   0   15:0       LSW      CNTR        2   4   15:0
          *                                                              MSW      CNTR        2   5   15:0
          *  NE LOSS CNT          LSW     PLAM        9   0   15:0       LSW      CNTR        2   6   15:0
          *                                                              MSW      CNTR        2   7   15:0
          *  NE UAS CNT           LSW     PLAM        10  0   15:0       LSW      CNTR        2   8   15:0
          *                                                              MSW      CNTR        2   9   15:0
          *-----------------------------------------------------------------------------------------------
          */

         gs_fec_err_sec_cnt      =   (int16)gt_HercADSL_CNTRMap_g997_NE_LinePerfCount.ul_FECSecCnt;
         gs_err_sec_cnt          =   (int16)gt_HercADSL_CNTRMap_g997_NE_LinePerfCount.ul_ESCnt;
         gs_sev_err_sec_cnt      =   (int16)gt_HercADSL_CNTRMap_g997_NE_LinePerfCount.ul_SESCnt;
         gs_los_err_sec_cnt      =   (int16)gt_HercADSL_CNTRMap_g997_NE_LinePerfCount.ul_LOSSCnt;
         gs_unavail_err_sec_cnt  =   (int16)gt_HercADSL_CNTRMap_g997_NE_LinePerfCount.ul_UASLCnt;
         break;

      case CNTR_FE_LinePerfCount: //CNTR 4
         /*
          *   Allow ME to overwrite Counters prior to init to maintain counters value over multiple links
          *-----------------------------------------------------------------------------------------------
          *  CMV MAP                      StratiPHY   Adr Idx bits    <-          Hercules    Adr Idx bits
          *  FE ECS CNT           LSW     PLAM        32  0   15:0       LSW      CNTR        4   0   15:0
          *                                                              MSW      CNTR        4   1   15:0
          *  FE ES CNT            LSW     PLAM        33  0   15:0       LSW      CNTR        4   2   15:0
          *                                                              MSW      CNTR        4   3   15:0
          *  FE SES CNT           LSW     PLAM        34  0   15:0       LSW      CNTR        4   4   15:0
          *                                                              MSW      CNTR        4   5   15:0
          *  FE LOSS CNT          LSW     PLAM        35  0   15:0       LSW      CNTR        4   6   15:0
          *                                                              MSW      CNTR        4   7   15:0
          *  FE UAS CNT           LSW     PLAM        36  0   15:0       LSW      CNTR        4   8   15:0
          *                                                              MSW      CNTR        4   9   15:0
          *-----------------------------------------------------------------------------------------------
          */
         gs_ecs_fe_cnt    =  (int16)gt_HercADSL_CNTRMap_g997_FE_LinePerfCount.ul_FECSecCnt;
         gs_es_fe_cnt     =  (int16)gt_HercADSL_CNTRMap_g997_FE_LinePerfCount.ul_ESCnt;
         gs_ses_fe_cnt    =  (int16)gt_HercADSL_CNTRMap_g997_FE_LinePerfCount.ul_SESCnt;
         gs_loss_fe_cnt   =  (int16)gt_HercADSL_CNTRMap_g997_FE_LinePerfCount.ul_LOSSCnt;
         gs_uasl_fe_cnt   =  (int16)gt_HercADSL_CNTRMap_g997_FE_LinePerfCount.ul_UASLCnt;
         break;

      case CNTR_NE_CRC_Running: //CNTR 8
         /*
          *   Allow ME to overwrite Counters prior to init to maintain counters value over multiple links
          *-----------------------------------------------------------------------------------------------
          *  CMV MAP                      StratiPHY   Adr Idx bits    <-          Hercules    Adr Idx bits
          *  DS CRC Long      LSW LP0     PLAM        4   0   15:0       LSW LP0  CNTR        8   0   15:0
          *                   MSW LP0     PLAM            1   15:0       MSW LP0  CNTR            1   15:0
          *                   LSW LP1     PLAM            2   15:0       LSW LP1  CNTR            2   15:0
          *                   MSW LP1     PLAM            3   15:0       MSW LP1  CNTR            3   15:0
          *-----------------------------------------------------------------------------------------------
          */
         //XDSLRTFW-508 Fix_DS_All_All_SuppressCounterWriteFromDSLAPI (Start)
         //XDSLRTFW-2003 Conter Writeback should not be allowed in ShowTime.(safety check)
         //XDSLRTFW-2003 (start)
         if (!((STATArray[STAT_MacroState] == STAT_ShowTimeState) ||
                (STATArray[STAT_MacroState] == STAT_ShowTimeTCSyncState)))
         {
            for(j=0; j < NUM_DATA_PATHS; j++)
            {
               gula_CRC_count_Prev[j] = gt_HercADSL_CNTRMap_g997_NE_ChPerf_CRCStats.ula_g997_CRC_RunningCnt[j];
            }
         }
         //XDSLRTFW-508 Fix_DS_All_All_SuppressCounterWriteFromDSLAPI (End)
         break;

      case CNTR_NE_FEC_Running: //CNTR 10
         /*
          *   Allow ME to overwrite Counters prior to init to maintain counters value over multiple links
          *-----------------------------------------------------------------------------------------------
          *  CMV MAP                      StratiPHY   Adr Idx bits    <-          Hercules    Adr Idx bits
          *  DS FEC Long      LSW LP0     PLAM        5   0   15:0       LSW LP0  CNTR        10  0   15:0
          *                   MSW LP0     PLAM            1   15:0       MSW LP0  CNTR            1   15:0
          *                   LSW LP1     PLAM            2   15:0       LSW LP1  CNTR            2   15:0
          *                   MSW LP1     PLAM            3   15:0       MSW LP1  CNTR            3   15:0
          *-----------------------------------------------------------------------------------------------
          */
         //XDSLRTFW-508 Fix_DS_All_All_SuppressCounterWriteFromDSLAPI (Start)
         //XDSLRTFW-2003 Conter Writeback should not be allowed in ShowTime.
         if (!((STATArray[STAT_MacroState] == STAT_ShowTimeState) ||
               (STATArray[STAT_MacroState] ==  STAT_ShowTimeTCSyncState)))
         {
            for(j=0; j < NUM_DATA_PATHS; j++)
            {
               //Fix_DS_All_All_ModifiedToGetCRCPerLink
               //gusa_CRC_count[j] =   (int16) gla_g997_CRC_Runningcnt[j];
               gula_CorrectedRSErrors_Prev[j] = gt_HercADSL_CNTRMap_g997_NE_ChPerf_FECStats.ula_g997_FEC_RunningCnt[j];
               //gsa_CorrectedRSErrors[j] = (int16)gt_HercADSL_CNTRMap_g997_NE_ChPerf_FECStats.ula_g997_FEC_RunningCnt[j];
               #ifdef ADSL_62
               gula_UncorrectableRSCodewordCnt_Prev[j] = gt_HercADSL_CNTRMap_g997_NE_ChPerf_FECStats.ula_FECV_RunningCnt[j];
               #endif
            }
         }
         //XDSLRTFW-508 Fix_DS_All_All_SuppressCounterWriteFromDSLAPI (End)
         //XDSLRTFW-2003 (end)
         break;

   case CNTR_PTM_BC0_StatsNE: //CNTR 45
     /*
    *-----------------------------------------------------------------------------------------------
    *  CMV MAP                      StratiPHY   Adr Idx bits    <-          Hercules    Adr Idx bits
    *  NE ul_CRC_P_cnt      LSW     PLAM        xx   0   15:0       LSW      CNTR       45   0   15:0
    *                       MSW                      1   15:0       MSW      CNTR       45   1   15:0
    *  NE ul_CVC_P_cnt      LSW     PLAM        xx   0   15:0       LSW      CNTR       45   2   15:0
    *                       MSW                      1   15:0       MSW      CNTR       45   3   15:0
    *  NE ul_CRC_NP_cnt     LSW     PLAM        xx   0   15:0       LSW      CNTR       45   4   15:0
    *                       MSW                      1   15:0       MSW      CNTR       45   5   15:0
    *  NE ul_CVC_NP_cnt     LSW     PLAM        xx   0   15:0       LSW      CNTR       45   6   15:0
    *                       MSW                      1   15:0       MSW      CNTR       45   7   15:0
    *-----------------------------------------------------------------------------------------------
    */
   //Near-end Hec Violation Count
   gul_CRC_P_cnt = gt_HercADSL_CNTRMap_g997_PtmPerf_NE.ul_CRC_P_cnt;
   //Near-end Delineated Total Cell Count
   gul_CVC_P_cnt = gt_HercADSL_CNTRMap_g997_PtmPerf_NE.ul_CVC_P_cnt;
   // Near-end User Total Cell Count
   gul_CRC_NP_cnt = gt_HercADSL_CNTRMap_g997_PtmPerf_NE.ul_CRC_NP_cnt;
   //Near-end Idle Cell Bit Error Count
   gul_CVC_NP_cnt = gt_HercADSL_CNTRMap_g997_PtmPerf_NE.ul_CVC_NP_cnt;
   break;

   case CNTR_ATM_BC0_StatsNE: //CNTR 46
   /*
    *-----------------------------------------------------------------------------------------------
    *  CMV MAP                      StratiPHY   Adr Idx bits    <-          Hercules    Adr Idx bits
    *  NE HECp CNT          LSW     PLAM        11   0   15:0       LSW      CNTR       46   0   15:0
    *                       MSW                      1   15:0       MSW      CNTR       46   1   15:0
    *  NE CDp CNT           LSW     PLAM        16   0   15:0       LSW      CNTR       46   2   15:0
    *                       MSW                      1   15:0       MSW      CNTR       46   3   15:0
    *  NE CUp CNT           LSW     PLAM        18   0   15:0       LSW      CNTR       46   4   15:0
    *                       MSW                      1   15:0       MSW      CNTR       46   5   15:0
    *  NE IBEp CNT          LSW     PLAM        19   0   15:0       LSW      CNTR       46   6   15:0
    *                       MSW                      1   15:0       MSW      CNTR       46   7   15:0
    *-----------------------------------------------------------------------------------------------
    */
   //Near-end Hec Violation Count
   gula_hec_error_cnt[0] = gt_HercADSL_CNTRMap_g997_NE_DataPathPerfCount.l_HECp;
   //Near-end Delineated Total Cell Count
   gula_tot_hec_cnt[0] = gt_HercADSL_CNTRMap_g997_NE_DataPathPerfCount.l_CDp;
   // Near-end User Total Cell Count
   gula_tot_cell_cnt[0] = gt_HercADSL_CNTRMap_g997_NE_DataPathPerfCount.l_CUp;
   //Near-end Idle Cell Bit Error Count
   gula_bit_error_cnt[0] = gt_HercADSL_CNTRMap_g997_NE_DataPathPerfCount.l_IBEp;
   break;

   case CNTR_ATM_BC0_TxStatsNE: //CNTR 53
    /*
    *-----------------------------------------------------------------------------------------------
    *  CMV MAP                      StratiPHY   Adr Idx bits    <-          Hercules    Adr Idx bits
    *  TxUserCell cnt NE BC0, LSW   PLAM        39   0   15:0       LSW      CNTR       53   0   15:0
    *                         MSW                    1   15:0       MSW      CNTR       53   1   15:0
    *  TxIdleCell cnt NE BC0, LSW   PLAM        38   0   15:0       LSW      CNTR       53   2   15:0
    *                         MSW                    1   15:0       MSW      CNTR       53   3   15:0
    *-----------------------------------------------------------------------------------------------
    */
   //XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping (Start)
   //Tx User Cell Count (TxCU) NE BC0
   gula_tx_non_idle_cell_cnt[0] = gt_g997_AtmPerf_TX_UICELL.ul_UCELL_P_count;
   // Tx Idle Cell Count (TxIdle) NE BC0
   gula_tx_idle_cell_cnt[0] = gt_g997_AtmPerf_TX_UICELL.ul_ICELL_P_count;
   //XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping (End)
   break;

   }

}
// XDSLRTFW-575: Counter Write back in ADSL mode (End)


/*^^^
 *-------------------------------------------------------------------
 *
 *  Prototype: void MapSocINFOtoHercINFO(void);
 *
 *  Description:
 *      Map Hercules CNTR CMVs to StratiPHY PLAM.
 *
 *-------------------------------------------------------------------
 *^^^
 */

void MapSocINFOtoHercINFO(void)
{

   /*
    *   Hercules SNRM is reported in 0.1dB Resolution in BIS & DMT.
    *   StratiPHY SNRM is reported in 0.5dB Resolution for DMT & 0.1dB Resolution in BIS.
    *-------------------------------------------------------------------------------------------
    *   CMV MAP             StratiPHY  Adr Idx     ->  CMV MAP              Hercules    Adr Idx
    *   DS SNRM (.5dB)      INFO       68  3           DS SNRM (.1dB)       INFO        68  3
    *-------------------------------------------------------------------------------------------
    */

   memcpy(INFOMap[INFO_TestParamsDS], &gt_NearEndParam, sizeof(gt_HercADSL_NearEndParam));
   gt_HercADSL_NearEndParam.s_SnrMargin = *PLAMMap[PLAM_SNRMargin_OneOverTen_dB_Resolution];

   /*
    *-----------------------------------------------------------------------------------------------
    *  CMV MAP                      StratiPHY   Adr Idx bits    ->          Hercules    Adr Idx bits
    *  HLINSCds                     INFO        70   2   15:0               INFO        79   0   15:0
    *  HLOGMTds                     INFO        79   0   15:0               INFO        79   2   15:0
    *  QLNMTds                      INFO        79   1   15:0               INFO        79   4   15:0
    *  SNRMTds                      INFO        79   2   15:0               INFO        79   6   15:0
    *  HLINGds                      ADSL Group Size = 2                     INFO        79   1   15:0
    *  HLOGGds                      ADSL Group Size = 2                     INFO        79   3   15:0
    *  QLNGds                       ADSL Group Size = 2                     INFO        79   5   15:0
    *  SNRGds                       ADSL Group Size = 2                     INFO        79   7   15:0
    *-----------------------------------------------------------------------------------------------
    */

   gt_HercADSL_INFOMap_ChanMeasParamsDS.s_HLINSC   =   gt_DS_LDParam.s_Hlin_scale;
   gt_HercADSL_INFOMap_ChanMeasParamsDS.s_HLOGMT   =   gt_DS_MeasurementPeriod.us_Hlogf_measurement_period;
   gt_HercADSL_INFOMap_ChanMeasParamsDS.s_QLNMT    =   gt_DS_MeasurementPeriod.us_QLN_measurement_period;
   gt_HercADSL_INFOMap_ChanMeasParamsDS.s_SNRMT    =   gt_DS_MeasurementPeriod.us_snr_measurement_period;

   /*
    *-----------------------------------------------------------------------------------------------
    *  CMV MAP                      StratiPHY   Adr Idx bits    ->          Hercules    Adr Idx bits
    *  HLINSCus                     INFO        71   2   15:0               INFO        80   0   15:0
    *  HLOGMTus                     INFO        80   0   15:0               INFO        80   2   15:0
    *  QLNMTus                      INFO        80   1   15:0               INFO        80   4   15:0
    *  SNRMTus                      INFO        80   2   15:0               INFO        80   6   15:0
    *  HLINGus                      ADSL Group Size = 2  15:0               INFO        80   1   15:0
    *  HLOGGus                      ADSL Group Size = 2  15:0               INFO        80   3   15:0
    *  QLNGus                       ADSL Group Size = 2  15:0               INFO        80   5   15:0
    *  SNRGus                       ADSL Group Size = 2  15:0               INFO        80   7   15:0
    *-----------------------------------------------------------------------------------------------
    */

   gt_HercADSL_INFOMap_ChanMeasParamsUS.s_HLINSC   =   gt_US_LDParam.s_Hlin_scale;
   gt_HercADSL_INFOMap_ChanMeasParamsUS.s_HLOGMT   =   gt_US_MeasurementPeriod.us_Hlogf_measurement_period;
   gt_HercADSL_INFOMap_ChanMeasParamsUS.s_QLNMT    =   gt_US_MeasurementPeriod.us_QLN_measurement_period;
   gt_HercADSL_INFOMap_ChanMeasParamsUS.s_SNRMT    =   gt_US_MeasurementPeriod.us_snr_measurement_period;

}

#endif  // #ifdef HERC_API
