/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   mtkernel.c
*
*   Routines to implement multi-tasking kernel.
*-------------------------------------------------------------------------
*/


#include <stdio.h>
#include "typedef.h"
#include "xception.h"
#include "mtkernel.h"
#include "gdata.h"
#include "profdbg.h"
#include "DetectInterrupts.h"
#include "cri_iof.h"
#include "fifo.h"
#ifdef DEBUG_STREAMING
#include "DebugBuffer.h"
#endif
#define TARGET


#ifndef TARGET_HW
FlagT gft_stallcontroldisable;
#endif


#ifndef ADSL_62

#define WhichThreadIsTask(task) ((((task)->TaskID)>>12)&0x7)

/* external functions */
void KernelException(int16);
void FullContextSave(void);
void FullContextRestore(void);
void ireturn(void);
PtrToFunc PopIReturnPtr();
void SetTimer(int16);
void tc_task0();
void ntc_task0();
void tc_task1();
void ntc_task1();
void tc_task2();
void ntc_task2();
void tc_task3();
void ntc_task3();
void tc_task4();
void ntc_task4();



int16           ThreadOrderLUT[NUM_THREADS];
int16           Thread;
int16           FGActive=0;
int16           FirstTimeKernel=1;

/* Define stack pointer & stacks with corresponding stack pointers array */
int16          Stack[NUM_THREADS][STACK_SIZE];
int16          *SPArray[NUM_THREADS];
int16          *StackPointer;

int16 KernelFault;
int16 SchedulerFault;
int32 PCArray[NUM_THREADS];
PtrToFunc ProgCounter;
int16 TimerTime[NUM_THREADS];
Queue_t TaskQueue[NUM_THREADS];

void TxForeGround(void);
void RxForeGround(void);
void nonADSL_main();
void ADSL_main();


/*****************************************************************************
;  Prototype: void KernelInit(void)
;
;  Initialization of kernel-specific variables.
;
;  Input Arguments: none.
;
;  Output Arguments: none.
;
;  Return: none.
;
;****************************************************************************/
void KernelInit(void) {

   /* Initialized thread order */
   ThreadOrderLUT[0] = 1;
   ThreadOrderLUT[1] = 0;


#ifndef TARGET
   SPArray[0] = &(Stack[0][0]);
   SPArray[1] = &(Stack[1][0]);
#endif

   TaskQueue[0].Front=TaskQueue[0].Rear=NULL;
   TaskQueue[1].Front=TaskQueue[1].Rear=NULL;

   /* Initialize thread 1 to start of its main */
#ifndef TARGET
   PCArray[1] = nonADSL_main;
#else
   PCArray[1] = (int32) nonADSL_main;
   PCArray[0] = (int32) ADSL_main;
#endif

   /* Init current thread */
   Thread = 0;
   StackPointer = SPArray[Thread];

   /* set the timer to the time alloted for the current thread */
   SetTimer(TimerTime[Thread]);

   gs_GlobalInterruptFlag=TRUE;

#if 0
   /* start the background for thread 0 */
   ADSL_main();
#endif
}
/*****************************************************************************
;  Prototype: void AddTaskToQueue(TCB_t *NewTask,Queue_t *Q);
;              void DeleteTaskFromQueue(Queue_t *Q);
;
;  These subroutines add or delete tasks to or from task queue Q.
;
;  Input Arguments:
;       TCB_t *NewTask          - pointer to TCB to be added to queue.
;       Queue_t *Q              - pointer to queue to or from which a task
;                                 is to be added or deleted.
;  Output Arguments: none.
;
;  Return: none.
;
;  Comments:
;   An empty queue is characterized by having both the Front and the
;   Rear pointers pointing to NULL:
;
;                 Front -> NULL
;                  Rear -> NULL
;
;   An one-element queue has both the Front and Rear point to the SAME TCB,
;   and that TCB in turns point to NULL:
;
;                 Front -> [1] -> NULL
;                           ^
;                           |
;                         Rear
;
;   An M-element queue has both the Front pointing to the 1st element and the
;   Rear pointing to the M-th element:
;
;                   [1] -> .... -> [M] -> NULL
;                    ^              ^
;                    |              |
;                  Front          Rear
;
;   Each time an element is added to the rear of the queue, the Rear marker
;   moves. Each time an element is deleted from the front of the queue, the
;   Front marker moves.
;   Special care needs to be taken when going from empty queue to 1 element
;   queue and vice versa.
;
;****************************************************************************/
static void AddTaskToQueue(TCB_t *NewTask,Queue_t *Q) {

    /* See if new task is already in queue. */
   if (NewTask->TaskID & 0x8000) {
      KernelException(QUEUE_ADD_EXCEPTION);
      return;
   }


   /* Add new task to rear of queue: */
   if (Q->Front == NULL) { /* empty queue */
      Q->Front = NewTask;
      Q->Rear  = NewTask;
      NewTask->Next = NULL;
   } else { /* non-empty queue */
      Q->Rear->Next = NewTask;
      NewTask->Next  = NULL;
      Q->Rear = NewTask;
   }

   /* Set MSB TaskID bit to indicate TCB is now added to the queue. */
   NewTask->TaskID |= 0x8000;
}


static void DeleteTaskFromQueue(Queue_t *Q) {
   gs_GlobalInterruptFlag=FALSE;

    /* See if queue is empty. */
   if (Q->Front == NULL) {
      KernelException(QUEUE_DELETE_EXCEPTION);
      return;
   }

    /* Clear MSB TaskID bit to indicate TCB is now deleted from the queue. */
   Q->Front->TaskID &= ~0x8000;

   /* Delete old task from front of queue: */
   Q->Front = Q->Front->Next;

   /* If there are none left, then set Rear to NULL */
   if (Q->Front==NULL)
      Q->Rear=NULL;
   gs_GlobalInterruptFlag=TRUE;
}

/*****************************************************************************
;  Prototype: TCB_t *IdentifyInterruptSource(void);
;
;  Identifies the source of interrupt from multiple sources.
;
;  Input Arguments: none.
;
;  Output Arguments: none.
;
;  Return: none.
;       TCB_t *                 - pointer to TCB corresponding to the
;                                 identified interrupt source.
;  Global Variables:
;     TaskArray[]             - (I) Array of TCB's, with one TCB
;                                     corresponding to one unique interrupt
;                                     source.
;
;****************************************************************************/
static TCB_t *IdentifyInterruptSource()
{
   TCB_t          *task_p;
   int16 mask;
   int16 InterruptSource;


   for(InterruptSource=NUM_INTERRUPTS-1;InterruptSource >=0;InterruptSource--)
   {
      mask = (int16) (1<< InterruptSource);
      if (mask & gs_InterruptMask)
      {
         task_p = &gt_TaskArray[InterruptSource];
         ResetInterrupt(InterruptSource);
         return task_p;
      }
   }
   task_p = NULL;
   return task_p;

}


/*****************************************************************************
;  Prototype: void TimeSlicer(void);
;
;  This is an interrupt service routine called from a timer interrupt.
;
;  Input Arguments: none.
;
;  Output Arguments: none.
;
;  Return: none.
;
;  Global Variables:
;     gs_GlobalInterruptFlag  - (O) ?
;     FGActive             - (I) Flag indicating whether there is a
;                                     foreground process currently running.
;     ThreadOrderLUT[]     - (I) Look up table for determining the order
;                                     in which the threads are run.
;     TimerTime[]             - (I) Num of clock ticks to count for each
;                                     before triggering a timer interrupt.
;     PCArray[]               - (IO)Array of return addresses from which each
;                                     thread resumes execution.
;     SPArray[]               - (IO)Array of stack pointers for each thread.
;
;****************************************************************************/
void TimeSlicer(void)
{
   int16 CurThread;
   int16 NextThread;

   gs_GlobalInterruptFlag=FALSE;
   /* Timer Interrupts can only happen in the background */
   if (FGActive)
      KernelException(TIMER_INTERRUPT_FOREGROUND);


   CurThread=Thread;
   NextThread = ThreadOrderLUT[CurThread];
   SetTimer(TimerTime[NextThread]);

   /* Since the ISR will never return, remove the ISR return pointer from its statck */
   ProgCounter=PopIReturnPtr();

#ifndef TARGET
   PCArray[CurThread]=ProgCounter;
#endif
   FullContextSave();

   /* Switch stackpointer */
   SPArray[CurThread] = StackPointer;
   StackPointer = SPArray[NextThread];

   Thread=NextThread;

   gs_GlobalInterruptFlag=TRUE;

   /* Retreive NextThread Background Context Here */
   FullContextRestore();
#ifndef TARGET
   ProgCounter=PCArray[Thread];
#endif

   /* Return to background processing */
   (*ProgCounter)();
}


/*****************************************************************************
;  Prototype: void MasterIntHandler(void);
;
;  This interrupt service routine identifies the interrupt source,
;   optionally executes a (relatively quick) time-critical function and
;   optionally puts a non-time-critical function/task into the task queue
;   for delayed processing. During the master interrupt handler,
;   interrupts are disabled.
;
;  Input Arguments: none.
;
;  Output Arguments: none.
;
;  Return: none.
;
;  Global Variables:
;     gs_GlobalInterruptFlag  - (O) ?
;     FGActive             - (I) Flag indicating whether there is a
;                                     foreground process currently running.
;
;****************************************************************************/
void MasterIntHandler(void)
{
   TCB_t          *NewTask;
   Queue_t  *Q;

   gs_GlobalInterruptFlag=FALSE;

   FullContextSave();

   while ((NewTask = IdentifyInterruptSource()) != NULL)
   {
      /* If there is a time critical task, run it here */
      if (NewTask->TimeCriticalTask != NULL) {
PROFDBG_DO_TIME_CRITICAL_BEGIN
         (*(NewTask->TimeCriticalTask)) ();
PROFDBG_DO_TIME_CRITICAL_END
      }

      if (NewTask->NonTimeCriticalTask != NULL)
         AddTaskToQueue(NewTask,&TaskQueue[WhichThreadIsTask(NewTask)]);
   }

   gs_GlobalInterruptFlag=TRUE;

/* If we are in the background when interrupted, exectute the foreground,
otherwise ireturn will return to current foreground */
   if (FGActive == 0)
   {
      FGActive = 1;
      for(Q = &TaskQueue[Thread];Q->Front;DeleteTaskFromQueue(Q))
         (*(Q->Front->NonTimeCriticalTask))();
      FGActive = 0;
   }
   FullContextRestore();
   ireturn();

}

void SetInterrupt(uint16 us_Interrupt){
   gs_InterruptMask = (int16) (gs_InterruptMask | ((1<<us_Interrupt) & gs_InterruptEnableMask));
}

void ResetInterrupt(uint16 us_Interrupt){
   gs_InterruptMask = (int16) (gs_InterruptMask & ~(1<<us_Interrupt));
}


void ADSL_main()
{
   int i=0, j=0;
   int AlwaysTrue=1;

   /* Initialization Stuff goes here */

   while (AlwaysTrue)
   {/* dummy code */
      j++;
      i = j;
      /* Background Loop */

   }

}


void nonADSL_main()
{
   int i=0, j=0;
   int AlwaysTrue=1;

   /* Initialization Stuff goes here */
   while (AlwaysTrue)
   {/* dummy code */
      j++;
      i = j;
      /* Background Loop */

   }
}



/* The following functions don't really have C equivalents */

int16 GlobalTimer;
void SetTimer(int16 i)
{
   GlobalTimer=i;
}

void FullContextSave()
{
}

void FullContextRestore()
{
}

void ireturn()
{
}

PtrToFunc PopIReturnPtr()
{
   PtrToFunc p;
   p = NULL;
   return(p);
}
#endif //ADSL_62

/*****************************************************************************
;  Prototype: void ForegroundHandler(void);
;
;  This function runs the calls to all foreground DSP tasks (including both time
;   critical (TC) and non-time critical (NTC), and both TX and RX. Based on the multiport HW
;   task scheduling method. The RX TC tasks are called first, followed by the TX TC task,
;   TX NTC task and then RX NTC tasks.
;
;  Input Arguments: none.
;
;  Output Arguments: none.
;
;  Return: none.
;
;  Global Variables:
;     gs_InterruptSource - (I) containing the interrupt sources
;     gt_TaskArray[] -- (I) the array of task function pointers
;     gs_RxNextState -- (I) the next RX state
;     gs_RxState -- (I) the current RX state
;
;****************************************************************************/
#ifdef ADSL_62
#ifndef TARGET_HW
extern uint8 guc_ftb_rx_qt_stalls;
extern uint8 guc_ftb_tx_qt_stalls;

void ForegroundHandler(void)
{
   FlagT ft_TxQtRun, ft_RxQtRun, ft_RxPmsRun;
   static int16 gs_RxPmsDelayCnt = 1;

   //If this is not expected interrupt, return
#ifndef TARGET_HW
    if(gs_InterruptMask == (1<< TX_FRAME_START))
      return;
#endif
   //Check if TX or RX QT is stalled or not
   ft_TxQtRun = !CheckQtStall((uint8)TX);
   ft_RxQtRun = !CheckQtStall((uint8)RX);


   if (gft_stallcontroldisable == 1)
   {
      ft_TxQtRun= 1;
      ft_RxQtRun = 1;
   }

   //This flag synchronizes the RX FC NTC run with RX FC TC run
   ft_RxPmsRun = 0;

   //Run DSP tasks in the following order as required in the time-slotted scheduling method
   //1. RX time critical, 2. TX time critical, 3. TX non-time critical, 4. RX non-time critical
   if(ft_RxQtRun) //If QT is not stalled
   {
      //RX time critical test
      if(gs_InterruptMask & (1<<RX_TSC_INT))
      {

          if (gt_TaskArray[RX_TSC_INT].TimeCriticalTask != NULL)
          {
         gt_TaskArray[RX_TSC_INT].TimeCriticalTask();
          }
      }
    }
   else
   {
        //Disable QTP for this frame
      DisableRxQtp();


        // allow at most 2 consecutive stalls  guc_ftb_rx_qt_stalls = 0,1
        if (guc_ftb_rx_qt_stalls == 0)
        {
            guc_ftb_rx_qt_stalls++;

            //Enable QTP in the next frame
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, EnableRxQtp);

            if((gs_RxNextState == R_C_SHOWTIME_RX) || (gs_RxState == R_C_SHOWTIME_RX))
            {
                //we will disable PMS one frame later
                DisableRxPms();

                //Set the bit to enable RX PMS next frame
                AddFunctionToFifo(gp_RxLoadingFunctionFifo, EnableRxPms);
            }
        }

      ClearRxStall();
   }

#if 0
  //ProcessTime
    if(gs_InterruptMask & (1<<RX_FRAME_START))
    {
         /* Run RxForeGround after RxProcessTones() */
         if (gt_TaskArray[RX_FRAME_START].TimeCriticalTask != NULL)
         gt_TaskArray[RX_FRAME_START].TimeCriticalTask();
    }
#endif

   //TX time critical task
   if(ft_TxQtRun) //If QT is not stalled
   {
      if(gs_InterruptMask & (1<<RX_TSC_INT))
        {
         if (gt_TaskArray[TX_FRAME_START].TimeCriticalTask != NULL)
            {
            gt_TaskArray[TX_FRAME_START].TimeCriticalTask();
            }
        }
   }
   else
   {
      //Disable QTP for this frame
      DisableTxQtp();


        // allow at most 2 consecutive stalls  guc_ftb_tx_qt_stalls = 0,1
        if (guc_ftb_tx_qt_stalls == 0)
        {
            guc_ftb_tx_qt_stalls++;

            //Enable QTP in the next frame
            AddFunctionToFifo(gp_TxLoadingFunctionFifo, EnableTxQtp);

            if((gs_TxNextState == R_SHOWTIME_TX) || (gs_TxState == R_SHOWTIME_TX))
            {
                //Disable PMS for this frame
                DisableTxPms();

                //Enable PMS in the next frame
                AddFunctionToFifo(gp_TxLoadingFunctionFifo, EnableTxPms);
            }
        }

      ClearTxStall();
   }

#ifdef DEBUG_STREAMING
   // only execute when debug streams are enabled
   if(gt_debugStreamControl.Parameter0 & CMV_INFO115_CONTROL_MASK)
   {
      DSH_FgService();
   }
   else
   {
      //Set VersionInfoStreamed to FALSE, so Version Info gets streamed again next time streams get enabled again
      guc_DSH_VersionInfoStreamed = FALSE;
   }
#endif

   //TX non-time critical task
   if(ft_TxQtRun) //If QT is not stalled
   {
      if(gs_InterruptMask & (1<<RX_TSC_INT))
      {
         if (gt_TaskArray[TX_FRAME_START].NonTimeCriticalTask != NULL)
            {
            gt_TaskArray[TX_FRAME_START].NonTimeCriticalTask();
            }
      }

   }

   //RX non-time critical task
   if (ft_RxQtRun)   //If QT is not stalled
   {
      if(gs_InterruptMask & (1<<RX_TSC_INT))
      {
            if (gt_TaskArray[RX_TSC_INT].NonTimeCriticalTask != NULL)
            {
            gt_TaskArray[RX_TSC_INT].NonTimeCriticalTask();
            }

#ifdef VR9_FIXME
            if(ft_RxPmsRun)
         {

            gt_TaskArray[RX_TSC_INT].NonTimeCriticalTask();
         }
#endif
      }
   }
#if 0
//ProcessTime
    if(gs_InterruptMask & (1<<RX_FRAME_START))
    {
        if (gt_TaskArray[RX_FRAME_START].NonTimeCriticalTask != NULL)
      gt_TaskArray[RX_FRAME_START].NonTimeCriticalTask();
    }
#endif

} //ForegroundHandler()

void EnableCores_ForLinkStart(void);
uint8 guc_PortActive=2;
int16 FGActive;
int32 gl_IntrCnt;

//#define DEBUG_ZEP_MEMMAP

#ifdef DEBUG_ZEP_MEMMAP
   #include "zep_memmap_cnfg.h"
   extern int32 jgZEP_PRAM_TX_LP0_START_ADDR; // = ZEP_PRAM_TX_LP0_START_ADDR;
   extern int32 jgZEP_PRAM_TX_LP1_START_ADDR; // = ZEP_PRAM_TX_LP1_START_ADDR;

   extern int32 jgZEP_PRAM_RX_LP0_START_ADDR; // = ZEP_PRAM_RX_LP0_START_ADDR;
   extern int32 jgZEP_PRAM_RX_LP1_START_ADDR; // = ZEP_PRAM_RX_LP1_START_ADDR;
#endif

void MasterIntHandler(void)
{

#ifdef DEBUG_ZEP_MEMMAP
    jgZEP_PRAM_TX_LP0_START_ADDR= ZEP_PRAM_TX_LP0_START_ADDR;
    jgZEP_PRAM_TX_LP1_START_ADDR= ZEP_PRAM_TX_LP1_START_ADDR;
    jgZEP_PRAM_RX_LP0_START_ADDR= ZEP_PRAM_RX_LP0_START_ADDR;
    jgZEP_PRAM_RX_LP1_START_ADDR= ZEP_PRAM_RX_LP1_START_ADDR;
#endif

    gl_IntrCnt++;


   if (guc_PortActive == 2)    // the very first frame after LinkStart; cores not enabled yet
    {
        // this function has to be called here; otherwise it will never
        // be called due to TC task only called during QT-run frame.
        // the system starts with QT-stall frames.
        EnableCores_ForLinkStart();

      guc_PortActive = 1;


    }

    if (guc_PortActive == 1)
    {
        //If the previous foreground task has not finished, issue the real-time exception
        if(FGActive == 1)
        {
            // currently, interrutps are disabled until TC/NTC finished so this
            // we never get to this exception; however, if interrupts are erroneously enabled
            // this will keep system from crashing. Also, later when system stable, we might
            // enable interrupts before NTC.
        }
        else
        {
            FGActive = 1;
            ForegroundHandler();
            FGActive = 0;
        }
    }

} //void MasterIntHandler(void)


/*****************************************************************************
;  Prototype: void KernelInit(void)
;
;  Initialization of kernel-specific variables.
;
;  Input Arguments: none.
;
;  Output Arguments: none.
;
;  Return: none.
;
;****************************************************************************/
void KernelInit(void) {

}
#endif //TARGET_HW
#endif //ADSL_62
