/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2010 Lantiq N.A. Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Latiq DMT Technology. Proprietary and Confidential.
*
*   640 N. McCarthy Blvd. Milpitas, CA 95035 USA
*
*   nlnf.c
*
*  This file contains Tx and Rx state functions for NLNF echo measurement
*  to detect missing filters at CPE side.
*  This is done before modem handshake/activation in sleep codeswap page.
*
*-------------------------------------------------------------------------
*/
// ******************************************************************************
//   File Name: nlnf.c
//
// History
//
// 22/09/2010 Palaksha :
//    For Micro Filter Detection algorith requires Hybrid training routines. This requires these functions
//    to be present in the Sleep State Code swap page as well. For this purpose the changes are made in
//    in build scripts arc_bld\modem\make_inputs\harvardArch_biscs.cmd The Sleep Code swap page size to
//    to 12416 Bytes(earlier it was 6016 bytes)
//       and also all functions in the files source\common\shared\HybridTraining.c and in file
//    sandbox\source\HWEngine_4.5\STR_ReconfigDecim2_HPF.c are declared with prefix with C_SCOPE
//    This is needed for the build script because In case  function needs to be there on more than one swap page,
//    in order to avoid multiply-defined global labels Each function must be defined using the CSCOPE keyword
//       Grep for Feature_MicroFilter_Detection_Framework
//
// 01/10/2010 Hanyu: Added NLNF measurement state machines/functions in sleep mode page.
//            This feature is triggered by "cw cntl 0 0 0x09" similar to sleep test mode.
//            Additinally, it is triggered by SW API 3.16.5.9 or newer during modem power up
//            and can be disabled by CMV bit-15 (default "0" means enabled) of INFO 121 0.
//        Grep for XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect
//
// 05/10/2010 Palaksha/Vinjam: Added Framework to integrate hybrid training
//            modules to "SLEEP" state.
//            Grep for "XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect Integrate_HybridPGA_Algo"
// ******************************************************************************

#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "pga_set.h"
#include "dsp_op.h"
#include "snr.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "pll.h"
#include "gdata.h"
#include "frm_sync.h"
#include "tdq_init.h"
#include "fdq_init.h"
#include "ec_init.h"
#include "xrtstate.h"
#include "mtkernel.h"
#include "states.h"
#include "fifo.h"
#include "compiler.h"
#include "ec_data.h"
#include "accum32.h"
#include "noiseacc.h"
#include "RMedleyTxF.h"
#include "pn_tab.h"
#include "medley.h"
#include "rmedley_Data.h"
#include "cmv.h"
#include "string.h"
#include "TxTneSt.h"
#include "tx_ops2.h"
#include "GenMedly.h"
#include "memsetbf.h"
#include "memcopy.h"
#include "bufmisc.h"
#include "afe.h"
#include "data_alloc.h"
#include "stateini.h"
#include "vecpwr.h"
#include "diagparam_bis.h"
#include "InitTDQfilter.h"
#include "ghs.h"

#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"

// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (START)
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
#include "nlnf.h"
#include "cmv_Data.h"
#include "LL_Iof.h"
#include "memrymap.h"
// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (END)

//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect Integrate_HybridPGA_Algo (Start_End)
#include "RCReverb1RxF.h"

// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (START)
#ifndef ISDN
int32 gls_noisesum;

void NLNF_QuietTxF(void)
{
   // Transmit Quiet until Rx moves to the next Tx/Rx states
   if (gl_TxSymbolCount == 0)
   {
      // Force G.dmt Annex A for NLNF
      gl_SelectedMode = MODE_G992_1 | ANNEX_A;
      OPTNArray[OPTN_ModeControl] = (int16) OPTN_ConfigMode_G992_1_A;

      // Set link mode dependent variables, including gs_TxNumTones,
      // gs_TxFirstChannel, gs_TxLastChannel, and gs_PN_US_LEN.
      SetLinkModeDependentVariables();
#ifdef FD_ACCUM_FOR_PGA
      if (gs_RxFftLength  == 1024)
         gs_td_fd_pwr_offset  = TD_FD_PWR_DIFF_PLUS;     // 3 db
      else if (gs_RxFftLength  == 512)
         gs_td_fd_pwr_offset  = TD_FD_PWR_DIFF_BIS;      // 6 db
#endif

      #ifdef DANUBE_AFE
      // reset Tx AFE noise shaper - to prevent spurious tones.
      WriteAfe(DANUBEA_SOFT_RESETS, 0x0008);
      #endif
      // enable IFFT and clear TxToneBuf to generate the quiet signal
      gt_TaskArray[TX_FRAME_START].TimeCriticalTask = (PtrToFunc) TxProcessTones;
      // "Enable_IFFT_Reordering" is a empty function in VR9 So,no need to call
      #ifndef ADSL_62
      AddFunctionToFifo(gp_TxLoadingFunctionFifo, Enable_IFFT_Reordering);
      #endif
      gft_IFFT_On = TRUE;
      TxToneSetUp(0, 0, 0);
   }
}

void NLNF_SyncRxF(void)
{
int32 l_delay;
int16 s_PGAMax;

     if (gl_RxSymbolCount == 1)  // Wait one frame for Tx init
     {
       //Bit14=1 indicates NLNF Started
       gt_nlnf_metrics_ibs.us_NlnfIbs |= 0x4000;
       //Reset Bit13 here for setting when NLNF is done.
       gt_nlnf_metrics_ibs.us_NlnfIbs &= 0xDFFF;
       // Initialized to 128 for NLNF to indicate Metric1/2 data are not ready.
       gt_nlnf_metrics_ibs.s_NlnfMetric1 = 0x0800; // Metric1 bits15:4 for NLNF echo
       gt_nlnf_metrics_ibs.s_NlnfMetric2 = 0x0080;

      // Report Idle to avoid SW rebooting during NLNF test
      // by cw test 7 0 0x7FD0 without SW API support.
      // Report NLNF end to SW API 3.16.5.9 or newer
      if (TESTArray[TEST_RxSubState] != CMV_TEST70_RX_NLNF_TRIGGERED)
      {
          STATArray[STAT_MacroState] = STAT_MFD;
          gt_HercADSL_STATMap_MacroState.s_Offset0 = STAT_MFD;
          gusa_HercADSL_MONIMap_Curr[0] = MONI_MFD;
      }

      // Initialize PGA
      //SetInitialPgaToMax(); // Set PGA by gs_max_pga_setting
      s_PGAMax = AFED_SetInitialPgaToMax();

      // Initialize to unity TDQ
      SetTDQtoUnity();
      AddFunctionToFifo(gp_RxLoadingFunctionFifo, LoadTDQ);
      guc_PgaTrainingState = TRAINING_IN_PROGRESS;
      AddFunctionToBkgdFifo((PtrToBkgdFunc) AFED_BgPGA);
     }
     //Initialize for RX FDQ DONE interrupt (frequency domain)
     if (gl_RxSymbolCount == 2)
     {
        //AddFunctionToFifo(gp_RxLoadingFunctionFifo, MoveToFdqDoneInt);
#ifdef ADSL_62
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, Enable_FFT);
#else
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,MoveToFdqDoneInt);
#endif
     }


     if (gl_RxSymbolCount == 3)
     {
        //AddFunctionToFifo(gp_RxLoadingFunctionFifo,
        //                  EnableFDQDoneNTC_EnableGetRxTones);
#ifdef ADSL_62
         gs_RtvSelect = FFT_OUTPUT;
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,ConfigRTVBuf0_train);
#else
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,EnableFDQDoneNTC_EnableGetRxTones);
#endif

     }

     if (guc_PgaTrainingState == TRAINING_DONE)
     {
      // set PGA when BgPGA is done on background
      AddFunctionToFifo(gp_RxLoadingFunctionFifo, AFED_SetPga);
      guc_PgaTrainingState = TRAINING_WAITING;
     }

      // Tx Test by continually sending Quiet signal by "cw test 6 0 0x6FD1"
      gs_TxSubState = TESTArray[TEST_TxSubState];

     // Wait 16 seconds or 64000 symbols for CO/DSLAM to transmit quiet at Silence state
     l_delay = 64000;
     // Wait 3000 symbols for testing to avoid SW rebooting
     // by cw test 7 0 0x7FD0 without SW API support.
     if (TESTArray[TEST_RxSubState] == CMV_TEST70_RX_NLNF_TRIGGERED)
      l_delay = 3000;
     if(gs_Set_Pause == 0x00B2) Pause(0x00B2); //debug
     if ((gl_RxSymbolCount > l_delay) &&
         (gs_TxSubState != CMV_TEST60_TX_NLNF_QUIET))
     {
     // Report Idle to avoid SW rebooting during NLNF test
     // by cw test 7 0 0x7FD0 without SW API support.
     if (TESTArray[TEST_RxSubState] == CMV_TEST70_RX_NLNF_TRIGGERED)
       STATArray[STAT_MacroState] = STAT_IdleState;

      // Move to the next NLNF Tx/Rx states
      gs_TxNextState = NLNF_REVERB_TX;
      gpF_TxStateFunc = (PtrToFunc) NLNF_ReverbTxF;

      gs_RxNextState = NLNF_HYBPGA_RX;
      gpF_RxStateFunc = (PtrToFunc) NLNF_HybPgaTrainRxF;
      if(gs_Set_Pause == 0x00B3) Pause(0x00B3); //debug

      #ifdef ADSL_62
      // Bydefault IFFT size is 256
      //
      #else
      // Enable 128-point (or 64 tones) IFFT
      ReadCoreReg(IRI_REG_IT_MISC_ADDR, &us_data);
      us_data |= IRI_IT_MISC_FFT_SIZE; // For 128-pt IFFT.
      WriteCoreReg(IRI_REG_IT_MISC_ADDR, us_data);
      #endif

      #ifdef DANUBE_AFE
      // re-enable tx shaper
      WriteAfe(DANUBEA_SOFT_RESETS, 0x0000);
      #endif
      //XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect Integrate_HybridPGA_Algo
      gft_NLNF_HybridTraining = 0;

     }
}

void NLNF_ReverbTxF(void)
{
int i;

     // Setup to transmit R-Reverb in G.dmt Annex A
     if (gl_TxSymbolCount == 0)
     {
        // TESTArray[TEST_EncoderGain] = ENCGAIN2;  // Default
        Gen_Reverb_Ref_fd(gsa_TxToneBuf, GEN_REVERB_TYPE_RT, gs_TxNumTones,
                          gs_TxFirstChannel, gs_TxLastChannel,
                          TESTArray[TEST_EncoderGain]);

         // add image signal to generate Tx echo in Rx path to train HYB/PGA
         // Mirror and conjugate tones 1-31 into tones 32-63
         for (i = gs_TxNumTones + 1; i < TX_NUM_TONES; i++)
         {
            gsa_TxToneBuf[2 * i] = gsa_TxToneBuf[2 * (TX_NUM_TONES - i)];
            gsa_TxToneBuf[2 * i + 1] = -gsa_TxToneBuf[2 * (TX_NUM_TONES - i) + 1];  // Conjugate.
         }
     }

   // Transmit R-Reverb until Rx moves to the next Tx/Rx states
}

void NLNF_HybPgaTrainRxF(void)
{

      // Tx Test by continually sending Reverb by "cw test 6 0 0x6FD2"
      gs_TxSubState = TESTArray[TEST_TxSubState];

      //XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect Integrate_HybridPGA_Algo (Start)
      RCReverb1RxF();  //contains the state machine for Hybrid training in DMT mode
    //XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect Integrate_HybridPGA_Algo (End)

    if((gft_NLNF_HybridTraining == 1) &&
      (gs_TxSubState != CMV_TEST60_TX_NLNF_REVERB_64TONES))
    {
        // Set NLNF Hybrid IB of INFO 121 0 or us_NlnfIbs LSB[1:0]
        if ((gs_LoadHybIndex >= 2) && (gs_LoadHybIndex <= 18))
         gt_nlnf_metrics_ibs.us_NlnfIbs |= 0x0001; // 0b01 Short BT
        else if ((gs_LoadHybIndex >= 19) && (gs_LoadHybIndex <= 22))
         gt_nlnf_metrics_ibs.us_NlnfIbs |= 0x0002; // 0b10 ~1kft BT
        else if (gs_LoadHybIndex >= 23)
         gt_nlnf_metrics_ibs.us_NlnfIbs |= 0x0003; // 0b10 Long BT

       // Move to the next NLNF Tx/Rx states
       gs_TxNextState = NLNF_QUIET1_TX;
       gpF_TxStateFunc = (PtrToFunc) NLNF_QuietTxF;

       gs_RxNextState = NLNF_NOP_RX;
       gpF_RxStateFunc = (PtrToFunc) NLNF_NopRxF;

       // HP2 cut off frequency is 500kHz programmed during the AGC2 training
       // The below register is linked with AGC2 gain also so don't program here
       //AGC2_INPUT_AFE_SET(0x0101);    //HP2 cutoff 0.5MHz,AGC2 gain -12dB (refer page 144)

       guc_NLNF_Enable = 2; // Flag to load NLNF Rx HPF
       AddFunctionToFifo(gp_RxLoadingFunctionFifo, ReconfigDecim2_HPF);
    }
}

void NLNF_NopRxF(void)
{
     // Wait 5 frames for Tx/Rx to settle.
     if (gl_RxSymbolCount > 3)
     {
        // Initialize QLN ro NLNF echo measurement
        gs_RxFirstChannel = 40; // NLNF measurement start tone
        gs_RxLastChannel = 255; // NLNF measurement end tone

        MemSetBuffer((int16 *)(void *)gla_RxAccumBuf, 0, 0,
                      (int16) (sizeof(int32) * ((gs_RxLastChannel+1) * 2)));
        memset(gsa_CReverbRefTones, (int16) 0,
                   sizeof(int16) * ((gs_RxLastChannel+1) * 2));

      // Move to the next NLNF Rx states
      if (gs_TxState == NLNF_QUIET1_TX)
      {
       gs_RxNextState = NLNF_QLN_RX;
       gls_noisesum = 0; // initialize to zero
      }
      else
      {
       gs_RxNextState = NLNF_ECHO_RX;
       gls_noisesum = -gls_noisesum;  // initialize to subtract QLN
      }
       // Go to QLN or NLNF echo measurement state
       gpF_RxStateFunc = (PtrToFunc) NLNF_MeasureQlnRxF;
     }

}

void NLNF_MeasureQlnRxF(void)
{
int16 s_metric;

 // NLNF QLN or Echo accumulation for 512 frames
 if (gl_RxSymbolCount <= 511)
  {
    // NLNF QLN or Echo accumulation
    NoiseAcc(gla_RxAccumBuf, (int16) 0, gsa_RxToneBuf, (int16) 0,
             (int16) 0, (int16) 0, gsa_CReverbRefTones,
             (int16) gs_RxFirstChannel, (int16) gs_RxLastChannel);
  }

 // NLNF QLN or Echo accumulation for 512 frames
 if (gl_RxSymbolCount == 511)
  {
      guc_SnrCalcState = TRAINING_IN_PROGRESS;
      AddFunctionToBkgdFifo((PtrToBkgdFunc) BGNLNFPostAccum);
  }
  else if ((gl_RxSymbolCount > 511) &&
            ((guc_SnrCalcState == TRAINING_DONE) ||
           (guc_BkgdTaskState == TRAINING_DONE)))
  {
      // Move to the next NLNF Rx states
      if (gs_TxState == NLNF_QUIET1_TX)
      {
       // Calculate and report NLNF average QLN in Q8.0 dB
       // Convert to Q8.8dB and then shift to Q8.0 dB format.
       gt_nlnf_metrics_ibs.s_NlnfMetric2 = (ConvertToDB(gls_noisesum))>>8;

       gs_TxNextState = NLNF_HPAR_TX;
       gpF_TxStateFunc = (PtrToFunc) NLNF_HighParTxF;
       gs_RxNextState = NLNF_NOP1_RX;
       gpF_RxStateFunc = (PtrToFunc) NLNF_NopRxF;
      }
      else
      {
       // Calculate and report NLNF Echo = (Echo_power - QLN_power)/QLN_power
       // Convert to Q8.8dB and then shift to Q8.0 dB format.
       // Store in Q16.0 dB
       s_metric = ((ConvertToDB(gls_noisesum))>>8) - gt_nlnf_metrics_ibs.s_NlnfMetric2;
       // NLNF Metric1 should be Q8.0 dB.
       // Cap metric1 to minimum -128dB and maximum +127dB.
       if (s_metric < -128)
        s_metric = -128;
       else if (s_metric > 127)
        s_metric = 127;

       //Save metric1 and shift to use LSB3:0 for noise level and confidence IBs
       gt_nlnf_metrics_ibs.s_NlnfMetric1 = (s_metric<<4);
       // Bit3 is No Confidence IB; Bit2:0 are for noise level. Same as AR7.
       if ((s_metric == -7) || // if -10dB<metric1<-6dB
           (s_metric == -8) || //For BT loops
           (s_metric == -9) ||
           (s_metric <= -16))   // For short loops or high noise
        gt_nlnf_metrics_ibs.s_NlnfMetric1 |= 0x0008; // Bit3=1 indicates training info is needed for better decision.

         // Set noise level IB[2:1:0] based on NLNF QLN level in dB
         s_metric = gt_nlnf_metrics_ibs.s_NlnfMetric2; // QLN
         // Initialize Noise IB INFO 121 1 or s_NlnfMetric1 LSB[2:1:0]
         gt_nlnf_metrics_ibs.s_NlnfMetric1 &= 0xFFF8;
         // Initialize Noise IB INFO 121 0 or us_NlnfIbs LSB[4:3:2]
         gt_nlnf_metrics_ibs.us_NlnfIbs &= 0xFFE3;

         // Typical Noise Level IB values:
         //            6 or 7 indicate high noise, e.g. 5T1, AWG-120dBm/Hz, shorter loop<2kft, etc.
         //            3, 4 or 5 indicate noise like AWGN-140 or -130dBm/Hz, 24DSL, 24HDSL, etc.
         if ((s_metric >= 0x000A) && (s_metric <= 0x0010))
          {
           gt_nlnf_metrics_ibs.s_NlnfMetric1 |= 0x0001; // IB[2:1:0]=0b001
           gt_nlnf_metrics_ibs.us_NlnfIbs |= 0x0004; // IB[4:3:2]=0b001
          }
         else if ((s_metric >= 0x0011) && (s_metric <= 0x001C))
          {
           gt_nlnf_metrics_ibs.s_NlnfMetric1 |= 0x0002; // IB[2:1:0]=0b010
           gt_nlnf_metrics_ibs.us_NlnfIbs |= 0x0008; // IB[4:3:2]=0b010
          }
         else if ((s_metric >= 0x001D) && (s_metric <= 0x0022))
          {
           gt_nlnf_metrics_ibs.s_NlnfMetric1 |= 0x0003; // IB[2:1:0]=0b011
           gt_nlnf_metrics_ibs.us_NlnfIbs |= 0x000C; // IB[4:3:2]=0b011
          }
         else if ((s_metric >= 0x0023) && (s_metric <= 0x0026))
          {
           gt_nlnf_metrics_ibs.s_NlnfMetric1 |= 0x0004; // IB[2:1:0]=0b100
           gt_nlnf_metrics_ibs.us_NlnfIbs |= 0x0010; // IB[4:3:2]=0b100
          }
         else if ((s_metric >= 0x0027) && (s_metric <= 0x002D))
          {
           gt_nlnf_metrics_ibs.s_NlnfMetric1 |= 0x0005; // IB[2:1:0]=0b101
           gt_nlnf_metrics_ibs.us_NlnfIbs |= 0x0014; // IB[4:3:2]=0b101
          }
         else if ((s_metric >= 0x002E) && (s_metric <= 0x0036))
          {
           gt_nlnf_metrics_ibs.s_NlnfMetric1 |= 0x0006; // IB[2:1:0]=0b110
           gt_nlnf_metrics_ibs.us_NlnfIbs |= 0x0018; // IB[4:3:2]=0b110
          }
         else if (s_metric >= 0x0037)
          {
           gt_nlnf_metrics_ibs.s_NlnfMetric1 |= 0x0007; // IB[2:1:0]=0b111
           gt_nlnf_metrics_ibs.us_NlnfIbs |= 0x001C; // IB[4:3:2]=0b111
          }

         guc_NLNF_Enable = 0; //Reset since NLNF is done.
         // us_NlnfIbs Bit14:13 setting:
         // Bit14:13=0b11 indicates NLNF Done.
         //         =0b10 indicates NLNF Started.
         //         =0b01 indicates NLNF Triggered.
         //         =0b00 indicates No NLNF Event. (Default)
         gt_nlnf_metrics_ibs.us_NlnfIbs |= 0x6000;
      if(gs_Set_Pause == 0x00B7) Pause(0x00B7); //debug
      // Report Idle to avoid SW rebooting during NLNF test
      // by cw test 7 0 0x7FD0 without SW API support.
      if (TESTArray[TEST_RxSubState] != CMV_TEST70_RX_NLNF_TRIGGERED)
      {
         // Report NLNF end to SW API 3.16.5.9 or newer
         STATArray[STAT_MacroState] = STAT_MFDComplete;
         gt_HercADSL_STATMap_MacroState.s_Offset0 = STAT_MFDComplete;
         gusa_HercADSL_MONIMap_Curr[0] = MONI_MFD_COMPLETE;
      }

       // Reset background states
       guc_SnrCalcState = TRAINING_WAITING;
       guc_BkgdTaskState = TRAINING_WAITING;

       // Debug to Tx HPAR siganl: "cw test 6 0 0x6FD4"
       gs_TxSubState = TESTArray[TEST_TxSubState];
       // Default to Tx reverb siganl or "cw test 6 0 0x6FD3" as previously defined

       if ((gs_TxSubState != CMV_TEST60_TX_NLNF_REVERB_32TONES) &&
           (gs_TxSubState != CMV_TEST60_TX_NLNF_HIGH_PAR))
       {
       // For now SW API will reboot ARC every 60 seconds in "Sleep mode"
       // Wait here and Read cmv data until SW rebooting or "ACS 2"
       }
      }
  } // if ((guc_SnrCalcState == TRAINING_DONE) ||...

}

void NLNF_HighParTxF(void)
{

int i;
// TX_FFT_LENGTH = 128
const int16 s_NLNF_Signal_16dB_PAR[TX_FFT_LENGTH] =
                        {0,0,0,0,0,0,0,0,0,0,0,0,                                      // Tone #0 to 5 are not used as per standard.
                         -ENCGAIN2,ENCGAIN2,-ENCGAIN2,ENCGAIN2,-ENCGAIN2,ENCGAIN2,    // Tone #6 to 31 are transmitted as high PAR signal.
                         -ENCGAIN2,ENCGAIN2,-ENCGAIN2,ENCGAIN2,-ENCGAIN2,ENCGAIN2,
                         -ENCGAIN2,ENCGAIN2,-ENCGAIN2,ENCGAIN2,-ENCGAIN2,ENCGAIN2,
                         -ENCGAIN2,ENCGAIN2,-ENCGAIN2,ENCGAIN2,-ENCGAIN2,ENCGAIN2,
                         -ENCGAIN2,ENCGAIN2,-ENCGAIN2,ENCGAIN2,-ENCGAIN2,ENCGAIN2,
                         -ENCGAIN2,ENCGAIN2,-ENCGAIN2,ENCGAIN2,-ENCGAIN2,ENCGAIN2,
                         -ENCGAIN2,ENCGAIN2,-ENCGAIN2,ENCGAIN2,-ENCGAIN2,ENCGAIN2,
                         -ENCGAIN2,ENCGAIN2,-ENCGAIN2,ENCGAIN2,-ENCGAIN2,ENCGAIN2,
                         -ENCGAIN2,ENCGAIN2,-ENCGAIN2,ENCGAIN2,
                         0,0,0,0,0,0,0,0,0,0,0,0,                  // Tone #32 to 63 are disabled to eliminate US Tx echo in Rx band.
                         0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                         0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                         0,0,0,0,0,0,0,0,0,0,0,0} ;

      if (gl_TxSymbolCount == 0)
     {
       // Setup freq domain REVERB signal in gsa_TxToneBuf input buffer
       // gs_TxFirstChannel = 6;
       // gs_TxLastChannel = 31;
        Gen_Reverb_Ref_fd(gsa_TxToneBuf, GEN_REVERB_TYPE_RT, gs_TxNumTones,
                          gs_TxFirstChannel, gs_TxLastChannel,
                          TESTArray[TEST_EncoderGain]);

     // By default, Tx Reverb Tone from #6 to #31
     // since it's better than HPAR on Amazon-SE.
     // It can be switched to Tx HPAR siganl by "cw test 6 0 0x6FD4"
     gs_TxSubState = TESTArray[TEST_TxSubState];

     if (gs_TxSubState == CMV_TEST60_TX_NLNF_HIGH_PAR)
     {
       // Initialize IFFT input buffer to generate the periodic high PAR signal with TX_FFT_LENGTH = 128
       for (i = 0; i < TX_FFT_LENGTH; i++)
         gsa_TxToneBuf[i] = s_NLNF_Signal_16dB_PAR [i];
     }
    }
   // Transmitting the same Tx samples in the gsa_TxToneBuf for each symbol
   // until the Rx state function to move to the next Tx/Rx states.
}

void BGNLNFPostAccum(void)
{
int16 i;
int32 *la_qln = (int32 *)(void *)guca_HndshkBuf;

   // Right shift by 9 bits to average for 512 frames
   // Actual shift by 7 with "-2 Offset" factor 1/4 in calling NoiseAcc(...)
   RoundNoiseAccum(gla_RxAccumBuf, la_qln, gs_RxFirstChannel, gs_RxLastChannel, 7);

   // Exclude noise power at G.hs tones to avoid IOP issue
   la_qln[gsa_DnCarSetA43[0]] = 0;
   la_qln[gsa_DnCarSetA43[1]] = 0;
   la_qln[gsa_DnCarSetA43[2]] = 0;
   la_qln[gsa_DnCarSetB43_J43[0]] = 0;
   la_qln[gsa_DnCarSetB43_J43[1]] = 0;
   la_qln[gsa_DnCarSetB43_J43[2]] = 0;
   // Exclude noise power at C-ACTx tones to avoid IOP issue
   la_qln[44] = 0;
   la_qln[48] = 0;
   la_qln[52] = 0;
   la_qln[60] = 0;

   for (i = gs_RxFirstChannel; i <= gs_RxLastChannel; i++)
   {
      // Convert estimate NLNF QLN to dB and store in gsa_RxFineGains.
      // noise power per tone in Q8.8dB
      // expects input in Q32.0, output in Q8.8
      // gsa_RxFineGains[i] = (int16) ConvertToDB(la_qln[i]);
      // QLN power per tone in linear format. To read: cr info 25 33 223
      if (gs_TxState == NLNF_QUIET1_TX)
       gsa_RxFineGains[i] = (int16) la_qln[i];
      // noise power sum in linear format over DS band
      gls_noisesum += la_qln[i];
   }

   guc_SnrCalcState = TRAINING_DONE;

}
#endif //#ifndef ISDN
#endif //#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (END)
