/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   ovflw.c
*
*  Functions for processing hardware overflow counters
*
*-------------------------------------------------------------------------
*/

#include "typedef.h"
#include "common.h"
#include "DSLEngin.h"
#include "gdata.h"

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void IncreaseIROverFlowCounter(void)
*
*  Description:
*     This function increase the Iridia Rx overflow counter
*
*  Global Variables:
*       gus_IRI_Rx_Ovflw: contains the IRI overflow info in Rx
*       gusa_IR_Ovflw_Cnt[]: counter of the IRI overflow
*-------------------------------------------------------------------
*^^^
*/
#ifndef ADSL_62
void UpdateOverFlowCounters()
{
   int16 i;
   int16 s_CounterIndex;   // Index of a counter within the array of counters.

   int16  TxIndex[TOTAL_ST_OVERFLOW_FIELDS] = {1, 2, 7, 10};   // Bit positions of relevant Tx overflow indicators within FDF overflow register (gus_STR_Ovflw).
   int16  RxIndex[TOTAL_SR_OVERFLOW_FIELDS] = {4, 9};       // Bit positions of relevant Rx overflow indicators within FDF overflow register (gus_STR_Ovflw).

   // These are bit positions of all binary overflow indicators packed into gus_STR_Ovflw.
   // 0: Interpolator 1 overflow   (TX)
   // 1: POTSHPF overflow        (TX)
   // 2: variable gain overflow  (TX)
   // 3: Tx SRC overflow         (TX)
   // 4: Rx SRC overflow            (RX)
   // 5: Interpolator 4 overflow (TX)
   // 6: Interpolator 3 overflow (TX)
   // 7: AEC overflow            (TX)
   // 8: DECIM2HPF overflow         (RX)
   // 9: TDQ overflow               (RX)
   // 10:DEC overflow            (TX)

   //=========================
   // TX Overflow counters
   //=========================

      // Counter 0: IFFT
      // Counter 1: POTS HPF
      // Counter 2: Tx gain
      // Counter 3: AEC
      // Counter 4: DEC

   s_CounterIndex = 0;
   // Bits 1 through 7 of gus_IRI_Tx_Ovflw are overflows for each IFFT stage.  All overflows are treated the same. A total count is kept.
   if ((gus_IRI_Tx_Ovflw & 0xfe) != 0)
      // Counter 0: IFFT
      gusa_TxOverflowCnts[s_CounterIndex++]++;

   // Check overflow bits for Tx digital filtering stages.
   for (i = 0; i < TOTAL_ST_OVERFLOW_FIELDS; i++, s_CounterIndex++)
      // Counter 1: POTS HPF
      // Counter 2: Tx gain
      // Counter 3: AEC
      // Counter 4: DEC
      gusa_TxOverflowCnts[s_CounterIndex] += (gus_STR_Ovflw >> TxIndex[i]) & 0x1;

   //=========================
   // RX Overflow counters
   //=========================
      // Counter 0: Rx SRC
      // Counter 1: TDQ
      // Counter 2: FFT
      // Counter 3: FDQ
      // Counter 4: Gainscale

   s_CounterIndex = 0;

   // Check overflow bits for Rx digital filtering stages.
   for (i = 0; i < TOTAL_SR_OVERFLOW_FIELDS; i++,s_CounterIndex++)
      // Counter 0: Rx SRC
      // Counter 1: TDQ
      gusa_RxOverflowCnts[s_CounterIndex] += (gus_STR_Ovflw >> RxIndex[i]) & 0x1;

   // Counter 2: FFT
   // Bits 2 through 10 of gus_IRI_Rx_Ovflw are overflows for each FFT stage.  All overflows are treated the same. A total count is kept.
   if ((gus_IRI_Rx_Ovflw & 0x07fc) != 0)
      gusa_RxOverflowCnts[s_CounterIndex]++;
   s_CounterIndex++;

   // Counter 3: FDQ
   // Bit 1 of gus_IRI_Rx_Ovflw = FDQ overflow
   gusa_RxOverflowCnts[s_CounterIndex++] += ((gus_IRI_Rx_Ovflw & 0x2)>>1);

   // Counter 4: Gainscale
   // Bit 0 of gus_IRI_Rx_Ovflw= QAM/Gainscale overflow
   gusa_RxOverflowCnts[s_CounterIndex++] += (gus_IRI_Rx_Ovflw & 0x1);

}

#else

#define IFFT_OVERFLOW      (2)      // To match corresponding bit (Butterfly 1) in variable for HWE3.x
#define PARR_OVERFLOW      (8)      // No respective bit in HWE3.x
#define TXGS_OVERFLOW      (0)      // To match corresponding bit in variable for HWE3.x

#define FFT_OVERFLOW    (2)      // To match corresponding bit (Butterfly 1) in variable for HWE3.x
#define RXGS_OVERFLOW      (0)      // To match corresponding bit in variable for HWE3.x
#define FFMAC_OVERFLOW     (1)      // To match ~corresponding (FDQ) bit in variable for HWE3.x
#define FBMAC_OVERFLOW     (1)

void UpdateOverFlowCounters()
{
   int32 i;
   int32 s_CounterIndex;   // Index of a counter within the array of counters.

   int16  TxIndex[TOTAL_ST_OVERFLOW_FIELDS] = {0, 3, 9, 11, 14, 16};    // Bit positions of relevant Tx overflow indicators within FDF overflow register (gus_STR_Ovflw).
   int16  RxIndex[TOTAL_SR_OVERFLOW_FIELDS] = {1, 2, 4, 5, 7, 10, 12, 13, 15};         // Bit positions of relevant Rx overflow indicators within FDF overflow register (gus_STR_Ovflw).

   // These are bit positions of all binary overflow indicators packed into gus_STR_Ovflw.
//16 TX.HBFILT.OVFLOW W1C 0x0 TX HB interp overflow indicator
//15 RX.SRC.OVFLOW W1C 0x0 Rx SRC overflow indicator
//14 TX.SRC.OVFLOW W1C 0x0 Tx SRC overflow indicator
//13 RX.ADC_SHIFT_OVFLOW W1C 0x0 ADC Shift overflow indicator. Write 1 to clear.
//12 RX.DC_OFFSET_OVFLOW W1C 0x0 Rx DC Offset overflow indicator. Write 1 to clear.
//11 TX.IIR.OVFLOW W1C 0x0 Tx IIR overflow indicator. This bit becomes asserted when an overflow occurs in any of the Tx IIR biquad stages. Write 1 to clear.
//10 RX.IIR.OVFLOW W1C 0x0 Zeroes both the DEC and TDQ outputs and resets the internal state machine.
// 9 TX.INTERP.OVFLOW W1C 0x0 ADSL INTERP filter overflow indicator. Write 1 to clear.
// 7 RX.DECIM.OVFLOW W1C 0x0 ADSL DECIM filter overflow indicator. Write 1 to clear.
// 5 RX.SJ.OVFLOW W1C 0x0 DEC Summing Junction overflow indicator. Write 1 to clear.
// 4 RX.TDQ.OVFLOW W1C 0x0 TDQ overflow indicator. Write 1 to clear.
// 3 TX.WINDOW.OVFLOW W1C 0x0 Tx Window overflow indicator. Write 1 to clear.
// 2 RX.WINDOW.OVFLOW W1C 0x0 Rx Window overflow indicator. Write 1 to clear.
// 1 RX.VG.OVFLOW W1C 0x0 Rx Variable gain block overflow indicator. Write 1 to clear.
// 0 TX.VG.OVFLOW W1C 0x0 Tx Variable gain block overflow indicator.Write 1 to clear.

   s_CounterIndex = 0;

   // Check overflow bits for Tx digital filtering stages.
   for (i = 0; i < TOTAL_ST_OVERFLOW_FIELDS; i++)
      gusa_TxOverflowCnts[s_CounterIndex++] += (gus_STR_Ovflw >> TxIndex[i]) & 0x1;

   gusa_TxOverflowCnts[s_CounterIndex++] += ((gus_IRI_Tx_Ovflw >> IFFT_OVERFLOW) & 0x1);
   gusa_TxOverflowCnts[s_CounterIndex++] += ((gus_IRI_Tx_Ovflw >> TXGS_OVERFLOW) & 0x1);

   //=========================
   // RX Overflow counters
   //=========================
   s_CounterIndex = 0;

   // Check overflow bits for Rx digital filtering stages.
   for (i = 0; i < TOTAL_SR_OVERFLOW_FIELDS; i++)
      gusa_RxOverflowCnts[s_CounterIndex++] += (gus_STR_Ovflw >> RxIndex[i]) & 0x1;

   gusa_RxOverflowCnts[s_CounterIndex++] += ((gus_IRI_Rx_Ovflw >> FFT_OVERFLOW) & 0x1);
   gusa_RxOverflowCnts[s_CounterIndex++] += ((gus_IRI_Rx_Ovflw >> RXGS_OVERFLOW) & 0x1);
   gusa_RxOverflowCnts[s_CounterIndex++] += ((gus_IRI_Rx_Ovflw >> FFMAC_OVERFLOW) & 0x1);
   gusa_RxOverflowCnts[s_CounterIndex++] += ((gus_IRI_Rx_Ovflw >> FBMAC_OVERFLOW) & 0x1);
}

#undef IFFT_OVERFLOW
#undef PARR_OVERFLOW
#undef TXGS_OVERFLOW
#undef FFT_OVERFLOW
#undef RXGS_OVERFLOW
#undef FFMAC_OVERFLOW
#undef FBMAC_OVERFLOW

#endif
