/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   sleep.c
*
*  This file contains functions to allow the modem to pause at and
*  resume from Tx and Rx States and Substates.
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "pga_set.h"
#include "dsp_op.h"
#include "snr.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "pll.h"
#include "gdata.h"
#include "frm_sync.h"
#include "tdq_init.h"
#include "fdq_init.h"
#include "ec_init.h"
#include "xrtstate.h"
#include "mtkernel.h"
#include "states.h"
#include "fifo.h"
#include "compiler.h"
#include "ec_data.h"
#include "accum32.h"
#include "noiseacc.h"
#include "RMedleyTxF.h"
#include "pn_tab.h"
#include "medley.h"
#include "rmedley_Data.h"
#include "cmv.h"
#include "string.h"
#include "TxTneSt.h"
#include "tx_ops2.h"
#include "GenMedly.h"
#include "memsetbf.h"
#include "memcopy.h"
#include "bufmisc.h"
#include "afe.h"
#include "data_alloc.h"
#include "stateini.h"
#include "vecpwr.h"
#include "diagparam_bis.h"
#ifdef SPECTRUM_ANALYSIS_ON
#include "hndshk_Data.h"
#endif

#include "ghs.h"
#include "trail.h"

#include "DoubleTrainingPGAHandler.h"
#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"

// The  gft_SleepTxMedleyManualAdvance flag is for use with the Tx substate that transmits Medley.
// If this flag is set, e.g. by a WinHost script, the substate will not automatically sequence through all frames
// of the Medley sequence.  In particular it will not update the variable that indicates the position within the
// Medley sequence.  This allows a WinHost script, by updating this variable at a rate of its choosing, to repeat
// each frame of Medley as many times as desired, or to randomly choose any frames in the Medley sequence to be transmitted
// in any order.
FlagT gft_SleepTxMedleyManualAdvance = 0;

FlagT gft_ClearReferenceToneBuf = TRUE; // clear the gsa_CReverbRefTones buffer in sleep state



/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : RSleepTxF
 *
 *  Prototype:  void RSleepTxF(void)
 *
 *    Quiescent state to provide configuration control
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 * Return:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

void RSleepTxF(void)
{
   static int16 s_CurrentTxTest = -1; /* Initialized to default TxSubState */
#ifndef ISDN
   int32 l_temp;
#endif

   if (gl_TxSymbolCount == 0)
   {
      /* Set mode as configured by OPTN CMV if not already set by handshake */
      /* or T1 initialization. */
      if (gl_SelectedMode == 0)
      {
#ifdef ISDN
         if ((OPTNArray[OPTN_ModeControl] & OPTN_ConfigMode_G992_5_B) != 0)
            gl_SelectedMode = MODE_G992_5 | ANNEX_B;
         else if ((OPTNArray[OPTN_ModeControl1] & OPTN_ConfigMode_G992_5_J) != 0)
         {
            gl_SelectedMode = MODE_G992_5 | ANNEX_J;
            gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_J] = gs_AnnexBMJPSDMaskIdx;
         }
         else if ((OPTNArray[OPTN_ModeControl1] & OPTN_ConfigMode_G992_5_M) != 0)
         {
            gl_SelectedMode = MODE_G992_5 | ANNEX_M;
            gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_M] = gs_AnnexBMJPSDMaskIdx;
         }
         else if ((OPTNArray[OPTN_ModeControl] & OPTN_ConfigMode_G992_3_B) != 0)
            gl_SelectedMode = MODE_G992_3 | ANNEX_B;
         else if ((OPTNArray[OPTN_ModeControl] & OPTN_ConfigMode_G992_3_J) != 0)
         {
            gl_SelectedMode = MODE_G992_3 | ANNEX_J;
            gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_J] = gs_AnnexBMJPSDMaskIdx;
         }
         else if ((OPTNArray[OPTN_ModeControl] & OPTN_ConfigMode_G992_3_M) != 0)
         {
            gl_SelectedMode = MODE_G992_3 | ANNEX_M;
            gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_M] = gs_AnnexBMJPSDMaskIdx;
         }
         else
            gl_SelectedMode = MODE_G992_1 | ANNEX_B;
#else
         if ((OPTNArray[OPTN_ModeControl] & OPTN_ConfigMode_G992_5_A) != 0)
            gl_SelectedMode = MODE_G992_5 | ANNEX_A;
         else if ((OPTNArray[OPTN_ModeControl1] & OPTN_ConfigMode_G992_5_I) != 0)
            gl_SelectedMode = MODE_G992_5 | ANNEX_I;
         else if ((OPTNArray[OPTN_ModeControl1] & OPTN_ConfigMode_G992_5_M) != 0)
         {
            gl_SelectedMode = MODE_G992_5 | ANNEX_M;
            gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_M] = gs_AnnexBMJPSDMaskIdx;
         }
         else if ((OPTNArray[OPTN_ModeControl] & (OPTN_ConfigMode_G992_3_A | OPTN_ConfigMode_G992_3_L)) != 0)
         {
            gl_SelectedMode = MODE_G992_3 | ANNEX_AL;
            /* Increase the TX power and reduce the last tone according to the */
            /* specifications for the particular Annex L mask. */
            l_temp = 16384;
            if ((OPTNArray[OPTN_AnnexControl] & OPTN_G992_3_AnnexA_PreferredModeMask) == OPTN_G992_3_AnnexA_PreferredModeL1)
            {
               /* Annex L Mask 1. */
               gs_TxLastChannel = 24;
               l_temp = 19698;
            }
            else if ((OPTNArray[OPTN_AnnexControl] & OPTN_G992_3_AnnexA_PreferredModeMask) == OPTN_G992_3_AnnexA_PreferredModeL2)
            {
               /* Annex L Mask 2. */
               gs_TxLastChannel = 14;
               l_temp = 29473;
            }
            gus_TxSineGain = (int16)(((int32)gus_TxGain_NoCutBack * l_temp) >> 14);
            AddFunctionToFifo(gp_TxLoadingFunctionFifo,LoadTxSineGain);
         }
         else if ((OPTNArray[OPTN_ModeControl] & OPTN_ConfigMode_G992_3_I) != 0)
            gl_SelectedMode = MODE_G992_3 | ANNEX_I;
         else if ((OPTNArray[OPTN_ModeControl] & OPTN_ConfigMode_G992_3_M) != 0)
         {
            gl_SelectedMode = MODE_G992_3 | ANNEX_M;
            gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_M] = gs_AnnexBMJPSDMaskIdx;
         }
         else
            gl_SelectedMode = MODE_G992_1 | ANNEX_A;
#endif
      }
      /* Set link mode dependent variables, including gs_TxNumTones, */
      /* gs_TxFirstChannel, gs_TxLastChannel, and gs_PN_US_LEN. */
      SetLinkModeDependentVariables();

#ifdef DANUBE
#ifdef TARGET_HW
   /********* cmv to allow for Analog loopback in the DAC ******************************/
   if (TESTArray[TEST_MODE_LOOPBACK] & TEST_ANALOG_LOOPBACK)  // Set 1 to TEST 30.
      WriteAfe(DANUBEA_LPBK, DAC_LOOP_BIT);        //  >> bit 0x200 in reg 0x40.
   /************************************************************************************/
#endif
#endif
   }

   switch (gs_TxSubState) {

   case -1: /* Default substate */

      gs_TxSubStateCnt = 0;
      break;

   case 0: /* Turn off transmitter */

      gt_TaskArray[TX_FRAME_START].TimeCriticalTask = (PtrToFunc)TxProcessTones;
      AddFunctionToFifo(gp_TxLoadingFunctionFifo,Enable_IFFT_Reordering);
      gft_IFFT_On = TRUE;
      TxToneSetUp(0,0,0);
      gs_TxSubState = -1;
      break;

   case 1: /* Send REVERB */
      /* default TESTArray[Test_EncoderGain] = ENCGAIN2 */
#if defined(ADSL_62) && defined(ISDN)
      gft_TxImages  =1;
#endif //ADSL_62
      Gen_Reverb_Ref_fd(gsa_TxToneBuf, GEN_REVERB_TYPE_RT, gs_TxNumTones, gs_TxFirstChannel, gs_TxLastChannel, TESTArray[TEST_EncoderGain]);
      gs_TxSubState = -1;
      break;

   case 2: /* Send SEGUE */

      /* default TESTArray[Test_EncoderGain]  = ENCGAIN2 */
#if defined(ADSL_62) && defined(ISDN)
      gft_TxImages  =1;
#endif //ADSL_62
      Gen_Reverb_Ref_fd(gsa_TxToneBuf, GEN_REVERB_TYPE_RT, gs_TxNumTones, gs_TxFirstChannel, gs_TxLastChannel, (int16) (-TESTArray[TEST_EncoderGain]) );
      gs_TxSubState = -1;
      break;

   case 3: /* Send MEDLEY */

      if (gs_TxSubStateCnt++ == 0)
      {
#if defined(ADSL_62) && defined(ISDN)
         gft_TxImages  =1;
#endif //ADSL_62
         /* Unpack the PN sequence for upstream MEDLEY. */
         UnpackPN(gsa_unpk_PN_US, (int16)(gs_PN_US_LEN + gs_PN_US_Step), gusa_PN_US_Tab, TESTArray[TEST_EncoderGain]);

         if (gft_SleepTxMedleyManualAdvance == 0)
            gs_TxFirstPNbit = 0;
      }

      /* Generate MEDLEY signal. */
      GenerateMedley(gsa_unpk_PN_US,gsa_TxToneBuf,gs_TxFirstPNbit,(int16)gs_PN_US_LEN,(int16)(gs_TxNumTones<<1));
      /* Clear unused frequencies. */
      MemSetBuffer(gsa_TxToneBuf, 0, 0, (int16)(sizeof(int16)*(2*gs_TxFirstChannel)));
      if (gs_TxLastChannel < gs_TxNumTones)
         MemSetBuffer(gsa_TxToneBuf, (int16)(2*(gs_TxLastChannel+1)), 0, (int16)(sizeof(int16)*2*(gs_TxNumTones - gs_TxLastChannel - 1)));

      /* Update offset to first unpacked bit. */
      if (gft_SleepTxMedleyManualAdvance == 0)
      {
         // Normal mode. Advance to next frame of Medley.  For manual-advance mode, a WinHost script
         // would update gs_TxFirstPNBit manually.
         gs_TxFirstPNbit += gs_PN_US_Step;
      }
      if (gs_TxFirstPNbit >= gs_PN_US_LEN)
      {
         gs_TxFirstPNbit -= gs_PN_US_LEN;
      }
      break;

      case 4: /* MTPR test */

         /* default  TESTArray[Test_EncoderGain]  = ENCGAIN2 */
         Gen_Reverb_Ref_fd(gsa_TxToneBuf, GEN_REVERB_TYPE_RT, gs_TxNumTones, gs_TxFirstChannel, gs_TxLastChannel, TESTArray[TEST_EncoderGain] );

         /* clear Tone */
         MemSetBuffer(gsa_TxToneBuf, (int16)(2*TESTArray[TEST_TxTestTone]), 0, 2*sizeof(int16));

         /* test different tones -- do not reset TxSubState to default*/
      break;

      case 5: /* Send-a-tone test */

      /* default TESTArray[Test_EncoderGain]  = ENCGAIN2 */
      TxToneSetUp(TESTArray[TEST_TxTestTone], TESTArray[TEST_EncoderGain] , 0);
      /* do not return to default TxSubState  */
      break;



      case 6: /* Send two frequency bands of REVERB, no matter disjoint or not. */
      /* default TESTArray[Test_EncoderGain] = ENCGAIN2 */
         Gen_Reverb_Two_Disjoint_Bands(gsa_TxToneBuf, GEN_REVERB_TYPE_RT, gs_TxNumTones, gs_TxFirstBd_LeftChn, gs_TxFirstBd_RightChn, gs_TxSecondBd_LeftChn, gs_TxSecondBd_RightChn, TESTArray[TEST_EncoderGain]);
         gs_TxSubState = -1;
         break;

      case 7: /* Send ECT (Echo canceller training sequence */
         AddFunctionToFifo(gp_TxLoadingFunctionFifo,Disable_IFFT_Reordering);
         gft_IFFT_On = FALSE;
         MemCopyWords(gsa_TxToneBuf, 0, gpsa_DECTrainBuf, 0, gs_TxFftLength);
         gs_TxSubState = -1;
         break;

      case 8: // Set IFFT scalebacks
         // Updates HW IFFT scaling according to current value of gs_TxLog2FftScaling.
         AddFunctionToFifo(gp_TxLoadingFunctionFifo,SetIFFTScaling);
         gs_TxSubState = -1;
         break;

      case 9:
         /* Reset hardware overflow counter to be 0 */
         MemSetBuffer((int16*)(void *)gusa_TxOverflowCnts, 0, 0, NUM_TX_OVFLOW_CNTRS*sizeof(uint16));
         gs_TxSubState = -1;
         break;


   }

   GetDECAdaptationRxData();

   if (CNTLArray[0] & 0x08){
      if (s_CurrentTxTest != TESTArray[TEST_TxSubState]) {
         /* switch tests */
         gs_TxSubState = TESTArray[TEST_TxSubState];
         s_CurrentTxTest = gs_TxSubState;
         //fix to transmit the REVERB/SEGUE/MEDLEY signal from quiet mode (after QLN computation by switching off the transmitter)
         if(gs_TxSubState > 0)
         {
#ifdef DANUBE_AFE
            WriteAfe(DANUBEA_SOFT_RESETS, 0x0000);    /* enable Tx-Noise-Shaper */
#endif
         }
      }
   }

}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : RSleepRxF
 *
 *  Prototype:  void RSleepRxF(void)
 *
 *    Quiescent state to provide configuration control
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 * Return:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */


void BGProcessSignalAccum(void);
#ifdef SPECTRUM_ANALYSIS_ON
void BGProcessPSDAccum(void);
#endif

void RSleepRxF(void)
{
   static int16 s_CurrentRxTest = -1; /* Initialized to default RxSubState */

   if (OPTNArray[OPTN_DMTLinkControl] & OPTN_DiagMode_Enable) {
      gs_RxSubState = 21;
   }

   switch (gs_RxSubState) {

   case -1: /* Default substate */

      gs_RxSubStateCnt = 0;
      gsa_RxBuffer8X_0 = gpsa_CommonMemoryBlock0;
      gsa_RxBuffer8X_1 = gpsa_CommonMemoryBlock1;
      gla_RxAccumBuf = (int32 *)(void *)gsa_RxBuffer8X_0;
      gsa_RxRepFrameAlignBuf = (int16 *) gsa_RxBuffer8X_0;

      // XDSLRTFW-1855 (Start)
      // This code is introduced here to make sure that the SubState is changed
      // only after ensuring the current TEST has completed its execution.
      // This is just an additional check.
      if (s_CurrentRxTest != TESTArray[TEST_RxSubState])
      {
         /* switch tests */
         gs_RxSubState = TESTArray[TEST_RxSubState];
         s_CurrentRxTest = gs_RxSubState;
      }
      // XDSLRTFW-1855 (End)

      break;

   case 0: /* Initialize for RX FDQ DONE interrupt (frequency domain) */

      gs_RxSubStateCnt++;

      if(gs_RxSubStateCnt == 1) {
#ifdef ADSL_62
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, Enable_FFT);
#else
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,MoveToFdqDoneInt);
#endif
      }

      if(gs_RxSubStateCnt == 2) {
#ifdef ADSL_62
         gs_RtvSelect = FFT_OUTPUT;
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,ConfigRTVBuf0_train);
#else
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,EnableFDQDoneNTC_EnableGetRxTones);
#endif
         gs_RxSubStateCnt =0;
         gs_RxSubState = -1;
      }
      break;

   case 1: /* Initialize for RX FRAME START interrupt (time domain) */

      gs_RxSubStateCnt++;

      if(gs_RxSubStateCnt == 1)
#ifdef ADSL_62
            gs_RtvSelect = FFT_OUTPUT;
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,ConfigRTVBuf0_train);
#else
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,MoveToFrameStartInt);
#endif


      if(gs_RxSubStateCnt == 2)
      {
#ifdef ADSL_62
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, Disable_FFT);
#else
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,DisableFDQDoneNTC_DisableGetRxTones);
#endif
         gs_RxSubState = -1;
      }
      break;

   case 2: /* Disable FDQ */

      AddFunctionToFifo(gp_RxLoadingFunctionFifo,DisableFDQ);
      gs_RxSubState = -1;
      break;

   case 3: /* Enable FDQ */

      AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadFDQ);
      gs_RxSubState = -1;
      break;

   case 4: /* Disable TDQ */

      AddFunctionToFifo(gp_RxLoadingFunctionFifo,UnityTDQ);
      gs_RxSubState = -1;
      break;

   case 5: /* Enable TDQ */

      AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadTDQ);
      gs_RxSubState = -1;
      break;

   case 6: /* Disable DEC */

      AddFunctionToFifo(gp_RxLoadingFunctionFifo,ClearDEC);
      gs_RxSubState = -1;
      break;

   case 7: /* Enable DEC */

      gft_ReorderDEC = TRUE;
      MemSetBuffer((int16 *)(void *)(gla_RxAccumBuf), 0, 0, (int16)(sizeof(int32)*gs_RxSamplesPerFrame));
      ReorderDEC((int16 *)(void *)gla_RxAccumBuf);
      AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadDEC);
      gs_RxSubState = -1;
      break;

   case 8: /* Disable AEC */

      AddFunctionToFifo(gp_RxLoadingFunctionFifo,ClearAEC);
      gs_RxSubState = -1;
      break;

   case 9: /* Enable AEC */

      AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadAEC);
      gs_RxSubState = -1;
      break;

   case 10: /* Perform frame alignment (using gus_syncoffset) */

      // Queue AdjustAlignmentForward() loading function.
      FrameAlign();
      AddFunctionToFifo(gp_RxLoadingFunctionFifo,ResetRxAlign);
      gs_RxSubState = -1;
      break;

   case 11: /* Calculate and Set PGA  */
      if (gs_RxSubStateCnt == 0) {
         gs_PGA_required = TESTArray[TEST_PGA_required]; /* Q8.8 format */
         guc_PgaTrainingState = TRAINING_IN_PROGRESS;
            AFED_BgPGA();
      }
      if (guc_PgaTrainingState == TRAINING_DONE) {
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_SetPga);
         gs_RxSubState = -1;
      }
      gs_RxSubStateCnt++;
      break;



   case 12: /* Capture Rx time/frequency domain samples from gs_RxToneBuf  */

      /* select RX FDQ DONE (resp. RX FRAME START) interrupt for
         freq (resp. time) domain samples */
         MemCopyWords(gsa_RxBuffer8X_1, 0, gsa_RxToneBuf, 0, gs_RxSamplesPerFrame);
         gs_RxSubState = -1;
      break;

   case 13: /* Average (time-domain) received signal over # frames */

      /* 2^gs_rx_framecnt corresponds to # frames to be averaged */
      /* int16 output array is stored in gla_RxAccumBuf */
      if (gs_RxSubStateCnt == 0)
      {
         MemSetBuffer((int16 *)(void *)(gla_RxAccumBuf),0,0,(int16)(sizeof(int32)*(gs_RxSamplesPerFrame<<1)));
      }
      else if (gs_RxSubStateCnt <= (1<<gs_rx_framecnt)) /* accumulate # frames */
      {
         Accum16to32(gla_RxAccumBuf, 0, gsa_RxToneBuf, 0, gs_RxSamplesPerFrame);
      }
      else /* average over # frames */
      {
         guc_SnrCalcState = TRAINING_IN_PROGRESS;
         AddFunctionToBkgdFifo((PtrToBkgdFunc)BGProcessSignalAccum);
         gs_RxSubState = 130;
      }
      gs_RxSubStateCnt++;
      break;

   case 130:
      if ( (guc_SnrCalcState == TRAINING_DONE) || (guc_BkgdTaskState == TRAINING_DONE) ) {
         gs_RxSubState = -1;
         TESTArray[TEST_RxSubState] = gs_RxSubState;  //Added to convey the process done information through CMV
      }
      break;



#ifdef SPECTRUM_ANALYSIS_ON
   case 14: /* Estimates spectrum by averaging frequency-domain frames */

      gs_RxSubStateCnt++;
      if (gs_RxSubStateCnt <= (1<<gs_log2_NumFramesAvg_SpectrumEst)) {
         if (gs_RxSubStateCnt == 1) {
            MemSetBuffer((int16*)(void *)(gla_RxAccumBuf), 0, 0, (int16)(sizeof(int32)*(gs_RxNumTones*2)));
            if(gft_ClearReferenceToneBuf == TRUE)
               memset(gsa_CReverbRefTones, (int16)0, sizeof(int16)*(gs_RxNumTones*2));

         }
         NoiseAcc(gla_RxAccumBuf, (int16)0, gsa_RxToneBuf, (int16)0, (int16)0, (int16)0, gsa_CReverbRefTones, (int16)0, gs_RxNumTones-1);
      }
      else {
         guc_SnrCalcState = TRAINING_IN_PROGRESS;
         AddFunctionToBkgdFifo((PtrToBkgdFunc)BGProcessPSDAccum);
         gs_RxSubState = 130;
      }
      break;
#endif

/*

*/

   case 15: // Set FFT scalebacks
      // Updates HW FFT scaling according to current value of gs_RxLog2FftScaling.

      AddFunctionToFifo(gp_RxLoadingFunctionFifo,SetFFTScaling);
      gs_RxSubState = -1;

      break;

   case 16: /* Load Unity DEC */

      AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadUnityDEC);
      gs_RxSubState = -1;
      break;

   case 17: /* Clear Rx Overflow counters */

      /* Reset hardware overflow counter to be 0 */
      MemSetBuffer((int16*)(void *)gusa_RxOverflowCnts, 0, 0, NUM_RX_OVFLOW_CNTRS*sizeof(uint16));
      gs_RxSubState = -1;
      break;

   case 18: /* Enable DEC Capture */

      if(gs_RxSubStateCnt == 0) {
         //guc_DECRxCaptureFlag = ACTIVE;
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,ActivateDECAdaptationRxCapture);
      }
      else if(gs_RxSubStateCnt == 1) {
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,SupressDECAdaptationRxCapture);
         gs_RxSubStateCnt =0;
         gs_RxSubState = -1;
      }
      gs_RxSubStateCnt++;
      break;

   case 19: /* Capture time/frequency vector power */

      gl_Pa = VectorPower(gsa_RxToneBuf, 0, gs_RxSamplesPerFrame, gs_Log2RxSamplesPerFrame);
      gs_RxSubState = -1;
      break;



      case 21: /* Compute Hlin function in background from accumulated frame */

         guc_BkgdTaskState = TRAINING_IN_PROGRESS;
//       AddFunctionToBkgdFifo((PtrToBkgdFunc)ComputeHlin);
         OPTNArray[OPTN_DMTLinkControl] = 0;
         STATArray[STAT_MacroState] = STAT_IdleState;
         gs_RxSubState = 130;
         break;

        case 22:

        guc_DoublePgaHandlerState = PGA_INIT;
        gft_EnableDoublePGATrain = TRUE;
        gs_RxSubState = 220;
        break;
    case 220 :
        //Added the functional call for Double  Training in PGA Handler ( Compute AGC1 + AGC2 )
        if(guc_DoublePgaHandlerState != PGA_DOUBLE_TRN_DONE)
        {
            PGADoubleTraining();
        }
        else
        {
            gs_RxSubState = -1;
        }
        break;
   }
}


/*********************************************************************************/
/* BG function that performs processing for substate 13 (frequency/time domain   */
/* signal average).                                                              */
/*********************************************************************************/
void BGProcessSignalAccum(void)
{
   /* Shift, round, and store signal accumulation back to the gla_RxAccumBuf. */
   RightShiftAndRound32to16((int16 *)(void *)(gla_RxAccumBuf), 0, gla_RxAccumBuf, 0,
      gs_RxSamplesPerFrame, gs_rx_framecnt);

   guc_SnrCalcState = TRAINING_DONE;
}


#ifdef SPECTRUM_ANALYSIS_ON
/*********************************************************************************/
/* BG function that performs processing for substate 14 (signal PSD estimation). */
/*********************************************************************************/
void BGProcessPSDAccum(void)
{
   int16 i;
   int32 *la_Spectrum = (int32 *)(void *)guca_HndshkBuf;

   /* -2 Offsets factor 1/4 in calling NoiseAcc(...) */
   RoundNoiseAccum(gla_RxAccumBuf, la_Spectrum, 0, gs_RxNumTones-1, gs_log2_NumFramesAvg_SpectrumEst-2);

   /* Convert estimate to dB and store in gsa_RxFineGains. */
   for (i = 0; i < gs_RxNumTones; i++)
   {
      gsa_RxFineGains[i] = ConvertToDB(la_Spectrum[i]);
   }

   guc_SnrCalcState = TRAINING_DONE;
}
#endif



