/**COPYRIGHT*****************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
    Copyright C 2016 Intel Corporation
    Copyright (C) 2015-2016: Lantiq Beteiligungs-GmbH & Co. KG
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *-------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   statein1.c
 *
 *   Functions for initializing the state machine.
 *
 *-------------------------------------------------------------------------
 */
/*
*-------------------------------------------------------------------------
*
*-------------------------------------------------------------------------
*/
// ******************************************************************
// statein1.c
//
// History
//
// 16/04/2010 Nihar: Increase DS performance against Vinax in DTAG lab
//                    DTAG-lab shows higher WhiteNoise level => use -130dBm/Hz instead of
//                    -140dBm/Hz for White Noise detection
//                    Grep for IOP_DS_ALL_VINAX_SetWhiteNoiseLevelToM130dBmHz
//
// 19/04/2010 Nihar: For debugging purposes it's very helpfull to have information
//            about the previous exception state/code available. So, put previous
//            Exc.Code/State into persistent memory and map it to CMVs
//            cr STAT 22 0 -> Prev. Exception State
//            cr STAT 23 0 -> Prev. Exception Code
//            Grep for Feature_ALL_ALL_ALL_PrevExceptionsCMV
//
// 31/05/2010 Nihar :Send "B43" & "J43" activation tones for "AnnexB + AnnexJ" multi mode
//            Grep for Perf_US_ALL_MultiTone_Activation
//
// 31/05/2010 Nihar: In Annex J, if mask upto tone 60 or less is selected then DS start tone
//             changed to 61. This feature enabled (default) by CMV info 103 1 bit 12.
//             Grep for Feature_US_BisPlus_ALL_StartDSFromTone61AnxJ
//
// 16/07/2010 Sriram/Bhadra  : Added new code pointers to suppport Amendment 3 of G.994.1
//            standard for Optional US interleaver depth
//         Grep for XDSLRTFW-148:SMS00918205 SMS00918215 Feature_AB_ALL_BisPlus_ALL_Optional_US_interlever_depth
//
// 31/7/2010 Nihar: It was seen at FT that the CNXT D57 Dslam was configured to INP = 2.0 but it was only sending
//             this INP in the CL message and not the MS message. Since we use the MS message,
//              we were always training at INP=0.
//              By default, this fix is enabled. To disable it reset bit 8 of INFO 103 1
//              Grep for IOP_DS_BisPlus_CNXT_CopyINPFromCLToBitloading
//
// 31/7/2010 Nihar: Modification done to reduce US PCB requested by CO by 3 dB in case of CNXT CO & ADSL2+ mode.
//           The fix enabled/Disabled through bit #8(0x100) of cmv INFO 103 0. By Default Disabled
//          Grep for PERF_US_BisPlus_CNXT_Reduce_US_PCB_By_3_dB
//
// 05/08/2010 Nihar : Disable the Erasure decoding Reporting by default.Clear the structure "gt_ErasureDecoding_Reprt"
//         Grep for Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting
//
// 26/07/10  Bhadra/Palaksha Murthy  Added fix against CNXT Cos.Link drops are
//           observed with some old CNXT DSLAMS in ADSL2/+ mode,if all tones are
//           loaded with 1bit(at some long loop fixed rate cases.
//          Solution is to force atleast to have one 2 bit tone.
//          Grep for "IOP_ALL_BISPLus_CNXT_1bitConstellation" to check the changes.
//
// 10/08/2010 Nihar/Bhadra: Ported back (from R3) the CNXT fix, where in if the configured min
//          INP < 1 & delay = 2ms, then force the number of checkbyte to '0'. By default,
//          this fix is enabled, but can be disabled by cw INFO 103 0 0x0080.
//          This fix gets rid of CRC/FECs on low-delay profile against CNXT,
//          but it also costs us performance. The CRCs were seen on Munich setup against E67
//          but not in Milpitas setup.
//          On disabling this fix, the previous fix wherein the min-delay is forced to 3ms
//          if the min-delay in configured = 2ms against CNXT.
//          Grep for SMS00815166 IOP_DS_BisPlus_CNXT_FramingLimitation
//
// 10/08/2010 Hanyu/Bhadra: Intialized G.hs-based C-Pilot1 detector threshold to 12dB.
//            By default, this fix is disabled. To enable it cw INFO 103 20 0x0004
//            Grep for SMS00827680 IOP_DS_CNXT_Gdmt_CPilot1Det
//
// 12/08/2010 AdeelJ/Sriram/Bhadra: To use the existing SRA code for 1 step SRA based on CMV
//           INFO 103 20 bit mask 0x0001.The SRA step size is increased
//           to maximum if this cmv is set.
//             In this file we conditionally bypass framing check for one step SRA.
//             Grep for SMS01221899 Feature_DS_All_All_EnableOneStepSRA
//
// 10/08/10 Nihar: Time period for declaring "Los due to CRC errors" is increased to 16 seconds.
//                 Reason: To pass the RFI test at AT&T
//                 Grep for "ENH_DS_ALL_ALL_LOS_16Sec"
//
// 10/08/2010 Nihar: Tramsmit Reverb 1 & 2 from tone 2, against all COs & in all modes. This helps in improving
//                   the US performance. Grep for PERF_US_ALL_ALL_TxReverbFromTone-2
//
// 10/08/2010 Nihar: Reset the INFO 103 structure (gt_INFX_CMV) to zero before link-start
//              Grep for BugFix_ALL_ALL_ALL_ResetINFO103Structure
//
// 12/08/2010 Nihar : Added a flag to indicate the Vender ID change in
//                    T1.413 mode against old IFX DSLAMs like AFC 6+6H.
//                    Switch the vender ID in T1413 mode to TI VID
//                    if the CO is Siemens. This improves US rates in long loops.
//                    Grep for IOP_A_US_T1413_OldIFX_SwitchToTIVID
//
// 17/08/2010 AdeelJ/Palaksha/Bhadra: IOP fix for SRA Upshift and Downshift not achieving the Target Margin.
//               Removed min margin Check so that SRA process Makes modem reach target margin.
//               Grep for SMS00966298 SMS00951973 IOP_DS_BISPlus_ALL_SRATargetMarginFix
//
// 17/08/2010 AdeelJ/Palaksha/Bhadra: initialized global flags for SRA process to zero.
//            Grep for Feature_AB_DS_BISPlus_ALL_IncreaseAccuracySRAStep
//
// 19/08/2010 AdeelJ/Palaksh/Bhadra: Fix for ADSL2+ low US rates against Intracom CNXT DSLAM.
//               Bit#13(Mask0x2000) of  CMV INFO 103 20 used to enable/Disable US performance enhancement fix.
//                 By Default Fix will be OFF(Bit will ZERO)
//               initialize interop cmv bit to zero. We only want this bit enabled with the operator Intracom (Greece).
//               Grep for IOP_US_BISPlus_CNXT_USRateImprovement
//
// 06/10/2010 Bhadra/AdeelJ: Modified Reverb and MEDLEY SNR calculation so that it does not discard
//             REIN affected frames if a cmv info 103 23: bitmask 0x0020 is set. i.e. the functionality is
//             reverted to the older one without REIN detection. This will cause lower
//             data rates in presence of REIN, but still higher than specified in TR-100
//             REIN noise tests. The positive aspect is that we dont have to worry about
//             maintaining margin in Showtime. This cmv is specific for FT like scenarios where
//             the DS margin was going low to an unacceptable level in presence of REIN noise.
//             In this file the bitmask for cmv info 103 23:0x0020 is defined.
//        Grep for SMS01501984 SMS01294435 Feature_DS_BisPlus_ALL_DisableTrainingREINDetection
//
// 06/10/2010 Bhadra:   Add   0.2dB more DS margin to pass margin verification tests at FT based on
//                      bit 7 of CMV INFO 103 1 ie(0x0080). By default this CMV is disabled.
//                      Grep for "PERF_US_ALLannexA_New_FTspeciffic "
//
// 09/02/2011 Sriram: Use the special TSSI set from SMS00910375 in the range of
//            2100m to 4200m to improve the US rates against CNXT DSLAMs with FW
//            version of 0x10.
//            This feature is controlled by CMV INFO 103 26 0x0002
//            It's enabled by default.
//            Grep for ADSLRTFW-1344 IOP_A_US_Plus_CNXT_MidloopRateImprove
//
// 22/03/2011 Vinjam: Added "ARX208" support through DSL CMV.
//            Initializations of "DSL 11 0" & "DSL 11 1".
//            Grep for XDSLRTFW-278: Feature_AB_ALL_ALL_ARX208_Support_DSL_CMV
//
// 26/08/2011 Sriram Shastry : Add support for PTM transfer mode (in addition to ATM mode which is normally used in ADSL).
// This includes support in G.HS to indicate PTM support and evaluate CO response regarding possible PTM support
// Interface towards PPE engine -> Exchange of data-> reading of TC status counters from PPE engine and forwarding them to the
// related CMVs such that API can read them
// This feature is contolled via
// cnfg 0 0 2   // 1 : PTM 2: ATM 3: PTM+ATM
// cnfg 2 0 2   // 1 : PTM 2: ATM 3: PTM+ATM
// Default : ATM mode
// Grep for XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping
//
// 24/06/2011 Kannan: Noise margin separation changes for BT loops, Added 2dB NMSA for BT >= 700ft.
//                    These changes are taken from Danube.
//                   Grep for XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA
//
//
// 09/08/2011 Vinjam/SriRam: Integrated code which finds "OOS" anamoly by reading the PPE register.
//                           Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//                           Grep for Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping
//
// 23/8/2011 Vinjam: Renamed "gl_LOS_detect_power" to "gl_AvgPilotPow".
//           renamed "gs_LOS_sframe_cnt" to "gs_LosDefect_state_cnt".
//           Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//
// 18/04/2011 Sriram: Use the special TSSI set to improve the US rates against CNXT DSLAMs with FW version of 0x10.
//            This feature is controlled by CMV INFO 103 26 0x0002
//            It's enabled by default.
//            Grep for XDSLRTFW-238 IOP_A_US_Plus_CNXT_MidloopRateImprove
//
// 30 Aug 2011: Vinjam: Set VR9 LD mode through a CMV
//              CMV DSL 10 Bits(4:0) are used to set the line driver for ADSL mode
//              Grep for XDSLRTFW-141: Feature_ALL_ALL_ALL_CMV_LD_Mode
//
// 30/8/2011 Vinjam: Integrated "DSL_PPE_CLOCK_CONTROL" code from VR9 VDSL2 code (544316)
//            Add PPE clock change CMV as DSL 15. Bits 0:1 are the new clock setting,
//           Bit 4 is a trigger bit that will be cleared by FW after the register write is done.
//           Grep for XDSLRTFW-315: Feature_ALL_ALL_ALL_DSL_PPE_CLOCK_CONTROL
//
// 05/09/2011 Vinjam: Added logic to detect No LIF module (or LIF module is not mounted).
//            set lindriver to 'off' (i.e. not present) if AFE LIF module detection has found out that no hybrid module is present.
//            LD power down settings: GPIO_LD_CTL = 0x0200; GPIO_LD_DOUT = 0x0001;
//            If detected LIF module is neither "Annex-A" nor "Annex-BJ" then set "Hybrid Type" to "UnKnown".
//            Grep for XDSLRTFW-200: Feature_ALL_ALL_ALL_Detect_No_LIF_Module
//
// 23/09/2011 Kannan: Enabled CMV bit to Bypass single Lp bit reduction during
//                    Bitswap against CNXT and enabled 103 0 0x80 bit for CNXT CO's.
//                   Grep for XDSLRTFW-332 IOP_A_DS_BisPlus_CNXT_BitswapDuetoRFI
//
// 27/09/2011 Kannan: 1bit LpReduction bit initialixed for plus mode in the CMV
//                    "info 103 27" against CNXT.
//                   Grep for XDSLRTFW-332 IOP_A_DS_BisPlus_CNXT_BitswapDuetoRFI
//
// 30/09/2011 Stefan : Upsteam performance fixes from Stefan.
//                     Vinjam integrated them to Vr9 R4.3 ADSL mainline
//                     Grep for XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl
//
// 09/11/2011 ChihWen/Bhadra: The fix for "ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved":
//         1. The orginal code will start the searching (for max delta_Lp) from 2880, which will take very long time
//            to find the max delta_Lp and fail the training. The maximum allowed starting point (for max delta_Lp)
//            is set to 2000, which will take about 15384 symbols (from 12642 to 28026).
//         2. Considering the max_Lp (Lp + max_delta_Lp) and min_Lp (Lp - min_delta_Lp) before requesting SRA.
//         3. The searching for SRA will be enabled when it is BDCM CO or INFO 103 26 bitmask(0x0400) being one (it is zero by default).
//         Grep for ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved
//
// 09/11/2011 ChihWen/Bhadra:a)Enabling one-step SRA against CNXT causing causing segmented SRA message.
//       For this message CNXT CO didn't respond. Limit sra_step of 0x7fff(Segmented message of One step SRA )
//       to BRCM only. And thus don't sent segmented SRA message to others.
//         Grep for ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved
//
// 17/11/2011 Sriram/Bhadra : Enable Connexant SRA fix by default which send NSIF during Handshake. The cmv allows NSIF
//            against CNXT CO version 0x0010.
//            Grep for SMS01261659 BugFix_DS_BisPlus_CNXT_Enable_SRA
//
// 21/11/2011 Hanyu: Ported MFD code to VRx. Reset NLNF IB of training info IBs: [9:8:7:6:5]
//            This feature is triggered by "cw cntl 0 0 0x09" similar to sleep test mode.
//            Additinally, it is triggered by SW API 3.16.5.9 or newer during modem power up
//            and can be disabled by CMV bit-15 (default "0" means enabled) of INFO 121 0.
//        Grep for XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect
//
//  22/12/2011 AdeelJ/Balabath: Fix for "DS CRCs in Sparnex Long Loops at Telefonica"
//              DS CRCs observed in loop reach tests at long loops
//            In this file we check the looplength and increase the margin correction
//            in order to compensate for the loss of Data Rate incurred by increasing the
//            DS INP.
//              DS INP was increased to 1 in these cases as it was observed that the noise
//            causing CRCs has impulse like behavior.
//            This Change is protected by mode (ADSL2+) Annex (A), loop >= 2300m
//            and cmv (INFO 26 0 :0x0020)
//            In future check should be added for Sparnex Simulator
//          Grep for ADSLRTFW-1362 IOP_A_DS_Plus_ALL_TelefonicaSparnexDSCRCs
//
// 12/12/2011 Vinjam/Kannan: STAT cmv added to read the Selected Annex M/J mask in the
//              Tx direction. Integrated the code changes to VR9 R4.3 ADSL Firmware.
//               Grep for "XDSLRTFW-356 SMS00845338 Feature_ALL_US_SelectedAnxMJMask".
//
// 12/12/2011 Vinjam: CMV controls to enable/disable upstream enhanced framing feature moved to DSL 13 Bit-1 (Mask: 0x0002)
//        Grep for XDSLRTFW-322 Fix_AB_US_BisPlus_All_EnhancedFramingMovedToDSLCMVgroup
//
// 12/01/2012 Kannan: CMV initialization of INFO 103 27 0x4000 to enable
//            64pt IFFT emulation for TI & CNXT in T1413 mode.
//            Grep for PERF_US_T1413_T1&CNXT_64ptIFFT
// 25/01/2012 Kannan: No of FDQ adaptation channels increased from 32 to 48 for ADSL1 mode
//            to do the showtime SNR update faster, which will help to do the
//            bitswap faster while applying sudden RFI
//           Grep BugFix_DS_ADSL1_ALL_SuddenRFI
//
//12/01/2012: Balabath: Added CMV to trigger LPR in idication.DSL 5 0 1 will trigger this.By default
//                      this bit is set to zero.
//                Grep for XDSLRTFW-201 Feature_US_ALL_ALL_LPR
// 19/01/2012 Balabath: Add DS Attenuation bias in ADSL2p to meet Telefonica requirements
//           Grep for XDSLRTFW-387 IOP_DS_ADSL2Plus_All_DSATNBias
//
// 30/01/2012 Raghu: Add margin fudge of 1dB to increase the DS data rates to meet
//          telefonica requirements. This is controlled by CMV info 103 27 bit13(0x2000).
//          and will be enabled for CNXT /IKANOS DSLAMs for above 9kft. For code changes
//          Grep for   XDSLRTFW-383 Enh_DS_ADSL2_CNXTIKNS_DSRate
//
// 02/02/2012 Sabrina/Balabath: It's seen in the field that AR9 has quite low DS
//            rates compared to AR7 with the ABLT-D BRCM DSLAM. Looks like
//            the CO sends out a low MAXNOMATP (-3dB) in GHS. We use this
//            parameter as a constrain during bitloading. Therefore, the
//            finegains are all -2.5dB on the tones with bits loaded and
//            the DS rate is low. By checking the AR7 code, it's not using
//            this parameter at all. In order to improve the DS performance,
//            the workaround is to set his parameter to 0 against BRCM
//            in ADSL2+ mode. This feature is CMV protected.
//            info 103 26 0x010 Disabled by default
//            Grep for XDSLRTFW-406  IOP_A_DS_Plus_BRCM_Set_MAXNOMATP_ToZero
//
//   07/02/2012 Shakil: Erasaure decoding feature was turned off by default which introduced CRCs in
//            the REIN test from Telefonica Spain in ADSL 2plus profile. As a sollution we enabled
//            erasure decoding feature and also make some small modification in the logic to easily
//            understand the code.
//            Grep for XDSLRTFW-399 ENH_DS_BisPlus_All_Enable_ErasureDecoding
//
// 16/2/2012 Vinjam: Allow adjusting the target DS margin via CMV/message in ADSL mode.
//           Option to add additional DS margin (additional to what is requested as target margin by the CO).
//           This margin would be added on all tones (i.e. flat). The reported margin must be the real margin
//          (i.e. including the additional margin configured). The goal of the CMV is not margin cheating.
//          This CMV will also be helpful for debugging purposes and it will also allow to decrease the margin
//          (i.e. increase DS performance by sacrificing margin/stability) HERC CMV "OPTN 28" is used for setting deltaTARSNRMds.
//          grep for "XDSLRTFW-310 Improve_BisPlus_DS_All_AdjustTargetMarginThroughCMV" to see the code changes.
//
// 17/02/2012 Kannan: Aux Pilot SNR threshold is CMV controlled and is reduced from 16dB to
//            10dB to make it work on long 24DSL 16kft and FSAN Class B noise case at 3250m.
//            Grep for Feature_DS_ADSL1_ALL_AuxPilotMinSNR_Threshold
//
// 23/02/2012 Sriram Shastry : Disable PLL bandwidth to reduce DS CRC for 24DSL noise CPE margin verification test.It was observed that if
//      RxAvgmargin drops from 3.5 dB to 2.5 dB , we see Burst of DS CRC's  as a result Sync is Lost.
//      Grep for : Enhc_DS_ALL_ALL_ByPassPLLBWIncrease
//
// Raghu:INP = 8 REIN Test Failure against some DSLAMs only with 60pps impulse rate.
//      New procedure is uesd for choosing the tones used for Sync symbol detection in Showtime.
//    a) We avoid consecutive tones to be used for detection. We go for block interleave type of tone selection and the depth 8 tones
//      b) Try to choose tones with more than 12 bit allocation in the first iteration.  Next iteration reduce the bit allocation threshold by 2
//      Step a & b are done till number of tones needed for Reverb Segue detection is completed
//    For Code changes grep for "XDSLRTFW-374 (ADSLRTFW-1361): IOP_DS_PLUS_FR_TelefonicaOnSite_INP_REIN_Tests (start)"
//
// 21/12/2011 Raghu:Stress test (FT stress test) has a marginal fail (1.07 e-07 instead of 1.0 e-07) on the
//                      Lucent Stinger linecard A2P72-HBI.
//                      1) Increase number of frames used for SNR averaging from 512 to 2048 When the margin
//                      goes below 2dB.
//                      2) Block size used for updating SNR and FDQ are inreased from 32 to 48 to reduces the
//                      response time which got increased due to increase in the frames used for averaging.
//                      Currently this is enabled only for CNXT DSLAMS.
//                      For code changes grep for XDSLRTFW-358 Enh_DS_BisPlus_CNXT_StressTest
//
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
// 07/06/2012 Vinjam: By default, Disabled virtual noise feature in downstream direction.
//            Clear CMV DSL 0 Bit-0 (i.e. cleared Bit-0 in "gs_DSL_FeaturesControl").
//            Grep for XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise
// 01/06/2012 Shakil: Merge all FT EMC fixes from ARx platform to VR9. Important changes are
//                 --> 512 point QLN implemmentation for PLUS mode only because in VR9 platform Rx Strymon IIR runs in 2.2Mhz
//                    in BIS/DMT mode and in 4.4Mhz in PLUS mode
//                 --> Remove all Rx bypass filters with unity pass
//                 --> Since in BIS/DMT mode Rx IIR runs in half of the frequency as in ARx platform modify the detection of
//                    RFI notch filter (double the input RFI frequency) only in BIS/DMT mode
//                 --> Added CMV control to enable/disable the RFI notching and enabled by default.
//                    INFO 103 28 bitmask 0x100-> 0 Enabled(default), 1(disabled)
//                 --> Remove the code for VR9 where we reset the noisy pilot flag if more than 17 frames are disturbed at
//                    every 40 frames. This reduces the possibility of a bad DEC update for long impulse burst.
//                 --> Improve detection of corrupted Sync Symbol by adding the noisy pilot flag as well in the condition
//                 --> Merge the change from ARx platform where we update the DEC coeffs if the Average margin is more than 3dB
//      Grep for: XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES
//
//   04/06/2012 Shakil: New feature implemented where we detect REIN noise at training and change framing
//            accordingly taking erasure decoding into account to increase stability in presence of REIN
//            even if the minINP exchanged during GSK was not enough to sustain the REIN. The background
//            of this feature was a test requirement from FT EMC lab at Laneon where the minINP and maxdelay
//            configured was 2 and 16ms respectively whereas REIN in the line was 4-5 DMT symbol duration.
//            In the regular condition considering erasure we may protect maximum 3 DMT symbol REIN therefore
//            resulting huge DS CRCs and link drop. With the new feature we could dynamically detect REIN at
//            CSilent1 state during handshake and increase the INP taking erasure into account while cap the
//            delay maximum to 8 ms and achieved CRC free stable link without sacrifising too much data rate
//            since we also ignore REIN affected symbols before bitloading and medley SNR calculation.There are
//            two parts of the implmentation
//            1. Detect REIN during GSK and adapt framing  prior to bitloading at Medley. It is controlled by
//                INFO 103 28 bitmask 0x200 and disabled by default (bitmask 0x200-> 0 disabled, 1 enabled)
//            2. Ignore REIN affected symbols for bitloading: No CMV controlled. Enabled by default
//            Grep for XDSLRTFW-471 Enhance_DS_ALL_ALL_REIN_IMMUNITY_TRAINING
//
// 05/07/2012 Ram: Merged "ReTx" Segmented Bitswap Request code from ARX ADSL code base.
//   To cope with sweeping and fixed RFI, the following changes are done.
//   1. Below changes #2,#4,#5,#6 are under cmv control INFO 103 23 bitmask(0x0040). This bit is one (enabled) by default.
//   2. Modify the maximum number of bits for bitswap (gs_REDUCE_LP_DELTA_BITSWAP) from 20 to 120.
//   3. Increase Tx HDLC buffer size (MAX_TX_HDLC_MSG_SIZE, MAX_TX_HDLC_BUFFER_SIZE) from 700 to 1000.
//   4. Increase the maximum tone number (gs_MaxTonePerOvhdMsg) in one HDLC segment from 160 to 240.
//   5. Enable segmented bitswap request.
//   6. Change gs_DD_RxChannelsPerSymbol from 16 to 32 to improve SNR updating frequency.
//   7. Once marign on tones were ever dropped to below -6 dB, then bitswap is triggered when minimum margin is below 0 dB.
//      The threshold (-6dB by default) can be changed with cmv INFO 119 0.
//   8. Do not move bits to the tones whose margin were ever dropped to below -6 dB since these tones were very likely
//      to be affected by RFI before, and will be affected by RFI again. This mechanism is under cmv control
//      INFO 103 23 bitmask(0x0080). This bit is one (enabled) by default.
//   9. If bitswap is failed, checking of #7 condition will be ignored. Then bitswap will be tried again.
//   10. Include fix SMS01320806 IOP_A_BisPlus_CNXT_ImprovedBitSwap.
//   Grep for "XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest"
//
// 31/07/2012 Sriram Shastry : Allow API to write to Herc cmv CNTR for near end performance monitoring counter
// like, ecs,es,ses,los,crc & fec.
// CMV setting : DSL 13 0 bit Maks 8, Disabled by default ( 0= disabled ,1 = Enabled )
//              Grep for : XDSLRTFW-425 IOP_ALL_DS_ALL_NECNTR_CMVWrite
// 16/07/2012 Anantha: Cleaned up unused LCD NCD related code
//               grep pattern XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Trigger
//
// 23/8/2012 Vinjam: Added a CMV control (DSL 19 0 0x1) to suppress CRC/FEC counter write-back by DSLAPI.
//                   By default, DSL 19 0 Bit-0 is set to "0" (i.e. allow CRC/FEC counter write-back)
//                   Grep for XDSLRTFW-508 Fix_DS_All_All_SuppressCounterWriteFromDSLAPI
//
// 24/8/2012 Vinjam: Initialized CRC & FEC counters (global variables) to zero.
//                   Grep for XDSLRTFW-508 Fix_DS_All_All_SuppressCounterWriteFromDSLAPI
//
// 07/9/2012 Vinjam: Suppressed CRC/FEC write-back option by default (i.e. CMV DSL 19 0 0x1 is set)
//                   Renamed "CMV_TO_SUPPRESS_HercCNTRtoSOCPLAM_SWWRITEOPTION" to "CMV_TO_SUPPRESS_CRC_FEC_WriteBackOption".
//                   Grep for XDSLRTFW-508 Fix_DS_All_All_SuppressCounterWriteFromDSLAPI
//
// 07/9/2012 Vinjam: "L2 exit due to RFI" is enabled by default "SOC CMV OPTN 31 0 0x1".
//                  XDSLRTFW-444 ADSLRTFW-1455 Feature_B_DS_BisPlus_ALL_L2Exit
//
// 17/09/2102 Ram: ReTx has been disabled by default (to be in sync with Message Spec)
//                 Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx_CMV_CNFG_80_INFO_229"
//
// 21/11/2012 Kannan: Read hybrid type from the port mode control structure offset 9 (bits b4 to b2)
//                    and set gus_HybridType accordingly. Port mode control structure will be
//                    initialized by the MEI driver.
//                    Grep for: "XDSLRTFW-541: Platform_VRX318"
//
// 24/12/2012 Vinjam: Modified default value of "CMV STAT 24" (reporting selected J/M Tx Mask) as per VRx Message Specifications (1.9)
//                    Grep for XDSLRTFW-356 SMS00845338 Feature_ALL_US_SelectedAnxMJMask
//
// 24/12/2012 ChihWen/Vinjam: Integration of R3.5 dying Gasp code changes to R5.2.
//            Global variables initializations moved from definition place to initGlobalVraiable( ).
//            Overwrite one time the Tx IB FIFO with LPR indication when dying gasp event is happening (GPIO pin 15), so that the LPR will be indicated
//           in the next US OHC frame. The reason for doing so was that there could be one OHC frame delay between the dying gasp event and
//           the time when Tx IB FIFO was empty. This delay would cause one OHC frame later for indicating LPR.
//             Grep for XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR
//
// 24/12/2012: Re-Initialization of global variable "gusa_CRC_count[]" at restart
//           Grep for XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC
//
// 26/12/2012 Stefan/Vinjam: Integrated R3.5 fix to R5.2 Mainline. Use Annex-B filters in oISDN binary.
//          Reconfigure them post-handshake again based on selected mode.
//          PSD violation in ADSL G.Hs if Annex-J mode is enabled - Jira XDSLRTFW-258
//          In Annex-B binary the configuration of the tx-path was not correct if Annex-J codepoints
//          in G.Hs were enabled. In this case the Tx-IIR filter was configured for Annex-J, but the
//          tx-interpolator for Annex-B tx signals. This was not seen in the final Annex-J or Annex-B
//          PSDs because of the reconfiguration of the tx-path after G.Hs
//          As Annex-J activation tones are currently not used in any field deployment the activation
//          tones and G.Hs filter configurations are hard-coded to Annex-B.
//          this part of the code is called only in LinkStartForTest.c
//          Also, global variable "gl_SelectedMode" is forced to "0" at restart/initialization
//          Grep for XDSLRTFW-653 XDSLRTFW-258 Bug_US_BisPlus_ALL_UseAnxBFiltForAnxJ_BeforeGHs
//
// 26/12/2012 Stefan/Vinjam: Integrated R3.5 fix to R5.2 Mainline.
//            To avoid long training times in ADSL mode and too early false mode switches to VDSL binary,
//             FW sends the intentional retrain information (using a global variable guc_Forced_Retrain) to SW/DSL API.
//            Code changes connected to Jira XDSLRTFW-248" and Jira XDSLRTFW-255.
//             Grep for XDSLRTFW-654 XDSLRTFW-248 Bug_DS_All_All_IntentionalReTrainToReduceTrainTime
//
// 08/11/2012 Anantha:1.Initialize global varibale in bitswap improvement
//               grep for XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap
// 27/12/2012 Mahesh: Initialize test array flag for L2 Lp
//                              grep for  XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [Start]
//
// 07/01/2013 Ram: Fix added for JIRA 575 - Attach "FEC uncorrectable CW count" to CMV, add support
//                 for incrementing UAS counter during training.
//                 Grep for XDSLRTFW-575: Counter Write back in ADSL mode
//
// 15/01/2013 Kannan: Initialize the exception code variables
//                 Grep for XDSLRTFW-181: VR9_VRX318_AFE_Init_Fail_Indication
//
// 16/01/2013 Ram: Fix added for JIRA 285 - Implement a 'Feature MAP' indicating the features supported by ADSL FW
//                 Added a new function 'ConfigAdslFeatureMap()' that provides info on the feature subset
//                 supported by FW. This feature map can be read out by SW using CMV 'DSL 19'
//                 (Refer Msg Spec ver 1.9 for more details on CMV)
//                 Grep for XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map
//
// 07/02/2013 Vinjam: Added support for "CMV CNFG 45" to select "G.Hs Toneset" as per VRx Msg Spec.
//            Inturn, "enale/disable" of "optional upstream interleaver depth" feature is moved to "CMV CNFG 46".
//            Grep for XDSLRTFW-699: Fix_AB_US_All_GHsToneSetSelection
// 11/02/2013 Kannan:
//          1. Orderly shutdown algo implementation and it is applicable for both
//             VR9 & VRX318.
//             Grep for "XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown"
//
// 20/02/2013 Mahesh:  Removed Ananta's bitswap enhancement changes for L2 & SRA
//
// 18/02/2013 Vinjam: Report downstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 1 [14:15]" & "CMV_RATE 1 [16:17] respectively.
//            Also, Report upstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 0 [14:15]" & "CMV_RATE 0 [16:17] respectively.
//            Modified enable/disable of Erasuredecoder logic as per VRx Msg Spec through "CMV DSL 1 0"
//            Grep for XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec
//
// 25/02/2013 Ram: Fix added for JIRA 285 - Implement a 'Feature MAP' indicating the features supported by VDSL FW
//                 Added a new function 'ConfigAdslFeatureMap()' that provides info on the feature subset
//                 supported by FW. This feature map can be read out by SW using CMV 'DSL 20'
//                 (Refer Msg Spec ver 1.9 for more details on CMV)
//                 Grep for XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map
//
// 27/03/2013 Mahesh Set proper fuse data in AFE regs BIAS1 & DAC1_MISC1 & reduce PSD by 0.5dB
//                         Grep for XDSLRTFW-785: Bug_All_All_All_PsdAfeReg
// 24/04/2013 Mahesh: Increase handshake PSD by 0.7dB
//             XDSLRTFW-912: Perf_DS_AnxA_All_GhsBoost
//
// 16/05/2013 Anantha Ramu : Added code to invoke changes corresponding to XDSLRTFW-336, when Lucent Stinger DSLAM is connected.
//                      Used CMV INFO 103 28 bit 13 to enable the changes
//                           Grep for XDSLRTFW-679 Enhance_US_BisPlus_LucentStinger_US_Rate_Improvement
//
// 12/07/2013 Vinjam / Ramalakshman : Added support to convey "VDSL_Feature_ATM_Off_Chip_Bonding" & "VDSL_Feature_ATM_On_Chip_Bonding" in VDSL Feature Map.
//                      Code changes are added in ConfigVdslFeatureMap( ).
//
// 08/04/2013 ChihWen:
//            Optimize the code for SRA, which are mainly as below.
//            1. Modify gs_MaxRateLp/gs_MinRateLp to be the max/min Lp complying to all framing constraints(including max/min net rate) when framing check is enabled(INFO 103 26 bitmask(0x400)),
//               gs_MaxRateLp/gs_MinRateLp will be the Lp with max/min net rate when framing check is not enabled.
//                  2. Combine the framing check in isValidFramingConfiguration and RShowtimeRxF_BIS. The combined framing check will refer to gs_MaxRateLp/gs_MinRateLp.
//                  3. Optimize the CMV setting related to SRA.
//                  4. Add two CMV to enable/disable the checking for min INP, and max delay when searching delta Lp in training.
//            Grep for XDSLRTFW-721 Enhance_DS_BisPlus_ALL_OptimizedSRACode
//
//
// 8/05/2013 Palaksha:Bug fix (TR100B Stress Test Failure)
//   1. Correct initialization of variable gs_TxOutBandGain = 0x0C00
//   2. Increased the DEC variable gs_DECAdaptExpfrom 6 to 10
//   3. Removed the condition for Disabling of DEC if gs_RxAvMargin < 0x0300
//   Grep for XDSLRTFW-924 IOP_DS_Perf_ALL_TR100BStressFail
//
// 14/06/2013 Naveen: Re-adjusted the DS PCB calcualtion for VRx Annex B/J
//                    The CMV CMV_INFX_DFE_IOP_FIX_DS_PCB_ENABLE is enabled
//                    We increase the DS PCB  based on loop length upto 1000m incase gft_StrongNoiseForDsPcbnoise=0
//                    For loop lengths from 1000m to 2000m, DC PCB used is 3dB
//            Grep for XDSLRTFW-754 Perf_DS_Plus_ALL_AdjDsPcb
//
//  29/06/2013 Palaksha: VR9_AnxB_HybImp
//               In Hybrid traing algorithm, END_TONE = (HYB_START_TONE + HYB_DECIM_FACTOR * HYB_DECIM_POINTS)= 64+4*110=544
//                This results in out of range buffer address access for few hybrid training related arrays
//               (guca_RxBat, gla_RxAccumBuf). This may result in wrong selection of hybrids
//         grep for VR9_AnxB_HybImp
//
// 01/07/13 Palaksha : Fix for "XDSLRTFW-783: TR067B(Section 8.1.9.1) Request downstream power cutback" failure
//                  The reason is :The bit#2(Mask 0x4) of CMV OPTN 5 0 is Set to 1(Means Excess Margin Reduction is disabled)
//                  The fix is set The bit#2(Mask 0x4) of CMV OPTN 5 0 is Set to 0(Means Excess Margin Reduction is ENABLED)
//            Grep for XDSLRTFW-783 Bug_fix_EnableExcessMarginReduction
//
// 10/12/2013 Kannan:
//                DEC adaptation was disabled through CMV "(OPTNArray[OPTN_AlgControl] & OPTN_DECAdaptDisable)"
//                and "gft_DECAdaptDisable" is linked to this CMV.
//                This causes to disable the DEC permanently.
//                So disabling of DEC in the FW is not required, it needs to be enabled to pass the temp chamber test
//                if DEC is required to be disabled, it needs to be done through CMV.
//                Note: "HERCULES_ADSL_CPE" is defined for VR9/VRX318
//                Grep for XDSLRTFW-1439
//
// 24/01/2014 Balabath :- Correction of bugs and implementation as per the ErasureDecoding implementation
//                      -Change of Default settings of DSL 1 0 CMV settings
//                      - IOP issues resolved with EBLT-C
//                      for Code Changes grep for " XDSLRTFW-1502 "
//
// 04/12/2013 Varun : Initialized the CMV to acknowledge L3 request by default
//                    Grep for  XDSLRTFW-1236
//
//12/12/2013 Varun : Changed the threshold(guc_24DSL_NOISE_THRESHOLD1) of DSL24 Noise to -108dbm/hz as 5T1 noise(close to older threshold at
//                   tones 10 to 16) was also triggering the DSL24 flag. Please refer jira for QLN capture information
//                    Grep for XDSLRTFW-1250
//
// 13/03/2014 Sriram Shastry : Increase US data rate against  BRCM CO for A.1.4.3 24 HDSL NEXT impairment_testprofile AU_RA_L_30000K
//          Grep for XDSLRTFW-1464 : Perf_US_Plus_AnxA_BRCM_USPerf24HDSLNoise
//
// 21/03/2014 Prashant : Fix for XDSLRTFW-1654 - CPE doesn't honour Min DS INP, TR105E INP test fails.
//                       Erasure decoder will be used to boost the INP (Default setting).
//                       Grep for XDSLRTFW-1654
//
//10/11/2014 Palaksha: "XDSLRTFW-1859:change default Line drive mode in ADSL to Medium"
//                     Just change the value of the following AFE Digital Registers
//                     GPIO_LD_DOUT (Address 0x 403)  = 0x5
//                     GPIO_LD_CTL    (Address   0x 405) = 0x 700
//                     This can be done by changing CMV DSL 10 0 to 0x3 (dms 0A62 0 1 3)
//                     Grep for XDSLRTFW-1859
//
// 29/09/2014 ChihWen: Workaround of ignoring MaxDsATP and decreasing 1 dB margin to pass the TR100A AWGN longer loops in Askey lab.
//            Grep for XDSLRTFW-2031 Enhc_A_DS_BisPlus_BRCM_WorkaroundForAskeyLabTesting
//
// 06/02/2015 Vinay : Added CMV DSL 0 Bit#3 (Mask:0x0008) to enable octet 2 of NPar2 of G993.2 in GHs and is enabled by default
//                    Grep for XDSLRTFW-1624
// 06/08/2014 ChihWen: Lower Tx power by 1dB in order to boost DS PSD to increase DS rate on shorter loops in ADSL1 mode against BRCM CO.
//             Grep for XDSLRTFW-1916 IOP_US_DMT_BRCM_LowerTxPower
//
// 06/08/2014 ChihWen: Enable noise margin separation against Vinax2 in the case when minINP >= 1, FB noise, and BIS mode.
//             Grep for XDSLRTFW-1951 IOP_DS_BIS_VINAX2_EnableNM
// 24/03/14 Hanyu: Ported ADSLRTFW-1419: It takes Litespan D4EP, with all ports enabled, ~60s to restart
//            if there is any retrains during training. To meet customer requirements,
//            we made following two changes.
//            1. Took out the unnecessary retrain for all non-CTLM DSLAMs during GHS.
//            2. Added CMV bit-14 of info 103 26 to control the retrain logic for
//            TIVID change with GHS0000 DSLAMs.
//            By default, this CMV is set to 1 (enabled).
//            For LiteSpan D4EP DSLAM with all ports enabled, this bit should be set
//            to 0 to shorten training time after power up.
//            Grep for XDSLRTFW-1590 IOP_A_DS_ALL_ShortenTrainingTime_AfterPowerup
//
// 27/03/14 Hanyu: Ported ADSLRTFW-1416: Added CMV bit-12 of info 103 26 to control the retrain logic for DS
//       performance tuning in TR-67 A.2/EU shor loops < 700m in SMS00822444 / XDSLRTFW-1682.
//       By default, this CMV bit is set to 1 (enabled).
//       For LiteSpan/CTLM DSLAM at AT&T lab, this CMV bit is disabled (0) to shorten training time.
//       Grep for XDSLRTFW-1592 IOP_A_DS_ADSL1_CTLM_AddCMV_TxPowerCut
//
// 31/03/2014 ChihWen: DS rate improvement against Adtran Geminax in DMT mode.
//                  To improve the DS rate against Adtran Geminax in DMT mode, the solutions are below.
//                  1. When preparing the parameters in R-MsgsRA, search the best R (>= 4) which will achieve highest K (best net rate),
//                     then set K in R-MsgsRA accordingly, but set R = 0, coding gain = 5.5 dB, and loaded tone number by the equation below.
//                      (loaded tone number) = 159 * (codeword size) - 232. This one-order equation is from (codeword size, loaded tone number)
//                     = (245,152) and (104,64). After receiving R-MsgsRA, Adtran Geminax will send C-RatesRA with proper options of R and K,
//                      in which AR9 will select the second or third option.
//                  2. Report DS LOS when pilot power < gl_PilotTone_PwrThresh/256 instead of gl_PilotTone_PwrThresh due to link drop by CO.
//            This is controlled by CMV info 103 27 bit5 0x0020 and is disabled by default.
//            1: Enabled
//            0: Disabled (Default)
//                  Grep for XDSLRTFW-1586 IOP_DS_A_GMX_DMT_LowRate
//
// 10/04/2014 Sriram Shastry: To avoid showtime link drop and long training time against ECI/Pulsecom DSLAM
//      at AT&T lab with AT&T capped US/DS lower data rates profiles, the following changes are introduced:
//      (1) US Tx powercutback by 4dB on all loops to avoid US linkdrop.
//      (2) Preferred to select pilot tone #48 and reduced the pilot power threshold
//          to avoid US/DS link drop due to polit tone corruption.
//      (3) Limited US max bits/bin to 8.
//      The above changes are protected by PLSE CO vendor ID and CMV
//      info 103 26 0x0800 with default value 0 (Disabled).
//      Enabling the CMV bit may introduce side-effects for both US and DS performance.
//      It is only recommended for AT&T profiles with the capped US/DS lower data rates
//      attached in the Jira entry.
//         Grep for ADSLRTFW-1412_XDSLRTFW-1591_IOP_A_DS_ADSL1_ECI_PLSE_LinkDrop
//
// 10/04/2014 Sriram Shastry: To reduce the training time against CNX5, the
//            following two changes are introduced.
//            1. Remove US bounds/TSSI information from long CLR.
//            2. Remove the additional long CLR which is due to the CPE
//               preferred US PSD MASK is not matched with CO in the G.hs
//               Annex L message. When this happends, CPE just takes the
//               information from CL and doesn't need to send back to CO.
//            This is protected by CMV info 103 26 0x100. The default value
//            is 0 (Disabled.)
//            Grep for ADSLRTFW-1404_XDSLRTFW-1594_IOP_A_DS_CTNW_BisPlus_ShortenGHS
//
//
// 10/04/2014 Sriram Shastry: Added the workaround requested by AT&T for their special profile
//                   on Alcatel BRCM DSLAMs (ABLT-D, ABLT-A and EBLT-K)
//                   in T1.413, G.dmt, G.lite and Annex L multimode, i.e.
//                   Multimode CPE needs to disable Annex L on short loops.
//                   This workaround is disabled by default with
//                   CMV bit7 = 0 for INFO 103 26.
//                   To enable it, set bit7 = 1 by cw INFO 103 26 0x0080.
//                   Grep for ADSLRTFW-1400_XDSLRTFW-1596_IOP_DS_BisPlus_BRCM_ATT_DisableAnxL
//
// 15/04/2014 ChiWen/Hanyu: Fine tuned US performance against CNXT DSLAMs based on ADSLRTFW-1480 and ADSLRTFW-1591 with the following changes
//  (1) Added special flat US TSSI;
//  (2) Set tone 32 to zero(gusa_US_Tssi_Value[32] = 0);
//  (3) Enabled special flat US TSSI in C-REVERB1/R-REVERB1 (might have influence over the final PGA training);
//  (4) Enabled special flat US TSSI in C-REVERB2;
//  (5) Renamed gft_USPerf_Midloop_Gspn to gft_USPerf_Gspn for all CNXT CO's;
//  (6) Above changes are applied to all CNXT CO/DSLAMs regardless of CO FW versions and controlled by CMV bit4 (MASK 0x0010) of info 103 27
//      that is ENABLED (bit4=1) by default. This is especially recommended at CenturyLink/USA. So far no side effect has been observed.
//  Grep for XDSLRTFW-1584 XDSLRTFW-1585 IOP_US_BISPlus_CNXT_USRateImprovement
//
// 30/03/2015 Sriram Shastry:Fail in TR-105i2a1 7.9 Performance Monitoring Counters during G.998.4 retransmission.
//         Grep for : XDSLRTFW-2070
//
// 12/10/2015 Vinay: Added code to support G.Fast in ADSL G.Hs session.
//            Grep for XDSLRTFW-2298
//
// 09/11/2015 Stefan: Correct parameters: guc_M130WHITE_NOISE_THRESHOLD and gs_COMB2_REFERENCE_POWER for oISDN
//          Grep for XDSLRTFW-2510 : PCB_and_QLN_optimization_oISDN
//
// 20/12/2017 Stefan Krause:  XDSLRTFW-3665 : Previous Failstate / Previous Exception Code
// - complete Failstate info is available in the following link in gt_FailStateInfo_Prev
// - gt_FailStateInfo_Prev is mapped to DSL_PREV_FAILSTATE (DSL_37)
// - the failstate history of the last 5 exceptions is mapped to DSL_PREV_EXCEPTION_CODES (DSL_38)
//     Grep for XDSLRTFW-3665
//
// 10/09/2018 Chih-Wen: XDSLRTFW-3958: Set default US tones to 29~57 to improve US rate for ISDN. This is done by setting
//            CMV_TO_FORCE_KPN_TSSI_US_BIN_START by default. So the setting for the operators, MT_HUNGARY, OTE_GREECE, and KPN, are
//            removed.
//            Grep for XDSLRTFW-3958 SetDefaultUsTones29to57_oISDN
//
// ****************************************************************************************************************

#include <stdio.h>
#include <string.h>
#include "typedef.h"
#include "common.h"
#include "rt_state.h"
#include "rt_state_bis.h"
#include "pga_set.h"
#include "ovhd_bis.h"
#include "rx_ovrhd_bis.h"
#include "trail.h"
#include "rt_tones.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "gdata_bis_diag.h"
#include "xgdata.h"
#include "pwr_ctbk.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "ghs.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "bitload_const.h"
#include "sleep.h"
#include "RTonesReqTxF.h"
#include "RSilent1TxF.h"
#include "RTone1TxF.h"
#include "RFlag1TxF.h"
#include "RHSMsgTxF.h"
#include "RFlag2TxF.h"
#include "RGalf2TxF.h"
#include "RQuietEF1TXF.h"
#include "RCTonesRxF.h"
#include "RCGalf1RxF.h"
#include "RCFlag1RxF.h"
#include "RCHSMsgRxF.h"
#include "RCFlag2RxF.h"
#include "RCGalf2RxF.h"
#include "T1413.h"
#include "RCReverb1RxF.h"
#include "RCPilot2RxF.h"
#include "RCEctRxF.h"
#include "RCPilot3Tref2RxF.h"
#include "RCPilot1RxF.h"
#include "RCQuiet2RxF.h"
#include "RCReverb2RxF.h"
#include "RQuiet3TxF.h"
#include "REctTxF.h"
#include "RQuiet2TxF.h"
#include "RSegueTxF.h"
#include "RReverb3TxF.h"
#include "RRates1TxF.h"
#include "RCrc1TxF.h"
#include "RMsgs1TxF.h"
#include "RCCrc1RxF.h"
#include "RCRates1RxF.h"
#include "RSegueRATxF.h"
#include "RReverbRATxF.h"
#include "RMedleyTxF.h"
#include "RCMedleyRxF.h"
#include "RCMedleyFRRxF.h"
#include "RRatesRATxF.h"
#include "RCrc3TxF.h"
#include "RCReverbRARxF.h"
#include "RCCrc3RxF.h"
#include "RCMsg2RxF.h"
#include "RCBGRxF.h"
#include "RReverb5TxF.h"
#include "RReverb6TxF.h"
#include "RSegue4TxF.h"
#include "RCReverb5RxF.h"
#include "RBGTxF.h"
#include "RCrc5TxF.h"
#include "showtime.h"
#include "RRecovTxF.h"
#include "RQuietFR1TxF.h"
#include "RReverbFrTxF.h"
#include "RSegueFrTxF.h"
#include "RLineProbeTxF.h"
#include "RMsgs1FrTxF.h"
#include "RCrc1FrTxF.h"
#include "RQuietFR2TxF.h"
#include "RReverbFrTx3F.h"
#include "RSegueFrTx3F.h"
#include "RSegueFr5TxF.h"
#include "RCRecovRxF.h"
#include "RCCrcFr1RxF.h"
#include "RCReverbFR1RxF.h"
#include "RCPilotFR1RxF.h"
#include "RCReverbFR2RxF.h"
#include "RCMsgFRRxF.h"
#include "RCReverbFR3RxF.h"
#include "RCPilotFR2RxF.h"
#include "RCReverbFR4RxF.h"
#include "RCEctFRRxF.h"
#include "RCReverbFR5RxF.h"
#include "RCReverbFR6RxF.h"
#include "RCReverbFR8RxF.h"
#include "preshow.h"
#include "xrtstate.h"
#include "states.h"
#include "fdq_init.h"
#include "fifo.h"
#include "mtkernel.h"
#include "pll.h"
#include "bert.h"
#include "cmv.h"
#include "ec_data.h"
#include "dec_adap_Data.h"
#include "rx_eoc.h"
#include "tx_eoc.h"
#include "rx_ib.h"
#include "tx_ib.h"
#include "tdq_init.h"
#include "mp.h"
#include "act_T1413.h"
#include "ec_init.h"
#include "aoc_ini.h"
#include "states.h"
#include "hndshk1.h"
#include "RSilent0TxF.h"
#include "RCSilent1RxF.h"
#include "hndshk2.h"
#include "RCQuietEF1RxF.h"
#include "initfifo.h"
#include "hndshk_Data.h"
#include "showtime_bis.h"
#include "spectral_shape_bis.h"

#include "trailend.h"
#include "RCComb1RxF_bis.h"
#include "RCComb2RxF_bis.h"
#include "RCComb3RxF_bis.h"
#include "RCIComb1RxF_bis.h"
#include "RCIComb2RxF_bis.h"
#include "RCMsgFmtRxF_bis.h"
#include "RCQuietRxF_bis.h"
#include "RCQuiet4RxF_bis.h"
#include "RCReverb1RxF_bis.h"
#include "RCTref1RxF_bis.h"
#include "RCReverb2RxF_bis.h"
#include "RCombTxF_bis.h"
#include "RLineProbeTxF_bis.h"
#include "RMsgFmtTxF_bis.h"
#include "RQuietTxF_bis.h"

#include "RQuiet5TxF_bis.h"
#include "RReverbTxF_bis.h"
#include "RSegueTxF_bis.h"
#include "RReverb5TxF_bis.h"
#include "RMsg1TxF_bis.h"
#include "RMedleyTxF_bis.h"
#include "RMsg2TxF_bis.h"
#include "RReverb6TxF_bis.h"
#include "RParamsTxF_bis.h"
#include "RReverb7TxF_bis.h"

#include "RCReverb3RxF_bis.h"
#include "RCReverb4RxF_bis.h"
#include "RCMsg1RxF_bis.h"
#include "RCReverb5RxF_bis.h"
#include "RCMedleyRxF_bis.h"
#include "RCExchMarkerRxF_bis.h"
#include "RCMsg2RxF_bis.h"
#include "RCReverb6RxF_bis.h"
#include "RCParamsRxF_bis.h"
#include "RCReverb7RxF_bis.h"
#include "memsetbf.h"
#include "rx_plam.h"
#include "rx_plam_bis.h"
#include "tx_plam.h"
#include "tx_plam_bis.h"
#include "diagparam_bis.h"
#include "snr.h"
#include "ovhd_bis.h"
#include "const_bis.h"
#include "version.h"
#include "InitHybridSettings.h"
#include "Ppe_memmap.h"
#include "LL_IOf.h"

#ifdef ADSL_62
#include zep_memmap_cnfg.h
#endif

#ifdef CUSTOMER_TASKS
#include "customertasks.h"
#endif

#ifndef TEST_HS_DECODE
#ifdef TARGET_HW
#include "socrates_memrymap.h"
#include "gpio.h"
#endif

#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"


// XDSLRTFW-364: Feature_DS_All_All_NLNF_TrainingInfo (START)
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
#include "nlnf.h"
#endif //#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
// XDSLRTFW-364: Feature_DS_All_All_NLNF_TrainingInfo (END)

//XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map (Start)
#include "ADSLFeatureMap.h"
#include "VDSLFeatureMap.h"
//XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map (End)

extern int16 gs_ChanDiscDetectMin;

//XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR (START)
extern FlagT gft_debug_LPR;
extern int32 gl_debug_cnt1;
extern int32 gl_debug_cnt2;
//XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR (END)

//XDSLRTFW-541: Platform_VRX318 (START)
#if defined(VRX318) || defined(VRX518)
extern PortModeControl_t gt_PortModeControl;
#endif //VRX318
//XDSLRTFW-541: Platform_VRX318 (END)

/*************************************************************************************
  ;   Prototype: void InitStateMachine(void);
  ;
  ;   Description:
  ;      This functions is used as a bridge betweem the state machine with the ShowTime
  ;      RX function.
  ;
  ;   Arguments:
  ;      none
  ;
  ;   Return Value:
  ;      none
  ;
  ;   Global Variables:
  ;      gs_TxStopState      -- (O) TX stop state
  ;      gs_RxStopState      -- (O) RX stop state
  ;      gs_TxSubState      -- (O) TX substate
  ;      gs_RxSubState      -- (O) RX substate
  ;      gs_TxDoneState      -- (O) TX done state
  ;      gs_RxDoneState      -- (O) RX done state
  ;      gs_TxStateJumpFrom   -- (O) TX jump from state
  ;      gs_RxStateJumpFrom   -- (O) RX jump from state
  ;      gs_TxStateJumpTo   -- (O) TX jump to state
  ;      gs_RxStateJumpTo   -- (O) RX jump to state
  ;      gl_TxSymbolCount   -- (O) TX symbol count
  ;      gl_RxSymbolCount   -- (O) RX symbol count
  ;      //DoState[]         -- (O) an array of state functions
  ;       gpF_TxStateFunc --     Tx state function pointer
  ;       gpF_RxStateFunc --     Rx state function pointer
  ;
  ;**************************************************************************************/
void InitStateMachine(void)
{
   /* =========================================================================================*/
   /* Initialize to SLEEP states */
   /* =========================================================================================*/

   gs_TxState = 0;
   gs_RxState = 0;

   gs_TxNextState = SLEEP_TX;
   gs_RxNextState = SLEEP_RX;

   gpF_TxStateFunc = (PtrToFunc)RSleepTxF;
   gpF_RxStateFunc = (PtrToFunc)RSleepRxF;


   /* =========================================================================================*/
   /* Initialize State Control variables   */
   /* =========================================================================================*/

   gs_TxStopState = STOP_TX;
   gs_RxStopState = STOP_RX;
   gs_TxSubState = 0;
   gs_RxSubState = 0;
   gs_TxDoneState = DONE_TX;
   gs_RxDoneState = DONE_RX;

   gs_TxStateJumpFrom = -1;
   gs_RxStateJumpFrom = -1;
   gs_RxSubStateJumpFrom = -1;

   // Tx/Rx JumpTo states are initialized to be Done State.
   // The only way to change them is by a "memory write" command in WinHost.
   gs_TxStateJumpTo = DONE_TX;
   gs_RxStateJumpTo = DONE_RX;
   gpF_TxStateJumpTo = (PtrToFunc)EmptyState;
   gpF_RxStateJumpTo = (PtrToFunc)EmptyState;

   gl_TxSymbolCount = -1;
   gl_RxSymbolCount = -1;

   gs_StartDECTraining = TRUE;

   gft_FlagPilotAccDone = FALSE;

#ifdef LEAVE_TRAIL
   for (i=0; i<MAX_STATES; i++)
      strcpy(StateName[i],"***Undefined***");

   strcpy(StateName[FAIL_TX],"FAIL_TX");
   strcpy(StateName[FAIL_RX],"FAIL_RX");
   strcpy(StateName[DONE_TX],"DONE_TX");
   strcpy(StateName[DONE_RX],"DONE_RX");
   strcpy(StateName[UNKNOWN],"UNKNOWN");

   strcpy(StateName[SLEEP_TX],"SLEEP_TX");
   strcpy(StateName[SLEEP_RX],"SLEEP_RX");

   // Entry states used for showtime-only test.
   strcpy(StateName[R_PRE_SHOWTIME_TX],"R_PRE_SHOWTIME_TX");
   strcpy(StateName[R_C_PRE_SHOWTIME_RX],"R_C_PRE_SHOWTIME_RX");

   /* ==================================================================== */
   /*  TX States  */
   /* ==================================================================== */

   /*  Handshake States */
   strcpy(StateName[R_SILENT0_TX],"R_SILENT0_TX");
   strcpy(StateName[R_TONES_REQ_TX],"R_TONES_REQ_TX");
   strcpy(StateName[R_SILENT1_TX],"R_SILENT1_TX");
   strcpy(StateName[R_TONE1_TX],"R_TONE1_TX");
   strcpy(StateName[R_FLAG1_TX],"R_FLAG1_TX");
   strcpy(StateName[R_HS_MSG_TX],"R_HS_MSG_TX");
   strcpy(StateName[R_FLAG2_TX],"R_FLAG2_TX");
   strcpy(StateName[R_GALF2_TX],"R_GALF2_TX");

   /*  Transceiver Training States */
   strcpy(StateName[R_QUIET2_TX],"R_QUIET2_TX");
   strcpy(StateName[R_REVERB1_TX],"R_REVERB1_TX");
   strcpy(StateName[R_QUIET3_TX],"R_QUIET3_TX");
   strcpy(StateName[R_ECT_TX],"R_ECT_TX");
   strcpy(StateName[R_REVERB2_TX],"R_REVERB2_TX");

   /*  Channel Analysis States */
   strcpy(StateName[R_SEGUE1_TX],"R_SEGUE1_TX");
   strcpy(StateName[R_REVERB3_TX],"R_REVERB3_TX");
   strcpy(StateName[R_SEGUE2_TX],"R_SEGUE2_TX");
   strcpy(StateName[R_RATES1_TX],"R_RATES1_TX");
   strcpy(StateName[R_CRC1_TX],"R_CRC1_TX");
   strcpy(StateName[R_MSGS1_TX],"R_MSGS1_TX");
   strcpy(StateName[R_CRC2_TX],"R_CRC2_TX");
   strcpy(StateName[R_MEDLEY_TX],"R_MEDLEY_TX");
   strcpy(StateName[R_REVERB4_TX],"R_REVERB4_TX");

   /*  Exchange States */

   strcpy(StateName[R_SEGUE3_TX],"R_SEGUE3_TX");
   strcpy(StateName[R_MSG_RA_TX],"R_MSG_RA_TX");
   strcpy(StateName[R_CRC_RA1_TX],"R_CRC_RA1_TX");
   strcpy(StateName[R_RATES_RA_TX],"R_RATES_RA_TX");
   strcpy(StateName[R_CRC_RA2_TX],"R_CRC_RA2_TX");
   strcpy(StateName[R_REVERB_RA_TX],"R_REVERB_RA_TX");
   strcpy(StateName[R_SEGUE_RA_TX],"R_SEGUE_RA_TX");
   strcpy(StateName[R_MSGS2_TX],"R_MSGS2_TX");
   strcpy(StateName[R_CRC3_TX],"R_CRC3_TX");
   strcpy(StateName[R_RATES2_TX],"R_RATES2_TX");
   strcpy(StateName[R_CRC4_TX],"R_CRC4_TX");
   strcpy(StateName[R_REVERB5_TX],"R_REVERB5_TX");
   strcpy(StateName[R_SEGUE4_TX],"R_SEGUE4_TX");
   strcpy(StateName[R_BG_TX],"R_BG_TX");
   strcpy(StateName[R_CRC5_TX],"R_CRC5_TX");
   strcpy(StateName[R_REVERB6_TX],"R_REVERB6_TX");
   strcpy(StateName[R_SEGUE5_TX],"R_SEGUE5_TX");

   /*  Showtime state */
   strcpy(StateName[R_SHOWTIME_TX],"R_SHOWTIME_TX");

   /* ==================================================================== */
   /*  RX States  */
   /* ==================================================================== */

   /*  Handshake States */
   strcpy(StateName[R_C_SILENT1_RX],"R_C_SILENT1_RX");
   strcpy(StateName[R_C_TONES_RX],"R_C_TONES_RX");
   strcpy(StateName[R_C_GALF1_RX],"R_C_GALF1_RX");
   strcpy(StateName[R_C_FLAG1_RX],"R_C_FLAG1_RX");
   strcpy(StateName[R_C_HS_MSG_RX],"R_C_HS_MSG_RX");
   strcpy(StateName[R_C_GALF2_RX],"R_C_GALF2_RX");
   strcpy(StateName[R_C_FLAG2_RX],"R_C_FLAG2_RX");

   /*  Transceiver Training States   */
   strcpy(StateName[R_C_QUIET2_RX],"R_C_QUIET2_RX");
   strcpy(StateName[R_C_PILOT1_RX],"R_C_PILOT1_RX");
   strcpy(StateName[R_C_REVERB1_RX],"R_C_REVERB1_RX");
   strcpy(StateName[R_C_ECT_RX],"R_C_ECT_RX");
   strcpy(StateName[R_C_REVERB2_RX],"R_C_REVERB2_RX");
   strcpy(StateName[R_C_PILOT3_RX],"R_C_PILOT3_RX");
   strcpy(StateName[R_C_REVERB3_RX],"R_C_REVERB3_RX");

   /*  Channel Analysis States */
   strcpy(StateName[R_C_RATES1_RX],"R_C_RATES1_RX");
   strcpy(StateName[R_C_CRC1_RX],"R_C_CRC1_RX");
   strcpy(StateName[R_C_MSGS1_RX],"R_C_MSGS1_RX");
   strcpy(StateName[R_C_CRC2_RX],"R_C_CRC2_RX");
   strcpy(StateName[R_C_MEDLEY_RX],"R_C_MEDLEY_RX");

   /*  Exchange States */
   strcpy(StateName[R_C_RATES_RA_RX],"R_C_RATES_RA_RX");
   strcpy(StateName[R_C_CRC_RA1_RX],"R_C_CRC_RA1_RX");
   strcpy(StateName[R_C_MSG_RA_RX],"R_C_MSG_RA_RX");
   strcpy(StateName[R_C_CRC_RA2_RX],"R_C_CRC_RA2_RX");
   strcpy(StateName[R_C_REVERB_RA_RX],"R_C_REVERB_RA_RX");
   strcpy(StateName[R_C_MSG2_RX],"R_C_MSG2_RX");
   strcpy(StateName[R_C_CRC3_RX],"R_C_CRC3_RX");
   strcpy(StateName[R_C_RATES2_RX],"R_C_RATES2_RX");
   strcpy(StateName[R_C_CRC4_RX],"R_C_CRC4_RX");
   strcpy(StateName[R_C_BG_RX],"R_C_BG_RX");
   strcpy(StateName[R_C_CRC5_RX],"R_C_CRC5_RX");
   strcpy(StateName[R_C_REVERB5_RX],"R_C_REVERB5_RX");

   /*  Showtime state */
   strcpy(StateName[R_C_SHOWTIME_RX],"R_C_SHOWTIME_RX (DMT)");

   /* Idle Link (L3) States */
   /*    strcpy(StateName[R_IDLE_LINK_TX],"R_IDLE_LINK_TX ");  */
   /*    strcpy(StateName[R_IDLE_LINK_RX],"R_IDLE_LINK_RX "); */

   /* Handshake States */
   strcpy(StateName[R_QUIET_EF1_TX],"R_QUIET_EF1_TX");
   strcpy(StateName[R_C_QUIET_EF1_RX],"R_C_QUIET_EF1_RX");

   /* T1.413 signaling states */
   strcpy(StateName[R_QUIET1_TX],"R_QUIET1_TX");
   strcpy(StateName[R_ACT_REQ_TX],"R_ACT_REQ_TX");
   strcpy(StateName[R_ACK_TX],"R_ACK_TX");
   strcpy(StateName[R_C_ACT_RX],"R_C_ACT_RX");
   strcpy(StateName[R_C_REVEILLE_RX],"R_C_REVEILLE_RX");

   /* Fast Retrain Tx and Rx states */
   strcpy(StateName[R_RECOV_TX],"R_RECOV_TX");
   strcpy(StateName[R_REVERB_FR1_TX],"R_REVERB_FR1_TX");
   strcpy(StateName[R_SEGUE_FR1_TX],"R_SEGUE_FR1_TX");
   strcpy(StateName[R_LINE_PROBE_TX],"R_LINE_PROBE_TX");
   strcpy(StateName[R_REVERB_FR2_TX],"R_REVERB_FR2_TX");
   strcpy(StateName[R_SEGUE_FR2_TX],"R_SEGUE_FR2_TX");
   strcpy(StateName[R_MSG_FR1_TX],"R_MSG_FR1_TX");
   strcpy(StateName[R_CRC_FR1_TX],"R_CRC_FR1_TX");
   strcpy(StateName[R_QUIET_FR1_TX],"R_QUIET_FR1_TX");
   strcpy(StateName[R_REVERB_FR3_TX],"R_REVERB_FR3_TX");
   strcpy(StateName[R_QUIET_FR2_TX],"R_QUIET_FR2_TX");
   strcpy(StateName[R_REVERB_FR4_TX],"R_REVERB_FR4_TX");
   strcpy(StateName[R_ECT_FR_TX],"R_ECT_FR_TX");
   strcpy(StateName[R_REVERB_FR5_TX],"R_REVERB_FR5_TX");
   strcpy(StateName[R_SEGUE_FR3_TX],"R_SEGUE_FR3_TX");
   strcpy(StateName[R_MEDLEY_FR_TX],"R_MEDLEY_FR_TX");
   strcpy(StateName[R_REVERB_FR6_TX],"R_REVERB_FR6_TX");
   strcpy(StateName[R_SEGUE_FR4_TX],"R_SEGUE_FR4_TX");
   strcpy(StateName[R_MSG_FR2_TX],"R_MSG_FR2_TX");
   strcpy(StateName[R_CRC_FR2_TX],"R_CRC_FR2_TX");
   strcpy(StateName[R_REVERB_FR7_TX],"R_REVERB_FR7_TX");
   strcpy(StateName[R_SEGUE_FR5_TX],"R_SEGUE_FR5_TX");

   strcpy(StateName[R_C_RECOV_RX],"R_C_RECOV_RX");
   strcpy(StateName[R_C_REVERB_FR1_RX],"R_C_REVERB_FR1_RX");
   strcpy(StateName[R_C_PILOT_FR1_RX],"R_C_PILOT_FR1_RX");
   strcpy(StateName[R_C_REVERB_FR2_RX],"R_C_REVERB_FR2_RX");
   strcpy(StateName[R_C_MSG_FR1_RX],"R_C_MSG_FR1_RX");
   strcpy(StateName[R_C_CRC_FR1_RX],"R_C_CRC_FR1_RX");
   strcpy(StateName[R_C_REVERB_FR3_RX],"R_C_REVERB_FR3_RX");
   strcpy(StateName[R_C_PILOT_FR2_RX],"R_C_PILOT_FR2_RX");
   strcpy(StateName[R_C_REVERB_FR4_RX],"R_C_REVERB_FR4_RX");
   strcpy(StateName[R_C_ECT_FR_RX],"R_C_ECT_FR_RX");
   strcpy(StateName[R_C_REVERB_FR5_RX],"R_C_REVERB_FR5_RX");
   strcpy(StateName[R_C_PILOT_FR3_RX],"R_C_PILOT_FR3_RX");
   strcpy(StateName[R_C_REVERB_FR6_RX],"R_C_REVERB_FR6_RX");
   strcpy(StateName[R_C_MEDLEY_FR_RX],"R_C_MEDLEY_FR_RX");
   strcpy(StateName[R_C_MSG_FR2_RX],"R_C_MSG_FR2_RX");
   strcpy(StateName[R_C_CRC_FR2_RX],"R_C_CRC_FR2_RX");
   strcpy(StateName[R_C_REVERB_FR8_RX],"R_C_REVERB_FR8_RX");

   /* =============================================================== */
   /* G.dmt.bis TX states                                             */
   /* =============================================================== */

   /* CPE TX Channel Discovery States */

   strcpy(StateName[R_QUIET1_TX_BIS],"R_QUIET1_TX_BIS");
   strcpy(StateName[R_COMB1_TX_BIS],"R_COMB1_TX_BIS");
   strcpy(StateName[R_QUIET2_TX_BIS],"R_QUIET2_TX_BIS");   // Reuse RQuietTxF_BIS
   strcpy(StateName[R_COMB2_TX_BIS],"R_COMB2_TX_BIS");   // Reuse RCombTxF_BIS
   strcpy(StateName[R_ICOMB1_TX_BIS],"R_ICOMB1_TX_BIS");   // Reuse RCombTxF_BIS
   strcpy(StateName[R_LINEPROBE_TX_BIS],"R_LINEPROBE_TX_BIS");

   strcpy(StateName[R_QUIET3_TX_BIS],"R_QUIET3_TX_BIS");   // Reuse RQuietTxF_BIS
   strcpy(StateName[R_COMB3_TX_BIS],"R_COMB3_TX_BIS");   // Reuse RCombTxF_BIS
   strcpy(StateName[R_ICOMB2_TX_BIS],"R_ICOMB2_TX_BIS");   // Reuse RCombTxF_BIS
   strcpy(StateName[R_MSG_FMT_TX_BIS],"R_MSG_FMT_TX_BIS");
   strcpy(StateName[R_MSG_PCB_TX_BIS],"R_MSG_PCB_TX_BIS");   // Reuse RMsgFmtTxF_BIS

   /* CPE TX Transceiver Training States */

   strcpy(StateName[R_REVERB1_TX_BIS],"R_REVERB1_TX_BIS");
   strcpy(StateName[R_QUIET4_TX_BIS],"R_QUIET4_TX_BIS");   // Reuse RQuietTxF_BIS
   strcpy(StateName[R_REVERB2_TX_BIS],"R_REVERB2_TX_BIS");   // Reuse RReverbTxF_BIS
   strcpy(StateName[R_QUIET5_TX_BIS],"R_QUIET5_TX_BIS");
   strcpy(StateName[R_REVERB3_TX_BIS],"R_REVERB3_TX_BIS");
   strcpy(StateName[R_ECT_TX_BIS],"R_ECT_TX_BIS");
   strcpy(StateName[R_REVERB4_TX_BIS],"R_REVERB4_TX_BIS");
   strcpy(StateName[R_SEGUE1_TX_BIS],"R_SEGUE1_TX_BIS");

   /* CPE TX Channel Analysis States */

   strcpy(StateName[R_REVERB5_TX_BIS],"R_REVERB5_TX_BIS");
   strcpy(StateName[R_SEGUE2_TX_BIS],"R_SEGUE2_TX_BIS");
   strcpy(StateName[R_MSG1_TX_BIS],"R_MSG1_TX_BIS");
   strcpy(StateName[R_MEDLEY_TX_BIS],"R_MEDLEY_TX_BIS");
   strcpy(StateName[R_EXCHMARKER_TX_BIS],"R_EXCHMARKER_TX_BIS");

   /* CPE TX Exchange States */

   strcpy(StateName[R_MSG2_TX_BIS],"R_MSG2_TX_BIS");
   strcpy(StateName[R_REVERB6_TX_BIS],"R_REVERB6_TX_BIS");
   strcpy(StateName[R_SEGUE3_TX_BIS],"R_SEGUE3_TX_BIS");
   strcpy(StateName[R_PARAMS_TX_BIS],"R_PARAMS_TX_BIS");
   strcpy(StateName[R_REVERB7_TX_BIS],"R_REVERB7_TX_BIS");
   strcpy(StateName[R_SEGUE4_TX_BIS],"R_SEGUE4_TX_BIS");

   /* For bis diagnostics mode only */
   strcpy(StateName[R_SEGUE_LD_TX_BIS],"R_SEGUE_LD_TX_BIS");
   strcpy(StateName[R_MSG_LD_TX_BIS],"R_MSG_LD_TX_BIS");
   strcpy(StateName[R_QUIET1_LD_TX_BIS],"R_QUIET1_LD_TX_BIS");
   strcpy(StateName[R_QUIET2_LD_TX_BIS],"R_QUIET2_LD_TX_BIS");
   strcpy(StateName[R_ACK_NACK_LD_TX_BIS],"R_ACK_NACK_LD_TX_BIS");
   strcpy(StateName[R_QUIET3_LD_TX_BIS],"R_QUIET3_LD_TX_BIS");
   strcpy(StateName[R_QUIET_L3_TX_BIS],"R_QUIET_L3_TX_BIS");

   /* For bis short initialization only */
   strcpy(StateName[R_QUIET2_SI_TX_BIS],"R_QUIET2_SI_TX_BIS");
   /* =============================================================== */
   /* G.dmt.bis RX states                                             */
   /* =============================================================== */

   /* CPE RX Channel Discovery States */

   strcpy(StateName[R_C_QUIET1_RX_BIS],"R_C_QUIET1_RX_BIS");
   strcpy(StateName[R_C_COMB1_RX_BIS],"R_C_COMB1_RX_BIS");
   strcpy(StateName[R_C_QUIET2_RX_BIS],"R_C_QUIET2_RX_BIS");
   strcpy(StateName[R_C_COMB2_RX_BIS],"R_C_COMB2_RX_BIS");
   strcpy(StateName[R_C_ICOMB1_RX_BIS],"R_C_ICOMB1_RX_BIS");
   strcpy(StateName[R_C_LINEPROBE_RX_BIS],"R_C_LINEPROBE_RX_BIS");
   strcpy(StateName[R_C_QUIET3_RX_BIS],"R_C_QUIET3_RX_BIS");
   strcpy(StateName[R_C_COMB3_RX_BIS],"R_C_COMB3_RX_BIS");
   strcpy(StateName[R_C_ICOMB2_RX_BIS],"R_C_ICOMB2_RX_BIS");
   strcpy(StateName[R_C_MSG_FMT_RX_BIS],"R_C_MSG_FMT_RX_BIS");
   strcpy(StateName[R_C_MSG_PCB_RX_BIS],"R_C_MSG_PCB_RX_BIS");   // Reuse RCMsgFmtRxF_BIS
   strcpy(StateName[R_C_QUIET4_RX_BIS],"R_C_QUIET4_RX_BIS");

   /* CPE RX Transceiver Training States */

   strcpy(StateName[R_C_REVERB1_RX_BIS],"R_C_REVERB1_RX_BIS");
   strcpy(StateName[R_C_REVERB2_RX_BIS],"R_C_REVERB2_RX_BIS");
   strcpy(StateName[R_C_REVERB3_RX_BIS],"R_C_REVERB3_RX_BIS");
   strcpy(StateName[R_C_TREF2_RX_BIS],"R_C_TREF2_RX_BIS");
   strcpy(StateName[R_C_REVERB4_RX_BIS],"R_C_REVERB4_RX_BIS");

   /* CPE RX Channel Analysis States */

   strcpy(StateName[R_C_MSG1_RX_BIS],"R_C_MSG1_RX_BIS");
   strcpy(StateName[R_C_REVERB5_RX_BIS],"R_C_REVERB5_RX_BIS");
   strcpy(StateName[R_C_MEDLEY_RX_BIS],"R_C_MEDLEY_RX_BIS");
   strcpy(StateName[R_C_EXCHMARKER_RX_BIS],"R_C_EXCHMARKER_RX_BIS");

   /* CPE RX Exchange States */

   strcpy(StateName[R_C_MSG2_RX_BIS],"R_C_MSG2_RX_BIS");
   strcpy(StateName[R_C_REVERB6_RX_BIS],"R_C_REVERB6_RX_BIS");
   strcpy(StateName[R_C_SEGUE3_RX_BIS],"R_C_SEGUE3_RX_BIS");
   strcpy(StateName[R_C_PARAMS_RX_BIS],"R_C_PARAMS_RX_BIS");
   strcpy(StateName[R_C_REVERB7_RX_BIS],"R_C_REVERB7_RX_BIS");
   strcpy(StateName[R_C_SEGUE4_RX_BIS],"R_C_SEGUE4_RX_BIS");

   /* For bis diagnostics mode only */
   strcpy(StateName[R_C_TREF1_LD_RX_BIS],"R_C_TREF1_LD_RX_BIS");
   strcpy(StateName[R_C_TREF2_LD_RX_BIS],"R_C_TREF2_LD_RX_BIS");
   strcpy(StateName[R_C_SEGUE_LD_RX_BIS],"R_C_SEGUE_LD_RX_BIS");
   strcpy(StateName[R_C_MSG_LD_RX_BIS],"R_C_MSG_LD_RX_BIS");
   strcpy(StateName[R_C_TREF3_LD_RX_BIS],"R_C_TREF3_LD_RX_BIS");
   strcpy(StateName[R_C_QUIET_L3_RX_BIS],"R_C_QUIET_L3_RX_BIS");

   /* Handshake Message Exchange Transaction States */
   strcpy(HndshkMsgName[R_HS_INITIAL-R_HS_INITIAL],        "R_HS_INITIAL       ");
   strcpy(HndshkMsgName[R_HS_SEND_MR-R_HS_INITIAL],        "R_HS_SEND_MR       ");
   strcpy(HndshkMsgName[R_HS_SEND_MS-R_HS_INITIAL],        "R_HS_SEND_MS       ");
   strcpy(HndshkMsgName[R_HS_SEND_CLR-R_HS_INITIAL],       "R_HS_SEND_CLR      ");
   strcpy(HndshkMsgName[R_HS_MS_OK-R_HS_INITIAL],          "R_HS_MS_OK         ");
   strcpy(HndshkMsgName[R_HS_CL_OK-R_HS_INITIAL],          "R_HS_CL_OK         ");
   strcpy(HndshkMsgName[R_HS_PARTIAL_MS-R_HS_INITIAL],     "R_HS_PARTIAL_MS    ");
   strcpy(HndshkMsgName[R_HS_PARTIAL_CL-R_HS_INITIAL],     "R_HS_PARTIAL_CL    ");
   strcpy(HndshkMsgName[R_HS_NOT_READY-R_HS_INITIAL],      "R_HS_NOT_READY     ");
   strcpy(HndshkMsgName[R_HS_NOT_SUPPORTED-R_HS_INITIAL],  "R_HS_NOT_SUPPORTED ");
   strcpy(HndshkMsgName[R_HS_NOT_UNDERSTOOD-R_HS_INITIAL], "R_HS_NOT_UNDERSTOOD");
   strcpy(HndshkMsgName[R_HS_RESTART-R_HS_INITIAL],        "R_HS_RESTART       ");
   strcpy(HndshkMsgName[R_HS_EXIT-R_HS_INITIAL],         "R_HS_EXIT          ");

   strcpy(HSMsgType[0x3F], "IDLE FLAG");
   strcpy(HSMsgType[M_MS], "MS");
   strcpy(HSMsgType[M_MR], "MR");
   strcpy(HSMsgType[M_CL], "CL");
   strcpy(HSMsgType[M_CLR], "CLR");
   strcpy(HSMsgType[M_MP], "MP");
   strcpy(HSMsgType[M_ACK1], "ACK1");
   strcpy(HSMsgType[M_ACK2], "ACK2");
   strcpy(HSMsgType[M_NAK_EF], "NAK_EF");
   strcpy(HSMsgType[M_NAK_NR], "NAK_NR");
   strcpy(HSMsgType[M_NAK_NS], "NAK_NS");
   strcpy(HSMsgType[M_NAK_CD], "NAK_CD");
   strcpy(HSMsgType[M_REQ_MS], "REQ_MS");
   strcpy(HSMsgType[M_REQ_MR], "REQ_MR");
   strcpy(HSMsgType[M_REQ_CLR], "REQ_CLR");
   strcpy(HSMsgType[M_REQ_RTX], "REQ_RTX");

   /* DSL preferred mode exchanged during GHS*/
   strcpy(PreferredModeName[0], "G992.3 AnnexA");
   strcpy(PreferredModeName[1], "G992.3 AnnexL Mask1");
   strcpy(PreferredModeName[2], "G992.3 AnnexL Mask2");

#endif // #ifdef LEAVE_STATE_TRAIL

#ifdef LEAVE_TRAIL
   strcpy(OLR_MsgTypeName[BITSWAP_REQ], "BitSwap");
   strcpy(OLR_MsgTypeName[DRR_REQ], "DRR");
   strcpy(OLR_MsgTypeName[SRA_REQ], "SRA");

   strcpy(OLR_ResultState[STAT_OLRPM_IDLE], "OLRPM_IDLE");
   strcpy(OLR_ResultState[STAT_OLRPM_IN_PROGRESS], "OLRPM_IN_PREGRESS");
   strcpy(OLR_ResultState[STAT_OLRPM_COMPLETE], "OLRPM_COMPLETE");
   strcpy(OLR_ResultState[STAT_OLRPM_ABORTED], "OLRPM_ABORTED");

   strcpy(OLRPM_ErrorName[RESP_BUSY], " Resp_Busy");
   strcpy(OLRPM_ErrorName[RESP_INVALID_PARAMETERS], " Resp_Invalid_Param");
   strcpy(OLRPM_ErrorName[RESP_NOT_ENABLED], "Resp_Not_Enabled");
   strcpy(OLRPM_ErrorName[RESP_NOT_SUPPORTED], "Resp_Not_Support");
   strcpy(OLRPM_ErrorName[REQ_INVALID_BiGi], "Req_Invalid_BiGi");
   strcpy(OLRPM_ErrorName[REQ_INVALID_Lp], "Req_Invalid_Lp");
   strcpy(OLRPM_ErrorName[REQ_INVALID_Bpn], "Req_Invalid_Bpn");
   strcpy(OLRPM_ErrorName[REQ_INVALID_FRAMING_CONSTRAINT], "Req_Invalid_Framing");
   strcpy(OLRPM_ErrorName[REQ_NOT_IN_L0_STATE], "Req_Not_In_L0");
   strcpy(OLRPM_ErrorName[RESP_STATE_NOT_DESIRED], "Resp_State_Not_Disired");
   strcpy(OLRPM_ErrorName[RESP_INFEASIBLE_PARAMETERS], "Resp_Infeasible_Param");
   strcpy(OLRPM_ErrorName[REQ_NOT_IN_L2_STATE], "Req_Not_In_L2");
#endif //LEAVE_TRAIL
}

/*************************************************************************************
  ;   Prototype: void InitGlobalVariables_BisInfoTx(Adsl2AllInfo_t *pt_BisInfo);
  ;
  ;   Description:
  ;
  ;      Initialize the tx global variables associated with a Bis (ADSL2) or
  ;   BisPlus (ADSL2+) data structure (which in turn is a component of the
  ;   a InfoField structure).
  ;
  ;   Arguments:
  ;      *pt_BisInfo   - pointer to BisInfo structure
  ;
  ;   Return Value:
  ;      none
  ;
  ;   Global Variables:
  ;
  ;**************************************************************************************/
void InitGlobalVariables_BisInfoTx(Adsl2AllInfo_t *pt_BisInfo) {

   //XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (Start)
#ifdef HERC_API
   // PTM Initialization

   gt_HercADSL_TPS_TC_Params[0].ta_TPS_TC_Type[0].s_MinNetDataRate = MIN_NET_DATARATE_ATM_BC0_DS;
   gt_HercADSL_TPS_TC_Params[0].ta_TPS_TC_Type[0].s_MaxNetDataRate = MAX_NET_DATARATE_ATM_BC0_DS;
   gt_HercADSL_TPS_TC_Params[0].ta_TPS_TC_Type[0].s_MinResNetDataRate = MIN_RES_NET_DATARATE_ATM_BC0_DS;
   gt_HercADSL_TPS_TC_Params[0].ta_TPS_TC_Type[0].s_MaxLatency = MAX_LATENCY_ATM_BC0_DS;
   gt_HercADSL_TPS_TC_Params[0].ta_TPS_TC_Type[0].uc_MaxBER = BER_ATM_BC0_DS;
   gt_HercADSL_TPS_TC_Params[0].ta_TPS_TC_Type[0].s_IMAxINP = (IMA_FLAG_ATM_BC0_DS<<8) | (MIN_INP_ATM_BC0_DS & 0x3);
   // XDSLRTFW-1481 (Start_End) TPSTCoptions is part of paramater 7 as per message spec.
   gt_HercADSL_TPS_TC_Params[0].ta_TPS_TC_Type[0].uc_TPSTCoptions = 0;  // If used then set it to EFM preemption = 1,EFM short packets =2

   gt_HercADSL_TPS_TC_Params[1].ta_TPS_TC_Type[0].s_MinNetDataRate = MIN_NET_DATARATE_ATM_BC1_DS;
   gt_HercADSL_TPS_TC_Params[1].ta_TPS_TC_Type[0].s_MaxNetDataRate = MAX_NET_DATARATE_ATM_BC1_DS;
   gt_HercADSL_TPS_TC_Params[1].ta_TPS_TC_Type[0].s_MinResNetDataRate = MIN_RES_NET_DATARATE_ATM_BC1_DS;
   gt_HercADSL_TPS_TC_Params[1].ta_TPS_TC_Type[0].s_MaxLatency = MAX_LATENCY_ATM_BC1_DS;
   gt_HercADSL_TPS_TC_Params[1].ta_TPS_TC_Type[0].uc_MaxBER = BER_ATM_BC1_DS;
   gt_HercADSL_TPS_TC_Params[1].ta_TPS_TC_Type[0].s_IMAxINP = (IMA_FLAG_ATM_BC1_DS<<8) | (MIN_INP_ATM_BC1_DS & 0x3);
   // XDSLRTFW-1481 (Start_End) TPSTCoptions is part of paramater 7 as per message spec.
   gt_HercADSL_TPS_TC_Params[1].ta_TPS_TC_Type[0].uc_TPSTCoptions = 0;  // If used then set it to EFM preemption = 1,EFM short packets =2

   gt_HercADSL_TPS_TC_Params[2].ta_TPS_TC_Type[0].s_MinNetDataRate = MIN_NET_DATARATE_ATM_BC0_US;
   gt_HercADSL_TPS_TC_Params[2].ta_TPS_TC_Type[0].s_MaxNetDataRate = MAX_NET_DATARATE_ATM_BC0_US;
   gt_HercADSL_TPS_TC_Params[2].ta_TPS_TC_Type[0].s_MinResNetDataRate = MIN_RES_NET_DATARATE_ATM_BC0_US;
   gt_HercADSL_TPS_TC_Params[2].ta_TPS_TC_Type[0].s_MaxLatency = MAX_LATENCY_ATM_BC0_US;
   gt_HercADSL_TPS_TC_Params[2].ta_TPS_TC_Type[0].uc_MaxBER = BER_ATM_BC0_US;
   gt_HercADSL_TPS_TC_Params[2].ta_TPS_TC_Type[0].s_IMAxINP = (IMA_FLAG_ATM_BC0_US<<8) | (MIN_INP_ATM_BC0_US & 0x3);
   // XDSLRTFW-1481 (Start_End) TPSTCoptions is part of paramater 7 as per message spec.
   gt_HercADSL_TPS_TC_Params[2].ta_TPS_TC_Type[0].uc_TPSTCoptions = 0;  // If used then set it to EFM preemption = 1,EFM short packets =2

   gt_HercADSL_TPS_TC_Params[3].ta_TPS_TC_Type[0].s_MinNetDataRate = MIN_NET_DATARATE_ATM_BC1_US;
   gt_HercADSL_TPS_TC_Params[3].ta_TPS_TC_Type[0].s_MaxNetDataRate = MAX_NET_DATARATE_ATM_BC1_US;
   gt_HercADSL_TPS_TC_Params[3].ta_TPS_TC_Type[0].s_MinResNetDataRate = MIN_RES_NET_DATARATE_ATM_BC1_US;
   gt_HercADSL_TPS_TC_Params[3].ta_TPS_TC_Type[0].s_MaxLatency = MAX_LATENCY_ATM_BC1_US;
   gt_HercADSL_TPS_TC_Params[3].ta_TPS_TC_Type[0].uc_MaxBER = BER_ATM_BC1_US;
   gt_HercADSL_TPS_TC_Params[3].ta_TPS_TC_Type[0].s_IMAxINP = (IMA_FLAG_ATM_BC1_US<<8) | (MIN_INP_ATM_BC1_US & 0x3);
   // XDSLRTFW-1481 (Start_End) TPSTCoptions is part of paramater 7 as per message spec.
   gt_HercADSL_TPS_TC_Params[3].ta_TPS_TC_Type[0].uc_TPSTCoptions = 0;  // If used then set it to EFM preemption = 1,EFM short packets =2

#ifdef PPE_ENGINE
   //these variables should be configured by ME
   gula_DREG_AT_CFG_Cnfg[0] = 0;
   gula_DREG_AR_CFG_Cnfg[0] = 0;
#endif //PPE_ENGINE



   //ATM testing initilization
   gt_HercADSL_TPS_TC_Params[0].s_TPS_TC_Control = 0x2;
   gt_HercADSL_TPS_TC_Params[0].ta_TPS_TC_Type[1].s_MinNetDataRate = MIN_NET_DATARATE_ATM_BC0_DS;
   gt_HercADSL_TPS_TC_Params[0].ta_TPS_TC_Type[1].s_MaxNetDataRate = MAX_NET_DATARATE_ATM_BC0_DS;
   gt_HercADSL_TPS_TC_Params[0].ta_TPS_TC_Type[1].s_MinResNetDataRate = MIN_RES_NET_DATARATE_ATM_BC0_DS;
   gt_HercADSL_TPS_TC_Params[0].ta_TPS_TC_Type[1].s_MaxLatency = MAX_LATENCY_ATM_BC0_DS;
   gt_HercADSL_TPS_TC_Params[0].ta_TPS_TC_Type[1].uc_MaxBER = BER_ATM_BC0_DS;
   gt_HercADSL_TPS_TC_Params[0].ta_TPS_TC_Type[1].s_IMAxINP = (IMA_FLAG_ATM_BC0_DS<<8) | (MIN_INP_ATM_BC0_DS & 0x3);

   gt_HercADSL_TPS_TC_Params[1].s_TPS_TC_Control = 0x2;
   gt_HercADSL_TPS_TC_Params[1].ta_TPS_TC_Type[1].s_MinNetDataRate = MIN_NET_DATARATE_ATM_BC1_DS;
   gt_HercADSL_TPS_TC_Params[1].ta_TPS_TC_Type[1].s_MaxNetDataRate = MAX_NET_DATARATE_ATM_BC1_DS;
   gt_HercADSL_TPS_TC_Params[1].ta_TPS_TC_Type[1].s_MinResNetDataRate = MIN_RES_NET_DATARATE_ATM_BC1_DS;
   gt_HercADSL_TPS_TC_Params[1].ta_TPS_TC_Type[1].s_MaxLatency = MAX_LATENCY_ATM_BC1_DS;
   gt_HercADSL_TPS_TC_Params[1].ta_TPS_TC_Type[1].uc_MaxBER = BER_ATM_BC1_DS;
   gt_HercADSL_TPS_TC_Params[1].ta_TPS_TC_Type[1].s_IMAxINP = (IMA_FLAG_ATM_BC1_DS<<8) | (MIN_INP_ATM_BC1_DS & 0x3);

   gt_HercADSL_TPS_TC_Params[2].s_TPS_TC_Control = 0x2;
   gt_HercADSL_TPS_TC_Params[2].ta_TPS_TC_Type[1].s_MinNetDataRate = MIN_NET_DATARATE_ATM_BC0_US;
   gt_HercADSL_TPS_TC_Params[2].ta_TPS_TC_Type[1].s_MaxNetDataRate = MAX_NET_DATARATE_ATM_BC0_US;
   gt_HercADSL_TPS_TC_Params[2].ta_TPS_TC_Type[1].s_MinResNetDataRate = MIN_RES_NET_DATARATE_ATM_BC0_US;
   gt_HercADSL_TPS_TC_Params[2].ta_TPS_TC_Type[1].s_MaxLatency = MAX_LATENCY_ATM_BC0_US;
   gt_HercADSL_TPS_TC_Params[2].ta_TPS_TC_Type[1].uc_MaxBER = BER_ATM_BC0_US;
   gt_HercADSL_TPS_TC_Params[2].ta_TPS_TC_Type[1].s_IMAxINP = (IMA_FLAG_ATM_BC0_US<<8) | (MIN_INP_ATM_BC0_US & 0x3);

   gt_HercADSL_TPS_TC_Params[3].s_TPS_TC_Control = 0x2;
   gt_HercADSL_TPS_TC_Params[3].ta_TPS_TC_Type[1].s_MinNetDataRate = MIN_NET_DATARATE_ATM_BC1_US;
   gt_HercADSL_TPS_TC_Params[3].ta_TPS_TC_Type[1].s_MaxNetDataRate = MAX_NET_DATARATE_ATM_BC1_US;
   gt_HercADSL_TPS_TC_Params[3].ta_TPS_TC_Type[1].s_MinResNetDataRate = MIN_RES_NET_DATARATE_ATM_BC1_US;
   gt_HercADSL_TPS_TC_Params[3].ta_TPS_TC_Type[1].s_MaxLatency = MAX_LATENCY_ATM_BC1_US;
   gt_HercADSL_TPS_TC_Params[3].ta_TPS_TC_Type[1].uc_MaxBER = BER_ATM_BC1_US;
   gt_HercADSL_TPS_TC_Params[3].ta_TPS_TC_Type[1].s_IMAxINP = (IMA_FLAG_ATM_BC1_US<<8) | (MIN_INP_ATM_BC1_US & 0x3);

#endif   //HERC_API
   //XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping ( End)
#if 0
   pt_BisInfo->ta_DSBearerChannel[0].s_Control = TPSTC_TYPE_ATM;
   pt_BisInfo->ta_DSBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_ATM].s_MinNetDataRate = MIN_NET_DATARATE_ATM_BC0_DS;
   pt_BisInfo->ta_DSBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_ATM].s_MaxNetDataRate = MAX_NET_DATARATE_ATM_BC0_DS;
   pt_BisInfo->ta_DSBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_ATM].s_MinResNetDataRate = MIN_RES_NET_DATARATE_ATM_BC0_DS;
   pt_BisInfo->ta_DSBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_ATM].s_MaxLatency = MAX_LATENCY_ATM_BC0_DS;
   pt_BisInfo->ta_DSBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_ATM].uc_MaxBER = BER_ATM_BC0_DS;
   pt_BisInfo->ta_DSBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_ATM].s_IMAxINP = (IMA_FLAG_ATM_BC0_DS<<8) | (MIN_INP_ATM_BC0_DS & 0x3);

   pt_BisInfo->ta_DSBearerChannel[1].s_Control = TPSTC_TYPE_ATM;
   pt_BisInfo->ta_DSBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_ATM].s_MinNetDataRate = MIN_NET_DATARATE_ATM_BC1_DS;
   pt_BisInfo->ta_DSBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_ATM].s_MaxNetDataRate = MAX_NET_DATARATE_ATM_BC1_DS;
   pt_BisInfo->ta_DSBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_ATM].s_MinResNetDataRate = MIN_RES_NET_DATARATE_ATM_BC1_DS;
   pt_BisInfo->ta_DSBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_ATM].s_MaxLatency = MAX_LATENCY_ATM_BC1_DS;
   pt_BisInfo->ta_DSBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_ATM].uc_MaxBER = BER_ATM_BC1_DS;
   pt_BisInfo->ta_DSBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_ATM].s_IMAxINP = (IMA_FLAG_ATM_BC1_DS<<8) | (MIN_INP_ATM_BC1_DS & 0x3);

   pt_BisInfo->ta_USBearerChannel[0].s_Control = TPSTC_TYPE_ATM;
   pt_BisInfo->ta_USBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_ATM].s_MinNetDataRate = MIN_NET_DATARATE_ATM_BC0_US;
   pt_BisInfo->ta_USBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_ATM].s_MaxNetDataRate = MAX_NET_DATARATE_ATM_BC0_US;
   pt_BisInfo->ta_USBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_ATM].s_MinResNetDataRate = MIN_RES_NET_DATARATE_ATM_BC0_US;
   pt_BisInfo->ta_USBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_ATM].s_MaxLatency = MAX_LATENCY_ATM_BC0_US;
   pt_BisInfo->ta_USBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_ATM].uc_MaxBER = BER_ATM_BC0_US;
   pt_BisInfo->ta_USBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_ATM].s_IMAxINP = (IMA_FLAG_ATM_BC0_US<<8) | (MIN_INP_ATM_BC0_US & 0x3);

   pt_BisInfo->ta_USBearerChannel[1].s_Control = TPSTC_TYPE_ATM;
   pt_BisInfo->ta_USBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_ATM].s_MinNetDataRate = MIN_NET_DATARATE_ATM_BC1_US;
   pt_BisInfo->ta_USBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_ATM].s_MaxNetDataRate = MAX_NET_DATARATE_ATM_BC1_US;
   pt_BisInfo->ta_USBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_ATM].s_MinResNetDataRate = MIN_RES_NET_DATARATE_ATM_BC1_US;
   pt_BisInfo->ta_USBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_ATM].s_MaxLatency = MAX_LATENCY_ATM_BC1_US;
   pt_BisInfo->ta_USBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_ATM].uc_MaxBER = BER_ATM_BC1_US;
   pt_BisInfo->ta_USBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_ATM].s_IMAxINP = (IMA_FLAG_ATM_BC1_US<<8) | (MIN_INP_ATM_BC1_US & 0x3);

   /*****************************************PTM CHANGES**************************************/
#ifdef DANUBE_PTM_SUPPORT
   pt_BisInfo->ta_DSBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_PTM].s_MinNetDataRate = MIN_NET_DATARATE_PTM_BC0_DS;
   pt_BisInfo->ta_DSBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_PTM].s_MaxNetDataRate = MAX_NET_DATARATE_PTM_BC0_DS;
   pt_BisInfo->ta_DSBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_PTM].s_MinResNetDataRate = MIN_RES_NET_DATARATE_PTM_BC0_DS;
   pt_BisInfo->ta_DSBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_PTM].s_MaxLatency = MAX_LATENCY_PTM_BC0_DS;
   pt_BisInfo->ta_DSBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_PTM].uc_MaxBER = BER_PTM_BC0_DS;
   pt_BisInfo->ta_DSBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_PTM].s_IMAxINP = (MIN_INP_PTM_BC0_DS & 0x3);


   pt_BisInfo->ta_DSBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_PTM].s_MinNetDataRate = MIN_NET_DATARATE_PTM_BC1_DS;
   pt_BisInfo->ta_DSBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_PTM].s_MaxNetDataRate = MAX_NET_DATARATE_PTM_BC1_DS;
   pt_BisInfo->ta_DSBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_PTM].s_MinResNetDataRate = MIN_RES_NET_DATARATE_PTM_BC1_DS;
   pt_BisInfo->ta_DSBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_PTM].s_MaxLatency = MAX_LATENCY_PTM_BC1_DS;
   pt_BisInfo->ta_DSBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_PTM].uc_MaxBER = BER_PTM_BC1_DS;
   pt_BisInfo->ta_DSBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_PTM].s_IMAxINP = (MIN_INP_PTM_BC1_DS & 0x3);


   pt_BisInfo->ta_USBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_PTM].s_MinNetDataRate = MIN_NET_DATARATE_PTM_BC0_US;
   pt_BisInfo->ta_USBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_PTM].s_MaxNetDataRate = MAX_NET_DATARATE_PTM_BC0_US;
   pt_BisInfo->ta_USBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_PTM].s_MinResNetDataRate = MIN_RES_NET_DATARATE_PTM_BC0_US;
   pt_BisInfo->ta_USBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_PTM].s_MaxLatency = MAX_LATENCY_PTM_BC0_US;
   pt_BisInfo->ta_USBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_PTM].uc_MaxBER = BER_PTM_BC0_US;
   pt_BisInfo->ta_USBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_PTM].s_IMAxINP = (MIN_INP_PTM_BC0_US & 0x3);


   pt_BisInfo->ta_USBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_PTM].s_MinNetDataRate = MIN_NET_DATARATE_PTM_BC1_US;
   pt_BisInfo->ta_USBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_PTM].s_MaxNetDataRate = MAX_NET_DATARATE_PTM_BC1_US;
   pt_BisInfo->ta_USBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_PTM].s_MinResNetDataRate = MIN_RES_NET_DATARATE_PTM_BC1_US;
   pt_BisInfo->ta_USBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_PTM].s_MaxLatency = MAX_LATENCY_PTM_BC1_US;
   pt_BisInfo->ta_USBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_PTM].uc_MaxBER = BER_PTM_BC1_US;
   pt_BisInfo->ta_USBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_PTM].s_IMAxINP =(MIN_INP_PTM_BC1_US & 0x3);
#endif//if defined DANUBE_PTM_SUPPORT

#endif // #if 0
   pt_BisInfo->t_Overhead.s_DSMSGOvhdMinRate = (int16)MIN_MSGOVERHEAD_DATARATE_DS;
   pt_BisInfo->t_Overhead.s_USMSGOvhdMinRate = (int16)MIN_MSGOVERHEAD_DATARATE_US;

   pt_BisInfo->ta_DSLatencyPath[0].s_MaxDataRate = MAX_DATARATE_LP0_DATAPATH_DS;
   pt_BisInfo->ta_DSLatencyPath[0].s_MaxRandD = (MAX_R_LP0_DS << 8) | MAX_D_LP0_DS;
   /*****************************************PTM CHANGES**************************************/
   pt_BisInfo->uc_DS_Max_Num_STM_TPS_TC = DEFAULT_NUM_DS_STM_TPS_TC;
   pt_BisInfo->uc_DS_Max_Num_ATM_TPS_TC = DEFAULT_NUM_DS_ATM_TPS_TC;
   pt_BisInfo->uc_DS_Max_Num_PTM_TPS_TC = DEFAULT_NUM_DS_PTM_TPS_TC;
   pt_BisInfo->uc_US_Max_Num_STM_TPS_TC = DEFAULT_NUM_US_STM_TPS_TC;
   pt_BisInfo->uc_US_Max_Num_ATM_TPS_TC = DEFAULT_NUM_US_ATM_TPS_TC;
   pt_BisInfo->uc_US_Max_Num_PTM_TPS_TC = DEFAULT_NUM_US_PTM_TPS_TC;
   /*********************************PTM CHANGES*************************************/

   if (gft_DisableExtendedFrame)
   {
      pt_BisInfo->ta_DSLatencyPath[0].s_OneOverS0min = ONE_OVER_S_HALF;
      pt_BisInfo->ta_DSLatencyPath[0].s_D0Mask = 0;
   }
   else
   {
      pt_BisInfo->ta_DSLatencyPath[0].s_OneOverS0min = MAX_ONEOVERS_LP0_DS;

#ifndef ADSL_62
      if (guc_Iridia_Revision_Number >= IRIDIA_31)
         pt_BisInfo->ta_DSLatencyPath[0].s_D0Mask = MAX_D0_SUPPORT_MASK;
      else
         pt_BisInfo->ta_DSLatencyPath[0].s_D0Mask = MAX_D0_SUPPORT_MASK_30;
#else
      pt_BisInfo->ta_DSLatencyPath[0].s_D0Mask = MAX_D0_SUPPORT_MASK;
#endif

   }

   pt_BisInfo->ta_DSLatencyPath[1].s_MaxDataRate = MAX_DATARATE_LP1_DATAPATH_DS;
   pt_BisInfo->ta_DSLatencyPath[1].s_MaxRandD = (MAX_R_LP1_DS << 8) | MAX_D_LP1_DS;

   pt_BisInfo->ta_USLatencyPath[0].s_MaxDataRate = MAX_DATARATE_LP0_DATAPATH_US;
   pt_BisInfo->ta_USLatencyPath[0].s_MaxRandD = (MAX_R_LP0_US << 8) | MAX_D_LP0_US;

   pt_BisInfo->ta_USLatencyPath[1].s_MaxDataRate = MAX_DATARATE_LP1_DATAPATH_US;
   pt_BisInfo->ta_USLatencyPath[1].s_MaxRandD = (MAX_R_LP1_US << 8) | MAX_D_LP1_US;

   pt_BisInfo->t_PMD_Npar2.ft_DiagMode = 0; /* not in diag mode */
   pt_BisInfo->t_PMD_Npar2.ft_ShortInit = 0; /* short Initialization mode not supported. */

}


/*************************************************************************************
  ;   Prototype: void InitGlobalVariables_BisInfoRx(Adsl2AllInfo_t *pt_BisInfo);
  ;
  ;   Description:
  ;
  ;      Initialize the rx global variables associated with a Bis (ADSL2) or
  ;   BisPlus (ADSL2+) data structure (which in turn is a component of the
  ;   a InfoField structure).
  ;
  ;   Arguments:
  ;      *pt_BisInfo   - pointer to BisInfo structure
  ;
  ;   Return Value:
  ;      none
  ;
  ;   Global Variables:
  ;
  ;**************************************************************************************/
void InitGlobalVariables_BisInfoRx(Adsl2AllInfo_t *pt_BisInfo) {

   /* Initialise the LP0 receive information to be max as this information is not exchanged */
   /* and it is assumed that max values are supported for R and D */
   pt_BisInfo->ta_DSLatencyPath[0].s_MaxRandD = (MAX_R_LP0_DS << 8) | MAX_D_LP0_DS;
   pt_BisInfo->ta_USLatencyPath[0].s_MaxRandD = (MAX_R_LP0_US << 8) | MAX_D_LP0_US;
}

/*************************************************************************************
  ;   Prototype: void InitGlobalVariables_BisPlusInfoTx(Adsl2AllInfo_t *pt_BisPlusInfo);
  ;
  ;   Description:
  ;
  ;      Initialize the tx global variables associated with a
  ;   BisPlus (ADSL2+) data structure (which in turn is a component of the
  ;   a InfoField structure).
  ;
  ;   Arguments:
  ;      *pt_BisPlusInfo   - pointer to BisPlusInfo structure
  ;
  ;   Return Value:
  ;      none
  ;
  ;   Global Variables:
  ;
  ;**************************************************************************************/
void InitGlobalVariables_BisPlusInfoTx(Adsl2AllInfo_t *pt_BisPlusInfo) {

   pt_BisPlusInfo->ta_DSBearerChannel[0].s_Control = TPSTC_TYPE_ATM;
   pt_BisPlusInfo->ta_DSBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_ATM].s_MinNetDataRate = MIN_NET_DATARATE_ATM_BC0_DS;
   pt_BisPlusInfo->ta_DSBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_ATM].s_MaxNetDataRate = MAX_NET_DATARATE_ATM_BC0_DS_G992_5;
   pt_BisPlusInfo->ta_DSBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_ATM].s_MinResNetDataRate = MIN_RES_NET_DATARATE_ATM_BC0_DS_G992_5;
   pt_BisPlusInfo->ta_DSBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_ATM].s_MaxLatency = MAX_LATENCY_ATM_BC0_DS_G992_5;
   pt_BisPlusInfo->ta_DSBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_ATM].uc_MaxBER = BER_ATM_BC0_DS_G992_5;
   pt_BisPlusInfo->ta_DSBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_ATM].s_IMAxINP = (IMA_FLAG_ATM_BC0_DS_G992_5<<8) | (MIN_INP_ATM_BC0_DS_G992_5 & 0x3);

   pt_BisPlusInfo->ta_DSBearerChannel[1].s_Control = TPSTC_TYPE_ATM;
   pt_BisPlusInfo->ta_DSBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_ATM].s_MinNetDataRate = MIN_NET_DATARATE_ATM_BC1_DS;
   pt_BisPlusInfo->ta_DSBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_ATM].s_MaxNetDataRate = MAX_NET_DATARATE_ATM_BC1_DS_G992_5;
   pt_BisPlusInfo->ta_DSBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_ATM].s_MinResNetDataRate = MIN_RES_NET_DATARATE_ATM_BC1_DS_G992_5;
   pt_BisPlusInfo->ta_DSBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_ATM].s_MaxLatency = MAX_LATENCY_ATM_BC1_DS_G992_5;
   pt_BisPlusInfo->ta_DSBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_ATM].uc_MaxBER = BER_ATM_BC1_DS_G992_5;
   pt_BisPlusInfo->ta_DSBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_ATM].s_IMAxINP = (IMA_FLAG_ATM_BC1_DS_G992_5<<8) | (MIN_INP_ATM_BC1_DS_G992_5 & 0x3);

   pt_BisPlusInfo->ta_USBearerChannel[0].s_Control = TPSTC_TYPE_ATM;
   pt_BisPlusInfo->ta_USBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_ATM].s_MinNetDataRate = MIN_NET_DATARATE_ATM_BC0_US;
   pt_BisPlusInfo->ta_USBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_ATM].s_MaxNetDataRate = MAX_NET_DATARATE_ATM_BC0_US;
   pt_BisPlusInfo->ta_USBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_ATM].s_MinResNetDataRate = MIN_RES_NET_DATARATE_ATM_BC0_US;
   pt_BisPlusInfo->ta_USBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_ATM].s_MaxLatency = MAX_LATENCY_ATM_BC0_US;
   pt_BisPlusInfo->ta_USBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_ATM].uc_MaxBER = BER_ATM_BC0_US;
   pt_BisPlusInfo->ta_USBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_ATM].s_IMAxINP = (IMA_FLAG_ATM_BC0_US<<8) | (MIN_INP_ATM_BC0_US & 0x3);

   pt_BisPlusInfo->ta_USBearerChannel[1].s_Control = TPSTC_TYPE_ATM;
   pt_BisPlusInfo->ta_USBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_ATM].s_MinNetDataRate = MIN_NET_DATARATE_ATM_BC1_US;
   pt_BisPlusInfo->ta_USBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_ATM].s_MaxNetDataRate = MAX_NET_DATARATE_ATM_BC1_US;
   pt_BisPlusInfo->ta_USBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_ATM].s_MinResNetDataRate = MIN_RES_NET_DATARATE_ATM_BC1_US;
   pt_BisPlusInfo->ta_USBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_ATM].s_MaxLatency = MAX_LATENCY_ATM_BC1_US;
   pt_BisPlusInfo->ta_USBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_ATM].uc_MaxBER = BER_ATM_BC1_US;
   pt_BisPlusInfo->ta_USBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_ATM].s_IMAxINP = (IMA_FLAG_ATM_BC1_US<<8) | (MIN_INP_ATM_BC1_US & 0x3);
   /********************************PTM changes Begin*****************************************/
#ifdef DANUBE_PTM_SUPPORT
   pt_BisPlusInfo->ta_DSBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_PTM].s_MinNetDataRate = MIN_NET_DATARATE_PTM_BC0_DS;
   pt_BisPlusInfo->ta_DSBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_PTM].s_MaxNetDataRate = MAX_NET_DATARATE_PTM_BC0_DS_G992_5;
   pt_BisPlusInfo->ta_DSBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_PTM].s_MinResNetDataRate = MIN_RES_NET_DATARATE_PTM_BC0_DS_G992_5;
   pt_BisPlusInfo->ta_DSBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_PTM].s_MaxLatency = MAX_LATENCY_PTM_BC0_DS_G992_5;
   pt_BisPlusInfo->ta_DSBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_PTM].uc_MaxBER = BER_PTM_BC0_DS_G992_5;
   pt_BisPlusInfo->ta_DSBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_PTM].s_IMAxINP = (MIN_INP_PTM_BC0_DS_G992_5 & 0x3);


   pt_BisPlusInfo->ta_DSBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_PTM].s_MinNetDataRate = MIN_NET_DATARATE_PTM_BC1_DS;
   pt_BisPlusInfo->ta_DSBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_PTM].s_MaxNetDataRate = MAX_NET_DATARATE_PTM_BC1_DS_G992_5;
   pt_BisPlusInfo->ta_DSBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_PTM].s_MinResNetDataRate = MIN_RES_NET_DATARATE_PTM_BC1_DS_G992_5;
   pt_BisPlusInfo->ta_DSBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_PTM].s_MaxLatency = MAX_LATENCY_PTM_BC1_DS_G992_5;
   pt_BisPlusInfo->ta_DSBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_PTM].uc_MaxBER = BER_PTM_BC1_DS_G992_5;
   pt_BisPlusInfo->ta_DSBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_PTM].s_IMAxINP = (MIN_INP_PTM_BC1_DS_G992_5 & 0x3);


   pt_BisPlusInfo->ta_USBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_PTM].s_MinNetDataRate = MIN_NET_DATARATE_PTM_BC0_US;
   pt_BisPlusInfo->ta_USBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_PTM].s_MaxNetDataRate = MAX_NET_DATARATE_PTM_BC0_US;
   pt_BisPlusInfo->ta_USBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_PTM].s_MinResNetDataRate = MIN_RES_NET_DATARATE_PTM_BC0_US;
   pt_BisPlusInfo->ta_USBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_PTM].s_MaxLatency = MAX_LATENCY_PTM_BC0_US;
   pt_BisPlusInfo->ta_USBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_PTM].uc_MaxBER = BER_PTM_BC0_US;
   pt_BisPlusInfo->ta_USBearerChannel[0].ta_TpsTcType[TPSTC_TYPE_PTM].s_IMAxINP = (MIN_INP_PTM_BC0_US & 0x3);


   pt_BisPlusInfo->ta_USBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_PTM].s_MinNetDataRate = MIN_NET_DATARATE_PTM_BC1_US;
   pt_BisPlusInfo->ta_USBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_PTM].s_MaxNetDataRate = MAX_NET_DATARATE_PTM_BC1_US;
   pt_BisPlusInfo->ta_USBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_PTM].s_MinResNetDataRate = MIN_RES_NET_DATARATE_PTM_BC1_US;
   pt_BisPlusInfo->ta_USBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_PTM].s_MaxLatency = MAX_LATENCY_PTM_BC1_US;
   pt_BisPlusInfo->ta_USBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_PTM].uc_MaxBER = BER_PTM_BC1_US;
   pt_BisPlusInfo->ta_USBearerChannel[1].ta_TpsTcType[TPSTC_TYPE_PTM].s_IMAxINP = (MIN_INP_PTM_BC1_US & 0x3);
#endif//if defined DANUBE_PTM_SUPPORT
   /*****************************************PTM changes End**************************************/
   pt_BisPlusInfo->t_Overhead.s_DSMSGOvhdMinRate = (int16)MIN_MSGOVERHEAD_DATARATE_DS;
   pt_BisPlusInfo->t_Overhead.s_USMSGOvhdMinRate = (int16)MIN_MSGOVERHEAD_DATARATE_US;

   pt_BisPlusInfo->ta_DSLatencyPath[0].s_MaxDataRate = MAX_DATARATE_LP0_DATAPATH_DS_G992_5;
   pt_BisPlusInfo->ta_DSLatencyPath[0].s_MaxRandD = (MAX_R_LP0_DS << 8) | MAX_D_LP0_DS;
   /***********************************PTM changes Begin****************************************/
   pt_BisPlusInfo->uc_DS_Max_Num_STM_TPS_TC = DEFAULT_NUM_DS_STM_TPS_TC;
   pt_BisPlusInfo->uc_DS_Max_Num_ATM_TPS_TC = DEFAULT_NUM_DS_ATM_TPS_TC;
   pt_BisPlusInfo->uc_DS_Max_Num_PTM_TPS_TC = DEFAULT_NUM_DS_PTM_TPS_TC;
   pt_BisPlusInfo->uc_US_Max_Num_STM_TPS_TC = DEFAULT_NUM_US_STM_TPS_TC;
   pt_BisPlusInfo->uc_US_Max_Num_ATM_TPS_TC = DEFAULT_NUM_US_ATM_TPS_TC;
   pt_BisPlusInfo->uc_US_Max_Num_PTM_TPS_TC = DEFAULT_NUM_US_PTM_TPS_TC;
   /*******************************PTM changes End****************************************/
   if (gft_DisableExtendedFrame)
   {
      pt_BisPlusInfo->ta_DSLatencyPath[0].s_OneOverS0min = ONE_OVER_S_ONETHIRD;
      pt_BisPlusInfo->ta_DSLatencyPath[0].s_D0Mask = 0;
   }
   else
   {
      pt_BisPlusInfo->ta_DSLatencyPath[0].s_OneOverS0min = MAX_ONEOVERS_LP0_DS;
#ifndef ADSL_62
      if (guc_Iridia_Revision_Number >= IRIDIA_31)
         pt_BisPlusInfo->ta_DSLatencyPath[0].s_D0Mask = MAX_D0_SUPPORT_MASK;
      else
         pt_BisPlusInfo->ta_DSLatencyPath[0].s_D0Mask = MAX_D0_SUPPORT_MASK_30;
#else
      pt_BisPlusInfo->ta_DSLatencyPath[0].s_D0Mask = MAX_D0_SUPPORT_MASK;
#endif

   }

   pt_BisPlusInfo->ta_DSLatencyPath[1].s_MaxDataRate = MAX_DATARATE_LP1_DATAPATH_DS_G992_5;
   pt_BisPlusInfo->ta_DSLatencyPath[1].s_MaxRandD = (MAX_R_LP1_DS << 8) | MAX_D_LP1_DS;

   pt_BisPlusInfo->ta_USLatencyPath[0].s_MaxDataRate = MAX_DATARATE_LP0_DATAPATH_US;
   pt_BisPlusInfo->ta_USLatencyPath[0].s_MaxRandD = (MAX_R_LP0_US << 8) | MAX_D_LP0_US;

   pt_BisPlusInfo->ta_USLatencyPath[1].s_MaxDataRate = MAX_DATARATE_LP1_DATAPATH_US;
   pt_BisPlusInfo->ta_USLatencyPath[1].s_MaxRandD = (MAX_R_LP1_US << 8) | MAX_D_LP1_US;

   pt_BisPlusInfo->t_PMD_Npar2.ft_DiagMode = 0; /* not in diag mode */
   pt_BisPlusInfo->t_PMD_Npar2.ft_ShortInit = 0; /* short Initialization mode not supported. */
}


/*************************************************************************************
  ;   Prototype: void InitGlobalVariables_BisPlusInfoRx(Adsl2AllInfo_t *pt_BisPlusInfo);
  ;
  ;   Description:
  ;
  ;      Initialize the tx global variables associated with a
  ;   BisPlus (ADSL2+) data structure (which in turn is a component of the
  ;   a InfoField structure).
  ;
  ;   Arguments:
  ;      *pt_BisPlusInfo   - pointer to BisPlusInfo structure
  ;
  ;   Return Value:
  ;      none
  ;
  ;   Global Variables:
  ;
  ;**************************************************************************************/
void InitGlobalVariables_BisPlusInfoRx(Adsl2AllInfo_t *pt_BisPlusInfo) {
   /* Initialise the LP0 receive information to be max as this information is not exchanged */
   /* and it is assumed that max values are supported for R and D */
   pt_BisPlusInfo->ta_DSLatencyPath[0].s_MaxRandD = (MAX_R_LP0_DS << 8) | MAX_D_LP0_DS;
   pt_BisPlusInfo->ta_USLatencyPath[0].s_MaxRandD = (MAX_R_LP0_US << 8) | MAX_D_LP0_US;
}

/*************************************************************************************
  ;   Prototype: void InitGlobalVariables(void);
  ;
  ;   Description:
  ;      Initialize global variables. Note that this function is called prior to initialization
  ;      of CMV arrays, and therefore should not reference any CMVs.
  ;
  ;   Arguments:
  ;      none
  ;
  ;   Return Value:
  ;      none
  ;
  ;   Global Variables:
  ;
  ;**************************************************************************************/
void   InitGlobalVariables(void)
{
   int16 s_temp;
   int16 i;
   uint8*  puc_temp_NSVendorSpec[MAX_NUM_NS_BLOCK];
   Adsl2AllInfo_t *pta_G9923xInfo[NUM_G992_3_ANNEX_SUPPORTED];
   Adsl2AllInfo_t *pta_G9925xInfo[NUM_G992_5_ANNEX_SUPPORTED];
#ifdef TARGET_HW
   int32* l_StackAddr;
#endif

   int16 j;
   DerivedFramePropLatencyPath_t *pt_PropPerLp[2];
   uint32 ul_addr, ul_data;

   gt_StructureSizeInfo.s_HnshkStructOffset = (int16)(sizeof(Adsl2AllInfo_t)>>1);
   gt_StructureSizeInfo.s_OLRPMCntStructOffset = (int16)(sizeof(OLRPMCnt_t)>>1);

   // BugFix_ALL_ALL_ALL_ResetINFO103Structure (Start_End)
   memset(&gt_INFX_CMV, 0, sizeof(gt_INFX_CMV));
   // XDSLRTFW-1481 (Start_End)
   memset(&gt_DS_StPilotDescriptorTable, 0, sizeof(gt_DS_StPilotDescriptorTable));

#ifdef PILOT_CAPTURE_518
   gul_518Pilot_Cnt = 0;
   memset(&gsa_518Pilot[0], 0, 10000);
#endif

   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
   //SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod (Start End)
   memset(&gt_ReTxConfigInfo, 0, sizeof(gt_ReTxConfigInfo));
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
   // XDSLRTFW-1481 (Start_End)
   memset(&gt_HercADSL_PLAMMap_g997_DataPathFailureStatus, 0, sizeof(gt_HercADSL_PLAMMap_g997_DataPathFailureStatus));
    //XDSLRTFW-2443 / XDSLRTFW-2462(start_end)
   memset(&guca_SNRBuf_NE, 0, (int16)(sizeof(uint8)*RX_NUM_TONES));

#ifdef DEBUG_STREAMING
    // Enable all streams by default (Tracee overwrites this setting when connecting to the device)
    memset(&gt_debugStreamConfigure,0xFF,sizeof(DebugStreamConfigure_t));
#endif
   //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
#ifdef VRX318
   gus_Zep_Tx_DelayCnt = 0; //default value
#else
   //VR9 need to wait for 4096 symbols to pull 120k bit (PTM) mode and
   //8k bit in ATM mode. This no is arrived by experiments
   //to pull data from the TX_CB.
   gus_Zep_Tx_DelayCnt = (2048 << 1); //default value
#endif  //#ifdef VRX318

   guc_s_44k_owner = 0;  //0 ==> Indicate S_44K mem is owned by DSL FW, 1 ==> S_44K is owned by PPE FW
   gus_LinkDownState_SymCount = 0;
   //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)

   //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START)
   gft_Enable_DsVnInMedley = 0;
   gus_NumbDsVnBrkPoints = 0;
   gt_NearEndParam.us_VN_TCM_Supported &= ~0x0100; //Used Bitmask as per VR9 Message Specification 1.6.1
   //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (END)

   //Initialize the flag used for Scaling Sync Symbol for DMT mode as per Standard for
   //ALCATEL LITE DSLAM sending CO Chip ID as "GENERIC_CO" (i.e. 0)
   gft_SyncScalingForGenericCOinDMT = 0;

   /* for cocomo testing limit the max CWSize to be 240; this is because of bm limitation of
      TDP CO, will be removed in next upgrade*/
#ifdef WIN32
   gs_max_CWSize = 247;
#else
   gs_max_CWSize = 255;
#endif

   // Feature_ALL_ALL_ALL_PrevExceptionsCMV (Start)
   STATArray[STAT_PREV_EXCEPTION_STATE] = (int16) (gus_ExceptionState_Persis);
   STATArray[STAT_PREV_EXCEPTION_CODE] = (int16) (gus_ExceptionCode_Persis);
   // Feature_ALL_ALL_ALL_PrevExceptionsCMV (End)
   gs_max_fine_gain =  638;      // 2.49dB in Q 8.8 ( this is lowered as linear value from the code is
   // rounded to higher value, so that final dB converted is limited to 2.5dB)
   gs_min_fine_gain = -640;      // -2.5dB in Q8.8

   gft_extrafinegainallocated = 0; // reset the flag

   gs_finegainadjust_bis = 0;
   gs_HLogReportDelta = HLOG_REPORTING_DEFAULT_ADJUST;

   /*  SNR's (in dB) required for QAM */
   gsa_ConstellationSNR[0] = 0x0B4F;   /*  11.31 dB =  1 bit (NOT USED) */
   gsa_ConstellationSNR[1] = 0x0B4F;   /*  11.31 dB =  1 bit (NOT USED) */
   gsa_ConstellationSNR[2] = 0x0E51; /*  14.32 dB =  2 bits  */
   gsa_ConstellationSNR[3] = 0x131C;   /*  19.11 dB =  3 bits */
   gsa_ConstellationSNR[4] = 0x154F;   /*  21.31 dB =  4 bits */
   gsa_ConstellationSNR[5] = 0x1875;   /*  24.46 dB =  5 bits */
   gsa_ConstellationSNR[6] = 0x1B8A;   /*  27.54 dB =  6 bits */
   gsa_ConstellationSNR[7] = 0x1E97;   /*  30.59 dB =  7 bits */
   gsa_ConstellationSNR[8] = 0x219C;   /*  33.61 dB =  8 bits */
   gsa_ConstellationSNR[9] = 0x24A1;   /*  36.63 dB =  9 bits */
   gsa_ConstellationSNR[10] = 0x27A6; /*  39.65 dB = 10 bits */
   gsa_ConstellationSNR[11] = 0x2AA8; /*  42.66 dB = 11 bits */
   gsa_ConstellationSNR[12] = 0x2DAB; /*  45.67 dB = 12 bits */
   gsa_ConstellationSNR[13] = 0x30AE;   /*  48.68 dB = 13 bits */
   gsa_ConstellationSNR[14] = 0x33B0; /*  51.69 dB = 14 bits */
   gsa_ConstellationSNR[15] = 0x36B3; /*  54.70 dB = 15 bits */

   /* =============================================================================== */
   /* Initialize modem status parameters */
   /* =============================================================================== */
   guc_TdqTrainingState =TRAINING_WAITING;         /*  TDQ training status flag */
   guc_FdqTrainingState= TRAINING_WAITING;         /*  FDQ training status flag */
   guc_EcTrainingState = TRAINING_WAITING;         /*  DEC training status flag */
   guc_AecTrainingState= TRAINING_WAITING;
   gft_BitloadState = TRAINING_WAITING;            /*  Bitloading status flag */
   guc_SnrCalcState = TRAINING_WAITING;              /*  SNR calculation status flag */
   guc_AccumState = TRAINING_WAITING;            /*  Accumulation status flag */
   guc_RxSyncFrameProcessingState = TRAINING_WAITING;
   guc_ShowTimeRxState = TRAINING_WAITING;         /* Showtime task layer Rx initialization status flag */
   guc_ShowTimeTxState = TRAINING_WAITING;         /* Showtime task layer Tx initialization status flag */
   guc_RxDataPumpState = TRAINING_WAITING;         /* Showtime DSL engine Rx initialization status flag */
   guc_RxToneOrderLoadState = RXTONEORDERLOAD_WAITING;
   guc_TxDataPumpState = TRAINING_WAITING;         /* Showtime DSL engine Tx initialization status flag */
   guc_PgaTrainingState = TRAINING_WAITING;

#ifdef DANUBE
   guc_TxIlvInitState = TXILV_INIT_BKGD_WAITING;      /* Danube ILV initialization status flag */
   guc_RxDilvInitState = RXDILV_INIT_BKGD_WAITING;    /* Danube DILV initialization status flag */
#endif

   /* =============================================================================== */
   /* Initialize modem configuration parameters */
   /* =============================================================================== */

#ifndef TARGET_HW
   gus_TxSineGain = UNITY_SINE_GAIN; /*  applied Tx gain */
   gus_TxGain_NoCutBack    = UNITY_SINE_GAIN;
   gus_TxGain_NoCutBack_3A = UNITY_SINE_GAIN;
   gus_TxGain_NoCutBack_3L = UNITY_SINE_GAIN;
   gus_TxGain_NoCutBack_3M = UNITY_SINE_GAIN;
   gus_FORCE_TX_FILTER     = 0; // 0=OFF: DO not Force
#else
   gus_TxSineGain = 0; /*  so that cpe transmits silence after reboot */
   //XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(start_end)
   gs_IncBitInBinReduced = 0;
   gs_OlrReq = 0;

#ifdef  ISDN  // Only for Annex - B
   // IOP_DS_DMT_TI_ReduceHSPwrToGetLowDSPCB (Start_End)
   gs_Required_TxPCB = 0;
   // 20log(5039/4096) -> 1.8dB
   //1.3dB - mahesh
   //XDSLRTFW-785: Bug_All_All_All_PsdAfeReg [Start_End]
   //gus_TxGain_NoCutBack = 5039; //Gus_TxGain_NoCutback for BJ hybrid
   // As per Kai recommendation reduced HSK PSD by 0.1 db //20log(4981/4096) = 1.7dB
   //gus_TxGain_NoCutBack = 4981;
   //With Annex 5J filter HSK power is 2dB more compared with 5B filter set, So we are reducing by 2dB, will compensate later at start of training
   gus_TxGain_NoCutBack = 3526;//7034;//3956; //1996;//3956; // -2dB
   //VR9_AnxB_HybImp Start
   gs_HybStartTone = HYB_START_TONE;
   gs_dbg_DecimPoints = HYB_DECIM_POINTS_3B1B;
   gs_HybEndTone = gs_HybStartTone + (HYB_DECIM_FACTOR * gs_dbg_DecimPoints);
   //VR9_AnxB_HybImp End
#else
   // 20log(5462/4096) -> 2.5dB
   //XDSLRTFW-785: Bug_All_All_All_PsdAfeReg [Start_End]
   //XDSLRTFW-912: Perf_DS_AnxA_All_GhsBoost[Start_End]
//   gus_TxGain_NoCutBack = 5920;
   //20*log10(2816/4096) = -3.2545dB
   gus_TxGain_NoCutBack = 2816; //1996;   //with pofi 8dB
   gus_TxGain_NoCutBack_3A = 5650;
   gus_TxGain_NoCutBack_3L = 3460;
   gus_TxGain_NoCutBack_3M = 4096;

   gs_HybStartTone = HYB_START_TONE;
   gs_dbg_DecimPoints = HYB_DECIM_POINTS;
   gs_HybEndTone = gs_HybStartTone + (HYB_DECIM_FACTOR * gs_dbg_DecimPoints);

#endif

#endif //TARGET_HW



   gs_Medley_OffsetXtra = 0;
   gus_TxGainCutBackFactor = 26029;    /* The Tx Gain will be computed on the fly */
   /* 26029 represents 10^(-0.1) in the 1.15 format */

   gsa_TxToneBuf = gsa_TxToneBufArray;   // Always use this pointer rather than the array name.

   gft_DecimatorPhaseSelectDone=FALSE;
   gs_MaxToneForFast = -1;                           /* Number of tones whose bits are allocated to fast path */
   gs_FirstNonzeroTone = 0;                     /* Set by tone ordering function */
   gs_FirstNonzeroTxTone = 0;                     /* First non zero Tx tone index. */
   gs_FirstNonzeroRxTone = 0;                     /* First non zero Rx tone index. */
   gft_BitloadOK = FAIL;
   gt_FineGainInfo.s_ExcessMarRedDB = 0;                     // Excess Margin reduction in DB (Q8.8)
   gs_RequestedRxMaxMargin = (64*256);            // Requested Max Margin in dB (Q8.8)
   gt_FineGainInfo.s_ExcessMarFGReduction = 0x2000;            // Fine gain reduction = DecimalGain(-gt_FineGainInfo.s_ExcessMarRedDB) [3.13 format]
   gs_ExcessMarFDQBoost = 0x2000;               // FDQ boost = 1/(Fine gain reduction) [3.13 format]
   gsa_TotalCodingGain[0]=0;
   gsa_TotalCodingGain[1]=0;

   //XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (Start)
   // initialize all US-perf settings to '0'
   gus_TxPathControl = 0x0;
   gs_DEC_SHIFT = 0;
   gs_DEC_SHIFT_INIT = 0;
   //XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (End)

   guca_RSCodingGain[0] = 0;
   guca_RSCodingGain[1]= RS_CODING_GAIN_2;
   guca_RSCodingGain[2]= RS_CODING_GAIN_4;
   guca_RSCodingGain[3]= RS_CODING_GAIN_6;
   guca_RSCodingGain[4]= RS_CODING_GAIN_8;
   guca_RSCodingGain[5]= RS_CODING_GAIN_10;
   guca_RSCodingGain[6]= RS_CODING_GAIN_12;
   guca_RSCodingGain[7]= RS_CODING_GAIN_14;
   guca_RSCodingGain[8]= RS_CODING_GAIN_16;

   gs_RxExtraBits = 0;
   guc_MaxAllocBitsPerTone = RX_MAX_BITS_PER_TONE;
   gsa_RxFineGainPlusBitChannel[RX_LAST_CHANNEL+1]=0;

   gus_SyncOffset = 0;                        /*  offset in words to beginning of code word */
   gus_SyncOffset_Corr_Method = 0;               /*  offset in words to beginning of code word, calculated by max correlation method */
   gs_PreSyncOffset = -1;

   //=================================================
   /* Flags and indicators */
   //=================================================
   //XDSLRTFW-181 VR9_VRX318_AFE_Init_Fail_Indication (START)
  #if 0
   gus_RC_Measure_ExceptionCode = E_CODE_NO_ERROR;
   gus_RC_Calib_ExceptionCode = E_CODE_NO_ERROR;
   gus_GLP_ExceptionCode = E_CODE_NO_ERROR;
  #endif
   gul_ExceptionCode = E_CODE_NO_ERROR;
   //XDSLRTFW-181 VR9_VRX318_AFE_Init_Fail_Indication (START)
   gus_ExceptionCode = E_CODE_NO_ERROR;
   gft_RCExch1RcvFlag   = NOT_RECEIVE;            /*  flag indicating the status of reception of C_Exch1 */

   gft_ShowTimeFirstPassTx = FALSE;               /*  flag to set intial buffer sizes for showtime TX */
   gft_ShowTimeFirstPassRx = FALSE;
   gft_RS_Support      = 16;                  /*  flag to indicate supported Reed-Solomon code length (8 or 16) */
   gft_TransferMode      = ATM;                      /* flag indicating if ATM or STM bit is set in G.994.1 MS message */
   //   gft_CutBackOn         = TRUE;                  /*  TX PowerCutback Enable Flag FALSE = cut back disabled */
   gft_FineGainOn      = TRUE;                  /*  flag indicating if US fine gain should be used (TRUE) or not (FALSE) */
   gft_ShowTimeSnrFlag   = TRUE;               /*  flag indicating if SNR is calculated in showtime */
   /*  FALSE - not calculated, TRUE - calculated */

   gft_SnrOrFdqUpdate = 0;    /* start with FDQ updates in showtime */
   gft_ShowtimeSnrUpdateFlag = FALSE;


   gft_RxFdqDoneIntOnly =TRUE;
   gft_DisableGetRxTones = FALSE;
   gft_LoadEngineFFTInput = FALSE;
   gft_GetEngineFFTOutput = FALSE;
   gft_GetEngineFFTOutputDone = FALSE;
   gft_EnableNoiseShaping = TRUE;
   gft_ReorderDEC = FALSE;
#ifndef ISDN
   // IOP_A_US_T1413_OldIFX_SwitchToTIVID (START_END)
   gft_IFTN_T1413LongLoop_TIVID = FALSE;
#endif

   gus_tx_config_num = 32;                     /*  configuration number for TX */
   gus_rx_config_num = 31;
   gs_UC=0;                  /*  Absolute Upstream Fast Retrain Power Cutback; 0 in full rate*/
   gs_RDC = 0;
   gs_DPF = 0;
   gs_MuxFrameCntRxFastPath=RX_SYMBOLS_PER_SFRAME;
   gs_HandShake_Cnt=0;                                 /* record the number of times going through GHS */
   gft_EscFromFR_Flag = FALSE;                  /*  Flag indicating G.hs is initiated from Fast Retrain */
   guc_received_ACK2_count=0;
   gft_AutoRestartFlag = FALSE;

   //VR9 AFE
   //ADSL mode use 1dB analog margin, 1dB margin for ADC transfer and 1.5dB margin for CF (6.3 instead of 5.3).
   //This leads in total to 3.5dB margin for the PGA training.
   //gs_PGA_margin = 0x0380; //8.8 format
   //PD_DB is changed for VR9_AFE according to the crest factor 6.3 and 0dB margin for ADC transfer and 1dB margin
   //as analog margin. This is done as per the input from Stefan & Tina
   gs_PGA_margin = 0x0100; //8.8 format
   gs_PGA_margin_AGC1 = (int16)0xFF00;
   gs_PGA_margin_AGC2 = (int16)0x0200;

#ifdef ISDN
   //Annex B
   gusa_InitHybridSettings= &gusa_HybridSetting_ADSL_B[0][0];
   guc_HybNumHybrids = VRX518_ANX_ABJ_NUM_HYBS_ANNEXB; //use different Macro for Anx A&B if differs
#else
   //Annex A
   gusa_InitHybridSettings= &gusa_HybridSetting_ADSL_A[0][0];
   guc_HybNumHybrids = VRX518_ANX_ABJ_NUM_HYBS_ANNEXA; //use different Macro for Anx A&B if differs
#endif

   gs_PGA_margin_Threshold = 0x0500;            /*  empirical threshold to distinguish the pga margin limited loops */
   gs_PGA_set = 0;                           /*  current PGA setting, in dB (Q8.8) */
   gs_PGA_before_lineprobe =0;                  /*  PGA value before R_LINE_PROBE_TX state */
   gs_PGA_Reg_Setting=0;
   gs_PGA_required_In_GHS = 0;
   gs_PGAStepDown = 0;

#ifdef VRX518
   gs_pga_margin_AnxL_BTLoops = 0; //extra PGA margin required to be used for AnxL Bridge tap loops, TBD
   gs_PGA_margin_delta_AnxL_BTloops = 0;
   OPTNArray[OPTN_AlgControl2] &= ~OPTN_NoiSMA_VR9_oPOTS;
   OPTNArray[OPTN_AlgControl2] |= VRX518_Margin_delta_3L_BDCM;

#else
   // With 1.5 dB AnxL BT loop PGA margin DS CRC's and link drop was observed in BRCM FG11 CO at milpitas,
   // In order to avoid showtime DS CRC and link drop due to DS CRCs, 4.5dB PGA margin was used for AnxL mode.
   // It was tested with Gmx CO, we don't see the data rate degratation as compared to 1.5dB PGA margin.
   gs_pga_margin_AnxL_BTLoops = 0x480; //extra PGA margin required to be used for AnxL Bridge tap loops, with hybrid choice between 3 and 31
   gs_PGA_margin_delta_AnxL_BTloops=0;
      OPTNArray[OPTN_AlgControl2] |= OPTN_NoiSMA_VR9_oPOTS;
      OPTNArray[OPTN_AlgControl2] &= ~VRX518_Margin_delta_3L_BDCM
#endif
   gs_PGA_margin_delta_DMT_VR9 = 0;//0x300; TBD


#ifdef HERCULES_ADSL_CPE
   // Initialize AFE register acces structure
   gt_AFEConfig.us_AFERegAddr = 0;
   gt_AFEConfig.us_AFERegData = 0;
   gt_AFEConfig.us_AFERegOp = 0x0; // 0 = ready (no op); 1 = read; 2 = write

#endif
   // IOP_DS_BisPlus_CNXT_CopyINPFromCLToBitloading (START_END)
   gt_INFX_CMV.s_DFE_Options |= CMV_DFE_CHOOSE_MININP_FROM_CL_CNXT_ENABLE;

   // PERF_US_BisPlus_CNXT_Reduce_US_PCB_By_3_dB (START)
#ifndef ISDN   // Only for Anx-A
   // SMS00768526: IOP_DS_BisPlus_CNXT_D57E67_RS_INP0DELAY2MS (START_END)
   // SMS00815166 IOP_DS_BisPlus_CNXT_FramingLimitation (Start_End)
   // SMS00905459 IOP_DS_BisPlus_CNXT_D57E67_Disable_RS_DELAY2MS (Start_End)
   // XDSLRTFW-332 IOP_A_DS_BisPlus_CNXT_BitswapDuetoRFI (START - END)
   // Enabled as we do it in Danube.
   gt_INFX_CMV.us_OperatorSpBits |= CMV_TO_DISABLE_CNXT_D57E67_BISPLUS_RS_DELAY2MS;
   //SMS00910375 IOP_US_BISPlus_CNXT_USRateImprovement (START)
   gt_INFX_CMV.us_OperatorSpBits2 &= ~CMV_TO_ENABLE_CNXT_US_RateImprovement;
   //SMS00910375 IOP_US_BISPlus_CNXT_USRateImprovement (END)
   //PERF_US_ALLannexA_New_FTspeciffic (Start)
   gt_INFX_CMV.s_DFE_Options &= ~(CMV_INFX_DFE_FT_INTERP13_ENABLE);  // 0xFF7F To Disable
   // gt_INFX_CMV.s_DFE_Options |= CMV_INFX_DFE_FT_INTERP13_ENABLE; //0x0080 To Enable
   //PERF_US_ALLannexA_New_FTspeciffic (End)
   //SMS01261659 BugFix_DS_BisPlus_CNXT_Enable_SRA(Start_End)
   gt_INFX_CMV.s_DFE_Options |= CMV_TO_ENABLE_CNXT_SRA_FIX;

#endif   // ifndef ISDN
   // SMS01221899 Feature_DS_All_All_EnableOneStepSRA (START_END)
   //XDSLRTFW-1313 XDSLRTFW-1208 : BugFix_DS_BisPlus_All_TR105SRAChanges (start)
   //gt_INFX_CMV.us_OperatorSpBits2 &= ~CMV_TO_ENABLE_ONE_STEP_SRA;
   gt_INFX_CMV.us_OperatorSpBits2 |= CMV_TO_ENABLE_ONE_STEP_SRA;

   gt_INFX_CMV.us_SRA_IOP_Bits &= ~CMV_TO_ENABLE_SRA_SEARCHING_DELTA_LP;
   gt_INFX_CMV.us_SRA_IOP_Bits &= ~CMV_TO_ENABLE_SEARCHING_DELTA_MarginOverINP;
   gt_INFX_CMV.us_SRA_IOP_Bits &= ~CMV_TO_DISABLE_SRA_FRAMING_CHECK;
   gt_INFX_CMV.us_SRA_IOP_Bits |= CMV_TO_ENABLE_SRA_MAXLATENCY_CHECK;
   gt_INFX_CMV.us_SRA_IOP_Bits |= CMV_SRA_INP_FRAMING_CHECK;
   gt_INFX_CMV.us_SRA_IOP_Bits &= ~CMV_SRA_TO_ENABLE_MINOVERHEAD_GHS_CHECK;
   gt_INFX_CMV.us_SRA_IOP_Bits &= ~CMV_SRA_ACHIEVE_TARGETMARGIN;


#if 0
   gt_INFX_CMV.us_SRA_IOP_Bits |= CMV_TO_ENABLE_SRA_MAXLATENCY_CHECK_DELTA_LP;
   gt_INFX_CMV.us_SRA_IOP_Bits |= CMV_SRA_TO_ENABLE_MINOVERHEAD_GHS_CHECK;
   //gt_INFX_CMV.us_SRA_IOP_Bits &= ~CMV_TO_ENABLE_SRA_SEARCHING_DELTA_LP;
   gt_INFX_CMV.us_SRA_IOP_Bits &= ~CMV_TO_ENABLE_SRA_INP_CHECK_DELTA_LP;
   //XDSLRTFW-1313 XDSLRTFW-1208 : BugFix_DS_BisPlus_All_TR105SRAChanges (end)
#else
   // This is needed for TR105E SRA test case to pass
   gt_INFX_CMV.us_SRA_IOP_Bits |= CMV_SRA_TO_ENABLE_MINOVERHEAD_GHS_CHECK;
   // SRA to trigger in capped rate cases.
   gt_INFX_CMV.us_SRA_IOP_Bits |= CMV_TO_ENABLE_SEARCHING_DELTA_MarginOverINP;
#endif
   //XDSLRTFW-1564 / XDSLRTFW-1665 (Start_End)
   gt_INFX_CMV.us_SRA_IOP_Bits &= ~CMV_FOR_MARGIN_ON_15BITS_TONES;

   //XDSLRTFW-2031 Enhc_A_DS_BisPlus_BRCM_WorkaroundForAskeyLabTesting (START)
#ifndef ISDN
   gt_INFX_CMV.us_SRA_IOP_Bits &= ~CMV_TO_ENABLE_WORKAROUND_ASKEY_LAB;
#endif
   //XDSLRTFW-2031 Enhc_A_DS_BisPlus_BRCM_WorkaroundForAskeyLabTesting (END)


#ifdef ISDN   // Only for Annex-B
   //XDSLRTFW-3958 SetDefaultUsTones29to57_oISDN (START_END)
   gt_INFX_CMV.us_OperatorSpBits = CMV_TO_FORCE_KPN_TSSI_US_BIN_START;
   //gt_INFX_CMV.us_OperatorSpBits &= ~CMV_ENABLE_IOP_CNXT_REDUCE_US_PCB_BY_3dB; //It is not doing anything.
#endif
   //SMS01501984 SMS01294435 Feature_DS_BisPlus_ALL_DisableTrainingREINDetection (START_END)
   gt_INFX_CMV.us_OperatorSpBits3 &= ~CMV_TO_DISABLE_REIN_ADAPTATION_TRAINING;

   //XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (Start)
   gt_INFX_CMV.us_OperatorSpBits3 |= (CMV_TO_ENABLE_FAST_BITSWAP |CMV_TO_ENABLE_BITSWAP_EVACUATION);
   //gt_INFX_CMV.us_OperatorSpBits3 |= CMV_TO_ENABLE_ADSL2PLUS_ATN_BenchmarkAR7;    /* XDSLRTFW-2390 */
   //XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (End)

   // XDSLRTFW-238 IOP_A_US_Plus_CNXT_MidloopRateImprove (Start_End)
   gt_INFX_CMV.us_OperatorSpBits4 |= CMV_TO_ENABLE_CNXT_Midloop_USPerf;
   // PERF_US_BisPlus_CNXT_Reduce_US_PCB_By_3_dB (END)
#ifndef ISDN
   // ADSLRTFW-1362 IOP_A_DS_Plus_ALL_TelefonicaSparnexDSCRCs (Start_End)
   gt_INFX_CMV.us_OperatorSpBits4 &= ~CMV_TO_ENABLE_FIX_Sparnex_DS_CRC;
   //XDSLRTFW-406  IOP_A_DS_Plus_BRCM_Set_MAXNOMATP_ToZero (START_END)
   gt_INFX_CMV.us_OperatorSpBits4 &= ~CMV_TO_ENABLE_BRCM_MAXNOMATP_DS_SettoZero;
   //XDSLRTFW-1590 IOP_A_DS_ALL_ShortenTrainingTime_AfterPowerup (START_END)
   gt_INFX_CMV.us_OperatorSpBits4 |= CVM_TO_Enable_GHS0000_TIVID_Retrain;
   //XDSLRTFW-1592 IOP_A_DS_ADSL1_CTLM_AddCMV_TxPowerCut (START_END)
   gt_INFX_CMV.us_OperatorSpBits4 |= CMV_TO_ENABLE_CTLM_ShortLoop_TxPowerCut;
#endif
   // XDSLRTFW-374 (ADSLRTFW-1361): IOP_DS_PLUS_FR_TelefonicaOnSite_INP_REIN_Tests (start)
   // ADSLRTFW-1361: Fix for "INP_REIN_Tests at Telephonica Spain (INP=8 60pps REIN Tests)"
   // New procedure is uesd for choosing the tones used for Sync symbol detection in Showtime.
   // Please note that same list of tones is also used by HW for L2 exit.
   gt_INFX_CMV.us_OperatorSpBits4 &= ~CMV_TO_ENABLE_NEW_REVSEG_DET_TONE_SEL;
   // XDSLRTFW-374 (ADSLRTFW-1361): IOP_DS_PLUS_FR_TelefonicaOnSite_INP_REIN_Tests (end)
   // XDSLRTFW-383 : Increase DS rates in VR9 against Luscent Stinger DSLAM in ADSL2/2plus mode for
   // Stright gauge loops > 3000M / 9Kft
   //XDSLRTFW-383 Enh_DS_ADSL2_CNXTIKNS_DSRate (start_End)
   gt_INFX_CMV.us_OperatorSpBits5 &= ~CMV_TO_ENABLE_DS_MARG_DELTA_3A_5A;

   //XDSLRTFW-1586 IOP_DS_A_GMX_DMT_LowRate (START_END)
   gt_INFX_CMV.us_OperatorSpBits5 &= ~CMV_TO_ENABLE_GMX_DMT_DSPerf;

   //XDSLRTFW-1584 XDSLRTFW-1585 IOP_US_BISPlus_CNXT_USRateImprovement
   gt_INFX_CMV.us_OperatorSpBits5 |= CMV_TO_ENABLE_CNXT_USPerf_E67;

#ifndef ISDN
   //XDSLRTFW-626: Enh_all_all_TelfonicaLongTraining (Start_End)
   gt_INFX_CMV.us_OperatorSpBits2 |= CMV_CGALF1_TIMEOUT_SILENT1;
#endif

   //ADSLRTFW-1400_XDSLRTFW-1596_IOP_DS_BisPlus_BRCM_ATT_DisableAnxL  (START_END)
   gt_INFX_CMV.us_OperatorSpBits4 &= ~CMV_TO_ENABLE_ATT_DISABLE_ANNEXL_SHORTLOOP;

   //ADSLRTFW-1404_XDSLRTFW-1594_IOP_A_DS_CTNW_BisPlus_ShortenGHS (START_END)
   gt_INFX_CMV.us_OperatorSpBits4 &= ~CMV_TO_ENABLE_CTNW_SHORTEN_GHS;

   //ADSLRTFW-1412_XDSLRTFW-1591_IOP_A_DS_ADSL1_ECI_PLSE_LinkDrop (START_END)
   gt_INFX_CMV.us_OperatorSpBits4 &= ~CMV_TO_ENABLE_ECI_PLSE_IOP_ATT;
   // XDSLRTFW-364: Feature_DS_All_All_NLNF_TrainingInfo (START)
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
#ifndef ISDN
   //Enable NLNF state machine by default
   gt_ApiOptions.us_Opt_Offset0 |= CMV_BIT2_TO_ENABLEE_NLNF_STARTUP;
   // Reset training info IBs: [9:8:7:6:5]
   gt_nlnf_metrics_ibs.us_NlnfIbs &= 0xFC1F;
#endif
#endif //#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
   // XDSLRTFW-364: Feature_DS_All_All_NLNF_TrainingInfo (END)

   //XDSLRTFW-322 Fix_AB_US_BisPlus_All_EnhancedFramingMovedToDSLCMVgroup (Start)
   gt_ApiOptions.us_Opt_Offset0 |= CMV_TO_ENABLE_US_INLV_DEPTH_STD;
   //XDSLRTFW-322 Fix_AB_US_BisPlus_All_EnhancedFramingMovedToDSLCMVgroup (End)

   gus_DSL_FW_InternalControl = DSL_ERASE_SRAM_VARS;

   // XDSLRTFW-2442 (Start_End)
   gs_lowOscOffset_ppm = -45; //difference of initOffset in ppm b/w low and High Osc levels.

   // XDSLRTFW-508 Fix_DS_All_All_SuppressCounterWriteFromDSLAPI(Start_End)
   gt_InteropOptions.us_InterOp_Bits0 |= (RESET_CRC_FEC_COUNTERS_AT_LINKSTART_TO_0_FOR_EOC_REPORTING);

   //XDSLRTFW-444 ADSLRTFW-1455 Feature_B_DS_BisPlus_ALL_L2Exit (Start_End)
   OPTNArray[OPTN_Power_Management] |= (OPTN_L2_Exit_Based_on_RFI);
   // XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [Start]
   TESTArray[TEST_Control3] |= TEST_L2ModeAmd4G9923_L2LpConditionDIS;
   // XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [End]

   //XDSLRTFW-1236(START_END)
   //Enable L3 mode by default
   TESTArray[TEST_Control3] &=(~TEST_DisableL3Mode);

   // XDSLRTFW-508 Fix_DS_All_All_SuppressCounterWriteFromDSLAPI(Start)
   gula_CRC_count[0] = 0;
   gula_CRC_count[1] = 0;
   gusa_CRC_count[0] = 0;
   gusa_CRC_count[1] = 0;
   gula_CorrectedRSErrors[0] = 0;
   gula_CorrectedRSErrors[1] = 0;
   gsa_CorrectedRSErrors[0] = 0;
   gsa_CorrectedRSErrors[1] = 0;
   // XDSLRTFW-508 Fix_DS_All_All_SuppressCounterWriteFromDSLAPI(End)

   gula_CRC_count_Prev[0] = 0;
   gula_CorrectedRSErrors_Prev[0] = 0;
   gula_UncorrectableRSCodewordCnt_Prev[0] = 0;
   gula_CRC_count_Prev[1] = 0;
   gula_CorrectedRSErrors_Prev[1] = 0;
   gula_UncorrectableRSCodewordCnt_Prev[1] = 0;

   // XDSLRTFW-575: Counter Write back in ADSL mode (Start)
#ifdef ADSL_62
   gula_UncorrectableRSCodewordCnt[0] = 0;
   gula_UncorrectableRSCodewordCnt[1] = 0;
#else
   gs_UncorrectableRSCodewordCnt[0] = 0;
   gs_UncorrectableRSCodewordCnt[1] = 0;
#endif

   //Setting to UNAVAILABLE during training
   gft_line_unavailable = TRUE;
   // XDSLRTFW-575: Counter Write back in ADSL mode (End)

   //XDSLRTFW-201 Feature_US_ALL_ALL_LPR (Start_End)
   gus_Set_LPR = 0;

   //XDSLRTFW-316  PLL BW is changed based on SNR during Medley.
   // This change in the bandwidth helps to reduce the DS CRC
   // caused glitches introduced by TX SRC.
   gt_INFX_CMV.us_OperatorSpBits5 |= (CMV_TO_BYPASS_PLL_BW_CHANGE_IN_SHOWTIME);

   // Enhc_DS_ALL_ALL_ByPassPLLBWIncrease(Start_End)
   gt_INFX_CMV.us_OperatorSpBits6 |= CMV_TO_DISABLE_PLL_BW_CHANGE_IN_SHOWTIME;

   // XDSLRTFW-358 Enh_DS_BisPlus_CNXT_StressTest (start_end)
   gt_INFX_CMV.us_OperatorSpBits6 &= ~CMV_TO_ENABLE_EXTRA_Log2NumShowtimeSNRTrainingSymbols;

   // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2
   // Default use new algorithm to decide on discard frame.
   gt_INFX_CMV.us_OperatorSpBits6 |= (CMV_TO_TOGGLE_NewAndOldDiscardFrameAlgo);

   // ADSLRTFW-1549 IOP_US_ADSL1_ADI_IncreaseTxMedleyNoise (Start_End)
   gt_INFX_CMV.us_OperatorSpBits6 |= CMV_TO_INCREASE_TX_MEDLEY_NOISE_ADI;
   //XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start_End): Enable RFI notching by default
   gt_INFX_CMV.us_OperatorSpBits6 &= ~CMV_TO_DISABLE_RFI_NOTCH;
   //XDSLRTFW-471 Enhance_DS_ALL_ALL_REIN_IMMUNITY_TRAINING (Start_End): Disable REIN detection and adaptation of framing by default
   gt_INFX_CMV.us_OperatorSpBits6 &= ~CMV_TO_ENABLE_REIN_DETECTION_TRAINING_AND_CHANGE_FRAMING;

   gt_INFX_CMV.us_OperatorSpBits7 &= ~(CMV_TO_FORCE_DSPCB_BDCM_ANNEXJ);   //XDSLRTFW-2285 (Start_End)
   gt_INFX_CMV.us_OperatorSpBits7 &= ~(CMV_ENABLE_NoiseMa_ISDN_FBNoise);  //XDSLRTFW-2248 (Start_End)

   // XDSLRTFW-332 IOP_A_DS_BisPlus_CNXT_BitswapDuetoRFI (START)
   //Enabled by default for Orange Spain customer who is having E67 CNXT CO
   //which supports Lp reduction of more than 1Lp bit at a
   //time single bitswap request. Enable this
   //bit for other CNXT CO's if the CNXT CO support Lp reducion of more
   // than 1bit in Bis& Plus mode.
   gt_INFX_CMV.us_OperatorSpBits5 |= CMV_TO_BYPASS_Bis_1bit_LpReduction_CNXT; //Enabled for Orange Spain Bis Mode
   gt_INFX_CMV.us_OperatorSpBits5 |= (CNXT_1BIT_LpREDUCTION << 9); //Plus mode 1bit LpReduction
   // XDSLRTFW-332 IOP_A_DS_BisPlus_CNXT_BitswapDuetoRFI (END)

   //PERF_US_T1413_T1&CNXT_64ptIFFT (START)
   //64pt IFFT emulation was enabled by default for TI & CNXT CO's in T1413 mode
   gt_INFX_CMV.us_OperatorSpBits5 |= (IFFT64_T1413_CNXT_TI_ENABLED << 14);
   gft_IFFT64_T1413_TxImages = 0;
   //PERF_US_T1413_T1&CNXT_64ptIFFT (END)

   //1degree less =>s_LATN_PLUS_A  =>  31 (31.0294) (31/32)*2^14 =>15872;
   //2degree less =>s_LATN_PLUS_A  =>  30 (29.9609) (30/32)*2^14 =>15360;
   //3degree less =>s_LATN_PLUS_A  =>  29 (28.9268) (29/32)*2^14 =>14848;
   //4degree less =>s_LATN_PLUS_A  =>  28 (27.9249) (28/32)*2^14 =>14336;
   //XDSLRTFW-387 IOP_DS_ADSL2Plus_All_DSATNBias (start_end)
        gt_INFX_CMV.s_LATN_PLUS_A = 12800;    //This value was recommended by Xavier for Telmex /* XDSLRTFW-2390 */
   //Feature_DS_ADSL1_ALL_AuxPilotMinSNR_Threshold (START)
   gt_INFX_CMV.us_OperatorSpBits6 |= AUX_PILOT_MIN_SNR_THRESHOLD;
   //Feature_DS_ADSL1_ALL_AuxPilotMinSNR_Threshold (END)
   // Moved to operator bit
   //gt_INFX_CMV.us_OperatorSpBits7 |= CMV_MinOvhd_DataRate_32Kbps; //XDSLRTFW-2376
   gft_DDPilot = DD_PILOT_OFF;

   gft_AuxPilot = AUX_PILOT_ENABLE;
   gs_MinAuxPilotToneIdx = 48;
   gs_MaxAuxPilotToneIdx = 224;

   //XDSLRTFW-1815 : DS CRCs and drop from showtime
   //IKNS CO4 doesn't support 1 bit loading, workaround is to change to 2
   //Disabled by default, just a place holder
   //gt_INFX_CMV.us_OperatorSpBits7 |= CMV_TO_ENABLE_IKNS_CO4_FIX;

#ifdef TARGET_HW
   gl_initfreqoffset = SRC_INITIAL_FREQ_OFFSET;
#else
   gl_initfreqoffset = 0x0;
#endif
   gft_Enable_IFFT64 = 0;  /* Flag used for enabling the IFFT64 */
   gft_ShortRSilent0 = FALSE;
   gs_NumT1Restarts = 0;

   /* QAM encoder gain table */
   gsa_QAMEncGainTab[0] =ENCGAIN2;
   gsa_QAMEncGainTab[1] =ENCGAIN2;
   gsa_QAMEncGainTab[2] =ENCGAIN2;
   gsa_QAMEncGainTab[3] =ENCGAIN3;
   gsa_QAMEncGainTab[4] =ENCGAIN4;
   gsa_QAMEncGainTab[5] =ENCGAIN5;
   gsa_QAMEncGainTab[6] =ENCGAIN6;
   gsa_QAMEncGainTab[7] =ENCGAIN7;
   gsa_QAMEncGainTab[8] =ENCGAIN8;
   gsa_QAMEncGainTab[9] =ENCGAIN9;
   gsa_QAMEncGainTab[10] =ENCGAIN10;
   gsa_QAMEncGainTab[11] =ENCGAIN11;
   gsa_QAMEncGainTab[12] =ENCGAIN12;
   gsa_QAMEncGainTab[13] =ENCGAIN13;
   gsa_QAMEncGainTab[14] =ENCGAIN14;
   gsa_QAMEncGainTab[15] =ENCGAIN15;

   /* QAM decoder constellation gain table */

   gsa_QAMDecGainTab[0] =DECGAIN2;
   gsa_QAMDecGainTab[1] =DECGAIN2;
   gsa_QAMDecGainTab[2] =DECGAIN2;
   gsa_QAMDecGainTab[3] =DECGAIN3;
   gsa_QAMDecGainTab[4] =DECGAIN4;
   gsa_QAMDecGainTab[5] =DECGAIN5;
   gsa_QAMDecGainTab[6] =DECGAIN6;
   gsa_QAMDecGainTab[7] =DECGAIN7;
   gsa_QAMDecGainTab[8] =DECGAIN8;
   gsa_QAMDecGainTab[9] =DECGAIN9;
   gsa_QAMDecGainTab[10] =DECGAIN10;
   gsa_QAMDecGainTab[11] =DECGAIN11;
   gsa_QAMDecGainTab[12] =DECGAIN12;
   gsa_QAMDecGainTab[13] =DECGAIN13;
   gsa_QAMDecGainTab[14] =DECGAIN14;
   gsa_QAMDecGainTab[15] =DECGAIN15;

   gft_QosMode = 1;

   gft_send_crc_corrupt_bits_flag = FALSE;                            /*  = FALSE, stop sending corrupt crc bits from ATU-R */
   /*  = TRUE, start sending corrupt crc bits from ATU-R */
   gft_receive_crc_corrupt_bits_flag = FALSE;
   /*  = TRUE, start receiving corrupt crc bits from ATU-C */
   gft_ModemType = G_DMT;
#ifndef TARGET_HW
   guc_BERT_RX_Select = 0;
#endif
   gus_Tx_Tcm_Num1bits = 0; /* Number of 1 bit loaded tones in the TX BAT table*/
   gus_Rx_Tcm_Num1bits = 0; /* Number of 1 bit loaded tones in the RX BAT table*/
   gft_Tx_Tcm_X0_YGT1 = FALSE; /* Flag that shows if X=0, Y>=2 trellis tone pairing occurs for the given TX BAT table*/
   gft_Rx_Tcm_X0_YGT1 = FALSE; /* Flag that shows if X=0, Y>=2 trellis tone pairing occurs for the given RX BAT table*/

   guc_DS_BearerChannels = AS0_DN;
   guc_US_BearerChannels = LS0_UP;
#ifdef SPECTRUM_ANALYSIS_ON
   gs_log2_NumFramesAvg_SpectrumEst = 8; /* log2 number of frames averaged for spectrum estimation */
#endif
   gs_r_c_quiet2_wait = 120 ;                  /* Wait time after detection of C_ACT, to assume it's finished */
   gs_DetectMin=DETECT_MIN;

   gs_tcm_coding_gain = TCM_CODING_GAIN;
   gs_max_coding_gain = MAX_CODING_GAIN;
   gs_intlv_tcm_coding_gain = 10;         /* 5 dB */
   gs_intlv_max_coding_gain = 16;         /* 8 dB */
#ifdef TARGET_HW
#ifdef AMAZON_AFE   /* Infineon Amazon-A AFE IC */

#ifndef ISDN
   gs_ReverbNoiseMarginReduction = 0x0100;      /* In dB (Q8.8 format). */   // 0 reccomended for Danube
#else
   gs_ReverbNoiseMarginReduction = 0x0000;      /* In dB (Q8.8 format). */
#endif

   gs_EchoNoiseMargin = 0x0100;            /* In dB (Q8.8 format). */
   gs_ISIMargin = 0x0400;                  /* In dB (Q8.8 format). */
   gs_AlcatelReverbReductionAdj = 0x0100;      /* In dB (Q8.8 format). */
#else
   //XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA (START)
   gs_ReverbNoiseMarginReduction = 0x0100;      /* In dB (Q8.8 format). */
   //XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA (END)
   gs_EchoNoiseMargin = 0x0100;            /* In dB (Q8.8 format). To disable set to 0x2000. */
   gs_ISIMargin = 0x0400;                  /* In dB (Q8.8 format). To disable set to 0x2000. */
#endif   /* End of #ifdef/#else AMAZON_AFE */
#else
   /* Disable in Cocomo. */
   gs_ReverbNoiseMarginReduction = 0x0000;
   gs_EchoNoiseMargin = 0x2000;
   gs_ISIMargin = 0x2000;
#endif   /* End of #ifdef/#else TARGET_HW */

   gs_UnityTDQExp = 14;

   gs_fgain_adjust = 0 ;
   gs_fgain_adjust_ncload3 = 20;

   gs_CRC_burst_thresh = CRC_BURST_THRESHOLD;
   gft_HpfFlag         = FALSE;               /*  flag indicating if the high-pass filter should be */
   gft_LOSDetectFlag = TRUE;                         /*  TRUE - LOS detection is enabled during showtime, */
   /*  FALSE - LOS detection disabled */
   gft_SEFDetectFlag = TRUE;                         /*  TRUE - SEF detection is enabled during showtime */

   /* 0x2000000 = (2*(8192^2)/4) is 6dB lower than */
   /* default received signal power at pilot tone with finegain equal to 0dB */
   gl_PilotTone_PwrThresh =  0x2000000;
   gs_DetectMicroInterrupt_PhaseErrThresh = PLL_QUARTER_PI_RADIANS / 4;

   guc_PgaState = 0;
   gs_SetPgaForTones_State = 0;
   gs_US_PwrCutback_EchoLoop = 0;
   gs_us_cutback = 6;
   gs_Initial_PGA_AnnexL = 30;
   gft_EchoLoop = FALSE;

   /* Measured echo power at tone 25 when PGA was equal to 30dB for Eagle AFE */
   gl_Ghs_ReferencePower_EchoLoop = 0x40007390;
   gft_C_PILOT1_1A_flag   = FALSE;               /*  = TRUE, when C-PILOT1 or C-PILOT1A is detected */

   AfeCalibrateFlag = TRUE;
#ifndef FLOAT_IN_SW
   gf_TdqNoiseLevel = (float)TDQ_NOISE_LEVEL;      /* noise level added to A matrix */
#else
   gf_TdqNoiseLevel = (Float32)TDQ_NOISE_LEVEL;   /* noise level added to A matrix */
#endif
   gus_TxGainCutBackFactor_Bis = 29205;  /* 29205 represents 10^(-0.05) in the 1.15 format. */

   /* =============================================================================== */
   /* Initialize modem configuration parameters */
   /* =============================================================================== */

   gs_PilotToneIdx = C_PILOT_TONE_64;
   gs_AuxPilotToneIdx = C_PILOT_TONE_64;
   gs_CPilotTone = C_PILOT_TONE_64;
   gs_PllScaling = UNITY_PLL_SCALING;

   gs_TDQLen = TDQ_LENGTH;

   gft_ChanRespBeyondNyquist = FALSE;

   gs_TxNumTones = 32;
   gs_TxFirstChannel = 6;
   gs_TxLastChannel = 31;

   gs_PN_US_LEN = 2*gs_TxNumTones - 1;
   gs_PN_US_Step = 1;

   gs_RxFirstChannel = 33;


   gs_RxLastChannel = 255;


#ifdef ADSL_62
   gus_segment_size =512;
#endif
#ifndef ISDN   // only for Anx-A
   // PERF_US_ALL_ALL_TxReverbFromTone-2
   gs_TxReverb12FirstCh = 2;
#else // ISDN
   gs_TxReverb12FirstCh = gs_TxFirstChannel;
   gs_TxReverb12LastCh  = gs_TxLastChannel;
#endif // ifndef ISDN
   gs_TxMedleyFirstCh = gs_TxFirstChannel;
   gs_TxMedleyLastCh = gs_TxLastChannel;


   gs_TxFftLength = (int16) TX_FFT_LENGTH;
   gs_TxCPLength = (int16) (gs_TxFftLength>>4);
   /* Compute log2(gs_TxFftLength)-1 = log2(gs_TxFftLength/2) */
   gs_TxLog2FftLength1 = 0;
   s_temp = (gs_TxFftLength >> 1);
   while((s_temp&1) == 0)
   {
      gs_TxLog2FftLength1++;
      s_temp >>= 1;
   }



   gs_RxNumTones = (int16) 256;
   gs_RxFftLength = (int16) 512;
   gs_RxCPLength = (int16) (512>>4);
   gs_RxSamplesPerFrame = (int16) 512;



#ifdef ADSL_62
#ifdef INTERPDEC
   gs_TxFftLength_Oversample = 512;
   gs_TxCPLength_Oversample = 32 ;
#else
   gs_TxFftLength_Oversample = gs_RxFftLength;
   gs_TxCPLength_Oversample = gs_RxCPLength ;
#endif
   /* Compute log2(gs_TxFftLength_Oversample)-1 = log2(gs_TxFftLength_Oversample/2) */
   gs_TxLog2FftLength1_Oversample = 0;
   s_temp = (gs_TxFftLength_Oversample >> 1);
   while((s_temp&1) == 0)
   {
      gs_TxLog2FftLength1_Oversample++;
      s_temp >>= 1;
   }
#endif

   gs_DEC_ORDER = 288;

   gus_Rx_MinToneIndx = 0;
   gus_Rx_MaxToneIndx = gs_RxNumTones -1;

   gs_RxBitLoadFirstChannel = (int16) gs_RxFirstChannel;
   gs_RxBitLoadLastChannel = (int16) gs_RxLastChannel;

   guc_Log2MaxConstSize = (uint8) RX_MAX_BITS_PER_TONE;

   /* Compute log2(gs_RxFftLength)-1 = log2(gs_FftLength/2) */
   gs_RxLog2FftLength1 = 0;
   s_temp = (gs_RxFftLength >> 1);
   while((s_temp&1) == 0)
   {
      gs_RxLog2FftLength1++;
      s_temp >>= 1;
   }

   /* Compute log2rxnumsamples */
   s_temp = gs_RxSamplesPerFrame;
   gs_Log2RxSamplesPerFrame = 0;
   while((s_temp&1) == 0)
   {
      gs_Log2RxSamplesPerFrame++;
      s_temp >>= 1;
   }

#ifndef TARGET_HW
   /* Set the default input/output buffer sizes */
   gs_Tx_OutBuf_Size = gs_TxFftLength;
#endif

#ifndef ADSL_62
   /* DEC upsampling factor */
   for(gs_DECUpsamplingFactor=1, s_temp=gs_TxFftLength; s_temp<gs_RxSamplesPerFrame; s_temp<<=1)
      gs_DECUpsamplingFactor <<= 1;
#else
   gs_DECUpsamplingFactor =1;
#endif

   /* Initialize variables for showtime DEC adaptation. Set defaults to: */
   /* TX frame alignment disabled, TX outband signal enabled, outband gain */
   /* of -14dB, and 15 outband tones. */
   gft_TxFrameAlignEnable = FALSE;

   gft_TxOutBandSignalEnable = TRUE;

#ifndef ISDN
   gus_NumOutBandTones_right = 30;
   gus_NumOutBandTones_left = 0;
   gs_TxOutBandGain = 0x0600;
#else
   //Changes from R3.5 (Start)
   gus_NumOutBandTones_right = 32;
   gs_TxOutBandGain = 0x0C00; //XDSLRTFW-924 IOP_DS_Perf_ALL_TR100BStressFail
   //   gus_NumOutBandTones_right = 3;
   //   gus_NumOutBandTones_left = 3;
   //   gs_TxOutBandGain = 0x0C00;
   //Changes from R3.5 (End)
#endif

#ifdef ISDN
   gs_DECAdaptExp = 10;//XDSLRTFW-924 IOP_DS_Perf_ALL_TR100BStressFail
#else
   gs_DECAdaptExp = 8;
#endif


#if defined(INFINEON) && defined(ISDN)
   //VDSL2OOB detection
   gs_SignalPowerVDSL2OOB = 0;
   gs_Dec6SignalPowerVDSL2OOB = 0;   //Added for debug purpose
   guc_PGAmarginForVDSL2OOB = 0;
#endif

   /*ENABLE_L3_CODE*/
   guc_PM_L3_InternalState = WAITING_FOR_L3_REQUEST;
   guc_PM_L3_Response = 0;      //Reset the variable

   /* Initialize hybrid settings */
   InitHybridSettings();
   //gs_HybTrIndexDbg = 0; //bhadra_check force hybrid idx 0 for initial testing

   /* Do not use Rx windowing by default. */
   gft_useRxWin = FALSE;

   /* Initialize noise detection variables. */
   guc_5T1_NOISE_THRESHOLD1 = 14;

#ifdef DANUBE
   gft_useRxWin = TRUE;     // enable RxWindowing always.
   guc_5T1_NOISE_THRESHOLD2 = 196;
   guc_24HDSL_NOISE_THRESHOLD = 170;
#else
   guc_5T1_NOISE_THRESHOLD2 = 184; //-115 dBm/Hz
   guc_24HDSL_NOISE_THRESHOLD = 160; //-103 dBm/Hz
   // Enhc_DS_ALL_ALL_ByPassPLLBWIncrease(Start)
   guc_24DSL_NOISE_THRESHOLD = 180;   // -113dBm/Hz

   //guc_24DSL_NOISE_THRESHOLD1 = 182;   // -114dBm/Hz
   //XDSLRTFW-1250(START_END)
   guc_24DSL_NOISE_THRESHOLD1 = 170;   // -108dBm/Hz
   // Enhc_DS_ALL_ALL_ByPassPLLBWIncrease(End)
#endif

#ifdef ADSL_62
   gft_useRxWin = TRUE;     // enable RxWindowing always.
#endif
   // IOP_DS_ALL_VINAX_SetWhiteNoiseLevelToM130dBmHz (Start_End)
   guc_M130WHITE_NOISE_THRESHOLD = 204; // -125 dBm/Hz     XDSLRTFW-2510 : PCB_and_QLN_optimization_oISDN (StartEnd)
   guc_M140WHITE_NOISE_THRESHOLD = 222; // -134 dBm/Hz
   // XDSLRTFW-1214:IOP_DS_Plus_IKNS_ShortLoopDSCRC(Start)
   guc_M140WHITE_NOISE_THRESHOLDS_shortLoop = 212; //-129.5 dBm/Hz i.e. =-23-(212)/2 = -129 dBm/Hz
   guc_FSNB_NOISE_THRESHOLDS_shortLoop = 150;      // -98 dBm/Hz
   // XDSLRTFW-1214:IOP_DS_Plus_IKNS_ShortLoopDSCRC(End)
   gft_5T1Noise = FALSE;
   gft_24HDSLNoise = FALSE;
   // Enhc_DS_ALL_ALL_ByPassPLLBWIncrease(Start_End)
   gft_M140WhiteNoise = FALSE;
   // IOP_DS_ALL_VINAX_SetWhiteNoiseLevelToM130dBmHz (Start_End)
   gft_M130WhiteNoise = FALSE;

#if defined(INFINEON) && defined(ISDN)
   gft_LowAvgNoise = FALSE;
#endif
   /* Initialize PSD mask variable. EU64_PSDMASK = Annex B PSD mask is the default. */
   gs_AnnexBMJPSDMaskIdx = EU64_PSDMASK;

   // XDSLRTFW-356 SMS00845338 Feature_ALL_US_SelectedAnxMJMask (Start)
   //Modified default value as per VRx Message Specifications (1.9)
   STATArray[STAT_SELECTED_ANX_MJ_MASK] = 0;
   // XDSLRTFW-356 SMS00845338 Feature_ALL_US_SelectedAnxMJMask (End)

   /* Initialize variables for the margin correction due to CO TX nonlinearity. */
   gft_NonLinMgnCorrEnable = TRUE;
   gs_NonLinMgnCorr = 0;


   /* Initialize variable controlling the FDQ training for unity TDQ if multi TDQ is disabled. */
   gft_TrainFdqIfMultiTdqDisabled = TRUE;

#if defined(INFINEON) && defined(AMAZON_AFE)
   /* Initialize flag controlling the reconfiguration of the default Interp1 TX LPF filters with alternative ones. */
   gft_AltInterp1TxLPF = TRUE;
#else
   gft_AltInterp1TxLPF = FALSE;
#endif

   /* =========================================================================================*/
   /* Init detection variables                                                   */
   /* =========================================================================================*/

   gs_ToneDetectScale = DETECT_SCALE;

   // SMS00827680 IOP_DS_CNXT_Gdmt_CPilot1Det (START)
#ifndef ISDN   // Only for Anx-A
   // Intialize G.hs-based C-Pilot1 detector threshold to 12dB.
   gs_Ghs_ToneDetectScale = 12;
#endif // ifndef ISDN
   // SMS00827680 IOP_DS_CNXT_Gdmt_CPilot1Det (END)
   //T1.413 C-ACT tone detection state and count
   gs_C_ACT_flag = -1;
   gs_DetectCACT_State = 0;
   gs_DetectCACT_AccumCount = 0;

   gs_RSDetect_SnrThreshold = 0x0700;   /* Threshold for no obvious reasons is set to 7 dB to qualify a tone for RS Detect */
   /* Note: We always choose tones with the highest snrs, the threshold is an additional check */

   /* =========================================================================================*/
   /* Init Frame Sync variables                                                   */
   /* =========================================================================================*/

   gs_CXY_Threshold = CXY_THRESHOLD;
   gs_CXY_Threshold_Rsh = CXY_THRESHOLD_RSH;
   gs_MaxEnergyRsh = MAX_ENERGY_RSH;

   /* =========================================================================================*/
   /* Set TC Task control flags                                                */
   /* =========================================================================================*/

   gft_IFFT_On = FALSE;
   gft_TxDataPump_On = FALSE;                  /* Allows data pump to start independently
                                                of showtime and be Time Critical */
   gft_CopyRxBuffer = TRUE;
   gft_EnablePLL = FALSE;


   gs_UpdateTimingRecoveryHWEnable = 1;


   /* =========================================================================================*/
   /* Init debug flags                                                         */
   /* =========================================================================================*/

   gft_MedleyFlag = TRUE;
   gft_ISIanalysis = FALSE;
   gft_OfflineTdq = FALSE;

   gs_tx_ConstSize = 13;
   gs_rx_ConstSize = 13;
   gs_Num1BitTones = 6;

   gft_QAM_On = FALSE;
   gft_disableZephyrTxScrambler = FALSE;
   gft_disableZephyrRxScrambler = FALSE;
   gft_disableAlphaeusTxByteFlip = FALSE;
   gft_disableAlphaeusRxByteFlip = FALSE;

   //Initialize the BIS ovhd segment info
   for (i = 0; i < 3; i++)
   {
      gsa_RTXmit_OvhdMsgSegIndx[i] = -1;
      gsa_COReq_OvhdMsgSegIndx[i] = -1;
      gfta_FirstOvhdMsgSeg[i] = FALSE;
   }

   /* =============================================== */
   /* global variable declarations for Multi TDQ  */
   /* =============================================== */

   gs_MultiTdqFlag = FALSE;                  /* when 1 enables MultiTdq processing            */

   for (i=0; i<TDQ_LENGTH*MULTI_TDQ_FILTERS; i++){
      gsa_MultiTdqTaps[i]=0;                  /* clear Multiple TDQ Filters (taps) */
   }
   for (i=0; i<MULTI_TDQ_FILTERS; i++){
      gsa_MultiTdqExp[i]=0;                  /* clear Multiple TDQ Filters (exponents) */
   }
   for (i=0; i<MULTI_TDQ_FILTERS; i++){
      gsa_MultiTdqPreSyncs[i]=0;               /* set Multiple TDQ Pre Sync points      */
   }

   gs_presync_stepsize = 1;

   for (i=0; i<MULTI_TDQ_FILTERS+1; i++) {
      for(j=0;j<POSTSYNCH_SEARCH_OFFSET*2+1;j++) {
         gsa_MultiTdqCapacity[i][j]=0;            /* capacity for Multiple TDQ Filters */
      }
   }



   /* =============================================== */
   /* miscellaneous initializaions      */
   /* =============================================== */
   gt_ADSL1_Control.DsRateCap = 4000 ;

   gus_US_max_bits_per_symbol = (MAX_US_BYTES*8);
   gus_DS_max_bits_per_symbol = (MAX_DS_BYTES*8);

   //Initialize the flag that indicate the first CL message
   gft_FirstCL = TRUE;
   //Enhancement_MultiMode_Switching (Start_End)
   gft_VDSL_set = FALSE;
   //Initialize the far end(CO's) mode capabilities contained in first CL message
   memset(guca_FE_ModeCapabilities, 0, 6);

   //initialize 0 to handshake infofield_t structure
   // Save the pointers for the allocated NS and Adsl2AllInfo_t part first !
   for (i = 0; i < MAX_NUM_NS_BLOCK ; i++) {
      puc_temp_NSVendorSpec[i] = gpt_TxInfo->ta_NS_Info[i].puca_NSVendorSpec;
   }
   for (i = 0; i < NUM_G992_3_ANNEX_SUPPORTED ; i++) {
      pta_G9923xInfo[i] = gpt_TxInfo->pta_G9923xInfo[i];
   }
   for (i = 0; i < NUM_G992_5_ANNEX_SUPPORTED ; i++) {
      pta_G9925xInfo[i] = gpt_TxInfo->pta_G9925xInfo[i];
   }
   memset(gpt_TxInfo, 0, (int16)sizeof(InfoField_t));
   for ( i = 0; i < MAX_NUM_NS_BLOCK; i++ ) {
      gpt_TxInfo->ta_NS_Info[i].puca_NSVendorSpec = puc_temp_NSVendorSpec[i];
   }
   for (i = 0; i < NUM_G992_3_ANNEX_SUPPORTED ; i++) {
      gpt_TxInfo->pta_G9923xInfo[i] = pta_G9923xInfo[i];
      memset(gpt_TxInfo->pta_G9923xInfo[i], 0, (int16)sizeof(Adsl2AllInfo_t));
   }
   for (i = 0; i < NUM_G992_5_ANNEX_SUPPORTED ; i++) {
      gpt_TxInfo->pta_G9925xInfo[i] = pta_G9925xInfo[i];
      memset(gpt_TxInfo->pta_G9925xInfo[i], 0, (int16)sizeof(Adsl2AllInfo_t));
   }

   // Same thing for Rx structure
   for (i = 0; i < MAX_NUM_NS_BLOCK; i++) {
      puc_temp_NSVendorSpec[i] = gpt_RxInfo->ta_NS_Info[i].puca_NSVendorSpec;
   }
   for (i = 0; i < NUM_G992_3_ANNEX_SUPPORTED ; i++) {
      pta_G9923xInfo[i] = gpt_RxInfo->pta_G9923xInfo[i];
   }
   for (i = 0; i < NUM_G992_5_ANNEX_SUPPORTED ; i++) {
      pta_G9925xInfo[i] = gpt_RxInfo->pta_G9925xInfo[i];
   }
   memset(gpt_RxInfo, 0, (int16)sizeof(InfoField_t));
   for ( i = 0; i < MAX_NUM_NS_BLOCK; i++ ) {
      gpt_RxInfo->ta_NS_Info[i].puca_NSVendorSpec = puc_temp_NSVendorSpec[i];
   }
   for (i = 0; i < NUM_G992_3_ANNEX_SUPPORTED ; i++) {
      gpt_RxInfo->pta_G9923xInfo[i] = pta_G9923xInfo[i];
      memset(gpt_RxInfo->pta_G9923xInfo[i], 0, (int16)sizeof(Adsl2AllInfo_t));
   }
   for (i = 0; i < NUM_G992_5_ANNEX_SUPPORTED ; i++) {
      gpt_RxInfo->pta_G9925xInfo[i] = pta_G9925xInfo[i];
      memset(gpt_RxInfo->pta_G9925xInfo[i], 0, (int16)sizeof(Adsl2AllInfo_t));
   }

   gs_MaxMsgLen = MAX_MESSAGE_LEN;

   // Initialize the Tx/Rx handshake msg counter
   guc_TxHSMsg_SegmentCnt = 0;
   guc_RxHSMsg_SegmentCnt = 0;
   gft_TxRetransmit_Msg = FALSE;
   gft_RxRetransmit_Msg = FALSE;
   guc_TxHSReqRtx_cnt = 0;
   guc_RxHSReqRtx_cnt = 0;

   // CPE preferred PSD modes/masks shown in CLR
   // -1 indicates corresponding Annex not supported
   // Different PSD masks in a supported Annex are numbered from 0, 1, ..., NUM_G992_xx_PSDMASK_SUPPORTED
   for (i = 0; i < NUM_G992_3_ANNEX_SUPPORTED; i++)
   {
      gs_Preferred_PSDMask_G9923x[i] = -1;
   }
   for (i = 0; i < NUM_G992_5_ANNEX_SUPPORTED; i++)
   {
      gs_Preferred_PSDMask_G9925x[i] = -1;
   }

   /* Initialize Bis (G9923x) Information in TxInfo and RxInfo */

   gft_DisableExtendedFrame = FALSE;

   gft_GHS_S0min_Negotiated = FALSE;

   gt_GHS_DSTssiInfo.s_MaxNumBrkpt = MAX_NUM_DS_TSSI_VALUES;
   gt_GHS_USTssiInfo.s_MaxNumBrkpt = MAX_NUM_US_TSSI_VALUES;

   for (i = 0; i < NUM_G992_3_ANNEX_SUPPORTED; i++)
   {
      InitGlobalVariables_BisInfoTx(gpt_TxInfo->pta_G9923xInfo[i]);
      InitGlobalVariables_BisInfoRx(gpt_RxInfo->pta_G9923xInfo[i]);
   }

   /* Initialize BisPlus (G9925x) Information in TxInfo and RxInfo */
   for (i = 0; i < NUM_G992_5_ANNEX_SUPPORTED; i++)
   {
      InitGlobalVariables_BisPlusInfoTx(gpt_TxInfo->pta_G9925xInfo[i]);
      InitGlobalVariables_BisPlusInfoRx(gpt_RxInfo->pta_G9925xInfo[i]);
   }

   //initialize the number fo supported bearer channels and latency paths
   gt_rx_config.s_Nbc = DEFAULT_NUM_DS_BEARER_CHANNELS;
   gt_tx_config.s_Nbc = DEFAULT_NUM_US_BEARER_CHANNELS;
   gt_rx_config.s_Nlp = DEFAULT_NUM_DS_LATENCY_PATHS;
   gt_tx_config.s_Nlp = DEFAULT_NUM_US_LATENCY_PATHS;

   /* FFT Buffer Scenario Initializations */
   gt_RxScenarioTransition.uc_scenarioTransitionState = FFT_BUFFER_SCENARIO_TRANSITION_WAITING;

   /* Handshake Data */
   gs_TxAn_Prev = 1;                                    /*  last bit symbol for xceiver */
   guc_TxOctet  = 0;                                    /*  Octet buffers for Tx */
   guc_RxOctet  = 0;
   gs_TxMsgBufCnt  = 0;                                 /*  number of octets in a message to be transmitted */
   gs_RxMsgBufCnt  = 0;                                 /*  number of octets of a received message frame segment */
   gs_DecodeBufCnt = 0;
   gus_GhsPgaSetDown = 0;
   guc_Received_Only_One_Octet_In_ID_Field = TRUE;
   guc_Received_Only_One_Octet_In_SI_Field = TRUE;



   //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START)
   //downstream virtual noise feature is disabled by default
   gs_DSL_FeaturesControl &= ~DSL_Enable_DS_VirtualNoise;
   //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (END)

   //XDSLRTFW-1624(START_END)
   //Enable Npar2 octet 2 sending in VDSL part of GHs by default
   gs_DSL_FeaturesControl |= DSL_EnableAELEM; //XDSLRTFW-2490 (Start_End)

   // Clear the near end System Vendor ID.  This should be set via CMV */
   memset(guca_ne_SystemVendorID, 0,  VENDOR_ID_LENGTH);

   //copy default G.hs revision info to system vendor revision info.  May be overwritten below.
   guca_ne_SystemVendorID[6] = guca_ne_G9941_VendorID[6];
   guca_ne_SystemVendorID[7] = guca_ne_G9941_VendorID[7];


   // Initialize the vendor id info to Infineon's vendor id.

   guca_ne_G9941_VendorID[0] = 0xB5;   // country code, octet 1.T.35 country code. needs to be found (USA=0xb500)
   // The value of this parameter should be defined by the vendor. If the bits in the first
   // octet are not all set to binary one, the bits in the second octet shall be set to binary
   // zero.
   guca_ne_G9941_VendorID[1] = 0x00;   // country code, octet 2

   guca_ne_G9941_VendorID[2] = 0x49;   // provider code, octet 1, "I"
   guca_ne_G9941_VendorID[3] = 0x46;   // provider code, octet 2, "F"
   guca_ne_G9941_VendorID[4] = 0x54;   // provider code, octet 3, "T"
   guca_ne_G9941_VendorID[5] = 0x4E;   // provider code, octet 4, "N"
   //XDSLRTFW-3364 (Start)
   guca_ne_G9941_VendorID[6] = (uint8)(((VERSION_PLATFORM & 0xF)<<4) | (VERSION_FEATURE & 0x0F));
   guca_ne_G9941_VendorID[7] = (uint8)(((VERSION_MAJOR & 0xF)<<4) | (VERSION_MINOR & 0x0F));
   //XDSLRTFW-3364 (End)

   for (i = 0; i< 6; i++)
      guca_ne_SystemVendorID[i] = guca_ne_G9941_VendorID[i];
#ifdef AMAZON_AFE
   // Clear Vendor ID
   for (i = 0; i< 6; i++)
      guca_ne_G9941_VendorID[i] = 0;
#endif

#ifdef LEAVE_TRAIL
#ifndef NOT_PRINT_TRAIL
   gft_FDQ_PrintedToTrail = 0;
   gft_DS_BAT_PrintedToTrail = 0;
   gft_DS_FineGains_PrintedToTrail = 0;
   gft_US_BAT_PrintedToTrail = 0;
   gft_US_FineGains_PrintedToTrail = 0;
   gft_USDS_Payloads_PrintedToTrail = 0;
   BearerChannelNames[0] = "AS0";
   BearerChannelNames[1] = "AS1";
   BearerChannelNames[2] = "AS2";
   BearerChannelNames[3] = "AS3";
   BearerChannelNames[4] = "LS0";
   BearerChannelNames[5] = "LS1";
   BearerChannelNames[6] = "LS2";
#endif /* NOT_PRINT_TRAIL */
#endif /*  LEAVE_TRAIL */

   gpusa_MedleySeq = gusa_PN512Tab;

#ifdef VRX518
   gs_PGA_required_In_RCComb1_Comp = (int16)0x0C00; //XDSLRTFW-3261
#ifdef ISDN
      gs_hsk_power_dB_Comp = (int16)0xEB00; //-21*256 difference in HSK tone power
      gs_COMB2_REFERENCE_POWER = 340;
      if (TESTArray[TEST_Control3] & TEST_Control3_A21OldLifHyb)
      {
          gs_hsk_power_dB_Comp = (int16)0xFA00; //-6*256 difference in HSK tone power
          gs_COMB2_REFERENCE_POWER = 240;//round(10^(8/10))*40
   }
#else
      gs_hsk_power_dB_Comp = (int16)0xF000; //-16*256 difference in HSK tone power
      gs_COMB2_REFERENCE_POWER = 120;//round(10^(5/10))*40; //XDSLRTFW-3261

#endif
#else
      gs_PGA_required_In_RCComb1_Comp = 0;
      gs_hsk_power_dB_Comp = 0;
      gs_COMB2_REFERENCE_POWER = 0x28;

#endif
   gs_hsk_power_dB_VendorComp = 0; //XDSLRTFW-3291

   /* BIS variables                      */

   /* This value was obtained at Socrates platform and right shifted by 10. */
   /* The corresponding state is R_C_COMB1_RX */
   /* Loop: 9kft 26AWG with white noise  */
   /* AFE:  Datapath      */
   /* PGA:  23dB         */
   gs_COMB1_REFERENCE_POWER = 18;

   /* This value was obtained in lab and right shifted by 10. */
   /* The corresponding state is R_C_COMB2_RX */
   /* Loop: 2kft 26AWG without noise  */
   /* AFE:  Datapath      */
   /* PGA:  0dB         */
//#ifdef ISDN
//   gs_COMB2_REFERENCE_POWER = (0x28*gs_COMB2_REFERENCE_POWER_comp);      // XDSLRTFW-2510 : PCB_and_QLN_optimization_oISDN
//#else
//   gs_COMB2_REFERENCE_POWER = (0x28*gs_COMB2_REFERENCE_POWER_comp);
//#endif


   guc_NUM_OF_BINS_FOR_COMB_DETECTION = NUM_OF_BINS_FOR_COMB_DETECTION;

   gs_THRESHOLD_FOR_QUALIFIED_COMBTONES = THRESHOLD_FOR_QUALIFIED_COMBTONES;


   // # of carriers used for Comb1/2 and Quiet1/2 detection. Not used for Comb/Icomb detections.
   gs_NumCombSubcarriersInspected = NUM_COMB_SUBCARRIERS_INSPECTED_ADSL2;
   gs_NumCombSubcarriersRequired = NUM_COMB_SUBCARRIERS_REQUIRED;
   gs_ChanDiscDetCnt=5;

   gs_R_C_COMB1_AC_LEN_BIS= 4;
   gs_LOG_R_C_COMB1_AC_LEN_BIS = 2;


   for(i=0; i<NUM_COMB_SUBCARRIERS_INSPECTED_ADSL2; i++)
      gsa_CombToneDetCnt[i] = 0;

   gs_ChanDiscDetectMin = 4;

   for(i=0; i<NUM_COMB_SUBCARRIERS_INSPECTED_ADSL2PLUS; i++)
      gsa_Inspected_COMB_Subcarriers[i] = gsa_C_COMB_index[2+i];

   /*===================================================================
     The following three threshold values should be decided experimentally
     and current values are used for test only.
     ===================================================================*/

   gs_NLEchoThresh_bis = (5<<8)>>LOGNUM_LINEPROBE_HARMONIC_TONES_TOTAL;      /*in dB and Q8.8 format*/
   gs_NLEchoDiffThresh_bis = 1;
   gs_NLEchoDiffThresh_rsh_bis = 5;

   gs_ZARunTimes=0;

   guc_RT_FMT_R_REVERB1 = 1; /* 1 = extended length(592); 0 = regular length(272) */
   guc_RT_FMT_C_REVERB4 = 1; /* 1 = extended length(1024); 0 = regular length(256) */
   guc_RT_FMT_C_TREF1_DURATION = 7; /* C-TREF1 length = guc_FMT_C_TREF1_DURATION*512   */
   guc_RT_FMT_C_PILOT = 1;   /* 1 = RT asks the CO to transmit a fixed 4-QAM constellation point on the C-TREF pilot tone; 0 = indicats it does not */

   gt_RMsgFmt_bis.uc_MedleyPRBSus =   0;            /* default use dmt medley sequence */

   gt_RMsgPcb_bis.us_R_MIN_PCB_DS = 0;
   gt_RMsgPcb_bis.us_R_MIN_PCB_US = 0;                  // R-MIN_PCB_US
   gt_RMsgPcb_bis.us_HOOK_STATUS = HOOK_STATUS_UNKNOWN;   // Hook Status
   gt_RMsgPcb_bis.us_C_PILOT = C_PILOT_CHOICE;

   // Temporary adjustments and disablings.
   gs_PCB_DS_Delta_bis = 0;/*2,initialised through "TEST_PCB_Delta_bis"*/
   //gs_RxDesiredMargin_Delta_bis = 1;
   //XDSLRTFW-1439 (START)//Huge DS CRC errors in G.992.5A Temperature Chamber Test
   //DEC adaptation should not be disabled in VR9/VRX318 FW
   //It is applicable for both Anx A & Anx B, since temp chamber test was
   //qualified with DEC enabled condition.
   //If DEC required to be disabed, it needs to be done through CMV
   //OPTNArray[OPTN_AlgControl] |= OPTN_DECAdaptDisable ; // disable DECupdate
   //XDSLRTFW-1439 (END)//Huge DS CRC errors in G.992.5A Temperature Chamber Test
#ifndef ISDN
   OPTNArray[OPTN_PwrManControl] |= OPTN_ExMarginRedDisable;
#else
   //OPTNArray[OPTN_PwrManControl] |= OPTN_ExMarginRedDisable; // XDSLRTFW-783 Bug_fix_EnableExcessMarginReduction
#endif

   for(i=0; i<LEN_R_MSGPCB_WITHOUT_CRC; i++)
      guca_RMsgPCBTab[i] = 0;

   for(i=0; i<LEN_C_MSGPCB; i++)
      guca_RCMsgPCBTab[i] = 0;

   gft_SkipCparams = FALSE;

   guc_CrcCalcState  = TRAINING_WAITING;

   gs_RCReverb3Len_Min = 500;

   guc_FormRParamsState  = TRAINING_WAITING;

   gt_RMsgs1_bis.us_MaxBitsPerTone= TX_MAX_BITS_PER_TONE;      /* maximum numbers of bits per tone supported */
   gt_RMsgs1_bis.us_EXTGIus=   MAX_EXTGIus;            /* maximum extension of the gi range supported by the far end xmitter */

#ifndef TARGET_HW
   guc_R_C_MEDLEY_LENGTH_DIV_512= 32; /* Software simulations */
   guc_R_C_MEDLEY_LENGTH_DIV_512_DEBUG = 5;  /* If unity TDQ forced, shorten length to speed up test */
#else
#ifdef RUN_ASIM
   guc_R_C_MEDLEY_LENGTH_DIV_512= 32; /* Required for real-time operation and asim build */
   guc_R_C_MEDLEY_LENGTH_DIV_512_DEBUG = 32;
#else
   guc_R_C_MEDLEY_LENGTH_DIV_512= 60; /* Required for real-time operation */
   guc_R_C_MEDLEY_LENGTH_DIV_512_DEBUG = 60;  /* Keep full length to avoid codeswap problems */
#endif
#endif


   //    gs_ClippingIdx = 0;

   /* Set this buffer to 0 */
   for(i=0; i <(LEN_C_PARAMS_MESSAGE_BYTES+1); i++)
      guca_R_C_PARAMS_bis[i] = 0;

   gs_InitFailCauseNearEnd = 0;
   gs_InitFailCauseFarEnd = 0;

   guc_US_lowest_latency_LP = 0;

   gft_DecodeCParamsOK = FALSE;

   gft_TcmFlag_bis_US = FALSE;
   gft_TcmFlag_bis_DS = FALSE;


   guc_RT_PassFail = 0xFF;
   guc_RT_Last_TX_State = 0;
   guc_msg_ld_idx_us = 0;
   gft_RCAckLDRcvFlag = RECEIVE_OK1;
   guc_RMsgLDType = R_MSG_LD_SCLR;

   gt_DS_MeasurementPeriod.us_Hlogf_measurement_period = (uint16)R_C_REVERB3_BIS_ACCUM_LEN_CHANEST;
   gt_DS_MeasurementPeriod.us_QLN_measurement_period   = (uint16)R_C_QUIET1_QLN_LEN;

   /* The follwing variables used for Bis diagnostics mode only */
   guc_msg_ld_idx_ds = 1;
   gpuca_R_C_MSG1_LD = (uint8*)(void *)gsa_TxToneOrder; /* gpuca_R_C_MSG1_LD is used to save all bytes of C-MSG1-LD message except its Sequnece number and Reserved byte. Note the corresponding CRCs will also be saved at the end */
   gpuca_R_C_MSG2_LD = guca_R_C_PARAMS_bis;
   gpuca_R_C_MSG3_LD = (uint8*)(void *)gus_US_Hlogf_m;
   gpuca_R_C_MSG4_LD = guca_US_Quiet_Line_Noise;
   gpuca_R_C_MSG5_LD = guca_US_ShowtimeSNR;
   /* Set default variables for R-MSG1-LD to "special values" defined for each scalar test parameter */
   gt_DS_LDParam.s_PrevInit_Status = 0;
   gt_DS_LDParam.s_PrevInit_LastTxState = 0;
   gt_DS_LDParam.s_Hlin_scale = 0;
   gt_US_LDParam.s_PrevInit_Status = 0;
   gt_US_LDParam.s_PrevInit_LastTxState = 0;
   gt_US_LDParam.s_Hlin_scale = 0;
   guc_LoopAtten_LSB = OUT_OF_RANGE_LOOPATTENU & 0xFF;
   guc_LoopAtten_MSB = (OUT_OF_RANGE_LOOPATTENU>>8) & 0x3;
   guc_SigAtten_LSB =  OUT_OF_RANGE_SIGNALATTENU & 0xFF;
   guc_SigAtten_MSB =  (OUT_OF_RANGE_SIGNALATTENU>>8) & 0x3;
   guca_RMSG1_LD[6] =  (LOOPDIAG_SNRM * 10) & 0xFF;
   guca_RMSG1_LD[7] =  ((LOOPDIAG_SNRM * 10)>>8) & 0xFF;
   guca_RMSG1_LD[8] =  0;
   guca_RMSG1_LD[9] =  0;
   guca_RMSG1_LD[10] =  0;
   guca_RMSG1_LD[11] =  0;
   guc_ACTATP_LSB =  OUT_OF_RANGE_ACTATP & 0xFF;
   guc_ACTATP_MSB =  (OUT_OF_RANGE_ACTATP>>8) & 0xFF;
#ifdef DIAG_AFE_RX_CALIBRATION
   gft_DiagAfeRxCalibration = 1;
#else
   gft_DiagAfeRxCalibration = 0;
#endif
   gs_DiagRxCalibrateConstant = CALIBRATE_RX_FILTER_CONSTANT_DB;

#ifdef TARGET_HW
   gft_RestoreShowtimeBGState = FALSE;
#else
   gft_RestoreShowtimeBGState = TRUE;
#endif

   gft_RxinitSwap = NO_CODESWAP;

   gs_numAecLMSIterations = NUM_AEC_LMS_ITERATIONS;

   // Specifes the Rx Rate Buffer Size to be used for each latency path
   // Constant for Socrates where the Deilv and rate buffers are in two separate memory banks
   // Variable for Socrates+ since the Deilv and rate buffers share a single memory bank
   gsa_RxRateBufferSize[LP0_DATA_PATH]=LP0_RX_RATEBUF_SIZE;
   gsa_RxRateBufferSize[LP1_DATA_PATH]=LP1_RX_RATEBUF_SIZE;

   // initialize ATM statistic counters
   memset(gula_tot_cell_cnt, 0, sizeof(uint32)*MAX_ATM_SIZE);
   memset(gula_tot_hec_cnt, 0, sizeof(uint32)*MAX_ATM_SIZE);
   memset(gula_idle_cell_cnt, 0, sizeof(uint32)*MAX_ATM_SIZE);
   memset(gula_non_idle_cell_cnt, 0, sizeof(uint32)*MAX_ATM_SIZE);
   memset(gula_dropped_cell_cnt, 0, sizeof(uint32)*MAX_ATM_SIZE);
   memset(gula_dropped_cell_fullbuffer_cnt, 0, sizeof(uint32)*MAX_ATM_SIZE);
   memset(gula_bit_error_cnt, 0, sizeof(uint32)*MAX_ATM_SIZE);

   //XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping (Start)
   memset(gula_fhec_cnt, 0, sizeof(uint32)*MAX_ATM_SIZE);
   memset(gula_fe_tot_hec_cnt, 0, sizeof(uint32)*MAX_ATM_SIZE);
   memset(gula_fe_tot_cell_cnt, 0, sizeof(uint32)*MAX_ATM_SIZE);
   memset(gula_fe_bit_error_cnt, 0, sizeof(uint32)*MAX_ATM_SIZE);

   memset(gula_tx_idle_cell_cnt, 0, sizeof(uint32)*MAX_ATM_SIZE);
   memset(gula_tx_non_idle_cell_cnt, 0, sizeof(uint32)*MAX_ATM_SIZE);
   memset(gula_tx_tot_cell_cnt, 0, sizeof(uint32)*MAX_ATM_SIZE);
   //XDSLRTFW-459 Feature_AB_ALL_ALL_FE_ATM_TC_CNTRS_Mapping (End)

   //XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (Start_End)
   //memset(&gt_HercADSL_TPS_TC_Params, 0, (uint16)NUM_BEARER_CHANNELS*sizeof(HercADSL_TPS_TC_BearerChannel_t));

   //////////////////////////////////////////////////
   // Showtime Processing (moved from synsyml_Data.c)
   //////////////////////////////////////////////////
   /*  LOS Detection Variables */
   //XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start)
   gs_LosDefect_state_cnt = 0;                /*  number sync symbols accumulated */
   guc_LosDefect_state = 0; //Reset LOS defect detection state machine
   //XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (End)
   //XDSLRTFW-673: Enh_DS_ALL_ALL_ClkChg(start)
   gla_RxPilotSum[0] = 0;
   gla_RxPilotSum[1] = 0;
   gs_ClkAvgFact = 0;
   gs_LogClkAvgFact = 0;
   gs_ClkCount1 = 0;
   gul_ClkCount2 = 0;
   //XDSLRTFW-673: Enh_DS_ALL_ALL_ClkChg(end)
   /*  SEF detection variables */
   guc_SEFDetectState = 1;               /*  SEF_DETECT_ENABLED / SEF_DETECT_DISABLED  */
   gs_SEF_sframe_cnt = 0;                /*  number of the 2 last sync symbols that  */
   gft_SEF_currentframe = FALSE;
   gus_SEF_totalcount = 0;

   /* Data Directed (DD) Snr/Fdq Updates */
   gft_doDDSnrFdqUpdate = DD_ENABLE;      // Turn on DD based snr/fdq updates by default
#ifdef AMAZON_SE
   //XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (Start)
   //Change gs_DD_RxChannelsPerSymbol from 16 to 32 to improve SNR updating frequency.
   gs_DD_RxChannelsPerSymbol = 32; // Can set it dynamically to a value upto DD_MAX_TONES_PER_SYMBOL(=16)
   //XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (End)
#else
   //BugFix_DS_ADSL1_ALL_SuddenRFI (START)
   //XY memory is being used for showtime FDQ and Showtime SNR update process and
   //XY memory is available to use tones upto 48, and the MIPS is also available to use for ADSL1 mode,
   //but in ADSL2 mode no of channels are restricted to 32 as it was earlier. Increasing the no of channels to 48
   //in ADSL2 mode may cause unexpected issues while doing OLR. Hence ADSL2 mode, it is not changed.
   gs_DD_RxChannelsPerSymbol = 48;         // Can set it dynamically to a value upto DD_MAX_TONES_PER_SYMBOL(=48)
   //BugFix_DS_ADSL1_ALL_SuddenRFI (END)
#endif
   gs_DD_FdqAdaptSlew = 1;               // Step-size used to change fdq coeffs bu SSLMS FDQ adaptation algorithm
   gs_DD_1SecFdqUpdateCount=0;            // Counters to keep track of rate of fdq adaptation
   gs_DD_min1SecFdqUpdateCount=0x7fff;      //large #
   gs_DD_rxFDQOutput_Buffer_Select = 0;   //0 (ping) or 1 (pong), dosent matter which buffer we initializa to
   gl_DD_numDiscardedDataFrames = 0;      // total # of data frames discarded
   gs_DD_NumFramesProcDisable = 0;         // do not disable DD processing for any # of frames by default

   gus_1Sec_RxShowtimeFrameCnt = 0;
   gus_1Sec_TxShowtimeFrameCnt = 0;      // XDSLRTFW-2070(Start_End)
   gus_4096SymbolCnt = 0;  // XDSLRTFW-2923 (Start_End)

   // XDSLRTFW-575: Counter Write back in ADSL mode (Start)
   gus_1Sec_RxTrnFrameCnt = 0;
   // XDSLRTFW-575: Counter Write back in ADSL mode (End)

   //SMS00966298 SMS00951973 IOP_DS_BISPlus_ALL_SRATargetMarginFix (START)
   //SMS00954738:Feature_AB_DS_BISPlus_ALL_IncreaseAccuracySRAStep(START)
   gft_SRAUpShift_process = 0;
   gft_SRADnShift_process = 0;
   //SMS00954738:Feature_AB_DS_BISPlus_ALL_IncreaseAccuracySRAStep(END)
   //SMS00966298 SMS00951973 IOP_DS_BISPlus_ALL_SRATargetMarginFix (END)

   gc_GhsDS_PCB=0;      // Carrier set A43 power cutback used by CO during G.hs.

   // Clear the far end G994.1 Vendor ID.

   memset(guca_fe_SystemVendorID, 0,  VENDOR_ID_LENGTH);
#ifdef HERCULES_ADSL_CPE
   guca_fe_SystemVendorID[2] = 0x30; // ASCII zero char
   guca_fe_SystemVendorID[3] = 0x30; // ASCII zero char
   guca_fe_SystemVendorID[4] = 0x30; // ASCII zero char
   guca_fe_SystemVendorID[5] = 0x30; // ASCII zero char
#endif

   /* Initialize the far end, near end Version Number */
   memset(guca_ne_SystemVersionNum, 0x0, VERSION_NUM_LENGTH);
#ifdef TARGET_HW
   extern uint8 build_date;
   extern uint8 build_month;
   extern uint8 build_hour;
   extern uint8 build_min;
   extern uint8 build_year;
   guca_ne_SystemVersionNum[VERSION_NUM_LENGTH-6] = build_date;
   guca_ne_SystemVersionNum[VERSION_NUM_LENGTH-5] = build_month;
   guca_ne_SystemVersionNum[VERSION_NUM_LENGTH-4] = build_min;
   guca_ne_SystemVersionNum[VERSION_NUM_LENGTH-3] = build_hour;
   guca_ne_SystemVersionNum[VERSION_NUM_LENGTH-2] = build_year;
   guca_ne_SystemVersionNum[VERSION_NUM_LENGTH-1] = 0;

#ifdef INFINEON
   // For Infineon CPE, copy 4-byte version string to first 4 bytes of System Vendor version number.
   memcpy(guca_ne_SystemVersionNum, gusa_FW_version_number, 4); //XDSLRTFW-3364 (Start_End)
#endif
#endif
   memset(guca_fe_SystemVersionNum, 0, VERSION_NUM_LENGTH);

   /* Initialize the far end, near end Serial Number */
   memset(guca_ne_SystemSerialNum, 0x0, SERIAL_NUM_LENGTH);
#ifndef HERCULES_ADSL_CPE
   memset(guca_fe_SystemSerialNum, 0x0, SERIAL_NUM_LENGTH);
#else
   memset(guca_fe_SystemSerialNum, 0x30, SERIAL_NUM_LENGTH);
#endif

   gft_Start_Transmit_HDLC = FALSE;


   /* Initialize showtime Timer */
   memset(&gt_Timer, 0, sizeof(Timer_t));
   memset(&gt_Saved_CO_Timer, 0, sizeof(Timer_t));

   gft_COSetTimer = FALSE;

   // Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting (Start)

   memset(&gt_ErasureDecoding_Reprt, 0, sizeof(ReportErasure_t));
   // Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting (End)

   // Flags here for GHS to Init codeswap transition purpose
   gft_enterTraining = FALSE;      // Flag indicate that we have got valid BIS mode and we are ready to codeswap new pages

   gft_farEndSISupport = FALSE;   // Indicates whether far end supports Short Initialization

   gs_BisToneOrderIntlvDepth = 4;   // Indicates interleaving depth for Bis tone-ordering
   //XDSLRTFW-148:SMS00918205 SMS00918215 Feature_AB_US_BisPlus_ALL_Optional_US_interlever_depth (Start)
   //SMS00957596 CR_AB_US_BisPlus_ALL_Optional_US_interlever_depth (Start_end)
   gt_Optional_US_InlvDepth.us_US_D0Max_Tx_CLR = 0x0E;   // Default settings
   gt_Optional_US_InlvDepth.us_US_D0Max_Rx_CL = 0;
   //XDSLRTFW-148:SMS00918205 SMS00918215 Feature_AB_US_BisPlus_ALL_Optional_US_interlever_depth (End)

   // global variables used for BIS ovhd update test paramter
   gft_UpdateTestPar = FALSE;
   gus_10sec_Timer = 0;
   gs_RxSNRM_ovhd = 0;
   gpsa_RxSnrBuf_ovhd = gsa_MedleySnrBuf;

   gus_10sec_SNRUpdate = (uint16)(FRAME_COUNT_FOR_ONE_SEC*10);
   gus_10sec_NegSNRMTimer = (uint16)(FRAME_COUNT_FOR_ONE_SEC*10);
   gus_PrevSNRUpdateCnt = 0;

   //ATM anomalies/defects count
   gula_NE_ocd_cnt = 0;               // total near end ocd anomaly count
   gula_NE_lcd_cnt = 0;               // total near end lcd defect count
   gula_NE_ncd_cnt = 0;               // total near end ncd anomaly count

   gula_FE_ocd_cnt = 0;               // total far end ocd anomaly count
   gula_FE_lcd_cnt = 0;               // total far end lcd defect count
   gula_FE_ncd_cnt = 0;               // total far end ncd anomaly count


   // default variable used for Bitswap (BIS)
   gs_BITSWAP_TRIGGER_DELTA = 0x300;   //3dB
   gs_Bitswap_Accept_Delta = 0x100;   //1dB
   //XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (Start)
   gs_bitswap_evacuation_thrd = 6;  // Default value in liear dB (INT16) format.
   //XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (End)

   memset(&gt_DSOLRPMCnt, 0, sizeof(OLRPMCntInfo_t));
   memset(&gt_USOLRPMCnt, 0, sizeof(OLRPMCntInfo_t));

   gus_BgLoopCnt = 0;       //log the Bg task loops to see whether its incrementing
   gl_CurrentBGTask = 0;    //log the current BGTask address

   //Initialize the near end LPR detection flag
   gs_lpr_detect = FALSE;

   // Initialize Debug Trail structure to default values
   gt_debugTrailTriggerControl.s_logType = (DEBUG_LOG_STATESTRAIL | DEBUG_LOG_SHOW_EVENT);   // Log statestrail during training and event log during showtime
   gt_debugTrailTriggerControl.s_triggerRxState = -1;   // Disable all trigger sub-contrils
   gt_debugTrailTriggerControl.s_triggerRxSubState = -1;
   gt_debugTrailTriggerControl.s_triggerRxSymbolCount = -1;
   gt_debugTrailTriggerControl.s_toneIndex = -1;
   gt_debugTrailTriggerControl.s_numTones = -1;
   gt_debugTrailTriggerControl.s_cyclicTrailUpdate = 0; // Disable cyclic/continuous update by default
   gt_debugTrailTriggerControl.s_prevRxState = -1;   // Initialize all internal implementation specific variables
   gt_debugTrailTriggerControl.s_prevRxSubState = -1;
   gt_debugTrailTriggerControl.s_prevTxState = -1;
   gt_debugTrailTriggerControl.s_prevTxSubState = -1;
   gt_debugTrailTriggerControl.ft_StateTrigger = FALSE;

   gt_debugTrailCollectControl.s_debugTrailLen = 0;   // initialize to 0
   gt_debugTrailCollectControl.s_debugTrailSize = DEBUG_TRAIL_SIZE;

   gs_dbgMaxPhErrRev = gs_dbgMaxPhErrRevEcho = gs_dbgMaxPhErrMed=0;
   gs_dbgChoosePilot = gs_dbgChoosePilotCD = -1;   // Set this to override pilot chosen by below code

   /* In non-plus modes unity TDQ is stored in the upper half of medley SNR buffer. */
   gpsa_MedleyUnityTDQSnr = (int16*)(&gsa_MedleySnrBuf[RX_NUM_TONES>>1]);

#ifndef ADSL_62
   gl_CyclicPrefixInsertCnt= R_C_SEGUE1_LEN-2;
#else
   gl_CyclicPrefixInsertCnt= R_C_SEGUE1_LEN-4;
#endif
   gs_FRCyclicPrefixInsertCnt = R_C_SEGUE_FR2_RX_LEN-2;

   //Internal flag indicate whether or not enable Smaller S in ADSL2+ mode
   gft_EnableSmallerS = FALSE;

   //Initialize the derived frame properties.
   s_temp = sizeof(DerivedFramePropLatencyPath_t)>>1;
   memset(&gt_DerivedFrameProperties_DS, 0, sizeof(DerivedFrameProp_t));
   memset(&gt_DerivedFrameProperties_US, 0, sizeof(DerivedFrameProp_t));
   gt_DerivedFrameProperties_DS.s_sizeofStruct = s_temp;
   gt_DerivedFrameProperties_US.s_sizeofStruct = s_temp;

   pt_PropPerLp[0] = gt_DerivedFrameProperties_DS.PropPerLp;
   pt_PropPerLp[1] = gt_DerivedFrameProperties_US.PropPerLp;
   for (i = 0; i < NUM_DATA_PATHS; i++)
   {
      pt_PropPerLp[0]->s_L2_LMin = 8;
      pt_PropPerLp[0]->s_OLR_LMinBpn = 8;
      pt_PropPerLp[0]->s_OLR_LMinNoBpn = 8;
      pt_PropPerLp[1]->s_L2_LMin = 8;
      pt_PropPerLp[1]->s_OLR_LMinBpn = 8;
      pt_PropPerLp[1]->s_OLR_LMinNoBpn = 8;
      pt_PropPerLp[0]++;
      pt_PropPerLp[1]++;
   }

#ifdef TARGET_HW
   //Initialize the top 4 long words (32bytes) as the repetitive 0xdeadbeef value
   for (i = 0; i < 4; i++)
   {
      l_StackAddr = (int32*)((int32)STACK_TOP+i*4);
      *l_StackAddr = 0xdeadbeef;
   }

   //check the 4th long words from top of the stack
   gl_StackMem = (int32*)((int32)STACK_TOP+12);
#endif

#ifdef PROFILE_PHASEERR
   ProfilePhaseErrInit();
#endif

#ifdef PROFILE_TASKS
   ProfileTaskInit();
#endif /* #ifdef PROFILE_TASKS */

   /************************************************************/
   /* Variables to control the logging of one tone of sync symbol   */
   /* Data stored in gsa_StatesTrail.                     */
   /************************************************************/

   gs_SyncSymbolCaptureTone = 48;   /* tone 48 of gsa_RxToneBuf is being captured */
#ifdef COLLECT_SYNCSYMBOL_INFO

   gs_RxSyncSymbolBufferIndex = 2*MAX_STATES;
   gs_RxSyncSymbolCount = 0;

#endif /* #ifdef COLLECT_SYNCSYMBOL_INFO  */

#ifdef COLLECT_EOCAOCIB_INFO
   gs_RxOverheadBufferIndex   = 2*MAX_STATES;
   gs_InitRxOverheadBufferIndex = 2*MAX_STATES;
   gs_RxOverHeadSymbolCount   = 0;
   gs_CollectRxOverheadInfoEnable   = 0;

#endif

#ifdef COLLECT_SHOWTIME_EVENTS_INFO
   gs_RxShowtimeEventsInfoBufferIndex = 2*MAX_STATES;
   gs_InitRxShowtimeEventsInfoBufferIndex = 2*MAX_STATES;
   gs_RxShowtimeEventsInfoEnable = 0;
   gs_RxShowtimeEventsError_threshold = 3;
   gs_RxShowtimeEventsInfo_SyncSymbolThreshold = 0x100;

#endif



   // init ME-HDLC message buffer sizes
   gt_ME_HDLC_Params.s_MaxAllowedTxMsgLength = MAX_TX_ME_HDLC_MSG_SIZE;
   gt_ME_HDLC_Params.s_MaxAllowedRxMsgLength = MAX_RX_ME_HDLC_MSG_SIZE;
   gt_ME_HDLC_Params.s_DmtTxCeocSpacing = TX_CEOC_SPACING;




   //init Clear EOC data structure
   gt_RxClearEocBuf_CMV.gs_RxClearEocBuf_Length   = RX_CLEAR_EOC_DATA_SIZE*2;    // length in bytes
   gt_RxClearEocBuf_CMV.gs_RxClearEocBuf_ReadIndex = 0;
   gt_RxClearEocBuf_CMV.gs_RxClearEocBuf_WriteIndex = 0;
   gt_RxClearEocBuf_CMV.gs_RxClearEocBuf_OverflowCnt = 0;
   gt_RxClearEocBuf_CMV.s_RxClearEocBuf_Disable = FALSE;

#ifdef PCM_INTERFACE_SUPPORT
   guc_PCMState = 0;
   for (i = 0; i < 2; i ++)
   {
      gt_PCMInterface[i].us_StrucLength = (sizeof(MessageOvhdFifo_t)+1)>>1;   //in words
      gt_PCMInterface[i].ErrorCode = 0;
      gt_PCMInterface[i].MessageBuffer = 0;  //null address
      //By default, the sw FIFO size is 100 bytes for each side(the maximum)
      gt_PCMInterface[i].BufferSize = PCM_FIFO_SIZE;
      gt_PCMInterface[i].IndexOfOldest = 0;
      gt_PCMInterface[i].NextAvailable = 0;
      gt_PCMInterface[i].us_OvflowCnt = 0;
   }
   //By default, the sw FIFO size is 100 bytes for each side(the maximum)
   gt_PCMInterface[0].MessageBuffer = &guca_PCMSWFIFO[0];
   gt_PCMInterface[1].MessageBuffer = &guca_PCMSWFIFO[PCM_FIFO_SIZE];
#endif   //#ifdef PCM_INTERFACE_SUPPORT

#ifdef TARGET_HW
   gt_Gpio.s_GPIO_16Hz_Flash_LED = 0x0900;      // gpio9 is 16Hz flash LED
   gt_Gpio.s_GPIO_Ctrl = 0x0610 ;            // all inputs except gpio4, gpio9 and gpio10
#ifdef DANUBE
   gt_Gpio.s_GPIO_For_TR68_Adsl_LED = 0x0A03;  // Gpio10 is TR68ADSL Led
#else
   gt_Gpio.s_GPIO_For_TR68_Adsl_LED = 0x0A01;  // Gpio10 is TR68ADSL Led
#endif
   gt_Gpio.us_GPIO_Data_Mask = 0x0610 ;      // Gpio 4, 9 and Gpio10
   gt_Gpio.us_GPIO_Data_Write = 0xffef;      // (at least) LOL GPIO should be initialized to low !!

#ifdef ADSL_62
   gt_Gpio.s_GPIO_DyingGasp_Pin = 15;         // Dying gasp pin
#else
   gt_Gpio.s_GPIO_DyingGasp_Pin = 8;         // Dying gasp pin
#endif

   gt_Gpio.s_GPIO_LOL = 4;                  // LOL pin
#endif

   //Initializing the variables for Auto SRA.
   gus_ra_Interval_Timer = 0;
   gft_Poll_SRACond = FALSE;
   gft_DownShiftFlag = FALSE;
   gft_UpShiftFlag = FALSE;
   gft_AutoSRA_ErrorCondition = FALSE;
   gft_Auto_SRA_Completed = FALSE;
   //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved: (START)
   gft_enable_new_adaptation = FALSE;
   //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved: (END)


   gft_XtraIfftCutback = 0;

   gs_RxEstimatedMinMargin = 0;

   gft_ChangeRSBin = FALSE;  //Flag to indicate whether or not we should update the SW Rev/Seg Detector tones

   gft_TcmFlag = FALSE;                         /* TCM coding flag (DEFAULT is OFF.) */

   gs_tssi_DeepNotchthreshold = 0x6400; /* value 50*512=0x6400 corresponds to a log_tssi of 50 dB in Q7.9 format */
   gs_tssi_ShallowNotchthreshold = 0x3C00;   /* value 30*512=0x3C00 corresponds to a log_tssi of 30 dB in Q7.9 format */
   gs_tssi_threshold = 0x3C00;   /* value 30*512=0x3C00 corresponds to a log_tssi of 30 dB in Q7.9 format */
   gft_NotchPresent = 0;
   gs_PcbDsDeltaForNotch = 0;
   gft_dbgDisableTimeout=FALSE;

   // Time period used for monitoring the Rx Delineated cell count
   // R3_P1: ENH_DS_ALL_ALL_LOS_16Sec (Start_End)
   guc_RxCellDelineatePeriod = 16;  //was 4; changed to 16

   //SMS01438029 Perf_DS_ALL_24Kb_Ilv_Memory (Start)
#ifdef ADSL_62
   //Initializing the variables for 24k dilv memory size (Bytes)
   gl_DS_Intlv_buf_size = 16002;
   gft_Ilv_Buf24k=FALSE;
   gt_INFX_CMV.us_Ena_Extended_D_IFX |= MASK_ENA_EXT_ILV_BUF;  // Enable DS extended interleaver

#ifdef ISDN
   // Feature_US_BisPlus_ALL_StartDSFromTone61AnxJ (Start_End)
   //Start DS from tone 61 for Annex J mode if US mask upto tone 60 or lower is selected
   gt_INFX_CMV.s_DFE_Options |= DS_START_TONE_61;

   // Perf_US_ALL_MultiTone_Activation (start_End)
   //XDSLRTFW-653 XDSLRTFW-258 Bug_US_BisPlus_ALL_UseAnxBFiltForAnxJ_BeforeGHs (Start)
   // PSD violation in ADSL G.Hs if Annex-J mode is enabled - Jira XDSLRTFW-258
   // In Annex-B binary the configuration of the tx-path was not correct if Annex-J codepoints
   // in G.Hs were enabled. In this case the Tx-IIR filter was configured for Annex-J, but the
   // tx-interpolator for Annex-B tx signals. This was not seen in the final Annex-J or Annex-B
   // PSDs because of the reconfiguration of the tx-path after G.Hs
   // As Annex-J activation tones are currently not used in any field deployment the activation
   // tones and G.Hs filter configurations are hard-coded to Annex-B.
   // ATTENTION!     This setting might be overwritten by API configuration
   //   gt_INFX_CMV.s_DFE_Options |= (ACTVATION_ANXB_TONES_FOR_ANXJ); //  Default State (Disable J43)
   //XDSLRTFW-653 XDSLRTFW-258 Bug_US_BisPlus_ALL_UseAnxBFiltForAnxJ_BeforeGHs (End)
   //XDSLRTFW-699: Fix_AB_US_All_GHsToneSetSelection (Start)
   //Selection of G.Hs tone set is moved out from "INFO 103 1 0x2000" to "CNFG 45 0 0x0006"
   //Default enable only B43/B43C G.Hs tone set.
   gs_GhsCarSetCfg = (US_GHS_CARRIER_SET_B43 | US_GHS_CARRIER_SET_B43C);
   //XDSLRTFW-699: Fix_AB_US_All_GHsToneSetSelection (End)
#else
   //Valid for Annex-A
   //XDSLRTFW-699: Fix_AB_US_All_GHsToneSetSelection (Start_End)
   gs_GhsCarSetCfg = (US_GHS_CARRIER_SET_A43 | US_GHS_CARRIER_SET_A43C); //Default set to A43 tone set
#endif
#endif
   //SMS01438029 Perf_DS_ALL_24Kb_Ilv_Memory (End)

   //XDSLRTFW-653 XDSLRTFW-258 Bug_US_BisPlus_ALL_UseAnxBFiltForAnxJ_BeforeGHs (Start)
   //Forced selected mode global variable to "0" at initializations
   //This is done to get the same configuration during link start, valid till G.Hs exit
   gl_SelectedMode = 0;
   //XDSLRTFW-653 XDSLRTFW-258 Bug_US_BisPlus_ALL_UseAnxBFiltForAnxJ_BeforeGHs (End)

   // XDSLRTFW-654 XDSLRTFW-248 Bug_DS_All_All_IntentionalReTrainToReduceTrainTime (Start_End)
   guc_Forced_Retrain = 0;


   //Initialize HDLC related structure variables
   memset(&gt_OlrPm_TxOvhdMsgInfoInput, 0, sizeof(TxOvhdMsgInfoRequest_t));
   gt_HDLCInfo.ft_InvertedSyncSymbol_expected = FALSE;
   gt_HDLCInfo.ft_SegmentedMsgProgress = FALSE;

#ifdef IFX_XTC
   gft_AlphaeusSel = TRUE;
#endif

#ifdef HERC_API


   gs_Fw_ImageInfoGet =    0x3;    // Bit 1: 0=CO, 1=CPE
   // Bit 2: 0=VDSL, 1=ADSL
   // Bit 3: 0=ADSL or VDSL Only, 1=Combined Image
#endif

   /*****************************************PTM CHANGES**************************************/
#if defined DANUBE_PTM_SUPPORT
   //PTM Modifications: Begin
   gt_INFX_CMV.us_PTM_Options_Indicated = DEFAULT_PTM_OPTIONS | ATM_ONLY;
   gt_INFX_CMV.s_DFE_Options |= DIS_BYTE_FLIP_MASK;//Default disable Byte flip
   //Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (Start_End)
   //Sriram : Modified the statement
   //gt_INFX_CMV.s_DFE_Options &= DIS_FORCE_PTM;//Disable force PTM by default
   gt_INFX_CMV.s_DFE_Options &= ~(FORCE_PTM_MASK); // Disable force PTM by default
   gft_ForcePTM = 0;
   gft_DisByteFlip = 0;
   //PTM Modifications: End
#endif//if defined DANUBE_PTM_SUPPORT
   /*********************************PTM CHANGES*************************************/
//#ifdef ISDN
   // XDSLRTFW-754 Perf_DS_Plus_ALL_AdjDsPcb (Start_End)
   gt_INFX_CMV.s_DFE_Options |= (CMV_INFX_DFE_IOP_FIX_DS_PCB_ENABLE);  // Enable DS PCB Imp for VRx Annex B/J
//#endif


#ifdef AMAZON_SE
   gt_INFX_CMV.s_versionControl = A12;
#endif
   //#ifdef DANUBE_WB // Danube
   //gt_INFX_CMV.s_Erasure  = ERASURE_DECODING_ENABLE;
   //   gs_erasure_set = gt_INFX_CMV.s_Erasure; //XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (Start_End)
   //#endif
   gt_INFX_CMV.s_CTUNE_NMSForce_mask = 0;//0x0004;//0x4004;// enable NMS force, Echo Log


   // XDSLRTFW-399 ENH_DS_BisPlus_All_Enable_ErasureDecoding (Start)
#ifdef  VR9_ERASURE  //VR9
   //XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (Start_End)
   //Erasure decoder deafult settings as per VRx Message Spec
   // Use Erasure Capability to boost the INP.
   // Setting to use if Erasure Gain to be used for DataRate Boost
   // as per the VR9 Spec.
   //XDSLRTFW-1502 (start)
   gs_DSL_EDcontrol = ERASURE_DECODING_ENABLE;
   gs_DSL_EDcontrol|= DSL_Enable_ERASUREDECODING_REPORTING;
   // XDSLRTFW-1654 (Start_End)
   gs_DSL_EDcontrol &= ~ERASURE_MAX_INP;  //XDSLRTFW-1945
   gt_INFX_CMV.s_ErasureGain = 0x0100;    // 1
   //XDSLRTFW-1502 (end)
   //use positive logic to enable Erasure. Enable erasure bit and
   //disable adjust INP Bitload (Data rate boost)
   //  Before enabling "adjust INP Bitload" gs_erasure set should be mapped to a cmv
   //  (e.g. Danube uses gt_INFX_CMV.s_Erasure) !!!

   //bit 0 = 1/0 (erasure enabled/disabled)
   //bit 1 = 0/1 (Data rate boost disabled/enabled)

   //XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (Start)
   //gs_erasure_set = 1; // Only erasure decoding is enabled
   gft_erasure_on =  gs_DSL_EDcontrol & ERASURE_DECODING_ENABLE;
   gft_allow_reset_erasure = 0;
   // XDSLRTFW-1502 (start_end)
   gft_erasure_hw_on = (gs_DSL_EDcontrol & ERASURE_DECODING_ENABLE);
   //XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (End)

#endif   //#ifdef VR9_ERASURE
   // XDSLRTFW-399 ENH_DS_BisPlus_All_Enable_ErasureDecoding (End)
   // AR8_TF:IOP_ALL_BISPLus_CNXT_1bitConstellation
   gs_ChIdx_1bitTo2bit = 0;   // //Cnxt TI AR8

   //XDSLRTFW-141: Feature_ALL_ALL_ALL_CMV_LD_Mode (Start)
   //   gus_LD_Mode = LD_VH_ADSL; //Default setting as per Jira XDSLRTFW-141
   //Jira XDSLRTFW-1859 Start
   //Line drive mode in ADSL to "Medium" can done by just changing the value of the following AFE Digital Registers
   //GPIO_LD_DOUT (Address 0x 403) = 0x5
   //GPIO_LD_CTL (Address 0x 405) = 0x 700
   gus_LD_Mode = LD_M_ADSL; //Default setting as per Jira
   //Jira XDSLRTFW-1859 End
   //XDSLRTFW-141: Feature_ALL_ALL_ALL_CMV_LD_Mode (End)

   gus_HybridType = 0;

   //XDSLRTFW-315: Feature_ALL_ALL_ALL_DSL_PPE_CLOCK_CONTROL (Start_End)
   gus_PpeClockControl = 0;

   //XDSLRTFW-278: Feature_AB_ALL_ALL_ARX208_Support_DSL_CMV (Start)
   gusa_AfeChipId[0] = 0xFFFE;   //Not Initialized
   gusa_AfeChipId[1] = 0xFFFE;   //Not Initialized
   //XDSLRTFW-278: Feature_AB_ALL_ALL_ARX208_Support_DSL_CMV (End)
#if defined(VRX318) || defined(VRX518)
   //XDSLRTFW-541: Platform_VRX318 (START)
   // Read hybrid type from the port mode control structure offset 9 (bits b4 to b2)
   // and set gus_HybridType accordingly
//   us_temp = (gt_PortModeControl.uc_AfePowerUp & VRX318_LIF_DET_MASK) >> 2;
   //XDSLRTFW-542: Platform_VRX318 (END)
#else
   //Read the hybrid type from the board and set gus_HybridType accordingly
  // us_temp = GPIO_DIN_AFE_GET;
#endif  //VRX318

  // us_temp = VRX_HYB_TYPE_ABJ; //Extract last 3 digits

   //if (us_temp == VRX_HYB_TYPE_ABJ)
   {
      //Type A LIF module

      gus_HybridType = VRX_HYB_TYPE_ABJ;

   }

   //XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (Start_End)
   gt_ADSL_TcMode_Reprt.us_FW_TC_mode = ATM_TC;
   gt_ADSL_TcMode_Reprt.us_PPE_TC_Mode = 0;  /* XDSLRTFW-3068 */

   //XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING(Start)
#ifdef ADSL_BONDING
   // clear bonding status before each link
   memset(&gt_Bonding_DiscAggr_Status, 0, sizeof(Bonding_DiscAggr_Status_t));
   gft_FE_Not_Bondable = 0;
   guc_ID_SPar1   = 0;
   guc_ID_SPar1_02 = 0;
#endif
   //XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING (End)

   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
   //SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod (Start)
   //Initialise the pointer to PPE<->DFE shared memory
   // gpt_ReTxXmemConfigInfo = (ReTxXmemConfigInfo_t *) (XMEM_RETX_PPE_SHARED_BUF_ADDR + ADSL_IMAGE_BASE_ADDR);

   // Initialise ReTx mode to 0
   gt_ReTxConfigInfo.ft_ReTxOn = 0;
   // Initialise delay offset to 1.
   gt_ReTxConfigInfo.s_delay_offset = 1;
   //Default value 0x0c (ie.,0.75dB =>0.75*16) suggested by Dietmaras per Arek setting.
   gt_ReTxConfigInfo.us_ReTxCodingGain = 0x0C;

   //Half round trip delay is 6 symbols in VR9
   //Strymon(1), i.e 4 time slots  + Iridia_FFT 3 time slots (3/4) + Iridia_QT(1/4), 1 time slot + Zephyr(1/4) 1 time slot
   //3 symbol for Rx & 3 symbol for Tx
   gt_ReTxConfigInfo.us_s_CPE = 6;

   gt_ReTxConfigInfo.us_d_CPE = 0;
   gt_ReTxConfigInfo.us_QSmax = 0x10;
   gt_ReTxConfigInfo.us_QSmin = 2;
   gt_ReTxConfigInfo.us_MSGmin = 6;
   //Initialize RTmem with ReTx Queue size
   gt_ReTxConfigInfo.us_RTmemMaxIfx = RETX_QUEUE_SIZE;

   // Initialise the flag to recieve extra bytes as per C-Msg1 changes.
   gt_ReTxConfigInfo.s_CMSG1_CI_LeftrThresh = 1;
   //SMS01435932:FEATURE_ALL_BisPlus_ALL_Univ_Retx_GHS_mod (End)
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)

   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx_CMV_CNFG_80_INFO_229 (Start)
   //gt_ReTxConfigInfo.us_ReTxConfigOptionBits |= (CMV_BIT_INDICATE_RETX); //ReTx enabled by default
   gt_ReTxConfigInfo.us_ReTxConfigOptionBits &= ~(CMV_BIT_INDICATE_RETX); //ReTx disabled by default
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx_CMV_CNFG_80_INFO_229 (End)


   //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start)
   gusa_CRC_count[0] = 0;           /*  CRC error count */
   gusa_CRC_count[1] = 0;           /*  CRC error count */
   //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (End)

   //XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR (START)
   gs_lpr_frmcnt = 0;
   gs_lpr_frmcnt_before_drop_line = 320; //320 symbols = 80 ms
   gl_TxIbFiFoWriteCnt = 0;
   //XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR (END)

   //XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR (START)
   //Debugging variables connected to Dying Gasp are initialized here
   gft_debug_LPR = 0;
   gl_debug_cnt1 = 0;
   gl_debug_cnt2 = 0;
   //XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR (END)

   //XDSLRTFW-686: PERF_DS_DMT_ALL_Bitswap(start)
   //Reusing the Virtual Noise memory for SNR backup in DMT mode
   gpsa_TempSnrBuff = gsa_RxWithOutVnSnrBuf;
#ifndef ISDN
   //XDSLRTFW-679 Enhance_US_BisPlus_LucentStinger_US_Rate_Improvement (Start-End)
   //XDSLRTFW-3476 (START_END)
   //gt_INFX_CMV.us_OperatorSpBits6 |= CMV_TO_ENABLE_IMPROVE_US_RATE_WITH_LUCENT_ST;
#endif
   //XDSLRTFW-441
   // XDSLRTFW-1464 : Perf_US_Plus_AnxA_BRCM_USPerf24HDSLNoise(Start_End)
   gt_INFX_CMV.us_OperatorSpBits6 &= ~(CMV_TO_ENABLE_PSDBoostUSPerf24HDSLNoise);

   //XDSLRTFW-1916 IOP_US_DMT_BRCM_LowerTxPower (START_END)
   gt_INFX_CMV.us_OperatorSpBits6 &= ~(CMV_TO_ENABLE_LOWER_TX_POWER);

   //XDSLRTFW-1951 IOP_DS_BIS_VINAX2_EnableNM (START_END)
   gt_INFX_CMV.us_OperatorSpBits6 &= ~(CMV_TO_ENABLE_NM_VINAX2);

   memset(guca_QLN, 0, sizeof(uint8)*(RX_NUM_TONES));
   //XDSLRTFW-2033 (start)
   gs_TX_IMAGE_NYQ = 0;
   gft_CNXT_ANNEXL_ADSL2 = FALSE;
   gft_CNXT_A_LongLoops = FALSE;
   //gs_ATPR_L2 = 10;//re-use of variable
   //XDSLRTFW-2033 (start)

   //XDSLRTFW-2033 (Start)
   gul_ToneDetectSymbCount = 0;
   gul_PGAResetSec = TIME_8S;
   //XDSLRTFW-2033 (End)
   guc_ClrControl = 0; //XDSLRTFW-2893
   // XDSLRTFW- 2298 (Start)
   // =========== G.Fast ========================
   // Initialize GHS capability list
   // gul_OperationModeCapable_G_Fast bits[7:0]   - standard info NPar2 octet 1 for VDSL2
   // gul_OperationModeCapable_G_Fast bits[15:8]  - standard info SPar2 octet 1 for VDSL2
   // gul_OperationModeCapable_G_Fast bits[23:16] - standard info SPar2 octet 2 for VDSL2
   // gul_OperationModeCapable_G_Fast bits[31:24] - standard info SPar2 octet 3 for VDSL2
   gul_OperationModeCapable_G_Fast = (G_Fast_Default_CE_Length | G_Fast_Default_Symbol_Periods_TDD_Frame ) |
                                     ((G_Fast_Profiles | G_Fast_Duration_Channel_Discovery ) << 8) |
                                     ((G_Fast_Symbol_Period_TDD_Frame) << 16);
   // XDSLRTFW- 2298 (End)

   //XDSLRTFW-2882 : Wrong HS tone selection (Start)
   // CToneSet A43
   gt_GhsCToneInfo[0].us_ToneIdx = 40;
   gt_GhsCToneInfo[1].us_ToneIdx = 56;
   gt_GhsCToneInfo[2].us_ToneIdx = 64;
   // CToneSet B43
   gt_GhsCToneInfo[3].us_ToneIdx = 72;
   gt_GhsCToneInfo[4].us_ToneIdx = 88;
   gt_GhsCToneInfo[5].us_ToneIdx = 96;
   // CToneSet A43C / B43C
   gt_GhsCToneInfo[6].us_ToneIdx = 257;
   gt_GhsCToneInfo[7].us_ToneIdx = 293;
   gt_GhsCToneInfo[8].us_ToneIdx = 337;
   //XDSLRTFW-2882 : Wrong HS tone selection (End)
   guc_NMS_AlgHandler = NOISE_MARGIN_SEP_DISABLED;
   gpsa_RCReverb_Quiet_Snr =    (int16 *)(void *)&guca_NMS_dbg[0*1024]; // Reverb SNR Quiet
   gpsa_RCReverb_Silence_Snr =  (int16 *)(void *)&guca_NMS_dbg[1*1024]; // Reverb SNR with POFI PD
   gpsa_PGA_Snr =             (int16 *)(void *)&guca_NMS_dbg[2*1024]; // SNR with PGA setting through PGA training (REVERB/MEDLEY)
   gpsa_deltaPGA_Snr =        (int16 *)(void *)&guca_NMS_dbg[3*1024]; // SNR with delta PGA (3dB)setting (REVERB/MEDLEY)
   gpsa_Medley_Vector =         (int16 *)(void *)&guca_NMS_dbg[4*1024]; // Actual Medley SNR without NMS
   gpsa_New_NMS_Vector =        (int16 *)(void *)&guca_NMS_dbg[5*1024]; // New NMS vector without celing
   gpsa_EchoLog = gpsa_Medley_Vector;
   gpsa_NMS_Vector = (int16 *)(void *)&gsa_NMS_Vector[0];
   gt_HercADSL_OPTNMap_MarginControl.s_deltaMarginMax = 0x0300; // 3dB max
   gt_HercADSL_OPTNMap_MarginControl.s_TxNoise_delta = 0x0000;
   gt_HercADSL_OPTNMap_MarginControl.s_ADCNoise_delta = 0x0000;
   gt_HercADSL_OPTNMap_MarginControl.s_ISINoise_delta = 0x0000;
   guc_TxSilence = SILENCE_WAIT;

   // Global vars moved from CalcQlnDiag.c
   //XDSLRTFW-3603 (start)
   guc_NoTones_Qln = 180;
   guc_NoTones_Qln_Force = 160;
   guc_NOISE_THRESHOLD_138 = 230; //>>> -23-230/2 => -138.0
   gus_XtalkLowerThan_m138dBmHz = 0;
   gft_AddNMS =FALSE;
   //XDSLRTFW-3603 (end)
   gft_IsBTorLLoop = FALSE; //XDSLRTFW-3674 (start_end)
   gt_INFX_CMV.s_HybTablesSwitch |= 0x0001;
   gs_HybTableForce = (int16)-1;
   gft_HlogMeasurement = FALSE;     //XDSLRTFW-3753 ,variable init

   // XDSLRTFW-3662(Start)
   // Bit defintion of DREG registers:
   // 0x7DC3 (DREG_MISCRAM3_ADDR):
   //  Bit 15 - Bit 0      --> PPE FW version
   //  Bit 31 - Bit 16     --> Fixed reference (0xA5A5)
   ul_addr = DREG_MISCRAM3_ADDR;
   ReadPpeReg(ul_addr, &ul_data);
   if (((ul_data & PPE_FW_VERSION_MASK) >> PPE_FW_VERSION_SHIFT) == PPE_FW_VERSION_REFERENCE)
   {
      gusa_PPE_FW[0] = 0x3;
      gusa_PPE_FW[1] = (ul_data & 0xFFFF);
   }
   // XDSLRTFW-3662(End)


   // XDSLRTFW-3665 : Previous Failstate / Previous Exception Code
   // - complete Failstate info is available in the following link in gt_FailStateInfo_Prev
   // - gt_FailStateInfo_Prev is mapped to DSL_PREV_FAILSTATE (DSL_37)
   // - the failstate history of the last 5 exceptions is mapped to DSL_PREV_EXCEPTION_CODES (DSL_38)
   //
   // It seems that we are calling this function multipl times during inititalization.
   // But it is not desired to to the update of the failstates multiple times.
   // Therefor we use counter gus_nFunctionCalls_InitGlobalVariables to
   // ensure that we do the init only when calling this function the very first time
   if (gus_nFunctionCalls_InitGlobalVariables == 0)
   {
      // copy fail state info of previous link before clearing it in this link
      memcpy(&gt_FailStateInfo_Prev, &gt_HercADSL_STATMap_FailureState, sizeof(HercADSL_FailStateInfo_t));
      memset(&gt_HercADSL_STATMap_FailureState, 0, sizeof(HercADSL_FailStateInfo_t));
      gt_HercADSL_STATMap_FailureState.ul_ExceptionCode = E_CODE_NO_ERROR;
      // XDSLRTFW-3665 - Exception History
      // update failstate history:
      // the latest exception code is always in gula_FailStateHistory[0]
      // gula_FailStateHistory contains ADSL and VDSL exceptions
      for (i=5-1; i>0; i--)
      {
         gula_FailStateHistory[i] = gula_FailStateHistory[i-1];
      }
      gula_FailStateHistory[0] = gt_FailStateInfo_Prev.ul_ExceptionCode;
   }
   gus_nFunctionCalls_InitGlobalVariables++;
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : InitModemTasks
 *
 *  Prototype:  void InitModemTasks(void)
 *
 *      Initializes variables in Modem tasks
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

void InitModemTasks_PreHandshake(void) {

#ifndef SLEEP_TEST_BUILD

   InitGlobalVariables();
   InitStateMachine();

#ifndef ADSL_62
   EnableTxInterrupt(TX_FRAME_START);
   EnableRxInterrupt(RX_FDQ_DONE);
#endif

   tcb_init();                              /* Initialize Task-layer control blocks. */
   InitBackground();
   InitTxLoadingFunctionFifo();
   InitRxLoadingFunctionFifo();

   //InitializeInfoField(gpt_TxInfo );  /*  initialize Tx information fields */

   SetZeroDEC();

#else   // for SLEEP_TEST_BUILD

   InitGlobalVariables();
   InitStateMachine();

   InitBackground();

#endif   // #ifndef SLEEP_TEST_BUILD
}

#endif   //TEST_HS_DECODE


/*************************************************************************************
  ;   Prototype: void InitGlobalVariables2_BisInfoTx(Adsl2AllInfo_t *pt_BisInfo, int16 s_annex);
  ;
  ;   Description:
  ;
  ;      Initialize the tx global variables associated with a Bis (ADSL2) or
  ;   BisPlus (ADSL2+) data structure (which in turn is a component of the
  ;   a InfoField structure).
  ;
  ;   Arguments:
  ;      *pt_BisInfo   - pointer to BisInfo structure
  ;
  ;   Return Value:
  ;      none
  ;
  ;   Global Variables:
  ;
  ;**************************************************************************************/
void InitGlobalVariables2_BisInfoTx(Adsl2AllInfo_t *pt_BisInfo, int16 s_annex) {

   int i, s_index;
   uint8 *puca_CLR_USTssiIndex, *puca_CLR_USTssiValue, *pfta_CLR_USTssiSi;

   s_index = s_annex*MAX_NUM_US_TSSI_VALUES;
   gsa_num_USTssi_Xmitted[0] = NUM_US_TSSI_VALUES_INITIAL_CLR;

   gsa_num_DS_Tssi_brkpt[0] = 0;
   gsa_num_DS_Tssi_brkpt_kept[0] = 0;
   gsa_num_US_Tssi_brkpt[0] = 0;
   gsa_num_US_Tssi_brkpt_kept[0] = 0;

   puca_CLR_USTssiIndex = (uint8*)(void *)gpusa_CLR_USTssiIndex + s_index;
   puca_CLR_USTssiValue = gpuca_CLR_USTssiValue + s_index;
   pfta_CLR_USTssiSi = gpfta_CLR_USTssiSi + (s_index/8);

#ifdef ISDN
   if (s_annex == G992_3_ANNEX_B)
   {
      // Choose US TSSi according to the preferred US PSD mask
      for (i = 0; i < NUM_US_TSSI_VALUES_INITIAL_CLR; i++)
      {
         puca_CLR_USTssiIndex[i] = guca_US_TssiIndex_G9923B[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_B]][i];
         puca_CLR_USTssiValue[i] = guca_US_TssiValue_G9923B[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_B]][i];
      }
      pfta_CLR_USTssiSi[0] = gfta_US_SprtSet_G9923B[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_B]][0];

      // Set NOMPSD*10, MAXNOMPSD*10, MAXNOMATP*10 in dB according to the PSD mask
      pt_BisInfo->t_PMD_NPar3_US.s_NOMPSD          = gsa_US_NOMPSD_G9923B[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_B]];      /*  Upstream nominal PSD */
      pt_BisInfo->t_PMD_NPar3_US.s_MAXNOMPSD    = gsa_US_MAXNOMPSD_G9923B[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_B]];   /*  Upstream maximum PSD */
      pt_BisInfo->t_PMD_NPar3_US.s_MAXNOMATP    = gsa_US_MAXNOMATP_G9923B[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_B]];   /*  Upstream maximum aggregrate transmit power */
   }
   else if (s_annex == G992_3_ANNEX_J)
   {//assume 3.J and 5.J use the same table
      // Choose US TSSi according to the preferred US PSD mask
      for (i = 0; i < NUM_US_TSSI_VALUES_INITIAL_CLR; i++)
      {
         puca_CLR_USTssiIndex[i] = guca_US_TssiIndex_AnnexJ[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_J]][i];
         puca_CLR_USTssiValue[i] = guca_US_TssiValue_AnnexJ[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_J]][i];
      }
      pfta_CLR_USTssiSi[0] = gfta_US_SprtSet_AnnexJ[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_J]][0];

      // Set NOMPSD*10, MAXNOMPSD*10, MAXNOMATP*10 in dB according to the PSD mask
      pt_BisInfo->t_PMD_NPar3_US.s_NOMPSD          = gsa_US_NOMPSD_AnnexJ[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_J]];      /*  Upstream nominal PSD */
      pt_BisInfo->t_PMD_NPar3_US.s_MAXNOMPSD    = gsa_US_MAXNOMPSD_AnnexJ[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_J]];   /*  Upstream maximum PSD */
      pt_BisInfo->t_PMD_NPar3_US.s_MAXNOMATP    = gsa_US_MAXNOMATP_AnnexJ[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_J]];   /*  Upstream maximum aggregrate transmit power */
   }
#else //ISDN
   if (s_annex == G992_3_ANNEX_A)
   {
      // Choose US TSSi according to the preferred US PSD mask
      for (i = 0; i < NUM_US_TSSI_VALUES_INITIAL_CLR; i++)
      {
         puca_CLR_USTssiIndex[i] = guca_US_TssiIndex_G9923A[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_A]][i];
         puca_CLR_USTssiValue[i] = guca_US_TssiValue_G9923A[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_A]][i];
      }
      pfta_CLR_USTssiSi[0] = gfta_US_SprtSet_G9923A[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_A]][0];

      // Set NOMPSD*10, MAXNOMPSD*10, MAXNOMATP*10 in dB according to the PSD mask
      pt_BisInfo->t_PMD_NPar3_US.s_NOMPSD          = gsa_US_NOMPSD_G9923A[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_A]];      /*  Upstream nominal PSD */
      pt_BisInfo->t_PMD_NPar3_US.s_MAXNOMPSD    = gsa_US_MAXNOMPSD_G9923A[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_A]];   /*  Upstream maximum PSD */
      pt_BisInfo->t_PMD_NPar3_US.s_MAXNOMATP    = gsa_US_MAXNOMATP_G9923A[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_A]];   /*  Upstream maximum aggregrate transmit power */
   }
   else if (s_annex == G992_3_ANNEX_I)
   {//Use Annex-A's stuff first
      // Choose US TSSi according to the preferred US PSD mask
      for (i = 0; i < NUM_US_TSSI_VALUES_INITIAL_CLR; i++)
      {
         puca_CLR_USTssiIndex[i] = guca_US_TssiIndex_AnnexI[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_I]][i];
         puca_CLR_USTssiValue[i] = guca_US_TssiValue_AnnexI[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_I]][i];
      }
      pfta_CLR_USTssiSi[0] = gfta_US_SprtSet_AnnexI[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_I]][0];

      // Set NOMPSD*10, MAXNOMPSD*10, MAXNOMATP*10 in dB according to the PSD mask
      pt_BisInfo->t_PMD_NPar3_US.s_NOMPSD          = gsa_US_NOMPSD_AnnexI[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_I]];      /*  Upstream nominal PSD */
      pt_BisInfo->t_PMD_NPar3_US.s_MAXNOMPSD    = gsa_US_MAXNOMPSD_AnnexI[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_I]];   /*  Upstream maximum PSD */
      pt_BisInfo->t_PMD_NPar3_US.s_MAXNOMATP    = gsa_US_MAXNOMATP_AnnexI[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_I]];   /*  Upstream maximum aggregrate transmit power */
   }
#endif//ISDN
   else if (s_annex == G992_3_ANNEX_M)
   {
      // Choose US TSSi according to the preferred US PSD mask
      for (i = 0; i < NUM_US_TSSI_VALUES_INITIAL_CLR; i++)
      {
         puca_CLR_USTssiIndex[i] = guca_US_TssiIndex_AnnexM[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_M]][i];
         puca_CLR_USTssiValue[i] = guca_US_TssiValue_AnnexM[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_M]][i];
      }
      pfta_CLR_USTssiSi[0] = gfta_US_SprtSet_AnnexM[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_M]][0];

      // Set NOMPSD*10, MAXNOMPSD*10, MAXNOMATP*10 in dB according to the PSD mask
      pt_BisInfo->t_PMD_NPar3_US.s_NOMPSD          = gsa_US_NOMPSD_AnnexM[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_M]];      /*  Upstream nominal PSD */
      pt_BisInfo->t_PMD_NPar3_US.s_MAXNOMPSD    = gsa_US_MAXNOMPSD_AnnexM[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_M]];   /*  Upstream maximum PSD */
      pt_BisInfo->t_PMD_NPar3_US.s_MAXNOMATP    = gsa_US_MAXNOMATP_AnnexM[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_M]];   /*  Upstream maximum aggregrate transmit power */
   }

   pt_BisInfo->t_PMD_NPar3_US.pus_BreakFreq = (uint16*)(void *)puca_CLR_USTssiIndex;
   pt_BisInfo->t_PMD_NPar3_US.pf_InSprtSet = pfta_CLR_USTssiSi;
   pt_BisInfo->t_PMD_NPar3_US.puc_tssi = puca_CLR_USTssiValue;

   pt_BisInfo->t_PMD_NPar3_DS.s_NOMPSD         = NOMPSD_DS;      /*  Downstream nominal PSD */
   pt_BisInfo->t_PMD_NPar3_DS.s_MAXNOMPSD    = MAXNOMPSD_DS;   /*  Downstream maximum PSD */
   pt_BisInfo->t_PMD_NPar3_DS.s_MAXNOMATP    = MAXNOMATP_DS;   /*  Downstream maximum aggregrate transmit power */

   pt_BisInfo->uc_TxSignalNyq = SIGNAL_ABOVE_NYQUIST_FREQ;
}

/*************************************************************************************
  ;   Prototype: void InitGlobalVariables2_BisInfoRx(Adsl2AllInfo_t *pt_BisInfo, int16 s_annex);
  ;
  ;   Description:
  ;
  ;      Initialize the tx global variables associated with a Bis (ADSL2) or
  ;      BisPlus (ADSL2+) data structure (which in turn is a component of the
  ;      a InfoField structure).
  ;
  ;   Arguments:
  ;      *pt_BisInfo   - pointer to BisInfo structure
  ;
  ;   Return Value:
  ;      none
  ;
  ;   Global Variables:
  ;
  ;**************************************************************************************/
#ifndef BIS_CODESWAP
int16 gs_COTSSI_NumOfBrkpts;
uint8 guca_COTSSI_Index[64], guca_COTSSI_Si[8], guca_COTSSI_Value[64];
#endif
void InitGlobalVariables2_BisInfoRx(Adsl2AllInfo_t *pt_BisInfo, int16 s_annex) {
   int i, s_index;
   uint8 *puca_CL_TssiIndex, *puca_CL_TssiValue, *pfta_CL_TssiSi;

   /* Initialize Bis (ADSL2) TSSI Information RxInfo */
   s_index = s_annex*MAX_NUM_US_TSSI_VALUES;
   puca_CL_TssiIndex = (uint8*)(void *)gpusa_CL_USTssiIndex + s_index;
   puca_CL_TssiValue = gpuca_CL_USTssiValue + s_index;
   pfta_CL_TssiSi = gpfta_CL_USTssiSi + (s_index/8);

   pt_BisInfo->t_PMD_NPar3_US.pus_BreakFreq = (uint16*)(void *)puca_CL_TssiIndex;
   pt_BisInfo->t_PMD_NPar3_US.puc_tssi = puca_CL_TssiValue;
   pt_BisInfo->t_PMD_NPar3_US.pf_InSprtSet = pfta_CL_TssiSi;

   for (i = 0; i < MAX_NUM_DS_TSSI_VALUES; i++)
   {
      gusa_DS_TssiIndex_G9923[s_annex][i] = 0;
      guca_DS_TssiValue_G9923[s_annex][i] = 0;
      gfta_DS_SprtSet_G9923[s_annex][i>>3] = 0;
   }
   pt_BisInfo->t_PMD_NPar3_DS.pus_BreakFreq = &gusa_DS_TssiIndex_G9923[s_annex][0];
   pt_BisInfo->t_PMD_NPar3_DS.puc_tssi = &guca_DS_TssiValue_G9923[s_annex][0];
   pt_BisInfo->t_PMD_NPar3_DS.pf_InSprtSet = &gfta_DS_SprtSet_G9923[s_annex][0];

#ifndef BIS_CODESWAP
   if (TESTArray[TEST_ReconfigControl] & TEST_USTssi_Inconsistency)
   {
      int16 s_COTSSI_NumOfBrkpts;
      if (gs_COTSSI_NumOfBrkpts > MAX_NUM_US_TSSI_VALUES)
         s_COTSSI_NumOfBrkpts = MAX_NUM_US_TSSI_VALUES;
      else
         s_COTSSI_NumOfBrkpts = gs_COTSSI_NumOfBrkpts;

      memcpy(puca_CL_TssiIndex, guca_COTSSI_Index, s_COTSSI_NumOfBrkpts);
      memcpy(puca_CL_TssiValue, guca_COTSSI_Value, s_COTSSI_NumOfBrkpts);
      memcpy(pfta_CL_TssiSi, guca_COTSSI_Si, s_COTSSI_NumOfBrkpts<<3);
   }
#endif
}


/*************************************************************************************
  ;   Prototype: void InitGlobalVariables2_BisPlusInfoTx(Adsl2AllInfo_t *pt_BisPlusInfo, int16 s_annex);
  ;
  ;   Description:
  ;
  ;      Initialize the tx global variables associated with a Bis (ADSL2) or
  ;   BisPlus (ADSL2+) data structure (which in turn is a component of the
  ;   a InfoField structure).
  ;
  ;   Arguments:
  ;      *pt_BisPlusInfo   - pointer to BisInfo structure
  ;
  ;   Return Value:
  ;      none
  ;
  ;   Global Variables:
  ;
  ;**************************************************************************************/
void InitGlobalVariables2_BisPlusInfoTx(Adsl2AllInfo_t *pt_BisPlusInfo, int16 s_annex)
{
   int i, s_index;
   uint8* puca_CLR_USTssiIndex, *puca_CLR_USTssiValue, *pfta_CLR_USTssiSi;

   gsa_num_USTssi_Xmitted[1] = NUM_US_TSSI_VALUES_INITIAL_CLR;
   gsa_num_DS_Tssi_brkpt[1] = 0;
   gsa_num_DS_Tssi_brkpt_kept[1] = 0;
   gsa_num_US_Tssi_brkpt[1] = 0;
   gsa_num_US_Tssi_brkpt_kept[1] = 0;

   s_index = MAX_NUM_US_TSSI_VALUES*NUM_G992_3_ANNEX_SUPPORTED+s_annex*MAX_NUM_US_TSSI_VALUES;
   puca_CLR_USTssiIndex = (uint8*)(void *)gpusa_CLR_USTssiIndex + s_index;
   puca_CLR_USTssiValue = gpuca_CLR_USTssiValue + s_index;
   pfta_CLR_USTssiSi = gpfta_CLR_USTssiSi + (s_index>>3);

#ifdef ISDN
   if (s_annex == G992_5_ANNEX_B)
   {
      // Choose US TSSi according to the preferred US PSD mask
      for (i = 0; i < NUM_US_TSSI_VALUES_INITIAL_CLR; i++)
      {
         puca_CLR_USTssiIndex[i] = guca_US_TssiIndex_G9925B[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_B]][i];
         puca_CLR_USTssiValue[i] = guca_US_TssiValue_G9925B[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_B]][i];
      }
      pfta_CLR_USTssiSi[0] = gfta_US_SprtSet_G9925B[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_B]][0];

      // Set NOMPSD*10, MAXNOMPSD*10, MAXNOMATP*10 in dB according to the PSD mask
      pt_BisPlusInfo->t_PMD_NPar3_US.s_NOMPSD          = gsa_US_NOMPSD_G9925B[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_B]];      /*  Upstream nominal PSD */
      pt_BisPlusInfo->t_PMD_NPar3_US.s_MAXNOMPSD    = gsa_US_MAXNOMPSD_G9925B[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_B]];  /*  Upstream maximum PSD */
      pt_BisPlusInfo->t_PMD_NPar3_US.s_MAXNOMATP    = gsa_US_MAXNOMATP_G9925B[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_B]];   /*  Upstream maximum aggregrate transmit power */
   }
   else if (s_annex == G992_5_ANNEX_J)
   {
      // Choose US TSSi according to the preferred US PSD mask
      for (i = 0; i < NUM_US_TSSI_VALUES_INITIAL_CLR; i++)
      {
         puca_CLR_USTssiIndex[i] = guca_US_TssiIndex_AnnexJ[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_J]][i];
         puca_CLR_USTssiValue[i] = guca_US_TssiValue_AnnexJ[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_J]][i];
      }
      pfta_CLR_USTssiSi[0] = gfta_US_SprtSet_AnnexJ[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_J]][0];

      // Set NOMPSD*10, MAXNOMPSD*10, MAXNOMATP*10 in dB according to the PSD mask
      pt_BisPlusInfo->t_PMD_NPar3_US.s_NOMPSD          = gsa_US_NOMPSD_AnnexJ[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_J]];      /*  Upstream nominal PSD */
      pt_BisPlusInfo->t_PMD_NPar3_US.s_MAXNOMPSD    = gsa_US_MAXNOMPSD_AnnexJ[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_J]];   /*  Upstream maximum PSD */
      pt_BisPlusInfo->t_PMD_NPar3_US.s_MAXNOMATP    = gsa_US_MAXNOMATP_AnnexJ[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_J]];   /*  Upstream maximum aggregrate transmit power */
   }
#else//ISDN
   if (s_annex == G992_5_ANNEX_A)
   {
      // Choose US TSSi according to the preferred US PSD mask
      for (i = 0; i < NUM_US_TSSI_VALUES_INITIAL_CLR; i++)
      {
         puca_CLR_USTssiIndex[i] = guca_US_TssiIndex_G9925A[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_A]][i];
         puca_CLR_USTssiValue[i] = guca_US_TssiValue_G9925A[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_A]][i];
      }

      pfta_CLR_USTssiSi[0] = gfta_US_SprtSet_G9925A[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_A]][0];

      // Set NOMPSD*10, MAXNOMPSD*10, MAXNOMATP*10 in dB according to the PSD mask
      pt_BisPlusInfo->t_PMD_NPar3_US.s_NOMPSD          = gsa_US_NOMPSD_G9925A[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_A]];      /*  Upstream nominal PSD */
      pt_BisPlusInfo->t_PMD_NPar3_US.s_MAXNOMPSD    = gsa_US_MAXNOMPSD_G9925A[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_A]];  /*  Upstream maximum PSD */
      pt_BisPlusInfo->t_PMD_NPar3_US.s_MAXNOMATP    = gsa_US_MAXNOMATP_G9925A[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_A]];   /*  Upstream maximum aggregrate transmit power */
   }
   else if (s_annex == G992_5_ANNEX_I)
   {
      //For G992.5.I it seems US has no difference from G992.3 case, so we used the set for G992.3I
      // Choose US TSSi according to the preferred US PSD mask
      for (i = 0; i < NUM_US_TSSI_VALUES_INITIAL_CLR; i++)
      {
         puca_CLR_USTssiIndex[i] = guca_US_TssiIndex_AnnexI[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_I]][i];
         puca_CLR_USTssiValue[i] = guca_US_TssiValue_AnnexI[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_I]][i];
      }
      pfta_CLR_USTssiSi[0] = gfta_US_SprtSet_AnnexI[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_I]][0];

      // Set NOMPSD*10, MAXNOMPSD*10, MAXNOMATP*10 in dB according to the PSD mask
      pt_BisPlusInfo->t_PMD_NPar3_US.s_NOMPSD          = gsa_US_NOMPSD_AnnexI[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_I]];      /*  Upstream nominal PSD */
      pt_BisPlusInfo->t_PMD_NPar3_US.s_MAXNOMPSD    = gsa_US_MAXNOMPSD_AnnexI[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_I]];   /*  Upstream maximum PSD */
      pt_BisPlusInfo->t_PMD_NPar3_US.s_MAXNOMATP    = gsa_US_MAXNOMATP_AnnexI[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_I]];   /*  Upstream maximum aggregrate transmit power */
   }
#endif//ISDN
   else if (s_annex == G992_5_ANNEX_M)
   {
      //For G992.5.M it seems US has no difference from G992.3 case, so we used the set for G992.3M
      // Choose US TSSi according to the preferred US PSD mask
      for (i = 0; i < NUM_US_TSSI_VALUES_INITIAL_CLR; i++)
      {
         puca_CLR_USTssiIndex[i] = guca_US_TssiIndex_AnnexM[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_M]][i];
         puca_CLR_USTssiValue[i] = guca_US_TssiValue_AnnexM[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_M]][i];
      }

      pfta_CLR_USTssiSi[0] = gfta_US_SprtSet_AnnexM[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_M]][0];

      // Set NOMPSD*10, MAXNOMPSD*10, MAXNOMATP*10 in dB according to the PSD mask
      pt_BisPlusInfo->t_PMD_NPar3_US.s_NOMPSD          = gsa_US_NOMPSD_AnnexM[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_M]];      /*  Upstream nominal PSD */
      pt_BisPlusInfo->t_PMD_NPar3_US.s_MAXNOMPSD    = gsa_US_MAXNOMPSD_AnnexM[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_M]];   /*  Upstream maximum PSD */
      pt_BisPlusInfo->t_PMD_NPar3_US.s_MAXNOMATP    = gsa_US_MAXNOMATP_AnnexM[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_M]];   /*  Upstream maximum aggregrate transmit power */
   }

   pt_BisPlusInfo->t_PMD_NPar3_US.pus_BreakFreq = (uint16*)(void *)puca_CLR_USTssiIndex;
   pt_BisPlusInfo->t_PMD_NPar3_US.pf_InSprtSet = pfta_CLR_USTssiSi;
   pt_BisPlusInfo->t_PMD_NPar3_US.puc_tssi = puca_CLR_USTssiValue;

   pt_BisPlusInfo->t_PMD_NPar3_DS.s_NOMPSD         = NOMPSD_DS;      /*  Downstream nominal PSD */
   pt_BisPlusInfo->t_PMD_NPar3_DS.s_MAXNOMPSD    = MAXNOMPSD_DS;   /*  Downstream maximum PSD */
   pt_BisPlusInfo->t_PMD_NPar3_DS.s_MAXNOMATP    = MAXNOMATP_DS;   /*  Downstream maximum aggregrate transmit power */

   pt_BisPlusInfo->uc_TxSignalNyq = SIGNAL_ABOVE_NYQUIST_FREQ;
}

/*************************************************************************************
  ;   Prototype: void InitGlobalVariables2_BisPlusInfoRx(Adsl2AllInfo_t *pt_BisPlusInfo, int16 s_annex);
  ;
  ;   Description:
  ;
  ;      Initialize the tx global variables associated with a Bis (ADSL2) or
  ;      BisPlus (ADSL2+) data structure (which in turn is a component of the
  ;      a InfoField structure).
  ;
  ;   Arguments:
  ;      *pt_BisPlusInfo   - pointer to BisInfo structure
  ;
  ;   Return Value:
  ;      none
  ;
  ;   Global Variables:
  ;
  ;**************************************************************************************/
void InitGlobalVariables2_BisPlusInfoRx(Adsl2AllInfo_t *pt_BisPlusInfo, int16 s_annex) {
   int i, s_index;
   uint8 *puca_CL_TssiIndex, *puca_CL_TssiValue, *pfta_CL_TssiSi;


   /* Initialize Bis (ADSL2+) TSSI Information in TxInfo and RxInfo */
   s_index = MAX_NUM_US_TSSI_VALUES*NUM_G992_3_ANNEX_SUPPORTED+s_annex*MAX_NUM_US_TSSI_VALUES;
   puca_CL_TssiIndex = (uint8*)(void *)gpusa_CL_USTssiIndex + s_index;
   puca_CL_TssiValue = gpuca_CL_USTssiValue + s_index;
   pfta_CL_TssiSi = gpfta_CL_USTssiSi + (s_index/8);

   pt_BisPlusInfo->t_PMD_NPar3_US.pus_BreakFreq = (uint16*)(void *)puca_CL_TssiIndex;
   pt_BisPlusInfo->t_PMD_NPar3_US.puc_tssi = puca_CL_TssiValue;
   pt_BisPlusInfo->t_PMD_NPar3_US.pf_InSprtSet = pfta_CL_TssiSi;

   for (i = 0; i < MAX_NUM_DS_TSSI_VALUES; i++)
   {
      gusa_DS_TssiIndex_G9925[s_annex][i] = 0;
      guca_DS_TssiValue_G9925[s_annex][i] = 0;
      gfta_DS_SprtSet_G9925[s_annex][i>>3] = 0;
   }

   pt_BisPlusInfo->t_PMD_NPar3_DS.pus_BreakFreq = &gusa_DS_TssiIndex_G9925[s_annex][0];
   pt_BisPlusInfo->t_PMD_NPar3_DS.puc_tssi = &guca_DS_TssiValue_G9925[s_annex][0];
   pt_BisPlusInfo->t_PMD_NPar3_DS.pf_InSprtSet = &gfta_DS_SprtSet_G9925[s_annex][0];

#ifndef BIS_CODESWAP
   if (TESTArray[TEST_ReconfigControl] & TEST_USTssi_Inconsistency)
   {
      int16 s_COTSSI_NumOfBrkpts;
      if (gs_COTSSI_NumOfBrkpts > MAX_NUM_US_TSSI_VALUES)
         s_COTSSI_NumOfBrkpts = MAX_NUM_US_TSSI_VALUES;
      else
         s_COTSSI_NumOfBrkpts = gs_COTSSI_NumOfBrkpts;

      memcpy(puca_CL_TssiIndex, guca_COTSSI_Index, s_COTSSI_NumOfBrkpts);
      memcpy(puca_CL_TssiValue, guca_COTSSI_Value, s_COTSSI_NumOfBrkpts);
      memcpy(pfta_CL_TssiSi, guca_COTSSI_Si, s_COTSSI_NumOfBrkpts<<3);
   }
#endif

}

//XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map (Start)
/*************************************************************************************
  ;  Prototype: void ConfigAdslFeatureMap (void);
  ;
  ;   Description:
  ;
  ;     Configures a 'Feature Map' (as required by CMV DSL 19) based on the
  ;     features supported by ADSL FW.
  ;
  ;   Arguments:
  ;      none
  ;
  ;   Return Value:
  ;      none
  ;
  ;   Global Variables:
  ;
  ;**************************************************************************************/
void ConfigAdslFeatureMap(void)
{
   // XDSLRTFW-3636 (Start)
   //Refer to CMV 'DSL 19' in Message Spec ver 3.1
   memset(&gt_AdslFeatureMap, 0, sizeof(gt_AdslFeatureMap));

   // Parameter 2
   gt_AdslFeatureMap.us_Length = 4; // Length of the DSL 19 payload data (inclding the length)

   // Parameter 3
   gt_AdslFeatureMap.Param[0] = ((ADSL_FEATURE_AFE_POWER_DOWN << 12) |  // XDSLRTFW-3648 (Start_End)
                                  (ADSL_FEATURE_NTR << 11) |
                                  (ADSL_FEATURE_CI_POLICY << 10) |
                                  (ADSL_FEATURE_PRE_EMPTION_AND_SHORT_PACKETS << 9) |
                                  (ADSL_FEATURE_COUNTER_INHIBITING << 8) |
                                  (ADSL_FEATURE_SHORT_INIT << 7) |
                                  (ADSL_FEATURE_DS_RETX_SRA << 5) |
                                  (ADSL_FEATURE_DS_RETX_PTM_BONDING << 4) |
                                  (ADSL_FEATURE_PTM_OFFCHIP_BONDING << 3) |
                                  (ADSL_FEATURE_ANNEX_I)
                                 );

   // Parameter 4
   // Reserved for future usage

   // Parameter 5
   // Reserved for Internal Features
   // XDSLRTFW-3636 (End)
}
