/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   statein1_dmt.c
*
*   Transceiver Training Phase RX State Functions for ATU-R.
*   Covering the RX states: R_C_QUIET2, R_C_PILOT1
*
*   Notes:
*
*
*------------------------------------------------------------------------
*/
// ******************************************************************
// statein1_dmt.c
//
// History
// 15/07/2011 Kannan: T1413 bring up. Codeswap Failure fixed.
//           Grep for XDSLRTFW-254 Feature_ALL_T1413_ALL_Bringup
//
//03/09/2012  Anantha: Changed variable name prefix to reflect change in data type
//Grep pattern XDSLRTFW-496: Feature_T1413_Info
// ******************************************************************

#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "pll.h"
#include "rt_tones.h"
#include "rx_ops.h"
#include "vecpwr.h"
#include "detect.h"
#include "states.h"
#include "RCReverb1RxF.h"
#include "rinfotbl.h"
#include "exchdata.h"
#include "T1413.h"
#include "fft_tab.h"
#include "cmv.h"
#include "aoc_ini.h"
#include "tx_eoc.h"
#include "rx_eoc.h"
#include "tx_ib.h"
#include "rx_ib.h"

#ifdef BIS_CODESWAP
#include "codeswap.h"
#include "soc_codeswap.h"
#endif




/*************************************************************************************
;  Prototype: void InitGlobalVariables_DMT(void);
;
;  Description:
;     This function is used to initialize the DMT only data variables after the
;     the DMT only data page has been codeswapped.
;
;  Arguments:
;     none
;
;  Return Value:
;     none
;
;  Global Variables:
;
;**************************************************************************************/
extern uint16 gus_last_crc_cnt;   //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)

void InitGlobalVariables_DMT(void)
{
    int16 i;

    for(i = 0; i < 4; i++)
    guca_PreAmbleField[i] = 0x55;

#ifdef ISDN
    gs_PGA_margin += gs_PGA_margin_delta_DMT_VR9;
#endif

    /* ======================================================================== */
    /*  Structure for R_MSGS1 */
    /* ======================================================================== */
    gt_RMsgs1.us_TrellisCoding_Option = TCM_OPTION;      /* Trellis Coding Option (DEFAULT is OFF, and controlled by  */
    /* OPTNArray[OPTN_Control].                          */

    gt_RMsgs1.us_EC_Option = OVERLAP_SPECTRUM_OPTION; /* echo canceler option */
    gt_RMsgs1.us_Higher_BitRates = S_HALF_OPTION;     /* support for Higher bit rates (S=1/2) */
    /* (DEFAULT is OFF, and controlled by OPTNArray[OPTN_Control].)*/
    gt_RMsgs1.us_DS_DualLatency = DUAL_PATH_OPTION;      /* support for dual latency downstream */
    gt_RMsgs1.us_US_DualLatency = DUAL_PATH_OPTION;      /* support for dual latency upstream     */
    gt_RMsgs1.us_NTR_Option= NTR_OPTION;           /* NTR option */
    gt_RMsgs1.us_FrameMode = FRAMING_MODE_OPTION;     /* framing mode */
    gt_RMsgs1.us_MaxBitsPerTone = TX_MAX_BITS_PER_TONE;  /* maximum numbers of bits per tone supported */
    gt_RMsgs1.us_T1413_Vendor_Id = gs_ne_T1413_VendorID;    /* T1.413 vendor id */
   //XDSLRTFW-496: Feature_T1413_Info(start)
    gt_RMsgs1.us_T1413_RevNo = T1413_REV_NO;       /* T1.413 revision number */
    gt_RMsgs1.us_T1413_Vendor_RevNo = T1413_VENDOR_REV_NO;/* T1.413 Vendor revision number */
    //XDSLRTFW-496: Feature_T1413_Info(end)

    gt_RMsgs1.uc_T1413_Ees = T1413_EES_FLAG;       /* T1.413 expanded exchange sequence */

    gs_DS_RateOption = 0;                       /* final downstream rate option */
    gs_US_RateOption = 0;                       /* final upstream rate option */

    /*  AOC variables */
    gpt_TxAocHandler = &gt_TxAocHandler;           /* pointer to TxAocHandler data structure */
    gpt_RxAocHandler = &gt_RxAocHandler;           /* pointer to RxAocHandler data structure */

    /*  EOC variables */
    gpt_TxEocHandler = &gt_TxEocHandler;           /* pointer to this structure */
    gpt_TxEocNetworkHandler = &gt_TxEocNetworkHandler;   /* pointer to this structure */
    gpt_RxEocHandler = &gt_RxEocHandler;           /* pointer to this structure */
    gpt_TxEocDgasp = &gt_TxEocDgasp;               /* pointer to gt_TxEocDgasp */
    gpt_TxEocNetworkInput = &gt_TxEocNetworkInput;    /* pointer to this structure */
    gpt_RxEocDecod = &gt_RxEocDecod;               /* pointer to gt_RxEocDecod */
    gpt_EocRxReadBuf = &gt_EocRxReadBuf;           /* pointer to gt_EocRxReadBuf */

    gus_RS_Overhead = (uint16)(RS_OVERHEAD_PERCENTAGE*32768+0.5); /* in Q1.15 format */

    /* Parameters relating to Rate Options */
    for (i=0; i<NUM_DS_RATE_OPTIONS; i++)
    {
        gta_DS_options[i].pus_ReqBytes = &gusa_DS_ReqBytes[i*NUM_DS_BEARER_CHANNELS*NUM_DATA_PATHS];
        gta_DS_options[i].puc_CheckBytes = &guca_DS_CheckBytes[i*NUM_DATA_PATHS];
        gta_US_options[i].pus_ReqBytes = &gusa_US_ReqBytes[i*NUM_US_BEARER_CHANNELS*NUM_DATA_PATHS];
        gta_US_options[i].puc_CheckBytes = &guca_US_CheckBytes[i*NUM_DATA_PATHS];
    }

    gft_RCExchRARcvFlag = NOT_RECEIVE;          /*  flag indicating the status of reception of C_Exch_RA */
    gft_RCExch2RcvFlag  = NOT_RECEIVE;          /*  flag indicating the status of reception of C_Exch2 */
    gft_RCSegue3RcvFlag = NOT_RECEIVE;          /*  flag indicating the status of reception of C_Segue3 */

    gft_TxInFastRetrain_flag = FALSE;
    gft_RxInFastRetrain_flag = FALSE;

    gft_FailOnCRCBurst = FALSE;    /*  == TRUE, enables abort showtime on CRC error burst */

    gft_FR_trigger_on_CRC = FALSE;

    guc_aoc_msg_id = AOC_MSG_ID_UNDEFINED;
    guc_next_rx_profile_number = 0; /* next RX profile number */
    guc_remote_max_profiles = NUM_PROFILES;  /* the maximum no. of profiles supported by remote site */
    guc_num_rx_profiles_stored = 0;       /* number of stored RX profiles */
    guc_num_tx_profiles_stored = 0;
    gft_FR_Truncate_Flag = FALSE;

    gpsa_DS_BitAndGain = (int16 *)(void *)gsa_CommonTwidMem;

    //initiate DMT bitswap counters
    gs_BITSWAP_TRIGGER_DELTA = 0x300;  //3dB
    gs_Bitswap_Accept_Delta = 0x200;   //2dB

    gs_BitSwapLogIndex = 2*MAX_STATES;
    gs_DMT_USBitSwapErrorCode = 0;

    guc_AocTxMaxRetries = AOC_TX_MAX_RETRIES;

    gft_TxBitSwapFlag = FALSE;      /* TRUE means requesting TX bit swap */
    gft_RxBitSwapFlag = FALSE;
    gft_BitSwapPerform = 0;      //Flag indicate the Bkgd PerformRxBitSwap status

    gus_last_crc_cnt = 0;   //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)


   INFOMap[INFO_RCMsgs1] = (int16*)(void *)&gt_RCMsgs1;

    /* Initialize AOC, EOC, IB data. */
    RxInitIb();
    RxAocInit();
    RxEocInit();
    TxAocInit();
    TxEocInit();
    TxInitIb();

#ifdef BIS_CODESWAP
    /* Codeswap sections trigger times have to change from the (BIS) original ones
    * Commented-out (for PM reasons) lines are same as BIS - are copied here for clarity */
    gsa_CodeSwapStartState[CSPAGE_BIS_XCVR1]  = -1;            // Will be triggered immediately after BIS_DMT_RAM is in
    //gla_CodeSwapStartSymbol[CSPAGE_BIS_XCVR1] = 0;
    gsa_CodeSwapNextSection[CSPAGE_BIS_XCVR1] = CSPAGE_BIS_XCVR1EXT;

    gsa_CodeSwapStartState[CSPAGE_BIS_XCVR1EXT]  = R_C_REVERB1_RX;
    //   gla_CodeSwapStartSymbol[CSPAGE_BIS_XCVR1EXT] = 0;
    gsa_CodeSwapNextSection[CSPAGE_BIS_XCVR1EXT] = CSPAGE_BIS_XCVRDMT;

    gsa_CodeSwapStartState[CSPAGE_BIS_XCVRDMT]  = -1;          // Will be triggered in R_C_ECT_RX, when RRev1Tx is done
    //gla_CodeSwapStartSymbol[CSPAGE_BIS_XCVRDMT] = 0;
    gsa_CodeSwapNextSection[CSPAGE_BIS_XCVRDMT] = CSPAGE_BIS_ANAL;

    gsa_CodeSwapStartState[CSPAGE_BIS_ANAL]  = R_C_REVERB2_RX;
    //gla_CodeSwapStartSymbol[CSPAGE_BIS_ANAL] = 0;
    gsa_CodeSwapNextSection[CSPAGE_BIS_ANAL] = CSPAGE_BIS_ANL1DMT;

    //gsa_CodeSwapStartState[CSPAGE_BIS_ANL1DMT]  = R_C_REVERB3_RX;
    //gla_CodeSwapStartSymbol[CSPAGE_BIS_ANL1DMT] = 0;
    //gsa_CodeSwapNextSection[CSPAGE_BIS_ANL1DMT] = CSPAGE_BIS_MTDQ;

    gsa_CodeSwapStartState[CSPAGE_BIS_MTDQ]  = R_C_RATES1_RX;
   //XDSLRTFW-254   Feature_ALL_T1413_ALL_Bringup(START)
//#ifdef DANUBE
    gsa_CodeSwapTxStartState[CSPAGE_BIS_MTDQ]  = R_REVERB3_TX;
//#else
//    gsa_CodeSwapTxStartState[CSPAGE_BIS_MTDQ]  = R_SEGUE1_TX;
//#endif
   //XDSLRTFW-254   Feature_ALL_T1413_ALL_Bringup(END)
    //gla_CodeSwapStartSymbol[CSPAGE_BIS_MTDQ] = 0;
    gsa_CodeSwapNextSection[CSPAGE_BIS_MTDQ] = CSPAGE_BIS_BTLDDMT;

    //gsa_CodeSwapStartState[CSPAGE_BIS_BTLDDMT]  = -1;              // When MultiTDQ is done
    //gla_CodeSwapStartSymbol[CSPAGE_BIS_BTLDDMT] = 0;
    //gsa_CodeSwapNextSection[CSPAGE_BIS_BTLDDMT] = CSPAGE_BIS_RXINIT;

    gsa_CodeSwapStartState[CSPAGE_BIS_RXINIT]  = -1;
    //   gla_CodeSwapStartSymbol[CSPAGE_BIS_RXINIT] = 0;
#ifndef ADSL_62
    gsa_CodeSwapNextSection[CSPAGE_BIS_RXINIT] = CSPAGE_BIS_TXINIT;
#else
    gsa_CodeSwapNextSection[CSPAGE_BIS_RXINIT] = CSPAGE_BIS_ZEP_TX_UCODE_ADSL1_LP0;
#endif
    //gsa_CodeSwapStartState[CSPAGE_BIS_TXINIT]  = -1;
    //gla_CodeSwapStartSymbol[CSPAGE_BIS_TXINIT] = -1;
    gsa_CodeSwapNextSection[CSPAGE_BIS_TXINIT] = CSPAGE_BIS_EXCHDMT;

    gsa_CodeSwapStartState[CSPAGE_BIS_ZEP_TX_UCODE_ADSL1_LP0]  = -1;
    gla_CodeSwapStartSymbol[CSPAGE_BIS_ZEP_TX_UCODE_ADSL1_LP0] = 0;
    gsa_CodeSwapNextSection[CSPAGE_BIS_ZEP_TX_UCODE_ADSL1_LP0] = CSPAGE_BIS_ZEP_RX_UCODE_ADSL1_LP0;

    gsa_CodeSwapStartState[CSPAGE_BIS_ZEP_RX_UCODE_ADSL1_LP0]  = -1;
    gla_CodeSwapStartSymbol[CSPAGE_BIS_ZEP_RX_UCODE_ADSL1_LP0] = 0;
    gsa_CodeSwapNextSection[CSPAGE_BIS_ZEP_RX_UCODE_ADSL1_LP0] = CSPAGE_BIS_TXINIT;

    gsa_CodeSwapStartState[CSPAGE_BIS_ZEP_TX_UCODE_ADSL1_LP1]  = -1;
    gla_CodeSwapStartSymbol[CSPAGE_BIS_ZEP_TX_UCODE_ADSL1_LP1] = 0;
    gsa_CodeSwapNextSection[CSPAGE_BIS_ZEP_TX_UCODE_ADSL1_LP1] = CSPAGE_BIS_ZEP_RX_UCODE_ADSL1_LP1;

    gsa_CodeSwapStartState[CSPAGE_BIS_ZEP_RX_UCODE_ADSL1_LP1]  = -1;
    gla_CodeSwapStartSymbol[CSPAGE_BIS_ZEP_RX_UCODE_ADSL1_LP1] = 0;
    gsa_CodeSwapNextSection[CSPAGE_BIS_ZEP_RX_UCODE_ADSL1_LP1] = CSPAGE_BIS_TXINIT;

    //gsa_CodeSwapStartState[CSPAGE_BIS_EXCHDMT]  = -1;              // When TxInit is in
    //gla_CodeSwapStartSymbol[CSPAGE_BIS_EXCHDMT] = 0;
    //gsa_CodeSwapNextSection[CSPAGE_BIS_EXCHDMT] = CSPAGE_BIS_SHT1DMT;

    //gsa_CodeSwapStartState[CSPAGE_BIS_SHT1DMT]  = -1;              // When ExchDMT is in
    //gla_CodeSwapStartSymbol[CSPAGE_BIS_SHT1DMT] = 0;
    //gsa_CodeSwapNextSection[CSPAGE_BIS_SHT1DMT] = CSPAGE_BIS_SHT2DMT;

    //gsa_CodeSwapStartState[CSPAGE_BIS_SHT2DMT]  = R_C_SHOWTIME_RX;
    //gla_CodeSwapStartSymbol[CSPAGE_BIS_SHT2DMT] = 4;
    //gsa_CodeSwapNextSection[CSPAGE_BIS_SHT2DMT] = CSPAGE_BIS_SHOWBG2;

    //gsa_CodeSwapStartState[CSPAGE_BIS_SHOWBG2]  = -1;           // When Tx is is Showtime too
    //gla_CodeSwapStartSymbol[CSPAGE_BIS_SHOWBG2] = 0;
    //gsa_CodeSwapNextSection[CSPAGE_BIS_SHOWBG2] = -1;
#endif
}
