/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   stateini.c
*
*  Functions for initializing the state machine.
*
*-------------------------------------------------------------------------
*/
// ******************************************************************
// stateini.c
//
// History
//
// 31/05/2010 Nihar: In Annex J, if mask upto tone 60 or less is selected then DS start tone
//             changed to 61. This feature enabled (default) by CMV info 103 1 bit 12.
//             Grep for Feature_US_BisPlus_ALL_StartDSFromTone61AnxJ
//
// 08/07/2010 Nihar: Added code to avoid US-rate run2run variations against TI AC5 and TI 4000C on short White Noise loops
//                  Optimize CO TDQ training by sending out a wider Reverb spectrum in Reverb1/Reverb2
//             grep for "IOP_DS_DMT_TI_UseBroaderTxReverbSignal"
//
// 19/08/2010 AdeelJ/Palaksh/Bhadra: Fix for ADSL2+ low US rates against Intracom CNXT DSLAM.
//               This is the training initialization just after completion of Handshake.
//               In case fix conditions are true, The code will overwrite the US TSSi values
//               finalized in g.hs by the new defined TSSi values with wider spectrum and giving
//               higher power in US mirror frequencies. These TSSi values will modify the US REVERB spectrum.
//               Grep for SMS00910375 IOP_US_BISPlus_CNXT_USRateImprovement
//
// 06/10/2010 Bhadra/AdeelJ: Modified Reverb and MEDLEY SNR calculation so that it does not discard
//             REIN affected frames if a cmv info 103 23: bitmask 0x0020 is set. i.e. the functionality is
//             reverted to the older one without REIN detection. This will cause lower
//             data rates in presence of REIN, but still higher than specified in TR-100
//             REIN noise tests. The positive aspect is that we dont have to worry about
//             maintaining margin in Showtime. This cmv is specific for FT like scenarios where
//             the DS margin was going low to an unacceptable level in presence of REIN noise.
//             In this file the bitmask for cmv info 103 23:0x0020 is defined.
//        Grep for SMS01501984 SMS01294435 Feature_DS_BisPlus_ALL_DisableTrainingREINDetection
//
// 09/02/2011 Sriram: Use the special TSSI set from SMS00910375 in the range of
//            2100m to 4200m to improve the US rates against CNXT DSLAMs with FW
//            version of 0x10.
//            This feature is controlled by CMV INFO 103 26 0x0002
//            It's enabled by default.
//            Grep for ADSLRTFW-1344 IOP_A_US_Plus_CNXT_MidloopRateImprove
//
// 18/04/2011 Sriram: Use the special TSSI set to improve the US rates against CNXT DSLAMs with FW version of 0x10.
//            This feature is controlled by CMV INFO 103 26 0x0002
//            It's enabled by default.
//            Grep for XDSLRTFW-238 IOP_A_US_Plus_CNXT_MidloopRateImprove
//
// 30/09/2011 Stefan : Upsteam performance fixes from Stefan.
//                     Vinjam integrated them to Vr9 R4.3 ADSL mainline
//                     Grep for XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl
//
// 17/01/2012 Vinjam : Cleaned up repeated initializations of "CMV OPTN 30".
//            Grep for "CleanUp_VR9_US_All_All_RepeatedInitialization"
//
// 16/05/2013 Anantha Ramu : Added code to invoke changes corresponding to XDSLRTFW-336, when Lucent Stinger DSLAM is connected.
//                   Used CMV INFO 103 28 bit 13 to enable the changes
//                           Grep for XDSLRTFW-679 Enhance_US_BisPlus_LucentStinger_US_Rate_Improvement
//
// 11/06/2013 Anantha Ramu: Disabled pilot tone averaging & enabled erasure decoding to resolve uncorrected DTUs at 3750 mt
//                          in all noise conditions. Need to verify the effectiveness of enabling erasure decoding.
//                          Grep for XDSLRTFW-996 Fix_DS_BisPlus_ReTx_Uncorrected_DTUs_3750mt
// 12/06/2013 Balbath: Link drops when there is a change number of 1bit loaded tones after bitswap.
//             Link drops were observed with Annex M mode only, AnnexA cases seems fine
//             Did experiments by disabling one bit tone modifications during bit-swap, and link is stable.
//             Required RX_MIN_ADDR (IR_ACT_ADDRD) programming to be (gs_RxFirstChannel-1) when No. of 1 bit
//             tones are not multiple of 4. With this fix, AnnexM link is stable.
//             Triggering of continuous bitswaps in these profiles: to be decided ?
//             Grep for XDSLRTFW-945 Bug_DS_BisPlus_SRACappedprofile_Lindrops
//
// 20/06/2013 Ram: Disabled Bitswap improvement changes as it was found to cause linkdrop in temp chamber test.
//                 Grep for XDSLRTFW-959: BugFix_DS_ALL_ALL_LinkDrop_In_TempChamberTest (Start_End)
//
// 08/04/2013 ChihWen:
//            Optimize the code for SRA, which are mainly as below.
//            1. Modify gs_MaxRateLp/gs_MinRateLp to be the max/min Lp complying to all framing constraints(including max/min net rate) when framing check is enabled(INFO 103 26 bitmask(0x400)),
//               gs_MaxRateLp/gs_MinRateLp will be the Lp with max/min net rate when framing check is not enabled.
//                2. Combine the framing check in "isValidFramingConfiguration" and "RShowtimeRxF_BIS". The combined framing check will refer to gs_MaxRateLp/gs_MinRateLp.
//                3. Optimize the CMV setting related to SRA.
//                4. Add two CMV to enable/disable the checking for min INP, and max delay when searching delta Lp in training.
//            Grep for XDSLRTFW-721 Enhance_DS_BisPlus_ALL_OptimizedSRACode
//
// 24/01/2014 Balabath :- Correction of bugs and implementation as per the ErasureDecoding implementation
//                      -Change of Default settings of DSL 1 0 CMV settings
//                      - IOP issues resolved with EBLT-C
//                      for Code Changes grep for " XDSLRTFW-1502 "
//
// 12/11/2014 Prashant :- Correction for gs_TxReverb12FirstCh was overwritten after setting CO depedent start tone.
//                     Grep for XDSLRTFW-1791.
//
// 15/04/2014 ChiWen/Hanyu: Fine tuned US performance against CNXT DSLAMs based on ADSLRTFW-1480 and ADSLRTFW-1591 with the following changes
//  (1) Added special flat US TSSI;
//  (2) Set tone 32 to zero(gusa_US_Tssi_Value[32] = 0);
//  (3) Enabled special flat US TSSI in C-REVERB1/R-REVERB1 (might have influence over the final PGA training);
//  (4) Enabled special flat US TSSI in C-REVERB2;
//  (5) Renamed gft_USPerf_Midloop_Gspn to gft_USPerf_Gspn for all CNXT CO's;
//  (6) Above changes are applied to all CNXT CO/DSLAMs regardless of CO FW versions and controlled by CMV bit4 (MASK 0x0010) of info 103 27
//      that is ENABLED (bit4=1) by default. This is especially recommended at CenturyLink/USA. So far no side effect has been observed.
//  Grep for XDSLRTFW-1584 XDSLRTFW-1585 IOP_US_BISPlus_CNXT_USRateImprovement
//
// 23/05/2015 Stefan : In PTM mode following DS anomalies (uc_lcd_def, uc_lcd_def, uc_ncd_anom) are not populated
//                     All three are set by default to "No-TC-Sync"
//                     The gt_tx_Anomaly settings are used in function "WriteIndicatorBits_bis" to set TIB#0 and TIB#1.
//                     So VR9 was sending the non-standard compliant values "0" in TIB#0 and TIB#1 indicating "No-TC-Sync"
//                     Fix: Set TIB#0 and TIB#1 according to standard (to 1) if PTM mode is selected
//                     Grep for XDSLRTFW-2328 TPSTC_TIB_INDICATION_FOR PTM
//
// 13/1/2017 Shriram Shastry : The CPE could not link up in G.DMT mode with 4.17.18.7 UGW7.1.1 [PPA API driver info: 96.32.7.3.0.0.4]
//          When  FW makes transition from VDSL to ADSL and CO is configued in ADSL1 Mode,
//          FW is 'NOT' communicating the required TC-Mode and  autonomous message to DSL API. Moved the  function call for  all hndshk mode and T1413
//          Grep for XDSLRTFW-3068
//
//  07/02/18: Stefan: XDSLRTFW-2417: INFINEON not used anymore in VR9 ADSL code
//            Re-enable required code under #ifdef INFINEON
//            - KPN specific ADSL Annex-B (oISDN) Tx-spectrum
//            - Nlp = 1
//            grep for: XDSLRTFW-2417 #define INFINEON not used anymore in VR9 ADSL code
//
// ******************************************************************

#include <stdio.h>
#include <string.h>
#include "typedef.h"
#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "xgdata.h"
#include "pwr_ctbk.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "ghs.h"
#include "hndshk_data.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "bitload.h"
#include "sleep.h"
#include "T1413.h"
#include "xrtstate.h"
#include "states.h"
#include "fdq_init.h"
#include "fifo.h"
#include "mtkernel.h"
#include "pll.h"
#include "bert.h"
#include "cmv.h"
#include "ec_data.h"
#include "dec_adap.h"
#include "rx_eoc.h"
#include "tx_eoc.h"
#include "rx_ib.h"
#include "tx_ib.h"
#include "tdq_init.h"
#include "profile1.h"
#include "mp.h"
#include "act_T1413.h"
#include "ec_init.h"
#include "aoc_ini.h"
#include "ovflw.h"
#include "memory.h"
#include "trail.h"
//SMS00910375 IOP_US_BISPlus_CNXT_USRateImprovement (START_END)
#include "spectral_shape_bis.h"
#include "Cri_iof.h"

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void UpdateRxNumTones(int16 s_RxNumTones)
*
*  Description:
*     This function updates the RxNumTones and all related variables
*
*  Global Variables:
*-------------------------------------------------------------------
*^^^
*/
C_SCOPE void UpdateRxNumTones(int16 s_RxNumTones)
{
    int16 s_temp;

    gs_RxNumTones = s_RxNumTones;

    gs_RxLastChannel = gs_RxNumTones-1;
    gus_Rx_MaxToneIndx = gs_RxNumTones-1;

    /* Compute log2(gs_RxNumTones) */
    gs_RxLog2NumTones = 0;
    s_temp = (gs_RxNumTones>> 1);
    while((s_temp&1) == 0)
    {
        gs_RxLog2NumTones++;
        s_temp >>= 1;
    }
    gs_RxLog2NumTones++;
}

/*^^^
*------------------------------------------------------------------------
*
*  Name : SetLinkModeDependentVariables(void)
*
*  Prototype:  void SetLinkModeDependentVariables(void)
*
*     Set variables based on Link Type as determined by Ghs or T1.413 signalling
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Return:
*      None
*
*  Global Variables Used:
*
*  Notes:
*
*------------------------------------------------------------------------
*^^^
*/
C_SCOPE void SetLinkModeDependentVariables(void)
{
    int16 s_temp;
    //assumed: annex-M and annex-J has the same number of PSD-mask,
    //and the last tone array are the same.
    int16 sa_AnxM_LastChannel[NUM_ANNEX_M_PSDMASK_SUPPORTED] = {32, 36, 40, 44, 48, 52, 56, 60, 63} ;

//SMS00910375 IOP_US_BISPlus_CNXT_USRateImprovement (START)
#ifndef ISDN
   int16 i;
   uint8 *puca_US_Tssi;
//   FlagT *pfta_US_SprtSet;
   uint8 *puca_US_BreakFreq;
   int32 l_fe_VendorID_Check;
#endif
//SMS00910375 IOP_US_BISPlus_CNXT_USRateImprovement (END)

    /****************************************************************/
    /* !!! Post - handshake Tx/Rx First/Last channel and       */
    /*      Tx/Rx NumTones settings !!!                        */
    /****************************************************************/
   //PLUS/BIS MODE
   //XDSLRTFW-238 IOP_A_US_Plus_CNXT_MidloopRateImprove (START)
   // This is a common Tssi which is sent across Bis/Plus mode for connexant CO.
   #ifndef ISDN
   #if 0 //XDSLRTFW-626: Enh_all_all_TelfonicaLongTraining (Start)
   if (gl_SelectedMode & MODE_ADSL2)
   {
      if(gft_USPerf_Gspn) //XDSLRTFW-1584 XDSLRTFW-1585 IOP_US_BISPlus_CNXT_USRateImprovement (START_END)
      {
         puca_US_Tssi = gt_GHS_USTssiInfo.uca_Tssi;
         puca_US_BreakFreq = gt_GHS_USTssiInfo.uca_Brkpt;
         for (i = 0; i < gt_GHS_USTssiInfo.s_NumBrkptkept; i++)
         {
            puca_US_BreakFreq[i] = guca_US_TssiIndex_G9925A_GSI_Intracom[i];
            puca_US_Tssi[i]      = guca_US_TssiValue_G9925A_GSI_Intracom[i];
         }
      }
   }
   #endif //XDSLRTFW-626: Enh_all_all_TelfonicaLongTraining (end)
   #endif
    if (gl_SelectedMode & MODE_G992_5)
    {
//SMS00910375 IOP_US_BISPlus_CNXT_USRateImprovement (START)
//ADSLRTFW-1344 IOP_A_US_Plus_CNXT_MidloopRateImprove (START_END)
#ifndef ISDN
      if(gft_USPerf_Intracom_Gspn) //XDSLRTFW-238 IOP_A_US_Plus_CNXT_MidloopRateImprove (Start_End)
         {
            puca_US_Tssi = gt_GHS_USTssiInfo.uca_Tssi;
//          pfta_US_SprtSet = gt_GHS_USTssiInfo.uca_Si;
            puca_US_BreakFreq = gt_GHS_USTssiInfo.uca_Brkpt;
            for (i = 0; i < gt_GHS_USTssiInfo.s_NumBrkptkept; i++)
            {
               puca_US_BreakFreq[i] = guca_US_TssiIndex_G9925A_GSI_Intracom[i];
               puca_US_Tssi[i]      = guca_US_TssiValue_G9925A_GSI_Intracom[i];
            }
         }
#endif
//SMS00910375 IOP_US_BISPlus_CNXT_USRateImprovement (END)

        // gs_TxLastChannel
#ifdef ISDN
        if (gl_SelectedMode & ANNEX_J)
        {
            /* if we are in plus anx J mode */
            gs_TxLastChannel = sa_AnxM_LastChannel[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_J]] ;
        }
        if (gl_SelectedMode & ANNEX_B)
        {
            /* if we are in plus anx B mode */
            gs_TxLastChannel = 60;
            if (gs_CurrentCoChipset == GSI_CO_CHIPSET)
            {
                gs_TxLastChannel = 63; /* set Tx last channel to 63 if conexant CO */
            }
        }
#endif
        if (gl_SelectedMode & ANNEX_M)
        {
            /* if we are in plus anx M mode */
            gs_TxLastChannel = sa_AnxM_LastChannel[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_M]] ;
        }

        /* if we are in plus mode */
        UpdateRxNumTones(512);

        // gs_RxNumTones would have changed. Reload UnityFdq
        AddFunctionToFifo(gp_RxLoadingFunctionFifo,DisableFDQ);
    }
    // BIS/DMT/T1413 MODE
    else if (gl_SelectedMode & (MODE_G992_3 | MODE_ADSL1))
    {
        // gs_TxLastChannel
#ifdef ISDN
        if (gl_SelectedMode & ANNEX_J)
        {
            /* if we are in bis anx J mode */
            gs_TxLastChannel = sa_AnxM_LastChannel[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_J]] ;
        }
        if (gl_SelectedMode & ANNEX_B)
        {
            /* if we are in bis/dmt anx B mode */
            gs_TxLastChannel = 60;
            if (gs_CurrentCoChipset == GSI_CO_CHIPSET)
            {
                gs_TxLastChannel = 63; /* set Tx last channel to 63 if conexant CO */
            }
        }
#endif
        if (gl_SelectedMode & ANNEX_M)
        {
            /* if we are in bis anx M mode */
            gs_TxLastChannel = sa_AnxM_LastChannel[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_M]] ;
        }

        /* if we are in bis or dmt mode */
        UpdateRxNumTones(256);
    }
    s_temp = gs_TxLastChannel; // ADSL2 default sets TxMedleyLastChannel to TxLastChannel.
    // ADSL 2 Annexs
    if ( gl_SelectedMode & MODE_ADSL2)
    {
        // gs_TxFirstChannel
        if (gl_SelectedMode & (ANNEX_I | ANNEX_J))
        {
            gs_TxFirstChannel = 1;
         // Fix for Tx first channel to be 1 in Annex J mode
         if(gs_TxReverb12FirstCh > gs_TxFirstChannel)
         {
            gs_TxReverb12FirstCh = gs_TxFirstChannel;
         }
        }
        else if (gl_SelectedMode & ANNEX_B)
        {
            gs_TxFirstChannel = 33;
        }
        // gs_RxFirstChannel
        if (gl_SelectedMode & (ANNEX_J | ANNEX_M))
        {
            gs_RxFirstChannel = 64;
#ifdef ISDN
            // Feature_US_BisPlus_ALL_StartDSFromTone61AnxJ (Start)
            if((gs_AnnexBMJPSDMaskIdx <= EU60_ANNEX_J_PSDMASK) &&
                    (gt_INFX_CMV.s_DFE_Options & DS_START_TONE_61) &&
                    (gl_SelectedMode & ANNEX_J))
            {
                gs_RxFirstChannel = 61;
            }
            // Feature_US_BisPlus_ALL_StartDSFromTone61AnxJ (End)
#endif // ifdef ISDN
        }
        else if (gl_SelectedMode & ANNEX_B)
        {
            gs_RxFirstChannel = 61;
            if (gs_CurrentCoChipset == GSI_CO_CHIPSET)
            {
                gs_RxFirstChannel = 64; // set Rx First channel to 64 if conexant CO
            }

        }
    }
    // ADSL 1 Annexs
    else
    {
        s_temp = gs_TxMedleyLastCh;
#ifdef ISDN
        // DMT Annex B -- special settings for improved Interop
        if (gl_SelectedMode & ANNEX_B)
        {
            /* Set first/last channel variables to generic (compliant) Annex B values. */
            gs_TxFirstChannel = 33;
         gs_TxReverb12FirstCh = 33; // XDSLRTFW-1791 (Start_End)
            // IOP_DS_DMT_TI_UseBroaderTxReverbSignal (Start)
            if (gs_CurrentCoChipset == TI_CO_CHIPSET)
            {
                gs_TxReverb12FirstCh = 28;
                gs_TxReverb12LastCh  = 64;
            }
            else
            {
                gs_TxReverb12FirstCh = 33;
                gs_TxReverb12LastCh  = 60;
            }
            // IOP_DS_DMT_TI_UseBroaderTxReverbSignal (End)
            s_temp = 60;      //gs_TxMedleyLastCh
            gs_RxFirstChannel = 61;

            /* If both CO and CPE support tones below 33 use lower tones to improve upstream performance. */
            if (gft_Tones1To32Support != FALSE)
            {
                /* Alcatel Annex B CO requires lower REVERB1,2 first tone and bitloads only tones 29 to 48. */
                if (gs_CurrentCoChipset == ALA_CO_CHIPSET)
                {
                    gs_TxFirstChannel = 29;
                    gs_TxReverb12FirstCh = 27;
                    s_temp = 56;       //gs_TxMedleyLastCh
                }
                /* For all other COs, lower only the REVERB1,2 first tone (for improved TDQ training). */
                else
                {
                    gs_TxReverb12FirstCh = 28;
                }
            }
        }
#endif
    }

#ifndef ISDN
    //XDSLRTFW-673: Enh_DS_ALL_ALL_ClkChg(start_end)
    //Disabling pilot tone averaging as it was causing uncorrrected DTUs at 3750 mt in ReTx mode
    TESTArray[Test_DisableShowClkAveraging] |= 0x1;
#endif

    //XDSLRTFW-959: BugFix_DS_ALL_ALL_LinkDrop_In_TempChamberTest (Start_End)
    //Disabling Bitswap improvement changes as it was found to cause linkdrop in temp chamber test.
    TESTArray[Test_DisableBitSwapImprvmnt] |= 0x1;

    // XDSLRTFW-945 Bug_DS_BisPlus_SRACappedprofile_Lindrops (start)
    if ( OPTNArray[OPTN_RX_FIRST_CHANNEL] != 0 )
      gs_RxFirstChannel = OPTNArray[OPTN_RX_FIRST_CHANNEL];
    // XDSLRTFW-945 Bug_DS_BisPlus_SRACappedprofile_Lindrops (end)

    if ((TESTArray[TEST_Control2]&TEST_UserDefinedCh)==0)
    {
        gs_TxMedleyFirstCh = gs_TxFirstChannel; // In this if{} for PM reasons (although not used in 3B/M)
        gs_TxMedleyLastCh = s_temp;          // In this if{} for PM reasons (although not used in 3B/M)
        gs_RxBitLoadFirstChannel = (int16) gs_RxFirstChannel;
        gs_RxBitLoadLastChannel = gs_RxLastChannel;
    }

    // XDSLRTFW-2417 #define INFINEON not used anymore in VR9 ADSL code
    if ((gl_SelectedMode & ANNEX_B) && (gt_INFX_CMV.us_OperatorSpBits & CMV_TO_FORCE_KPN_TSSI_US_BIN_START))
    // Specific requirements for KPN (Dutch Telco), whose DSLAM of choice is
    // Alcatel/BRCM ADSL2+ capable CO.
    {
        gs_TxFirstChannel = 29;
        gs_TxMedleyFirstCh = 29;
        if (gs_TxReverb12FirstCh > gs_TxFirstChannel)
        gs_TxReverb12FirstCh = gs_TxFirstChannel;
        gs_TxMedleyLastCh = 57;
        gs_TxLastChannel = 57;
    }

    // Annexs with US Band upto tone 64
    if (gl_SelectedMode & (ANNEX_B | ANNEX_M | ANNEX_J))
    {
        gs_TxNumTones = (int16) TX_NUM_TONES;
        gs_PN_US_LEN = 2*gs_TxNumTones - 2;
        gs_PN_US_Step = 2;
        /* Pilot tone to be used */
        gs_CPilotTone = gs_AuxPilotToneIdx = C_PILOT_TONE_96;
        gs_MinAuxPilotToneIdx = 80;
    }

    /**************************************************************/
    /* Post - handshake misc controls based on mode selected */
    /**************************************************************/
    if(gl_SelectedMode & MODE_ADSL2)
    {

        if (gl_SelectedMode & MODE_G992_5)
        {
            //Enable S=1/4 in Plus mode (for the situation where we cannot get extended frame
            //parameter case in GHS)
            if (OPTNArray[OPTN_StateMachineCtrl] & OPTN_ForceEnableSmallerS)
            gft_EnableSmallerS = TRUE;
            else
            {
                if (OPTNArray[OPTN_StateMachineCtrl] & OPTN_SONEFOURTH_ENABLE)
                {
                    if((gs_CurrentCoChipset == IFTN_CO_CHIPSET)
                            && (gt_HandshakeBis.sa_DS_MaxNetDataRateBC[0] > NET_MAX_RATE_THRESHOLD))
                    gft_EnableSmallerS = TRUE;
                }
            }

            if (!gft_GHS_S0min_Negotiated && gft_EnableSmallerS)
            gt_HandshakeBis.s_OneOverSminADSL2=4; // would need to change after s=1/16 support is completed
        }

        /* Disable data on pilot, more commonly known as aux pilot in dmt world */
        if (!(OPTNArray[OPTN_StateMachineCtrl] & OPTN_EnableDataOnPilot_Bis))
        {
            gft_AuxPilot = AUX_PILOT_DISABLE;
        }

        /* Do not use fine gain adjustments in BIS mode */
        OPTNArray[OPTN_FgainAdjust_ShortLoop] = 0; //(Q8.8)
        OPTNArray[OPTN_FgainAdjust_MedLoop]  = 0; //(Q8.8)
        OPTNArray[OPTN_FgainAdjust_LongLoop] = 0;//(Q8.8)

        /* Disable MarginDelta if it is indicated only for DMT */
        if (OPTNArray[OPTN_AlgControl2] & (OPTN_MarginD_IntlvDMTonly|OPTN_MarginD_SelectDMTonly)) {
            OPTNArray[OPTN_MarginDelta] = 0 ;
        }

        gs_PCB_DS_Delta_bis = TESTArray[TEST_PCB_Delta_bis];



        s_temp = 331;
        /*****************************************PTM CHANGES**************************************/
#ifdef DANUBE_PTM_SUPPORT
        if((guca_US_TransferMode_bis[0] | guca_DS_TransferMode_bis[0]) & PTM_MASK)

        {
            gt_INFX_CMV.us_PTM_Options_Selected = CMV_PTM_SELECTED | guc_PtmOctet_US_BC0 | (guc_PtmOctet_DS_BC0 << 6);
        }
        else
        {
            gt_INFX_CMV.us_PTM_Options_Selected = CMV_ATM_SELECTED;
        }
        if(gt_INFX_CMV.s_DFE_Options & FORCE_PTM_MASK)
        {
            gft_ForcePTM = 1;

            gt_INFX_CMV.us_PTM_Options_Selected = (CMV_PTM_SELECTED | gt_INFX_CMV.us_PTM_Options_Indicated) & DIS_ATM;

        }

        if(gt_INFX_CMV.us_PTM_Options_Selected & CMV_PTM_SELECTED)
        {
            if(gt_INFX_CMV.s_DFE_Options & DIS_BYTE_FLIP_MASK)
            {
                gft_DisByteFlip = 1;
            }


        }
#endif//if defined DANUBE_PTM_SUPPORT
        /*********************************PTM CHANGES*************************************/
      //PERF_US_ALLannexA_New_FTspeciffic (Start)
#ifndef ISDN   // Only for Anx-A
      if ((gt_INFX_CMV.s_DFE_Options & CMV_INFX_DFE_FT_INTERP13_ENABLE)
           && (gt_ReTxConfigInfo.ft_ReTxOn == 0) //XDSLRTFW-2066
          )
      {
         //Boost margin by 0.2dB for FT.
         OPTNArray[OPTN_MarginDelta] += (int16)0xFFCD;  // XDSLRTFW-2027 IOP_A_DS_AnnexL_CNXT_DataRate add (-0.2)dB to avoid overwritting the CMV setting
      }
#endif // ifndef ISDN
      //PERF_US_ALLannexA_New_FTspeciffic (End)
      //XDSLRTFW-721 ADSLRTFW-1688 Enhance_DS_BisPlus_ALL_OptimizedSRACode (START)
//#ifndef ISDN
      if (gs_CurrentCoChipset == BDCM_CO_CHIPSET)
      {
         TESTArray[TEST_OLR_SRA_DeltaLpchange] = 0x7fff;
         gt_INFX_CMV.us_SRA_IOP_Bits |= CMV_TO_ENABLE_SRA_SEARCHING_DELTA_LP;
         //ADSLRTFW-1705 : BugFix_DS_BisPlus_All_TR105SRAChanges (start_end)
         gt_INFX_CMV.us_OperatorSpBits2 |= CMV_TO_ENABLE_ONE_STEP_SRA;
      }

      if (gs_CurrentCoChipset == GSI_CO_CHIPSET)
      {
         gt_INFX_CMV.us_SRA_IOP_Bits |= CMV_TO_DISABLE_SRA_FRAMING_CHECK;
      }
//#endif
      //XDSLRTFW-721 ADSLRTFW-1688 Enhance_DS_BisPlus_ALL_OptimizedSRACode (END)

#ifdef AMAZON_SE
#ifndef ISDN
        // SE sees low snrs on mid-range tones (around Tone 100-150) in TR100-NA margin test when
        // 5dB extra noise is added. Temporarily we made the changes in gs_ReverbNoiseMarginReduction
        // gs_EchoNoiseMargin to sacrifice the rate for the pass in margin.
        gs_ReverbNoiseMarginReduction = 0x0000;    /* In dB (Q8.8 format). */ // 0 reccomended for Danube
#endif
#endif

    }  // if(gl_SelectedMode & MODE_ADSL2)

    else
    {
        s_temp = 61;
    }

    // Note: currently no CO's where bitswap is disabled above-> following 2 lines could be removed
    // Overwrite the Auto bitswap bit by the forcing CMV control below
    if (OPTNArray[OPTN_AlgControl2] & OPTN_ForceAutoBitswap)
    OPTNArray[OPTN_AlgControl] &= ~OPTN_DSAutoBitSwapDisable;

#ifndef ADSL_62
#ifdef HERCULES_ADSL_CPE
    if (!( gl_SelectedMode & MODE_ADSL2)) /* Disable US/DS bitswap for DMT Mode */
    OPTNArray[OPTN_AlgControl] |=  (OPTN_DSAutoBitSwapDisable | OPTN_USBitSwapDisable);
#endif
#endif




    /**************************************************************/
    /* Post-handshake debug trail settings based on mode selected */
    /**************************************************************/
    if (gt_debugTrailTriggerControl.s_logType & DEBUG_LOG_FD_FRAME)
    {
        gt_debugTrailTriggerControl.s_logType |= DEBUG_LOG_RXTONECAPTURE ;
        gt_debugTrailTriggerControl.s_toneIndex = 0 ;
        gt_debugTrailTriggerControl.s_numTones  = gs_RxNumTones ;
    }
    else if(gt_debugTrailTriggerControl.s_toneIndex == -1 &&
            gt_debugTrailTriggerControl.s_numTones == -1)
    {
        gt_debugTrailTriggerControl.s_toneIndex = gs_RxFirstChannel;
        gt_debugTrailTriggerControl.s_numTones  = 2 ;
    }
    /* If trigger not set by user, set it to first state of dmt training */
    if (gt_debugTrailTriggerControl.s_triggerRxState == -1 &&
            gt_debugTrailTriggerControl.s_triggerRxSubState == -1 &&
            gt_debugTrailTriggerControl.s_triggerRxSymbolCount == -1)
    {
        gt_debugTrailTriggerControl.s_triggerRxState = s_temp;
        gt_debugTrailTriggerControl.s_triggerRxSymbolCount = 0;
    }

    /**************************************************************/
    /* Post - handshake misc controls based on co chipset */
    /**************************************************************/
    if (gs_CurrentCoChipset == IFTN_CO_CHIPSET)    /* Ver_Minor <  0xf */
    {
        int16 s_majorVer = ((gs_CurrentCoVendorID>>12)&0xf);
        int16 s_minorVer = ((gs_CurrentCoVendorID>>4)&0xff);
        int16 s_buildCode = (gs_CurrentCoVendorID&0xf);

        /* Force CW size to be 247 for Geminax Bis Infineon CO */
        if (s_majorVer == 0x4)
        TESTArray[TEST_Control2] |= TEST_ForceCWSize247;

        if (s_buildCode != 0xf)  /* In release version */
        {

            /* Disable rcquiet5 during dec training in Adsl2/+ AnnexB modes against Infineon CO chipset for versions < 4.0e.x except 4.0d.{8-f} AND versions < 7.0e.x except 7.0d.{b-e} */
            /* Disable dec adaptation against Infineon CO chipset for versions < 07.0D.07 */
            if (STATArray[STAT_Mode] & STAT_ConfigMode_AnnexB_ALL)
            {
                s_temp = 0x7;
                if ((s_majorVer == 0x4 && s_minorVer < 0xe && !(s_minorVer == 0xD && s_buildCode >= 0x8)) ||
                        (s_majorVer == 0x7 && s_minorVer < 0xe && !(s_minorVer == 0xD && s_buildCode >= 0xB)))
                {
                    OPTNArray[OPTN_StateMachineCtrl] |= OPTN_PilotOnDecTraining_Bis;
                }
            }
            /* Disable rcquiet5 during dec training in other Adsl2/+ modes against Infineon CO chipset for versions < 7.0e.x except 7.0d.{a-e} */
            /* Disable dec adaptation against Infineon CO chipset for versions < 07.0D.0A */
            else
            {
                /* Disable dec adaptation against Infineon CO chipset for versions < 07.0D.0A */
                s_temp = 0xa;
                if (s_majorVer == 0x7 && s_minorVer < 0xe && !(s_minorVer == 0xD && s_buildCode >= 0xA) )
                {
                    OPTNArray[OPTN_StateMachineCtrl] |= OPTN_PilotOnDecTraining_Bis;
                }
            }

            /*Certain older Gmx FW versions use PAR reduction on the sync frames.  This interferes
            with our DEC adaptation so we disable adaptation for those versions.*/

            if (s_majorVer  > 0x4 &&// exclude Geminax 2.1 (no PARR on this chip)
                    (s_majorVer < 0x7 ||// include any DMT-only or DMT+ADSL2-only Geminax Max builds
                        (s_majorVer == 0x7 && s_minorVer < 0xD) ||//include older 0x7 branches
                        (s_majorVer == 0x7 && s_minorVer == 0xD && s_buildCode < s_temp))) // include older builds on 7.D branch
            {
                OPTNArray[OPTN_AlgControl] |= OPTN_DECAdaptDisable;
            gft_DECAdaptDisable =1;
            }
        }
    }

//SMS01501984 SMS01294435 Feature_DS_BisPlus_ALL_DisableTrainingREINDetection  (START)
   if(gt_INFX_CMV.us_OperatorSpBits3 & CMV_TO_DISABLE_REIN_ADAPTATION_TRAINING)
       gft_indEnable = 0; // this will disable REIN Adaptation during training
   //SMS01501984 SMS01294435 Feature_DS_BisPlus_ALL_DisableTrainingREINDetection (END)

#ifdef ADSL_62
   //If dec adaptation is enabled for AnnexL,
   //we need to reduce step size and reduce oob power if we enbale dec adpatation for Annex_L
   if (( (gl_SelectedMode & (MODE_G992_3))) && (gl_SelectedMode & (ANNEX_L)  ))
   {
//       gft_DECAdaptDisable =1;
      gs_TxOutBandGain = 0x400;
   }
#endif //#ifdef ADSL_62

//XDSLRTFW-679 Enhance_US_BisPlus_LucentStinger_US_Rate_Improvement (Start)
#ifndef ISDN
    // Extract the provider  code (Vendor ID, 4 octets), Workaround for TI  AC7/CNXT vendor ID
   l_fe_VendorID_Check = (guca_fe_G9941_VendorID[2] << 24) | (guca_fe_G9941_VendorID[3] << 16) |
                                           (guca_fe_G9941_VendorID[4] << 8) | (guca_fe_G9941_VendorID[5]);
   if ((l_fe_VendorID_Check  == GHS_GSI_ID) &&(gt_INFX_CMV.us_OperatorSpBits6 & CMV_TO_ENABLE_IMPROVE_US_RATE_WITH_LUCENT_ST))
   {
      OPTNArray[OPTN_TXPathControl] = 8;
   }

#endif
//XDSLRTFW-679 Enhance_US_BisPlus_LucentStinger_US_Rate_Improvement (End)

//XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (Start)
   // US-performance: PLUS mode configuration
   // 0x01: STATUS      readonly
   // 0x02: ENABLE_DMT  on
   // 0x04: ENABLE_BIS  on
   // 0x08: ENABLE_PLUS on
   if ((OPTNArray[OPTN_TXPathControl] & 0x08) && ((gl_SelectedMode == (MODE_G992_5 | ANNEX_A))) )
   {
      OPTNArray[OPTN_TXPathControl] |= 0x01;    // set STATUS to on
      gft_DECAdaptDisable =1;                                        // disable DEC update
      OPTNArray[OPTN_AlgControl] |= OPTN_DECAdaptDisable;
      // 0x xxx1:    SWITCH_BEFORE_RREVERB3
      // 0x xxx2:    SWITCH_BEFORE_RREVERB4
      // 0x xxx4:    SWITCH_BEFORE_RREVERB5           <- set in PLUS mode
      // 0x xxx8:    SWITCH_BEFORE_MEDLEY (not supported)
      // 0x xx4x:    images are turned on
      // 0x x8xx:    images are turned on
      // 0x 1xxx:    shift Tx-filter                  <- set in PLUS mode
      // 0x 2xxx:    add 1 image to tx-signal
      // 0x 4xxx:    add all images to tx-signal
      // 0x 80xx:    compensate DECDelay              <- set in PLUS mode
      gus_TxPathControl = 0x9004;
      gs_DEC_SHIFT = 0;
      gs_DEC_SHIFT_INIT = 2;
   }
   else
   {
      // to prevent false configurations reset STATUS bit if no mode was configured
        //CleanUp_VR9_US_All_All_RepeatedInitialization
        OPTNArray[OPTN_TXPathControl] = 0;      // set STATUS to on
   }
//XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (End)
    // COCOMO ONLY, On hardware this reconfiguration should be done askin to G992_1 in RCQuiet2
#ifndef TARGET_HW
    if ( gl_SelectedMode & (MODE_G992_2)  )
    { // Lite mode is selected after HWE handshake
        UpdateRxNumTones(128);
        if (STATArray[STAT_Misc] & STAT_TDQ_at_1104)
        {
            if (gs_RxFftLength == 512)
            {
                gs_RxSamplesPerFrame = 256;
                gs_Log2RxSamplesPerFrame = 8;
#ifndef ADSL_62
                /* DEC upsampling factor */
                for(gs_DECUpsamplingFactor=1, s_temp=gs_TxFftLength; s_temp<gs_RxSamplesPerFrame; s_temp<<=1)
                gs_DECUpsamplingFactor <<= 1;
#endif
            }

#ifdef TDQ_LENGTH_LITE
            gs_TDQLen = TDQ_LENGTH_LITE;
#else
            gs_TDQLen = TDQ_LENGTH;
#endif
        }
    }
#endif
   if(OPTNArray[OPTN_AlgControl] & OPTN_DECAdaptDisable)
      gft_DECAdaptDisable =1;
//XDSLRTFW-996 Fix_DS_BisPlus_ReTx_Uncorrected_DTUs_3750mt (Start)
//Following changes done, as these settings resolved uncorrected DTUs at 3750 mt
   if(gt_ReTxConfigInfo.ft_ReTxOn == 1)
   {
#ifndef ISDN
      TESTArray[Test_DisableShowClkAveraging] |= 0x1; //Disable pilot tone averaging for ReTx as it was causing uncorrrected DTUs at 3750 mt
#endif
      //XDSLRTFW-1502 (start_end)
      //gs_DSL_EDcontrol |= (ERASURE_DECODING_ENABLE);
   }
//XDSLRTFW-996 Fix_DS_BisPlus_ReTx_Uncorrected_DTUs_3750mt (End)

   // XDSLRTFW-2328 TPSTC_TIB_INDICATION_FOR PTM (ADSL2p PTM mode vs. E/// EDN612p: link drop after 10s)
   // In PTM mode all TPSTC TIB bits need to be set to "1" (indicating TC-SYNC) - according to G992.3 standard
   // We use the flag TEST_SuppressCdIbToCO to disable the reporting
   if (   ((gt_HandshakeBis.sa_DS_BCActive[0] == TRUE) && (guca_DS_TransferMode_bis[0] == PTM))
       || ((gt_HandshakeBis.sa_DS_BCActive[1] == TRUE) && (guca_DS_TransferMode_bis[1] == PTM)))
   {
      TESTArray[TEST_Control3] |= TEST_SuppressCdIbToCO;
   }
   //XDSLRTFW-2376 Start
   if (TESTArray[TEST_MSGDSOverheadRate] > gt_HandshakeBis.s_MinMSGDSOverheadRate)
   {
      gt_HandshakeBis.s_MinMSGDSOverheadRate = TESTArray[TEST_MSGDSOverheadRate];
   }
   //XDSLRTFW-2376 End
}
/* XDSLRTFW-3068 */
/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void Set_AutoMsg_FW_PPE_TcMode()
*
*  Description:
*     This function updates the firmware TPS-TC-Mode and set autonomous message flag
*
*  Global Variables:
*-------------------------------------------------------------------
*^^^
*/

void Set_AutoMsg_FW_PPE_TcMode()
{
   // Convey Autonomous message to DSL API on TPS TC Mode - common for all ADSL.x & T1413 modes
   gus_Required_TC_Info = gt_ADSL_TcMode_Reprt.us_FW_TC_mode;    // The required TC as communicated between CO and CPE is stored to the variable.
   // XDSLRTFW-3712 (Start_End)
   // The PPE clock frequency needs to be configured based on the profile selected, bonding capability and TC mode.
   // The PPE frequency which needs to be configured is indicated to the PPE driver by configuring the DREG register 0x7DCE (DREG_MISCRAM14_ADDR)
   // before sending out the autonomos message.
   Ppe_clockChange();

   //XDSLRTFW-3795 (Start_End)
   //Send Autonomous message if selected mode != Loop Diagnostics Mode.
   //Required TC mode may not be communicated by CO in G.Hs during Loop diagnostics mode.
   if ((gl_SelectedMode & LINK_DIAG) == 0)
   {
      gft_TC_autonomous_msg = TRUE;
   }
}
/* XDSLRTFW-3068 */
#if defined(ADSL_62) && defined(TARGET_HW)
extern int32 __gl_LdStDmSwapStart;
extern int32 __gl_LdStDmSwapEnd;

extern int32 __gl_ExtendedResBssStart;
extern int32 __gl_ExtendedResBssEnd;

extern int32 __gl_ExtendedTrainBssStart;
extern int32 __gl_ExtendedTrainBssEnd;

void ClearDataSwapPages(void)
{
#if 0
    int32 *i;

    for (i = &__gl_LdStDmSwapStart; i <  &__gl_LdStDmSwapEnd; i++)
    {
        *i = 0;
    }
#else
    // these start and end symbols are defined in the HarvardArch_biscs.cmd
    memset((void *)&__gl_LdStDmSwapStart, 0, ((int32)&__gl_LdStDmSwapEnd - (int32)&__gl_LdStDmSwapStart));
    memset((void *)&__gl_ExtendedTrainBssStart, 0, ((int32)&__gl_ExtendedTrainBssEnd - (int32)&__gl_ExtendedTrainBssStart));
    memset((void *)&__gl_ExtendedResBssStart, 0, ((int32)&__gl_ExtendedResBssEnd - (int32)&__gl_ExtendedResBssStart));
#endif

}
#endif
