/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2008 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   states.c
*
*  Functions for running the state machine.
*
*-------------------------------------------------------------------------
*/
// ******************************************************************
// states.c
//
// History
//
// 19/04/2010 Nihar: For debugging purposes it's very helpfull to have information
//            about the previous exception state/code available. So, put previous
//            Exc.Code/State into persistent memory and map it to CMVs
//            cr STAT 22 0 -> Prev. Exception State
//            cr STAT 23 0 -> Prev. Exception Code
//            Grep for Feature_ALL_ALL_ALL_PrevExceptionsCMV
//
// 09/08/2011 Vinjam: Added logic to trigger the exception for "LOF", "ESE" & "OOS" show time near-end failures.
//                    Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//
// 10/08/2011 Vinjam: Optimized the code related to near end show time failures.
//                    Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//
// 06/09/2011 Vinjam: Added code to suppress the link drop with new CMV bits in TEST 29 0
//                    Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//
//12/01/2012: Balabath: Added CMV to trigger LPR in idication.DSL 5 0 1 will trigger this.By default
//                      this bit is set to zero.
//                Grep for XDSLRTFW-201 Feature_US_ALL_ALL_LPR
// 04/07/2012 Anantha: Added logic to trigger the exception for LCD and NCD show time near-end failures.
//                   Added PTM check for OOS
//                    Grep for XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers
//
// 20/11/2012 Balabath: XDSLRTFW-593 :Symbol counts Rx/Tx are not showing proper values in STAT 5 command
//                   for linkdrop in showtime eg, LOS,LOF etc
//       "l_RxSymbolCount_AtFail" is not updated properly if the line dropped from the (PLAM)failure reasons (LOS,LOM,LOF etc.,)
//       Because in these cases , "ExceptionHandler" will be executed before saving the "gl_RxSymbolCount "to "gl_save_RxSymbolCount".
//       As a solution update symbol count before calling the Exception Handler.
//                    Grep for XDSLRTFW-593:BugFix_ALL_ALL_ALL_SymbolCounts
//
//21/11/2012: Kannan: Added state machine
//    (1)When link is drop from showtime,  DSL FW Empties the Tx cell buffer by
//       pulling 8k(ATM)/120k(PTM) bit amount of data from the Tx cell buffer.
//       This is required for shared PDBRAM access between DSL FW and PPE FW.
//       Once the link is drop from showtime, PDBRAM memory (S_44k) will be used by the DSL FW for
//       training and PPE FW use it for showtime data traffic.
//       Hence DSL FW need to empty the user data if any available in the Tx cell buffer.
//       If user data is not available in Tx cell buffer, PPE will generate an idle cells for the
//       DSL FW to pull.
//    (2) Zephyr Tx path will be running for 4096 symbols additionally to pull the data from PPE
//        when the link is drop from showtime. Zephyr tx run count 4096 is emperically arrived.
//      Note: Though this change is applicable for ATM/PTM,  It has been tested in ATM mode only.
//     Grep for "XDSLRTFW-541: Platform_VR9_VRX318"
//
// 24/12/2012 ChihWen/Vinjam: Integration of R3.5 dying Gasp code changes to R5.2.
//            Overwrite one time the Tx IB FIFO with LPR indication when dying gasp event is happening (GPIO pin 15), so that the LPR will be indicated
//       in the next US OHC frame. The reason for doing so was that there could be one OHC frame delay between the dying gasp event and
//       the time when Tx IB FIFO was empty. This delay would cause one OHC frame later for indicating LPR.
//             Grep for XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR
//
// 07/01/2013 Ram: Fix added for JIRA 575 - Add support for incrementing UAS counter during training.
//                 Grep for XDSLRTFW-575: Counter Write back in ADSL mode
//
// 11/02/2013 Kannan:
//          1. Orderly shutdown algo implementation and it is applicable for both
//             VR9 & VRX318.
//             Grep for "XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown"
//23/01/2013 Bhadra:1)There were some FW intentional retrains for CNXT DSLAMs which are not indicated to API.
//           This requires code changes of Exception Code in 32 bit. (Currently we do reporting of 32 bit
//           only for certain cases in CMV_Remap.c, This has to be modified for all ExceptionCodes).
//           2) Code has been Optimized to avoid certain retrains like FailureState:172 - E_CODE_RCMsg1_Bis_CNXT_USPerfMidLoopTSSI
//           3) Since we have problems in mis-detecting cross talk as C-tones
//           (and thus indicating HS entered to API even though CO is not connected to ADSL modes),
//           Move indicating the HS entered (STAT 0 0 -> 5 ) after C-GALF1 is detected.
//           This will give clear picture whether HS is entered or not?
//           4) If time out occurs at C-GLAF1 phase, most probably this is C-Tone mis-detection.
//           So goto silence phase again instead of Failstate and also API will not reset the Timer.
//               This is CMV controlled  INFO 103 bit#1 (0x0002) default this is enabled.
//           5) Corrected the bug introduced as part of fix XDSLRTFW-507."Temp_AnxCnt" is initialised to total octets in msg till  SI-SPAR(1)
//           instead of SI-SPAR(1) octets. In general we can check for MAX SPAR1 octets (5).
//           For  Code Changes grep for XDSLRTFW-626: Enh_all_all_TelfonicaLongTraining
//
//27/05/2013 Varun : Added code(Debug option) to initialize the DMA of of Debug Buffer in case of failure before Training
//                   Grep for "XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer"
// 20/06/2013 Varun : Added code(Debug option) to initialize the DMA of of Debug Buffer if case of showtime failure
//                Grep for "XDSLRTFW-599 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
// 28/08/2013 Ram: Bug-> With TI-AC7 CO, Rx goes to showtime first and sets STAT_MacroState to STAT_ShowTimeTCSyncState in
//                 do_atm_processing(). When Tx comes to showtime, if condition (!isShowtime()) fails and STAT_PowerMode
//                 never gets SET to L0. API/UGW finds that CPE is still in L3 mode even after coming to Showtime and hence
//                 drops the link. Modified the if condition to solve the Bug.
//                 Grep for //XDSLRTFW-1198: BugFix_DS_BisPlus_TIAC7_Showtime_LinkDrop_After_5Secs
//
//18/07/2014 Balabth: AFE Read access failures are seen because of  AFE_DONE bit not getting cleared.
//           AFE_DONE bit is W1C (Write 1 to clear this bit). DSL FW write 1 to clear this bit for both AFE read and AFE write functions.
//           We are reading the register immediately after setting this bit some times not working.
//          added wait until AFE_DONE bit get cleared .
//          And There was a bug for reporting the sub-error codes if AFE failure occurs after LinkStart.Fixed the same
//          Grep for: "XDSLRTFW-1831"
//
// 18/11/2014 Vinay : Added a new CMV (INFO 241) to capture the configuration of ADSL as a debug feature.
//       Grep for XDSLRTFW-1782 : CAPTURE_CONFIGURATION_MESSAGES
//
// 07/05/2015 Sriram Shastry : Implement  Final Fail  state. Introduced new Tx and  Rx Substate before entering  Final fail state.
//          Grep for  :XDSLRTFW-2254
//
// 18/01/2016 Vinay: Added code to prevent Line DRiver going to power down when link drops or fails.
//                   Grep for XDSLRTFW-2555
// *************************************************************************************************

#include "typedef.h"
#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "xgdata.h"
#include "DSLEngin.h"
#include "pwr_ctbk.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "ghs.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "xrtstate.h"
#include "states.h"
#include "fdq_init.h"
#include "fifo.h"
#include "mtkernel.h"
#include "pll.h"
#include "bert.h"
#include "codeswap.h"
#include "cmv.h"
#include "mp.h"
// XDSLRTFW-2254 FINAL_FAILSTATE (BEGIN)
#include "aux_regs.h"
#include "LL_IOf.h"
// XDSLRTFW-2254 FINAL_FAILSTATE (END)
#if (defined(ADSL_62) && defined(TARGET_HW))
#include "hmp.h"
#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"
#else
#include "nmp.h"
#endif
#include "nmp_plfm.h"
#include "pll.h"
#include "timercov.h"
#include "RSilent0TxF.h"
#include "RCTonesRxF.h"
#include "RTonesReqTxF.h"
#include "trail.h"
#include "ovflw.h"
#include "memsetbf.h"
#include "trail.h"
#include "me_hdlc_txprocessor_bis.h"
#include "profdbg.h"
#include "tx_plam.h"
#include "soc_codeswap.h"  // XDSLRTFW-2254 FINAL_FAILSTATE (BEGIN_END)
#ifdef TARGET_HW
#include "gpio.h"
#endif

#if defined(DANUBE) && defined(TARGET_HW) && defined(TX_NOISESHAPER_RESET)
#include "afe.h"
#endif
#ifdef HERC_API
#include "gdata_bis.h"
#include "cmv_remap.h"
#endif

#define STATES_PRN FALSE      /*  specify whether printing is turned on (TRUE) or off (FALSE) */
#if STATES_PRN
#include <stdio.h>
#endif
//#ifdef DANUBE
#ifdef TARGET_HW
#include "dataswap.h"
#include "DebugBuffer.h"
#endif
//#endif

//XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR (START)
#define ReadMemory32(ul_addr, pul_data) *(pul_data) = *((volatile uint32*)((uint32)ul_addr))
#define WriteMemory32(ul_addr, ul_data) *((volatile uint32*)((uint32)ul_addr)) = (ul_data)
//XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR (END)

//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START_END)
//XDSLRTFW-541: Platform_VRX318 (START_END)
#include "cri_iof.h"
#include "memrymap.h"


/* =============================================== */
/* defintions */
/* =============================================== */
//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
#define PPE_ACK_WAIT_TIMEOUT (10*4000)  //10secs timeout
//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)

/* =============================================== */
/* Global variable declarations */
/* =============================================== */
//XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR (START)
FlagT gft_debug_LPR;
int32 gl_debug_cnt1;
int32 gl_debug_cnt2;
//XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR (END)

int16 SizeTcb;
PtrToFunc gpF_TxStateFunc;    // Global function pointer of TX state function
PtrToFunc gpF_RxStateFunc;    // Global function pointer of RX state function
PtrToFunc gpF_TxStateJumpTo;  // Global function pointer of TX jump state
PtrToFunc gpF_RxStateJumpTo;  // Global function pointer of RX jump state

extern uint8 guc_PortActive;

#ifdef TARGET_HW
extern void CheckShowtimeUpdate(uint16 us_SuppressInfo, FlagT ft_ResetTimer, uint16* us_Timer, int16 s_TempMargin1,
                  int16 s_TempMargin2, int16 s_FinalMargin1, int16 s_FinalMargin2);
//extern void CheckShowtimeUpdate();
#endif

extern void LeaveTrail(int32 l_SymbolCount, int16 s_State, int16 s_NextState, char *name);

// enter FAIL_RX only
void EnterFailStates(uint32 us_ErrorCode)
{
    gs_RxNextState = FAIL_RX;
    gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

    //Set exception handler variable
    gus_ExceptionState  = gs_RxState;
    gus_ExceptionCode   = us_ErrorCode;
   // XDSLRTFW-802:IOP_ALL_ALL_ALL_LongTrainingtimeDuetoTaskScheduling (Start)
    gl_save_RxSymbolCount = gl_RxSymbolCount;
    gs_save_RxSubState = gs_RxSubState;
    gl_save_TxSymbolCount = gl_TxSymbolCount;
    gs_save_TxSubState = gs_TxSubState;
   // XDSLRTFW-802:IOP_ALL_ALL_ALL_LongTrainingtimeDuetoTaskScheduling (End)

    // XDSLRTFW-1782 : CAPTURE_CONFIGURATION_MESSAGES (START)
    Decode_Config_Info();
    // XDSLRTFW-1782 : CAPTURE_CONFIGURATION_MESSAGES (END)

#ifdef DEBUG_STREAMING
   DSH_SendEvent(DSH_EVT_EXCEPTION, sizeof(gus_ExceptionCode), &gus_ExceptionCode);
#endif
}

#ifdef ADSL_62
//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
//XDSLRTFW-541: Platform_VR9_VRX318 (START)

// XDSLRTFW-2254 FINAL_FAILSTATE (BEGIN)

   //Rx FAIL Sub States
   #define INIT_RX_FAIL            (0)
   #define GET_PDBRAM_OWNERSHIP    (1)
   #define SHUT_OFF_RX_PPE         (2) // PPE
   #define CHECK_FOR_CODESWAP_DONE (3) // CodeSwap Finished
   #define SHUT_OFF_BGTASK         (4) // BackGround Tasks
   #define FINAL_TERMINATE         (5)
   #define RX_PATH_OFF_DONE        (-1)
   //Tx FAIL Sub States
   #define INIT_TX_FAIL            (0)
   #define SHUT_OFF_TX_PPE         (1) // PPE
   #define INFORM_FAIL_REBOOT      (2) // MEI Indication
   #define TX_PATH_OFF_DONE        (-1)
// XDSLRTFW-2254 FINAL_FAILSTATE (END)
extern void DisableTxPms(void);
extern void DisableRxPms(void);

// place holder for auto-reset
void FailRxF(void)
{

    switch(gs_RxSubState)
    {

        case INIT_RX_FAIL:
            if (gs_TxState == FAIL_TX)
            {
               // Suppress Fail State indication in showtime, if suppress cmv enabled
               if ((STATArray[STAT_MacroState] != STAT_ShowTimeState) ||
                  !(TESTArray[TEST_SuppressErrorReportingToME] & TEST_SuppressFailStateToME))
               {
                  STATArray[STAT_MacroState] = STAT_PreFailState;   //STAT_LinkDownState
                  gt_HercADSL_STATMap_MacroState.s_Offset0 = STAT_PreFailState;
                  gusa_HercADSL_MONIMap_Curr[0] = MONI_PREFAIL;
               }

               //XDSLRTFW-541: Platform_VRX318 (START)
               //Clear Rx data status,Tx & Rx Link status bits of PPE
               DFE_PPE_RxDataStatus_LeaveShow();
               DFE_PPE_LinkStatus_TxRxLeaveShow();
               DFE_PPE_PDBRAM_S_44K_Mem_Owner();
               gus_LinkDownState_SymCount = 0;
               //XDSLRTFW-541: Platform_VRX318 (END)

               //Do not reboot the  modem in showtime immediately, since CPE need to pull
               //120K bit(PTM mode)/8K bit(ATM mode) of data from the PPE buffer to empty the PPE buffer.
               //In order to pull the data from the PPE, we need to run the Zephyr for
               //N number of symbols. N = (PTM Mode) , N = (ATM Mode)
               //we will let zephyr tx run until an additional 120k bits have been read from PPE
               gs_RxSubState = GET_PDBRAM_OWNERSHIP;
            }
            break;

      case GET_PDBRAM_OWNERSHIP:
            //we will let zephyr tx run until an additional 120k bits have been read from PPE
            gus_LinkDownState_SymCount++;
            if (guc_s_44k_owner & MASK_BIT0)
            {
               DFE_PPE_PDBRAM_S_44K_Mem_Owner();
            }
            if ( (((guc_s_44k_owner & MASK_BIT0) == 0) &&
               (gus_LinkDownState_SymCount >= gus_Zep_Tx_DelayCnt)) ||
               (gus_LinkDownState_SymCount >= PPE_ACK_WAIT_TIMEOUT) )
            {
            // XDSLRTFW-2254 FINAL_FAILSTATE (BEGIN_END)
            gs_RxSubState = SHUT_OFF_RX_PPE;

            }
            break;


// XDSLRTFW-2254 FINAL_FAILSTATE (BEGIN)

        case  SHUT_OFF_RX_PPE :

         gt_TaskArray[RX_TSC_INT].TimeCriticalTask = RxProcessTones;
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, DisableRxPms);
         gs_RxSubState = CHECK_FOR_CODESWAP_DONE;

         break;

      case CHECK_FOR_CODESWAP_DONE:

         if (CheckForCodeSwapDone())   /* Check for codeswap done */
         {
            gs_CodeSwapStatus = CODESWAP_COMPLETE;
            gs_RxSubState = SHUT_OFF_BGTASK;
         }
         break;

      case SHUT_OFF_BGTASK:
            // check all background tasks are done.

            if ((gs_TxSubState == TX_PATH_OFF_DONE) &&
            (gp_BGTaskFifo->FunctionBuffer[gp_BGTaskFifo->IndexOfOldest] == 0) && (gl_CurrentBGTask == 0))
         {
            // for now this is the last substate
            // The modem should enter the TERMINATE state only when CNTL 0 0 4 is issued. But we were doing
            // an "AND" operation with "0x4" and we used to enter the TERMINATE state when Bit 2 is set in CNTL 0
            if(CNTLArray[CNTL_ModemControl] == CNTL_FinalFailState)
            {
               gs_RxSubState = FINAL_TERMINATE;
            }
            else
            {
               gs_RxSubState = RX_PATH_OFF_DONE;
               guc_PortActive = 0;
            }
         }
            break;


         case FINAL_TERMINATE:

         if(guc_MPMsgReq== 0)
         {
            guc_PortActive = 0;
            gft_PauseOff=FALSE;
            Pause(1);
         }
         break;
    }
// XDSLRTFW-2254 FINAL_FAILSTATE (END)
}


void FailTxF(void)
{

    switch(gs_TxSubState)
    {

        case INIT_TX_FAIL:
// XDSLRTFW-2254 FINAL_FAILSTATE (BEGIN)
         if ((gs_RxState == FAIL_RX) && (gs_RxSubState >= SHUT_OFF_RX_PPE))
// XDSLRTFW-2254 FINAL_FAILSTATE (END)
         {
            gs_TxSubState = SHUT_OFF_TX_PPE;

         }

         break;

        case SHUT_OFF_TX_PPE:

// XDSLRTFW-2254 FINAL_FAILSTATE (BEGIN)
               // disable TX data path
            // FRAME START is used for Frame aling/Sync  across  two Modems. Master Send's Txsingal & Tx-Master signal acts as a reference
            // for  the  Slave modem. Slave modem will Tx signal+offset to Reference signal and perform  sync with Master Modem. Thus Frame
            // is will be aligned.
            // Unlike VDSL system , which uses TX/RX_FRAME START ==> Training Phase & TSC ==> Showtime operation.
            // ADSL system uses TX_FRAME_START for both Tranining & Showtime .
            gt_TaskArray[TX_FRAME_START].TimeCriticalTask = TxProcessTones;   //TX_TSC_INT -->TX_FRAME_START

            // Time Slot controller will co-ordinate time slots across hardware resources. Like:
            // TC layer core, Zephyr core and the Iridia-QTP and Iridia-QT cores
            // gt_TaskArray[TX_TSC_INT].TimeCriticalTask = TxProcessTones;

            AddFunctionToFifo(gp_TxLoadingFunctionFifo, DisableTxPms);
// XDSLRTFW-2254 FINAL_FAILSTATE (END)
            gs_TxSubState = INFORM_FAIL_REBOOT;

      break;


        case INFORM_FAIL_REBOOT:

            // Suppress Fail State indication in showtime, if suppress cmv enabled
             if ((STATArray[STAT_MacroState] != STAT_ShowTimeState) ||
               !(TESTArray[TEST_SuppressErrorReportingToME] & TEST_SuppressFailStateToME))
            {
               //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
               //XDSLRTFW-541: Platform_VRX318 (START)
               // Force Margin cmv to be negative. This is to ensure that ME reboots
               // in showtime, as ME does not look for FAIL state in showtime
               gt_NearEndParam.s_SnrMargin = -20;
               gs_SnrMargin_OneOverTen_dB_Resolution = -100;
               STATArray[STAT_MacroState] = STAT_FailState;
               gt_HercADSL_STATMap_MacroState.s_Offset0 = STAT_FailState;
               gusa_HercADSL_MONIMap_Curr[0] = MONI_FAIL;
               gs_AutoMsgHandlerState = CHECK_MODEM_MACRO_STATE;
               STATArray[STAT_FailureState] = (uint16)(gus_ExceptionCode) &(0xFFFF);
               // Feature_ALL_ALL_ALL_PrevExceptionsCMV (Start)
               gus_ExceptionCode_Persis = (uint16)(gus_ExceptionCode)&(0xFFFF);
               gus_ExceptionState_Persis = gus_ExceptionState;
               // Feature_ALL_ALL_ALL_PrevExceptionsCMV (End) */
               //XDSLRTFW-541: Platform_VRX318 (END)
               //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)
               gs_TxSubState = TX_PATH_OFF_DONE;
            }
            break;

    }
}

void RxIdleTC(void);
void TxIdleTC(void);
//XDSLRTFW-541: Platform_VR9_VRX318 (END)
//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)
#endif

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void ExceptionHandler(void);
*
*  Description:
*     This function decides where to go from FAIL_TX and FAIL_RX state
*     and also print out error message (if desired)
*
*  Global Variables:
*     gus_ExceptionState   -- (I) State where exception occurs
*     gus_ExceptionCode -- (I) Code to indicate the cause of exception
*     gft_AutoRestartFlag  -- (I) Indicator if the state machine should go to G.hs or not
*     gs_TxNextState    -- (O) TX next state
*     gs_RxNextState    -- (O) RX next state
*     gs_Tx_OutBuf_Size -- (O) TX output buffer size
*
*-------------------------------------------------------------------
*^^^
*/
#ifdef ANX_J_DEBUG
extern int16 gs_Set_Pause;
#endif
void ExceptionHandler(void) {
uint16 us_Errorcode;
uint16 us_FWFailurecode;

#ifdef DEBUG_TRACES

if(guc_ShowtimeEnter==0) // XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer(START_END)
{
//update the stuctures for DMA initialization of DebugBuffer
RequestSwap_DebugBuff_GHS_OR_TRAINING_Tomem();

}
else //XDSLRTFW-599 FEATURE_ALL_ALL_ALL_Debug_Buffer(START)
{
   //update the superframe debug parameters at the failure state once
   updateShowtimeBuffSuperframe();

   int16 s_size_bytes=gus_LenDebugBuff;
   //if gu_LenDebugBuff more than DEBUG_INTERNAL_PING_OR_PONG_BUFFER_MAX_SIZE_BYTES then it is pointing the pong buffer => subtract DEBUG_INTERNAL_PING_OR_PONG_BUFFER_MAX_SIZE_BYTES to get the actual size
                  if(gus_LenDebugBuff>=DEBUG_INTERNAL_PING_OR_PONG_BUFFER_MAX_SIZE_BYTES)
                     s_size_bytes=gus_LenDebugBuff-DEBUG_INTERNAL_PING_OR_PONG_BUFFER_MAX_SIZE_BYTES;

      RequestSwap_DebugBuff_ShowTime_Tomem((int32 *)(void *)&gpuca_debugBuff[gus_LenDebugBuff-s_size_bytes],s_size_bytes);
}//XDSLRTFW-599 FEATURE_ALL_ALL_ALL_Debug_Buffer(END)

#endif // #ifdef DEBUG_TRACES


#ifdef ANX_J_DEBUG
   if(gs_Set_Pause == 0xE5) Pause(0xABE5);  //Debug
#endif
   // OR the 4-bit bitload exception code into bits 12-9 of the exception code.
   gus_ExceptionCode = gus_ExceptionCode | (gus_BitloadExceptionCode<<8);


#ifndef BIS_CODESWAP
   /* Perform auto start (i.e., go to G.handshake */
   if(gft_AutoRestartFlag == TRUE) {

      if((gus_ExceptionCode & 0xff) == (E_CODE_C_TONES & 0xff)) {/* CO initiated GHS */
         gs_TxNextState = R_SILENT0_TX;
         gpF_TxStateFunc = (PtrToFunc)RSilent0TxF;

         gs_RxNextState = R_C_TONES_RX;
         gpF_RxStateFunc = (PtrToFunc)RCTonesRxF;
      }
      else { /* CPE initated GHS       */
         //XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING(Start)
#ifdef  ADSL_BONDING
         if (gft_EnableBondingExchangeOnly)
         {
            //Go to STAT_BondingExchangeComplete macro state and also silence Tx
            gsa_IndirectStat0[0] = STAT_BondingExchangeComplete; //compiled out
            gs_MONI_ModemStat_Status = MONI_BONDINGEXCHANGE_COMPLETE; //compiled out
         }
#endif
         //XDSLRTFW-230 Feature_ALL_ALL_ALL_PTM_BONDING(End)
         gs_TxNextState = R_TONES_REQ_TX;
         gpF_TxStateFunc = (PtrToFunc)RTonesReqTxF;

         gs_RxNextState = R_C_TONES_RX;
         gpF_RxStateFunc = (PtrToFunc)RCTonesRxF;

         AddFunctionToFifo(gp_RxLoadingFunctionFifo,MoveToFdqDoneInt);
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,EnableFDQDoneNTC_EnableGetRxTones);
         /* in case, the transition was done in the middle of Rx sync */
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,ResetRxAlign);
      }

      /*  initialize input/output buffer sizes */
      RemoveTxCP();
      RemoveRxCP();
   }
   /* Goto stop state to debug the problem */
   else {
#endif
      // Turn off transmitter.
      gus_TxSineGain = 0;
      LoadTxSineGain();

      // XDSLRTFW-2555 (Start)
      //XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR (START)
      //Turn off line driver
        //VR9_SetLDMode(LD_PDN); // Commenting this instruction to prevent the Line driver turning power down
        //XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR (END)
      // XDSLRTFW-2555 (End)

      // Suppress Fail State indication in showtime, if suppress cmv enabled
      if ((STATArray[STAT_MacroState] != STAT_ShowTimeState) ||
         !(TESTArray[TEST_SuppressErrorReportingToME] & TEST_SuppressFailStateToME))
      {
#ifndef ADSL_62
         for (i = 0; i < NUM_TASK_BUFFERS; i++)
            gt_TaskArray[i].TimeCriticalTask = NULL;
#else
            gt_TaskArray[RX_FRAME_START].TimeCriticalTask = RxIdleTC;
            gt_TaskArray[RX_TSC_INT].TimeCriticalTask = RxIdleTC;

            gt_TaskArray[TX_FRAME_START].TimeCriticalTask = TxIdleTC;
#endif
      }

#ifdef HERC_API
      if (gs_TxState == FAIL_TX)
         gt_HercADSL_STATMap_FailureState.s_TxState_AtFail = gus_ExceptionState;
      else
         gt_HercADSL_STATMap_FailureState.s_TxState_AtFail = gs_TxState;

      if (gs_RxState== FAIL_RX)
         gt_HercADSL_STATMap_FailureState.s_RxState_AtFail = gus_ExceptionState;
      else
         gt_HercADSL_STATMap_FailureState.s_RxState_AtFail = gs_RxState;

      gt_HercADSL_STATMap_FailureState.s_TxSubState_AtFail = gs_save_TxSubState;
      gt_HercADSL_STATMap_FailureState.s_RxSubState_AtFail = gs_save_RxSubState;
      gt_HercADSL_STATMap_FailureState.l_TxSymbolCount_AtFail = gl_save_TxSymbolCount;
      gt_HercADSL_STATMap_FailureState.l_RxSymbolCount_AtFail = gl_save_RxSymbolCount;
      //XDSLRTFW-626: Enh_all_all_TelfonicaLongTraining (Start)
      //gt_HercADSL_STATMap_FailureState.ul_ExceptionCode = (int32) (gus_ExceptionCode & 0xFF);
      // Indicate 32-bit value;
      us_Errorcode = (gus_ExceptionCode >> 16) & (0xFFFF);
      us_FWFailurecode = (gus_ExceptionCode  & 0xFFFF);
      gt_HercADSL_STATMap_FailureState.ul_ExceptionCode = (us_FWFailurecode <<16) | (us_Errorcode);
      gt_HercADSL_STATMap_FailureState.us_BitloadErrorCode = gus_BitloadExceptionCode;
      //XDSLRTFW-626: Enh_all_all_TelfonicaLongTraining (end)

#endif





#ifdef DEBUG_STREAMING
   DSH_SendEvent(DSH_EVT_EXCEPTION, sizeof(gt_HercADSL_STATMap_FailureState.ul_ExceptionCode), &gt_HercADSL_STATMap_FailureState.ul_ExceptionCode);
#endif
#ifdef ADSL_62
      gs_TxNextState = FAIL_TX;
      gs_RxNextState = FAIL_RX;

      gpF_TxStateFunc = (PtrToFunc)FailTxF;
      gpF_RxStateFunc = (PtrToFunc)FailRxF;
#else
      gs_TxNextState = gs_TxStopState;
      gs_RxNextState = gs_RxStopState;

      gpF_TxStateFunc = (PtrToFunc)ExceptionHandler;
      gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;
#endif

#ifndef BIS_CODESWAP
   }
#endif

}



/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void TxForeGround(void);
*
*   Description:
*     This function executes the TX foreground processing.
*
*  Arguments:
*     none
*
*  Global Variables:
*     gs_TxStopState    -- (I) TX stop state
*     gs_TxStateJumpFrom   -- (I) TX jump from state
*     gs_TxStateJumpTo  -- (I) TX jump to state
*     gs_TxState        -- (I/O) TX current state
*     gs_TxSymbolCount  -- (I/O) TX symbol count
*     gs_TxNextState    -- (I/O) TX next state
*     gs_TxSubState     -- (O) TX substate
*     gft_ShowTimeFirstPassTx -- (O) TX showtime first-pass indicator
*     gs_Tx_OutBuf_Size -- (I/O) TX output buffer size
*     gft_HpfFlag       -- (I) flag = 1: HPF is on, else off
*     gt_HPFInput       -- (I/O) FIR filter structure containing the HPF parameters
*     gus_TxSineGain    -- (I) TX gain level
*     gsa_TxDtoABuf[]      -- (O) buffer for D to A samples
*     sa_EchoBuf[]      -- (O) buffer for simulated echo samples
*-------------------------------------------------------------------
*^^^
*/
void TxForeGround(void) {

#ifdef PROFILE_TASKS
   LogMips(TX_NTC, TC_NTC_START_FLAG);
#endif

#ifdef DEBUG_STREAMING
         if(gs_save_TxState != gs_TxState)
         {
            uint16 usa_stateArray[] =  {gs_RxState,gs_TxState};
            DSH_SendEvent(DSH_EVT_STATE_CHANGE,4,&usa_stateArray);
            gs_save_TxState = gs_TxState;
         }
         if(gs_save_TxSubState != gs_TxSubState)
         {
            uint16 usa_substateArray[] =  {gs_RxSubState,gs_TxSubState};
            DSH_SendEvent(DSH_EVT_SUB_STATE_CHANGE,4,&usa_substateArray);
            gs_save_TxSubState = gs_TxSubState;
         }
#endif

   /* If we are not in the stop state */
   if(gs_TxNextState != gs_TxStopState) {

      if(gs_TxState != gs_TxNextState)
      {  /*  if there is a state change */

         /* Check to see if we are to reach jump state */
         if (gs_TxNextState == gs_TxStateJumpFrom) {
            /*  change to JumpTo state */
            LeaveTrail(gl_TxSymbolCount, gs_TxState, gs_TxStateJumpTo, "TX");

            gs_TxState = gs_TxStateJumpTo;
            gs_TxNextState = gs_TxState;

            gpF_TxStateFunc = gpF_TxStateJumpTo;
         }
         else {
            LeaveTrail(gl_TxSymbolCount, gs_TxState, gs_TxNextState, "TX");

            /* usual state change */
            gs_TxState = gs_TxNextState;
         }

         // save fail state information
         gl_save_TxSymbolCount = gl_TxSymbolCount;
         gs_save_TxSubState = gs_TxSubState;
         gl_save_RxSymbolCount = gl_RxSymbolCount;
         gs_save_RxSubState = gs_RxSubState;

         /* Reset symbol count and substate at the beginning of a new state */
         gl_TxSymbolCount = 0;
         gs_TxSubState = 0;
         gs_TxSubStateCnt = 0;
         /* If we are using h/w based sequence generation in this state */
         if(gft_QAM_On == TRUE) {
            /* tear down h/w based sequence generation settings for the next state */
            AddFunctionToFifo(gp_TxLoadingFunctionFifo,TxHwSequenceGenerationTeardown);
         }

#if defined(TX_NOISESHAPER_RESET)
         WriteAfe(DANUBEA_SOFT_RESETS, 0x0000);    /* enable Tx-Noise-Shaper */
#endif
         /* Reset hardware overflow counter to be 0 */
         MemSetBuffer((int16*)(void *)gusa_TxOverflowCnts, 0, 0, NUM_TX_OVFLOW_CNTRS*sizeof(uint16));
        }
      else {

         /* Increase symbol count */
         gl_TxSymbolCount++;
      }
    }
   /* else: freeze l_TxSymbolCount, s_TxState, s_TxNextState and s_TxSubState  */
   /* if we transition into a stopstate (for debug)    */
#ifndef ADSL_62
   if (gs_TxState != R_SHOWTIME_TX)
#endif
   if(STATArray[STAT_MacroState] != STAT_FailState)
   {
      /* =========================================================================== */
      // Check the Tx, Rx overflow info in hardware (Iridia, Strymon)
      /* =========================================================================== */
      UpdateOverFlowCounters();

      // reset the overflow indicator in case the value being double counted.
      gus_IRI_Tx_Ovflw = 0;
      gus_IRI_Rx_Ovflw = 0;
      gus_STR_Ovflw = 0;

      isStateTrigger(gs_TxState, gs_TxSubState, gl_TxSymbolCount);
      isTxSubStateTrigger();
   }
//Feature_ALL_ALL_ALL_AFE_DFE_3GLP_Status (Start)
#if (defined(ADSL_62) && defined(TARGET_HW))
#ifndef VRX518
   //if (STATArray[STAT_MacroState] != STAT_FailState)
   //{
      Update_GLP_OverFlowCounters(0); //for Macro 0
   //}
#endif
#endif
//Feature_ALL_ALL_ALL_AFE_DFE_3GLP_Status(End)

   //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
   //Orderly shutdown request from SW/API
   if (CNTLArray[CNTL_PM_Control] & CNTL_OrderlyShutDown)
   {
      if (!((gs_TxState == FAIL_TX) || (gs_RxState == FAIL_RX)))
      {
          gus_ExceptionCode = E_CODE_ORDERLY_SHUTDOWN;
          gus_ExceptionState  = gs_TxState;
          gs_TxNextState = FAIL_TX;
          //XDSLRTFW-593:BugFix_ALL_ALL_ALL_SymbolCounts (start)
          // save the Rx/Tx Symbol Count before entering ExceptionHandler
          gl_save_RxSymbolCount = gl_RxSymbolCount;
          gs_save_RxSubState = gs_RxSubState;
          gl_save_TxSymbolCount = gl_TxSymbolCount;
          gs_save_TxSubState = gs_TxSubState;
          //XDSLRTFW-593:BugFix_ALL_ALL_ALL_SymbolCounts (end)
          gpF_TxStateFunc = (PtrToFunc)ExceptionHandler;
      }
   }
   //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)

   /* ======================================================================== */
   /* Execute state function */
   /* ======================================================================== */
PROFDBG_DO_TX_STATE_BEGIN
   (*gpF_TxStateFunc)();
PROFDBG_DO_TX_STATE_END

#ifdef PROFILE_TASKS
   LogMips(TX_NTC, TC_NTC_END_FLAG);
#endif

#pragma Offwarn(883)
} /*  TxForeGround() */
#pragma Onwarn(883)


/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void RxForeGround(void);
*
*   Description:
*     This function executes the RX foreground processing.
*
*  Arguments:
*     none
*
*  Global Variables:
*     gs_RxStopState    -- (I) RX stop state
*     gs_RxStateJumpFrom   -- (I) RX jump from state
*     gs_RxStateJumpTo  -- (I) RX jump to state
*     gs_RxState        -- (I/O) RX current state
*     gs_RxSymbolCount  -- (I/O) RX symbol count
*     gs_RxNextState    -- (I/O) RX next state
*     gs_RxSubState     -- (O) RX substate
*     gft_ShowTimeFirstPassRx -- (O) RX showtime first-pass indicator
*-------------------------------------------------------------------
*^^^
*/
void RxForeGround(void) {

   if (gft_StopDSL)  // If this flag is set, halt state machine and DSL cores (debug only).
      Pause(1234);

#ifdef PROFILE_TASKS
   LogMips(RX_NTC, TC_NTC_START_FLAG);
#endif

#ifdef DEBUG_STREAMING
         if(gs_save_RxState != gs_RxState)
         {
            uint16 usa_stateArray[] =  {gs_RxState,gs_TxState};
            DSH_SendEvent(DSH_EVT_STATE_CHANGE,4,&usa_stateArray);
            gs_save_RxState = gs_RxState;
         }
         if(gs_save_RxSubState != gs_RxSubState)
         {
            uint16 usa_substateArray[] =  {gs_RxSubState,gs_TxSubState};
            DSH_SendEvent(DSH_EVT_SUB_STATE_CHANGE,4,&usa_substateArray);
            gs_save_RxSubState = gs_RxSubState;
         }
#endif

  // XDSLRTFW-802:IOP_ALL_ALL_ALL_LongTrainingtimeDuetoTaskScheduling(Start)
   if(((gus_ExceptionCode & 0xFFFF) != E_CODE_NO_ERROR)&&
      ((gs_RxNextState != FAIL_RX)&&(gs_TxNextState != FAIL_TX))
     )
   {
      EnterFailStates(gus_ExceptionCode); //XDSLRTFW-1831

   }
   // XDSLRTFW-802:IOP_ALL_ALL_ALL_LongTrainingtimeDuetoTaskScheduling(End)

   /* If we are not in stop state */
   if (gs_RxNextState != gs_RxStopState)
   {
      /*  check to see if we have reached jump state */
      if (gs_RxState == gs_RxStateJumpFrom &&
         (gs_RxSubStateJumpFrom == -1 || gs_RxSubState == gs_RxSubStateJumpFrom))
      {
         gs_RxNextState = gs_RxStateJumpTo;
         gpF_RxStateFunc = gpF_RxStateJumpTo;
      }

      if (gs_RxState != gs_RxNextState)
      {
         /*  Record state change for debug purpose */
         LeaveTrail(gl_RxSymbolCount, gs_RxState, gs_RxNextState, "RX");

         // save fail state informations
         gl_save_RxSymbolCount = gl_RxSymbolCount;
         gs_save_RxSubState = gs_RxSubState;
         gl_save_TxSymbolCount = gl_TxSymbolCount; //will be helpful in debug
         gs_save_TxSubState = gs_TxSubState;

         /* Reset symbol count and substate at the beginning of a new state */
         gl_RxSymbolCount = 0;
         gs_RxSubState = 0;
         gs_RxSubStateCnt = 0;
         gs_RxState = gs_RxNextState;

         /* Reset hardware overflow counter to be 0 */
         MemSetBuffer((int16*)(void *)gusa_RxOverflowCnts, 0, 0, NUM_RX_OVFLOW_CNTRS*sizeof(uint16));
      }
      else
      {
         gl_RxSymbolCount++;
      }
   } /* Stop state if */

#ifdef LEAVE_TRAIL
   // Print Rx, Tx state/symbol count info to screen.
   PrnStatus();
#endif

   CheckForCodeSwap();
#ifdef DEBUG_TRACES
//#ifdef DANUBE
#ifdef TARGET_HW
    CheckForDataSwap();
#endif
//#endif
#endif // #ifdef DEBUG_TRACES

   isStateTrigger(gs_RxState, gs_RxSubState, gl_RxSymbolCount);

#ifdef DEBUG_STREAMING
         if(gs_DSH_PrevMacroState != gt_HercADSL_STATMap_MacroState.s_Offset0)
         {
            gs_DSH_PrevMacroState = gt_HercADSL_STATMap_MacroState.s_Offset0;
            gpt_DSH_ModemFsmState->s_MacroState_Offset0 = gt_HercADSL_STATMap_MacroState.s_Offset0;
            DSH_SendStream(DSH_FSM_STATE, sizeof(DSH_ModemFsmState), (void *)gpt_DSH_ModemFsmState);
         }
#endif

   if ((gs_RxState != R_C_SHOWTIME_RX) && (STATArray[STAT_MacroState] != STAT_FailState))
   {
         isRxSubStateTrigger();
   }
   else
   {
      gs_NearEndFailureReported = gs_NearEndFailure;
      if (TESTArray[TEST_SuppressErrorReportingToME] & TEST_SuppressLOSFailureToME)
      {
         gs_NearEndFailureReported &= (~PLAM_LOS_FailureBit);
      }
      // set STAT to showtime if both RX and TX are in showtime
      if (gs_TxState==R_SHOWTIME_TX)
      {
         //XDSLRTFW-1198: BugFix_DS_BisPlus_TIAC7_Showtime_LinkDrop_After_5Secs (Start)
         //Bug: With TI-AC7 CO, Rx goes to showtime first and sets STAT_MacroState to STAT_ShowTimeTCSyncState in
         //do_atm_processing(). When Tx comes to showtime, foll if condition (!isShowtime()) fails and STAT_PowerMode
         //never gets SET to L0. API/UGW finds that CPE is still in L3 mode even after coming to Showtime and hence
         //drops the link.

         //if (!isShowtime())
         if((STATArray[STAT_PowerMode] == STAT_PM_L3) && (STATArray[STAT_MacroState] != STAT_FailState))
         //XDSLRTFW-1198: BugFix_DS_BisPlus_TIAC7_Showtime_LinkDrop_After_5Secs (End)
         {
            STATArray[STAT_MacroState] = STAT_ShowTimeState;
            gt_HercADSL_STATMap_MacroState.s_Offset0 = STAT_ShowTimeState;
            gusa_HercADSL_MONIMap_Curr[0] = MONI_SHOWTIME_TC_NOSYNC;
            STATArray[STAT_PowerMode] = STAT_PM_L0;
            gft_EnterL3afterNextReboot = FALSE;

            // XDSLRTFW-575: Counter Write back in ADSL mode (Start)
            // Now we are in showtime, hence make line 'available'
            gft_line_unavailable = FALSE;
            // XDSLRTFW-575: Counter Write back in ADSL mode (End)
         }

#ifdef HERC_API
         if ((gt_HercADSL_STATMap_MacroState.s_Offset0 == STAT_ShowTimeTCSyncState) && (gs_showtime_tc_sync_first_time < 1))
         {
            gs_showtime_tc_sync_first_time = 1;
            gft_showtime_tc_sync__ADSL_Mode = TRUE;   // XDSLRTFW-2191(Start_end)
         }
         else if ((gt_HercADSL_STATMap_MacroState.s_Offset0 == STAT_ShowTimeState) && (gs_showtime_tc_sync_first_time == 1))
         {
            gs_showtime_tc_sync_first_time = 2;
         }
#endif
      }
// ******************************************************************
// states.c
//
// History
//
// 08/02/2010 : Transition to Fail State (STAT 0 0 = 0x2) from Showtime
//                   based on conditions given in the message 'CMD_ReInitNE_Configure'
//                   Currently, only LOM (Loss of Margin) or LOS (Loss of Sync) will
//                   trigger this to go to Fail State.
//                   Grep for SMS01381699
//
// ******************************************************************
#ifdef TARGET_HW
      // SMS01381699 (Start)
      // ReInit Triggers for Showtime -> FailState transition
        //XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start)
      if (gs_RxState == R_C_SHOWTIME_RX)
        {
            //Feature_ALL_ALL_FT_ReInit_Triggers(Start_end)
            gus_ExceptionCode = 0;
            if ((gs_NearEndFailure & PLAM_LOM_FailureBit) && (gsa_HercADSL_MONIMap_ShowFailConditions[0].s_Offset0 & MONI_LOM_FAILURE)
                && !(TESTArray[TEST_SuppressErrorReportingToME] & TEST_SuppressSNRMarginToME) && (gft_TriggerLOMReInit == TRUE))
            {
                gus_ExceptionCode   =   E_CODE_ShowtimeMargin_Failure;
            }
         //XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers (start)
         //NCD exception declaration
            if (((guca_US_TransferMode_bis[0] == ATM) || (gft_ModemType != G_DMT_BIS)) &&
            (gs_NearEndFailure & (PLAM_NCD_BC0_FailureBit | PLAM_NCD_BC1_FailureBit))
            && (gsa_HercADSL_MONIMap_ShowFailConditions[0].s_Offset0 &
               (MONI_NCD_FAILURE_BC0 | MONI_NCD_FAILURE_BC1))
                && !(TESTArray[TEST_SuppressErrorReportingToME] & TEST_SuppressNCDFailureToME))
            {
                gus_ExceptionCode   =  E_CODE_ShowtimeNCD_Failure;
            }
         //LCD exception declaration
            if (((guca_US_TransferMode_bis[0] == ATM) || (gft_ModemType != G_DMT_BIS)) &&
            (gs_NearEndFailure & (PLAM_LCD_BC0_FailureBit | PLAM_LCD_BC1_FailureBit))
               && (gsa_HercADSL_MONIMap_ShowFailConditions[0].s_Offset0 &
                  (MONI_LCD_FAILURE_BC0 | MONI_LCD_FAILURE_BC1))
                && !(TESTArray[TEST_SuppressErrorReportingToME] & TEST_SuppressLCDFailureToME))
            {
                gus_ExceptionCode   =  E_CODE_ShowtimeLCD_Failure;
            }
         //XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers (end)
            //Feature_ALL_ALL_FT_ReInit_Triggers(Start_end)
            if ((gs_NearEndFailure & PLAM_LOS_FailureBit) && (gsa_HercADSL_MONIMap_ShowFailConditions[0].s_Offset0 & MONI_LOS_FAILURE)
                && !(TESTArray[TEST_SuppressErrorReportingToME] & TEST_SuppressLOSFailureToME))
            {
                if(gs_NearEndFailure & PLAM_LOS_DueToCRC_FailureBit)
                    gus_ExceptionCode   =   E_CODE_ShowtimeLOS_DueToCRC_Failure;
                else
                    gus_ExceptionCode   =   E_CODE_ShowtimeLOS_Failure;
            }
            //Feature_ALL_ALL_FT_ReInit_Triggers(Start)
            //SMS01501977 SMS01276795 Enhancment_DS_ALL_ALL_FT_Reboot_Criteria (Start)
            if((guc_consecutive_err_sec_cnt >= 90) && (gsa_HercADSL_MONIMap_ShowFailConditions[0].s_Offset1 & MONI_ES90_FAILURE)
                && !(TESTArray[TEST_SuppressErrorReportingToME] & TEST_SuppressES90FailureToME))
            {
               guc_consecutive_err_sec_cnt=0;
               gus_ExceptionCode   =   E_CODE_ES90_FAILURE;
            }

            //SMS01501977 SMS01276795 Enhancment_DS_ALL_ALL_FT_Reboot_Criteria (End)
            //Feature_ALL_ALL_FT_ReInit_Triggers(End)
            if((guc_consecutive_sev_err_sec_cnt >= 30) && (gsa_HercADSL_MONIMap_ShowFailConditions[0].s_Offset1 & MONI_SES30_FAILURE)
                && !(TESTArray[TEST_SuppressErrorReportingToME] & TEST_SuppressSES30FailureToME))
            {
               guc_consecutive_sev_err_sec_cnt=0;
               gus_ExceptionCode   =   E_CODE_SES30_FAILURE;
            }
            if((guc_consecutive_sev_err_sec_cnt >= 10) && (gsa_HercADSL_MONIMap_ShowFailConditions[0].s_Offset0 & MONI_ESE_FAILURE)
                && !(TESTArray[TEST_SuppressErrorReportingToME] & TEST_SuppressESEFailureToME))
            {
               gus_ExceptionCode   =   E_CODE_ESE_FAILURE;
               gs_NearEndFailure |= PLAM_ESE_FailureBit;
            }
         //XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers(start end)
            if ((guca_US_TransferMode_bis[0] == PTM) && (gs_NearEndFailure & PLAM_OOS_FailureBit) &&
            (gsa_HercADSL_MONIMap_ShowFailConditions[0].s_Offset0 & MONI_OOS_FAILURE_BC0)
                && !(TESTArray[TEST_SuppressErrorReportingToME] & TEST_SuppressOOSFailureToME))
            {
                gus_ExceptionCode   =   E_CODE_ShowtimeOOS_Failure;
            }
         // XDSLRTFW-1481 (Start_END)

            if ((gs_NearEndFailure & PLAM_LOF_FailureBit) && (gsa_HercADSL_MONIMap_ShowFailConditions[0].s_Offset0 & MONI_LOF_FAILURE)
                && !(TESTArray[TEST_SuppressErrorReportingToME] & TEST_SuppressLOFFailureToME))
            {
                gus_ExceptionCode   =   E_CODE_ShowtimeLOF_Failure;
            }
            // XDSLRTFW-201 Feature_US_ALL_ALL_LPR(start)
#if 0       // Need to check this ! if added Txstate/RxSate will be changed to silent and
            // we may not send LPR indication bits more than once
            if((gs_NearEndFailure & PLAM_LPR_FailureBit) &&
                && !(TESTArray[TEST_SuppressErrorReportingToME] & TEST_SuppressLPRFailureToME))
            {
               gus_ExceptionCode   =   E_CODE_ShowtimeLPR_Failure;
            }
#endif
            // XDSLRTFW-201 Feature_US_ALL_ALL_LPR(End)
            if(gus_ExceptionCode != 0)
            {
                gus_ExceptionState  = gs_RxState;
                gs_RxNextState = FAIL_RX;
                //XDSLRTFW-593:BugFix_ALL_ALL_ALL_SymbolCounts (start)
                // save the Rx/Tx Symbol Count before entering ExceptionHandler
                gl_save_RxSymbolCount = gl_RxSymbolCount;
                gs_save_RxSubState = gs_RxSubState;
                gl_save_TxSymbolCount = gl_TxSymbolCount;
                gs_save_TxSubState = gs_TxSubState;
                //XDSLRTFW-593:BugFix_ALL_ALL_ALL_SymbolCounts (end)

                gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;
            }
        }
        //XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (End)
      // SMS01381699 (End)
#endif
   }



   /* =========================================================================== */
   /*  Execute state function that processes the RX signal */
   /* =========================================================================== */
PROFDBG_DO_RX_STATE_BEGIN
   (*gpF_RxStateFunc)();
PROFDBG_DO_RX_STATE_END

#ifdef HERC_API
   if (gs_MpWinhostControl == 1)
   {
      if (NewMPCheckMessage(VBM_MAILBOX)!= 0)
      {
         gs_ModemOperationRequired = NewMPHandleMessage(VBM_MAILBOX);
      }
   }
#endif

#ifdef TARGET_HW
   if(isShowtime())
   {
      //Check whether Showtime SNR is updating, if not, triggering negative SNRM
      CheckShowtimeUpdate((uint16)TEST_SuppressShowtimeSNRUpdateCntStuckToME,
         (gus_PrevSNRUpdateCnt != gus_ShowtimeSNRUpdateCount), &gus_10sec_SNRUpdate, gt_NearEndParam.s_SnrMargin, gs_SnrMargin_OneOverTen_dB_Resolution, -2, -10);

      gus_PrevSNRUpdateCnt = gus_ShowtimeSNRUpdateCount;

      //check SNRM update, postpone indication negative SNRM after 10sec of consecutive negative SNRM
      CheckShowtimeUpdate((uint16)TEST_SuppressSNRMarginToME,
         (gs_Margin>=0), &gus_10sec_NegSNRMTimer, 0, 0, gs_Margin, gs_Margin_Point1dB);

      // If Dying Gasp is enabled and a read of GPIO DyingGasp pin doesn't agree with
      // the read during start up, we declare near end loss of power.
      if (OPTNArray[OPTN_AlgControl2] & OPTN_EnableDGasp)
      {
         //XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR (START)
         if ( (GetGPIOBit(gt_Gpio.s_GPIO_DyingGasp_Pin) != gs_GPIO_PowerOn) || (CNTLArray[CNTL_ModemDying] == CNTL_ModemSendDyingGasp) )
         //XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR (END)
         {
            //XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR (START)
            if (gft_debug_LPR == 0)
            {
               uint32 ul_addr, ul_data;
               gft_debug_LPR = 1;
               gl_debug_cnt1 = gl_TxSymbolCount;

                  //The Tx IB FIFO contains 6 bytes from 0x4FE30 ~ 0x4FE35
                  //The sequence of writing 4 bytes of IB bits will as below.
                  //0x4FE34, 0x4FE35, 0x4FE30, 0x4FE31
                  //0x4FE32, 0x4FE33, 0x4FE34, 0x4FE35
                  //0x4FE30, 0x4FE31, 0x4FE32, 0x4FE33
                  // ...
                  //So ul_addr_offset is to calculate the address of the next first IB byte, in order to set LPR bit to zero.
               //ul_addr_offset = ((3 - (gl_TxIbFiFoWriteCnt % 3) + 2) % 3) * 2;

               ul_addr = 0x30D880;
               ReadMemory32(ul_addr, &ul_data);
               ul_addr = (ul_data & 0x3FFFF) + 0x40000;

               //ul_addr += ul_addr_offset;
               //ReadMemory32(ul_addr, &ul_data);

               ul_data = 0xDFFFDFFF;
               WriteMemory32(ul_addr, ul_data);

               ul_addr += 4;
               ReadMemory32(ul_addr, &ul_data);
               ul_data = (ul_data & 0xFFFF0000) | 0xDFFF;
               WriteMemory32(ul_addr, ul_data);
            }
            //XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR (END)

            gs_NE_LPR_indication = 1;

            //XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR (START)
            //Enter into fail state under CMV control.
            if (OPTNArray[OPTN_AlgControl2] & CMV_TO_ENABLE_LINK_DROP_FOR_DYING_GASP)
            {
               gs_lpr_frmcnt++;
               if (gs_lpr_frmcnt >= gs_lpr_frmcnt_before_drop_line)
               {
                     gus_ExceptionCode   = 0xAAAA;
                  gus_ExceptionState  = 0xAAAA;
                  gs_RxNextState = FAIL_RX;
                  gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;
               }
            }
            //XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR (END)
         }
         else
         {
            //XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR (START)
            if (gft_debug_LPR == 1)
               gl_debug_cnt2 = gl_TxSymbolCount;

            gs_lpr_frmcnt = 0;
            //XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR (END)

            gs_NE_LPR_indication = 0;
         }
      }
      // XDSLRTFW-201 Feature_US_ALL_ALL_LPR(start)
      if (gus_Set_LPR & DSL_ModemSendDyingGasp) //Check only DSL 5 0 Bit-0
      {
         gs_NE_LPR_indication = 1;
      }
      // XDSLRTFW-201 Feature_US_ALL_ALL_LPR(End)
   }

   FlashGPIO();

#endif // #ifdef TARGET_HW

#ifdef HERC_API

   // XDSLRTFW-575: Counter Write back in ADSL mode (Start)
   // Increment Unavailable seconds counter during training
   if (((STATArray[STAT_MacroState] == STAT_GhsState) ||
        (STATArray[STAT_MacroState] == STAT_FullInitState)) &&
       (gft_line_unavailable == TRUE))
   {
      gus_1Sec_RxTrnFrameCnt++;

      if (gus_1Sec_RxTrnFrameCnt == FRAME_COUNT_FOR_ONE_SEC)
      {
         gs_unavail_err_sec_cnt++;
         gt_HercADSL_CNTRMap_g997_NE_LinePerfCount.ul_UASLCnt++; // XDSLRTFW-1562 (Start)
         gus_1Sec_RxTrnFrameCnt = 0;
      }
   }
   // XDSLRTFW-575: Counter Write back in ADSL mode (End)


if (STATArray[STAT_MacroState] <= STAT_ReadyState)
   MapHercCNFGtoSOC();

    HercMonitorUpdate();
#endif // #ifdef HERC_API

#ifdef PROFILE_TASKS
   LogMips(RX_NTC, TC_NTC_END_FLAG);
#endif

#ifdef DEBUG_STREAMING
   // only execute when debug streams are enabled
   if(gt_debugStreamControl.Parameter0 & CMV_INFO115_CONTROL_MASK)
   {
      DSH_FgService();
   }
   else
   {
      //Set VersionInfoStreamed to FALSE, so Version Info gets streamed again next time streams get enabled again
      guc_DSH_VersionInfoStreamed = FALSE;
   }
#endif
} /*  RxForeGround() */

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: FlagT isShowtime(void);
*
*  Description: To be uniformly called to determine the showtime state
*           Regardless of platform or macrostate definition.
*
*-------------------------------------------------------------------
*^^^
*/
FlagT isShowtime(void)
{
#ifdef HERC_API
   return( (STATArray[STAT_MacroState] == STAT_ShowTimeState) || (STATArray[STAT_MacroState] == STAT_ShowTimeTCSyncState) || (STATArray[STAT_MacroState] == STAT_FailState) );
#else
   return( STATArray[STAT_MacroState] == STAT_ShowTimeState);
#endif
}


/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void EmptyState(void);
*
*  Description:
*      Empty dummy function that does nothing.
*
*-------------------------------------------------------------------
*^^^
*/
void EmptyState(void) {
   /*  Empty function. */
}
