/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   statestc.c
*
*  Functions for Time-critical tasks from state.c
*
*-------------------------------------------------------------------------
*/
//*******************************************************************
// statestc.c
//
// History
//
//
// 30/09/2011 Stefan : Upsteam performance fixes from Stefan.
//                     Vinjam integrated them to Vr9 R4.3 ADSL mainline
//                     Grep for XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl
//
// 17/01/2012 Vinjam : Fixed a coding bug in checking "CMV OPTN 30".
//                     Due to the coding bug, Tx Images were not created by firmware for Annex-M mode,
//                     even though "gft_TxImages" is set to "1".
//                     Grep for "Bug_VR9_US_3M5M_All_CreatingTxImages"
//
// 17/01/2012 Kannan/Vinjam: Fixed a coding bug which corrupts the Nyquist Bin
//                     Grep for "Bug_VR9_US_All_All_FixNyquistBin"
// 12/01/2012 Kannan : Send mirrored complex conjugate images in T1413 mode to emulate
//                     64pt IFFT in T1413 mode for TI & CNXT CO's.
//                     Grep for PERF_US_T1413_T1&CNXT_64ptIFFT
// 5/4/2013 Enable images for Cnxt .. send only single image
//          XDSLRTFW-577 IOP_US_AnxMPlus_Cnxt_UsPerf
//
// 17/05/2013 Ram: Scale down US Tx images in T1413 mode and loops > 15Kft to improve DS data rates.
//                 Grep for  XDSLRTFW-819: BugFix_DS_DMT_CNXT_Improve_DS_Performance_In_BTLoops
//
// 03/12/2013 ChihWen/Sriram Shastry: Scale down US Tx images with right shift.
//                 Grep for XDSLRTFW-1371/XDSLRTFW-1416 BugFix_US_ALL_ALL_ScaleDownTxImageWithRightShift
//*****************************************************************************

#include "typedef.h"
#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "xgdata.h"
#include "pwr_ctbk.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "ghs.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "xrtstate.h"
#include "states.h"
#include "fdq_init.h"
#include "fifo.h"
#include "mtkernel.h"
#include "pll.h"
#include "bert.h"
#include "codeswap.h"
#include "cmv.h"
#include "mp.h"
#include "nmp.h"
#include "nmp_plfm.h"
#include "pll.h"
#include "timercov.h"
#include "rcmedley_Data.h"
#include "med2rev.h"
#include "trail.h"
#include "gdata_bis.h"
#include "mul.h"
#include "afe.h"
#include "delay.h"
#include "string.h"
#ifdef DEBUG_STREAMING
#include "DebugBuffer.h"
#endif

#define STATES_PRN FALSE      /*  specify whether printing is turned on (TRUE) or off (FALSE) */
#if STATES_PRN
#include <stdio.h>
#endif

int8 jgIfftDelay = 50;
#ifdef ADSL_62
extern int16 gsa_TxTimeBuf[];  // size = 1024
extern FlagT gft_DisableIfft;
#endif

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void TxProcessTones(void);
*
*   Description:
*
*  Time-critical task associated with Tx Frame Start.
*
*  Arguments:
*     none
*
*  Global Variables:
*     gp_TxLoadingFunction -- (I) point to a function Fifo to implement
*                       frame specific processing (e.g. InsertTxCP)
*     gft_TxDataPump_On -- (I) flag set to TRUE once Fast/Inlv data
*                       processing is enabled (which may be prior
*                       to Showime due to MFC requirements)
*     gft_IFFT_On       -- (I) flag set to enable IFFT
*
*-------------------------------------------------------------------
*^^^
*/

void TxProcessTones(void)
{

    int16 s_ImageScaleFactor = 0;//XDSLRTFW-1371/XDSLRTFW-1416 BugFix_US_ALL_ALL_ScaleDownTxImageWithRightShift (START_END)


#ifdef PROFILE_TASKS
   LogMips(TX_TC_FS, TC_NTC_START_FLAG);
#endif

   /* ======================================================================== */
   /* gft_TxDataPump_On is set TRUE to begin the fast/inlv data processing.   */
   /* Due to multiframe codeword (MFC) considerations, this flag may be set   */
   /* prior to Showtime (in order to account for the required MFC buffer      */
   /* delay.  This flag is set by the state machine.                    */
   /*                                                       */
   /* ======================================================================== */

   if (gft_TxDataPump_On == TRUE)
   {
      if(gft_ModemType != G_DMT_BIS)
      {
         StartTxDataPump_DMT();
      }
      else
      {
         RShowtimeTxTC_BIS_B();
      }
   }


   /* ======================================================================== */
   /* TxLoading functions perform a frame specific function.  They are used to   */
   /* insert the Tx Cyclic Prefix (CP), for example.  gTxLoadingFunction is   */
   /* set by the state machine and is automatically cleared - i.e. the loading   */
   /* function is called only once.                               */
   /*                                                       */
   /* ======================================================================== */

   /* If there are pending loading functions, then run them */

   ExecuteQueuedLoadingFunctions(gp_TxLoadingFunctionFifo);

   if(gft_QAM_On == TRUE) {
      /* Hardware based sequence generation */
      Trigger_QAM();
   }
   else {
      /* ======================================================================== */
      /* LoadTxOutBuffer moves the data contained in TxToneBuf to the IFFT buffer   */
      /* ======================================================================== */
#ifdef ADSL_62
        if ((gs_StartDECTraining == TRUE) && (gft_DisableIfft ==TRUE))
        {
            LoadTxOutBuffer(gsa_TxTimeBuf, gs_TxFftLength);
        }
//XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (Start_End)
        //Bug_VR9_US_3M5M_All_CreatingTxImages (Start_End)
      //PERF_US_T1413_T1&CNXT_64ptIFFT (START - END)
        else if (((gft_TxImages ==1) && (OPTNArray[OPTN_TXPathControl] & 0x01) == 0) ||
      (gft_IFFT64_T1413_TxImages == 1))
      {
         int i,j;
         int16 s_fftlen, ntones, ntones2;

         ntones = gs_TxNumTones;
         ntones2 = ntones*2;
         s_fftlen = gs_TxFftLength_Oversample;

         for (i=0 ; i<ntones ; i++)
         {
            gsa_TxTimeBuf[2*i] = gsa_TxToneBuf[2*i];
            gsa_TxTimeBuf[2*i+1] = gsa_TxToneBuf[2*i+1];
         }
// XDSLRTFW-577 IOP_US_AnxMPlus_Cnxt_UsPerf(START)
         gsa_TxTimeBuf[2*ntones] = gsa_TxToneBuf[2*i+1];
         gsa_TxTimeBuf[2*ntones+1] = 0; //NyQuist
// XDSLRTFW-577 IOP_US_AnxMPlus_Cnxt_UsPerf(End)
#ifndef ISDN
         //XDSLRTFW-819: BugFix_DS_DMT_CNXT_Improve_DS_Performance_In_BTLoops (Start)
         // s_ImageScaleFactor = 1; //XDSLRTFW-1371/XDSLRTFW-1416 BugFix_US_ALL_ALL_ScaleDownTxImageWithRightShift (Start_End)
         if((gs_CurrentCoChipset == GSI_CO_CHIPSET) && (gl_SelectedMode & MODE_G992_1) && (gs_EstimatedLoopLength > 15000))
         {
            //T1413 mode: Scale down US Tx images in Loops > 15Kft (to reduce effect of Echo) to improve DS data rates.
            s_ImageScaleFactor = 1; //XDSLRTFW-1371/XDSLRTFW-1416 BugFix_US_ALL_ALL_ScaleDownTxImageWithRightShift (Start_End)
         }
#endif
         //Prepare for the conjugate signals
            //Bug_VR9_US_All_All_FixNyquistBin
         for (i=ntones+1 ; i<ntones2 ; i++)
         {
#ifndef ISDN
            //XDSLRTFW-1371/XDSLRTFW-1416 BugFix_US_ALL_ALL_ScaleDownTxImageWithRightShift (Start)
            gsa_TxTimeBuf[2*i] = (gsa_TxTimeBuf[2*(ntones2-i)])>>s_ImageScaleFactor;
            gsa_TxTimeBuf[2*i+1] = (-gsa_TxTimeBuf[2*(ntones2-i)+1])>>s_ImageScaleFactor;
            //XDSLRTFW-1371/XDSLRTFW-1416 BugFix_US_ALL_ALL_ScaleDownTxImageWithRightShift (End)
#else
            gsa_TxTimeBuf[2*i] = gsa_TxTimeBuf[2*(ntones2-i)];
            gsa_TxTimeBuf[2*i+1] = -gsa_TxTimeBuf[2*(ntones2-i)+1];

#endif
         }

// XDSLRTFW-577 IOP_US_AnxMPlus_Cnxt_UsPerf(START)
#if 1   //Amara: TBD is it really required doing mirroring, i.e. annexB: 0 to 127 tones gain is repeated 129 to 255bins
#ifndef ISDN
         if ((gs_CurrentCoChipset == GSI_CO_CHIPSET) &&
             ((gl_SelectedMode & (MODE_G992_5|ANNEX_M)) ||
              ((gl_SelectedMode & MODE_G992_1) && (gs_EstimatedLoopLength > 15000))))
         //XDSLRTFW-819: BugFix_DS_DMT_CNXT_Improve_DS_Performance_In_BTLoops (End)
#else
         if ((gs_CurrentCoChipset == GSI_CO_CHIPSET) &&
            (gl_SelectedMode & (MODE_G992_5|ANNEX_M)))

#endif

         {
            //prepare for the images at gs_TxFftLength*2 for cnxt only send single image
            for (i=ntones2,j=0 ; i < (s_fftlen>>1) ; i++,j++)
            {
               gsa_TxTimeBuf[2*i] = 0;
               gsa_TxTimeBuf[2*i+1] = 0;
            }
         }
         else
         {
            //prepare for the images at gs_TxFftLength*2
            for (i=ntones2,j=0 ; i < (s_fftlen>>1) ; i++,j++)
            {
               gsa_TxTimeBuf[2*i] = gsa_TxTimeBuf[2*j];
               gsa_TxTimeBuf[2*i+1] = gsa_TxTimeBuf[2*j+1];
            }
         }
#else
            //prepare for the images at gs_TxFftLength*2 for cnxt only send single image
            for (i=ntones2,j=0 ; i < (s_fftlen>>1) ; i++,j++)
            {
               gsa_TxTimeBuf[2*i] = 0;
               gsa_TxTimeBuf[2*i+1] = 0;
            }

#endif
// XDSLRTFW-577 IOP_US_AnxMPlus_Cnxt_UsPerf(End)
         LoadTxOutBuffer(gsa_TxTimeBuf, s_fftlen);
      }
      else
         LoadTxOutBuffer(gsa_TxToneBuf, gs_TxFftLength);


#else // #ifdef ADSL_62
      LoadTxOutBuffer(gsa_TxToneBuf, gs_TxFftLength);

#endif // ADSL_62




#ifdef PROFILE_TONE
      if (gt_debugTrailTriggerControl.ft_StateTrigger)
      {
         if (gt_debugTrailTriggerControl.s_logType & DEBUG_LOG_TXTONECAPTURE)
         {
            // If space for one more data collection set:

            if ( (gt_debugTrailCollectControl.s_debugTrailLen + 2*gt_debugTrailTriggerControl.s_numTones) <= gt_debugTrailCollectControl.s_debugTrailSize)
            {
               memcpy(&gsa_StatesTrail[gt_debugTrailCollectControl.s_debugTrailLen],  &gsa_TxToneBuf[2*gt_debugTrailTriggerControl.s_toneIndex], sizeof(int16)*(2*gt_debugTrailTriggerControl.s_numTones));
               gt_debugTrailCollectControl.s_debugTrailLen += 2*gt_debugTrailTriggerControl.s_numTones ;
            }
         }
         else if ((gt_debugTrailTriggerControl.s_logType & DEBUG_LOG_4BITMASK) == DEBUG_FREEZE_STATE)
         {
            // Negative argument to Pause() is used so that DFE will be disabled.
            Pause(-2);
         }
      }
#endif

      /* ======================================================================== */
      /* If gft_IFFT_On is TRUE, then the IFFT is used to modulate frequency     */
      /* domain data into a time domain waveform.  If not, the IFFT buffer       */
      /* is assumed to already contain the time domain waveform and the IFFT     */
      /* is not performed.                                        */
      /* ======================================================================== */
#ifndef ADSL_62
      if (gft_IFFT_On == TRUE) {
         Trigger_IFFT();
      }
#endif
   }
#ifdef TX_NOISESHAPER_RESET
   if ( gc_afeResetDelayCnt > 0 )
   { gc_afeResetDelayCnt--;
   if ( gc_afeResetDelayCnt == 0 )
            WriteAfe(DANUBEA_SOFT_RESETS, 0x0008);
   }
#endif
   /* ======================================================================== */
   /* Check the overflow information from Iridia, Strymon registers            */
   /* ======================================================================== */

   ReadAndClearHWOverflow(&gus_IRI_Tx_Ovflw, &gus_IRI_Rx_Ovflw, &gus_STR_Ovflw);

   delay( jgIfftDelay );
#ifdef PROFILE_TASKS
   LogMips(TX_TC_FS, TC_NTC_END_FLAG);
#endif

}


/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void RxProcessTones(void);
*
*   Description:
*
*  Time-critical task associated with Rx Frame.  This task is assigned
*  to the Rx Frame interrupt when frequency domain data is to be processed
*  (e.g. SNR calculation)
*
*  Arguments:
*     none
*
*  Global Variables:
*     gp_RxLoadingFunction -- (I) point to a function Fifo to implement
*                       frame specific processing (e.g. InsertRxCP,
*                       LoadTDQ)
*     gft_EnablePLL        -- (I) set to TRUE to enable PLL
*                       It is set in the state
*                       machine.
*
*-------------------------------------------------------------------
*^^^
*/

/* GRxProcessTones is the time critical task to be run at R3 */
/* The state transition part of this code will be moved into non-time critical task
when the loop attenuation code is removed from the GetRxTones function */

void RxProcessTones()
{
      int32 l_temp1, l_temp2;

#ifdef PROFILE_TASKS
   LogMips(RX_TC_FDQ, TC_NTC_START_FLAG);
#endif

   /* ===========================================================================   */
   /* The RxLoading functions are used to modify the engine. It can be used for  */
   /* cyclic prefix insertion, loading equalizer taps, etc                    */
   /* ===========================================================================   */

   /* If there are pending loading functions, then run them */

   if(gft_RxFdqDoneIntOnly == TRUE)
      ExecuteQueuedLoadingFunctions(gp_RxLoadingFunctionFifo);
   else
      gft_RxFdqDoneIntOnly = TRUE;

   /* ===========================================================================   */
   /* The following function GetRxTone is called after the tranceiver training      */
   /* is completed or during the showtime. This functions takes               */
   /* s_RxInBuf[] as its input and applies EC, TDQ, FFT, FDQ etc. to obtain      */
   /* the DMT tones stored in s_RxToneBuf[]. Data in s_RxInBuf[] are unchanged.  */
   /* ===========================================================================   */

   if(gft_DisableGetRxTones==FALSE)  /* FDQ_DONE interrupt only */
      GetRxTones(gsa_RxToneBuf, 0, gs_RxNumTones); /* Capture FFT Buffer */

#ifdef FD_ACCUM_FOR_FRAMEALIGN
    /* =========================================================================== */
   /*  The gft_EnablePLL flag will be set by the state machine.                   */
   /* =========================================================================== */
   if (gft_fw_pilot_fdq)
      CopyPilotTone(gsa_RxPilotTone, gs_PilotToneIdx);
#endif //FD_ACCUM_FOR_FRAMEALIGN


#ifdef PROFILE_TONE
   if ((gt_debugTrailTriggerControl.ft_StateTrigger) && (gt_debugTrailTriggerControl.s_logType & DEBUG_LOG_RXTONECAPTURE)) {

      // If space for one more data collection set:
      if ( (gt_debugTrailCollectControl.s_debugTrailLen + 2*gt_debugTrailTriggerControl.s_numTones)
                                                                  <= gt_debugTrailCollectControl.s_debugTrailSize)
      {
         FlagT ft_CopyRxBuffer_save;
         ft_CopyRxBuffer_save = gft_CopyRxBuffer ;
         gft_CopyRxBuffer = TRUE ;
         GetRxTones(&gsa_StatesTrail[gt_debugTrailCollectControl.s_debugTrailLen],
                  gt_debugTrailTriggerControl.s_toneIndex,
                  gt_debugTrailTriggerControl.s_numTones) ;
         gt_debugTrailCollectControl.s_debugTrailLen += 2*gt_debugTrailTriggerControl.s_numTones ;
         if (gt_debugTrailTriggerControl.s_cyclicTrailUpdate &&
            (gt_debugTrailCollectControl.s_debugTrailLen + 2*gt_debugTrailTriggerControl.s_numTones) > gt_debugTrailCollectControl.s_debugTrailSize)
         {
            gt_debugTrailCollectControl.s_debugTrailLen = 0;
         }
         gft_CopyRxBuffer = ft_CopyRxBuffer_save ;
      }
   }
#endif

#ifdef USE_ENGINE_FOR_BG_FFTS
   if(gft_GetEngineFFTOutput == TRUE)
   {
      GetEngineFFTResult();
      gft_GetEngineFFTOutput = FALSE;
      gft_GetEngineFFTOutputDone = TRUE;
   }
#endif

   /* =========================================================================== */
   /*  The gft_EnablePLL flag will be set by the state machine.                   */
   /* =========================================================================== */
#ifdef FD_ACCUM_FOR_FRAMEALIGN
   if (!gft_fw_pilot_fdq)
#endif  //FD_ACCUM_FOR_FRAMEALIGN
   CopyTone(gsa_RxPilotTone, gs_PilotToneIdx);


   if (gft_EnablePLL)
   {
      /* DD pilot ON */
      if (gft_DDPilot == DD_PILOT_ON)
      {
         ConvertDataToPllRef(gsa_RxPilotTone);
      }

      MULS16(l_temp1, gsa_RxPilotTone[0],gsa_RxPilotTone[0]);
      MULS16(l_temp2, gsa_RxPilotTone[1],gsa_RxPilotTone[1]);
      l_temp1 += l_temp2;
      gft_PilotPowerOK = (l_temp1 > gl_PilotTone_PwrThresh) ? 1: 0;


      PLL(gsa_RxPilotTone);
      UpdateTimingRecoveryHW(gl_pll_loopfilter_out);

#ifdef PROFILE_PHASEERR
      LogPhaseError();
#endif
   }
   else
   {
      UpdateTimingRecoveryHW(gl_pll_freq_offset);
   }

#ifdef DEBUG_STREAMING
   // XDSLRTFW-3004 : Debug stream symbol counter is a factor 2 to high for cascaded mode (start_end)
   // only execute when debug streams are enabled
   if(gt_debugStreamControl.Parameter0 & CMV_INFO115_CONTROL_MASK)
   {
      DSH_FgService();
   }
   else
   {
      //Set VersionInfoStreamed to FALSE, so Version Info gets streamed again next time streams get enabled again
      guc_DSH_VersionInfoStreamed = FALSE;
   }
#endif

#ifdef PROFILE_TASKS
   LogMips(RX_TC_FDQ, TC_NTC_END_FLAG);
#endif

}

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void RxProcessTime(void);
*
*   Description:
*
*  Time-critical task associated with Rx Frame.  This task is assigned
*  to the Rx Frame interrupt when time domain data is to be processed
*  (e.g. TDQ training)
*
*  Arguments:
*     none
*
*  Global Variables:
*     gp_RxLoadingFunctionFifo   -- (I) point to a function Fifo to implement
*                       frame specific processing (e.g. InsertRxCP,
*                       LoadTDQ)
*     gft_EnablePLL        -- (I) set to TRUE to enable PLL
*                       It is set in the state
*                       machine.
*
*-------------------------------------------------------------------
*^^^
*/
#ifndef FD_ACCUM_FOR_FRAMEALIGN
void RxProcessTime()
{

     int32 l_temp1, l_temp2;

#ifdef PROFILE_TASKS
   LogMips(RX_TC_FS, TC_NTC_START_FLAG);
#endif
#ifdef ADSL_62
   /* =========================================================================== */
   /*  The gft_EnablePLL flag will be set by the state machine.                   */
   /* =========================================================================== */
   CopyPilotTone(gsa_RxPilotTone, gs_PilotToneIdx);

   if (gft_EnablePLL)
   {
      /* DD pilot ON */
      if (gft_DDPilot == DD_PILOT_ON)
      {
         ConvertDataToPllRef(gsa_RxPilotTone);
      }

      MULS16(l_temp1, gsa_RxPilotTone[0],gsa_RxPilotTone[0]);
      MULS16(l_temp2, gsa_RxPilotTone[1],gsa_RxPilotTone[1]);
      l_temp1 += l_temp2;
      gft_PilotPowerOK = (l_temp1 > gl_PilotTone_PwrThresh) ? 1: 0;


      PLL(gsa_RxPilotTone);
      UpdateTimingRecoveryHW(gl_pll_loopfilter_out);

#ifdef PROFILE_PHASEERR
      LogPhaseError();
#endif
   }
   else {
      UpdateTimingRecoveryHW(gl_pll_freq_offset);
   }

#endif
   // this flag is set before the loading function execution
   // so that it can be overwritten inside a loading function
   gft_RxFdqDoneIntOnly = FALSE;

   /* ===========================================================================   */
   /* The RxLoading functions are used to modify the engine. It can be used for  */
   /* cyclic prefix insertion, loading equalizer taps, etc                    */
   /* ===========================================================================   */

   /* If there are pending loading functions, then run them */

   ExecuteQueuedLoadingFunctions(gp_RxLoadingFunctionFifo);

   /* =================2==========================================================  */
   /* The following function GetRxTime is called whenver Time Domain Data is     */
   /* needed                                                      */
   /* ===========================================================================   */

   Disable_FFT_Reordering();
   GetRxTime(gsa_RxToneBuf, gs_RxSamplesPerFrame); /* Capture Time-Domain Buffer */
#ifdef ISI_ANALYSIS_ON
   if (gft_ISIanalysis == TRUE) {
      GetRxCP();
   }
#endif
   Enable_FFT_Reordering();

#ifdef USE_ENGINE_FOR_BG_FFTS
   if(gft_LoadEngineFFTInput)
   {
      gft_LoadEngineFFTInput = FALSE;
      gft_GetEngineFFTOutput = TRUE;
      Disable_FFT_Reordering();   /* copy linear input data for doing FFT */
      LoadEngineFFTInput();
      Enable_FFT_Reordering();
   }
#endif

   Trigger_EngineFFT();
#ifdef ADSL_62
    //Set FFT Buffer Swap Started
    if(gft_RxFdqDoneIntOnly == TRUE)
      ResetManualFFT();
#endif

#ifdef PROFILE_TASKS
   LogMips(RX_TC_FS, TC_NTC_END_FLAG);
#endif


}
#endif //FD_ACCUM_FOR_FRAMEALIGN

#ifdef ADSL_62
void RxIdleTC(void)
{
    ExecuteQueuedLoadingFunctions(gp_RxLoadingFunctionFifo);
}

void TxIdleTC(void)
{
    ExecuteQueuedLoadingFunctions(gp_TxLoadingFunctionFifo);
}
#endif
