/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   trailend.c
*
*  This file contains functions for printing info to the trail log file
*  only after completion of execution.
*  The file 'trail.c' contains functions used to open and update the log file during
*  execution.
*
*-------------------------------------------------------------------------
*/

// ******************************************************************
//  trailend.c
//
// History
//
// 01/06/2012 Shakil: Merge all FT EMC fixes from ARx platform to VR9. Important changes are
//             --> 512 point QLN implemmentation for PLUS mode only because in VR9 platform Rx Strymon IIR runs in 2.2Mhz
//                in BIS/DMT mode and in 4.4Mhz in PLUS mode
//             --> Remove all Rx bypass filters with unity pass
//             --> Since in BIS/DMT mode Rx IIR runs in half of the frequency as in ARx platform modify the detection of
//                RFI notch filter (double the input RFI frequency) only in BIS/DMT mode
//             --> Added CMV control to enable/disable the RFI notching and enabled by default.
//                INFO 103 28 bitmask 0x100-> 0 Enabled(default), 1(disabled)
//             --> Remove the code for VR9 where we reset the noisy pilot flag if more than 17 frames are disturbed at
//                every 40 frames. This reduces the possibility of a bad DEC update for long impulse burst.
//             --> Improve detection of corrupted Sync Symbol by adding the noisy pilot flag as well in the condition
//             --> Merge the change from ARx platform where we update the DEC coeffs if the Average margin is more than 3dB
//    Grep for: XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES
//
// ******************************************************************


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "typedef.h"
#include "common.h"
#include "gdata.h"
#include "gdata_dmt.h"
#include "ghs.h"
#include "hndshk_Data.h"
#include "exchdata.h"
#include "const.h"
#include "mp.h"
#include "cmv.h"
#include "tdq_init.h"
#include "ec_data.h"
#include "rinfotbl.h"
#include "trail.h"
#include "trailfileio_defs.h"
#include "gdata_bis.h"
#include "snr.h"
#include "DecTrain_Data.h"
#include "memcopy.h"
#include "trailfileio_defs.h"
#include "trailphaserr.h"
#include "bitload.h"
#include "math.h"
#include "rcmedley_Data.h"
#include "decimalgain.h"
#include "gdata_bis_diag.h"
#include "dsp_op.h"
#include "diagparam_bis.h"


/* =============================================== */
/* Local functions                           */
/* =============================================== */
void PrintFinalFDQ(void);
void PrintFinal_DS_BAT(void);
void PrintFinal_DS_FineGains(void);
void PrintFinal_US_BAT(void);
void PrintFinal_US_FineGains(void);
void PrintPGAInfo(void);

/* =============================================== */
/* global variable declarations */
/* =============================================== */


extern int32 gl_Total_TX_symbols;                  /*  total number of TX symbols */
extern int32 gl_Total_RX_symbols;                  /*  total number of RX symbols */
//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start_End): Increase QLN points to 512
//extern uint8 guca_QLN[RX_NUM_TONES>>1];
extern uint8 guca_QLN[RX_NUM_TONES];
extern int16 gs_TdqCtbk;

#ifdef LEAVE_TRAIL

FlagT gft_FDQ_PrintedToTrail;
FlagT gft_DS_BAT_PrintedToTrail;
FlagT gft_DS_FineGains_PrintedToTrail;
FlagT gft_US_BAT_PrintedToTrail;
FlagT gft_US_FineGains_PrintedToTrail;
FlagT gft_USDS_Payloads_PrintedToTrail;

char *BearerChannelNames[7];


#endif /*  LEAVE_TRAIL */

extern void PrnOtherResults(void);
extern void PrnConfigParams_DMT(void);
extern void PrnConfigParams_BIS(void);
extern void PrnConfigParamsLite(void);
extern void PrnShowTimeResults(void);
extern void PrnOvflwTrainResults_DMT(void);
extern void PrnOvflwShowtimeResults_DMT(void);

/* =============================================== */
/* static function prototypes */
/* =============================================== */
void PrintInfoField( TRAILFILE trail_fid, InfoField_t * t_Info );

/*****************************************************************************
;  Prototype: void PrnResults(void)
;
;  Description:
;      Prints results to files.
;
;  Arguments: none
;
;  Returns: none
;
;  Global Variables: none
;
;****************************************************************************/
void PrnResults(void)
{
   /* ========================================================================== */
   /* Write various results to trail file for debug and information purpose */
   /* ========================================================================== */

    /*  total symbol counts have not been updated to include the number of symbols in */
    /*  the current state so need to add current symbol count to total symbol counts */
    gl_Total_TX_symbols += (gl_TxSymbolCount + 1);
    gl_Total_RX_symbols += (gl_RxSymbolCount + 1);

#ifdef LEAVE_TRAIL

   if (gus_ExceptionCode != E_CODE_NO_ERROR) {
      FPRINTF_TO_TRAILFILE(trail_fid, "Combined Exception Code (gus_ExceptionCode) = %d\n", gus_ExceptionCode);
      FPRINTF_TO_TRAILFILE(trail_fid, "Exception Code & 0xff  = %d\n", gus_ExceptionCode & 0xff);
      FPRINTF_TO_TRAILFILE(trail_fid, "Bitload Exception Code = Exception Code & 0x0f00 = %d\n", gus_ExceptionCode & 0x0400);
      FPRINTF_TO_TRAILFILE(trail_fid, "Exception State = %d\n", gus_ExceptionState);
   }

   FPRINTF_TO_TRAILFILE(trail_fid, "\nFinal states:\n");
   FPRINTF_TO_TRAILFILE(trail_fid, "TX: %d \tRX: %d\n", gs_TxState, gs_RxState);
   FPRINTF_TO_TRAILFILE(trail_fid, "Final symbol counts:\n");
   FPRINTF_TO_TRAILFILE(trail_fid, "TX: %ld \tRX: %ld\n\n", gl_TxSymbolCount, gl_RxSymbolCount);
   FPRINTF_TO_TRAILFILE(trail_fid, "Total number of TX symbols: %ld\n", gl_Total_TX_symbols);
   FPRINTF_TO_TRAILFILE(trail_fid, "Total number of RX symbols: %ld\n\n", gl_Total_RX_symbols);

    /* ---- Trail for handshaking ---- */
   if (TESTArray[TEST_InitState] == TEST_GhsInitState)
   {
      FPRINTF_TO_TRAILFILE( trail_fid, "\n# of PGA reductions in Handshake (in steps of 3dB) from initial PGA value:\t %d\n", gus_GhsPgaSetDown);
      FPRINTF_TO_TRAILFILE( trail_fid, "PGA value in Handshake (in dB (Q8.8)):\t 0x%x\n", gs_PGA_required_In_GHS);

        FPRINTF_TO_TRAILFILE( trail_fid, "\n\nStored CL Message from ATU-C:\n" );
        PrintInfoField( trail_fid, &gt_TrailRxInfoSave );
        FPRINTF_TO_TRAILFILE( trail_fid, "\n\n" );

      FPRINTF_TO_TRAILFILE( trail_fid, "\n\nStored CLR Message from ATU-R:\n" );
        PrintInfoField( trail_fid, &gt_TrailTxInfoSave );
        FPRINTF_TO_TRAILFILE( trail_fid, "\n\n" );

      if (gs_MS_source == ATU_R)
         FPRINTF_TO_TRAILFILE( trail_fid, "\n\nMS Message sent by ATU-R:\n" );
      else if (gs_MS_source == ATU_C)
         FPRINTF_TO_TRAILFILE( trail_fid, "\n\nMS Message sent by ATU-C:\n" );

      PrintInfoField( trail_fid, &gt_TrailMSInfo );
      FPRINTF_TO_TRAILFILE( trail_fid, "\n\n" );
    }

   PrnOtherResults();

   if(guc_AecTrainingState == TRAINING_DONE) {

      if (OPTNArray[OPTN_AlgControl] & OPTN_AECDnldDisable)
         FPRINTF_TO_TRAILFILE(trail_fid, "AEC download disabled\n");
      else
         FPRINTF_TO_TRAILFILE(trail_fid, "AEC download enabled\n");

      FPRINTF_TO_TRAILFILE(trail_fid, "AEC coefficients\n");
      for(s_count=0; s_count<AEC_ORDER; s_count++)
         FPRINTF_TO_TRAILFILE(trail_fid, "gsa_aec_h[%d] = %d\n", s_count, gsa_pre_aec_h[s_count]);
      FPRINTF_TO_TRAILFILE(trail_fid, "gs_aec_h_exp = %d\n\n", gs_pre_aec_h_exp);
      FPRINTF_TO_TRAILFILE(trail_fid, "gs_aec_h_delay = %d\n\n", gs_pre_aec_h_delay);
   }

   if (gft_DecimatorPhaseSelectDone == TRUE)
   {
      FPRINTF_TO_TRAILFILE(trail_fid, "gs_DecimatorPhaseIdx = %d\n\n", gs_DecimatorPhaseIdx);
   }

   if(guc_TdqTrainingState == TRAINING_DONE)
   {
      FPRINTF_TO_TRAILFILE(trail_fid, "TDQ coefficients\n");
      for (s_count=0; s_count<gs_TDQLen; s_count++)
         FPRINTF_TO_TRAILFILE(trail_fid, "gsa_tdq_h[%d]: %d\n", s_count, gsa_pre_tdq_h[s_count]);
      FPRINTF_TO_TRAILFILE(trail_fid, "gs_tdq_h_exp = %d\n\n", gs_pre_tdq_h_exp);
      FPRINTF_TO_TRAILFILE(trail_fid, "Tdq Scaling Cutback (in dB) = %d\n\n", gs_TdqCtbk);
      FPRINTF_TO_TRAILFILE(trail_fid, "TdqDnldDisable(1=yes, 0=no) = %d\n\n", (OPTNArray[OPTN_AlgControl] & OPTN_TDQDnldDisable));

      /* print all TDQs and capacities if necessary */
      if(((OPTNArray[OPTN_AlgControl] & OPTN_MedleyTdqEnable) != 0) ||
         ((OPTNArray[OPTN_AlgControl] & OPTN_MedleyTdqOffEnable) != 0))
      {
         for(s_count=0;s_count<gs_NumMultiTdq;s_count++)
         {
            FPRINTF_TO_TRAILFILE(trail_fid, "TDQ %d (coefficients):", s_count);
            for(i=0;i<gs_TDQLen;i++)
               FPRINTF_TO_TRAILFILE(trail_fid, " %d", gsa_MultiTdqTaps[s_count*gs_TDQLen+i]);
            FPRINTF_TO_TRAILFILE(trail_fid, "\nTDQ %d (exponent): %d\n", s_count, gsa_MultiTdqExp[s_count]);
         }

         for(s_count=0;s_count<=gs_last_tdq_idx;s_count++)
         {
            FPRINTF_TO_TRAILFILE(trail_fid, "gsa_MultiTdqCapacity[%d]:", s_count);
            for(i=0;i<POSTSYNCH_SEARCH_OFFSET*2+1;i++)
               FPRINTF_TO_TRAILFILE(trail_fid, " %d", gsa_MultiTdqCapacity[s_count][i]);
            FPRINTF_TO_TRAILFILE(trail_fid, "\n");
         }
         FPRINTF_TO_TRAILFILE(trail_fid, "\n");
      }
   }

   if(guc_EcTrainingState == TRAINING_DONE)
   {
      int16 s_Log2PowerScale;
      int32 l_AvgReverbPowerPerSample;
      int16 gs_EchoPowerDB, gs_ReverbPowerDB;
      //
      //
      // Calculating Echo Power relative to nominal Reverb power.
      //----------------------------------------------------------
      //
      // The echo power is measured during the R-ECT state, prior to turning on the DEC (and after any analog echo
      // canceller training).  Therefore it gives no
      // information about DEC performance.  It only indicates the strength of the echo that the DEC will attempt to
      // cancel.
      //
      // Echo signal sum of squares is measured in the time domain, so for easy comparison Reverb sum of squares
      // should be calculated in the time domain as well.
      // The expected frequency domain sum of squares of the Reverb received during RCReverb2, after loading of TDQ
      //  and FDQ filters, is:
      //
      //    Reverb2 Freq. domain sum of squares = DEC_QPSK_GAIN*DEC_QPSK_GAIN*(gs_RxLastChannel-gs_RxFirstChannel)
      //
      // where DEC_QPSK_GAIN is currently 8192.
      // To get the corresponding sum of squares in the time domain, i.e. prior to the FFT, scale by:
      //    PowerScale = (2^RxLog2FftScaling )/sqrt(2^k)
      // where k is the number of stages of FFT (always 8), and RxLog2FftScaling is an existing variable that is set
      // to the # of optional stage scalebacks in effect (there are 9 optional scalebacks including the post-processing
      // stage).
      //
      // For example, if RxLog2FftScaling=5, then PowerScale= (2^5)/sqrt(2^8) = 2,  i.e the time domain sum of squares
      // will be twice the frequency domain sum of squares.  Since PowerScale is always a power of 2, implement the
      // scaling using a leftshift by log2(PowerScale).
      //
        s_Log2PowerScale= gs_RxLog2FftScaling - (gs_RxLog2NumTones>>1);

      // To avoid overflow, divide Reverb power by number of time domain samples to get average square of time domain sample
      // value.
      l_AvgReverbPowerPerSample= (DEC_QPSK_GAIN*DEC_QPSK_GAIN>>(gs_Log2RxSamplesPerFrame-s_Log2PowerScale) )*(gs_RxLastChannel-gs_RxFirstChannel);

      gs_EchoPowerDB = ConvertToDB(gl_AvgEchoPowerPerSample);  // gl_EchoPowerPerSample is the average echo power per time domain sample.
      gs_ReverbPowerDB = ConvertToDB(l_AvgReverbPowerPerSample);
      FPRINTF_TO_TRAILFILE(trail_fid, "DEC Training:\n");
      FPRINTF_TO_TRAILFILE(trail_fid, "Ratio of Rx echo power (all tones) to Rx Reverb power (FirstChannel:LastChannel) prior to turning on DEC = %d dB\n", (gs_EchoPowerDB - gs_ReverbPowerDB) >> 8);

      FPRINTF_TO_TRAILFILE(trail_fid, "DEC coefficients\n");
      for(s_count=0; s_count<gs_DEC_ORDER; s_count++)
         FPRINTF_TO_TRAILFILE(trail_fid, "gsa_dec_h[%d] = %d\n", s_count, gsa_pre_dec_h[s_count]);
      FPRINTF_TO_TRAILFILE(trail_fid, "gs_dec_h_exp = %d\n\n", gs_pre_dec_h_exp);
      FPRINTF_TO_TRAILFILE(trail_fid, "gs_dec_h_delay = %d\n\n", gs_pre_dec_h_delay);


   }


   if(guc_AlignmentTrainingState == TRAINING_DONE) {
         FPRINTF_TO_TRAILFILE(trail_fid, "\nReverb2 Frame Alignment:\n");
         FPRINTF_TO_TRAILFILE(trail_fid, "Correlation Peak Method  = %d\n", gus_SyncOffset_Corr_Method);
         FPRINTF_TO_TRAILFILE(trail_fid, "Max Window Energy Method = %d\n\n", gus_SyncOffset);
   }


   if(guc_FdqTrainingState == TRAINING_DONE)
   {
      if (gft_FDQ_PrintedToTrail == 0) {
         // Print FDQ coefficients if they weren't already printed.
         PrintFinalFDQ();
      }

      if(gft_ModemType == G_DMT)
      {
   #ifdef CALC_REVERB_SNR
         /* If != FAST_RETRAIN */
         if (TESTArray[TEST_InitState] != TEST_RetrainInitState)
         {
            FPRINTF_TO_TRAILFILE(trail_fid, "\nR_C_REVERB2: SNR in dB\n");
            for(s_count=0; s_count<gs_RxNumTones; s_count++)
               FPRINTF_TO_TRAILFILE(trail_fid, "gsa_Reverb2SnrBuf[%d] = %d\n", s_count, (gsa_ReverbSnrBuf[s_count]>>8));
         }
   #endif /*  CALC_REVERB_SNR */

   #ifdef CALC_REVERB_ECHO_SNR
         /* If != RETRAIN/XTRAIN */
         if (TESTArray[TEST_InitState] != TEST_RetrainInitState)
         {
            FPRINTF_TO_TRAILFILE(trail_fid, "\nR_C_REVERB3: SNR in dB\n");
            for(s_count=0; s_count<gs_RxNumTones; s_count++)
               FPRINTF_TO_TRAILFILE(trail_fid, "gsa_Reverb3SnrBuf[%d] = %d\n", s_count, (gsa_ReverbEchoSnrBuf[s_count]>>8));
         }
   #endif /*  CALC_REVERB_ECHO_SNR */
      }
      else if (gft_ModemType == G_DMT_BIS)
      {
   #ifdef CALC_REVERB_SNR
         FPRINTF_TO_TRAILFILE(trail_fid, "\nR_C_REVERB3: SNR in dB\n");
         for(s_count=0; s_count<gs_RxNumTones; s_count++)
            FPRINTF_TO_TRAILFILE(trail_fid, "gsa_Reverb3SnrBuf_bis[%d] = %d\n", s_count, (gsa_ReverbSnrBuf[s_count]>>8));

   #endif /*  CALC_REVERB_SNR */

   #ifdef CALC_REVERB_ECHO_SNR
         FPRINTF_TO_TRAILFILE(trail_fid, "\nR_C_REVERB4: SNR in dB\n");
         for(s_count=0; s_count<gs_RxNumTones; s_count++)
            FPRINTF_TO_TRAILFILE(trail_fid, "gsa_Reverb4SnrBuf_bis[%d] = %d\n", s_count, (gsa_ReverbEchoSnrBuf[s_count]>>8));

   #endif /*  CALC_REVERB_ECHO_SNR */

      }

      /* If != RETRAIN/XTRAIN */
      if (TESTArray[TEST_InitState] != TEST_RetrainInitState)
      {
         FPRINTF_TO_TRAILFILE(trail_fid, "\nR_C_MEDLEY: SNR in dB\n");
         for(s_count=0; s_count<gs_RxNumTones; s_count++)
            FPRINTF_TO_TRAILFILE(trail_fid, "gsa_MedleySnrBuf[%d] = %d\n", s_count, (gsa_MedleySnrBuf[s_count]>>8));

         PrintPhaseErrLog();

         // For Bis, print SUPPORTED, MEDLEY and Blackout sets.
         if(( gl_SelectedMode & (MODE_ADSL2)  ))
         {
            uint32 *pl_ptr;

            FPRINTF_TO_TRAILFILE(trail_fid, "\n These sets are one bit/tone.  Rightmost bits in each 32-bit value are tones 0, 32, 64, etc.\n");

            FPRINTF_TO_TRAILFILE(trail_fid, "\nSUPPORTED set US: \n");
            pl_ptr = (uint32 *) &gp_SUPPORTEDset_US;
            for (i=0 ;i<TX_NUM_TONES/32 ; i++)
               FPRINTF_TO_TRAILFILE(trail_fid, "%08x\n", pl_ptr[i]);
            FPRINTF_TO_TRAILFILE(trail_fid, "\n");

            FPRINTF_TO_TRAILFILE(trail_fid, "\nBLACKOUT set US: \n");
            pl_ptr = (uint32 *) &gp_BlackoutBits_US;
            for (i=0 ;i<TX_NUM_TONES/32 ; i++)
               FPRINTF_TO_TRAILFILE(trail_fid, "%08x\n", pl_ptr[i]);
            FPRINTF_TO_TRAILFILE(trail_fid, "\n");

            FPRINTF_TO_TRAILFILE(trail_fid, "\nMEDLEY set US: \n");
            pl_ptr = (uint32 *) &gp_MEDLEYset_US;
            for (i=0 ;i<TX_NUM_TONES/32 ; i++)
               FPRINTF_TO_TRAILFILE(trail_fid, "%08x\n", pl_ptr[i]);
            FPRINTF_TO_TRAILFILE(trail_fid, "\n");

            FPRINTF_TO_TRAILFILE(trail_fid, "\nSUPPORTED set DS: \n");
            pl_ptr = (uint32 *) &p_SUPPORTEDset_DS;
            for (i=0 ;i<RX_NUM_TONES/32 ; i++)
               FPRINTF_TO_TRAILFILE(trail_fid, "%08x\n", pl_ptr[i]);
            FPRINTF_TO_TRAILFILE(trail_fid, "\n");

            FPRINTF_TO_TRAILFILE(trail_fid, "\nBLACKOUT set DS: \n");
            pl_ptr = (uint32 *) &guca_RMsgPCBTab[4];
            for (i=0 ;i<RX_NUM_TONES/32 ; i++)
               FPRINTF_TO_TRAILFILE(trail_fid, "%08x\n", pl_ptr[i]);
            FPRINTF_TO_TRAILFILE(trail_fid, "\n");

            FPRINTF_TO_TRAILFILE(trail_fid, "\nMEDLEY set DS: \n");
            pl_ptr = (uint32 *) &p_MEDLEYset_DS;
            for (i=0 ;i<RX_NUM_TONES/32 ; i++)
               FPRINTF_TO_TRAILFILE(trail_fid, "%08x\n", pl_ptr[i]);
            FPRINTF_TO_TRAILFILE(trail_fid, "\n");
         }

         FPRINTF_TO_TRAILFILE(trail_fid, "\nBit Loading Information:\n\n");
      }


      /* If != RETRAIN */
      if (TESTArray[TEST_InitState] != TEST_RetrainInitState) {
         FPRINTF_TO_TRAILFILE(trail_fid, "gft_BitloadOK = %d\n", gft_BitloadOK);
         if(gft_ModemType == G_DMT_BIS)
            FPRINTF_TO_TRAILFILE(trail_fid, "Total Bits Supported = %d\n\n", gs_TotalBitsSupported);
         else
            FPRINTF_TO_TRAILFILE(trail_fid, "\n");
      }

      if(gft_BitloadOK == SUCCEED)
      {

         FPRINTF_TO_TRAILFILE(trail_fid, "gft_FineGainOn (0:off 1:on) = %d\n", gft_FineGainOn);
         FPRINTF_TO_TRAILFILE(trail_fid,"Average SNR margin init = %d (dB)\n", (gs_init_AvMargin>>8));
         FPRINTF_TO_TRAILFILE(trail_fid,"Minimum SNR margin init = %d (dB)\n", (gs_init_MinMargin>>8));
         FPRINTF_TO_TRAILFILE(trail_fid,"Average SNR margin = %d (dB)\n", (gs_RxAvMargin>>8));
         FPRINTF_TO_TRAILFILE(trail_fid,"Minimum SNR margin = %d (dB)\n", (gs_RxMinMargin>>8));

         FPRINTF_TO_TRAILFILE(trail_fid,"Average fine gain = %d (in Q.8.8 dB)\n", gs_RxAvFineGain);
         FPRINTF_TO_TRAILFILE(trail_fid,"RMS fine gain = %d (in Q.8.8 dB)\n", gt_TxPMDControl.us_RMSGI_DS );
         FPRINTF_TO_TRAILFILE(trail_fid,"Excess margin reduction = %d (in Q.8.8 dB)\n", gt_FineGainInfo.s_ExcessMarRedDB);



         if (gft_DS_BAT_PrintedToTrail == 0)
            PrintFinal_DS_BAT();

         if (gft_DS_FineGains_PrintedToTrail == 0)
            PrintFinal_DS_FineGains();

         if(gft_ModemType == G_DMT)
         {
            FPRINTF_TO_TRAILFILE(trail_fid, "\nC_RATES1:\n");
            for(s_count = 0; s_count<4; s_count++)
            {
               for(i=0; i<30; i++)
                  FPRINTF_TO_TRAILFILE(trail_fid, "%3d", (uint16)guca_R_C_Rates1[s_count*30+i]);
               FPRINTF_TO_TRAILFILE(trail_fid, "\n");
            }

            FPRINTF_TO_TRAILFILE(trail_fid, "\nC_MSG1:\n");
            FPRINTF_TO_TRAILFILE(trail_fid, "\tMinRequiredSnrMargin = %d (dB)\n", gt_RCMsgs1.us_MinRequiredSnrMargin);
            FPRINTF_TO_TRAILFILE(trail_fid, "\tEC_Option = %d\n", gt_RCMsgs1.us_EC_Option);
            FPRINTF_TO_TRAILFILE(trail_fid, "\tNTR_Option = %d\n", gt_RCMsgs1.us_NTR_Option);
            FPRINTF_TO_TRAILFILE(trail_fid, "\tFrameMode = %d\n", gt_RCMsgs1.us_FrameMode);
            FPRINTF_TO_TRAILFILE(trail_fid, "\tInit. Politeness Power Cutback = %d\n", gt_RCMsgs1.us_PSDLevel);
            FPRINTF_TO_TRAILFILE(trail_fid, "\tMaxBitsPerTone Supported (DS) = %d\n", gt_RCMsgs1.us_MaxBitsPerTone);

            FPRINTF_TO_TRAILFILE(trail_fid, "\nR_RATES1:\n");
            for(s_count = 0; s_count<4; s_count++)
            {
               for(i=0; i<11; i++)
                  FPRINTF_TO_TRAILFILE(trail_fid, "%3d ", (uint16)guca_RRates1Tab[s_count*11+i]);
               FPRINTF_TO_TRAILFILE(trail_fid, "\n");
            }

            FPRINTF_TO_TRAILFILE(trail_fid, "\nR_MSG1:\n");
            FPRINTF_TO_TRAILFILE(trail_fid, "\tEC_Option = %d\n", gt_RMsgs1.us_EC_Option);
            FPRINTF_TO_TRAILFILE(trail_fid, "\tNTR_Option = %d\n", gt_RMsgs1.us_NTR_Option);
            FPRINTF_TO_TRAILFILE(trail_fid, "\tFrameMode = %d\n", gt_RMsgs1.us_FrameMode);
            FPRINTF_TO_TRAILFILE(trail_fid, "\tMaxBitsPerTone Supported (US) = %d\n", gt_RMsgs1.us_MaxBitsPerTone);

            FPRINTF_TO_TRAILFILE(trail_fid, "\nPacked R_MSG1:\n");
            for(i=0; i<6; i++)
               FPRINTF_TO_TRAILFILE(trail_fid, "\tguca_RMsgs1Tab[%d] = 0x%x\n", i, guca_RMsgs1Tab[i]);

            FPRINTF_TO_TRAILFILE(trail_fid, "\nR_MSG_RA:\n");
            FPRINTF_TO_TRAILFILE(trail_fid, "\tNumber of RS check bytes (R) = %d\n", gt_RMsgRA.us_R);
            FPRINTF_TO_TRAILFILE(trail_fid, "\tNumber of RS payload bytes (K) = %d\n", gt_RMsgRA.us_K);
            FPRINTF_TO_TRAILFILE(trail_fid, "\tNumber of tones carrying data = %d\n", gt_RMsgRA.us_ncloaded);
            FPRINTF_TO_TRAILFILE(trail_fid, "\tEstimated Average loop attenuation = %d\n", gt_RMsgRA.us_AvLoopAttenu);
            FPRINTF_TO_TRAILFILE(trail_fid, "\tCoding gain = %d \n", gt_RMsgRA.us_CodingGain);
            FPRINTF_TO_TRAILFILE(trail_fid, "\tPerformance (SNR) margin= %d\n", gt_RMsgRA.us_SnrMargin);
            FPRINTF_TO_TRAILFILE(trail_fid, "\tTotal number of bits per DMT symbol = %d\n", gt_RMsgRA.us_TotalBitsPerSymbol);

            FPRINTF_TO_TRAILFILE(trail_fid, "\nPacked R_MSG_RA:\n");
            for(i=0; i<R_MSG_RA_NUM_BYTES; i++)
               FPRINTF_TO_TRAILFILE(trail_fid, "\tguca_RMsgRATab[%d] = 0x%x\n", i, guca_RMsgRATab[i]);

            FPRINTF_TO_TRAILFILE(trail_fid, "\nR_RATES_RA:\n");
            FPRINTF_TO_TRAILFILE(trail_fid, "\tguc_RRatesRA = 0x%x\n", guc_RRatesRA);

            FPRINTF_TO_TRAILFILE(trail_fid, "\nC_RATES_RA:\n");
            for(s_count = 0; s_count<4; s_count++)
            {
               for(i=0; i<30; i++)
                  FPRINTF_TO_TRAILFILE(trail_fid, "%3d ", (uint16)gsa_RCRatesRA[s_count*30+i]);
               FPRINTF_TO_TRAILFILE(trail_fid, "\n");
            }

            FPRINTF_TO_TRAILFILE(trail_fid, "\nC_MSG_RA:\n");
            FPRINTF_TO_TRAILFILE(trail_fid, "\tNew MinRequiredDSSnrMargin at Initialization = %d (dB)\n", gt_RCMsgRA.us_MinRequiredInitDSSnrMargin);
            FPRINTF_TO_TRAILFILE(trail_fid, "\tMinRequiredDSSnrMargin in steady state = %d (dB)\n", gt_RCMsgRA.us_MinRequiredSSDSSnrMargin);
            FPRINTF_TO_TRAILFILE(trail_fid, "\tMax Allowed DSSnrMargin at init. and in steady state = %d (dB)\n", gt_RCMsgRA.us_MaxDSSnrMargin);


            FPRINTF_TO_TRAILFILE(trail_fid, "\nR_MSG2 (for downstream):\n");
            FPRINTF_TO_TRAILFILE(trail_fid, "\tTotalBitsSupported = %d\n", gt_RMsg2.s_TotalBitsSupported);
            FPRINTF_TO_TRAILFILE(trail_fid, "\tPerformMargin = %d\n", gt_RMsg2.us_PerformMargin);
            FPRINTF_TO_TRAILFILE(trail_fid, "\tAvLoopAttenu = %d\n", gt_RMsg2.us_AvLoopAttenu);

            FPRINTF_TO_TRAILFILE(trail_fid, "\nPacked R_MSG2:\n");

            for(i=0; i<4; i++)
               FPRINTF_TO_TRAILFILE(trail_fid, "\tguca_RMsg2[%d] = 0x%x\n", i, guca_RMsg2[i]);

            FPRINTF_TO_TRAILFILE(trail_fid, "\nR_RATES2\n");
            FPRINTF_TO_TRAILFILE(trail_fid, "\tguc_RRates2 = 0x%x\n", guc_RRates2);

            FPRINTF_TO_TRAILFILE(trail_fid, "\nC_MSG2 (for upstream):\n");
            FPRINTF_TO_TRAILFILE(trail_fid, "\tTotalBitsSupported = %d\n", gt_RCMsg2.s_TotalBitsSupported);
            FPRINTF_TO_TRAILFILE(trail_fid, "\tPerformMargin = %d\n", gt_RCMsg2.us_PerformMargin);

            if ((STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_AB) || (STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_C) )
               FPRINTF_TO_TRAILFILE(trail_fid, "\tErased Stored Profiles = %d\n", gt_RCMsg2.us_EraseStoredProfiles);

            FPRINTF_TO_TRAILFILE(trail_fid, "\tAvLoopAttenu = %d\n", gt_RCMsg2.us_AvLoopAttenu);

            FPRINTF_TO_TRAILFILE(trail_fid, "\nC_RATES2:\n");
            FPRINTF_TO_TRAILFILE(trail_fid, "\tguc_RCRates2 = 0x%x\n", gs_RCRates2);

            FPRINTF_TO_TRAILFILE(trail_fid, "\nC-B&G:\n");
            for(i=1; i<gs_TxNumTones; i++)
               FPRINTF_TO_TRAILFILE(trail_fid, "\tgsa_US_BitAndGain[%d] = 0x%x\n", i, gsa_US_BitAndGain[i-1]);

            FPRINTF_TO_TRAILFILE(trail_fid, "\nR-B&G:\n");
            for(i=1; i<gs_RxNumTones; i++)
               FPRINTF_TO_TRAILFILE(trail_fid, "\tgsa_DS_BitAndGain[%d] = 0x%x\n", i, gpsa_DS_BitAndGain[i]);

         }
         else if(gft_ModemType == G_DMT_BIS)
         {
            /************** C_MSGS_FMT_BIS  ****************/
            FPRINTF_TO_TRAILFILE(trail_fid, "\nC_MSG_FMT_BIS:\n");

         if (gt_RCMsgFmt_bis.us_FMT_R_REVERB1)
            FPRINTF_TO_TRAILFILE(trail_fid, "\tATU-C requests extended duration of R-REVERB1.\n");
         else
            FPRINTF_TO_TRAILFILE(trail_fid, "\tATU-C does not request extended duration of R-REVERB1.\n");

         if (gt_RCMsgFmt_bis.us_FMT_C_REVERB4)
            FPRINTF_TO_TRAILFILE(trail_fid, "\tATU-C requests extended duration of C-REVERB4(1024 frames).\n");
         else
            FPRINTF_TO_TRAILFILE(trail_fid, "\tATU-C does not request extended duration of C-REVERB4(256 frames).\n");

            FPRINTF_TO_TRAILFILE(trail_fid, "\tLength of R_QUIET4 = %d (frames)\n", gt_RCMsgFmt_bis.us_FMT_R_QUIET4*512);

         if (gt_RCMsgFmt_bis.us_FMT_C_MSG_PCB)
            FPRINTF_TO_TRAILFILE(trail_fid, "\tATU-C shall transmit blackout bits.\n");
         else
            FPRINTF_TO_TRAILFILE(trail_fid, "\tATU-C shall not transmit blackout bits.\n");


         /************** C_MSGS_PCB_BIS ********************/
      FPRINTF_TO_TRAILFILE(trail_fid, "\nC_MSG_PCB_BIS:\n");
      FPRINTF_TO_TRAILFILE(trail_fid, "\tMinimum ATU-C DS power cutback = %d (dB)\n", gt_RCMsgPcb_bis.us_C_MIN_PCB_DS);
      FPRINTF_TO_TRAILFILE(trail_fid, "\tMinimum ATU-C US power cutback = %d (dB)\n", gt_RCMsgPcb_bis.us_C_MIN_PCB_US);
      switch (gt_RCMsgPcb_bis.us_HOOK_STATUS)
      {
      case 0:
         FPRINTF_TO_TRAILFILE(trail_fid, "\tHook Status = Unknown\n");
         break;
      case 1:
         FPRINTF_TO_TRAILFILE(trail_fid, "\tHook Status = On-hook\n");
         break;
      case 2:
         FPRINTF_TO_TRAILFILE(trail_fid, "\tHook Status = Off-hook\n");
         break;
      case 3:
         FPRINTF_TO_TRAILFILE(trail_fid, "\tHook Status = Not capable to detect.\n");
         break;
      }


            /************** R_MSGS_FMT_BIS  ****************/
            FPRINTF_TO_TRAILFILE(trail_fid, "\nR_MSG_FMT_BIS:\n");

         if (gt_RMsgFmt_bis.us_FMT_R_REVERB1)
            FPRINTF_TO_TRAILFILE(trail_fid, "\tATU-R requests extended duration of R-REVERB1.\n");
         else
            FPRINTF_TO_TRAILFILE(trail_fid, "\tATU-R does not request extended duration of R-REVERB1.\n");

         if (gt_RMsgFmt_bis.us_FMT_C_REVERB4)
            FPRINTF_TO_TRAILFILE(trail_fid, "\tATU-R requests extended duration of C-REVERB4(1024 frames).\n");
         else
            FPRINTF_TO_TRAILFILE(trail_fid, "\tATU-R does not request extended duration of C-REVERB4(256 frames).\n");

            FPRINTF_TO_TRAILFILE(trail_fid, "\tMinimum C-TREF1 Duration = %d (frames)\n", gt_RMsgFmt_bis.us_FMT_C_TREF1*512);

         if (gt_RMsgFmt_bis.us_FMT_R_MSG_PCB)
            FPRINTF_TO_TRAILFILE(trail_fid, "\tBlackout bits are present in R-MSG-PCB.\n");
         else
            FPRINTF_TO_TRAILFILE(trail_fid, "\tBlackout bits are not present in R-MSG-PCB.\n");

         if (gt_RMsgFmt_bis.us_FMT_C_TREF2)
            FPRINTF_TO_TRAILFILE(trail_fid, "\tATU-R requests ATU-C to transmit C-TREF2 during R-ECT.\n");
         else
            FPRINTF_TO_TRAILFILE(trail_fid, "\tATU-R requests ATU-C to transmit C-QUIET during R-ECT.\n");

         if (gt_RMsgFmt_bis.us_FMT_C_PILOT)
            FPRINTF_TO_TRAILFILE(trail_fid, "\tATU-R requests fixed 4-QAM constellation points in C-TREF.\n");
         else
            FPRINTF_TO_TRAILFILE(trail_fid, "\tATU-R does not request fixed 4-QAM constellation points in C-TREF.\n");



         /************** R_MSGS_PCB_BIS *****************/
         FPRINTF_TO_TRAILFILE(trail_fid, "\nR_MSG_PCB_BIS:\n");
         FPRINTF_TO_TRAILFILE(trail_fid, "\tMinimum ATU-R DS power cutback = %d (dB)\n", gt_RMsgPcb_bis.us_R_MIN_PCB_DS);
         FPRINTF_TO_TRAILFILE(trail_fid, "\tMinimum ATU-R US power cutback = %d (dB)\n", gt_RMsgPcb_bis.us_R_MIN_PCB_US);
         switch (gt_RMsgPcb_bis.us_HOOK_STATUS)
         {
         case 0:
         FPRINTF_TO_TRAILFILE(trail_fid, "\tHook Status = Unknown\n");
         break;
         case 1:
         FPRINTF_TO_TRAILFILE(trail_fid, "\tHook Status = On-hook\n");
         break;
         case 2:
         FPRINTF_TO_TRAILFILE(trail_fid, "\tHook Status = Off-hook\n");
         break;
         case 3:
         FPRINTF_TO_TRAILFILE(trail_fid, "\tHook Status = Not capable to detect.\n");
         break;
         }
         FPRINTF_TO_TRAILFILE(trail_fid, "\tPilotToneIndex = %d\n", gt_RMsgPcb_bis.us_C_PILOT);


            /*****************  C_MSG1_BIS  *****************/
            FPRINTF_TO_TRAILFILE(trail_fid, "\nC_MSG1_BIS:\n");

            FPRINTF_TO_TRAILFILE(trail_fid, "\tTarget Noise Margin (dB) = %5.1f\n", (float)gt_RCMsgs1_bis.us_TARSNRMds/10);
            FPRINTF_TO_TRAILFILE(trail_fid, "\tMinimum Noise Margin (dB) = %5.1f\n", (float)gt_RCMsgs1_bis.us_MINSNRMds/10);
            FPRINTF_TO_TRAILFILE(trail_fid, "\tMaximum Noise Margin (dB) = %5.1f\n", (float)gt_RCMsgs1_bis.us_MAXSNRMds/10);
            FPRINTF_TO_TRAILFILE(trail_fid, "\tRate Adaptation Mode = %d\n", gt_RCMsgs1_bis.us_RA_MODEds);
            FPRINTF_TO_TRAILFILE(trail_fid, "\tPower Management Mode = %d\n", gt_RCMsgs1_bis.us_PM_Mode);
            FPRINTF_TO_TRAILFILE(trail_fid, "\tRate Adaptation Upshift Noise Margin (Q8.8dB) = 0x%x\n", gt_RCMsgs1_bis.us_RA_USNRMds);
            FPRINTF_TO_TRAILFILE(trail_fid, "\tRate Adaptation Upshift Time Interval = %d\n", gt_RCMsgs1_bis.us_RA_UTIMEds);
            FPRINTF_TO_TRAILFILE(trail_fid, "\tRate Adaptation Downshift Noise Margin (Q8.8dB) = 0x%x\n", gt_RCMsgs1_bis.us_RA_DSNRMds);
            FPRINTF_TO_TRAILFILE(trail_fid, "\tRate Adaptation Downshift Time Interval = %d\n", gt_RCMsgs1_bis.us_RA_DTIMEds);
            FPRINTF_TO_TRAILFILE(trail_fid, "\tMaxBitsPerTone Supported (DS) = %d\n", gt_RCMsgs1_bis.us_MaxBitsPerTone);
            FPRINTF_TO_TRAILFILE(trail_fid, "\tmax extension of gi range supported = %d\n", gt_RCMsgs1_bis.us_EXTGIds);
            FPRINTF_TO_TRAILFILE(trail_fid, "\tminimum length of the R_MEDLEY state = %d\n", gt_RCMsgs1_bis.uc_CA_MEDLEYus * 512);


            /*****************  R_MSG1_BIS  *****************/
            FPRINTF_TO_TRAILFILE(trail_fid, "\nR_MSG1_BIS:\n");

            FPRINTF_TO_TRAILFILE(trail_fid, "\tMaxBitsPerTone Supported (US) = %d\n", gt_RMsgs1_bis.us_MaxBitsPerTone);
            FPRINTF_TO_TRAILFILE(trail_fid, "\tmax extension of gi range supported = %d\n", gt_RMsgs1_bis.us_EXTGIus);
            FPRINTF_TO_TRAILFILE(trail_fid, "\tminimum length of the C_MEDLEY state = %d\n", gt_RMsgs1_bis.uc_CA_MEDLEYds * 512);


            FPRINTF_TO_TRAILFILE(trail_fid, "\nPacked R_MSG1_BIS:\n");
            for(i=0; i<R_MSG1_NUM_BYTES_BIS; i++)
               FPRINTF_TO_TRAILFILE(trail_fid, "\tguca_RMsgs1Tab_bis[%d] = 0x%x\n", i, guca_RMsgs1Tab_bis[i]);


         /********** C_MSGS2_BIS **********/
         FPRINTF_TO_TRAILFILE(trail_fid, "\nC_MSGS2_BIS:\n");
         FPRINTF_TO_TRAILFILE(trail_fid, "\n\tPacked C_MSG2_BIS:\n");
         for(i=0; i<(gs_TxNumTones/8); i++)
            FPRINTF_TO_TRAILFILE(trail_fid, "\tguca_R_C_Msgs2_bis[%d] = 0x%x%x\n", i, (guca_R_C_Msgs2_bis[i]&0xF0)>>4, (guca_R_C_Msgs2_bis[i]&0x0F));

         FPRINTF_TO_TRAILFILE(trail_fid, "\n Nonzero tones for modulating R-PARAMS message:\n");
         for (i=0; i< gs_TxNumTones; i++) { // do once for each carrier
            s_ind = (i >> 3);                // index in packed array
            s_bitpos = (i & 0x07);
            ft_usedTone = ((guca_R_C_Msgs2_bis[s_ind] >> s_bitpos) & 0x01);

            if (ft_usedTone)
            FPRINTF_TO_TRAILFILE(trail_fid, "%4d ", i);
         }
         FPRINTF_TO_TRAILFILE(trail_fid, "\n");


   /************ R_MSGS2_BIS ****************/
         FPRINTF_TO_TRAILFILE(trail_fid, "\nR_MSGS2_BIS:\n");
         FPRINTF_TO_TRAILFILE(trail_fid, "\n\tPacked R_MSG2_BIS:\n");
         if (( gl_SelectedMode & (MODE_G992_5)  ))
         {
            for(i=0; i<R_MSG2_NUM_BYTES_PLUS; i++)
               FPRINTF_TO_TRAILFILE(trail_fid, "\tguca_RMsgs2Tab_bis[%d] = 0x%x%x\n", i, (guca_RMsgs2Tab_bis[i]&0xF0)>>4, (guca_RMsgs2Tab_bis[i]&0x0F));
         }
         else
         {
            for(i=0; i<R_MSG2_NUM_BYTES_BIS; i++)
               FPRINTF_TO_TRAILFILE(trail_fid, "\tguca_RMsgs2Tab_bis[%d] = 0x%x%x\n", i, (guca_RMsgs2Tab_bis[i]&0xF0)>>4, (guca_RMsgs2Tab_bis[i]&0x0F));
         }

         FPRINTF_TO_TRAILFILE(trail_fid, "\n Nonzero tones for modulating C-PARAMS message:\n");

         for (i=0; i< gs_RxNumTones; i++) { // do once for each carrier

            s_ind = (i >> 3);                // index in packed array
            s_bitpos = (i & 0x07);
            ft_usedTone = ((guca_RMsgs2Tab_bis[s_ind] >> s_bitpos) & 0x01);

            if (ft_usedTone)
            FPRINTF_TO_TRAILFILE(trail_fid, "%4d ", i);
         }
         FPRINTF_TO_TRAILFILE(trail_fid, "\n");



         } /* if (gft_ModemType == G_DMT_BIS) */


         if (gs_RxNumTones == 128) // Lite Mode
            PrnConfigParamsLite();
         else
         {
            if (gft_ModemType == G_DMT)
               PrnConfigParams_DMT();
         }

      }

   }  /* if(guc_FdqTrainState == TRAINING_DONE) { */

   /************ Received Diagnostic Mode Parameters ****************/
   if((gft_ModemType == G_DMT_BIS) && (guc_msg_ld_idx_ds == 6))
   {
      /************ C_MSG1_LD ****************/
      FPRINTF_TO_TRAILFILE(trail_fid, "\nC_MSG1_LD:\n");
      FPRINTF_TO_TRAILFILE(trail_fid, "\tHlin scale = %d\n", (gpuca_R_C_MSG1_LD[1]<<8)+gpuca_R_C_MSG1_LD[0]);

      s_value = (int16)(gpuca_R_C_MSG1_LD[3]<<8)+gpuca_R_C_MSG1_LD[2];
      if(s_value == OUT_OF_RANGE_LOOPATTENU)
         FPRINTF_TO_TRAILFILE(trail_fid, "\tLATN = OUT OF RANGE\n");
      else
         FPRINTF_TO_TRAILFILE(trail_fid, "\tLATN = %d [dB * 10]\n", s_value);

      s_value = (int16)(gpuca_R_C_MSG1_LD[5]<<8)+gpuca_R_C_MSG1_LD[4];
      if(s_value == OUT_OF_RANGE_SIGNALATTENU)
         FPRINTF_TO_TRAILFILE(trail_fid, "\tSATN = OUT OF RANGE\n");
      else
         FPRINTF_TO_TRAILFILE(trail_fid, "\tSATN = %d [dB * 10]\n", s_value);

      s_value = (int16)(gpuca_R_C_MSG1_LD[7]<<8)+gpuca_R_C_MSG1_LD[6];
      if(s_value == OUT_OF_RANGE_SNRM)
         FPRINTF_TO_TRAILFILE(trail_fid, "\tSNRM = NOT MEASURED\n");
      else
         FPRINTF_TO_TRAILFILE(trail_fid, "\tSNRM = %d [dB * 10]\n", s_value);

      FPRINTF_TO_TRAILFILE(trail_fid, "\tATTNDR = %ld [bit/second]\n", ((int32)gpuca_R_C_MSG1_LD[11]<<24)+(gpuca_R_C_MSG1_LD[10]<<16)
                                       +(gpuca_R_C_MSG1_LD[9]<<8)+gpuca_R_C_MSG1_LD[8]);
      s_value = (int16)(gpuca_R_C_MSG1_LD[13]<<8)+gpuca_R_C_MSG1_LD[12];
      if(s_value == OUT_OF_RANGE_ACTATP)
         FPRINTF_TO_TRAILFILE(trail_fid, "\tFar-end ACTATP = OUT OF RANGE\n");
      else
         FPRINTF_TO_TRAILFILE(trail_fid, "\tFar-end ACTATP = %d [dBm * 10]\n", s_value);

      /************ C_MSG2_LD ****************/
      FPRINTF_TO_TRAILFILE(trail_fid, "\nC_MSG2_LD (Hlin):\n");
      for (i=0; i<gs_TxNumTones; i++) {
         /*real*/
         FPRINTF_TO_TRAILFILE(trail_fid, "Hlin[%d] = %d ", i, (int16)(gpuca_R_C_MSG2_LD[4*i+1]<<8)+gpuca_R_C_MSG2_LD[4*i]);

         /*imag*/
         if((s_value = (gpuca_R_C_MSG2_LD[4*i+3]<<8)) < 0)
            FPRINTF_TO_TRAILFILE(trail_fid, "- j*%d\n", -(s_value + gpuca_R_C_MSG2_LD[4*i+2]));
         else
            FPRINTF_TO_TRAILFILE(trail_fid, "+ j*%d\n", s_value + gpuca_R_C_MSG2_LD[4*i+2]);
      }

      /************ C_MSG3_LD ****************/
      FPRINTF_TO_TRAILFILE(trail_fid, "\nC_MSG3_LD (Hlog):\n");
      for (i=0; i<gs_TxNumTones; i++) {
         FPRINTF_TO_TRAILFILE(trail_fid, "Hlog[%d] = %d\n", i, (int16)((gpuca_R_C_MSG3_LD[2*i+1] & 0x03)<<8)+gpuca_R_C_MSG3_LD[2*i]);
      }

      /************ C_MSG4_LD ****************/
      FPRINTF_TO_TRAILFILE(trail_fid, "\nC_MSG4_LD (Qln):\n");
      for (i=0; i<gs_TxNumTones; i++) {
         FPRINTF_TO_TRAILFILE(trail_fid, "Qln[%d] = %d\n", i, (int16)gpuca_R_C_MSG4_LD[i]);
      }

      /************ C_MSG5_LD ****************/
      FPRINTF_TO_TRAILFILE(trail_fid, "\nC_MSG5_LD (Medley SNR):\n");
      for (i=0; i<gs_TxNumTones; i++) {
         FPRINTF_TO_TRAILFILE(trail_fid, "SNR[%d] = %d\n", i, (int16)gpuca_R_C_MSG5_LD[i]);
      }

      /* Print Transmitted RT DiagMode test-paramters */
      /************ R_MSG1_LD ****************/
      FPRINTF_TO_TRAILFILE(trail_fid, "\nR_MSG1_LD:\n");
      FPRINTF_TO_TRAILFILE(trail_fid, "\tHlin scale = %d\n", (guca_RMSG1_LD[1]<<8)+guca_RMSG1_LD[0]);

      s_value = (int16)(guca_RMSG1_LD[3]<<8)+guca_RMSG1_LD[2];
      if(s_value == OUT_OF_RANGE_LOOPATTENU)
         FPRINTF_TO_TRAILFILE(trail_fid, "\tLATN = OUT OF RANGE\n");
      else
         FPRINTF_TO_TRAILFILE(trail_fid, "\tLATN = %d [dB * 10]\n", s_value);

      s_value = (int16)(guca_RMSG1_LD[5]<<8)+guca_RMSG1_LD[4];
      if(s_value == OUT_OF_RANGE_SIGNALATTENU)
         FPRINTF_TO_TRAILFILE(trail_fid, "\tSATN = OUT OF RANGE\n");
      else
         FPRINTF_TO_TRAILFILE(trail_fid, "\tSATN = %d [dB * 10]\n", s_value);

      s_value = (int16)(guca_RMSG1_LD[7]<<8)+guca_RMSG1_LD[6];
      if(s_value == OUT_OF_RANGE_SNRM)
         FPRINTF_TO_TRAILFILE(trail_fid, "\tSNRM = NOT MEASURED\n");
      else
         FPRINTF_TO_TRAILFILE(trail_fid, "\tSNRM = %d [dB * 10]\n", s_value);

      FPRINTF_TO_TRAILFILE(trail_fid, "\tATTNDR = %ld [bit/second]\n", ((int32)guca_RMSG1_LD[11]<<24)+(guca_RMSG1_LD[10]<<16)
                                       +(guca_RMSG1_LD[9]<<8)+guca_RMSG1_LD[8]);

      s_value = (int16)(guca_RMSG1_LD[13]<<8)+guca_RMSG1_LD[12];
      if(s_value == OUT_OF_RANGE_ACTATP)
         FPRINTF_TO_TRAILFILE(trail_fid, "\tFar-end ACTATP = OUT OF RANGE\n");
      else
         FPRINTF_TO_TRAILFILE(trail_fid, "\tFar-end ACTATP = %d [dBm * 10]\n", s_value);

      /************ R_MSG2_LD to R_MSG5_LD ****************/
      FPRINTF_TO_TRAILFILE(trail_fid, "\nR_MSG2_LD to R_MSG5_LD (Hlin):\n");
      for (i=0; i<gs_RxNumTones; i++)
      {

         /*real*/
         FPRINTF_TO_TRAILFILE(trail_fid, "Hlin[%d] = %d ", i, (int16)(gpuca_RMSG2_LD[4*i+1]<<8)+gpuca_RMSG2_LD[4*i]);

         /*imag*/
         if((s_value = (gpuca_RMSG2_LD[4*i+3]<<8)) < 0)
            FPRINTF_TO_TRAILFILE(trail_fid, "- j*%d\n", -(s_value + gpuca_RMSG2_LD[4*i+2]));
         else
            FPRINTF_TO_TRAILFILE(trail_fid, "+ j*%d\n", s_value + gpuca_RMSG2_LD[4*i+2]);
      }


      /************ R_MSG6_LD to R_MSG7_LD ****************/
      FPRINTF_TO_TRAILFILE(trail_fid, "\nR_MSG6_LD to R_MSG7_LD(Hlog):\n");
      for (i=0; i<256; i++)
         FPRINTF_TO_TRAILFILE(trail_fid, "Hlog[%d] = %d\n", i, (int16)((gpuca_RMSG6_LD[2*i+1] & 0x03)<<8)+gpuca_RMSG6_LD[2*i]);

      /************ R_MSG8_LD ****************/
      FPRINTF_TO_TRAILFILE(trail_fid, "\nR_MSG8_LD (Qln):\n");
      for (i=0; i<gs_RxNumTones; i++)
         FPRINTF_TO_TRAILFILE(trail_fid, "Qln[%d] = %d\n", i, gpuca_RMSG8_LD[i]);

      /************ R_MSG9_LD ****************/
      FPRINTF_TO_TRAILFILE(trail_fid, "\nR_MSG9_LD (SNR):\n");
      //converted on the  fly during transmission
      for (i=0; i<gs_RxNumTones; i++)
      {
         if((i < gs_RxFirstChannel) || (i > gs_RxLastChannel))
            s_value = OUT_OF_RANGE_SNR & 0xFF;
         else
            s_value =((uint8)round((32<<8) + gsa_MedleySnrBuf[i],7)) & 0xFF;
         FPRINTF_TO_TRAILFILE(trail_fid, "SNR[%d] = %d\n", i, s_value);
      }

      FPRINTF_TO_TRAILFILE(trail_fid, "\n");
   }
   else if((( gl_SelectedMode & (MODE_ADSL2)  )) && (guc_FdqTrainingState == TRAINING_DONE))
   {
      // Bis/Plus Data Mode Train. Print Hlog and QLN
      /************  Hlog test parameter ****************/
      FPRINTF_TO_TRAILFILE(trail_fid, "\nHlog  in Diagnostics Mode format (6-Hlog[]/10)[dB]:\n");
      if(( gl_SelectedMode & (MODE_G992_5)  ))
      {
         FPRINTF_TO_TRAILFILE(trail_fid, "Hlog[%d] = %d\n", 0, OUT_OF_RANGE_HLOG);
         for (i=1; i<gs_RxNumTones; i++)
         {
            s_ind = (i-1)>>1;
            if(((i+1) & 1) == 0)
               s_value = gsa_RxHlogDS[s_ind];
            else
            {
               // interpolate subsampled Hlog
               // Since we expect it to be smooth in dB domain linearly interpolate dB values
               if((gsa_RxHlogDS[s_ind] != OUT_OF_RANGE_HLOG) && (gsa_RxHlogDS[s_ind+1] != OUT_OF_RANGE_HLOG))
                  s_value = (int16)(((int32)gsa_RxHlogDS[s_ind] + gsa_RxHlogDS[s_ind+1] + 1) >> 1);
               else
                  s_value = OUT_OF_RANGE_HLOG;
            }

            FPRINTF_TO_TRAILFILE(trail_fid, "Hlog[%d] = %d\n", i, s_value);
         }
      }
      else
      {
         for (i=0; i<256; i++)
            FPRINTF_TO_TRAILFILE(trail_fid, "Hlog[%d] = %d\n", i, gsa_RxHlogDS[i]);
      }

      /************ QLN test parameter ****************/
      FPRINTF_TO_TRAILFILE(trail_fid, "\nQuiet Line Noise PSD in Diagnostics Mode format (-23-Qln[]/2)[dBm/Hz]:\n");
      if(( gl_SelectedMode & (MODE_G992_5)  ))
      {
         FPRINTF_TO_TRAILFILE(trail_fid, "Qln[%d] = %d\n", 0, OUT_OF_RANGE_QUIETLINE_PSD);
         for (i=1; i<gs_RxNumTones; i++)
         {
            s_ind = (i-1)>>1;
            if(((i+1) & 1) == 0)
               s_value = (int16)guca_QLN[s_ind];
            else
            {
               // interpolate subsampled Hlog
               // Since we expect it to be smooth in dB domain linearly interpolate dB values
               if((guca_QLN[s_ind] != OUT_OF_RANGE_QUIETLINE_PSD) && (guca_QLN[s_ind+1] != OUT_OF_RANGE_QUIETLINE_PSD))
                  s_value = (int16)(((int16)guca_QLN[s_ind] + guca_QLN[s_ind+1] + 1) >> 1);
               else
                  s_value = OUT_OF_RANGE_QUIETLINE_PSD;
            }

            FPRINTF_TO_TRAILFILE(trail_fid, "Qln[%d] = %d\n", i, s_value);
         }
      }
      else
      {
         for (i=0; i<gs_RxNumTones; i++)
            FPRINTF_TO_TRAILFILE(trail_fid, "Qln[%d] = %d\n", i, guca_QLN[i]);
      }

      FPRINTF_TO_TRAILFILE(trail_fid, "\n");
   }


   if (guc_PgaTrainingState == TRAINING_DONE)
      /* Print PGA information */
      PrintPGAInfo();

   // Print overflow information for specific states
   // Only meaningful in connectivity test and train test vector test
   if(gft_ModemType == G_DMT) {
      if (TESTArray[TEST_InitState] == TEST_ShowtimeInitState)
         PrnOvflwShowtimeResults_DMT();

      else if (((TESTArray[TEST_Control] & TEST_ConnControl) != 0) ||
            (TESTArray[TEST_InitState] == TEST_TrainInitState)) {
         PrnOvflwTrainResults_DMT();
         PrnOvflwShowtimeResults_DMT();
      }
   }

   //else if (gft_ModemType == G_DMT_BIS) {
      //if (((TESTArray[TEST_Control] & TEST_ConnControl) != 0) &&
         //(TESTArray[TEST_InitState] != TEST_TrainInitState)) {
      // PrnOvflwResults_BIS();
   //}

    PrnShowTimeResults();

// print txtonebuf and rxtonebuf if loop back is enabled
   if (gft_StrymonLpbkMode == STR_TX_RX_LPBK)
   {
      FPRINTF_TO_TRAILFILE(trail_fid, "\nStrymon Loop Back enabled : TRUE\n");
      FPRINTF_TO_TRAILFILE(trail_fid, "\n Tx Tone Buf: \n");

         for (i=0; i<gs_TxFftLength; i++)
            FPRINTF_TO_TRAILFILE(trail_fid, "TxToneBuf[%d] = %d\n", i, gsa_TxToneBuf[i]);

      FPRINTF_TO_TRAILFILE(trail_fid, "\n Rx Tone Buf: \n");
         for (i=0; i<gs_RxNumTones; i++)
            FPRINTF_TO_TRAILFILE(trail_fid, "RxToneBuf[%d] = %d\n", i, gsa_RxToneBuf[i]);

   }





   FCLOSE_TRAILFILE(trail_fid);
   FCLOSE_TRAILFILE(crc_fid);

#endif   /* #ifdef LEAVE_TRAIL  */

}

#ifdef LEAVE_TRAIL

/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: PrintInfoField_Bis
 *
 *  Description:
 *    Print Bis or BisPlus Information Field structure.
 *
 *  Parameters:
 *      FILE *trail_fid   : output file to which the data is printed
 *      Adsl2AllInfo_t *pt_BisInfo : pointer to Bis or BisPlus information to be printed
 *    uc_InfoType:   : type from InfoField
 *      uc_multiplier   : =1 for bis and = 2 for plus to double the data rates reported.
 *
 *  Returns:
 *    none
 *
 *  Notes:
 *    This function is only used for processing LEAVE_TRAIL.
 *
 *-------------------------------------------------------------------
 *^^^
 */
void PrintInfoField_Bis( TRAILFILE trail_fid, Adsl2AllInfo_t *pt_BisInfo, uint8 uc_InfoType, uint8 uc_multiplier,
                  uint8* puca_TssiIndex, uint8* pfta_Si, uint8* puca_Tssi)
{

int16 i, j, s_shift;
uint8 uc_Spar2, uc_Type, *puca_BreakFreq;
uint8 tempValue;
double temp;


         FPRINTF_TO_TRAILFILE(trail_fid, "Standard Information NPar2:\t 0x%02X\n", pt_BisInfo->uc_SI_NPar2);
         for(i=0; i< NUM_SI_SPAR2_OCTETS; i++)
            FPRINTF_TO_TRAILFILE(trail_fid, "Standard Information SPar2 octet %d:\t 0x%02X\n", (i+1), pt_BisInfo->uc_SI_SPar2[i]);

         /* pmd info */
         if ( (pt_BisInfo->uc_SI_SPar2[0] & SPECTRUM_BOUNDS_UP) != 0 )
         {
            /* spectrum bounds upstream info */
            temp = (double)(pt_BisInfo->t_PMD_NPar3_US.s_NOMPSD)/10.0;
            FPRINTF_TO_TRAILFILE(trail_fid, "\nNominal PSD Upstream (relative to -38dBm/Hz):\t %+2.1lfdBm/Hz\n", temp);

            temp = (double)pt_BisInfo->t_PMD_NPar3_US.s_MAXNOMPSD/10.0;
            FPRINTF_TO_TRAILFILE(trail_fid, "Max. Nominal PSD Upstream (relative to -38dBm/Hz):\t %+2.1lfdBm/Hz\n", temp);

            temp = (double)pt_BisInfo->t_PMD_NPar3_US.s_MAXNOMATP/10.0;
            FPRINTF_TO_TRAILFILE(trail_fid, "Max. Nominal Aggregate Transmit Power Upstream (relative to 12.5dBm):\t %+2.1lfdBm\n", temp);
            }

         if ( (pt_BisInfo->uc_SI_SPar2[0] & SPECTRUM_BOUNDS_DN) != 0 )
         {
            /* spectrum bounds downstream info */
            temp = (double)pt_BisInfo->t_PMD_NPar3_DS.s_NOMPSD/10.0;
            FPRINTF_TO_TRAILFILE(trail_fid, "\nNominal PSD Downstream (relative to -40dBm/Hz):\t %+2.1lfdBm/Hz\n", temp);

            temp = (double)pt_BisInfo->t_PMD_NPar3_DS.s_MAXNOMPSD/10.0;
            FPRINTF_TO_TRAILFILE(trail_fid, "Max. Nominal PSD Downstream (relative to -40dBm/Hz):\t %+2.1lfdBm/Hz\n", temp);

            temp = (double)pt_BisInfo->t_PMD_NPar3_DS.s_MAXNOMATP/10.0;
            FPRINTF_TO_TRAILFILE(trail_fid, "Max. Nominal Aggregate Transmit Power Downstream (relative to 19.9dBm):\t %2.1lfdBm\n", temp);
         }

         /* tssi info */
         /* upstream spectrum shaping info */
         if ( ((uc_InfoType == M_CL) || (uc_InfoType == M_CLR)) && ((pt_BisInfo->uc_SI_SPar2[0] & SPECTRUM_SHAPE_UP) != 0) )
         {
            int16 s_num_US_Tssi_brkpt;

            FPRINTF_TO_TRAILFILE(trail_fid, "\nUpstream spectrum shaping breakpoints: ");

            if (uc_InfoType == M_CL) {
               FPRINTF_TO_TRAILFILE(trail_fid, "we received %d breakpoints, max we can keep is %d.\n",
                  gsa_num_US_Tssi_brkpt[uc_multiplier-1], gt_GHS_USTssiInfo.s_MaxNumBrkpt);
               s_num_US_Tssi_brkpt = gsa_num_US_Tssi_brkpt_kept[uc_multiplier-1];
            }
            else {
               FPRINTF_TO_TRAILFILE(trail_fid, "\n");
               s_num_US_Tssi_brkpt = gt_GHS_USTssiInfo.s_NumBrkptkept;
               if (s_num_US_Tssi_brkpt > NUM_US_TSSI_VALUES_INITIAL_CLR)
               {
                  FPRINTF_TO_TRAILFILE(trail_fid, "Default CLR US Tssi Info:\nSubcarrier Indices: ");
                  for (i = 0; i < NUM_US_TSSI_VALUES_INITIAL_CLR; i++)
                     FPRINTF_TO_TRAILFILE(trail_fid, "%d\t", puca_TssiIndex[i]);;

                  FPRINTF_TO_TRAILFILE(trail_fid, "\nIndication bit:     ");

                  for (i = 0; i < NUM_US_TSSI_VALUES_INITIAL_CLR; i++)
                     FPRINTF_TO_TRAILFILE(trail_fid, "%d\t", (pfta_Si[i>>3]>>i)&0x1);

                  FPRINTF_TO_TRAILFILE(trail_fid, "\nlog_tssi:           ");

                  for (i = 0; i < NUM_US_TSSI_VALUES_INITIAL_CLR; i++)
                     FPRINTF_TO_TRAILFILE(trail_fid, "%d\t", puca_Tssi[i]);

                  FPRINTF_TO_TRAILFILE(trail_fid, "\n\nUpdated CLR US Tssi Info: Total %d of breakpoints\n", s_num_US_Tssi_brkpt);
               }
            }

            FPRINTF_TO_TRAILFILE(trail_fid, "Subcarrier Indices: ");
            puca_BreakFreq = (uint8*)pt_BisInfo->t_PMD_NPar3_US.pus_BreakFreq;
            for (i = 0; i < s_num_US_Tssi_brkpt; i++)
               FPRINTF_TO_TRAILFILE(trail_fid, "%d\t", puca_BreakFreq[i]);;

            FPRINTF_TO_TRAILFILE(trail_fid, "\nIndication bit:     ");

            for (i = 0; i < s_num_US_Tssi_brkpt; i++)
            {
               s_shift = i - ((i>>3)<<3);
               FPRINTF_TO_TRAILFILE(trail_fid, "%d\t", ((pt_BisInfo->t_PMD_NPar3_US.pf_InSprtSet[i>>3])>>s_shift)&0x1);
            }

            FPRINTF_TO_TRAILFILE(trail_fid, "\nlog_tssi:           ");

            for (i = 0; i < s_num_US_Tssi_brkpt; i++)
               FPRINTF_TO_TRAILFILE(trail_fid, "%d\t", pt_BisInfo->t_PMD_NPar3_US.puc_tssi[i]);

            FPRINTF_TO_TRAILFILE(trail_fid, "\n");
         }

         if ( (pt_BisInfo->uc_SI_SPar2[0] & SPECTRUM_SHAPE_DN) != 0 )
         {
            FPRINTF_TO_TRAILFILE(trail_fid, "\nDownstream spectrum shaping breakpoints: ");

            FPRINTF_TO_TRAILFILE(trail_fid, "we received %d breakpoints, max we can keep is %d.\n",
               gsa_num_DS_Tssi_brkpt[uc_multiplier-1], gt_GHS_DSTssiInfo.s_MaxNumBrkpt);

            FPRINTF_TO_TRAILFILE(trail_fid, "Subcarrier Indices: ");
            for (i = 0; i < gsa_num_DS_Tssi_brkpt_kept[uc_multiplier-1]; i++)
               FPRINTF_TO_TRAILFILE(trail_fid, "%d\t", pt_BisInfo->t_PMD_NPar3_DS.pus_BreakFreq[i]);;

            FPRINTF_TO_TRAILFILE(trail_fid, "\nIndication bit:     ");

            for (i = 0; i < gsa_num_DS_Tssi_brkpt_kept[uc_multiplier-1]; i++)
            {
               s_shift = i - ((i>>3)<<3);
               FPRINTF_TO_TRAILFILE(trail_fid, "%d\t", ((pt_BisInfo->t_PMD_NPar3_DS.pf_InSprtSet[i>>3])>>s_shift)&0x1);
            }

            FPRINTF_TO_TRAILFILE(trail_fid, "\nlog_tssi:           ");

            for (i = 0; i < gsa_num_DS_Tssi_brkpt_kept[uc_multiplier-1]; i++)
               FPRINTF_TO_TRAILFILE(trail_fid, "%d\t", pt_BisInfo->t_PMD_NPar3_DS.puc_tssi[i]);

            FPRINTF_TO_TRAILFILE(trail_fid, "\n");
         }

         if ( (pt_BisInfo->uc_SI_SPar2[0] & TX_IMAGE_NYQ) != 0 ) {
            /* transmit signal images above nyquist info */
            if((pt_BisInfo->uc_TxSignalNyq & 0x3C) == 0)
               FPRINTF_TO_TRAILFILE(trail_fid, "IDFT size N:\t is not a power of 2\n");
            else
               FPRINTF_TO_TRAILFILE(trail_fid, "IDFT size N:\t %d\n", (1<<((pt_BisInfo->uc_TxSignalNyq &0x3C)>>2)));

            if((pt_BisInfo->uc_TxSignalNyq & 0x3) == 1)
               FPRINTF_TO_TRAILFILE(trail_fid, "IFFT fill:\t complex conjugate of the base-band signal\n");
            else if((pt_BisInfo->uc_TxSignalNyq & 0x3) == 2)
               FPRINTF_TO_TRAILFILE(trail_fid, "IFFT fill:\t zero-filled\n");
            else if ((pt_BisInfo->uc_TxSignalNyq & 0x3) == 0)
               FPRINTF_TO_TRAILFILE(trail_fid, "IFFT fill:\t Neither zero-filled, nor complex conjugate of the base-band signal\n");

            FPRINTF_TO_TRAILFILE(trail_fid, "\n");
           }

         switch (pt_BisInfo->uca_PSD_Mask[0] & 0x3)
         {
         case 0:
            FPRINTF_TO_TRAILFILE(trail_fid, "US PSD Mask: G992.3 AnnexA\n");
            break;

         case 1:
            FPRINTF_TO_TRAILFILE(trail_fid, "US PSD Mask: G992.3 AnnexL Mask1 (Wide Spectrum)\n");
            break;

         case 2:
            FPRINTF_TO_TRAILFILE(trail_fid, "US PSD Mask: G992.3 AnnexL Mask2 (Narrow Spectrum)\n");
            break;

         case 3:
            FPRINTF_TO_TRAILFILE(trail_fid, "US PSD Mask: G992.3 AnnexL Mask1 | G992.3 AnnexL Mask2 \n");
            break;

         default:
            break;

         }


         switch (pt_BisInfo->uca_PSD_Mask[1] & 0x3)
         {
         case 0:
            FPRINTF_TO_TRAILFILE(trail_fid, "DS PSD Mask: G992.3 AnnexA\n");
            break;

         case 1:
            FPRINTF_TO_TRAILFILE(trail_fid, "DS PSD Mask: Non_Overlapped\n");
            break;

         case 2:
            FPRINTF_TO_TRAILFILE(trail_fid, "DS PSD Mask: Overlapped\n");
            break;

         default:
            break;

         }
         /* pms-tc info */
         FPRINTF_TO_TRAILFILE(trail_fid, "\nMinimum DS MSG overhead data rate:\t %d (times 1000 bps)\n", pt_BisInfo->t_Overhead.s_DSMSGOvhdMinRate);
         FPRINTF_TO_TRAILFILE(trail_fid, "Maximum num of DS STM TPS-TC functions:\t %d\n", pt_BisInfo->uc_DS_Max_Num_STM_TPS_TC);
         FPRINTF_TO_TRAILFILE(trail_fid, "Maximum num of DS ATM TPS-TC functions:\t %d\n", pt_BisInfo->uc_DS_Max_Num_ATM_TPS_TC);
         FPRINTF_TO_TRAILFILE(trail_fid, "Maximum num of DS PTM TPS-TC functions:\t %d\n", pt_BisInfo->uc_DS_Max_Num_PTM_TPS_TC);

         FPRINTF_TO_TRAILFILE(trail_fid, "\nMinimum US MSG overhead data rate:\t %d (times 1000 bps)\n", pt_BisInfo->t_Overhead.s_USMSGOvhdMinRate);
         FPRINTF_TO_TRAILFILE(trail_fid, "Maximum num of US STM TPS-TC functions:\t %d\n", pt_BisInfo->uc_US_Max_Num_STM_TPS_TC);
         FPRINTF_TO_TRAILFILE(trail_fid, "Maximum num of US ATM TPS-TC functions:\t %d\n", pt_BisInfo->uc_US_Max_Num_ATM_TPS_TC);
         FPRINTF_TO_TRAILFILE(trail_fid, "Maximum num of US PTM TPS-TC functions:\t %d\n", pt_BisInfo->uc_US_Max_Num_PTM_TPS_TC);


         for(i=0; i<MAX_LATENCY_PATHS; i++)
         {
            /* print info for only those latency paths that are supported */
            if(pt_BisInfo->uc_SI_SPar2[2*(i+1)+1] & LATENCY_PATH_DN)
            {
               FPRINTF_TO_TRAILFILE(trail_fid, "\nFor DS Latency Path #%d\n", i);
               FPRINTF_TO_TRAILFILE(trail_fid, "Maximum data rate = %d (times %d bps)\n", pt_BisInfo->ta_DSLatencyPath[i].s_MaxDataRate, uc_multiplier*4000);
               FPRINTF_TO_TRAILFILE(trail_fid, "Maximum R = %d", 2*(pt_BisInfo->ta_DSLatencyPath[i].s_MaxRandD >> 8));
               if (i == 0)
                  FPRINTF_TO_TRAILFILE(trail_fid, "(Not transmitted - required by Standard)\n");
               else
                  FPRINTF_TO_TRAILFILE(trail_fid, "\n");
               FPRINTF_TO_TRAILFILE(trail_fid, "Maximum D = %d", (1<<(pt_BisInfo->ta_DSLatencyPath[i].s_MaxRandD & 0xFF)));
               if (i == 0)
                  FPRINTF_TO_TRAILFILE(trail_fid, "(Not transmitted - required by Standard)\n");
               else
                  FPRINTF_TO_TRAILFILE(trail_fid, "\n");
            }
         }

         for(i=0; i<MAX_LATENCY_PATHS; i++)
         {
            /* print info for only those latency paths that are supported */
            if(pt_BisInfo->uc_SI_SPar2[2*(i+1)+1] & LATENCY_PATH_UP)
            {
               FPRINTF_TO_TRAILFILE(trail_fid, "\nFor US Latency Path #%d\n", i);
               FPRINTF_TO_TRAILFILE(trail_fid, "Maximum data rate = %d (times 4000 bps)\n", pt_BisInfo->ta_USLatencyPath[i].s_MaxDataRate);
               FPRINTF_TO_TRAILFILE(trail_fid, "Maximum R = %d", 2*(pt_BisInfo->ta_USLatencyPath[i].s_MaxRandD >> 8));
               if (i == 0)
                  FPRINTF_TO_TRAILFILE(trail_fid, "(Not transmitted - required by Standard)\n");
               else
                  FPRINTF_TO_TRAILFILE(trail_fid, "\n");
               FPRINTF_TO_TRAILFILE(trail_fid, "Maximum D = %d", (1<<(pt_BisInfo->ta_USLatencyPath[i].s_MaxRandD & 0xFF)));
               if (i == 0)
                  FPRINTF_TO_TRAILFILE(trail_fid, "(Not transmitted - required by Standard)\n");
               else
                  FPRINTF_TO_TRAILFILE(trail_fid, "\n");
            }
         }

         /* tps-tc info */
         for(i=0; i<MAX_BEARER_CHANNEL; i++)
         {
            uc_Spar2 = pt_BisInfo->uc_SI_SPar2[2*(i+1)];
            for(j=0; j<MAX_TPS_TC_TYPE; j++)
            {
               /* the assumption below is that STM, ATM and PTM codepoints for all TPS-TC functions are the same (atleast it is so in the current g994.1 standard */
               /* so we are using tps-tc function 0's STM, ATM and PTM constants ie. constant TPSTC_FUNC0_STM_DN, TPSTC_FUNC0_ATM_DN, TPSTC_FUNC0_PTM_DN */
               /* already printed STM info. So, set the STM bit corresponding to Spar2 to zero */
               switch(j)
               {
                  case 0:
                     uc_Type = TPSTC_FUNC_STM_DN;
                     break;

                  case 1:
                     uc_Type = TPSTC_FUNC_ATM_DN;
                     break;

                  case 2:
                     uc_Type = TPSTC_FUNC_PTM_DN;
                     break;
               }

               if(uc_Spar2 & uc_Type)
               {
                  /* print for only those tps tc types that are supported */
                  FPRINTF_TO_TRAILFILE(trail_fid, "\nFor DS TPS-TC Function#%d type %d:\n", i, j);
                  FPRINTF_TO_TRAILFILE(trail_fid, "Minimum net data rate =  %d (times %d bps)\n", pt_BisInfo->ta_DSBearerChannel[i].ta_TpsTcType[j].s_MinNetDataRate, uc_multiplier*4000);
                  FPRINTF_TO_TRAILFILE(trail_fid, "Maximum net data rate =  %d (times %d bps)\n", pt_BisInfo->ta_DSBearerChannel[i].ta_TpsTcType[j].s_MaxNetDataRate, uc_multiplier*4000);
                  FPRINTF_TO_TRAILFILE(trail_fid, "Minimum reserved net data rate =  %d (times %d bps)\n", pt_BisInfo->ta_DSBearerChannel[i].ta_TpsTcType[j].s_MinResNetDataRate, uc_multiplier*4000);
                  if ((pt_BisInfo->ta_DSBearerChannel[i].ta_TpsTcType[j].s_MaxLatency == 1024) || (pt_BisInfo->ta_DSBearerChannel[i].ta_TpsTcType[j].s_MaxLatency == 0))
                     FPRINTF_TO_TRAILFILE(trail_fid, "Maximum latency = 1024 (a special value which means no delay boundary)\n");
                  else
                     FPRINTF_TO_TRAILFILE(trail_fid, "Maximum latency =  %d ms \n", (pt_BisInfo->ta_DSBearerChannel[i].ta_TpsTcType[j].s_MaxLatency));
                  if((pt_BisInfo->ta_DSBearerChannel[i].ta_TpsTcType[j].uc_MaxBER) == 0)
                     FPRINTF_TO_TRAILFILE(trail_fid, "Maximum BER =  10^(-3)\n");
                  else if((pt_BisInfo->ta_DSBearerChannel[i].ta_TpsTcType[j].uc_MaxBER) == 0x1)
                     FPRINTF_TO_TRAILFILE(trail_fid, "Maximum BER =  10^(-5)\n");
                  else if((pt_BisInfo->ta_DSBearerChannel[i].ta_TpsTcType[j].uc_MaxBER) == 0x2)
                     FPRINTF_TO_TRAILFILE(trail_fid, "Maximum BER =  10^(-7)\n");

                  tempValue = pt_BisInfo->ta_DSBearerChannel[i].ta_TpsTcType[j].s_IMAxINP & 0x03;
                  if (tempValue == 0)
                     FPRINTF_TO_TRAILFILE(trail_fid, "Minimum INP = 0 (a special value which means no INP bound)\n");
                  else if (tempValue == 1)
                     FPRINTF_TO_TRAILFILE(trail_fid, "Minimum INP = 1/2\n");
                  else if (tempValue == 2)
                     FPRINTF_TO_TRAILFILE(trail_fid, "Minimum INP = 1\n");
                  else if (tempValue == 3)
                     FPRINTF_TO_TRAILFILE(trail_fid, "Minimum INP = 2\n");


                  if (uc_Type == TPSTC_FUNC_ATM_DN)
                  {
                     tempValue = (pt_BisInfo->ta_DSBearerChannel[i].ta_TpsTcType[j].s_IMAxINP >>8) & 0x01;
                     FPRINTF_TO_TRAILFILE(trail_fid, "IMA Flag = %d\n", tempValue);
                  }
               }
            } /* for(j=0; j<MAX_TPS_TC_TYPE; j++) */
         } /* for(i=0; i<NUM_DS_BEARER_CHANNELS_SUPPORTED; i++) */



         for(i=0; i<MAX_BEARER_CHANNEL; i++)
         {
            uc_Spar2 = pt_BisInfo->uc_SI_SPar2[2*(i+1)];
            for(j=0; j<MAX_TPS_TC_TYPE; j++)
            {
               /* the assumption below is that STM, ATM and PTM codepoints for all TPS-TC functions are the same (atleast it is so in the current g994.1 standard */
               /* so we are using tps-tc function 0's STM, ATM and PTM constants ie. constant TPSTC_FUNC_STM_US, TPSTC_FUNC_ATM_US, TPSTC_FUNC_PTM_US */
               /* already printed STM info. So, set the STM bit corresponding to Spar2 to zero */
               switch(j)
               {
                  case 0:
                     uc_Type = TPSTC_FUNC_STM_US;
                     break;

                  case 1:
                     uc_Type = TPSTC_FUNC_ATM_US;
                     break;

                  case 2:
                     uc_Type = TPSTC_FUNC_PTM_US;
                     break;

               }
               if(uc_Spar2 & uc_Type)
               {
                  /* print for only those tps tc types that are supported */
                  FPRINTF_TO_TRAILFILE(trail_fid, "\nFor US TPS-TC Function#%d type %d:\n", i, j);
                  FPRINTF_TO_TRAILFILE(trail_fid, "Minimum net data rate =  %d (times 4000 bps)\n", pt_BisInfo->ta_USBearerChannel[i].ta_TpsTcType[j].s_MinNetDataRate);
                  FPRINTF_TO_TRAILFILE(trail_fid, "Maximum net data rate =  %d (times 4000 bps)\n", pt_BisInfo->ta_USBearerChannel[i].ta_TpsTcType[j].s_MaxNetDataRate);
                  FPRINTF_TO_TRAILFILE(trail_fid, "Minimum reserved net data rate =  %d (times 4000 bps)\n", pt_BisInfo->ta_USBearerChannel[i].ta_TpsTcType[j].s_MinResNetDataRate);

                  if ((pt_BisInfo->ta_USBearerChannel[i].ta_TpsTcType[j].s_MaxLatency == 1024) || (pt_BisInfo->ta_USBearerChannel[i].ta_TpsTcType[j].s_MaxLatency == 0))
                     FPRINTF_TO_TRAILFILE(trail_fid, "Maximum latency = 1024 (a special value which means no delay boundary)\n");
                  else
                     FPRINTF_TO_TRAILFILE(trail_fid, "Maximum latency =  %d ms \n", (pt_BisInfo->ta_USBearerChannel[i].ta_TpsTcType[j].s_MaxLatency));
                  if((pt_BisInfo->ta_USBearerChannel[i].ta_TpsTcType[j].uc_MaxBER) == 0)
                     FPRINTF_TO_TRAILFILE(trail_fid, "Maximum BER =  10^(-3)\n");
                  else if((pt_BisInfo->ta_USBearerChannel[i].ta_TpsTcType[j].uc_MaxBER) == 0x1)
                     FPRINTF_TO_TRAILFILE(trail_fid, "Maximum BER =  10^(-5)\n");
                  else if((pt_BisInfo->ta_USBearerChannel[i].ta_TpsTcType[j].uc_MaxBER) == 0x2)
                     FPRINTF_TO_TRAILFILE(trail_fid, "Maximum BER =  10^(-7)\n");

                  tempValue = pt_BisInfo->ta_USBearerChannel[i].ta_TpsTcType[j].s_IMAxINP & 0x03;
                  if (tempValue == 0)
                     FPRINTF_TO_TRAILFILE(trail_fid, "Minimum INP = 0 (a special value which means no INP bound)\n");
                  else if (tempValue == 1)
                     FPRINTF_TO_TRAILFILE(trail_fid, "Minimum INP = 1/2\n");
                  else if (tempValue == 2)
                     FPRINTF_TO_TRAILFILE(trail_fid, "Minimum INP = 1\n");
                  else if (tempValue == 3)
                     FPRINTF_TO_TRAILFILE(trail_fid, "Minimum INP = 2\n");


                  if (uc_Type == TPSTC_FUNC_ATM_US)
                  {
                     tempValue = (pt_BisInfo->ta_USBearerChannel[i].ta_TpsTcType[j].s_IMAxINP >>8) & 0x01;
                     FPRINTF_TO_TRAILFILE(trail_fid, "IMA Flag = %d\n", tempValue);
                  }
               }
            } /* for(j=0; j<MAX_TPS_TC_TYPE; j++) */

         } /* for(i=0; i<NUM_US_BEARER_CHANNELS_SUPPORTED; i++) */
}


/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: PrintInfoField
 *
 *  Description:
 *    Print an Information Field structure.
 *
 *  Parameters:
 *      FILE *trail_fid   : output file to which the data is printed
 *      InfoField *t_Info : information to be printed
 *
 *  Returns:
 *    none
 *
 *  Notes:
 *    This function is only used for processing LEAVE_TRAIL.
 *
 *-------------------------------------------------------------------
 *^^^
 */
void PrintInfoField( TRAILFILE trail_fid, InfoField_t * t_Info ) {

    int16 i, j;
    NonStandardBlock_t *pt_NSB;

    FPRINTF_TO_TRAILFILE(trail_fid, "Message Type:\t 0x%02X\n", t_Info->uc_Type);
    FPRINTF_TO_TRAILFILE(trail_fid, "Revision Number: \t%d\n", t_Info->uc_Rev);

    /* ---- Vendor ID (required only for CL and CLR messages) ---- */
    switch (t_Info->uc_Type)
   {

    case M_CL  :
    case M_CLR :
        FPRINTF_TO_TRAILFILE(trail_fid, "Country Code:\t 0x%04X\n", t_Info->us_Country);
        FPRINTF_TO_TRAILFILE(trail_fid, "Provider ID:\t 0x%08X\n", t_Info->ul_Provider);
        FPRINTF_TO_TRAILFILE(trail_fid, "Vendor Specific Info:\t 0x%04X\n", t_Info->us_VendorInfo);

    }   /*  switch (vendor ID) */

    /* ==== Service and Channel parameters (for CL, CLR, MS only) ==== */
    switch (t_Info->uc_Type)
   {

    case M_CL :
    case M_CLR :
    case M_MS :
        FPRINTF_TO_TRAILFILE(trail_fid, "ID_NPar1:\t 0x%02X\n", t_Info->uc_ID_NPar1);
      for(i=0; i<3; i++)
         FPRINTF_TO_TRAILFILE(trail_fid, "ID_SPar1, octet %d:\t 0x%02X\n", (i+1), t_Info->uc_ID_SPar1[i]);

        /* ---- ID_NPar2 ---- */
        FPRINTF_TO_TRAILFILE(trail_fid, "Maximum Net Data Rate Upstream:\t %d kbps\n",
         (t_Info->uc_UpMaxNDR & LARGE_NDR) ? ((t_Info->uc_UpMaxNDR & NDR_BITS)*2000) : ((t_Info->uc_UpMaxNDR & NDR_BITS)*64));

        FPRINTF_TO_TRAILFILE(trail_fid, "Minimum Net Data Rate Upstream:\t %d kbps\n",
         (t_Info->uc_UpMinNDR & LARGE_NDR) ? ((t_Info->uc_UpMinNDR & NDR_BITS)*2000) : ((t_Info->uc_UpMinNDR & NDR_BITS)*64));

        FPRINTF_TO_TRAILFILE(trail_fid, "Average Net Data Rate Upstream:\t %d kbps\n",
         (t_Info->uc_UpAvgNDR & LARGE_NDR) ? ((t_Info->uc_UpAvgNDR & NDR_BITS)*2000) : ((t_Info->uc_UpAvgNDR & NDR_BITS)*64));

        FPRINTF_TO_TRAILFILE(trail_fid, "Maximum Net Data Rate Downstream:\t %d kbps\n",
         (t_Info->uc_DnMaxNDR & LARGE_NDR) ? ((t_Info->uc_DnMaxNDR & NDR_BITS)*2000) : ((t_Info->uc_DnMaxNDR & NDR_BITS)*64));

        FPRINTF_TO_TRAILFILE(trail_fid, "Minimum Net Data Rate Downstream:\t %d kbps\n",
         (t_Info->uc_DnMinNDR & LARGE_NDR) ? ((t_Info->uc_DnMinNDR & NDR_BITS)*2000) : ((t_Info->uc_DnMinNDR & NDR_BITS)*64));

        FPRINTF_TO_TRAILFILE(trail_fid, "Average Net Data Rate Downstream:\t %d kbps\n",
         (t_Info->uc_DnAvgNDR & LARGE_NDR) ? ((t_Info->uc_DnAvgNDR & NDR_BITS)*2000) : ((t_Info->uc_DnAvgNDR & NDR_BITS)*64));

        FPRINTF_TO_TRAILFILE(trail_fid, "Maximum Latency Upstream:\t %d ms\n",
         (t_Info->uc_UpMaxLat & LARGE_LATENCY) ? ((4+(t_Info->uc_UpMaxLat & LATENCY_BITS))*10) : (t_Info->uc_UpMaxLat & LATENCY_BITS));
        FPRINTF_TO_TRAILFILE(trail_fid, "Average Latency Upstream:\t %d ms\n",
         (t_Info->uc_UpAvgLat & LARGE_LATENCY) ? ((4+(t_Info->uc_UpAvgLat & LATENCY_BITS))*10) : (t_Info->uc_UpAvgLat & LATENCY_BITS));

        FPRINTF_TO_TRAILFILE(trail_fid, "Maximum Latency Downstream:\t %d ms\n",
         (t_Info->uc_DnMaxLat & LARGE_LATENCY) ? ((4+(t_Info->uc_DnMaxLat & LATENCY_BITS))*10) : (t_Info->uc_DnMaxLat & LATENCY_BITS));
        FPRINTF_TO_TRAILFILE(trail_fid, "Average Latency Downstream:\t %d ms\n",
         (t_Info->uc_DnAvgLat & LARGE_LATENCY) ? ((4+(t_Info->uc_DnAvgLat & LATENCY_BITS))*10) : (t_Info->uc_DnAvgLat & LATENCY_BITS));

        FPRINTF_TO_TRAILFILE(trail_fid, "ATU-R Splitter Information:\t 0x%02X\n", t_Info->uc_ID_NPar2_O11);

        FPRINTF_TO_TRAILFILE(trail_fid, "ATU-C Splitter Information:\t 0x%02X\n", t_Info->uc_ID_NPar2_O12);

      FPRINTF_TO_TRAILFILE(trail_fid, "Attenuation in G.994.1 xmit pwer per carrier relative to max power for US carrier set A43:\t %fdB\n", (t_Info->uc_UpA43Attenuation*0.5));
      FPRINTF_TO_TRAILFILE(trail_fid, "Attenuation in G.994.1 xmit pwer per carrier relative to max power for DS carrier set A43:\t %fdB\n", (t_Info->uc_DnA43Attenuation*0.5));
      FPRINTF_TO_TRAILFILE(trail_fid, "Attenuation in G.994.1 xmit pwer per carrier relative to max power for US carrier set B43:\t %fdB\n", (t_Info->uc_UpB43Attenuation*0.5));
      FPRINTF_TO_TRAILFILE(trail_fid, "Attenuation in G.994.1 xmit pwer per carrier relative to max power for DS carrier set B43:\t %fdB\n", (t_Info->uc_DnB43Attenuation*0.5));
      FPRINTF_TO_TRAILFILE(trail_fid, "Attenuation in G.994.1 xmit pwer per carrier relative to max power for US carrier set C43:\t %fdB\n", (t_Info->uc_UpC43Attenuation*0.5));
      FPRINTF_TO_TRAILFILE(trail_fid, "Attenuation in G.994.1 xmit pwer per carrier relative to max power for DS carrier set C43:\t %fdB\n", (t_Info->uc_DnC43Attenuation*0.5));
      FPRINTF_TO_TRAILFILE(trail_fid, "Attenuation in G.994.1 xmit pwer per carrier relative to max power for US carrier set A4:\t %fdB\n", (t_Info->uc_UpA4Attenuation*0.5));
      FPRINTF_TO_TRAILFILE(trail_fid, "Attenuation in G.994.1 xmit pwer per carrier relative to max power for DS carrier set A4:\t %fdB\n", (t_Info->uc_DnA4Attenuation*0.5));

    }   /*  switch (parameter field) */


    /* ==== Standard information (for CL, CLR, MS only) ==== */
    switch (t_Info->uc_Type)
   {
    case M_CL :
    case M_CLR :
    case M_MS :

        FPRINTF_TO_TRAILFILE(trail_fid, "Standard Information NPar1:\t 0x%02X\n", t_Info->uc_SI_NPar1);
      FPRINTF_TO_TRAILFILE(trail_fid, "Standard Information SPar1 octet 1:\t 0x%02X\n", t_Info->uc_SI_SPar1[0]);
      FPRINTF_TO_TRAILFILE(trail_fid, "Standard Information SPar1 octet 2:\t 0x%02X\n", t_Info->uc_SI_SPar1[1]);

      FPRINTF_TO_TRAILFILE(trail_fid, "Standard Information SPar1 octet 3:\t 0x%02X\n", t_Info->uc_SI_SPar1[2]);
      FPRINTF_TO_TRAILFILE(trail_fid, "Standard Information SPar1 octet 4:\t 0x%02X\n", t_Info->uc_SI_SPar1[3]);

      if (t_Info->uc_SI_SPar1[0] & G992_1_A) {
            FPRINTF_TO_TRAILFILE(trail_fid, "Standard Information NPar2:\t 0x%02X\n", t_Info->uc_SI_1A_NPar2);
            FPRINTF_TO_TRAILFILE(trail_fid, "Standard Information SPar2:\t 0x%02X\n", t_Info->uc_SI_1A_SPar2);

            /* ---- SI_NPar3 ---- */
            FPRINTF_TO_TRAILFILE(trail_fid, "Minimum Spectrum Upstream:\t %d\n", t_Info->uc_1A_UpMinSpect);
            FPRINTF_TO_TRAILFILE(trail_fid, "Maximum Spectrum Upstream:\t %d\n", t_Info->uc_1A_UpMaxSpect);

            FPRINTF_TO_TRAILFILE(trail_fid, "Minimum Spectrum Downstream:\t %d\n", t_Info->uc_1A_DnMinSpect);
            FPRINTF_TO_TRAILFILE(trail_fid, "Maximum Spectrum Downstream:\t %d\n", t_Info->uc_1A_DnMaxSpect);
        }

      if (t_Info->uc_SI_SPar1[0] & G992_1_B) {
            FPRINTF_TO_TRAILFILE(trail_fid, "Standard Information NPar2:\t 0x%02X\n", t_Info->uc_SI_1B_NPar2);
            FPRINTF_TO_TRAILFILE(trail_fid, "Standard Information SPar2:\t 0x%02X\n", t_Info->uc_SI_1B_SPar2);

            /* ---- SI_NPar3 ---- */
            FPRINTF_TO_TRAILFILE(trail_fid, "Minimum Spectrum Upstream:\t %d\n", t_Info->uc_1B_UpMinSpect);
            FPRINTF_TO_TRAILFILE(trail_fid, "Maximum Spectrum Upstream:\t %d\n", t_Info->uc_1B_UpMaxSpect);

            FPRINTF_TO_TRAILFILE(trail_fid, "Minimum Spectrum Downstream:\t %d\n", t_Info->uc_1B_DnMinSpect);
            FPRINTF_TO_TRAILFILE(trail_fid, "Maximum Spectrum Downstream:\t %d\n", t_Info->uc_1B_DnMaxSpect);
        }

      if (t_Info->uc_SI_SPar1[0] & G992_2_AB) {
            FPRINTF_TO_TRAILFILE(trail_fid, "Standard Information NPar2:\t 0x%02X\n", t_Info->uc_SI_2AB_NPar2);
            FPRINTF_TO_TRAILFILE(trail_fid, "Standard Information SPar2:\t 0x%02X\n", t_Info->uc_SI_2AB_SPar2);

            /* ---- SI_NPar3 ---- */
            FPRINTF_TO_TRAILFILE(trail_fid, "Minimum Spectrum Upstream:\t %d\n", t_Info->uc_2AB_UpMinSpect);
            FPRINTF_TO_TRAILFILE(trail_fid, "Maximum Spectrum Upstream:\t %d\n", t_Info->uc_2AB_UpMaxSpect);

            FPRINTF_TO_TRAILFILE(trail_fid, "Minimum Spectrum Downstream:\t %d\n", t_Info->uc_2AB_DnMinSpect);
            FPRINTF_TO_TRAILFILE(trail_fid, "Maximum Spectrum Downstream:\t %d\n", t_Info->uc_2AB_DnMaxSpect);
        }

      /* ============================================*/
      /* Print Info Field G992_3 (a.k.a. BIS, ADSL2) Annex A/B/M */
      /* ============================================*/
#ifndef ISDN
      if (t_Info->uc_SI_SPar1[2] & (G992_3_A >> 16)) {

#ifndef BIS_CODESWAP
         if (TESTArray[TEST_ReconfigControl] & TEST_USTssi_Inconsistency)
         {
            (t_Info->pta_G9923xInfo[G992_3_ANNEX_A]->uc_SI_SPar2[0]) |= SPECTRUM_SHAPE_UP;
         }
#endif
         PrintInfoField_Bis(trail_fid, t_Info->pta_G9923xInfo[G992_3_ANNEX_A], t_Info->uc_Type, 1, guca_US_TssiIndex_G9923A[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_A]], gfta_US_SprtSet_G9923A[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_A]], guca_US_TssiValue_G9923A[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_A]]);
        }

#else//ISDN
      if (t_Info->uc_SI_SPar1[2] & (G992_3_B >> 16)) {

         PrintInfoField_Bis(trail_fid, t_Info->pta_G9923xInfo[G992_3_ANNEX_B], t_Info->uc_Type, 1, guca_US_TssiIndex_G9923B[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_B]], gfta_US_SprtSet_G9923B[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_B]], guca_US_TssiValue_G9923B[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_B]]);
        }
#endif//ISDN
#ifndef ISDN
      if (t_Info->uc_SI_SPar1[3] & (G992_3_M >> 24)) {

         PrintInfoField_Bis(trail_fid, t_Info->pta_G9923xInfo[G992_3_ANNEX_M], t_Info->uc_Type, 1, guca_US_TssiIndex_AnnexM[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_M]], gfta_US_SprtSet_AnnexM[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_M]], guca_US_TssiValue_AnnexM[gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_M]]);
        }

      /* ============================================*/
      /* Print Info Field G992_5 (a.k.a. PLUS, ADSL2+) Annex A/B */
      /* ============================================*/

      if (t_Info->uc_SI_SPar1[3] & (G992_5_A >> 24)) {
#ifndef BIS_CODESWAP
         if (TESTArray[TEST_ReconfigControl] & TEST_USTssi_Inconsistency)
         {
            (t_Info->pta_G9925xInfo[G992_5_ANNEX_A]->uc_SI_SPar2[0]) |= SPECTRUM_SHAPE_UP;
         }
#endif

         PrintInfoField_Bis(trail_fid, t_Info->pta_G9925xInfo[G992_5_ANNEX_A], t_Info->uc_Type, 2, guca_US_TssiIndex_G9925A[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_A]], gfta_US_SprtSet_G9925A[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_A]], guca_US_TssiValue_G9925A[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_A]]);
      }

#else//ISDN
      if (t_Info->uc_SI_SPar1[3] & (G992_5_B >> 24)) {

         PrintInfoField_Bis(trail_fid, t_Info->pta_G9925xInfo[G992_5_ANNEX_B], t_Info->uc_Type, 2, guca_US_TssiIndex_G9925B[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_B]], gfta_US_SprtSet_G9925B[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_B]], guca_US_TssiValue_G9925B[gs_Preferred_PSDMask_G9925x[G992_5_ANNEX_B]]);
      }
#endif//ISDN

    }   /*  switch (Standard Info) */


    /* ==== Non-Standard information (for CL, CLR, MS only) ==== */
    switch (t_Info->uc_Type) {
    case M_CL :
    case M_CLR :
    case M_MS :

        FPRINTF_TO_TRAILFILE(trail_fid, "No. of Non-Standard Blocks:\t %d\n", t_Info->uc_NumBlock);

        for ( i = 0; i < t_Info->uc_NumBlock; i++ ) {

            pt_NSB = &( t_Info->ta_NS_Info[i] );
            FPRINTF_TO_TRAILFILE(trail_fid, "Length of Block %d:\t%d\n", i+1, pt_NSB->uc_NSLen);

            for ( j = 0; j < pt_NSB->uc_NSLen - 6; j++ )
                FPRINTF_TO_TRAILFILE(trail_fid, "%d ", pt_NSB->puca_NSVendorSpec[j] );

            FPRINTF_TO_TRAILFILE(trail_fid, "\n");

        }   /*  for */

        break;

    }   /*  switch (Non-Standard Info) */

   /* ==== Selected Mode ==== */
   if ((( (gl_SelectedMode & (MODE_G992_5))) && (gl_SelectedMode & (ANNEX_A)  )) != 0)
      FPRINTF_TO_TRAILFILE(trail_fid, "Selected Mode:\t G992.5 \n");
   else if ((( (gl_SelectedMode & (MODE_G992_3))) && (gl_SelectedMode & (ANNEX_L)  )) != 0)
      FPRINTF_TO_TRAILFILE(trail_fid, "Selected Mode:\t G992.3 L\n");
   else if ((( (gl_SelectedMode & (MODE_G992_3))) && (gl_SelectedMode & (ANNEX_A)  )) != 0)
      FPRINTF_TO_TRAILFILE(trail_fid, "Selected Mode:\t G992.3 A\n");
   else if ((( (gl_SelectedMode & (MODE_G992_3))) && (gl_SelectedMode & (ANNEX_B)  )) != 0)
      FPRINTF_TO_TRAILFILE(trail_fid, "Selected Mode:\t G992.3 B\n");
   else if ((( (gl_SelectedMode & (MODE_G992_5))) && (gl_SelectedMode & (ANNEX_B)  )) != 0)
      FPRINTF_TO_TRAILFILE(trail_fid, "Selected Mode:\t G992.5 B\n");
   else if ((( (gl_SelectedMode & (MODE_G992_3))) && (gl_SelectedMode & (ANNEX_M)  )) != 0)
      FPRINTF_TO_TRAILFILE(trail_fid, "Selected Mode:\t G992.3 M\n");
   else if ((( (gl_SelectedMode & (MODE_G992_5))) && (gl_SelectedMode & (ANNEX_M)  )) != 0)
      FPRINTF_TO_TRAILFILE(trail_fid, "Selected Mode:\t G992.5 M\n");
   else if ((( (gl_SelectedMode & (MODE_G992_5))) && (gl_SelectedMode & (ANNEX_J)  )) != 0)
      FPRINTF_TO_TRAILFILE(trail_fid, "Selected Mode:\t G992.5 J\n");
   else if ((( (gl_SelectedMode & (MODE_G992_3))) && (gl_SelectedMode & (ANNEX_J)  )) != 0)
      FPRINTF_TO_TRAILFILE(trail_fid, "Selected Mode:\t G992.3 J\n");
   else if ((STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_AB) != 0)
      FPRINTF_TO_TRAILFILE(trail_fid, "Selected Mode:\t G992.2 AB\n");
   else if ((STATArray[STAT_Mode] & STAT_ConfigMode_T1413) != 0)
         FPRINTF_TO_TRAILFILE(trail_fid, "Selected Mode:\t T1413\n");
   else if ((( (gl_SelectedMode & (MODE_G992_1))) && (gl_SelectedMode & (ANNEX_A)  )) != 0)
         FPRINTF_TO_TRAILFILE(trail_fid, "Selected Mode:\t G992.1 A\n");
      else if ((( (gl_SelectedMode & (MODE_G992_1))) && (gl_SelectedMode & (ANNEX_B)  )) != 0)
      FPRINTF_TO_TRAILFILE(trail_fid, "Selected Mode:\t G992.1 B\n");


}   /*  PrintInfoField() */


void PrintFinalFDQ(void)
{
   int i;
   float fdq_mag;

   FPRINTF_TO_TRAILFILE(trail_fid, "\nFinal FDQ coefficients\n");
   for(i=0; i<gs_RxNumTones; i++) {
      fdq_mag = (float)sqrt(pow(gsa_pre_FDQ_coef[2*i],2) + pow(gsa_pre_FDQ_coef[2*i+1], 2))*(float)pow(2, guca_pre_FDQ_exp[i] - 13);
      FPRINTF_TO_TRAILFILE(trail_fid, "gsa_FDQ_coef[%3d] = %6d %6d\t exp = %2d\tmag = %6.2f\n", i,
      gsa_pre_FDQ_coef[2*i], gsa_pre_FDQ_coef[2*i+1], guca_pre_FDQ_exp[i], fdq_mag);
   }

   gft_FDQ_PrintedToTrail = 1;
}

void PrintFinal_DS_BAT(void)
{
   int i, total_bits;

   total_bits = 0;

   FPRINTF_TO_TRAILFILE(trail_fid, "\nFinal Bit Allocation Table (downstream):\n");

   for(i=gs_RxFirstChannel; i<=gs_RxLastChannel; i++) {
      FPRINTF_TO_TRAILFILE(trail_fid, "gsa_RxBat[%d] = %d\n", i, guca_RxBat[i]);
      total_bits += guca_RxBat[i];
   }

   FPRINTF_TO_TRAILFILE(trail_fid, "Total RX allocated bits = %d\n", total_bits);



   gft_DS_BAT_PrintedToTrail = 1;

}

void PrintFinal_DS_FineGains(void)
{
   int16 i, s_FineGainDecimal;

   FPRINTF_TO_TRAILFILE(trail_fid, "\nFinal Fine Gains (downstream) in Q3.13 format:\n");
   for(i=0; i<gs_RxNumTones; i++) {
      s_FineGainDecimal = (DecimalGain(gsa_RxFineGains[i]) + (1<<3)) & 0xFFF0;
      FPRINTF_TO_TRAILFILE(trail_fid, "gsa_RxFineGains[%3d] = %5.2f dB (%1.2f ; 0x%x ; %4d)\n", i, (float)gsa_RxFineGains[i]/256.0, (float)s_FineGainDecimal/8192.0, s_FineGainDecimal, s_FineGainDecimal);
   }



   gft_DS_FineGains_PrintedToTrail = 1;

}

void PrintFinal_US_BAT(void)
{
   int i, total_bits;


   FPRINTF_TO_TRAILFILE(trail_fid, "\nFinal Bit Allocation Table (upstream):\n");

   total_bits = 0;
   for(i=gs_TxFirstChannel; i<=gs_TxLastChannel; i++) {
      FPRINTF_TO_TRAILFILE(trail_fid, "gsa_TxBat[%d] = %d\n", i, guca_TxBat[i]);
      total_bits += guca_TxBat[i];
   }

   FPRINTF_TO_TRAILFILE(trail_fid, "Total TX allocated bits %d\n", total_bits);



   gft_US_BAT_PrintedToTrail = 1;

}

void PrintFinal_US_FineGains(void)
{
   int i;

   FPRINTF_TO_TRAILFILE(trail_fid, "\nFinal Fine Gains (upstream) in Q3.13 format:\n");
   for (i=0; i<gs_TxNumTones; i++)
      FPRINTF_TO_TRAILFILE(trail_fid, "gsa_TxFineGains[%d] = %d\n", i, gsa_TxFineGains[i]);



   gft_US_FineGains_PrintedToTrail = 1;

}

/*****************************************************************************
;  Prototype: void OLR_PrnShowtimeParams(void)
;
;  This subroutine prints showtime configuration data to the trail file
;
;  Input Arguments:
;       None
;
;  Output Arguments:
;       None
;
;  Global Variables:
;
;
;****************************************************************************/

void OLR_PrnShowtimeParams(uint8 uc_prnTxShowtimeParams, uint8 uc_prnRxShowtimeParams)
{
   int i, s_MuxFrameSize[NUM_DATA_PATHS], s_CodewordSize[NUM_DATA_PATHS];
   Config_t t_config;
   double fa_S[NUM_DATA_PATHS];

   if(uc_prnTxShowtimeParams)
   {
      FPRINTF_TO_TRAILFILE(trail_fid, "\nReconfigured TX Showtime Parameters:\n");

      t_config = gt_tx_config;
      for (i = 0; i < t_config.s_Nlp; i++)
      {
         s_MuxFrameSize[i] = gt_TxShowTimeVars.t_FrameParms[i].s_MuxFrameSize;
         s_CodewordSize[i] = gt_TxShowTimeVars.t_FrameParms[i].s_CodewordSize;
      }
   }
   else if(uc_prnRxShowtimeParams)
   {
      FPRINTF_TO_TRAILFILE(trail_fid, "\nReconfigured RX Showtime Parameters:\n");

      t_config = gt_rx_config;
      for (i = 0; i < t_config.s_Nlp; i++)
      {
         s_MuxFrameSize[i] = gt_RxShowTimeVars.t_FrameParms[i].s_MuxFrameSize;
         s_CodewordSize[i] = gt_RxShowTimeVars.t_FrameParms[i].s_CodewordSize;
      }
   }

   // Number of bits over which the FEC data frame spans
   for (i=0; i<t_config.s_Nlp; i++)
   {
      if (t_config.s_Lp[i] != 0)
            fa_S[i] = ((double)s_CodewordSize[i] * 8) / (double)t_config.s_Lp[i];
         else  // This path is disable or not linked up, so clear the variable
            fa_S[i] = 0;
      }

   FPRINTF_TO_TRAILFILE(trail_fid, "\n        Lp\tBp0\tBp1\t  S  \t K\tCWSize\n");
   for (i = 0; i < t_config.s_Nlp; i++)
   {
      FPRINTF_TO_TRAILFILE(trail_fid, "LP#%d:", i);
      FPRINTF_TO_TRAILFILE(trail_fid, " %3d", t_config.s_Lp[i]);
      FPRINTF_TO_TRAILFILE(trail_fid, "\t%3d", t_config.sa_Bpn[i][0]);
      FPRINTF_TO_TRAILFILE(trail_fid, "\t%3d", t_config.sa_Bpn[i][1]);
      FPRINTF_TO_TRAILFILE(trail_fid, "\t%2.3f", fa_S[i]);
      FPRINTF_TO_TRAILFILE(trail_fid, "\t%2lu", s_MuxFrameSize[i]);
      FPRINTF_TO_TRAILFILE(trail_fid, "\t%6lu\n", s_CodewordSize[i]);
   }


}

/*****************************************************************************
;  Prototype: void OLRPM_PrnShowtimeParams(uint8 uc_prnTxShowtimeParams, uint8 uc_prnRxShowtimeParams, int16 s_option)
;
;  This subroutine prints showtime configuration data to the trail file
;
;  Input Arguments:
;       None
;
;  Output Arguments:
;       None
;
;  Global Variables:
;
;
;****************************************************************************/

void OLRPM_PrnShowtimeParams(uint8 uc_prnTxShowtimeParams, uint8 uc_prnRxShowtimeParams, int16 s_option)
{

   uint8 uc_MsgType, i, j;
   int16 s_OLRState, s_FromTone, s_ToTone, s_Error, s_OLRStatus, s_OLRError;
   int16 sa_K[NUM_DATA_PATHS], sa_NFEC[NUM_DATA_PATHS];
   double fa_S[NUM_DATA_PATHS];
   Config_t t_config;

   FPRINTF_TO_TRAILFILE(trail_fid, "\n***********************************");

   if(uc_prnTxShowtimeParams)
   {
      if (s_option == 0)
         FPRINTF_TO_TRAILFILE(trail_fid, "\nInitial TX Showtime Parameters:\n");
      else if (s_option == OLR_BACKUP_CONFIG)
         FPRINTF_TO_TRAILFILE(trail_fid, "\nUS On Line Reconfiguration:\n");

      s_OLRStatus = STAT_OLRStatus_US;
      s_OLRError =  STAT_OLRError_US;
      t_config = gt_tx_config;

   }

   if(uc_prnRxShowtimeParams)
   {
      switch (s_option)
      {
         case 0:
            FPRINTF_TO_TRAILFILE(trail_fid, "\nInitial RX Showtime Parameters\n");
            break;

         case OLR_BACKUP_CONFIG:
            FPRINTF_TO_TRAILFILE(trail_fid, "\nDS On Line Reconfiguration");
            s_OLRStatus = STAT_OLRStatus_DS;
            s_OLRError =  STAT_OLRError_US;
            t_config = gt_rx_config;
            break;

         case PM_RESTOREL0_BACKUP_CONFIG:
            FPRINTF_TO_TRAILFILE(trail_fid,"\nDS Power Management - L0 Restore\n");
            break;

         case PM_L0TOL2_BACKUP_CONFIG:
            FPRINTF_TO_TRAILFILE(trail_fid,"\nDS Power Management - L0 to L2 \n");
            break;

         case PM_L2LPT_BACKUP_CONFIG:
            FPRINTF_TO_TRAILFILE(trail_fid,"\nDS Power Management - L2 Low Power Trim\n");
            break;
      }
   }

      FPRINTF_TO_TRAILFILE(trail_fid, "\n***********************************");

      if (s_option == OLR_BACKUP_CONFIG)
      {
         uc_MsgType = (uint8)(STATArray[s_OLRStatus] >>4) & 0x3; //OLR msg type index
         s_OLRState = (STATArray[s_OLRStatus]) & 0x3; //OLR task state

         FPRINTF_TO_TRAILFILE(trail_fid, "\nOLR Message Type:       %s", OLR_MsgTypeName[uc_MsgType]);
         if(!((STATArray[s_OLRStatus]>>8)&0x7))
            FPRINTF_TO_TRAILFILE(trail_fid, "\nOLR Message Xmit Count: %d", (STATArray[s_OLRStatus]>>8)&0x7);

         if (STATArray[s_OLRError])
         {
            FPRINTF_TO_TRAILFILE(trail_fid, "\nOLR State:              %s", OLR_ResultState[s_OLRState]);

            if ((STATArray[s_OLRStatus]>> 11)&0x1)
            {
               if (uc_prnTxShowtimeParams)
                  FPRINTF_TO_TRAILFILE(trail_fid, "\nOLR Response:       %s", "Sent");
               else if (uc_prnRxShowtimeParams)
                  FPRINTF_TO_TRAILFILE(trail_fid, "\nOLR Response:       %s", "Received");
            }
            else
            {
               if (uc_prnTxShowtimeParams)
                  FPRINTF_TO_TRAILFILE(trail_fid, "\nOLR Response:       %s", "Not Sent");
               else if (uc_prnRxShowtimeParams)
                  FPRINTF_TO_TRAILFILE(trail_fid, "\nOLR Response:       %s", "Not Received");
            }

            FPRINTF_TO_TRAILFILE(trail_fid, "\nOLR Error Code:         0x%x", STATArray[s_OLRError]);
         }

         FPRINTF_TO_TRAILFILE(trail_fid, "\n\n");

         if (!STATArray[s_OLRError]) {
            if (uc_MsgType == BITSWAP_REQ)
            {
               FPRINTF_TO_TRAILFILE(trail_fid, "Bitswap Test Passed\n\n");

               s_FromTone = TESTArray[TEST_BitSwapFromTone];
               s_ToTone   = TESTArray[TEST_BitSwapToTone];

               FPRINTF_TO_TRAILFILE(trail_fid, "Detail BitSwap Info:\n");
               FPRINTF_TO_TRAILFILE(trail_fid, "Tone\toldBi\tnewBi\n");
               FPRINTF_TO_TRAILFILE(trail_fid, "%4d\t", s_FromTone);
               FPRINTF_TO_TRAILFILE(trail_fid, "%5d\t", guca_RxBat[s_FromTone]+1);
               FPRINTF_TO_TRAILFILE(trail_fid, "%5d\n", guca_RxBat[s_FromTone]);
               FPRINTF_TO_TRAILFILE(trail_fid, "%4d\t", s_ToTone);
               FPRINTF_TO_TRAILFILE(trail_fid, "%5d\t", guca_RxBat[s_ToTone]-1);
               FPRINTF_TO_TRAILFILE(trail_fid, "%5d\n", guca_RxBat[s_ToTone]);
               return;
            }
            else if ((uc_MsgType == DRR_REQ) || (uc_MsgType == SRA_REQ))
            {
               FPRINTF_TO_TRAILFILE(trail_fid, "OLR Test Passed\n\n");
               FPRINTF_TO_TRAILFILE(trail_fid, "Detail %s Info:", OLR_MsgTypeName[uc_MsgType]);
            }

         }
         else
         {
            FPRINTF_TO_TRAILFILE(trail_fid, "Detail error info");

            s_Error = STATArray[s_OLRError]&0x3;
            FPRINTF_TO_TRAILFILE(trail_fid, "%s", OLRPM_ErrorName[s_Error]);
         }
      }
      else if ((s_option != OLR_BACKUP_CONFIG) && (s_option)) {
         FPRINTF_TO_TRAILFILE(trail_fid, "\nPower Management Parameters:\n");
         FPRINTF_TO_TRAILFILE(trail_fid, "DS Minimum PCB = %d dB, Maximum PCB = %d dB\n", gt_RxOLRPMVars.uc_min_PCB_val, gt_RxOLRPMVars.uc_max_PCB_val);
         FPRINTF_TO_TRAILFILE(trail_fid, "DS Minimum Lp[LP0] = %d, Maximum Lp[LP0] = %d\n", gt_rx_config.s_Lp[LP0_DATA_PATH], gt_rx_config.s_Lp[LP0_DATA_PATH]);
         FPRINTF_TO_TRAILFILE(trail_fid, "DS Minimum Lp[LP1] = %d, Maximum Lp[LP1] = %d\n", gt_rx_config.s_Lp[LP1_DATA_PATH], gt_rx_config.s_Lp[LP1_DATA_PATH]);
         FPRINTF_TO_TRAILFILE(trail_fid, "DS L0 PCB = %d dB\n", gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL0Symbols);
         FPRINTF_TO_TRAILFILE(trail_fid, "DS L2 PCB = %d dB\n", gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL2Symbols);
         FPRINTF_TO_TRAILFILE(trail_fid, "DS L2 Exit PCB = %d dB\n", gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL2toL0ExitSymbols);
         FPRINTF_TO_TRAILFILE(trail_fid, "DS L2 Exit BiGi Gain = %d (1:L2 gain, 0:L0 gain)\n", gt_RxOLRPMVars.t_L2PowerCutBack.ft_isL2Gain);
         FPRINTF_TO_TRAILFILE(trail_fid, "DS L2 FFT Gain = %d dB\n", gt_RxOLRPMVars.t_L2PowerCutBack.s_L2FFTGaindB);
         FPRINTF_TO_TRAILFILE(trail_fid, "DS L2 FDQ Gain = %d dB\n", gt_RxOLRPMVars.t_L2PowerCutBack.s_L2FdqGaindB);
         FPRINTF_TO_TRAILFILE(trail_fid, "FFT Scaleback = 0x%04X\n", gt_RxOLRPMVars.t_L2PowerCutBack.s_FftScalebackMask);
         FPRINTF_TO_TRAILFILE(trail_fid, "FDQ Multiplier = 0x%X\n", gt_RxOLRPMVars.t_L2PowerCutBack.s_fdqMultiplier);
         FPRINTF_TO_TRAILFILE(trail_fid, "PM Testing Passed\n");
         return;
      }

      FPRINTF_TO_TRAILFILE(trail_fid, "\nTesting Parameters:\n");
      FPRINTF_TO_TRAILFILE(trail_fid, "       deltaLp\tdeltaBp0\tdeltaBp1\n");

      for (i = 0; i <t_config.s_Nlp ; i++)
      {
         FPRINTF_TO_TRAILFILE(trail_fid, "LP#%d:  ", i);
         if (!gs_trail_deltaLp[i])
            FPRINTF_TO_TRAILFILE(trail_fid, "      -\t");
         else
            FPRINTF_TO_TRAILFILE(trail_fid, "%7d\t", gs_trail_deltaLp[i]);

         if (!gs_trail_deltaBpn[i])
            FPRINTF_TO_TRAILFILE(trail_fid, "       -\t");
         else
            FPRINTF_TO_TRAILFILE(trail_fid, "%8d\t", gs_trail_deltaBpn[i]);

         FPRINTF_TO_TRAILFILE(trail_fid, "       -\n");
      }

      for (i=0; i<t_config.s_Nlp; i++)
      {
         sa_K[i]=0;
         for (j=0; j<t_config.s_Nbc; j++)
            sa_K[i] = sa_K[i] + t_config.sa_Bpn[i][j];

         if (sa_K[i])
            sa_K[i]++;
      }

      // Number of octets per FEC data frame and interleaved FEC Data Frame in path p
      for (i=0; i<t_config.s_Nlp; i++)
         sa_NFEC[i] = (t_config.s_Mp[i] * sa_K[i]) + t_config.s_Rp[i];

         // Number of bits over which the FEC data frame spans
         for (i=0; i<t_config.s_Nlp; i++)
         {
            if (t_config.s_Lp[i] != 0)
               fa_S[i] = ((double)sa_NFEC[i] * 8) / (double)(t_config.s_Lp[i]);
            else  // This path is disable or not linked up, so clear the variable
               fa_S[i] = 0;
         }

      FPRINTF_TO_TRAILFILE(trail_fid, "\nTesting Results:");
      FPRINTF_TO_TRAILFILE(trail_fid, "\n             oldLp\tnewLp\toldBp0\tnewBp0\toldBp1\tnewBp1\tnewS\tCWSize\tK\n");
      for (i = 0; i <t_config.s_Nlp ; i++)
      {

         FPRINTF_TO_TRAILFILE(trail_fid, "DS LP #%d:    ", i);
         FPRINTF_TO_TRAILFILE(trail_fid, "%5d\t", t_config.s_Lp[i] - gs_trail_deltaLp[i]);
         FPRINTF_TO_TRAILFILE(trail_fid, "%5d\t", t_config.s_Lp[i]);
         FPRINTF_TO_TRAILFILE(trail_fid, "%6d\t", t_config.sa_Bpn[i][i] - gs_trail_deltaBpn[i]);
         FPRINTF_TO_TRAILFILE(trail_fid, "%6d\t", t_config.sa_Bpn[i][i]);
         FPRINTF_TO_TRAILFILE(trail_fid, "%6d\t", t_config.sa_Bpn[i][i+1]);
         FPRINTF_TO_TRAILFILE(trail_fid, "%6d\t", t_config.sa_Bpn[i][i+1]);
         FPRINTF_TO_TRAILFILE(trail_fid, "%2.3f\t", fa_S[i]);
         FPRINTF_TO_TRAILFILE(trail_fid, "%6d\t", sa_NFEC[i]);
         FPRINTF_TO_TRAILFILE(trail_fid, "%d\n", sa_K[i]);
      }

      FPRINTF_TO_TRAILFILE(trail_fid, "\n");

}




/*****************************************************************************
;  Prototype: void PrintPGAInfo(void)
;
;  This subroutine prints PGA information to the trail file
;
;  Input Arguments:
;       None
;
;  Output Arguments:
;       None
;
;  Global Variables:
;
;
;****************************************************************************/
void PrintPGAInfo(void)
{
   FPRINTF_TO_TRAILFILE(trail_fid, "PGA Setting:                       %d dB\n", gs_PGA_set >> 8);
   FPRINTF_TO_TRAILFILE(trail_fid, "PGA Required:                      %d dB\n", gs_PGA_required >> 8);
}
#endif  /*  LEAVE_TRAIL */


#ifdef LEAVE_TRAIL
/*****************************************************************************
;  Prototype: void PrnTxOvflow(uint16* pusa_TxOverflowCnts)
;
;  This subroutine
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Global Variables:
;
;
;****************************************************************************/
void PrnTxOvflw(uint16* pusa_TxOverflowCnts)
{
   FPRINTF_TO_TRAILFILE(trail_fid, "\t IFFT:           %d\n", pusa_TxOverflowCnts[0]);
   FPRINTF_TO_TRAILFILE(trail_fid, "\t POTS HPF:       %d\n", pusa_TxOverflowCnts[1]);
   FPRINTF_TO_TRAILFILE(trail_fid, "\t Tx Scalar Gain: %d\n", pusa_TxOverflowCnts[2]);
   FPRINTF_TO_TRAILFILE(trail_fid, "\t AEC:            %d\n", pusa_TxOverflowCnts[3]);
   FPRINTF_TO_TRAILFILE(trail_fid, "\t DEC:            %d\n", pusa_TxOverflowCnts[4]);
   FPRINTF_TO_TRAILFILE(trail_fid, "\n");
}

#endif // LEAVE_TRAIL




#ifdef LEAVE_TRAIL
/*****************************************************************************
;  Prototype: void PrnRxOvflow(uint16 *pusa_RxOverflowCnts)
;
;  This subroutine
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Global Variables:
;
;
;****************************************************************************/
void PrnRxOvflw(uint16 *pusa_RxOverflowCnts)
{
   FPRINTF_TO_TRAILFILE(trail_fid, "\t SRC:       %d\n", pusa_RxOverflowCnts[0]);
   FPRINTF_TO_TRAILFILE(trail_fid, "\t TDQ:       %d\n", pusa_RxOverflowCnts[1]);
   FPRINTF_TO_TRAILFILE(trail_fid, "\t FFT:       %d\n", pusa_RxOverflowCnts[2]);
   FPRINTF_TO_TRAILFILE(trail_fid, "\t FDQ:       %d\n", pusa_RxOverflowCnts[3]);
   FPRINTF_TO_TRAILFILE(trail_fid, "\t GainScale: %d\n", pusa_RxOverflowCnts[4]);
   FPRINTF_TO_TRAILFILE(trail_fid, " \n");
}

#endif // LEAVE_TRAIL

#ifdef LEAVE_TRAIL
/*****************************************************************************
;  Prototype: void PrnOvflwTrainResults_DMT(void)
;
;  This subroutine
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Global Variables:
;
;
;****************************************************************************/
void PrnOvflwTrainResults_DMT(void)
{
   FPRINTF_TO_TRAILFILE(trail_fid, "\n Overflow Information in Training States: \n");
   FPRINTF_TO_TRAILFILE(trail_fid, " (Count is number of frames in a state for which \n");
   FPRINTF_TO_TRAILFILE(trail_fid, " given overflow occurred at least once) \n");

   // Print the Tx State Overflow Info
   FPRINTF_TO_TRAILFILE(trail_fid, "\n Selected Tx States:\n");

   // RReverb2Tx
   FPRINTF_TO_TRAILFILE(trail_fid, " RReverb2Tx:\n");
   PrnTxOvflw(gusa_RReverb2_TxOverflowCnts);

   // REctTx
   FPRINTF_TO_TRAILFILE(trail_fid, " REctTx:\n");
   PrnTxOvflw(gusa_REct_TxOverflowCnts);

   // RMedleyTx
   FPRINTF_TO_TRAILFILE(trail_fid, " RMedleyTx:\n");
   PrnTxOvflw(gusa_RMedley_TxOverflowCnts);

   // Print the Rx State Overflow Info
   FPRINTF_TO_TRAILFILE(trail_fid, "\n Selected Rx States:\n");

   // RCReverb2Rx
   FPRINTF_TO_TRAILFILE(trail_fid, " RCReverb2Rx:\n");
   PrnRxOvflw(gusa_RCReverb2_RxOverflowCnts);

   // RCPilot3Rx
   FPRINTF_TO_TRAILFILE(trail_fid, " RCPilot3Rx:\n");
   PrnRxOvflw(gusa_RCPilot3_RxOverflowCnts);

   // RCReverb3Rx
   FPRINTF_TO_TRAILFILE(trail_fid, " RCReverb3Rx:\n");
   PrnRxOvflw(gusa_RCReverb3_RxOverflowCnts);

   // RCMedleyRx
   FPRINTF_TO_TRAILFILE(trail_fid, " RCMedleyRx:\n");
   PrnRxOvflw(gusa_RCMedley_RxOverflowCnts);

}


/*****************************************************************************
;  Prototype: void PrnOvflwShowtimeResults_DMT(void)
;
;  This subroutine
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Global Variables:
;
;
;****************************************************************************/
void PrnOvflwShowtimeResults_DMT(void)
{
   FPRINTF_TO_TRAILFILE(trail_fid, "\n Overflow Information in Showtime States: \n");
   FPRINTF_TO_TRAILFILE(trail_fid, " (Count is number of frames in a state for which given overflow occurred at least once)\n");

   // RShowtimeTx
   FPRINTF_TO_TRAILFILE(trail_fid, " RShowtimeDMTTx:\n");
   PrnTxOvflw(gusa_TxOverflowCnts);

   // RCShowtimeRx
   FPRINTF_TO_TRAILFILE(trail_fid, " RShowtimeDMTRx:\n");
   PrnRxOvflw(gusa_RxOverflowCnts);

}


#endif //LEAVE_TRAIL

