/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   act_T1413.c
 *
 *   The Activation Sequence for both TX and RX.
 *   Complying with T1.413 Issue 2
 *
 *------------------------------------------------------------------------
 */
// ******************************************************************
// act_T1413.c
//
// History
// 15/07/2011 Kannan: T1413 bring up and T1413 mode loop length estimation.
//           Grep for XDSLRTFW-254 XDSLRTFW-221 Feature_ALL_T1413_ALL_Bringup
// 02/01/2011 Kannan: 14/04/2008 Ram: In long 24 DSL loops 16kft, IFX DSLAM is unable to detect RACK1 from CPE
//                   thus it does not send C-REVEILLE, which causes training failure. Boosting up
//                   the level of RACK1 by 6dB helps fix this issue.
//                   Grep for IOP_US_T1413_ALL_HigherRACK1_Level
// 02/01/2012 Kannan: 25/08/2008 Sabrina Y.: Toggle gft_T1413_ACK_boost after sending R-ACK
//                        In T1413 mode, R-ACK power level is boosted by 6 dB by default since some IFX
//                        CO has problem in detecting R-ACK at long loops with high noise. However,
//                        some STM COs are sensitive to this signal power and fail to detect R-Reverb1.
//                        So we have to toggle the level till C-Pilot1 off is detected.
//                        grep for SMS00801603 IOP_DS_ALL_T1413_PwrBoostPingPong
//
//16/01/2012 Shakil/Balabath:Non Standard T1413 GHS Activation switching required by Telefonica Spain.
//          By default , if no CO activation tones detected the CPE switches between T1413 and GHS activation
//          at every two seconds (i.e. 2 seconds of t1413 followed by 2 seconds of GHS and so on...).
//          This feature changes the switching time from 2 seconds to 60 seconds
//          (i.e. 60 seconds of t1413 followed by 60 seconds of GHS and so on...).
//          This feature is CMV controlled and by default disabled.
//          CNFG 58 0 -> bit 0  (Non standard T1413-GHS activation switching enabled/disabled)
//                   0: disabled (default)
//                   1: enabled
//          CNFG 58 0-> bit 1 (T1413/GHS Activation startup)
//                   0 -> GHS Activation startup (Default)
//                   1-> T1413 activation startup
//       For code changes Grep for XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching
//
//09/02/2012 Balabath: XTSE-status (STAT 1) must be updated during init/training/showtime according to following table:
//           1. while sending out G.Hs activation tones: (XTSE-status = all G.Hs modes as configured by API, e.g. DMT-Anx-A + BIS-AnxA + PLUS-AnxA + VDSL, NO T1.413)
//          2. while sending out T1.413 activation signal: (XTSE-status = T1.413 mode)
//          3. in G.Hs: (XTSE-status = all G.Hs modes as configured by API, e.g. DMT-Anx-A + BIS-AnxA + PLUS-AnxA + VDSL)
//          4. in ADSL training: (XTSE-status = ADSL mode of current training, i.e. outcome of modeselect in G.HS or T1.413)
//          5. in T1.413 training: (XTSE-status = T1.413 mode)
//          6. in ADSL showtime: (XTSE-status = ADSL mode, same as 4.)
//          7. in T1.413 showtime: (XTSE-status = T1.413 mode)
//          For code changes grep for "XDSLRTFW-415 Enh_all_all_STAT1_update"
//
// 04/06/2012 Shakil: New feature implemented where we detect REIN noise at training and change framing
//          accordingly taking erasure decoding into account to increase stability in presence of REIN
//          even if the minINP exchanged during GSK was not enough to sustain the REIN. The background
//          of this feature was a test requirement from FT EMC lab at Laneon where the minINP and maxdelay
//          configured was 2 and 16ms respectively whereas REIN in the line was 4-5 DMT symbol duration.
//          In the regular condition considering erasure we may protect maximum 3 DMT symbol REIN therefore
//          resulting huge DS CRCs and link drop. With the new feature we could dynamically detect REIN at
//          CSilent1 state during handshake and increase the INP taking erasure into account while cap the
//          delay maximum to 8 ms and achieved CRC free stable link without sacrifising too much data rate
//          since we also ignore REIN affected symbols before bitloading and medley SNR calculation.There are
//          two parts of the implmentation
//          1. Detect REIN during GSK and adapt framing  prior to bitloading at Medley. It is controlled by
//                INFO 103 28 bitmask 0x200 and disabled by default (bitmask 0x200-> 0 disabled, 1 enabled)
//          2. Ignore REIN affected symbols for bitloading: No CMV controlled. Enabled by default
//          Grep for XDSLRTFW-471 Enhance_DS_ALL_ALL_REIN_IMMUNITY_TRAINING
//
// 16/09/2013 Prashant: Fix for Jira XDSLRTFW-1163 - Two "actually used" modes indicated. Update Stat1 only after
//            detection of T1413.
//            Grep for XDSLRTFW-1163 Fix_all_all_STAT1_update (Start)
//
// 08/01/2014 Balabath: Fix for XDSLRTFW-1487. In ZTE labs customer expectation is link should come up in T1413 mode
//  when CPE is configured in T1413+VDSL2 and CO is ADSL2p+T1413. After Debug it is found,
//  -CPE switches from VDSL firmware to ADSL firmware after 3 failures.
//  - After ADSL firmware is loaded T1413 state machine started.
//  - If no response is found within 2sec CPE switches to GHS tones and ends with no common mode,
//  After debugging it is found that CO response for RActReq after FW switch to ADSL is close to 40s.
//  Where as in second retrain it is less than a 1sec.
//  Workaround added if only T1413 and VDSL2 are enabled then wait for 60s in RActReq state.
//  For code changes grep for "XDSLRTFW-1487"
//
// 13/1/2017 Shriram Shastry : The CPE could not link up in G.DMT mode with 4.17.18.7 UGW7.1.1 [PPA API driver info: 96.32.7.3.0.0.4]
//          When  FW makes transition from VDSL to ADSL and CO is configued in ADSL1 Mode,
//          FW is 'NOT' communicating the required TC-Mode and  autonomous message to DSL API.
//          Grep for XDSLRTFW-3068
//
// **************************************************************************************************************
#include "common.h"
#include "rt_state.h"
#include "xrtstate.h"
#include "rt_tones.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "gdata.h"
#include "xgdata.h"
#include "states.h"
#include "stateini.h"
#include "fifo.h"
#include "act_T1413.h"
#include "detect.h"
#include "TxTneSt.h"
#include "post_hsk.h"
#include "RQuiet2TxF.h"
#include "RSilent0TxF.h"
#include "RCSilent1RxF.h"
#include "RCPilot1RxF.h"
#include "RCPilot1InitRxF.h"
#include "SetPgaForToneDetection.h"
#include "pga_set.h"
#include "snr.h"
#include "cmv.h"
#include "afe.h"
#include "pll.h"
#include "gpersistent.h"
#include "hndshk_Data.h"
#include "T1413.h"
#include "accum32.h"
#include "memsetbf.h"
#include "bufmisc.h"

#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"

#ifdef BIS_CODESWAP
#include "codeswap.h"
#include "soc_codeswap.h"
#endif

extern gus_DelayCPilot1Det;
extern int32 VectorPower(int16 *s_databuf, int16 s_offset, int16 s_ndata, int16 s_GuardBits);
//XDSLRTFW-254 XDSLRTFW-221 Feature_ALL_T1413_ALL_Bringup (START - END)
#define LOG2_T1413_ROUGH_LOOP_ESTIMATE_LEN (0)

/*^^^
*-------------------------------------------------------------------
########               ########
######## TX ROUTINES   ########
########               ########
*-------------------------------------------------------------------
*^^^
*/

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RActReqTxF
 *
 *  Description:
 *    R_ACT_REQ is used for ATU-R to initiate a link to the ATU-C.
 *
 *  Prototype: RActReqTxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount  - number of symbold in current Tx state
 *      gs_RxState        - Rx state
 *      gs_TxNextState    - next Tx state
 *      gs_TxOutBuf[]     - time domain samples to transmit, used in TxMultiTones()
 *      gs_TxToneBuf[]    - frequency domain samples, used in TxMultiTones()
 *      gsa_IFFT_OutBuf[] - output of IFFT, used in TxMultiTones()
 *      gusa_txgain[]     - (I) used for power cutback
 *
 *  Notes: implements state R_ACT_REQ_TX
 *
 *------------------------------------------------------------------------
 *^^^
 */

void RActReqTxF(void) {

   int16 s_SymCnt;

    /* ---- transmit silence ---- */
    if (gl_TxSymbolCount == 0)
   {
      gt_TaskArray[TX_FRAME_START].TimeCriticalTask=TxProcessTones;

      /* enable IFFT */
      gft_IFFT_On = TRUE;
      //XDSLRTFW-415 Enh_all_all_STAT1_update(start)
      // XDSLRTFW-1163 Fix_all_all_STAT1_update (Start)
#ifdef HERC_API
//      gt_HercADSL_STATMap_ModeSelect.s_Offset0 = (gt_HercADSL_OPTNMap_ModeControl.s_Offset0 & 0x1);
//      gt_HercADSL_STATMap_ModeSelect.s_Offset1 = 0;
#endif
   // XDSLRTFW-1163 Fix_all_all_STAT1_update (End)
      //XDSLRTFW-415 Enh_all_all_STAT1_update(end)
   }

   /* Start with quiet to simulate 100ms silence in HS/T1 multimode. */
   s_SymCnt = (gl_TxSymbolCount + R_ACT_REQ_ACT_TX_LEN) % R_ACT_REQ_TX_LEN;

   if ( s_SymCnt ==  0 )  {
      // transmit at higher power level
#if defined(TX_NOISESHAPER_RESET)
      WriteAfe(DANUBEA_SOFT_RESETS, 0x0000);    /* enable Tx-Noise-Shaper */
#endif
      TxToneSetUp((int16) R_ACT_REQ_TONE,0,POWER_LEVEL_HIGH);
   }

   // transmit at lower POWER_LEVEL_LOW
   else if ( s_SymCnt == R_ACT_REQ_ACT_TX_HALFLEN)
      TxToneSetUp((int16) R_ACT_REQ_TONE,0,POWER_LEVEL_LOW);

   // transmit quiet
   else if ( s_SymCnt == R_ACT_REQ_ACT_TX_LEN)
      TxToneSetUp((int16) R_ACT_REQ_TONE,0,0);

}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RQuiet1TxF
 *
 *  Description:
 *    R_QUIET1_TX is a quiet state where no signal is transmitted.
 *    It either waits for C_ACT to enter R_ACK or re-enter R_ACT_REQ
 *      after R_QUIET1_TX_LEN;
 *
 *  Prototype: RSilent0TxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount - number of symbold in current Tx state
 *      gs_RxState       - Rx state
 *      gs_TxNextState   - next Tx state
 *
 *  Notes: implements state R_QUIET1_TX
 *
 *------------------------------------------------------------------------
 *^^^
 */

void RQuiet1TxF(void) {
   // transmit quiet
   if(gl_TxSymbolCount == 0)
      TxToneSetUp( (int16) R_ACT_REQ_TONE,0,0 );

   // proceed to R_ACK_TX upon detection of C_ACT
   if (gs_RxState == R_C_REVEILLE_RX) {
      gs_TxNextState = R_ACK_TX;
      gpF_TxStateFunc = (PtrToFunc)RAckTxF;
   }

   else if (gl_TxSymbolCount == R_QUIET1_TX_LEN - 1) {
      gs_TxNextState = R_ACT_REQ_TX;
      gpF_TxStateFunc = (PtrToFunc)RActReqTxF;

   }
}


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : R_ACK_TX
 *
 *  Abstract :
 *
 *  R_ACK_TX is used as an acknowledgement of the detection of C_ACT, in order
 *  to continume initiating a communication link to the ATU-C.  Three signals
 *  are defined: R_ACK1, R_ACK2, R_ACk3.
 *
 *  Returns: None
 *
 *  Global Variables Used:
 *      gs_TxOutBuf[]  -   The current symbol (bit) that is to be modulated
 *                         onto the carrier set frequencies.
 *
 *  Notes :
 *
 *------------------------------------------------------------------------
 *^^^
 */

void RAckTxF(void) {

   int16 s_Tone;

   if (OPTNArray[OPTN_StateMachineCtrl] & OPTN_PilotOnDecTraining_DMT)
   {
      gft_PilotOnDecTraining = TRUE;
#ifndef ISDN
      s_Tone = R_ACK2_TONE;
#else
        if (gft_Tones1To32SupportRT)  //support Tone 1-32
            s_Tone = R_ACK2e_TONE;
        else
            s_Tone = R_ACK2m_TONE;
#endif
   }
   else
   {
      gft_PilotOnDecTraining = FALSE;
#ifndef ISDN
      s_Tone = R_ACK1_TONE;
#else
        if (gft_Tones1To32SupportRT)  //support Tone 1-32
            s_Tone = R_ACK1e_TONE;
        else
            s_Tone = R_ACK1m_TONE;
#endif
   }

   if(gl_TxSymbolCount == 0) {
      // R3_P1: AR8_TF: IOP_US_T1413_ALL_HigherRACK1_Level
      // In long 24 DSL loops 16kft, IFX DSLAM is unable to detect RACK1 from CPE
      // thus it does not send C-REVEILLE, which causes training failure. Boosting up
      // the level of RACK1 by 6dB helps fix this issue.

      //SMS00801603 IOP_DS_ALL_T1413_PwrBoostPingPong (START)
      //Some STM COs are sensitive to the R-ACK power level and may not be able to
      //detect R-Reverb1 sent out later. Hence we have to toggle it till C-Pilot1
      //off is detected.
#ifndef ISDN    // Only for Anx-A
      if (gft_T1413_ACK_boost)
        TxToneSetUp(s_Tone, 0, (POWER_LEVEL_HIGH << 1));
      else
        TxToneSetUp(s_Tone, 0, POWER_LEVEL_HIGH);
      gft_T1413_ACK_boost ^= 0x01;
#else
      TxToneSetUp(s_Tone,0,POWER_LEVEL_HIGH) ;
#endif  // ifndef ISDN
      //SMS00801603 IOP_DS_ALL_T1413_PwrBoostPingPong (END)
   }
   else if(gl_TxSymbolCount == R_ACK_TX_HALFLEN) {

      TxToneSetUp(s_Tone,0,POWER_LEVEL_LOW);
   }
   // Transit to R_QUIET2
   else if(gl_TxSymbolCount == R_ACK_TX_LEN-1) {

      gs_TxNextState = R_QUIET2_TX;
      gpF_TxStateFunc = (PtrToFunc) RQuiet2TxF;
   }
}



/*^^^
*-------------------------------------------------------------------
########               ########
######## RX ROUTINES   ########
########               ########
*-------------------------------------------------------------------
*^^^
*/


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : R_C_ACT_RX
 *
 *  Abstract :
 *
 *  R_C_ACT_RX detects either C_TONE or C_ACT signal.
 *  Upon the detection of C_TONE or C_ACT
 *  the Rx enters the R_QUIET1_TX or R_ACK_TX state.respectively
 *
 *  Global Variables Used:
 *      gpsa_FFT_InBuf[]   - input of IFFT
 *      gs_RxToneBuf[]    - frequency domain samples
 *      ( above two are used in DetectTones() )
 *      gs_RxSubState     - (I/O) current RX substate
 *      gs_RxSubStateCnt  - (I/O) # symbols in current RX substate
 *      gl_RxSymbolCount  - (I) # symbol periods in current RX state
 *      gs_RxNextState    - (O) RX state that will begin next symbol period
 *
 *  Notes :
 *
 *------------------------------------------------------------------------
 *^^^
 */
#ifndef ISDN   // Only for Anx-A
// R3_P1: AR8_TF: IOP_DS_T1413_ALL_CActCPilot1DetectionProblems

int16 gs_T1413ToneDetectScale = 6;
#else // Anx-B
int16 gs_T1413ToneDetectScale = 60;
#endif // ifndef ISDN

#define CACT_ACCUM      0
#define CACT_DETECT     1
int16 DetectCAct(void)
{
   int16 s_ActType;

   s_ActType = -1;
   switch (gs_DetectCACT_State)
   {
   case CACT_ACCUM:
      /* clear accum buffer before first accumulation */
      if (gs_DetectCACT_AccumCount == 0 )
      {
         MemSetBuffer((int16 *)(void *)gla_RxAccumBuf, 0, 0, (int16)(sizeof(int32)*RX_FFT_LENGTH));
      }

      /* Accumulate recieved signal for 8 frames */
      Accum16to32((int32 *)gla_RxAccumBuf, 0,   gsa_RxToneBuf, 0, RX_FFT_LENGTH);
      gs_DetectCACT_AccumCount++;

      /* Accumulation done, goto next state */
      if ((gs_DetectCACT_AccumCount % (1<<CACT_LOG2_NUM_ACCUM_SYMBOLS)) == 0)
      {
         /* Average accumulated signal */
         guc_AccumState = TRAINING_IN_PROGRESS;
         AddFunctionToBkgdFifo((PtrToBkgdFunc)BgRightShiftAndRound32to16);

         gs_DetectCACT_State = CACT_DETECT;
      }
      break;

   case CACT_DETECT:
      if(guc_AccumState == TRAINING_DONE)
      {
#ifndef ISDN
         //--- Detect either C_T1413_TONE or C_ACT --------
         if (DetectTone(gsa_RxRepFrameAlignBuf, C_ACT2_TONE, C_ACT2_TONE - HALF_DETECT_BAND,
            C_ACT2_TONE + HALF_DETECT_BAND, (int16)(gs_T1413ToneDetectScale*256)))
            s_ActType = C_ACT2 ;

         // The leakage of the pulsed Tx Tone while using 64 pt IFFT into DS band
         // causes false detection of the T1413 pilot tone. (reference Pui)
         // Hence we do not detect for this tone
         /*
         else if ( s_ToneDetected = DetectTone(gsa_RxToneBuf, C_T1413_TONE, C_T1413_TONE - HALF_DETECT_BAND,
         C_T1413_TONE + HALF_DETECT_BAND, (int16)(gs_ToneDetectScale*256)) )
         s_ActType = C_ACT_TONE;
         */
         else if (DetectTone(gsa_RxRepFrameAlignBuf, C_ACT4_TONE, C_ACT4_TONE - HALF_DETECT_BAND,
            C_ACT4_TONE + HALF_DETECT_BAND, (int16)(gs_T1413ToneDetectScale*256)) )
            s_ActType = C_ACT4;
#else
           //--- Detect either C_T1413_TONE or C_ACT --------
         if (DetectTone(gsa_RxRepFrameAlignBuf, C_ACT2e_TONE, C_ACT2e_TONE - HALF_DETECT_BAND,
            C_ACT2e_TONE + HALF_DETECT_BAND, (int16)(gs_T1413ToneDetectScale*256)))
            {
                gft_Tones1To32SupportCO =1;
            s_ActType = C_ACT2 ;
            }

         else if (DetectTone(gsa_RxRepFrameAlignBuf, C_ACT2m_TONE, C_ACT2m_TONE - HALF_DETECT_BAND,
            C_ACT2m_TONE + HALF_DETECT_BAND, (int16)(gs_T1413ToneDetectScale*256)) )
            {
            gft_Tones1To32SupportCO =0;
                s_ActType = C_ACT2;
            }
#endif
         else
            s_ActType = 0;

         gs_DetectCACT_State = CACT_ACCUM;
         gs_DetectCACT_AccumCount = 0;
      }
   }

   return(s_ActType);
}

#define RX_CALCMAXPGA      0
#define RX_SETMAXPGA    1
#define RX_DETECT_ACT      2
#define RX_COUNT_SYMBOLS   3
#define RX_DETECT_C_QUIET2 4


void RCActRxF(void) {
   int16 s_ActType;
//XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching (Start)
   uint32 ul_ActTimeout;

   if ((gus_Cnfg_Misc & CNFG_MISC_NON_STANDARD_HSK_MASK)||(gul_ModeControl == (uint32)(OPTN_ConfigMode_T1413|OPTN_ConfigMode_G993_2<<16))) //XDSLRTFW-1487
      ul_ActTimeout = 120*TIME_500MS;
   else
      ul_ActTimeout = 4*TIME_500MS;

//XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching (End)

   if (gl_RxSymbolCount == 0)
   {
      gs_DetectCACT_State = CACT_ACCUM;
      gs_DetectCACT_AccumCount = 0;
   }


#ifndef TARGET_HW //Cocomo Only
   /* No averaging for test vector tests since this would require a change of input testvectors */
   if (DetectTone(gsa_RxToneBuf, C_ACT2_TONE, C_ACT2_TONE - HALF_DETECT_BAND,
         C_ACT2_TONE + HALF_DETECT_BAND, (int16)(gs_ToneDetectScale*256)))
      s_ActType = C_ACT2 ;

   // The leakage of the pulsed Tx Tone while using 64 pt IFFT into DS band
   // causes false detection of the T1413 pilot tone. (reference Pui)
   // Hence we do not detect for this tone
   /*
   else if (DetectTone(gsa_RxToneBuf, C_T1413_TONE, C_T1413_TONE - HALF_DETECT_BAND,
      C_T1413_TONE + HALF_DETECT_BAND, (int16)(gs_ToneDetectScale*256)) )
      s_ActType = C_ACT_TONE;
         */
   else if ( DetectTone(gsa_RxToneBuf, C_ACT4_TONE, C_ACT4_TONE - HALF_DETECT_BAND,
         C_ACT4_TONE + HALF_DETECT_BAND, (int16)(gs_ToneDetectScale*256)) )
      s_ActType = C_ACT4;
   else
      s_ActType = 0;
#else

      /* average recieved signal and perform multi-tone detection */
      /* returns -1 -- no detection performed, 0 -- no tones detected, 2 or 4 -- tones detected */
      s_ActType = DetectCAct();
#endif

   if (gs_RxSubState >= RX_DETECT_ACT) SetPgaForToneDetection();
   switch (gs_RxSubState)  {

      case RX_CALCMAXPGA:
         //XDSLRTFW-3727 T1413_perf_improvement
         gs_PGA_required = AFED_SetInitialPgaToMax();//23*256; ///* initial PGA */
         guc_PgaTrainingState = TRAINING_IN_PROGRESS;
         AddFunctionToBkgdFifo((PtrToBkgdFunc)AFED_BgPGA);
         gs_RxSubState = RX_SETMAXPGA;
      break;

      case RX_SETMAXPGA:

         if (guc_PgaTrainingState == TRAINING_DONE)
            {
             //XDSLRTFW-3727 T1413_perf_improvement
             AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_SetPga);
            gs_RxSubStateCnt = 0;
             //XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching (Start_End)
            gul_T1413_ACT_TimeOUT_Cnt = 0;
            gs_RxSubState = RX_DETECT_ACT;
         }
      break;

      case RX_DETECT_ACT:

         if ( s_ActType > 0)
            {
            gs_C_ACT_flag = s_ActType;
            gs_RxDetectCnt = 0;
            gs_RxSubState = RX_COUNT_SYMBOLS;
         }
         else
         {
         /* If C-ACT is not detected for 2 seconds and not in T1.413 only mode, switch */
         /* to handshake. */
            //XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching (Start_End)
            if ((gul_T1413_ACT_TimeOUT_Cnt >= ul_ActTimeout) && (gs_SetPgaForTones_State == SETPGATONES_LEVEL_OK))
                {
//#ifdef ISDN
//          if (gul_ModeControl & ~(OPTN_ConfigMode_ETSI_AnnexC<<16))
//#else
//             if (gul_ModeControl & ~OPTN_ConfigMode_T1413)
//#endif
               if (gul_ModeControl & ~(OPTN_ConfigMode_T1413 | (OPTN_ConfigMode_ETSI_AnnexC<<16)))
               {
//XDSLRTFW-471 Enhance_DS_ALL_ALL_REIN_IMMUNITY_TRAINING (Start_End): If non standard Ghsk feature is enabled
//(60s hsk and t1413 switching period) then we have enough time to detect REIN (2 seconds in RCSilentRxF) if the
//starting mode is Gsk. Otherwise we must skip the short silence delay of 100ms during T1413-GHSK transition
//in order to have enough time to detect REIN duration if Rein Immunity flag is TRUE
                  if ((gus_Cnfg_Misc == 1) ||
                     (((gus_Cnfg_Misc == 3) || !(gus_Cnfg_Misc & CNFG_MISC_NON_STANDARD_HSK_MASK))
                        && (!(gt_INFX_CMV.us_OperatorSpBits6 & CMV_TO_ENABLE_REIN_DETECTION_TRAINING_AND_CHANGE_FRAMING))))
                     gft_ShortRSilent0 = TRUE;

                  gs_TxNextState = R_SILENT0_TX;
                  gs_RxNextState = R_C_SILENT1_RX;

                  gpF_TxStateFunc = (PtrToFunc) RSilent0TxF;
                  gpF_RxStateFunc = (PtrToFunc) RCSilent1RxF;
                  //XDSLRTFW-2033 (Start)
                  gul_ToneDetectSymbCount = 0;
                  gul_PGAResetSec = TIME_8S;
                  //XDSLRTFW-2033 (End)
               }

               else // G.hs not supported.  Jump back to first substate to reset PGA to max.
               {
                  gs_RxSubState = RX_CALCMAXPGA;
               }
            }
            gs_RxSubStateCnt++;
            //XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching (Start_End)
            gul_T1413_ACT_TimeOUT_Cnt++;
         }
      break;


      case RX_COUNT_SYMBOLS:
         if(s_ActType > 0)
         {
            if (gs_C_ACT_flag == s_ActType)
               gs_RxDetectCnt++;
            else
               gs_RxSubState = RX_DETECT_ACT;
         }
         else if (s_ActType == 0)
            gs_RxSubState = RX_DETECT_ACT;

         if (gs_RxDetectCnt == R_C_ACT_DET_CNT - 1)
            {
            STATArray[STAT_Misc] |= STAT_T1413_Signal_Detected;

            if (gs_C_ACT_flag == C_ACT_TONE)
                {
               // C_T1413_TONE is detected.  This causes CPE to go quiet for a
               // minute, or until C-ACT is detected to initiate the link.
               gs_TxNextState = R_QUIET1_TX;
               gpF_TxStateFunc = (PtrToFunc) RQuiet1TxF;

               gs_C_ACT_flag = -1;
               gs_RxSubState = RX_DETECT_ACT;
            }
            else
                {
               gs_RxSubState = RX_DETECT_C_QUIET2;
               gs_RxSubStateCnt = 0;
            }
         }
      break;

      case RX_DETECT_C_QUIET2:
      /* The detection of C_QUIET2 does not serve any purpose right now.
           We don't go back to initial startup if we timeout here,
           neither do we use any kind of timing information for the duration of C_ACT.
           -> Change it to waiting a certain number of symbols, and then
           send R_ACK_TX and start looking for C_REVEILLE.
           The number of symbols should be large enough to make sure C_ACT has
           finished before sending R_ACK, and small enough to make sure that we will
           not miss REVEILLE: if C_ACT has been detected immediately, then 120
           (128-R_C_ACT_DET_CNT) symbols is the proper. If we were late in detecting
           C_ACT, then 120 symbols might risk the CO detection of R_ACK. */
        gs_RxSubStateCnt++;
        if((gs_RxSubStateCnt >= gs_r_c_quiet2_wait) && (gs_SetPgaForTones_State == SETPGATONES_LEVEL_OK)){
         gs_TxNextState = R_ACK_TX;
         gs_RxNextState = R_C_REVEILLE_RX;

         gpF_TxStateFunc = (PtrToFunc) RAckTxF;
         gpF_RxStateFunc = (PtrToFunc) RCReveilleRxF;

        }
      break;
   }


}

#undef CACT_ACCUM
#undef CACT_DETECT

#undef RX_DETECT_ACT
#undef RX_COUNT_SYMBOLS
#undef RX_DETECT_C_QUIET2


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : R_C_REVEILLE_RX
 *
 *  Abstract :
 *
 *  R_C_REVEILLE_RX detects the C_REVEILLE_TONE and enters R_C_PILOT1 only after it has detected the
 *  C_Pilot1/1A or C-Quiet3 signal from the ATU-C.
 *
 *  Global Variables Used:
 *      gs_RxToneBuf[]    - frequency domain samples
 *
 *  Notes :
 *
 *------------------------------------------------------------------------
 *^^^
 */



#define PLUS_HALF_DB     (17355)
#define RX_DETECT_REVEILLE    0
#define RX_WAIT               3
#define RX_DETECT_PILOT       4
#define RX_WAIT_FOR_SWAPS     5
#define RX_WAIT_FOR_SWAPS_1      6
void RCReveilleRxF(void) {

    STATArray[STAT_MacroState] = STAT_T1413;
    gusa_HercADSL_MONIMap_Curr[0] = MONI_T1413;
    gt_HercADSL_STATMap_MacroState.s_Offset0 = STAT_T1413;

   switch(gs_RxSubState)   {

   case RX_DETECT_REVEILLE:
#ifndef ISDN

      if ( DetectTone(gsa_RxToneBuf, C_REVEILLE_TONE, (C_REVEILLE_TONE - HALF_DETECT_BAND),
         (C_REVEILLE_TONE + HALF_DETECT_BAND), (int16)(gs_T1413ToneDetectScale << 8)) )
#else
      if ( DetectTone(gsa_RxToneBuf, C_REVEILLE_TONE, C_REVEILLE_TONE - HALF_DETECT_BAND,
         C_REVEILLE_TONE + HALF_DETECT_BAND, (int16)(gs_T1413ToneDetectScale << 8)) )
#endif
      {
         gs_RxSubStateCnt++;
         //XDSLRTFW-254 XDSLRTFW-221 Feature_ALL_T1413_ALL_Bringup   (START)
            gl_t1413_crevelle_tone_power =
              VectorPower(gsa_RxToneBuf, C_REVEILLE_TONE << 1, 2,
                             LOG2_T1413_ROUGH_LOOP_ESTIMATE_LEN);
         //XDSLRTFW-254 XDSLRTFW-221 Feature_ALL_T1413_ALL_Bringup   (END)

      }
      else {
         gs_RxSubStateCnt = 0;
         //XDSLRTFW-254 XDSLRTFW-221 Feature_ALL_T1413_ALL_Bringup   (START)
         gl_t1413_crevelle_tone_power = 0;
         //XDSLRTFW-254 XDSLRTFW-221 Feature_ALL_T1413_ALL_Bringup   (END)
      }

      if (gs_RxSubStateCnt == RX_REVEILLE_DET_CNT - 1) {
         gs_t1413_PGA_set = gs_PGA_set; //Debug
         gs_t1413_tdq_exp = gs_pre_tdq_h_exp;   //Debug
         //XDSLRTFW-254 XDSLRTFW-221 Feature_ALL_T1413_ALL_Bringup  (START)
         gs_t1413_crevelle_tone_power_dB =
         ConvertToDB((int32) (gl_t1413_crevelle_tone_power)) -
            gs_PGA_set + (gs_pre_tdq_h_exp - 14) * 0x600;
         //XDSLRTFW-3727 T1413_perf_improvement_Ctune_Adapt   (start)
         //1.5dB more difference observed after 11000ft onwards(seen with NDLT-G), so do compensation for the same.
         // To use same CTune and LL API changes
         if (gs_t1413_crevelle_tone_power_dB < 13750)
         {
            gs_t1413_crevelle_tone_power_dB += (gs_hsk_power_dB_Comp - 384);
         }
         else
            gs_t1413_crevelle_tone_power_dB += gs_hsk_power_dB_Comp;
         //XDSLRTFW-3727 T1413_perf_improvement_Ctune_Adapt   (end)
         gs_hsk_tone_power_dB = gs_t1413_crevelle_tone_power_dB;

         //XDSLRTFW-254 XDSLRTFW-221 Feature_ALL_T1413_ALL_Bringup   (END)
         gs_RxSubStateCnt = 0;
         gs_RxSubState = RX_WAIT;
      }
      break;

   case RX_WAIT:
      /* Wait until the high-power portion of C-REVEILLE has finished before looking for the pilot
         tone, otherwise there are frequent C-PILOT1 false detections. */
      if(gs_RxSubStateCnt++ == 64) {
#ifdef ISDN
            gs_CPilotTone = gs_PilotToneIdx = C_PILOT_TONE_96;
            /* Set first/last channel variables to generic (compliant) Annex B values. */
            gft_Tones1To32Support= gft_Tones1To32SupportCO & gft_Tones1To32SupportRT;

#endif
         gs_RxSubState = RX_DETECT_PILOT;
         gs_RxSubStateCnt = 0;
      }
      break;

   case RX_DETECT_PILOT:


      if ( DetectTone(gsa_RxToneBuf, gs_CPilotTone, (int16)(gs_CPilotTone-4),
                     (int16)(gs_CPilotTone+4), DETECT_SCALE << 8) )
         gs_RxSubStateCnt++;
      else
         gs_RxSubStateCnt = 0;

      /* If R_C_PILOT1_1A_CNT number of consecutive C-PILOT1 OR C-PILOT1A tones are */
      /* detected and XCVR0 page is swapped in, transit to R_C_PILOT1 state */
      if (gs_RxSubStateCnt >= R_C_PILOT1_1A_CNT)   // declare tone valid
      {
         // NOTE: Do this in the foreground. Don't want this to be interrupted
         // by the Rx time critical.
#ifndef ISDN
         STATArray[STAT_Mode] |= STAT_ConfigMode_T1413;
         gul_ModeControl &= STAT_ConfigMode_T1413; // fixes bug of using adsl2 hdsl-deframer.
         gl_SelectedMode = MODE_G992_1 | ANNEX_A;
#else
            STATArray[STAT_Mode1] |= STAT_ConfigMode_ETSI_AnnexC;
            gl_SelectedMode = MODE_G992_1 | ANNEX_B;
#endif


         gus_TxGain_NoCutBack = (int16)(((int32)gus_TxGain_NoCutBack * PLUS_HALF_DB) >> 14);
         gus_TxSineGain = gus_TxGain_NoCutBack;
         AddFunctionToFifo(gp_TxLoadingFunctionFifo,LoadTxSineGain);
         // This is for the programmable user rate cap
         gt_HandshakeBis.sa_DS_MaxNetDataRateBC[0] = gpt_TxInfo->pta_G9923xInfo[0]->ta_DSBearerChannel[0].ta_TpsTcType[1].s_MaxNetDataRate;
         gft_ModemType = G_DMT;

         SetLinkModeDependentVariables();

         //Initiate sending autonomous message requesting for TC driver to be loaded
         //For T1413: Required TC driver mode is initialized to 'ATM' in the statein1.c
         Set_AutoMsg_FW_PPE_TcMode();  /* XDSLRTFW-3068 */

         guc_HandshakeDone = FALSE;
         AddFunctionToBkgdFifo((PtrToBkgdFunc)BGInitModem_PostHandshake);

#ifdef BIS_CODESWAP
         /* We are commited to T1.413 startup - trigger R_NOGHS codeswap
         (XCVR0 will automatically kick-in after R_NOGHS completion) */
         if (gs_CodeSwapSection == CSPAGE_BIS_R_NOGHS) {
            gs_CodeSwapStatus = CODESWAP_START;
            gsa_CodeSwapNextSection[CSPAGE_BIS_R_NOGHS] = CSPAGE_BIS_XCVR0;


         }
#endif
         gs_RxSubState = RX_WAIT_FOR_SWAPS;
      } // if (gs_RxSubStateCnt == R_C_PILOT1_1A_CNT)

      break;

   case RX_WAIT_FOR_SWAPS:

#ifdef BIS_CODESWAP
      if ((gs_CodeSwapStatus == CODESWAP_IDLE) && (gs_CodeSwapSection == CSPAGE_BIS_XCVR0))
         gs_CodeSwapStatus = CODESWAP_START;

      if ((gs_CodeSwapSection == CSPAGE_BULK_O1) && (guc_HandshakeDone == TRUE))
      {
         //when we start code-swap here, we will start CSPAGE_BULK_O1,
            //because both two possible "current-page" (CSPAGE_BIS_XCVR0) have their "next" to be CSPAGE_BULK_O1.
         gsa_CodeSwapNextSection[CSPAGE_BULK_O1] = CSPAGE_BIS_DMT_RAM;
         gs_CodeSwapStatus = CODESWAP_START;
         gs_RxSubState = RX_WAIT_FOR_SWAPS_1;
      }
#else
      if (guc_HandshakeDone == TRUE)
         gs_RxSubState = RX_WAIT_FOR_SWAPS_1;
#endif
      break;

   case RX_WAIT_FOR_SWAPS_1:

#ifdef BIS_CODESWAP
      if (gs_CodeSwapSection == CSPAGE_BIS_DMT_RAM)
         // this means XCVR0 is already in
#endif
      {
         /* The following is required to restore PGA after QLN measurement. */
         gs_PGA_required_In_GHS = gs_PGA_required;
         gs_RxSubStateCnt = 0;
         gpF_RxStateFunc = (PtrToFunc) RCPilot1InitRxF;

      }
      break ;
   }
}

#undef RX_DETECT_REVEILLE
#undef RX_WAIT
#undef RX_DETECT_PILOT
#undef RX_WAIT_FOR_SWAPS
#undef RX_WAIT_FOR_SWAPS_1
